/*****************************************************************************/
/* @file:    string.h                                                        */
/* @version: V1.01                                                           */
/* @purpose: Definitions for memory and string functions.                    */
/*                                                                           */
/*****************************************************************************/

#ifndef _STRING_H
#define	_STRING_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef	unsigned int size_t;
#endif

#ifndef	NULL
#define	NULL	0
#endif

extern int		ffs (int);
extern int		ffsl (long);
extern int		ffsll (long long);
extern void *	memchr(const void *, int, size_t);
extern int		memcmp(const void *, const void *, size_t);
extern void *	memcpy(void *, const void *, size_t);
extern void *	memmove(void *, const void *, size_t);
extern void *	memset(void *, int, size_t);
extern int		strcasecmp (const char *, const char *);
extern char *	strcat(char *, const char *);
extern char *	strchr(const char *, int);
extern int		strcmp(const char *, const char *);
extern int		strcoll(const char *, const char *);
extern char *	strcpy(char *, const char *);
extern size_t	strcspn(const char *, const char *);
/* extern char *	strerror(int); *//* can not be supported */
extern size_t	strlen(const char *);
extern int		strncasecmp (const char *, const char *, size_t);
extern char *	strncat(char *, const char *, size_t);
extern int		strncmp(const char *, const char *, size_t);
extern char *	strncpy(char *, const char *, size_t);
extern char *	strpbrk(const char *, const char *);
extern char *	strrchr(const char *, int);
extern size_t	strspn(const char *, const char *);
extern char *	strstr(const char *, const char *);
extern char *	strtok(char *, const char *);
extern size_t	strxfrm(char *, const char *, size_t);

//##################################################################
extern char *	strdup(const char *);

#ifdef __cplusplus
}
#endif
#endif	/* _STRING_H */