/*****************************************************************************/
/* @file:    limits.h                                                        */
/* @version: V1.01                                                           */
/* @purpose: Contains defines for a number of implementation dependent       */
/*           values which are commonly used in C programs.                   */
/*                                                                           */
/*****************************************************************************/

#ifndef _LIMITS_H
#define _LIMITS_H

#ifdef __cplusplus
extern "C" {
#endif

#define MB_LEN_MAX               1       /* MAX # BYTES IN MULTI-BYTE        */

#define CHAR_BIT                 8       /* NUMBER OF BITS IN TYPE CHAR      */
#define SCHAR_MIN             -128       /* MIN VALUE FOR SIGNED CHAR        */
#define SCHAR_MAX              127       /* MAX VALUE FOR SIGNED CHAR        */
#define UCHAR_MAX              255U      /* MAX VALUE FOR UNSIGNED CHAR      */
 /* Minimum and maximum values a `char' can hold.  */
#ifdef __CHAR_UNSIGNED__
# undef CHAR_MIN
# define CHAR_MIN 0
# undef CHAR_MAX
# define CHAR_MAX UCHAR_MAX
#else
# undef CHAR_MIN
# define CHAR_MIN SCHAR_MIN
# undef CHAR_MAX
# define CHAR_MAX SCHAR_MAX
#endif

#define SHRT_MIN            -32768       /* MIN VALUE FOR SHORT              */
#define SHRT_MAX             32767       /* MAX VALUE FOR SHORT              */
#define USHRT_MAX            65535U      /* MAX VALUE FOR UNSIGNED SHORT     */




#define INT_MAX         2147483647       /* MAX VALUE FOR INT                */
#define INT_MIN         (-INT_MAX-1)     /* MIN VALUE FOR INT                */
#define UINT_MAX        4294967295U      /* MAX VALUE FOR UNSIGNED INT       */


#define LONG_MAX        INT_MAX          /* MAX VALUE FOR LONG               */
#define LONG_MIN        INT_MIN          /* MIN VALUE FOR LONG               */
#define ULONG_MAX       UINT_MAX         /* MAX VALUE FOR UNSIGNED LONG      */

#define LLONG_MAX    9223372036854775807ll /* MAX VALUE FOR LONG LONG          */

#define LLONG_MIN         (-LLONG_MAX-1) /* MIN VALUE FOR LONG LONG          */
#define ULLONG_MAX  18446744073709551615ull /* MAX VALUE FOR UNSIGNED LONG LONG */

#ifdef __cplusplus
}
#endif
#endif /* _LIMITS_H */
