/************************************************************
*       Header file for the KungFu32  C
*       *       Microcontroller
*
*       Copyright 2012-2024 ChipON, All rights reserved
*************************************************************/

#ifndef  _KF32R3ALLOVER_H_
#define  _KF32R3ALLOVER_H_

struct all_bit{
		unsigned int _b0:1;
		unsigned int _b1:1;
		unsigned int _b2:1;
		unsigned int _b3:1;
		unsigned int _b4:1;
		unsigned int _b5:1;
		unsigned int _b6:1;
		unsigned int _b7:1;
		unsigned int _b8:1;
		unsigned int _b9:1;
		unsigned int _b10:1;
		unsigned int _b11:1;
		unsigned int _b12:1;
		unsigned int _b13:1;
		unsigned int _b14:1;
		unsigned int _b15:1;
		unsigned int _b16:1;
		unsigned int _b17:1;
		unsigned int _b18:1;
		unsigned int _b19:1;
		unsigned int _b20:1;
		unsigned int _b21:1;
		unsigned int _b22:1;
		unsigned int _b23:1;
		unsigned int _b24:1;
		unsigned int _b25:1;
		unsigned int _b26:1;
		unsigned int _b27:1;
		unsigned int _b28:1;
		unsigned int _b29:1;
		unsigned int _b30:1;
		unsigned int _b31:1;
};
// modelGPIOA

/** 0x5000 0000 GPIOA_PIR **/
union GPIOA_PIR_REG{
	unsigned int reg;
	struct GPIOA_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PIR (*((volatile union GPIOA_PIR_REG *)0x50000000))
// model

/** 0x5000 0004 GPIOA_POR **/
union GPIOA_POR_REG{
	unsigned int reg;
	struct GPIOA_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_POR (*((volatile union GPIOA_POR_REG *)0x50000004))
// model

/** 0x5000 0008 GPIOA_PUR **/
union GPIOA_PUR_REG{
	unsigned int reg;
	struct GPIOA_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PUR (*((volatile union GPIOA_PUR_REG *)0x50000008))
// model

/** 0x5000 000C GPIOA_PDR **/
union GPIOA_PDR_REG{
	unsigned int reg;
	struct GPIOA_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PDR (*((volatile union GPIOA_PDR_REG *)0x5000000C))
// model

/** 0x5000 0010 GPIOA_PODR **/
union GPIOA_PODR_REG{
	unsigned int reg;
	struct GPIOA_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PODR (*((volatile union GPIOA_PODR_REG *)0x50000010))
// model

/** 0x5000 0014 GPIOA_PMOD **/
union GPIOA_PMOD_REG{
	unsigned int reg;
	struct GPIOA_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PMOD (*((volatile union GPIOA_PMOD_REG *)0x50000014))
// model

/** 0x5000 0018 GPIOA_OMOD **/
union GPIOA_OMOD_REG{
	unsigned int reg;
	struct GPIOA_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_OMOD (*((volatile union GPIOA_OMOD_REG *)0x50000018))
// model

/** 0x5000 001C GPIOA_LOCK **/
union GPIOA_LOCK_REG{
	unsigned int reg;
	struct GPIOA_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_LOCK (*((volatile union GPIOA_LOCK_REG *)0x5000001C))
// model

/** 0x5000 0020 GPIOA_RMPL **/
union GPIOA_RMPL_REG{
	unsigned int reg;
	struct GPIOA_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPL (*((volatile union GPIOA_RMPL_REG *)0x50000020))
// model

/** 0x5000 0024 GPIOA_RMPH **/
union GPIOA_RMPH_REG{
	unsigned int reg;
	struct GPIOA_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPH (*((volatile union GPIOA_RMPH_REG *)0x50000024))
// model

/** 0x5000 0038 GPIOA_SDE **/
union GPIOA_SDE_REG{
	unsigned int reg;
	struct GPIOA_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_SDE (*((volatile union GPIOA_SDE_REG *)0x50000038))
// model

/** 0x5000 003C GPIOA_SDCTL **/
union GPIOA_SDCTL_REG{
	unsigned int reg;
	struct GPIOA_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_SDCTL (*((volatile union GPIOA_SDCTL_REG *)0x5000003C))
// modelGPIOB

/** 0x5000 0040 GPIOB_PIR **/
union GPIOB_PIR_REG{
	unsigned int reg;
	struct GPIOB_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PIR (*((volatile union GPIOB_PIR_REG *)0x50000040))
// model

/** 0x5000 0044 GPIOB_POR **/
union GPIOB_POR_REG{
	unsigned int reg;
	struct GPIOB_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_POR (*((volatile union GPIOB_POR_REG *)0x50000044))
// model

/** 0x5000 0048 GPIOB_PUR **/
union GPIOB_PUR_REG{
	unsigned int reg;
	struct GPIOB_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PUR (*((volatile union GPIOB_PUR_REG *)0x50000048))
// model

/** 0x5000 004C GPIOB_PDR **/
union GPIOB_PDR_REG{
	unsigned int reg;
	struct GPIOB_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PDR (*((volatile union GPIOB_PDR_REG *)0x5000004C))
// model

/** 0x5000 0050 GPIOB_PODR **/
union GPIOB_PODR_REG{
	unsigned int reg;
	struct GPIOB_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PODR (*((volatile union GPIOB_PODR_REG *)0x50000050))
// model

/** 0x5000 0054 GPIOB_PMOD **/
union GPIOB_PMOD_REG{
	unsigned int reg;
	struct GPIOB_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PMOD (*((volatile union GPIOB_PMOD_REG *)0x50000054))
// model

/** 0x5000 0058 GPIOB_OMOD **/
union GPIOB_OMOD_REG{
	unsigned int reg;
	struct GPIOB_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_OMOD (*((volatile union GPIOB_OMOD_REG *)0x50000058))
// model

/** 0x5000 005C GPIOB_LOCK **/
union GPIOB_LOCK_REG{
	unsigned int reg;
	struct GPIOB_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_LOCK (*((volatile union GPIOB_LOCK_REG *)0x5000005C))
// model

/** 0x5000 0060 GPIOB_RMPL **/
union GPIOB_RMPL_REG{
	unsigned int reg;
	struct GPIOB_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPL (*((volatile union GPIOB_RMPL_REG *)0x50000060))
// model

/** 0x5000 0064 GPIOB_RMPH **/
union GPIOB_RMPH_REG{
	unsigned int reg;
	struct GPIOB_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPH (*((volatile union GPIOB_RMPH_REG *)0x50000064))
// model

/** 0x5000 0078 GPIOB_SDE **/
union GPIOB_SDE_REG{
	unsigned int reg;
	struct GPIOB_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_SDE (*((volatile union GPIOB_SDE_REG *)0x50000078))
// model

/** 0x5000 007C GPIOB_SDCTL **/
union GPIOB_SDCTL_REG{
	unsigned int reg;
	struct GPIOB_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_SDCTL (*((volatile union GPIOB_SDCTL_REG *)0x5000007C))
// modelGPIOC

/** 0x5000 0080 GPIOC_PIR **/
union GPIOC_PIR_REG{
	unsigned int reg;
	struct GPIOC_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PIR (*((volatile union GPIOC_PIR_REG *)0x50000080))
// model

/** 0x5000 0084 GPIOC_POR **/
union GPIOC_POR_REG{
	unsigned int reg;
	struct GPIOC_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_POR (*((volatile union GPIOC_POR_REG *)0x50000084))
// model

/** 0x5000 0088 GPIOC_PUR **/
union GPIOC_PUR_REG{
	unsigned int reg;
	struct GPIOC_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PUR (*((volatile union GPIOC_PUR_REG *)0x50000088))
// model

/** 0x5000 008C GPIOC_PDR **/
union GPIOC_PDR_REG{
	unsigned int reg;
	struct GPIOC_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PDR (*((volatile union GPIOC_PDR_REG *)0x5000008C))
// model

/** 0x5000 0090 GPIOC_PODR **/
union GPIOC_PODR_REG{
	unsigned int reg;
	struct GPIOC_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PODR (*((volatile union GPIOC_PODR_REG *)0x50000090))
// model

/** 0x5000 0094 GPIOC_PMOD **/
union GPIOC_PMOD_REG{
	unsigned int reg;
	struct GPIOC_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PMOD (*((volatile union GPIOC_PMOD_REG *)0x50000094))
// model

/** 0x5000 0098 GPIOC_OMOD **/
union GPIOC_OMOD_REG{
	unsigned int reg;
	struct GPIOC_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_OMOD (*((volatile union GPIOC_OMOD_REG *)0x50000098))
// model

/** 0x5000 009C GPIOC_LOCK **/
union GPIOC_LOCK_REG{
	unsigned int reg;
	struct GPIOC_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_LOCK (*((volatile union GPIOC_LOCK_REG *)0x5000009C))
// model

/** 0x5000 00A0 GPIOC_RMPL **/
union GPIOC_RMPL_REG{
	unsigned int reg;
	struct GPIOC_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPL (*((volatile union GPIOC_RMPL_REG *)0x500000A0))
// model

/** 0x5000 00A4 GPIOC_RMPH **/
union GPIOC_RMPH_REG{
	unsigned int reg;
	struct GPIOC_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPH (*((volatile union GPIOC_RMPH_REG *)0x500000A4))
// model

/** 0x5000 00B8 GPIOC_SDE **/
union GPIOC_SDE_REG{
	unsigned int reg;
	struct GPIOC_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_SDE (*((volatile union GPIOC_SDE_REG *)0x500000B8))
// model

/** 0x5000 00BC GPIOC_SDCTL **/
union GPIOC_SDCTL_REG{
	unsigned int reg;
	struct GPIOC_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_SDCTL (*((volatile union GPIOC_SDCTL_REG *)0x500000BC))
// modelGPIOD

/** 0x5000 00C0 GPIOD_PIR **/
union GPIOD_PIR_REG{
	unsigned int reg;
	struct GPIOD_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PIR (*((volatile union GPIOD_PIR_REG *)0x500000C0))
// model

/** 0x5000 00C4 GPIOD_POR **/
union GPIOD_POR_REG{
	unsigned int reg;
	struct GPIOD_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_POR (*((volatile union GPIOD_POR_REG *)0x500000C4))
// model

/** 0x5000 00C8 GPIOD_PUR **/
union GPIOD_PUR_REG{
	unsigned int reg;
	struct GPIOD_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PUR (*((volatile union GPIOD_PUR_REG *)0x500000C8))
// model

/** 0x5000 00CC GPIOD_PDR **/
union GPIOD_PDR_REG{
	unsigned int reg;
	struct GPIOD_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PDR (*((volatile union GPIOD_PDR_REG *)0x500000CC))
// model

/** 0x5000 00D0 GPIOD_PODR **/
union GPIOD_PODR_REG{
	unsigned int reg;
	struct GPIOD_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PODR (*((volatile union GPIOD_PODR_REG *)0x500000D0))
// model

/** 0x5000 00D4 GPIOD_PMOD **/
union GPIOD_PMOD_REG{
	unsigned int reg;
	struct GPIOD_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PMOD (*((volatile union GPIOD_PMOD_REG *)0x500000D4))
// model

/** 0x5000 00D8 GPIOD_OMOD **/
union GPIOD_OMOD_REG{
	unsigned int reg;
	struct GPIOD_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_OMOD (*((volatile union GPIOD_OMOD_REG *)0x500000D8))
// model

/** 0x5000 00DC GPIOD_LOCK **/
union GPIOD_LOCK_REG{
	unsigned int reg;
	struct GPIOD_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_LOCK (*((volatile union GPIOD_LOCK_REG *)0x500000DC))
// model

/** 0x5000 00E0 GPIOD_RMPL **/
union GPIOD_RMPL_REG{
	unsigned int reg;
	struct GPIOD_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPL (*((volatile union GPIOD_RMPL_REG *)0x500000E0))
// model

/** 0x5000 00E4 GPIOD_RMPH **/
union GPIOD_RMPH_REG{
	unsigned int reg;
	struct GPIOD_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPH (*((volatile union GPIOD_RMPH_REG *)0x500000E4))
// model

/** 0x5000 00F8 GPIOD_SDE **/
union GPIOD_SDE_REG{
	unsigned int reg;
	struct GPIOD_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_SDE (*((volatile union GPIOD_SDE_REG *)0x500000F8))
// model

/** 0x5000 00FC GPIOD_SDCTL **/
union GPIOD_SDCTL_REG{
	unsigned int reg;
	struct GPIOD_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_SDCTL (*((volatile union GPIOD_SDCTL_REG *)0x500000FC))
// modelGPIOA

/** 0x5000 1000 GPIOA_INTMS **/
union GPIOA_INTMS_REG{
	unsigned int reg;
	struct GPIOA_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTMS (*((volatile union GPIOA_INTMS_REG *)0x50001000))
// model

/** 0x5000 1004 GPIOA_INTRISE **/
union GPIOA_INTRISE_REG{
	unsigned int reg;
	struct GPIOA_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTRISE (*((volatile union GPIOA_INTRISE_REG *)0x50001004))
// model

/** 0x5000 1008 GPIOA_INTFALL **/
union GPIOA_INTFALL_REG{
	unsigned int reg;
	struct GPIOA_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTFALL (*((volatile union GPIOA_INTFALL_REG *)0x50001008))
// model

/** 0x5000 100C GPIOA_INTIE **/
union GPIOA_INTIE_REG{
	unsigned int reg;
	struct GPIOA_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTIE (*((volatile union GPIOA_INTIE_REG *)0x5000100C))
// model

/** 0x5000 1010 GPIOA_INTIF **/
union GPIOA_INTIF_REG{
	unsigned int reg;
	struct GPIOA_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTIF (*((volatile union GPIOA_INTIF_REG *)0x50001010))
// modelGPIOB

/** 0x5000 1040 GPIOB_INTMS **/
union GPIOB_INTMS_REG{
	unsigned int reg;
	struct GPIOB_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTMS (*((volatile union GPIOB_INTMS_REG *)0x50001040))
// model

/** 0x5000 1044 GPIOB_INTRISE **/
union GPIOB_INTRISE_REG{
	unsigned int reg;
	struct GPIOB_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTRISE (*((volatile union GPIOB_INTRISE_REG *)0x50001044))
// model

/** 0x5000 1048 GPIOB_INTFALL **/
union GPIOB_INTFALL_REG{
	unsigned int reg;
	struct GPIOB_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTFALL (*((volatile union GPIOB_INTFALL_REG *)0x50001048))
// model

/** 0x5000 104C GPIOB_INTIE **/
union GPIOB_INTIE_REG{
	unsigned int reg;
	struct GPIOB_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTIE (*((volatile union GPIOB_INTIE_REG *)0x5000104C))
// model

/** 0x5000 1050 GPIOB_INTIF **/
union GPIOB_INTIF_REG{
	unsigned int reg;
	struct GPIOB_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTIF (*((volatile union GPIOB_INTIF_REG *)0x50001050))
// modelIONMI

/** 0x5000 107C IONMI_CTLR **/
union IONMI_CTLR_REG{
	unsigned int reg;
	struct IONMI_CTLR_BITS{
		unsigned int _IONMIEN:1;
		unsigned int _FLTWR:3;
		unsigned int _FCKDIV:3;
		unsigned int :1;
		unsigned int _IRQMS:3;
		unsigned int _FLTEN:1;
		unsigned int _FLTCKS:1;
		unsigned int _IONMIIC:1;
		unsigned int _IONMIIF:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IONMI_CTLR (*((volatile union IONMI_CTLR_REG *)0x5000107C))
// modelGPIOC

/** 0x5000 1080 GPIOC_INTMS **/
union GPIOC_INTMS_REG{
	unsigned int reg;
	struct GPIOC_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTMS (*((volatile union GPIOC_INTMS_REG *)0x50001080))
// model

/** 0x5000 1084 GPIOC_INTRISE **/
union GPIOC_INTRISE_REG{
	unsigned int reg;
	struct GPIOC_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTRISE (*((volatile union GPIOC_INTRISE_REG *)0x50001084))
// model

/** 0x5000 1088 GPIOC_INTFALL **/
union GPIOC_INTFALL_REG{
	unsigned int reg;
	struct GPIOC_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTFALL (*((volatile union GPIOC_INTFALL_REG *)0x50001088))
// model

/** 0x5000 108C GPIOC_INTIE **/
union GPIOC_INTIE_REG{
	unsigned int reg;
	struct GPIOC_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTIE (*((volatile union GPIOC_INTIE_REG *)0x5000108C))
// model

/** 0x5000 1090 GPIOC_INTIF **/
union GPIOC_INTIF_REG{
	unsigned int reg;
	struct GPIOC_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTIF (*((volatile union GPIOC_INTIF_REG *)0x50001090))
// modelGPIOD

/** 0x5000 10C0 GPIOD_INTMS **/
union GPIOD_INTMS_REG{
	unsigned int reg;
	struct GPIOD_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTMS (*((volatile union GPIOD_INTMS_REG *)0x500010C0))
// model

/** 0x5000 10C4 GPIOD_INTRISE **/
union GPIOD_INTRISE_REG{
	unsigned int reg;
	struct GPIOD_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTRISE (*((volatile union GPIOD_INTRISE_REG *)0x500010C4))
// model

/** 0x5000 10C8 GPIOD_INTFALL **/
union GPIOD_INTFALL_REG{
	unsigned int reg;
	struct GPIOD_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTFALL (*((volatile union GPIOD_INTFALL_REG *)0x500010C8))
// model

/** 0x5000 10CC GPIOD_INTIE **/
union GPIOD_INTIE_REG{
	unsigned int reg;
	struct GPIOD_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTIE (*((volatile union GPIOD_INTIE_REG *)0x500010CC))
// model

/** 0x5000 10D0 GPIOD_INTIF **/
union GPIOD_INTIF_REG{
	unsigned int reg;
	struct GPIOD_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTIF (*((volatile union GPIOD_INTIF_REG *)0x500010D0))
// modelOSC

/** 0x4000 1000 OSC_CTL0 **/
union OSC_CTL0_REG{
	unsigned int reg;
	struct OSC_CTL0_BITS{
		unsigned int _PMWREN:1;
		unsigned int _SCKS:3;
		unsigned int _LFCKEN:1;
		unsigned int :1;
		unsigned int _LFCKS:2;
		unsigned int _HFCKEN:1;
		unsigned int _HFCKS:3;
		unsigned int _PLLCKS0:1;
		unsigned int _PLLCKS1:1;
		unsigned int :2;
		unsigned int _SCKDIV:3;
		unsigned int :1;
		unsigned int _HFCKDIV:4;
		unsigned int _LFCKDIV:3;
		unsigned int :1;
		unsigned int _PLL0DIV:1;
		unsigned int _LKDTEN:1;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL0 (*((volatile union OSC_CTL0_REG *)0x40001000))
// model

/** 0x4000 1004 OSC_CTL1 **/
union OSC_CTL1_REG{
	unsigned int reg;
	struct OSC_CTL1_BITS{
		unsigned int :4;
		unsigned int _TESTEN_STOP:1;
		unsigned int _HSEHYEN:1;
		unsigned int :8;
		unsigned int _SCLKPMCDIV:2;
		unsigned int _FSCM:1;
		unsigned int _FSCMGAP:3;
		unsigned int :1;
		unsigned int _FSCMS:3;
		unsigned int _CLKOUTS:4;
		unsigned int _CLKOE:1;
		unsigned int _CLKOUTDIV:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL1 (*((volatile union OSC_CTL1_REG *)0x40001004))
// model

/** 0x4000 1008 OSC_INT **/
union OSC_INT_REG{
	unsigned int reg;
	struct OSC_INT_BITS{
		unsigned int _ILFIF:1;
		unsigned int _IHFIF:1;
		unsigned int :1;
		unsigned int _EHFIF:1;
		unsigned int _PLL0IF:1;
		unsigned int _HSIVAFIF:1;
		unsigned int :1;
		unsigned int _CKFIF:1;
		unsigned int _ILFIE:1;
		unsigned int _IHFIE:1;
		unsigned int :1;
		unsigned int _EHFIE:1;
		unsigned int _PLL0IE:1;
		unsigned int _HSIVAFIE:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_INT (*((volatile union OSC_INT_REG *)0x40001008))
// model

/** 0x4000 100C OSC_CTL2 **/
union OSC_CTL2_REG{
	unsigned int reg;
	struct OSC_CTL2_BITS{
		unsigned int _INTLFSWEN:1;
		unsigned int _INTHFSWEN:1;
		unsigned int :1;
		unsigned int _EXTHFSWEN:1;
		unsigned int _PLL0SWEN:1;
		unsigned int _HSIVAFSWEN:1;
		unsigned int :2;
		unsigned int _ILFDLY:4;
		unsigned int _IHFDLY:4;
		unsigned int :4;
		unsigned int _EHFDLY:4;
		unsigned int _PLL0DLY:4;
		unsigned int _HSIVAFDLY:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL2 (*((volatile union OSC_CTL2_REG *)0x4000100C))
// model

/** 0x4000 1018 OSC_CTL3 **/
union OSC_CTL3_REG{
	unsigned int reg;
	struct OSC_CTL3_BITS{
		unsigned int _HSXTALEXEN:1;
		unsigned int :1;
		unsigned int _GMBOOST:4;
		unsigned int :3;
		unsigned int _XTHR1M:1;
		unsigned int _XTHR470K:1;
		unsigned int _XTHR200K:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL3 (*((volatile union OSC_CTL3_REG *)0x40001018))
// model

/** 0x4000 1020 OSC_HF2CTL **/
union OSC_HF2CTL_REG{
	unsigned int reg;
	struct OSC_HF2CTL_BITS{
		unsigned int _PMCTL_WEN:1;
		unsigned int _PMCAL_WEN:1;
		unsigned int _IWDTCTL_WEN:1;
		unsigned int _WWDTCTL_WEN:1;
		unsigned int _EWDTCTL_WEN:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HF2CTL (*((volatile union OSC_HF2CTL_REG *)0x40001020))
// model

/** 0x4000 1024 OSC_HF2OSCCAL **/
union OSC_HF2OSCCAL_REG{
	unsigned int reg;
	struct OSC_HF2OSCCAL_BITS{
		unsigned int :32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HF2OSCCAL (*((volatile union OSC_HF2OSCCAL_REG *)0x40001024))
// model

/** 0x4000 1030 OSC_HF3CTL **/
union OSC_HF3CTL_REG{
	unsigned int reg;
	struct OSC_HF3CTL_BITS{
		unsigned int :6;
		unsigned int _VCOREOEN:1;
		unsigned int _FLASHPOWOEN:1;
		unsigned int _LPPHERIOEN:1;
		unsigned int :1;
		unsigned int _RAMBPOWOEN:1;
		unsigned int :1;
		unsigned int _FVRCAPLESSMONEN:1;
		unsigned int _FVRCAPLESSOEN:1;
		unsigned int :2;
		unsigned int _VREF1VOEN:1;
		unsigned int :10;
		unsigned int _OSCSEL:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HF3CTL (*((volatile union OSC_HF3CTL_REG *)0x40001030))
// model

/** 0x4000 1034 OSC_HF3OSCCAL **/
union OSC_HF3OSCCAL_REG{
	unsigned int reg;
	struct OSC_HF3OSCCAL_BITS{
		unsigned int _EN_CKTC:1;
		unsigned int _LDO_HPMODE:1;
		unsigned int _CKCAL:11;
		unsigned int _CKTC:6;
		unsigned int _COMP_BIAS:2;
		unsigned int _EN_VAFOSC:1;
		unsigned int _LDO_1P2OR1P3:1;
		unsigned int _FREQPLUS:1;
		unsigned int _TST_SEL:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HF3OSCCAL (*((volatile union OSC_HF3OSCCAL_REG *)0x40001034))
// modelPLL0

/** 0x4000 1200 PLL0_CTL **/
union PLL0_CTL_REG{
	unsigned int reg;
	struct PLL0_CTL_BITS{
		unsigned int _PDRST:1;
		unsigned int :1;
		unsigned int _M:14;
		unsigned int _N:4;
		unsigned int _OD:2;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PLL0_CTL (*((volatile union PLL0_CTL_REG *)0x40001200))
// modelMPU

/** 0x4000 1600 MPU_CTLESR **/
union MPU_CTLESR_REG{
	unsigned int reg;
	struct MPU_CTLESR_BITS{
		unsigned int _MPUEN:1;
		unsigned int :19;
		unsigned int _SPERIF0:1;
		unsigned int _SPERIF1:1;
		unsigned int _SPERIF2:1;
		unsigned int _SPERIF3:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_CTLESR (*((volatile union MPU_CTLESR_REG *)0x40001600))
// model

/** 0x4000 1604 MPU_IER **/
union MPU_IER_REG{
	unsigned int reg;
	struct MPU_IER_BITS{
		unsigned int :16;
		unsigned int _SPERIC0:1;
		unsigned int _SPERIC1:1;
		unsigned int _SPERIC2:1;
		unsigned int _SPERIC3:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_IER (*((volatile union MPU_IER_REG *)0x40001604))
// model

/** 0x4000 1A08 MPU_IDR **/
union MPU_IDR_REG{
	unsigned int reg;
	struct MPU_IDR_BITS{
		unsigned int _CPID:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_IDR (*((volatile union MPU_IDR_REG *)0x40001A08))
// model

/** 0x4000 1610 MPU_ERRARS0 **/
union MPU_ERRARS0_REG{
	unsigned int reg;
	struct MPU_ERRARS0_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS0 (*((volatile union MPU_ERRARS0_REG *)0x40001610))
// model

/** 0x4000 1614 MPU_ERRDRS0 **/
union MPU_ERRDRS0_REG{
	unsigned int reg;
	struct MPU_ERRDRS0_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS0 (*((volatile union MPU_ERRDRS0_REG *)0x40001614))
// model

/** 0x4000 1618 MPU_ERRARS1 **/
union MPU_ERRARS1_REG{
	unsigned int reg;
	struct MPU_ERRARS1_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS1 (*((volatile union MPU_ERRARS1_REG *)0x40001618))
// model

/** 0x4000 161C MPU_ERRDRS1 **/
union MPU_ERRDRS1_REG{
	unsigned int reg;
	struct MPU_ERRDRS1_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS1 (*((volatile union MPU_ERRDRS1_REG *)0x4000161C))
// model

/** 0x4000 1620 MPU_ERRARS2 **/
union MPU_ERRARS2_REG{
	unsigned int reg;
	struct MPU_ERRARS2_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS2 (*((volatile union MPU_ERRARS2_REG *)0x40001620))
// model

/** 0x4000 1624 MPU_ERRDRS2 **/
union MPU_ERRDRS2_REG{
	unsigned int reg;
	struct MPU_ERRDRS2_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS2 (*((volatile union MPU_ERRDRS2_REG *)0x40001624))
// model

/** 0x4000 1628 MPU_ERRARS3 **/
union MPU_ERRARS3_REG{
	unsigned int reg;
	struct MPU_ERRARS3_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS3 (*((volatile union MPU_ERRARS3_REG *)0x40001628))
// model

/** 0x4000 162C MPU_ERRDRS3 **/
union MPU_ERRDRS3_REG{
	unsigned int reg;
	struct MPU_ERRDRS3_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS3 (*((volatile union MPU_ERRDRS3_REG *)0x4000162C))
// model

/** 0x4000 1710 MPU_RGDE1W0 **/
union MPU_RGDE1W0_REG{
	unsigned int reg;
	struct MPU_RGDE1W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W0 (*((volatile union MPU_RGDE1W0_REG *)0x40001710))
// model

/** 0x4000 1714 MPU_RGDE1W1 **/
union MPU_RGDE1W1_REG{
	unsigned int reg;
	struct MPU_RGDE1W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W1 (*((volatile union MPU_RGDE1W1_REG *)0x40001714))
// model

/** 0x4000 1718 MPU_RGDE1W2 **/
union MPU_RGDE1W2_REG{
	unsigned int reg;
	struct MPU_RGDE1W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W2 (*((volatile union MPU_RGDE1W2_REG *)0x40001718))
// model

/** 0x4000 171C MPU_RGDE1W3 **/
union MPU_RGDE1W3_REG{
	unsigned int reg;
	struct MPU_RGDE1W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W3 (*((volatile union MPU_RGDE1W3_REG *)0x4000171C))
// model

/** 0x4000 1720 MPU_RGDE2W0 **/
union MPU_RGDE2W0_REG{
	unsigned int reg;
	struct MPU_RGDE2W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W0 (*((volatile union MPU_RGDE2W0_REG *)0x40001720))
// model

/** 0x4000 1724 MPU_RGDE2W1 **/
union MPU_RGDE2W1_REG{
	unsigned int reg;
	struct MPU_RGDE2W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W1 (*((volatile union MPU_RGDE2W1_REG *)0x40001724))
// model

/** 0x4000 1728 MPU_RGDE2W2 **/
union MPU_RGDE2W2_REG{
	unsigned int reg;
	struct MPU_RGDE2W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W2 (*((volatile union MPU_RGDE2W2_REG *)0x40001728))
// model

/** 0x4000 172C MPU_RGDE2W3 **/
union MPU_RGDE2W3_REG{
	unsigned int reg;
	struct MPU_RGDE2W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W3 (*((volatile union MPU_RGDE2W3_REG *)0x4000172C))
// model

/** 0x4000 1730 MPU_RGDE3W0 **/
union MPU_RGDE3W0_REG{
	unsigned int reg;
	struct MPU_RGDE3W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W0 (*((volatile union MPU_RGDE3W0_REG *)0x40001730))
// model

/** 0x4000 1734 MPU_RGDE3W1 **/
union MPU_RGDE3W1_REG{
	unsigned int reg;
	struct MPU_RGDE3W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W1 (*((volatile union MPU_RGDE3W1_REG *)0x40001734))
// model

/** 0x4000 1738 MPU_RGDE3W2 **/
union MPU_RGDE3W2_REG{
	unsigned int reg;
	struct MPU_RGDE3W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W2 (*((volatile union MPU_RGDE3W2_REG *)0x40001738))
// model

/** 0x4000 173C MPU_RGDE3W3 **/
union MPU_RGDE3W3_REG{
	unsigned int reg;
	struct MPU_RGDE3W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W3 (*((volatile union MPU_RGDE3W3_REG *)0x4000173C))
// model

/** 0x4000 1740 MPU_RGDE4W0 **/
union MPU_RGDE4W0_REG{
	unsigned int reg;
	struct MPU_RGDE4W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W0 (*((volatile union MPU_RGDE4W0_REG *)0x40001740))
// model

/** 0x4000 1744 MPU_RGDE4W1 **/
union MPU_RGDE4W1_REG{
	unsigned int reg;
	struct MPU_RGDE4W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W1 (*((volatile union MPU_RGDE4W1_REG *)0x40001744))
// model

/** 0x4000 1748 MPU_RGDE4W2 **/
union MPU_RGDE4W2_REG{
	unsigned int reg;
	struct MPU_RGDE4W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W2 (*((volatile union MPU_RGDE4W2_REG *)0x40001748))
// model

/** 0x4000 174C MPU_RGDE4W3 **/
union MPU_RGDE4W3_REG{
	unsigned int reg;
	struct MPU_RGDE4W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W3 (*((volatile union MPU_RGDE4W3_REG *)0x4000174C))
// model

/** 0x4000 1750 MPU_RGDE5W0 **/
union MPU_RGDE5W0_REG{
	unsigned int reg;
	struct MPU_RGDE5W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W0 (*((volatile union MPU_RGDE5W0_REG *)0x40001750))
// model

/** 0x4000 1754 MPU_RGDE5W1 **/
union MPU_RGDE5W1_REG{
	unsigned int reg;
	struct MPU_RGDE5W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W1 (*((volatile union MPU_RGDE5W1_REG *)0x40001754))
// model

/** 0x4000 1758 MPU_RGDE5W2 **/
union MPU_RGDE5W2_REG{
	unsigned int reg;
	struct MPU_RGDE5W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W2 (*((volatile union MPU_RGDE5W2_REG *)0x40001758))
// model

/** 0x4000 1718 MPU_RGDE5W3 **/
union MPU_RGDE5W3_REG{
	unsigned int reg;
	struct MPU_RGDE5W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W3 (*((volatile union MPU_RGDE5W3_REG *)0x40001718))
// model

/** 0x4000 1760 MPU_RGDE6W0 **/
union MPU_RGDE6W0_REG{
	unsigned int reg;
	struct MPU_RGDE6W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W0 (*((volatile union MPU_RGDE6W0_REG *)0x40001760))
// model

/** 0x4000 1764 MPU_RGDE6W1 **/
union MPU_RGDE6W1_REG{
	unsigned int reg;
	struct MPU_RGDE6W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W1 (*((volatile union MPU_RGDE6W1_REG *)0x40001764))
// model

/** 0x4000 1768 MPU_RGDE6W2 **/
union MPU_RGDE6W2_REG{
	unsigned int reg;
	struct MPU_RGDE6W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W2 (*((volatile union MPU_RGDE6W2_REG *)0x40001768))
// model

/** 0x4000 176C MPU_RGDE6W3 **/
union MPU_RGDE6W3_REG{
	unsigned int reg;
	struct MPU_RGDE6W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W3 (*((volatile union MPU_RGDE6W3_REG *)0x4000176C))
// model

/** 0x4000 1770 MPU_RGDE7W0 **/
union MPU_RGDE7W0_REG{
	unsigned int reg;
	struct MPU_RGDE7W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W0 (*((volatile union MPU_RGDE7W0_REG *)0x40001770))
// model

/** 0x4000 1774 MPU_RGDE7W1 **/
union MPU_RGDE7W1_REG{
	unsigned int reg;
	struct MPU_RGDE7W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W1 (*((volatile union MPU_RGDE7W1_REG *)0x40001774))
// model

/** 0x4000 1778 MPU_RGDE7W2 **/
union MPU_RGDE7W2_REG{
	unsigned int reg;
	struct MPU_RGDE7W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W2 (*((volatile union MPU_RGDE7W2_REG *)0x40001778))
// model

/** 0x4000 177C MPU_RGDE7W3 **/
union MPU_RGDE7W3_REG{
	unsigned int reg;
	struct MPU_RGDE7W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W3 (*((volatile union MPU_RGDE7W3_REG *)0x4000177C))
// model

/** 0x4000 1780 MPU_RGDE8W0 **/
union MPU_RGDE8W0_REG{
	unsigned int reg;
	struct MPU_RGDE8W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W0 (*((volatile union MPU_RGDE8W0_REG *)0x40001780))
// model

/** 0x4000 1784 MPU_RGDE8W1 **/
union MPU_RGDE8W1_REG{
	unsigned int reg;
	struct MPU_RGDE8W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W1 (*((volatile union MPU_RGDE8W1_REG *)0x40001784))
// model

/** 0x4000 1788 MPU_RGDE8W2 **/
union MPU_RGDE8W2_REG{
	unsigned int reg;
	struct MPU_RGDE8W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W2 (*((volatile union MPU_RGDE8W2_REG *)0x40001788))
// model

/** 0x4000 178C MPU_RGDE8W3 **/
union MPU_RGDE8W3_REG{
	unsigned int reg;
	struct MPU_RGDE8W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W3 (*((volatile union MPU_RGDE8W3_REG *)0x4000178C))
// model

/** 0x4000 1790 MPU_RGDE9W0 **/
union MPU_RGDE9W0_REG{
	unsigned int reg;
	struct MPU_RGDE9W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W0 (*((volatile union MPU_RGDE9W0_REG *)0x40001790))
// model

/** 0x4000 1794 MPU_RGDE9W1 **/
union MPU_RGDE9W1_REG{
	unsigned int reg;
	struct MPU_RGDE9W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W1 (*((volatile union MPU_RGDE9W1_REG *)0x40001794))
// model

/** 0x4000 1798 MPU_RGDE9W2 **/
union MPU_RGDE9W2_REG{
	unsigned int reg;
	struct MPU_RGDE9W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W2 (*((volatile union MPU_RGDE9W2_REG *)0x40001798))
// model

/** 0x4000 179C MPU_RGDE9W3 **/
union MPU_RGDE9W3_REG{
	unsigned int reg;
	struct MPU_RGDE9W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W3 (*((volatile union MPU_RGDE9W3_REG *)0x4000179C))
// model

/** 0x4000 17A0 MPU_RGDE10W0 **/
union MPU_RGDE10W0_REG{
	unsigned int reg;
	struct MPU_RGDE10W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W0 (*((volatile union MPU_RGDE10W0_REG *)0x400017A0))
// model

/** 0x4000 17A4 MPU_RGDE10W1 **/
union MPU_RGDE10W1_REG{
	unsigned int reg;
	struct MPU_RGDE10W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W1 (*((volatile union MPU_RGDE10W1_REG *)0x400017A4))
// model

/** 0x4000 17A8 MPU_RGDE10W2 **/
union MPU_RGDE10W2_REG{
	unsigned int reg;
	struct MPU_RGDE10W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W2 (*((volatile union MPU_RGDE10W2_REG *)0x400017A8))
// model

/** 0x4000 17AC MPU_RGDE10W3 **/
union MPU_RGDE10W3_REG{
	unsigned int reg;
	struct MPU_RGDE10W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W3 (*((volatile union MPU_RGDE10W3_REG *)0x400017AC))
// model

/** 0x4000 17B0 MPU_RGDE11W0 **/
union MPU_RGDE11W0_REG{
	unsigned int reg;
	struct MPU_RGDE11W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W0 (*((volatile union MPU_RGDE11W0_REG *)0x400017B0))
// model

/** 0x4000 17B4 MPU_RGDE11W1 **/
union MPU_RGDE11W1_REG{
	unsigned int reg;
	struct MPU_RGDE11W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W1 (*((volatile union MPU_RGDE11W1_REG *)0x400017B4))
// model

/** 0x4000 17B8 MPU_RGDE11W2 **/
union MPU_RGDE11W2_REG{
	unsigned int reg;
	struct MPU_RGDE11W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W2 (*((volatile union MPU_RGDE11W2_REG *)0x400017B8))
// model

/** 0x4000 17BC MPU_RGDE11W3 **/
union MPU_RGDE11W3_REG{
	unsigned int reg;
	struct MPU_RGDE11W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W3 (*((volatile union MPU_RGDE11W3_REG *)0x400017BC))
// model

/** 0x4000 17C0 MPU_RGDE12W0 **/
union MPU_RGDE12W0_REG{
	unsigned int reg;
	struct MPU_RGDE12W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W0 (*((volatile union MPU_RGDE12W0_REG *)0x400017C0))
// model

/** 0x4000 17C4 MPU_RGDE12W1 **/
union MPU_RGDE12W1_REG{
	unsigned int reg;
	struct MPU_RGDE12W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W1 (*((volatile union MPU_RGDE12W1_REG *)0x400017C4))
// model

/** 0x4000 17C8 MPU_RGDE12W2 **/
union MPU_RGDE12W2_REG{
	unsigned int reg;
	struct MPU_RGDE12W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W2 (*((volatile union MPU_RGDE12W2_REG *)0x400017C8))
// model

/** 0x4000 17CC MPU_RGDE12W3 **/
union MPU_RGDE12W3_REG{
	unsigned int reg;
	struct MPU_RGDE12W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W3 (*((volatile union MPU_RGDE12W3_REG *)0x400017CC))
// model

/** 0x4000 17D0 MPU_RGDE13W0 **/
union MPU_RGDE13W0_REG{
	unsigned int reg;
	struct MPU_RGDE13W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W0 (*((volatile union MPU_RGDE13W0_REG *)0x400017D0))
// model

/** 0x4000 17D4 MPU_RGDE13W1 **/
union MPU_RGDE13W1_REG{
	unsigned int reg;
	struct MPU_RGDE13W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W1 (*((volatile union MPU_RGDE13W1_REG *)0x400017D4))
// model

/** 0x4000 17D8 MPU_RGDE13W2 **/
union MPU_RGDE13W2_REG{
	unsigned int reg;
	struct MPU_RGDE13W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W2 (*((volatile union MPU_RGDE13W2_REG *)0x400017D8))
// model

/** 0x4000 17DC MPU_RGDE13W3 **/
union MPU_RGDE13W3_REG{
	unsigned int reg;
	struct MPU_RGDE13W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W3 (*((volatile union MPU_RGDE13W3_REG *)0x400017DC))
// model

/** 0x4000 17E0 MPU_RGDE14W0 **/
union MPU_RGDE14W0_REG{
	unsigned int reg;
	struct MPU_RGDE14W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W0 (*((volatile union MPU_RGDE14W0_REG *)0x400017E0))
// model

/** 0x4000 17E4 MPU_RGDE14W1 **/
union MPU_RGDE14W1_REG{
	unsigned int reg;
	struct MPU_RGDE14W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W1 (*((volatile union MPU_RGDE14W1_REG *)0x400017E4))
// model

/** 0x4000 17E8 MPU_RGDE14W2 **/
union MPU_RGDE14W2_REG{
	unsigned int reg;
	struct MPU_RGDE14W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W2 (*((volatile union MPU_RGDE14W2_REG *)0x400017E8))
// model

/** 0x4000 17EC MPU_RGDE14W3 **/
union MPU_RGDE14W3_REG{
	unsigned int reg;
	struct MPU_RGDE14W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W3 (*((volatile union MPU_RGDE14W3_REG *)0x400017EC))
// model

/** 0x4000 17F0 MPU_RGDE15W0 **/
union MPU_RGDE15W0_REG{
	unsigned int reg;
	struct MPU_RGDE15W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W0 (*((volatile union MPU_RGDE15W0_REG *)0x400017F0))
// model

/** 0x4000 17F4 MPU_RGDE15W1 **/
union MPU_RGDE15W1_REG{
	unsigned int reg;
	struct MPU_RGDE15W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W1 (*((volatile union MPU_RGDE15W1_REG *)0x400017F4))
// model

/** 0x4000 17F8 MPU_RGDE15W2 **/
union MPU_RGDE15W2_REG{
	unsigned int reg;
	struct MPU_RGDE15W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W2 (*((volatile union MPU_RGDE15W2_REG *)0x400017F8))
// model

/** 0x4000 17FC MPU_RGDE15W3 **/
union MPU_RGDE15W3_REG{
	unsigned int reg;
	struct MPU_RGDE15W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W3 (*((volatile union MPU_RGDE15W3_REG *)0x400017FC))
// model

/** 0x4000 1900 MPU_RGDEACC0 **/
union MPU_RGDEACC0_REG{
	unsigned int reg;
	struct MPU_RGDEACC0_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC0 (*((volatile union MPU_RGDEACC0_REG *)0x40001900))
// model

/** 0x4000 1904 MPU_RGDEACC1 **/
union MPU_RGDEACC1_REG{
	unsigned int reg;
	struct MPU_RGDEACC1_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC1 (*((volatile union MPU_RGDEACC1_REG *)0x40001904))
// model

/** 0x4000 1908 MPU_RGDEACC2 **/
union MPU_RGDEACC2_REG{
	unsigned int reg;
	struct MPU_RGDEACC2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC2 (*((volatile union MPU_RGDEACC2_REG *)0x40001908))
// model

/** 0x4000 190C MPU_RGDEACC3 **/
union MPU_RGDEACC3_REG{
	unsigned int reg;
	struct MPU_RGDEACC3_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC3 (*((volatile union MPU_RGDEACC3_REG *)0x4000190C))
// model

/** 0x4000 1910 MPU_RGDEACC4 **/
union MPU_RGDEACC4_REG{
	unsigned int reg;
	struct MPU_RGDEACC4_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC4 (*((volatile union MPU_RGDEACC4_REG *)0x40001910))
// model

/** 0x4000 1914 MPU_RGDEACC5 **/
union MPU_RGDEACC5_REG{
	unsigned int reg;
	struct MPU_RGDEACC5_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC5 (*((volatile union MPU_RGDEACC5_REG *)0x40001914))
// model

/** 0x4000 1918 MPU_RGDEACC6 **/
union MPU_RGDEACC6_REG{
	unsigned int reg;
	struct MPU_RGDEACC6_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC6 (*((volatile union MPU_RGDEACC6_REG *)0x40001918))
// model

/** 0x4000 191C MPU_RGDEACC7 **/
union MPU_RGDEACC7_REG{
	unsigned int reg;
	struct MPU_RGDEACC7_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC7 (*((volatile union MPU_RGDEACC7_REG *)0x4000191C))
// model

/** 0x4000 1920 MPU_RGDEACC8 **/
union MPU_RGDEACC8_REG{
	unsigned int reg;
	struct MPU_RGDEACC8_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC8 (*((volatile union MPU_RGDEACC8_REG *)0x40001920))
// model

/** 0x4000 1924 MPU_RGDEACC9 **/
union MPU_RGDEACC9_REG{
	unsigned int reg;
	struct MPU_RGDEACC9_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC9 (*((volatile union MPU_RGDEACC9_REG *)0x40001924))
// model

/** 0x4000 1928 MPU_RGDEACC10 **/
union MPU_RGDEACC10_REG{
	unsigned int reg;
	struct MPU_RGDEACC10_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC10 (*((volatile union MPU_RGDEACC10_REG *)0x40001928))
// model

/** 0x4000 192C MPU_RGDEACC11 **/
union MPU_RGDEACC11_REG{
	unsigned int reg;
	struct MPU_RGDEACC11_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC11 (*((volatile union MPU_RGDEACC11_REG *)0x4000192C))
// model

/** 0x4000 1930 MPU_RGDEACC12 **/
union MPU_RGDEACC12_REG{
	unsigned int reg;
	struct MPU_RGDEACC12_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC12 (*((volatile union MPU_RGDEACC12_REG *)0x40001930))
// model

/** 0x4000 1934 MPU_RGDEACC13 **/
union MPU_RGDEACC13_REG{
	unsigned int reg;
	struct MPU_RGDEACC13_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC13 (*((volatile union MPU_RGDEACC13_REG *)0x40001934))
// model

/** 0x4000 1938 MPU_RGDEACC14 **/
union MPU_RGDEACC14_REG{
	unsigned int reg;
	struct MPU_RGDEACC14_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC14 (*((volatile union MPU_RGDEACC14_REG *)0x40001938))
// model

/** 0x4000 193C MPU_RGDEACC15 **/
union MPU_RGDEACC15_REG{
	unsigned int reg;
	struct MPU_RGDEACC15_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC15 (*((volatile union MPU_RGDEACC15_REG *)0x4000193C))
// modelINT

/** 0x4020 0000 INT_CTL0 **/
union INT_CTL0_REG{
	unsigned int reg;
	struct INT_CTL0_BITS{
		unsigned int _AIE:1;
		unsigned int _PRIGROUP:2;
		unsigned int :1;
		unsigned int _INTPENDING:1;
		unsigned int _INTPREEMPT:1;
		unsigned int _FAULTMASK:1;
		unsigned int _DSALIGN:1;
		unsigned int :4;
		unsigned int _PRIBASE:4;
		unsigned int _INTPEND:7;
		unsigned int :1;
		unsigned int _INTACT:7;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL0 (*((volatile union INT_CTL0_REG *)0x40200000))
// model

/** 0x4020 009C INT_CTL1 **/
union INT_CTL1_REG{
	unsigned int reg;
	struct INT_CTL1_BITS{
		unsigned int _INTDELY:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL1 (*((volatile union INT_CTL1_REG *)0x4020009C))
// model

/** 0x4020 0004 INT_EIE0 **/
union INT_EIE0_REG{
	unsigned int reg;
	struct INT_EIE0_BITS{
		unsigned int :3;
		unsigned int _HADRFAULTIE:1;
		unsigned int :1;
		unsigned int _STACKIE:1;
		unsigned int _ARIFAULTIE:1;
		unsigned int :4;
		unsigned int _SVCIE:1;
		unsigned int :2;
		unsigned int _SOFTSVIE:1;
		unsigned int _SYSTICKIE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE0 (*((volatile union INT_EIE0_REG *)0x40200004))
// model

/** 0x4020 000C INT_EIE1 **/
union INT_EIE1_REG{
	unsigned int reg;
	struct INT_EIE1_BITS{
		unsigned int _WWDTIE:1;
		unsigned int _EINT16IE:1;
		unsigned int _PAIE:1;
		unsigned int _PBIE:1;
		unsigned int _PCIE:1;
		unsigned int _PDIE:1;
		unsigned int _T0IE:1;
		unsigned int _T1IE:1;
		unsigned int _T2IE:1;
		unsigned int _T3IE:1;
		unsigned int _T4IE:1;
		unsigned int _T5IE:1;
		unsigned int _ADC0IE:1;
		unsigned int _DMA0IE:1;
		unsigned int _CMPIE:1;
		unsigned int _USART0IE:1;
		unsigned int _USART1IE:1;
		unsigned int _USART2IE:1;
		unsigned int _USART3IE:1;
		unsigned int _SPI0IE:1;
		unsigned int _SPI1IE:1;
		unsigned int _EINT19TO18IE:1;
		unsigned int _CANFDBUSIE:1;
		unsigned int _EINT31TO21IE:1;
		unsigned int _CMUIE:1;
		unsigned int _OSCIE:1;
		unsigned int _I2C0IE:1;
		unsigned int _I2C1IE:1;
		unsigned int _EPWM11IE:1;
		unsigned int _EPWM12IE:1;
		unsigned int _EPWM13IE:1;
		unsigned int _EPWM14IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE1 (*((volatile union INT_EIE1_REG *)0x4020000C))
// model

/** 0x4020 0014 INT_EIE2 **/
union INT_EIE2_REG{
	unsigned int reg;
	struct INT_EIE2_BITS{
		unsigned int _WKPIE:1;
		unsigned int _SRAMECCIE:1;
		unsigned int _DRAMECCIE:1;
		unsigned int _FLASHECCIE:1;
		unsigned int _BUSERRIE:1;
		unsigned int _CANFDGENIE:1;
		unsigned int _CANFDECCIE:1;
		unsigned int _CANFDMB150IE:1;
		unsigned int _CANFDMB3116IE:1;
		unsigned int _CANFDMB4732IE:1;
		unsigned int _CANFDMB6348IE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE2 (*((volatile union INT_EIE2_REG *)0x40200014))
// model

/** 0x4020 001C INT_EIF0 **/
union INT_EIF0_REG{
	unsigned int reg;
	struct INT_EIF0_BITS{
		unsigned int :2;
		unsigned int _NMIIF:1;
		unsigned int _HARDAFULTIF:1;
		unsigned int :1;
		unsigned int _STACKIF:1;
		unsigned int _ARIFAULTIF:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SVCIF:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIF:1;
		unsigned int _SYSTICKIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF0 (*((volatile union INT_EIF0_REG *)0x4020001C))
// model

/** 0x4020 0024 INT_EIF1 **/
union INT_EIF1_REG{
	unsigned int reg;
	struct INT_EIF1_BITS{
		unsigned int _WWDTIF:1;
		unsigned int _EINT16IF:1;
		unsigned int _PAIF:1;
		unsigned int _PBIF:1;
		unsigned int _PCIF:1;
		unsigned int _PDIF:1;
		unsigned int _T0IF:1;
		unsigned int _T1IF:1;
		unsigned int _T2IF:1;
		unsigned int _T3IF:1;
		unsigned int _T4IF:1;
		unsigned int _T5IF:1;
		unsigned int _ADC0IF:1;
		unsigned int _DMA0IF:1;
		unsigned int _CMPIF:1;
		unsigned int _USART0IF:1;
		unsigned int _USART1IF:1;
		unsigned int _USART2IF:1;
		unsigned int _USART3IF:1;
		unsigned int _SPI0IF:1;
		unsigned int _SPI1IF:1;
		unsigned int _EINT19TO18IF:1;
		unsigned int _CANFDBUSIF:1;
		unsigned int _EINT31TO21IF:1;
		unsigned int _CMUIF:1;
		unsigned int _OSCIF:1;
		unsigned int _I2C0IF:1;
		unsigned int _I2C1IF:1;
		unsigned int _EPWM11IF:1;
		unsigned int _EPWM12IF:1;
		unsigned int _EPWM13IF:1;
		unsigned int _EPWM14IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF1 (*((volatile union INT_EIF1_REG *)0x40200024))
// model

/** 0x4020 002C INT_EIF2 **/
union INT_EIF2_REG{
	unsigned int reg;
	struct INT_EIF2_BITS{
		unsigned int _WKPIF:1;
		unsigned int _SRAMECCIF:1;
		unsigned int _DRAMECCIF:1;
		unsigned int _FLASHECCIF:1;
		unsigned int _BUSERRIF:1;
		unsigned int _CANFDGENIF:1;
		unsigned int _CANFDECCIF:1;
		unsigned int _CANFDMB150IF:1;
		unsigned int _CANFDMB3116IF:1;
		unsigned int _CANFDMB4732IF:1;
		unsigned int _CANFDMB6348IF:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF2 (*((volatile union INT_EIF2_REG *)0x4020002C))
// model

/** 0x4020 0034 INT_IP0 **/
union INT_IP0_REG{
	unsigned int reg;
	struct INT_IP0_BITS{
		unsigned int _PRI4:8;
		unsigned int _PRI5:8;
		unsigned int _PRI6:8;
		unsigned int _PRI7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP0 (*((volatile union INT_IP0_REG *)0x40200034))
// model

/** 0x4020 0038 INT_IP1 **/
union INT_IP1_REG{
	unsigned int reg;
	struct INT_IP1_BITS{
		unsigned int _PRI8:8;
		unsigned int _PRI9:8;
		unsigned int _PRI10:8;
		unsigned int _PRI11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP1 (*((volatile union INT_IP1_REG *)0x40200038))
// model

/** 0x4020 003C INT_IP2 **/
union INT_IP2_REG{
	unsigned int reg;
	struct INT_IP2_BITS{
		unsigned int _PRI12:8;
		unsigned int _PRI13:8;
		unsigned int _PRI14:8;
		unsigned int _PRI15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP2 (*((volatile union INT_IP2_REG *)0x4020003C))
// model

/** 0x4020 0040 INT_IP3 **/
union INT_IP3_REG{
	unsigned int reg;
	struct INT_IP3_BITS{
		unsigned int _PRI16:8;
		unsigned int _PRI17:8;
		unsigned int _PRI18:8;
		unsigned int _PRI19:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP3 (*((volatile union INT_IP3_REG *)0x40200040))
// model

/** 0x4020 0044 INT_IP4 **/
union INT_IP4_REG{
	unsigned int reg;
	struct INT_IP4_BITS{
		unsigned int _PRI20:8;
		unsigned int _PRI21:8;
		unsigned int _PRI22:8;
		unsigned int _PRI23:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP4 (*((volatile union INT_IP4_REG *)0x40200044))
// model

/** 0x4020 0048 INT_IP5 **/
union INT_IP5_REG{
	unsigned int reg;
	struct INT_IP5_BITS{
		unsigned int _PRI24:8;
		unsigned int _PRI25:8;
		unsigned int _PRI26:8;
		unsigned int _PRI27:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP5 (*((volatile union INT_IP5_REG *)0x40200048))
// model

/** 0x4020 004C INT_IP6 **/
union INT_IP6_REG{
	unsigned int reg;
	struct INT_IP6_BITS{
		unsigned int _PRI28:8;
		unsigned int _PRI29:8;
		unsigned int _PRI30:8;
		unsigned int _PRI31:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP6 (*((volatile union INT_IP6_REG *)0x4020004C))
// model

/** 0x4020 0050 INT_IP7 **/
union INT_IP7_REG{
	unsigned int reg;
	struct INT_IP7_BITS{
		unsigned int _PRI32:8;
		unsigned int _PRI33:8;
		unsigned int _PRI34:8;
		unsigned int _PRI35:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP7 (*((volatile union INT_IP7_REG *)0x40200050))
// model

/** 0x4020 0054 INT_IP8 **/
union INT_IP8_REG{
	unsigned int reg;
	struct INT_IP8_BITS{
		unsigned int _PR36:8;
		unsigned int _PRI37:8;
		unsigned int _PRI38:8;
		unsigned int _PRI339:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP8 (*((volatile union INT_IP8_REG *)0x40200054))
// model

/** 0x4020 0058 INT_IP9 **/
union INT_IP9_REG{
	unsigned int reg;
	struct INT_IP9_BITS{
		unsigned int _PRI40:8;
		unsigned int _PRI41:8;
		unsigned int _PRI42:8;
		unsigned int _PRI43:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP9 (*((volatile union INT_IP9_REG *)0x40200058))
// model

/** 0x4020 005C INT_IP10 **/
union INT_IP10_REG{
	unsigned int reg;
	struct INT_IP10_BITS{
		unsigned int _PRI44:8;
		unsigned int _PRI45:8;
		unsigned int _PRI46:8;
		unsigned int _PRI47:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP10 (*((volatile union INT_IP10_REG *)0x4020005C))
// model

/** 0x4020 0060 INT_IP11 **/
union INT_IP11_REG{
	unsigned int reg;
	struct INT_IP11_BITS{
		unsigned int _PRI48:8;
		unsigned int _PRI49:8;
		unsigned int _PRI50:8;
		unsigned int _PRI51:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP11 (*((volatile union INT_IP11_REG *)0x40200060))
// model

/** 0x4020 0064 INT_IP12 **/
union INT_IP12_REG{
	unsigned int reg;
	struct INT_IP12_BITS{
		unsigned int _PRI52:8;
		unsigned int _PRI53:8;
		unsigned int _PRI54:8;
		unsigned int _PRI55:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP12 (*((volatile union INT_IP12_REG *)0x40200064))
// model

/** 0x4020 0068 INT_IP13 **/
union INT_IP13_REG{
	unsigned int reg;
	struct INT_IP13_BITS{
		unsigned int _PRI56:8;
		unsigned int _PRI57:8;
		unsigned int _PRI58:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP13 (*((volatile union INT_IP13_REG *)0x40200068))
// model

/** 0x4020 0080 INT_EINTMASK **/
union INT_EINTMASK_REG{
	unsigned int reg;
	struct INT_EINTMASK_BITS{
		unsigned int :16;
		unsigned int _EINTM:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTMASK (*((volatile union INT_EINTMASK_REG *)0x40200080))
// model

/** 0x4020 0084 INT_EINTRISE **/
union INT_EINTRISE_REG{
	unsigned int reg;
	struct INT_EINTRISE_BITS{
		unsigned int :16;
		unsigned int _EINTRI:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTRISE (*((volatile union INT_EINTRISE_REG *)0x40200084))
// model

/** 0x4020 0088 INT_EINTFALL **/
union INT_EINTFALL_REG{
	unsigned int reg;
	struct INT_EINTFALL_BITS{
		unsigned int :16;
		unsigned int _EINTFA:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTFALL (*((volatile union INT_EINTFALL_REG *)0x40200088))
// model

/** 0x4020 008C INT_EINTF **/
union INT_EINTF_REG{
	unsigned int reg;
	struct INT_EINTF_BITS{
		unsigned int :16;
		unsigned int _EINTIF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTF (*((volatile union INT_EINTF_REG *)0x4020008C))
// model

/** 0x4020 0090 INT_EINTEL **/
union INT_EINTEL_REG{
	unsigned int reg;
	struct INT_EINTEL_BITS{
		unsigned int :16;
		unsigned int _EINTEL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTEL (*((volatile union INT_EINTEL_REG *)0x40200090))
// modelSYS

/** 0x4020 00B0 SYS_PSW **/
union SYS_PSW_REG{
	unsigned int reg;
	struct SYS_PSW_BITS{
		unsigned int :28;
		unsigned int _V:1;
		unsigned int _C:1;
		unsigned int _Z:1;
		unsigned int _N:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSW (*((volatile union SYS_PSW_REG *)0x402000B0))
// model

/** 0x4020 00B4 SYS_MCTL **/
union SYS_MCTL_REG{
	unsigned int reg;
	struct SYS_MCTL_BITS{
		unsigned int :1;
		unsigned int _SLEEPONEXIT:1;
		unsigned int _SLEEPDEEP:1;
		unsigned int :1;
		unsigned int _SLPONMOD:1;
		unsigned int :4;
		unsigned int _STACKALIGN:1;
		unsigned int :5;
		unsigned int _SUSTA:1;
		unsigned int _SPSEL:1;
		unsigned int :13;
		unsigned int _RUNOUT:1;
		unsigned int _FETCHOUT:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MCTL (*((volatile union SYS_MCTL_REG *)0x402000B4))
// model

/** 0x4020 00B8 SYS_ARCTL **/
union SYS_ARCTL_REG{
	unsigned int reg;
	struct SYS_ARCTL_BITS{
		unsigned int :2;
		unsigned int _SYSTEMRST:1;
		unsigned int :1;
		unsigned int _CDMAR:1;
		unsigned int _CDMAAM:1;
		unsigned int _CRWDC:1;
		unsigned int _CDMADC:1;
		unsigned int _CDBUGBS:1;
		unsigned int _CDMALDC:2;
		unsigned int _ROMLOCK:1;
		unsigned int :4;
		unsigned int _ARKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_ARCTL (*((volatile union SYS_ARCTL_REG *)0x402000B8))
// model

/** 0x4020 00BC SYS_VECTOFF **/
union SYS_VECTOFF_REG{
	unsigned int reg;
	struct SYS_VECTOFF_BITS{
		unsigned int _TBLOFF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_VECTOFF (*((volatile union SYS_VECTOFF_REG *)0x402000BC))
// model

/** 0x4020 00C0 CACHE_CTLR **/
union CACHE_CTLR_REG{
	unsigned int reg;
	struct CACHE_CTLR_BITS{
		unsigned int _CACHEEN:1;
		unsigned int _CACHERST:1;
		unsigned int _ICWR2LEN:1;
		unsigned int _ICRD2LEN:1;
		unsigned int _CECCEN:1;
		unsigned int :6;
		unsigned int _CACHETEN:1;
		unsigned int _BUSTEN:1;
		unsigned int _BUSTSTART:1;
		unsigned int _BUSTMODE:1;
		unsigned int _BUSTD0:1;
		unsigned int _BUSTD1:1;
		unsigned int _BUSRERR:1;
		unsigned int _BUSWERR:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CACHE_CTLR (*((volatile union CACHE_CTLR_REG *)0x402000C0))
// model

/** 0x4020 00C4 SYS_RAMSPA **/
union SYS_RAMSPA_REG{
	unsigned int reg;
	struct SYS_RAMSPA_BITS{
		unsigned int _RAMSPA:26;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_RAMSPA (*((volatile union SYS_RAMSPA_REG *)0x402000C4))
// model

/** 0x4020 00C8 SYS_MEMCTL **/
union SYS_MEMCTL_REG{
	unsigned int reg;
	struct SYS_MEMCTL_BITS{
		unsigned int _MEMM:2;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MEMCTL (*((volatile union SYS_MEMCTL_REG *)0x402000C8))
// model

/** 0x4020 00CC SYS_MSPSPA **/
union SYS_MSPSPA_REG{
	unsigned int reg;
	struct SYS_MSPSPA_BITS{
		unsigned int _MSPSPAL:16;
		unsigned int _MSPSPAH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MSPSPA (*((volatile union SYS_MSPSPA_REG *)0x402000CC))
// model

/** 0x4020 00D0 SYS_PSPSPA **/
union SYS_PSPSPA_REG{
	unsigned int reg;
	struct SYS_PSPSPA_BITS{
		unsigned int _PSPSPAL:16;
		unsigned int _PSPSPAH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSPSPA (*((volatile union SYS_PSPSPA_REG *)0x402000D0))
// modelDMA

/** 0x4000 1100 DMA_CTLR1 **/
union DMA_CTLR1_REG{
	unsigned int reg;
	struct DMA_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR1 (*((volatile union DMA_CTLR1_REG *)0x40001100))
// model

/** 0x4000 1104 DMA_CTLR2 **/
union DMA_CTLR2_REG{
	unsigned int reg;
	struct DMA_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR2 (*((volatile union DMA_CTLR2_REG *)0x40001104))
// model

/** 0x4000 1108 DMA_CTLR3 **/
union DMA_CTLR3_REG{
	unsigned int reg;
	struct DMA_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR3 (*((volatile union DMA_CTLR3_REG *)0x40001108))
// model

/** 0x4000 110C DMA_CTLR4 **/
union DMA_CTLR4_REG{
	unsigned int reg;
	struct DMA_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR4 (*((volatile union DMA_CTLR4_REG *)0x4000110C))
// model

/** 0x4000 1110 DMA_CTLR5 **/
union DMA_CTLR5_REG{
	unsigned int reg;
	struct DMA_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR5 (*((volatile union DMA_CTLR5_REG *)0x40001110))
// model

/** 0x4000 1114 DMA_CTLR6 **/
union DMA_CTLR6_REG{
	unsigned int reg;
	struct DMA_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR6 (*((volatile union DMA_CTLR6_REG *)0x40001114))
// model

/** 0x4000 1118 DMA_CTLR7 **/
union DMA_CTLR7_REG{
	unsigned int reg;
	struct DMA_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CTLR7 (*((volatile union DMA_CTLR7_REG *)0x40001118))
// model

/** 0x4000 1120 DMA_PADDR1 **/
union DMA_PADDR1_REG{
	unsigned int reg;
	struct DMA_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR1 (*((volatile union DMA_PADDR1_REG *)0x40001120))
// model

/** 0x4000 1124 DMA_PADDR2 **/
union DMA_PADDR2_REG{
	unsigned int reg;
	struct DMA_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR2 (*((volatile union DMA_PADDR2_REG *)0x40001124))
// model

/** 0x4000 1128 DMA_PADDR3 **/
union DMA_PADDR3_REG{
	unsigned int reg;
	struct DMA_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR3 (*((volatile union DMA_PADDR3_REG *)0x40001128))
// model

/** 0x4000 112C DMA_PADDR4 **/
union DMA_PADDR4_REG{
	unsigned int reg;
	struct DMA_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR4 (*((volatile union DMA_PADDR4_REG *)0x4000112C))
// model

/** 0x4000 1130 DMA_PADDR5 **/
union DMA_PADDR5_REG{
	unsigned int reg;
	struct DMA_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR5 (*((volatile union DMA_PADDR5_REG *)0x40001130))
// model

/** 0x4000 1134 DMA_PADDR6 **/
union DMA_PADDR6_REG{
	unsigned int reg;
	struct DMA_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR6 (*((volatile union DMA_PADDR6_REG *)0x40001134))
// model

/** 0x4000 1138 DMA_PADDR7 **/
union DMA_PADDR7_REG{
	unsigned int reg;
	struct DMA_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_PADDR7 (*((volatile union DMA_PADDR7_REG *)0x40001138))
// model

/** 0x4000 1140 DMA_MADDR1 **/
union DMA_MADDR1_REG{
	unsigned int reg;
	struct DMA_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR1 (*((volatile union DMA_MADDR1_REG *)0x40001140))
// model

/** 0x4000 1144 DMA_MADDR2 **/
union DMA_MADDR2_REG{
	unsigned int reg;
	struct DMA_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR2 (*((volatile union DMA_MADDR2_REG *)0x40001144))
// model

/** 0x4000 1148 DMA_MADDR3 **/
union DMA_MADDR3_REG{
	unsigned int reg;
	struct DMA_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR3 (*((volatile union DMA_MADDR3_REG *)0x40001148))
// model

/** 0x4000 114C DMA_MADDR4 **/
union DMA_MADDR4_REG{
	unsigned int reg;
	struct DMA_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR4 (*((volatile union DMA_MADDR4_REG *)0x4000114C))
// model

/** 0x4000 1150 DMA_MADDR5 **/
union DMA_MADDR5_REG{
	unsigned int reg;
	struct DMA_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR5 (*((volatile union DMA_MADDR5_REG *)0x40001150))
// model

/** 0x4000 1154 DMA_MADDR6 **/
union DMA_MADDR6_REG{
	unsigned int reg;
	struct DMA_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR6 (*((volatile union DMA_MADDR6_REG *)0x40001154))
// model

/** 0x4000 1158 DMA_MADDR7 **/
union DMA_MADDR7_REG{
	unsigned int reg;
	struct DMA_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MADDR7 (*((volatile union DMA_MADDR7_REG *)0x40001158))
// model

/** 0x4000 1160 DMA_CPAR1 **/
union DMA_CPAR1_REG{
	unsigned int reg;
	struct DMA_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR1 (*((volatile union DMA_CPAR1_REG *)0x40001160))
// model

/** 0x4000 1164 DMA_CPAR2 **/
union DMA_CPAR2_REG{
	unsigned int reg;
	struct DMA_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR2 (*((volatile union DMA_CPAR2_REG *)0x40001164))
// model

/** 0x4000 1168 DMA_CPAR3 **/
union DMA_CPAR3_REG{
	unsigned int reg;
	struct DMA_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR3 (*((volatile union DMA_CPAR3_REG *)0x40001168))
// model

/** 0x4000 116C DMA_CPAR4 **/
union DMA_CPAR4_REG{
	unsigned int reg;
	struct DMA_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR4 (*((volatile union DMA_CPAR4_REG *)0x4000116C))
// model

/** 0x4000 1170 DMA_CPAR5 **/
union DMA_CPAR5_REG{
	unsigned int reg;
	struct DMA_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR5 (*((volatile union DMA_CPAR5_REG *)0x40001170))
// model

/** 0x4000 1174 DMA_CPAR6 **/
union DMA_CPAR6_REG{
	unsigned int reg;
	struct DMA_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR6 (*((volatile union DMA_CPAR6_REG *)0x40001174))
// model

/** 0x4000 1178 DMA_CPAR7 **/
union DMA_CPAR7_REG{
	unsigned int reg;
	struct DMA_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CPAR7 (*((volatile union DMA_CPAR7_REG *)0x40001178))
// model

/** 0x4000 1180 DMA_CMAR1 **/
union DMA_CMAR1_REG{
	unsigned int reg;
	struct DMA_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR1 (*((volatile union DMA_CMAR1_REG *)0x40001180))
// model

/** 0x4000 1184 DMA_CMAR2 **/
union DMA_CMAR2_REG{
	unsigned int reg;
	struct DMA_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR2 (*((volatile union DMA_CMAR2_REG *)0x40001184))
// model

/** 0x4000 1188 DMA_CMAR3 **/
union DMA_CMAR3_REG{
	unsigned int reg;
	struct DMA_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR3 (*((volatile union DMA_CMAR3_REG *)0x40001188))
// model

/** 0x4000 118C DMA_CMAR4 **/
union DMA_CMAR4_REG{
	unsigned int reg;
	struct DMA_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR4 (*((volatile union DMA_CMAR4_REG *)0x4000118C))
// model

/** 0x4000 1190 DMA_CMAR5 **/
union DMA_CMAR5_REG{
	unsigned int reg;
	struct DMA_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR5 (*((volatile union DMA_CMAR5_REG *)0x40001190))
// model

/** 0x4000 1194 DMA_CMAR6 **/
union DMA_CMAR6_REG{
	unsigned int reg;
	struct DMA_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR6 (*((volatile union DMA_CMAR6_REG *)0x40001194))
// model

/** 0x4000 1198 DMA_CMAR7 **/
union DMA_CMAR7_REG{
	unsigned int reg;
	struct DMA_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_CMAR7 (*((volatile union DMA_CMAR7_REG *)0x40001198))
// model

/** 0x4000 11A0 DMA_NCT1 **/
union DMA_NCT1_REG{
	unsigned int reg;
	struct DMA_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT1 (*((volatile union DMA_NCT1_REG *)0x400011A0))
// model

/** 0x4000 11A4 DMA_NCT2 **/
union DMA_NCT2_REG{
	unsigned int reg;
	struct DMA_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT2 (*((volatile union DMA_NCT2_REG *)0x400011A4))
// model

/** 0x4000 11A8 DMA_NCT3 **/
union DMA_NCT3_REG{
	unsigned int reg;
	struct DMA_NCT3_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT3 (*((volatile union DMA_NCT3_REG *)0x400011A8))
// model

/** 0x4000 11AC DMA_NCT4 **/
union DMA_NCT4_REG{
	unsigned int reg;
	struct DMA_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT4 (*((volatile union DMA_NCT4_REG *)0x400011AC))
// model

/** 0x4000 11B0 DMA_NCT5 **/
union DMA_NCT5_REG{
	unsigned int reg;
	struct DMA_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT5 (*((volatile union DMA_NCT5_REG *)0x400011B0))
// model

/** 0x4000 11B4 DMA_NCT6 **/
union DMA_NCT6_REG{
	unsigned int reg;
	struct DMA_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT6 (*((volatile union DMA_NCT6_REG *)0x400011B4))
// model

/** 0x4000 11B8 DMA_NCT7 **/
union DMA_NCT7_REG{
	unsigned int reg;
	struct DMA_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_NCT7 (*((volatile union DMA_NCT7_REG *)0x400011B8))
// model

/** 0x4000 11C0 DMA_LIFR **/
union DMA_LIFR_REG{
	unsigned int reg;
	struct DMA_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_LIFR (*((volatile union DMA_LIFR_REG *)0x400011C0))
// model

/** 0x4000 11C4 DMA_LIER **/
union DMA_LIER_REG{
	unsigned int reg;
	struct DMA_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIE7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_LIER (*((volatile union DMA_LIER_REG *)0x400011C4))
// model

/** 0x4000 11C8 DMA_MUXL **/
union DMA_MUXL_REG{
	unsigned int reg;
	struct DMA_MUXL_BITS{
		unsigned int _SOURCE1:4;
		unsigned int :3;
		unsigned int _TRGEN1:1;
		unsigned int _SOURCE2:4;
		unsigned int :3;
		unsigned int _TRGEN2:1;
		unsigned int _SOURCE3:4;
		unsigned int :3;
		unsigned int _TRGEN3:1;
		unsigned int _SOURCE4:4;
		unsigned int :3;
		unsigned int _TRGEN4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MUXL (*((volatile union DMA_MUXL_REG *)0x400011C8))
// model

/** 0x4000 11CC DMA_MUXH **/
union DMA_MUXH_REG{
	unsigned int reg;
	struct DMA_MUXH_BITS{
		unsigned int _SOURCE5:4;
		unsigned int :3;
		unsigned int _TRGEN5:1;
		unsigned int _SOURCE6:4;
		unsigned int :3;
		unsigned int _TRGEN6:1;
		unsigned int _SOURCE7:4;
		unsigned int :3;
		unsigned int _TRGEN7:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA_MUXH (*((volatile union DMA_MUXH_REG *)0x400011CC))
// modelSYSTICK

/** 0x4020 00A0 ST_CTL **/
union ST_CTL_REG{
	unsigned int reg;
	struct ST_CTL_BITS{
		unsigned int _STEN:1;
		unsigned int _TICKINTEN:1;
		unsigned int _STCLKS:1;
		unsigned int :13;
		unsigned int _COUNTZERO:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CTL (*((volatile union ST_CTL_REG *)0x402000A0))
// model

/** 0x4020 00A4 ST_RELOAD **/
union ST_RELOAD_REG{
	unsigned int reg;
	struct ST_RELOAD_BITS{
		unsigned int _STRELOAD:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_RELOAD (*((volatile union ST_RELOAD_REG *)0x402000A4))
// model

/** 0x4020 00A8 ST_CV **/
union ST_CV_REG{
	unsigned int reg;
	struct ST_CV_BITS{
		unsigned int _STCV:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CV (*((volatile union ST_CV_REG *)0x402000A8))
// model

/** 0x4020 00AC ST_CALI **/
union ST_CALI_REG{
	unsigned int reg;
	struct ST_CALI_BITS{
		unsigned int _STCALIB:24;
		unsigned int :6;
		unsigned int _SKEW:1;
		unsigned int _STCLKREF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CALI (*((volatile union ST_CALI_REG *)0x402000AC))
// modelT0

/** 0x4000 0080 T0_CNT **/
union T0_CNT_REG{
	unsigned int reg;
	struct T0_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CNT (*((volatile union T0_CNT_REG *)0x40000080))
// model

/** 0x4000 0084 T0_CTL1 **/
union T0_CTL1_REG{
	unsigned int reg;
	struct T0_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL1 (*((volatile union T0_CTL1_REG *)0x40000084))
// model

/** 0x4000 0088 T0_CTL2 **/
union T0_CTL2_REG{
	unsigned int reg;
	struct T0_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL2 (*((volatile union T0_CTL2_REG *)0x40000088))
// model

/** 0x4000 008C T0_PRSC **/
union T0_PRSC_REG{
	unsigned int reg;
	struct T0_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PRSC (*((volatile union T0_PRSC_REG *)0x4000008C))
// model

/** 0x4000 0090 T0_PPX **/
union T0_PPX_REG{
	unsigned int reg;
	struct T0_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PPX (*((volatile union T0_PPX_REG *)0x40000090))
// model

/** 0x4000 0094 T0_UDTIM **/
union T0_UDTIM_REG{
	unsigned int reg;
	struct T0_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_UDTIM (*((volatile union T0_UDTIM_REG *)0x40000094))
// modelT1

/** 0x4000 0100 T1_CNT **/
union T1_CNT_REG{
	unsigned int reg;
	struct T1_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CNT (*((volatile union T1_CNT_REG *)0x40000100))
// model

/** 0x4000 0104 T1_CTL1 **/
union T1_CTL1_REG{
	unsigned int reg;
	struct T1_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL1 (*((volatile union T1_CTL1_REG *)0x40000104))
// model

/** 0x4000 0108 T1_CTL2 **/
union T1_CTL2_REG{
	unsigned int reg;
	struct T1_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL2 (*((volatile union T1_CTL2_REG *)0x40000108))
// model

/** 0x4000 010C T1_PRSC **/
union T1_PRSC_REG{
	unsigned int reg;
	struct T1_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PRSC (*((volatile union T1_PRSC_REG *)0x4000010C))
// model

/** 0x4000 0110 T1_PPX **/
union T1_PPX_REG{
	unsigned int reg;
	struct T1_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PPX (*((volatile union T1_PPX_REG *)0x40000110))
// model

/** 0x4000 0114 T1_UDTIM **/
union T1_UDTIM_REG{
	unsigned int reg;
	struct T1_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_UDTIM (*((volatile union T1_UDTIM_REG *)0x40000114))
// modelT2

/** 0x4000 0180 T2_CNT **/
union T2_CNT_REG{
	unsigned int reg;
	struct T2_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CNT (*((volatile union T2_CNT_REG *)0x40000180))
// model

/** 0x4000 0184 T2_CTL1 **/
union T2_CTL1_REG{
	unsigned int reg;
	struct T2_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL1 (*((volatile union T2_CTL1_REG *)0x40000184))
// model

/** 0x4000 0188 T2_CTL2 **/
union T2_CTL2_REG{
	unsigned int reg;
	struct T2_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL2 (*((volatile union T2_CTL2_REG *)0x40000188))
// model

/** 0x4000 018C T2_PRSC **/
union T2_PRSC_REG{
	unsigned int reg;
	struct T2_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PRSC (*((volatile union T2_PRSC_REG *)0x4000018C))
// model

/** 0x4000 0190 T2_PPX **/
union T2_PPX_REG{
	unsigned int reg;
	struct T2_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PPX (*((volatile union T2_PPX_REG *)0x40000190))
// model

/** 0x4000 0194 T2_UDTIM **/
union T2_UDTIM_REG{
	unsigned int reg;
	struct T2_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_UDTIM (*((volatile union T2_UDTIM_REG *)0x40000194))
// modelT3

/** 0x4000 0200 T3_CNT **/
union T3_CNT_REG{
	unsigned int reg;
	struct T3_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CNT (*((volatile union T3_CNT_REG *)0x40000200))
// model

/** 0x4000 0204 T3_CTL1 **/
union T3_CTL1_REG{
	unsigned int reg;
	struct T3_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL1 (*((volatile union T3_CTL1_REG *)0x40000204))
// model

/** 0x4000 0208 T3_CTL2 **/
union T3_CTL2_REG{
	unsigned int reg;
	struct T3_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL2 (*((volatile union T3_CTL2_REG *)0x40000208))
// model

/** 0x4000 020C T3_PRSC **/
union T3_PRSC_REG{
	unsigned int reg;
	struct T3_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PRSC (*((volatile union T3_PRSC_REG *)0x4000020C))
// model

/** 0x4000 0210 T3_PPX **/
union T3_PPX_REG{
	unsigned int reg;
	struct T3_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PPX (*((volatile union T3_PPX_REG *)0x40000210))
// model

/** 0x4000 0214 T3_UDTIM **/
union T3_UDTIM_REG{
	unsigned int reg;
	struct T3_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_UDTIM (*((volatile union T3_UDTIM_REG *)0x40000214))
// modelT4

/** 0x4000 0280 T4_CNT **/
union T4_CNT_REG{
	unsigned int reg;
	struct T4_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CNT (*((volatile union T4_CNT_REG *)0x40000280))
// model

/** 0x4000 0284 T4_CTL1 **/
union T4_CTL1_REG{
	unsigned int reg;
	struct T4_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL1 (*((volatile union T4_CTL1_REG *)0x40000284))
// model

/** 0x4000 0288 T4_CTL2 **/
union T4_CTL2_REG{
	unsigned int reg;
	struct T4_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL2 (*((volatile union T4_CTL2_REG *)0x40000288))
// model

/** 0x4000 028C T4_PRSC **/
union T4_PRSC_REG{
	unsigned int reg;
	struct T4_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PRSC (*((volatile union T4_PRSC_REG *)0x4000028C))
// model

/** 0x4000 0290 T4_PPX **/
union T4_PPX_REG{
	unsigned int reg;
	struct T4_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PPX (*((volatile union T4_PPX_REG *)0x40000290))
// model

/** 0x4000 0294 T4_UDTIM **/
union T4_UDTIM_REG{
	unsigned int reg;
	struct T4_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_UDTIM (*((volatile union T4_UDTIM_REG *)0x40000294))
// modelT5

/** 0x4000 0300 T5_CNT **/
union T5_CNT_REG{
	unsigned int reg;
	struct T5_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CNT (*((volatile union T5_CNT_REG *)0x40000300))
// model

/** 0x4000 0304 T5_CTL1 **/
union T5_CTL1_REG{
	unsigned int reg;
	struct T5_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CTL1 (*((volatile union T5_CTL1_REG *)0x40000304))
// model

/** 0x4000 0308 T5_CTL2 **/
union T5_CTL2_REG{
	unsigned int reg;
	struct T5_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CTL2 (*((volatile union T5_CTL2_REG *)0x40000308))
// model

/** 0x4000 030C T5_PRSC **/
union T5_PRSC_REG{
	unsigned int reg;
	struct T5_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PRSC (*((volatile union T5_PRSC_REG *)0x4000030C))
// model

/** 0x4000 0310 T5_PPX **/
union T5_PPX_REG{
	unsigned int reg;
	struct T5_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PPX (*((volatile union T5_PPX_REG *)0x40000310))
// model

/** 0x4000 0314 T5_UDTIM **/
union T5_UDTIM_REG{
	unsigned int reg;
	struct T5_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_UDTIM (*((volatile union T5_UDTIM_REG *)0x40000314))
// modelCCP0

/** 0x4000 00A0 CCP0_C1 **/
union CCP0_C1_REG{
	unsigned int reg;
	struct CCP0_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C1 (*((volatile union CCP0_C1_REG *)0x400000A0))
// model

/** 0x4000 00A4 CCP0_C2 **/
union CCP0_C2_REG{
	unsigned int reg;
	struct CCP0_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C2 (*((volatile union CCP0_C2_REG *)0x400000A4))
// model

/** 0x4000 00A8 CCP0_C3 **/
union CCP0_C3_REG{
	unsigned int reg;
	struct CCP0_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C3 (*((volatile union CCP0_C3_REG *)0x400000A8))
// model

/** 0x4000 00AC CCP0_C4 **/
union CCP0_C4_REG{
	unsigned int reg;
	struct CCP0_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C4 (*((volatile union CCP0_C4_REG *)0x400000AC))
// model

/** 0x4000 00B0 CCP0_SRIC **/
union CCP0_SRIC_REG{
	unsigned int reg;
	struct CCP0_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_SRIC (*((volatile union CCP0_SRIC_REG *)0x400000B0))
// model

/** 0x4000 00B4 CCP0_DF **/
union CCP0_DF_REG{
	unsigned int reg;
	struct CCP0_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_DF (*((volatile union CCP0_DF_REG *)0x400000B4))
// model

/** 0x4000 00C0 CCP0_CTL1 **/
union CCP0_CTL1_REG{
	unsigned int reg;
	struct CCP0_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL1 (*((volatile union CCP0_CTL1_REG *)0x400000C0))
// model

/** 0x4000 00C4 CCP0_R1 **/
union CCP0_R1_REG{
	unsigned int reg;
	struct CCP0_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R1 (*((volatile union CCP0_R1_REG *)0x400000C4))
// model

/** 0x4000 00C8 CCP0_R2 **/
union CCP0_R2_REG{
	unsigned int reg;
	struct CCP0_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R2 (*((volatile union CCP0_R2_REG *)0x400000C8))
// model

/** 0x4000 00CC CCP0_R3 **/
union CCP0_R3_REG{
	unsigned int reg;
	struct CCP0_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R3 (*((volatile union CCP0_R3_REG *)0x400000CC))
// model

/** 0x4000 00D0 CCP0_R4 **/
union CCP0_R4_REG{
	unsigned int reg;
	struct CCP0_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R4 (*((volatile union CCP0_R4_REG *)0x400000D0))
// model

/** 0x4000 00D4 CCP0_CTL2 **/
union CCP0_CTL2_REG{
	unsigned int reg;
	struct CCP0_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL2 (*((volatile union CCP0_CTL2_REG *)0x400000D4))
// model

/** 0x4000 00D8 CCP0_CTL3 **/
union CCP0_CTL3_REG{
	unsigned int reg;
	struct CCP0_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL3 (*((volatile union CCP0_CTL3_REG *)0x400000D8))
// model

/** 0x4000 00DC CCP0_EGIF **/
union CCP0_EGIF_REG{
	unsigned int reg;
	struct CCP0_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_EGIF (*((volatile union CCP0_EGIF_REG *)0x400000DC))
// modelCCP1

/** 0x4000 0120 CCP1_C1 **/
union CCP1_C1_REG{
	unsigned int reg;
	struct CCP1_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C1 (*((volatile union CCP1_C1_REG *)0x40000120))
// model

/** 0x4000 0124 CCP1_C2 **/
union CCP1_C2_REG{
	unsigned int reg;
	struct CCP1_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C2 (*((volatile union CCP1_C2_REG *)0x40000124))
// model

/** 0x4000 0128 CCP1_C3 **/
union CCP1_C3_REG{
	unsigned int reg;
	struct CCP1_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C3 (*((volatile union CCP1_C3_REG *)0x40000128))
// model

/** 0x4000 012C CCP1_C4 **/
union CCP1_C4_REG{
	unsigned int reg;
	struct CCP1_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C4 (*((volatile union CCP1_C4_REG *)0x4000012C))
// model

/** 0x4000 0130 CCP1_SRIC **/
union CCP1_SRIC_REG{
	unsigned int reg;
	struct CCP1_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :5;
		unsigned int _ANA_T:3;
		unsigned int _ANA_TEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_SRIC (*((volatile union CCP1_SRIC_REG *)0x40000130))
// model

/** 0x4000 0134 CCP1_DF **/
union CCP1_DF_REG{
	unsigned int reg;
	struct CCP1_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_DF (*((volatile union CCP1_DF_REG *)0x40000134))
// model

/** 0x4000 0140 CCP1_CTL1 **/
union CCP1_CTL1_REG{
	unsigned int reg;
	struct CCP1_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL1 (*((volatile union CCP1_CTL1_REG *)0x40000140))
// model

/** 0x4000 0144 CCP1_R1 **/
union CCP1_R1_REG{
	unsigned int reg;
	struct CCP1_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R1 (*((volatile union CCP1_R1_REG *)0x40000144))
// model

/** 0x4000 0148 CCP1_R2 **/
union CCP1_R2_REG{
	unsigned int reg;
	struct CCP1_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R2 (*((volatile union CCP1_R2_REG *)0x40000148))
// model

/** 0x4000 014C CCP1_R3 **/
union CCP1_R3_REG{
	unsigned int reg;
	struct CCP1_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R3 (*((volatile union CCP1_R3_REG *)0x4000014C))
// model

/** 0x4000 0150 CCP1_R4 **/
union CCP1_R4_REG{
	unsigned int reg;
	struct CCP1_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R4 (*((volatile union CCP1_R4_REG *)0x40000150))
// model

/** 0x4000 0154 CCP1_CTL2 **/
union CCP1_CTL2_REG{
	unsigned int reg;
	struct CCP1_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL2 (*((volatile union CCP1_CTL2_REG *)0x40000154))
// model

/** 0x4000 0158 CCP1_CTL3 **/
union CCP1_CTL3_REG{
	unsigned int reg;
	struct CCP1_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL3 (*((volatile union CCP1_CTL3_REG *)0x40000158))
// model

/** 0x4000 015C CCP1_EGIF **/
union CCP1_EGIF_REG{
	unsigned int reg;
	struct CCP1_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_EGIF (*((volatile union CCP1_EGIF_REG *)0x4000015C))
// modelCCP2

/** 0x4000 01A0 CCP2_C1 **/
union CCP2_C1_REG{
	unsigned int reg;
	struct CCP2_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C1 (*((volatile union CCP2_C1_REG *)0x400001A0))
// model

/** 0x4000 01A4 CCP2_C2 **/
union CCP2_C2_REG{
	unsigned int reg;
	struct CCP2_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C2 (*((volatile union CCP2_C2_REG *)0x400001A4))
// model

/** 0x4000 01A8 CCP2_C3 **/
union CCP2_C3_REG{
	unsigned int reg;
	struct CCP2_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C3 (*((volatile union CCP2_C3_REG *)0x400001A8))
// model

/** 0x4000 01AC CCP2_C4 **/
union CCP2_C4_REG{
	unsigned int reg;
	struct CCP2_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C4 (*((volatile union CCP2_C4_REG *)0x400001AC))
// model

/** 0x4000 01B0 CCP2_SRIC **/
union CCP2_SRIC_REG{
	unsigned int reg;
	struct CCP2_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_SRIC (*((volatile union CCP2_SRIC_REG *)0x400001B0))
// model

/** 0x4000 01B4 CCP2_DF **/
union CCP2_DF_REG{
	unsigned int reg;
	struct CCP2_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_DF (*((volatile union CCP2_DF_REG *)0x400001B4))
// model

/** 0x4000 01C0 CCP2_CTL1 **/
union CCP2_CTL1_REG{
	unsigned int reg;
	struct CCP2_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL1 (*((volatile union CCP2_CTL1_REG *)0x400001C0))
// model

/** 0x4000 01C4 CCP2_R1 **/
union CCP2_R1_REG{
	unsigned int reg;
	struct CCP2_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R1 (*((volatile union CCP2_R1_REG *)0x400001C4))
// model

/** 0x4000 01C8 CCP2_R2 **/
union CCP2_R2_REG{
	unsigned int reg;
	struct CCP2_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R2 (*((volatile union CCP2_R2_REG *)0x400001C8))
// model

/** 0x4000 01CC CCP2_R3 **/
union CCP2_R3_REG{
	unsigned int reg;
	struct CCP2_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R3 (*((volatile union CCP2_R3_REG *)0x400001CC))
// model

/** 0x4000 01D0 CCP2_R4 **/
union CCP2_R4_REG{
	unsigned int reg;
	struct CCP2_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R4 (*((volatile union CCP2_R4_REG *)0x400001D0))
// model

/** 0x4000 01D4 CCP2_CTL2 **/
union CCP2_CTL2_REG{
	unsigned int reg;
	struct CCP2_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL2 (*((volatile union CCP2_CTL2_REG *)0x400001D4))
// model

/** 0x4000 01D8 CCP2_CTL3 **/
union CCP2_CTL3_REG{
	unsigned int reg;
	struct CCP2_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL3 (*((volatile union CCP2_CTL3_REG *)0x400001D8))
// model

/** 0x4000 01DC CCP2_EGIF **/
union CCP2_EGIF_REG{
	unsigned int reg;
	struct CCP2_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_EGIF (*((volatile union CCP2_EGIF_REG *)0x400001DC))
// modelCCP3

/** 0x4000 0220 CCP3_C1 **/
union CCP3_C1_REG{
	unsigned int reg;
	struct CCP3_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C1 (*((volatile union CCP3_C1_REG *)0x40000220))
// model

/** 0x4000 0224 CCP3_C2 **/
union CCP3_C2_REG{
	unsigned int reg;
	struct CCP3_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C2 (*((volatile union CCP3_C2_REG *)0x40000224))
// model

/** 0x4000 0228 CCP3_C3 **/
union CCP3_C3_REG{
	unsigned int reg;
	struct CCP3_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C3 (*((volatile union CCP3_C3_REG *)0x40000228))
// model

/** 0x4000 022C CCP3_C4 **/
union CCP3_C4_REG{
	unsigned int reg;
	struct CCP3_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C4 (*((volatile union CCP3_C4_REG *)0x4000022C))
// model

/** 0x4000 0230 CCP3_SRIC **/
union CCP3_SRIC_REG{
	unsigned int reg;
	struct CCP3_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_SRIC (*((volatile union CCP3_SRIC_REG *)0x40000230))
// model

/** 0x4000 0234 CCP3_DF **/
union CCP3_DF_REG{
	unsigned int reg;
	struct CCP3_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_DF (*((volatile union CCP3_DF_REG *)0x40000234))
// model

/** 0x4000 0240 CCP3_CTL1 **/
union CCP3_CTL1_REG{
	unsigned int reg;
	struct CCP3_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL1 (*((volatile union CCP3_CTL1_REG *)0x40000240))
// model

/** 0x4000 0244 CCP3_R1 **/
union CCP3_R1_REG{
	unsigned int reg;
	struct CCP3_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R1 (*((volatile union CCP3_R1_REG *)0x40000244))
// model

/** 0x4000 0248 CCP3_R2 **/
union CCP3_R2_REG{
	unsigned int reg;
	struct CCP3_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R2 (*((volatile union CCP3_R2_REG *)0x40000248))
// model

/** 0x4000 024C CCP3_R3 **/
union CCP3_R3_REG{
	unsigned int reg;
	struct CCP3_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R3 (*((volatile union CCP3_R3_REG *)0x4000024C))
// model

/** 0x4000 0250 CCP3_R4 **/
union CCP3_R4_REG{
	unsigned int reg;
	struct CCP3_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R4 (*((volatile union CCP3_R4_REG *)0x40000250))
// model

/** 0x4000 0254 CCP3_CTL2 **/
union CCP3_CTL2_REG{
	unsigned int reg;
	struct CCP3_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL2 (*((volatile union CCP3_CTL2_REG *)0x40000254))
// model

/** 0x4000 0258 CCP3_CTL3 **/
union CCP3_CTL3_REG{
	unsigned int reg;
	struct CCP3_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL3 (*((volatile union CCP3_CTL3_REG *)0x40000258))
// model

/** 0x4000 025C CCP3_EGIF **/
union CCP3_EGIF_REG{
	unsigned int reg;
	struct CCP3_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_EGIF (*((volatile union CCP3_EGIF_REG *)0x4000025C))
// modelCCP4

/** 0x4000 02A0 CCP4_C1 **/
union CCP4_C1_REG{
	unsigned int reg;
	struct CCP4_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C1 (*((volatile union CCP4_C1_REG *)0x400002A0))
// model

/** 0x4000 02A4 CCP4_C2 **/
union CCP4_C2_REG{
	unsigned int reg;
	struct CCP4_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C2 (*((volatile union CCP4_C2_REG *)0x400002A4))
// model

/** 0x4000 02A8 CCP4_C3 **/
union CCP4_C3_REG{
	unsigned int reg;
	struct CCP4_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C3 (*((volatile union CCP4_C3_REG *)0x400002A8))
// model

/** 0x4000 02AC CCP4_C4 **/
union CCP4_C4_REG{
	unsigned int reg;
	struct CCP4_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C4 (*((volatile union CCP4_C4_REG *)0x400002AC))
// model

/** 0x4000 02B0 CCP4_SRIC **/
union CCP4_SRIC_REG{
	unsigned int reg;
	struct CCP4_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_SRIC (*((volatile union CCP4_SRIC_REG *)0x400002B0))
// model

/** 0x4000 02B4 CCP4_DF **/
union CCP4_DF_REG{
	unsigned int reg;
	struct CCP4_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_DF (*((volatile union CCP4_DF_REG *)0x400002B4))
// model

/** 0x4000 02C0 CCP4_CTL1 **/
union CCP4_CTL1_REG{
	unsigned int reg;
	struct CCP4_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL1 (*((volatile union CCP4_CTL1_REG *)0x400002C0))
// model

/** 0x4000 02C4 CCP4_R1 **/
union CCP4_R1_REG{
	unsigned int reg;
	struct CCP4_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R1 (*((volatile union CCP4_R1_REG *)0x400002C4))
// model

/** 0x4000 02C8 CCP4_R2 **/
union CCP4_R2_REG{
	unsigned int reg;
	struct CCP4_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R2 (*((volatile union CCP4_R2_REG *)0x400002C8))
// model

/** 0x4000 02CC CCP4_R3 **/
union CCP4_R3_REG{
	unsigned int reg;
	struct CCP4_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R3 (*((volatile union CCP4_R3_REG *)0x400002CC))
// model

/** 0x4000 02D0 CCP4_R4 **/
union CCP4_R4_REG{
	unsigned int reg;
	struct CCP4_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R4 (*((volatile union CCP4_R4_REG *)0x400002D0))
// model

/** 0x4000 02D4 CCP4_CTL2 **/
union CCP4_CTL2_REG{
	unsigned int reg;
	struct CCP4_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL2 (*((volatile union CCP4_CTL2_REG *)0x400002D4))
// model

/** 0x4000 02D8 CCP4_CTL3 **/
union CCP4_CTL3_REG{
	unsigned int reg;
	struct CCP4_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL3 (*((volatile union CCP4_CTL3_REG *)0x400002D8))
// model

/** 0x4000 02DC CCP4_EGIF **/
union CCP4_EGIF_REG{
	unsigned int reg;
	struct CCP4_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_EGIF (*((volatile union CCP4_EGIF_REG *)0x400002DC))
// modelCCP5

/** 0x4000 03A0 CCP5_C1 **/
union CCP5_C1_REG{
	unsigned int reg;
	struct CCP5_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_C1 (*((volatile union CCP5_C1_REG *)0x400003A0))
// model

/** 0x4000 03A4 CCP5_C2 **/
union CCP5_C2_REG{
	unsigned int reg;
	struct CCP5_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_C2 (*((volatile union CCP5_C2_REG *)0x400003A4))
// model

/** 0x4000 03A8 CCP5_C3 **/
union CCP5_C3_REG{
	unsigned int reg;
	struct CCP5_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_C3 (*((volatile union CCP5_C3_REG *)0x400003A8))
// model

/** 0x4000 03AC CCP5_C4 **/
union CCP5_C4_REG{
	unsigned int reg;
	struct CCP5_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_C4 (*((volatile union CCP5_C4_REG *)0x400003AC))
// model

/** 0x4000 03B0 CCP5_SRIC **/
union CCP5_SRIC_REG{
	unsigned int reg;
	struct CCP5_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_SRIC (*((volatile union CCP5_SRIC_REG *)0x400003B0))
// model

/** 0x4000 03B4 CCP5_DF **/
union CCP5_DF_REG{
	unsigned int reg;
	struct CCP5_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_DF (*((volatile union CCP5_DF_REG *)0x400003B4))
// model

/** 0x4000 03C0 CCP5_CTL1 **/
union CCP5_CTL1_REG{
	unsigned int reg;
	struct CCP5_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_CTL1 (*((volatile union CCP5_CTL1_REG *)0x400003C0))
// model

/** 0x4000 03C4 CCP5_R1 **/
union CCP5_R1_REG{
	unsigned int reg;
	struct CCP5_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_R1 (*((volatile union CCP5_R1_REG *)0x400003C4))
// model

/** 0x4000 03C8 CCP5_R2 **/
union CCP5_R2_REG{
	unsigned int reg;
	struct CCP5_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_R2 (*((volatile union CCP5_R2_REG *)0x400003C8))
// model

/** 0x4000 03CC CCP5_R3 **/
union CCP5_R3_REG{
	unsigned int reg;
	struct CCP5_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_R3 (*((volatile union CCP5_R3_REG *)0x400003CC))
// model

/** 0x4000 03D0 CCP5_R4 **/
union CCP5_R4_REG{
	unsigned int reg;
	struct CCP5_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_R4 (*((volatile union CCP5_R4_REG *)0x400003D0))
// model

/** 0x4000 03D4 CCP5_CTL2 **/
union CCP5_CTL2_REG{
	unsigned int reg;
	struct CCP5_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int :2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_CTL2 (*((volatile union CCP5_CTL2_REG *)0x400003D4))
// model

/** 0x4000 03D8 CCP5_CTL3 **/
union CCP5_CTL3_REG{
	unsigned int reg;
	struct CCP5_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_CTL3 (*((volatile union CCP5_CTL3_REG *)0x400003D8))
// model

/** 0x4000 03DC CCP5_EGIF **/
union CCP5_EGIF_REG{
	unsigned int reg;
	struct CCP5_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP5_EGIF (*((volatile union CCP5_EGIF_REG *)0x400003DC))
// modelT11

/** 0x4000 0900 T11_CNT **/
union T11_CNT_REG{
	unsigned int reg;
	struct T11_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CNT (*((volatile union T11_CNT_REG *)0x40000900))
// model

/** 0x4000 0904 T11_PHS **/
union T11_PHS_REG{
	unsigned int reg;
	struct T11_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PHS (*((volatile union T11_PHS_REG *)0x40000904))
// model

/** 0x4000 0908 T11_PPX **/
union T11_PPX_REG{
	unsigned int reg;
	struct T11_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PPX (*((volatile union T11_PPX_REG *)0x40000908))
// model

/** 0x4000 090C T11_PRSC **/
union T11_PRSC_REG{
	unsigned int reg;
	struct T11_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PRSC (*((volatile union T11_PRSC_REG *)0x4000090C))
// model

/** 0x4000 0910 T11_CTL **/
union T11_CTL_REG{
	unsigned int reg;
	struct T11_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int :1;
		unsigned int _ETLOCK:1;
		unsigned int :1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CTL (*((volatile union T11_CTL_REG *)0x40000910))
// modelEPWM11

/** 0x4000 0914 EPWM11_RA **/
union EPWM11_RA_REG{
	unsigned int reg;
	struct EPWM11_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RA (*((volatile union EPWM11_RA_REG *)0x40000914))
// model

/** 0x4000 0918 EPWM11_RB **/
union EPWM11_RB_REG{
	unsigned int reg;
	struct EPWM11_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RB (*((volatile union EPWM11_RB_REG *)0x40000918))
// model

/** 0x4000 091C EPWM11_CTLA **/
union EPWM11_CTLA_REG{
	unsigned int reg;
	struct EPWM11_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _OTSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CTLA (*((volatile union EPWM11_CTLA_REG *)0x4000091C))
// model

/** 0x4000 0920 EPWM11_CTLB **/
union EPWM11_CTLB_REG{
	unsigned int reg;
	struct EPWM11_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CTLB (*((volatile union EPWM11_CTLB_REG *)0x40000920))
// model

/** 0x4000 0924 EPWM11_DBCTL **/
union EPWM11_DBCTL_REG{
	unsigned int reg;
	struct EPWM11_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DBCTL (*((volatile union EPWM11_DBCTL_REG *)0x40000924))
// model

/** 0x4000 0928 EPWM11_DBT **/
union EPWM11_DBT_REG{
	unsigned int reg;
	struct EPWM11_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DBT (*((volatile union EPWM11_DBT_REG *)0x40000928))
// model

/** 0x4000 092C EPWM11_PCCTL **/
union EPWM11_PCCTL_REG{
	unsigned int reg;
	struct EPWM11_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_PCCTL (*((volatile union EPWM11_PCCTL_REG *)0x4000092C))
// model

/** 0x4000 0930 EPWM11_PXASCTL **/
union EPWM11_PXASCTL_REG{
	unsigned int reg;
	struct EPWM11_PXASCTL_BITS{
		unsigned int _PXASS:4;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int _PXASE:1;
		unsigned int _PXAVNEG:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_PXASCTL (*((volatile union EPWM11_PXASCTL_REG *)0x40000930))
// model

/** 0x4000 0934 EPWM11_ETCTL **/
union EPWM11_ETCTL_REG{
	unsigned int reg;
	struct EPWM11_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_ETCTL (*((volatile union EPWM11_ETCTL_REG *)0x40000934))
// model

/** 0x4000 0938 EPWM11_IE **/
union EPWM11_IE_REG{
	unsigned int reg;
	struct EPWM11_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IE (*((volatile union EPWM11_IE_REG *)0x40000938))
// model

/** 0x4000 093C EPWM11_IF **/
union EPWM11_IF_REG{
	unsigned int reg;
	struct EPWM11_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IF (*((volatile union EPWM11_IF_REG *)0x4000093C))
// model

/** 0x4000 0940 EPWM11_IC **/
union EPWM11_IC_REG{
	unsigned int reg;
	struct EPWM11_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IC (*((volatile union EPWM11_IC_REG *)0x40000940))
// model

/** 0x4000 0944 EPWM11_DE **/
union EPWM11_DE_REG{
	unsigned int reg;
	struct EPWM11_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DE (*((volatile union EPWM11_DE_REG *)0x40000944))
// model

/** 0x4000 0948 EPWM11_DF **/
union EPWM11_DF_REG{
	unsigned int reg;
	struct EPWM11_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DF (*((volatile union EPWM11_DF_REG *)0x40000948))
// model

/** 0x4000 0958 EPWM11_CAP **/
union EPWM11_CAP_REG{
	unsigned int reg;
	struct EPWM11_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CAP (*((volatile union EPWM11_CAP_REG *)0x40000958))
// model

/** 0x4000 095C EPWM11_RC **/
union EPWM11_RC_REG{
	unsigned int reg;
	struct EPWM11_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RC (*((volatile union EPWM11_RC_REG *)0x4000095C))
// model

/** 0x4000 0960 EPWM11_RD **/
union EPWM11_RD_REG{
	unsigned int reg;
	struct EPWM11_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RD (*((volatile union EPWM11_RD_REG *)0x40000960))
// model

/** 0x4000 0964 EPWM11_UDCTL **/
union EPWM11_UDCTL_REG{
	unsigned int reg;
	struct EPWM11_UDCTL_BITS{
		unsigned int :27;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_UDCTL (*((volatile union EPWM11_UDCTL_REG *)0x40000964))
// modelT12

/** 0x4000 0A00 T12_CNT **/
union T12_CNT_REG{
	unsigned int reg;
	struct T12_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CNT (*((volatile union T12_CNT_REG *)0x40000A00))
// model

/** 0x4000 0A04 T12_PHS **/
union T12_PHS_REG{
	unsigned int reg;
	struct T12_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PHS (*((volatile union T12_PHS_REG *)0x40000A04))
// model

/** 0x4000 0A08 T12_PPX **/
union T12_PPX_REG{
	unsigned int reg;
	struct T12_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PPX (*((volatile union T12_PPX_REG *)0x40000A08))
// model

/** 0x4000 0A0C T12_PRSC **/
union T12_PRSC_REG{
	unsigned int reg;
	struct T12_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PRSC (*((volatile union T12_PRSC_REG *)0x40000A0C))
// model

/** 0x4000 0A10 T12_CTL **/
union T12_CTL_REG{
	unsigned int reg;
	struct T12_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int :1;
		unsigned int _ETLOCK:1;
		unsigned int :1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CTL (*((volatile union T12_CTL_REG *)0x40000A10))
// modelEPWM12

/** 0x4000 0A14 EPWM12_RA **/
union EPWM12_RA_REG{
	unsigned int reg;
	struct EPWM12_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RA (*((volatile union EPWM12_RA_REG *)0x40000A14))
// model

/** 0x4000 0A18 EPWM12_RB **/
union EPWM12_RB_REG{
	unsigned int reg;
	struct EPWM12_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RB (*((volatile union EPWM12_RB_REG *)0x40000A18))
// model

/** 0x4000 0A1C EPWM12_CTLA **/
union EPWM12_CTLA_REG{
	unsigned int reg;
	struct EPWM12_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CTLA (*((volatile union EPWM12_CTLA_REG *)0x40000A1C))
// model

/** 0x4000 0A20 EPWM12_CTLB **/
union EPWM12_CTLB_REG{
	unsigned int reg;
	struct EPWM12_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CTLB (*((volatile union EPWM12_CTLB_REG *)0x40000A20))
// model

/** 0x4000 0A24 EPWM12_DBCTL **/
union EPWM12_DBCTL_REG{
	unsigned int reg;
	struct EPWM12_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DBCTL (*((volatile union EPWM12_DBCTL_REG *)0x40000A24))
// model

/** 0x4000 0A28 EPWM12_DBT **/
union EPWM12_DBT_REG{
	unsigned int reg;
	struct EPWM12_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DBT (*((volatile union EPWM12_DBT_REG *)0x40000A28))
// model

/** 0x4000 0A2C EPWM12_PCCTL **/
union EPWM12_PCCTL_REG{
	unsigned int reg;
	struct EPWM12_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_PCCTL (*((volatile union EPWM12_PCCTL_REG *)0x40000A2C))
// model

/** 0x4000 0A30 EPWM12_PXASCTL **/
union EPWM12_PXASCTL_REG{
	unsigned int reg;
	struct EPWM12_PXASCTL_BITS{
		unsigned int _PXASS:4;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int _PXASE:1;
		unsigned int _PXAVNEG:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_PXASCTL (*((volatile union EPWM12_PXASCTL_REG *)0x40000A30))
// model

/** 0x4000 0A34 EPWM12_ETCTL **/
union EPWM12_ETCTL_REG{
	unsigned int reg;
	struct EPWM12_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_ETCTL (*((volatile union EPWM12_ETCTL_REG *)0x40000A34))
// model

/** 0x4000 0A38 EPWM12_IE **/
union EPWM12_IE_REG{
	unsigned int reg;
	struct EPWM12_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IE (*((volatile union EPWM12_IE_REG *)0x40000A38))
// model

/** 0x4000 0A3C EPWM12_IF **/
union EPWM12_IF_REG{
	unsigned int reg;
	struct EPWM12_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IF (*((volatile union EPWM12_IF_REG *)0x40000A3C))
// model

/** 0x4000 0A40 EPWM12_IC **/
union EPWM12_IC_REG{
	unsigned int reg;
	struct EPWM12_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IC (*((volatile union EPWM12_IC_REG *)0x40000A40))
// model

/** 0x4000 0A44 EPWM12_DE **/
union EPWM12_DE_REG{
	unsigned int reg;
	struct EPWM12_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DE (*((volatile union EPWM12_DE_REG *)0x40000A44))
// model

/** 0x4000 0A48 EPWM12_DF **/
union EPWM12_DF_REG{
	unsigned int reg;
	struct EPWM12_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DF (*((volatile union EPWM12_DF_REG *)0x40000A48))
// model

/** 0x4000 0A50 EPWM12_HRPWMCTLA **/
union EPWM12_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM12_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRPWMCTLA (*((volatile union EPWM12_HRPWMCTLA_REG *)0x40000A50))
// model

/** 0x4000 0A54 EPWM12_HRCMPA **/
union EPWM12_HRCMPA_REG{
	unsigned int reg;
	struct EPWM12_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRCMPA (*((volatile union EPWM12_HRCMPA_REG *)0x40000A54))
// model

/** 0x4000 0A58 EPWM12_CAP **/
union EPWM12_CAP_REG{
	unsigned int reg;
	struct EPWM12_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CAP (*((volatile union EPWM12_CAP_REG *)0x40000A58))
// model

/** 0x4000 0A5C EPWM12_RC **/
union EPWM12_RC_REG{
	unsigned int reg;
	struct EPWM12_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RC (*((volatile union EPWM12_RC_REG *)0x40000A5C))
// model

/** 0x4000 0A60 EPWM12_RD **/
union EPWM12_RD_REG{
	unsigned int reg;
	struct EPWM12_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RD (*((volatile union EPWM12_RD_REG *)0x40000A60))
// model

/** 0x4000 0A64 EPWM12_UDCTL **/
union EPWM12_UDCTL_REG{
	unsigned int reg;
	struct EPWM12_UDCTL_BITS{
		unsigned int :27;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_UDCTL (*((volatile union EPWM12_UDCTL_REG *)0x40000A64))
// modelT13

/** 0x4000 0B00 T13_CNT **/
union T13_CNT_REG{
	unsigned int reg;
	struct T13_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CNT (*((volatile union T13_CNT_REG *)0x40000B00))
// model

/** 0x4000 0B04 T13_PHS **/
union T13_PHS_REG{
	unsigned int reg;
	struct T13_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PHS (*((volatile union T13_PHS_REG *)0x40000B04))
// model

/** 0x4000 0B08 T13_PPX **/
union T13_PPX_REG{
	unsigned int reg;
	struct T13_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PPX (*((volatile union T13_PPX_REG *)0x40000B08))
// model

/** 0x4000 0B0C T13_PRSC **/
union T13_PRSC_REG{
	unsigned int reg;
	struct T13_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PRSC (*((volatile union T13_PRSC_REG *)0x40000B0C))
// model

/** 0x4000 0B10 T13_CTL **/
union T13_CTL_REG{
	unsigned int reg;
	struct T13_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int :1;
		unsigned int _ETLOCK:1;
		unsigned int :1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CTL (*((volatile union T13_CTL_REG *)0x40000B10))
// modelEPWM13

/** 0x4000 0B14 EPWM13_RA **/
union EPWM13_RA_REG{
	unsigned int reg;
	struct EPWM13_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RA (*((volatile union EPWM13_RA_REG *)0x40000B14))
// model

/** 0x4000 0B18 EPWM13_RB **/
union EPWM13_RB_REG{
	unsigned int reg;
	struct EPWM13_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RB (*((volatile union EPWM13_RB_REG *)0x40000B18))
// model

/** 0x4000 0B1C EPWM13_CTLA **/
union EPWM13_CTLA_REG{
	unsigned int reg;
	struct EPWM13_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CTLA (*((volatile union EPWM13_CTLA_REG *)0x40000B1C))
// model

/** 0x4000 0B20 EPWM13_CTLB **/
union EPWM13_CTLB_REG{
	unsigned int reg;
	struct EPWM13_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CTLB (*((volatile union EPWM13_CTLB_REG *)0x40000B20))
// model

/** 0x4000 0B24 EPWM13_DBCTL **/
union EPWM13_DBCTL_REG{
	unsigned int reg;
	struct EPWM13_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DBCTL (*((volatile union EPWM13_DBCTL_REG *)0x40000B24))
// model

/** 0x4000 0B28 EPWM13_DBT **/
union EPWM13_DBT_REG{
	unsigned int reg;
	struct EPWM13_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DBT (*((volatile union EPWM13_DBT_REG *)0x40000B28))
// model

/** 0x4000 0B2C EPWM13_PCCTL **/
union EPWM13_PCCTL_REG{
	unsigned int reg;
	struct EPWM13_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_PCCTL (*((volatile union EPWM13_PCCTL_REG *)0x40000B2C))
// model

/** 0x4000 0B30 EPWM13_PXASCTL **/
union EPWM13_PXASCTL_REG{
	unsigned int reg;
	struct EPWM13_PXASCTL_BITS{
		unsigned int _PXASS:4;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int _PXASE:1;
		unsigned int _PXAVNEG:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_PXASCTL (*((volatile union EPWM13_PXASCTL_REG *)0x40000B30))
// model

/** 0x4000 0B34 EPWM13_ETCTL **/
union EPWM13_ETCTL_REG{
	unsigned int reg;
	struct EPWM13_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_ETCTL (*((volatile union EPWM13_ETCTL_REG *)0x40000B34))
// model

/** 0x4000 0B38 EPWM13_IE **/
union EPWM13_IE_REG{
	unsigned int reg;
	struct EPWM13_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IE (*((volatile union EPWM13_IE_REG *)0x40000B38))
// model

/** 0x4000 0B3C EPWM13_IF **/
union EPWM13_IF_REG{
	unsigned int reg;
	struct EPWM13_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IF (*((volatile union EPWM13_IF_REG *)0x40000B3C))
// model

/** 0x4000 0B40 EPWM13_IC **/
union EPWM13_IC_REG{
	unsigned int reg;
	struct EPWM13_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IC (*((volatile union EPWM13_IC_REG *)0x40000B40))
// model

/** 0x4000 0B44 EPWM13_DE **/
union EPWM13_DE_REG{
	unsigned int reg;
	struct EPWM13_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DE (*((volatile union EPWM13_DE_REG *)0x40000B44))
// model

/** 0x4000 0B48 EPWM13_DF **/
union EPWM13_DF_REG{
	unsigned int reg;
	struct EPWM13_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DF (*((volatile union EPWM13_DF_REG *)0x40000B48))
// model

/** 0x4000 0B50 EPWM13_HRPWMCTLA **/
union EPWM13_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM13_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRPWMCTLA (*((volatile union EPWM13_HRPWMCTLA_REG *)0x40000B50))
// model

/** 0x4000 0B54 EPWM13_HRCMPA **/
union EPWM13_HRCMPA_REG{
	unsigned int reg;
	struct EPWM13_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRCMPA (*((volatile union EPWM13_HRCMPA_REG *)0x40000B54))
// model

/** 0x4000 0B58 EPWM13_CAP **/
union EPWM13_CAP_REG{
	unsigned int reg;
	struct EPWM13_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CAP (*((volatile union EPWM13_CAP_REG *)0x40000B58))
// model

/** 0x4000 0B5C EPWM13_RC **/
union EPWM13_RC_REG{
	unsigned int reg;
	struct EPWM13_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RC (*((volatile union EPWM13_RC_REG *)0x40000B5C))
// model

/** 0x4000 0B60 EPWM13_RD **/
union EPWM13_RD_REG{
	unsigned int reg;
	struct EPWM13_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RD (*((volatile union EPWM13_RD_REG *)0x40000B60))
// model

/** 0x4000 0B64 EPWM13_UDCTL **/
union EPWM13_UDCTL_REG{
	unsigned int reg;
	struct EPWM13_UDCTL_BITS{
		unsigned int :27;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_UDCTL (*((volatile union EPWM13_UDCTL_REG *)0x40000B64))
// modelT14

/** 0x4000 0C00 T14_CNT **/
union T14_CNT_REG{
	unsigned int reg;
	struct T14_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CNT (*((volatile union T14_CNT_REG *)0x40000C00))
// model

/** 0x4000 0C04 T14_PHS **/
union T14_PHS_REG{
	unsigned int reg;
	struct T14_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PHS (*((volatile union T14_PHS_REG *)0x40000C04))
// model

/** 0x4000 0C08 T14_PPX **/
union T14_PPX_REG{
	unsigned int reg;
	struct T14_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PPX (*((volatile union T14_PPX_REG *)0x40000C08))
// model

/** 0x4000 0C0C T14_PRSC **/
union T14_PRSC_REG{
	unsigned int reg;
	struct T14_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PRSC (*((volatile union T14_PRSC_REG *)0x40000C0C))
// model

/** 0x4000 0C10 T14_CTL **/
union T14_CTL_REG{
	unsigned int reg;
	struct T14_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int :1;
		unsigned int _ETLOCK:1;
		unsigned int :1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL (*((volatile union T14_CTL_REG *)0x40000C10))
// modelEPWM14

/** 0x4000 0C14 EPWM14_RA **/
union EPWM14_RA_REG{
	unsigned int reg;
	struct EPWM14_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_RA (*((volatile union EPWM14_RA_REG *)0x40000C14))
// model

/** 0x4000 0C18 EPWM14_RB **/
union EPWM14_RB_REG{
	unsigned int reg;
	struct EPWM14_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_RB (*((volatile union EPWM14_RB_REG *)0x40000C18))
// model

/** 0x4000 0C1C EPWM14_CTLA **/
union EPWM14_CTLA_REG{
	unsigned int reg;
	struct EPWM14_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_CTLA (*((volatile union EPWM14_CTLA_REG *)0x40000C1C))
// model

/** 0x4000 0C20 EPWM14_CTLB **/
union EPWM14_CTLB_REG{
	unsigned int reg;
	struct EPWM14_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_CTLB (*((volatile union EPWM14_CTLB_REG *)0x40000C20))
// model

/** 0x4000 0C24 EPWM14_DBCTL **/
union EPWM14_DBCTL_REG{
	unsigned int reg;
	struct EPWM14_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_DBCTL (*((volatile union EPWM14_DBCTL_REG *)0x40000C24))
// model

/** 0x4000 0C28 EPWM14_DBT **/
union EPWM14_DBT_REG{
	unsigned int reg;
	struct EPWM14_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_DBT (*((volatile union EPWM14_DBT_REG *)0x40000C28))
// model

/** 0x4000 0C2C EPWM14_PCCTL **/
union EPWM14_PCCTL_REG{
	unsigned int reg;
	struct EPWM14_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_PCCTL (*((volatile union EPWM14_PCCTL_REG *)0x40000C2C))
// model

/** 0x4000 0C30 EPWM14_PXASCTL **/
union EPWM14_PXASCTL_REG{
	unsigned int reg;
	struct EPWM14_PXASCTL_BITS{
		unsigned int _PXASS:4;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int _PXASE:1;
		unsigned int _PXAVNEG:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_PXASCTL (*((volatile union EPWM14_PXASCTL_REG *)0x40000C30))
// model

/** 0x4000 0C34 EPWM14_ETCTL **/
union EPWM14_ETCTL_REG{
	unsigned int reg;
	struct EPWM14_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_ETCTL (*((volatile union EPWM14_ETCTL_REG *)0x40000C34))
// model

/** 0x4000 0C38 EPWM14_IE **/
union EPWM14_IE_REG{
	unsigned int reg;
	struct EPWM14_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_IE (*((volatile union EPWM14_IE_REG *)0x40000C38))
// model

/** 0x4000 0C3C EPWM14_IF **/
union EPWM14_IF_REG{
	unsigned int reg;
	struct EPWM14_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_IF (*((volatile union EPWM14_IF_REG *)0x40000C3C))
// model

/** 0x4000 0C40 EPWM14_IC **/
union EPWM14_IC_REG{
	unsigned int reg;
	struct EPWM14_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_IC (*((volatile union EPWM14_IC_REG *)0x40000C40))
// model

/** 0x4000 0C44 EPWM14_DE **/
union EPWM14_DE_REG{
	unsigned int reg;
	struct EPWM14_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_DE (*((volatile union EPWM14_DE_REG *)0x40000C44))
// model

/** 0x4000 0C48 EPWM14_DF **/
union EPWM14_DF_REG{
	unsigned int reg;
	struct EPWM14_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_DF (*((volatile union EPWM14_DF_REG *)0x40000C48))
// model

/** 0x4000 0C50 EPWM14_HRPWMCTLA **/
union EPWM14_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM14_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_HRPWMCTLA (*((volatile union EPWM14_HRPWMCTLA_REG *)0x40000C50))
// model

/** 0x4000 0C54 EPWM14_HRCMPA **/
union EPWM14_HRCMPA_REG{
	unsigned int reg;
	struct EPWM14_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_HRCMPA (*((volatile union EPWM14_HRCMPA_REG *)0x40000C54))
// model

/** 0x4000 0C58 EPWM14_CAP **/
union EPWM14_CAP_REG{
	unsigned int reg;
	struct EPWM14_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_CAP (*((volatile union EPWM14_CAP_REG *)0x40000C58))
// model

/** 0x4000 0C5C EPWM14_RC **/
union EPWM14_RC_REG{
	unsigned int reg;
	struct EPWM14_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_RC (*((volatile union EPWM14_RC_REG *)0x40000C5C))
// model

/** 0x4000 0C60 EPWM14_RD **/
union EPWM14_RD_REG{
	unsigned int reg;
	struct EPWM14_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_RD (*((volatile union EPWM14_RD_REG *)0x40000C60))
// model

/** 0x4000 0C64 EPWM14_UDCTL **/
union EPWM14_UDCTL_REG{
	unsigned int reg;
	struct EPWM14_UDCTL_BITS{
		unsigned int :27;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM14_UDCTL (*((volatile union EPWM14_UDCTL_REG *)0x40000C64))
// modelADC

/** 0x4000 0400 ADC_CTL0 **/
union ADC_CTL0_REG{
	unsigned int reg;
	struct ADC_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :3;
		unsigned int _DIV_SEL:1;
		unsigned int _ADCCLKS:4;
		unsigned int :1;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_CTL0 (*((volatile union ADC_CTL0_REG *)0x40000400))
// model

/** 0x4000 0404 ADC_CTL1 **/
union ADC_CTL1_REG{
	unsigned int reg;
	struct ADC_CTL1_BITS{
		unsigned int _NOVMODEN:1;
		unsigned int :1;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :1;
		unsigned int _NOVIF:1;
		unsigned int _NOVIC:1;
		unsigned int _NOVIE:1;
		unsigned int :1;
		unsigned int _REFSEL:2;
		unsigned int :1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_CTL1 (*((volatile union ADC_CTL1_REG *)0x40000404))
// model

/** 0x4000 0408 ADC_SCANSQ0 **/
union ADC_SCANSQ0_REG{
	unsigned int reg;
	struct ADC_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_SCANSQ0 (*((volatile union ADC_SCANSQ0_REG *)0x40000408))
// model

/** 0x4000 040C ADC_SCANSQ1 **/
union ADC_SCANSQ1_REG{
	unsigned int reg;
	struct ADC_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_SCANSQ1 (*((volatile union ADC_SCANSQ1_REG *)0x4000040C))
// model

/** 0x4000 0410 ADC_SCANSQ2 **/
union ADC_SCANSQ2_REG{
	unsigned int reg;
	struct ADC_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_SCANSQ2 (*((volatile union ADC_SCANSQ2_REG *)0x40000410))
// model

/** 0x4000 0444 ADC_SCANSQ3 **/
union ADC_SCANSQ3_REG{
	unsigned int reg;
	struct ADC_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_SCANSQ3 (*((volatile union ADC_SCANSQ3_REG *)0x40000444))
// model

/** 0x4000 0414 ADC_HSCANSQ **/
union ADC_HSCANSQ_REG{
	unsigned int reg;
	struct ADC_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HSCANSQ (*((volatile union ADC_HSCANSQ_REG *)0x40000414))
// model

/** 0x4000 0418 ADC_WDH **/
union ADC_WDH_REG{
	unsigned int reg;
	struct ADC_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_WDH (*((volatile union ADC_WDH_REG *)0x40000418))
// model

/** 0x4000 041C ADC_WDL **/
union ADC_WDL_REG{
	unsigned int reg;
	struct ADC_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_WDL (*((volatile union ADC_WDL_REG *)0x4000041C))
// model

/** 0x4000 0420 ADC_DATA **/
union ADC_DATA_REG{
	unsigned int reg;
	struct ADC_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_DATA (*((volatile union ADC_DATA_REG *)0x40000420))
// model

/** 0x4000 0424 ADC_HPDATA0 **/
union ADC_HPDATA0_REG{
	unsigned int reg;
	struct ADC_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA0 (*((volatile union ADC_HPDATA0_REG *)0x40000424))
// model

/** 0x4000 0428 ADC_HPDATA1 **/
union ADC_HPDATA1_REG{
	unsigned int reg;
	struct ADC_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA1 (*((volatile union ADC_HPDATA1_REG *)0x40000428))
// model

/** 0x4000 042C ADC_HPDATA2 **/
union ADC_HPDATA2_REG{
	unsigned int reg;
	struct ADC_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA2 (*((volatile union ADC_HPDATA2_REG *)0x4000042C))
// model

/** 0x4000 0430 ADC_HPDATA3 **/
union ADC_HPDATA3_REG{
	unsigned int reg;
	struct ADC_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA3 (*((volatile union ADC_HPDATA3_REG *)0x40000430))
// model

/** 0x4000 0434 ADC_HPOFF0 **/
union ADC_HPOFF0_REG{
	unsigned int reg;
	struct ADC_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF0 (*((volatile union ADC_HPOFF0_REG *)0x40000434))
// model

/** 0x4000 0438 ADC_HPOFF1 **/
union ADC_HPOFF1_REG{
	unsigned int reg;
	struct ADC_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF1 (*((volatile union ADC_HPOFF1_REG *)0x40000438))
// model

/** 0x4000 043C ADC_HPOFF2 **/
union ADC_HPOFF2_REG{
	unsigned int reg;
	struct ADC_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF2 (*((volatile union ADC_HPOFF2_REG *)0x4000043C))
// model

/** 0x4000 0440 ADC_HPOFF3 **/
union ADC_HPOFF3_REG{
	unsigned int reg;
	struct ADC_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF3 (*((volatile union ADC_HPOFF3_REG *)0x40000440))
// model

/** 0x4000 0450 ADC_STATE **/
union ADC_STATE_REG{
	unsigned int reg;
	struct ADC_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _EOC2IE:1;
		unsigned int _EOC2IC:1;
		unsigned int _EOC2IF:1;
		unsigned int _S2_IF:1;
		unsigned int _S1_IF:1;
		unsigned int :8;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int :2;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_STATE (*((volatile union ADC_STATE_REG *)0x40000450))
// model

/** 0x4000 0458 ADC_SCANCTL **/
union ADC_SCANCTL_REG{
	unsigned int reg;
	struct ADC_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:3;
		unsigned int :1;
		unsigned int _NCHNUB:5;
		unsigned int :3;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_SCANCTL (*((volatile union ADC_SCANCTL_REG *)0x40000458))
// model

/** 0x4000 0460 ADC_HPDATA4 **/
union ADC_HPDATA4_REG{
	unsigned int reg;
	struct ADC_HPDATA4_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA4 (*((volatile union ADC_HPDATA4_REG *)0x40000460))
// model

/** 0x4000 0464 ADC_HPDATA5 **/
union ADC_HPDATA5_REG{
	unsigned int reg;
	struct ADC_HPDATA5_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA5 (*((volatile union ADC_HPDATA5_REG *)0x40000464))
// model

/** 0x4000 0468 ADC_HPDATA6 **/
union ADC_HPDATA6_REG{
	unsigned int reg;
	struct ADC_HPDATA6_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA6 (*((volatile union ADC_HPDATA6_REG *)0x40000468))
// model

/** 0x4000 046C ADC_HPDATA7 **/
union ADC_HPDATA7_REG{
	unsigned int reg;
	struct ADC_HPDATA7_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPDATA7 (*((volatile union ADC_HPDATA7_REG *)0x4000046C))
// model

/** 0x4000 0470 ADC_HPOFF4 **/
union ADC_HPOFF4_REG{
	unsigned int reg;
	struct ADC_HPOFF4_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF4 (*((volatile union ADC_HPOFF4_REG *)0x40000470))
// model

/** 0x4000 0474 ADC_HPOFF5 **/
union ADC_HPOFF5_REG{
	unsigned int reg;
	struct ADC_HPOFF5_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF5 (*((volatile union ADC_HPOFF5_REG *)0x40000474))
// model

/** 0x4000 0478 ADC_HPOFF6 **/
union ADC_HPOFF6_REG{
	unsigned int reg;
	struct ADC_HPOFF6_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF6 (*((volatile union ADC_HPOFF6_REG *)0x40000478))
// model

/** 0x4000 047C ADC_HPOFF7 **/
union ADC_HPOFF7_REG{
	unsigned int reg;
	struct ADC_HPOFF7_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HPOFF7 (*((volatile union ADC_HPOFF7_REG *)0x4000047C))
// model

/** 0x4000 0480 ADC_HSCANSQ1 **/
union ADC_HSCANSQ1_REG{
	unsigned int reg;
	struct ADC_HSCANSQ1_BITS{
		unsigned int _HSSQ4:8;
		unsigned int _HSSQ5:8;
		unsigned int _HSSQ6:8;
		unsigned int _HSSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_HSCANSQ1 (*((volatile union ADC_HSCANSQ1_REG *)0x40000480))
// model

/** 0x4000 0484 ADC_CTL2 **/
union ADC_CTL2_REG{
	unsigned int reg;
	struct ADC_CTL2_BITS{
		unsigned int _HP4DMAEN:1;
		unsigned int _HP5DMAEN:1;
		unsigned int _HP6DMAEN:1;
		unsigned int _HP7DMAEN:1;
		unsigned int _S2_IE:1;
		unsigned int _S2_IC:1;
		unsigned int _S1_IE:1;
		unsigned int _S1_IC:1;
		unsigned int _EOC_CNT_IC:1;
		unsigned int _EOC_CNT:2;
		unsigned int _HPSTART_1:1;
		unsigned int _SOCASEL1:2;
		unsigned int _SOCASEL0:2;
		unsigned int :2;
		unsigned int _CHBSHTIME:4;
		unsigned int :1;
		unsigned int _CHASHTIME:4;
		unsigned int :3;
		unsigned int _MCMODE:1;
		unsigned int _RMODE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC_CTL2 (*((volatile union ADC_CTL2_REG *)0x40000484))
// modelDAC0

/** 0x4000 1B00 DAC0_CTL **/
union DAC0_CTL_REG{
	unsigned int reg;
	struct DAC0_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL (*((volatile union DAC0_CTL_REG *)0x40001B00))
// model

/** 0x4000 1B04 DAC0_DAHD **/
union DAC0_DAHD_REG{
	unsigned int reg;
	struct DAC0_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DAHD (*((volatile union DAC0_DAHD_REG *)0x40001B04))
// model

/** 0x4000 1B08 DAC0_DATA **/
union DAC0_DATA_REG{
	unsigned int reg;
	struct DAC0_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DATA (*((volatile union DAC0_DATA_REG *)0x40001B08))
// model

/** 0x4000 1B0C DAC0_CTL1 **/
union DAC0_CTL1_REG{
	unsigned int reg;
	struct DAC0_CTL1_BITS{
		unsigned int _SEL:2;
		unsigned int _RFS:2;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :2;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL1 (*((volatile union DAC0_CTL1_REG *)0x40001B0C))
// model

/** 0x4000 1B14 DAC0_CAL **/
union DAC0_CAL_REG{
	unsigned int reg;
	struct DAC0_CAL_BITS{
		unsigned int _TPEN:1;
		unsigned int _TP:2;
		unsigned int :10;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CAL (*((volatile union DAC0_CAL_REG *)0x40001B14))
// modelCMP

/** 0x4000 0380 CMP_CTL0 **/
union CMP_CTL0_REG{
	unsigned int reg;
	struct CMP_CTL0_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL0 (*((volatile union CMP_CTL0_REG *)0x40000380))
// model

/** 0x4000 0384 CMP_CTL1 **/
union CMP_CTL1_REG{
	unsigned int reg;
	struct CMP_CTL1_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL1 (*((volatile union CMP_CTL1_REG *)0x40000384))
// model

/** 0x4000 0388 CMP_CTL2 **/
union CMP_CTL2_REG{
	unsigned int reg;
	struct CMP_CTL2_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL2 (*((volatile union CMP_CTL2_REG *)0x40000388))
// model

/** 0x4000 038C CMP_CTL3 **/
union CMP_CTL3_REG{
	unsigned int reg;
	struct CMP_CTL3_BITS{
		unsigned int _EN:1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL3 (*((volatile union CMP_CTL3_REG *)0x4000038C))
// model

/** 0x4000 0390 CMP_CTL4 **/
union CMP_CTL4_REG{
	unsigned int reg;
	struct CMP_CTL4_BITS{
		unsigned int _C0EN:1;
		unsigned int _C1EN:1;
		unsigned int _C2EN:1;
		unsigned int _FLTINSEL:1;
		unsigned int _BEMFEN:1;
		unsigned int _HALLSEL:1;
		unsigned int _DELAYVOL:2;
		unsigned int _CMPOUTDSEL:2;
		unsigned int _IOEN:1;
		unsigned int _CMP3ANALOGOUTEN:1;
		unsigned int _C0IE:1;
		unsigned int _C1IE:1;
		unsigned int _C2IE:1;
		unsigned int _C3IE:1;
		unsigned int _C0IC:1;
		unsigned int _C1IC:1;
		unsigned int _C2IC:1;
		unsigned int _C3IC:1;
		unsigned int _CMPOUTASEL:2;
		unsigned int _PWMCMP:1;
		unsigned int _CIFMS:1;
		unsigned int _C0IF:1;
		unsigned int _C1IF:1;
		unsigned int _C2IF:1;
		unsigned int _C3IF:1;
		unsigned int _C0OUT:1;
		unsigned int _C1OUT:1;
		unsigned int _C2OUT:1;
		unsigned int _C3OUT:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL4 (*((volatile union CMP_CTL4_REG *)0x40000390))
// model

/** 0x4000 0394 CMP_CTL5 **/
union CMP_CTL5_REG{
	unsigned int reg;
	struct CMP_CTL5_BITS{
		unsigned int :8;
		unsigned int _CMPLPEN:1;
		unsigned int :19;
		unsigned int _COPSEL:2;
		unsigned int _MOTORSEL:1;
		unsigned int _INSCM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL5 (*((volatile union CMP_CTL5_REG *)0x40000394))
// model

/** 0x4000 0398 CMP_TRIM0 **/
union CMP_TRIM0_REG{
	unsigned int reg;
	struct CMP_TRIM0_BITS{
		unsigned int _C0TRIMNPOL:1;
		unsigned int _C0TRIMN:6;
		unsigned int _C0TRIMPPOL:1;
		unsigned int _C0TRIMP:6;
		unsigned int :16;
		unsigned int _CMPTRIMLOWEN:1;
		unsigned int _CMPTRIMHIGHEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM0 (*((volatile union CMP_TRIM0_REG *)0x40000398))
// model

/** 0x4000 039C CMP_TRIM1 **/
union CMP_TRIM1_REG{
	unsigned int reg;
	struct CMP_TRIM1_BITS{
		unsigned int _C1TRIMNPOL:1;
		unsigned int _C1TRIMN:6;
		unsigned int _C1TRIMPPOL:1;
		unsigned int _C1TRIMP:6;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM1 (*((volatile union CMP_TRIM1_REG *)0x4000039C))
// model

/** 0x4000 03A0 CMP_TRIM2 **/
union CMP_TRIM2_REG{
	unsigned int reg;
	struct CMP_TRIM2_BITS{
		unsigned int _C2TRIMNPOL:1;
		unsigned int _C2TRIMN:6;
		unsigned int _C2TRIMPPOL:1;
		unsigned int _C2TRIMP:6;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM2 (*((volatile union CMP_TRIM2_REG *)0x400003A0))
// model

/** 0x4000 03A4 CMP_TRIM3 **/
union CMP_TRIM3_REG{
	unsigned int reg;
	struct CMP_TRIM3_BITS{
		unsigned int _C3TRIMNPOL:1;
		unsigned int _C3TRIMN:6;
		unsigned int _C3TRIMPPOL:1;
		unsigned int _C3TRIMP:6;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM3 (*((volatile union CMP_TRIM3_REG *)0x400003A4))
// modelUSART0

/** 0x4000 0500 USART0_CTLR **/
union USART0_CTLR_REG{
	unsigned int reg;
	struct USART0_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int :1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :3;
		unsigned int _RESHD:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_CTLR (*((volatile union USART0_CTLR_REG *)0x40000500))
// model

/** 0x4000 0504 USART0_BRGR **/
union USART0_BRGR_REG{
	unsigned int reg;
	struct USART0_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_BRGR (*((volatile union USART0_BRGR_REG *)0x40000504))
// model

/** 0x4000 0508 USART0_STR **/
union USART0_STR_REG{
	unsigned int reg;
	struct USART0_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int :2;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_STR (*((volatile union USART0_STR_REG *)0x40000508))
// model

/** 0x4000 050C USART0_TBUFR **/
union USART0_TBUFR_REG{
	unsigned int reg;
	struct USART0_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_TBUFR (*((volatile union USART0_TBUFR_REG *)0x4000050C))
// model

/** 0x4000 050C USART0_RBUFR **/
union USART0_RBUFR_REG{
	unsigned int reg;
	struct USART0_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_RBUFR (*((volatile union USART0_RBUFR_REG *)0x4000050C))
// model

/** 0x4000 0514 USART0_IER **/
union USART0_IER_REG{
	unsigned int reg;
	struct USART0_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int :2;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_IER (*((volatile union USART0_IER_REG *)0x40000514))
// model

/** 0x4000 0518 USART0_ADM **/
union USART0_ADM_REG{
	unsigned int reg;
	struct USART0_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_ADM (*((volatile union USART0_ADM_REG *)0x40000518))
// modelUSART1

/** 0x4000 0580 USART1_CTLR **/
union USART1_CTLR_REG{
	unsigned int reg;
	struct USART1_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int :1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :3;
		unsigned int _RESHD:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_CTLR (*((volatile union USART1_CTLR_REG *)0x40000580))
// model

/** 0x4000 0584 USART1_BRGR **/
union USART1_BRGR_REG{
	unsigned int reg;
	struct USART1_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_BRGR (*((volatile union USART1_BRGR_REG *)0x40000584))
// model

/** 0x4000 0588 USART1_STR **/
union USART1_STR_REG{
	unsigned int reg;
	struct USART1_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int :2;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_STR (*((volatile union USART1_STR_REG *)0x40000588))
// model

/** 0x4000 058C USART1_TBUFR **/
union USART1_TBUFR_REG{
	unsigned int reg;
	struct USART1_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_TBUFR (*((volatile union USART1_TBUFR_REG *)0x4000058C))
// model

/** 0x4000 058C USART1_RBUFR **/
union USART1_RBUFR_REG{
	unsigned int reg;
	struct USART1_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_RBUFR (*((volatile union USART1_RBUFR_REG *)0x4000058C))
// model

/** 0x4000 0594 USART1_IER **/
union USART1_IER_REG{
	unsigned int reg;
	struct USART1_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int :2;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_IER (*((volatile union USART1_IER_REG *)0x40000594))
// model

/** 0x4000 0598 USART1_ADM **/
union USART1_ADM_REG{
	unsigned int reg;
	struct USART1_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_ADM (*((volatile union USART1_ADM_REG *)0x40000598))
// modelUSART2

/** 0x4000 0600 USART2_CTLR **/
union USART2_CTLR_REG{
	unsigned int reg;
	struct USART2_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int :1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :3;
		unsigned int _RESHD:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_CTLR (*((volatile union USART2_CTLR_REG *)0x40000600))
// model

/** 0x4000 0604 USART2_BRGR **/
union USART2_BRGR_REG{
	unsigned int reg;
	struct USART2_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_BRGR (*((volatile union USART2_BRGR_REG *)0x40000604))
// model

/** 0x4000 0608 USART2_STR **/
union USART2_STR_REG{
	unsigned int reg;
	struct USART2_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int :2;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_STR (*((volatile union USART2_STR_REG *)0x40000608))
// model

/** 0x4000 060C USART2_TBUFR **/
union USART2_TBUFR_REG{
	unsigned int reg;
	struct USART2_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_TBUFR (*((volatile union USART2_TBUFR_REG *)0x4000060C))
// model

/** 0x4000 060C USART2_RBUFR **/
union USART2_RBUFR_REG{
	unsigned int reg;
	struct USART2_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_RBUFR (*((volatile union USART2_RBUFR_REG *)0x4000060C))
// model

/** 0x4000 0614 USART2_IER **/
union USART2_IER_REG{
	unsigned int reg;
	struct USART2_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int :2;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_IER (*((volatile union USART2_IER_REG *)0x40000614))
// model

/** 0x4000 0618 USART2_ADM **/
union USART2_ADM_REG{
	unsigned int reg;
	struct USART2_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_ADM (*((volatile union USART2_ADM_REG *)0x40000618))
// modelUSART3

/** 0x4000 0680 USART3_CTLR **/
union USART3_CTLR_REG{
	unsigned int reg;
	struct USART3_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int :1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :3;
		unsigned int _RESHD:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_CTLR (*((volatile union USART3_CTLR_REG *)0x40000680))
// model

/** 0x4000 0684 USART3_BRGR **/
union USART3_BRGR_REG{
	unsigned int reg;
	struct USART3_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_BRGR (*((volatile union USART3_BRGR_REG *)0x40000684))
// model

/** 0x4000 0688 USART3_STR **/
union USART3_STR_REG{
	unsigned int reg;
	struct USART3_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int :2;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_STR (*((volatile union USART3_STR_REG *)0x40000688))
// model

/** 0x4000 068C USART3_TBUFR **/
union USART3_TBUFR_REG{
	unsigned int reg;
	struct USART3_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_TBUFR (*((volatile union USART3_TBUFR_REG *)0x4000068C))
// model

/** 0x4000 068C USART3_RBUFR **/
union USART3_RBUFR_REG{
	unsigned int reg;
	struct USART3_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_RBUFR (*((volatile union USART3_RBUFR_REG *)0x4000068C))
// model

/** 0x4000 0694 USART3_IER **/
union USART3_IER_REG{
	unsigned int reg;
	struct USART3_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int :2;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_IER (*((volatile union USART3_IER_REG *)0x40000694))
// model

/** 0x4000 0698 USART3_ADM **/
union USART3_ADM_REG{
	unsigned int reg;
	struct USART3_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_ADM (*((volatile union USART3_ADM_REG *)0x40000698))
// modelSPI0

/** 0x4000 0700 SPI0_BRGR **/
union SPI0_BRGR_REG{
	unsigned int reg;
	struct SPI0_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BRGR (*((volatile union SPI0_BRGR_REG *)0x40000700))
// model

/** 0x4000 0704 SPI0_CTLR **/
union SPI0_CTLR_REG{
	unsigned int reg;
	struct SPI0_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_CTLR (*((volatile union SPI0_CTLR_REG *)0x40000704))
// model

/** 0x4000 0708 SPI0_BUFR **/
union SPI0_BUFR_REG{
	unsigned int reg;
	struct SPI0_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BUFR (*((volatile union SPI0_BUFR_REG *)0x40000708))
// model

/** 0x4000 070C SPI0_STR **/
union SPI0_STR_REG{
	unsigned int reg;
	struct SPI0_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int :1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int _TSTOP:1;
		unsigned int :2;
		unsigned int _TSTOPIE:1;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int _TSTOPIC:1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_STR (*((volatile union SPI0_STR_REG *)0x4000070C))
// model

/** 0x4000 0718 SPI0_PPX **/
union SPI0_PPX_REG{
	unsigned int reg;
	struct SPI0_PPX_BITS{
		unsigned int _SPIPPX:16;
		unsigned int :14;
		unsigned int _CSDELAYEND:1;
		unsigned int _TESTEN_CSDELAY:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_PPX (*((volatile union SPI0_PPX_REG *)0x40000718))
// modelSPI1

/** 0x4000 0780 SPI1_BRGR **/
union SPI1_BRGR_REG{
	unsigned int reg;
	struct SPI1_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BRGR (*((volatile union SPI1_BRGR_REG *)0x40000780))
// model

/** 0x4000 0784 SPI1_CTLR **/
union SPI1_CTLR_REG{
	unsigned int reg;
	struct SPI1_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_CTLR (*((volatile union SPI1_CTLR_REG *)0x40000784))
// model

/** 0x4000 0788 SPI1_BUFR **/
union SPI1_BUFR_REG{
	unsigned int reg;
	struct SPI1_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BUFR (*((volatile union SPI1_BUFR_REG *)0x40000788))
// model

/** 0x4000 078C SPI1_STR **/
union SPI1_STR_REG{
	unsigned int reg;
	struct SPI1_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int :1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int _TSTOP:1;
		unsigned int :2;
		unsigned int _TSTOPIE:1;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int _TSTOPIC:1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_STR (*((volatile union SPI1_STR_REG *)0x4000078C))
// model

/** 0x4000 0798 SPI1_PPX **/
union SPI1_PPX_REG{
	unsigned int reg;
	struct SPI1_PPX_BITS{
		unsigned int _SPIPPX:16;
		unsigned int :14;
		unsigned int _CSDELAYEND:1;
		unsigned int _TESTEN_CSDELAY:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_PPX (*((volatile union SPI1_PPX_REG *)0x40000798))
// modelI2C0

/** 0x4000 0800 I2C0_CTLR **/
union I2C0_CTLR_REG{
	unsigned int reg;
	struct I2C0_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _MENA:1;
		unsigned int :8;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_CTLR (*((volatile union I2C0_CTLR_REG *)0x40000800))
// model

/** 0x4000 0804 I2C0_SR **/
union I2C0_SR_REG{
	unsigned int reg;
	struct I2C0_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int :3;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :1;
		unsigned int _BLTF:1;
		unsigned int :2;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_SR (*((volatile union I2C0_SR_REG *)0x40000804))
// model

/** 0x4000 0808 I2C0_BUFR **/
union I2C0_BUFR_REG{
	unsigned int reg;
	struct I2C0_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BUFR (*((volatile union I2C0_BUFR_REG *)0x40000808))
// model

/** 0x4000 080C I2C0_ADDR0 **/
union I2C0_ADDR0_REG{
	unsigned int reg;
	struct I2C0_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR0 (*((volatile union I2C0_ADDR0_REG *)0x4000080C))
// model

/** 0x4000 0810 I2C0_BRGR **/
union I2C0_BRGR_REG{
	unsigned int reg;
	struct I2C0_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BRGR (*((volatile union I2C0_BRGR_REG *)0x40000810))
// model

/** 0x4000 0814 I2C0_ADDR1 **/
union I2C0_ADDR1_REG{
	unsigned int reg;
	struct I2C0_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR1 (*((volatile union I2C0_ADDR1_REG *)0x40000814))
// model

/** 0x4000 0818 I2C0_ADDR2 **/
union I2C0_ADDR2_REG{
	unsigned int reg;
	struct I2C0_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR2 (*((volatile union I2C0_ADDR2_REG *)0x40000818))
// model

/** 0x4000 081C I2C0_ADDR3 **/
union I2C0_ADDR3_REG{
	unsigned int reg;
	struct I2C0_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR3 (*((volatile union I2C0_ADDR3_REG *)0x4000081C))
// model

/** 0x4000 0820 I2C0_IER **/
union I2C0_IER_REG{
	unsigned int reg;
	struct I2C0_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :4;
		unsigned int _ISIE:1;
		unsigned int :2;
		unsigned int _SDATEN:1;
		unsigned int _BLTIE:1;
		unsigned int :2;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int _BUSLOW:12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_IER (*((volatile union I2C0_IER_REG *)0x40000820))
// modelI2C1

/** 0x4000 0880 I2C1_CTLR **/
union I2C1_CTLR_REG{
	unsigned int reg;
	struct I2C1_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _MENA:1;
		unsigned int :8;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_CTLR (*((volatile union I2C1_CTLR_REG *)0x40000880))
// model

/** 0x4000 0884 I2C1_SR **/
union I2C1_SR_REG{
	unsigned int reg;
	struct I2C1_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int :3;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :1;
		unsigned int _BLTF:1;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int :2;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_SR (*((volatile union I2C1_SR_REG *)0x40000884))
// model

/** 0x4000 0888 I2C1_BUFR **/
union I2C1_BUFR_REG{
	unsigned int reg;
	struct I2C1_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BUFR (*((volatile union I2C1_BUFR_REG *)0x40000888))
// model

/** 0x4000 088C I2C1_ADDR0 **/
union I2C1_ADDR0_REG{
	unsigned int reg;
	struct I2C1_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR0 (*((volatile union I2C1_ADDR0_REG *)0x4000088C))
// model

/** 0x4000 0890 I2C1_BRGR **/
union I2C1_BRGR_REG{
	unsigned int reg;
	struct I2C1_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BRGR (*((volatile union I2C1_BRGR_REG *)0x40000890))
// model

/** 0x4000 0894 I2C1_ADDR1 **/
union I2C1_ADDR1_REG{
	unsigned int reg;
	struct I2C1_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR1 (*((volatile union I2C1_ADDR1_REG *)0x40000894))
// model

/** 0x4000 0898 I2C1_ADDR2 **/
union I2C1_ADDR2_REG{
	unsigned int reg;
	struct I2C1_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR2 (*((volatile union I2C1_ADDR2_REG *)0x40000898))
// model

/** 0x4000 089C I2C1_ADDR3 **/
union I2C1_ADDR3_REG{
	unsigned int reg;
	struct I2C1_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR3 (*((volatile union I2C1_ADDR3_REG *)0x4000089C))
// model

/** 0x4000 08A0 I2C1_IER **/
union I2C1_IER_REG{
	unsigned int reg;
	struct I2C1_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :4;
		unsigned int _ISIE:1;
		unsigned int :2;
		unsigned int _SDATEN:1;
		unsigned int _BLTIE:1;
		unsigned int :2;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int _BUSLOW:12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_IER (*((volatile union I2C1_IER_REG *)0x400008A0))
// modelIWDT

/** 0x4000 0E00 IWDT_CTL **/
union IWDT_CTL_REG{
	unsigned int reg;
	struct IWDT_CTL_BITS{
		unsigned int _IWDTPS:4;
		unsigned int _IWDTOVF:12;
		unsigned int :13;
		unsigned int _CLKS:1;
		unsigned int :1;
		unsigned int _IWDTEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_CTL (*((volatile union IWDT_CTL_REG *)0x40000E00))
// model

/** 0x4000 0E04 IWDT_FD **/
union IWDT_FD_REG{
	unsigned int reg;
	struct IWDT_FD_BITS{
		unsigned int _IWDTFD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_FD (*((volatile union IWDT_FD_REG *)0x40000E04))
// modelWWDT

/** 0x4000 0E80 WWDT_CTL **/
union WWDT_CTL_REG{
	unsigned int reg;
	struct WWDT_CTL_BITS{
		unsigned int _WWDTEN:1;
		unsigned int _WWDTIE:1;
		unsigned int _WWDTIF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WWDTIC:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL (*((volatile union WWDT_CTL_REG *)0x40000E80))
// model

/** 0x4000 0E84 WWDT_CNT **/
union WWDT_CNT_REG{
	unsigned int reg;
	struct WWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CNT (*((volatile union WWDT_CNT_REG *)0x40000E84))
// model

/** 0x4000 0E88 WWDT_CTL1 **/
union WWDT_CTL1_REG{
	unsigned int reg;
	struct WWDT_CTL1_BITS{
		unsigned int _CLKS:2;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL1 (*((volatile union WWDT_CTL1_REG *)0x40000E88))
// modelEWDT

/** 0x4000 0F00 EWDT_CTL **/
union EWDT_CTL_REG{
	unsigned int reg;
	struct EWDT_CTL_BITS{
		unsigned int _EWDTEN:1;
		unsigned int _WT40IE:1;
		unsigned int _WT40IF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WT40IC:1;
		unsigned int _EWDTINEN:1;
		unsigned int _EWDTINPOL:1;
		unsigned int _CLK:2;
		unsigned int :1;
		unsigned int _EWDTRSTIE:1;
		unsigned int _EWDTRSTIC:1;
		unsigned int _EWDTRSTIF:1;
		unsigned int _OUTSEL:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EWDT_CTL (*((volatile union EWDT_CTL_REG *)0x40000F00))
// model

/** 0x4000 0F04 EWDT_CNT **/
union EWDT_CNT_REG{
	unsigned int reg;
	struct EWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EWDT_CNT (*((volatile union EWDT_CNT_REG *)0x40000F04))
// modelRST

/** 0x4000 0F80 RST_CTL0 **/
union RST_CTL0_REG{
	unsigned int reg;
	struct RST_CTL0_BITS{
		unsigned int _GPIOARST:1;
		unsigned int _GPIOBRST:1;
		unsigned int _GPIOCRST:1;
		unsigned int _GPIODRST:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL0 (*((volatile union RST_CTL0_REG *)0x40000F80))
// model

/** 0x4000 0F84 RST_CTL1 **/
union RST_CTL1_REG{
	unsigned int reg;
	struct RST_CTL1_BITS{
		unsigned int :2;
		unsigned int _T1RST:1;
		unsigned int _T2RST:1;
		unsigned int _T3RST:1;
		unsigned int _T4RST:1;
		unsigned int :5;
		unsigned int _ADC0RST:1;
		unsigned int :2;
		unsigned int _DAC0RST:1;
		unsigned int :1;
		unsigned int _CMPRST:1;
		unsigned int _T0RST:1;
		unsigned int :1;
		unsigned int _USART0RST:1;
		unsigned int _USART1RST:1;
		unsigned int _USART2RST:1;
		unsigned int _USART3RST:1;
		unsigned int :1;
		unsigned int _SPI0RST:1;
		unsigned int _SPI1RST:1;
		unsigned int _I2C0RST:1;
		unsigned int _I2C1RST:1;
		unsigned int :2;
		unsigned int _MPURST:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL1 (*((volatile union RST_CTL1_REG *)0x40000F84))
// model

/** 0x4000 0F88 RST_CTL2 **/
union RST_CTL2_REG{
	unsigned int reg;
	struct RST_CTL2_BITS{
		unsigned int :5;
		unsigned int _WWDTRST:1;
		unsigned int :2;
		unsigned int _EPWM11RST:1;
		unsigned int _EPWM12RST:1;
		unsigned int _EPWM13RST:1;
		unsigned int _EPWM16RST:1;
		unsigned int _DMA0RST:1;
		unsigned int :8;
		unsigned int _T5RST:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL2 (*((volatile union RST_CTL2_REG *)0x40000F88))
// model

/** 0x4000 0F8C RST_CTL3 **/
union RST_CTL3_REG{
	unsigned int reg;
	struct RST_CTL3_BITS{
		unsigned int :12;
		unsigned int _CMURST:1;
		unsigned int _CRCRST:1;
		unsigned int :13;
		unsigned int _EWDTRST:1;
		unsigned int :1;
		unsigned int _CANFD6RST:1;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL3 (*((volatile union RST_CTL3_REG *)0x40000F8C))
// model

/** 0x4000 0F90 RST_CTL4 **/
union RST_CTL4_REG{
	unsigned int reg;
	struct RST_CTL4_BITS{
		unsigned int :10;
		unsigned int _ECC1RST:1;
		unsigned int :9;
		unsigned int _ECC0RST:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL4 (*((volatile union RST_CTL4_REG *)0x40000F90))
// modelCLKEN

/** 0x4000 12C0 PCLK_CTL0 **/
union PCLK_CTL0_REG{
	unsigned int reg;
	struct PCLK_CTL0_BITS{
		unsigned int _GPIOACLKEN:1;
		unsigned int _GPIOBCLKEN:1;
		unsigned int _GPIOCCLKEN:1;
		unsigned int _GPIODCLKEN:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL0 (*((volatile union PCLK_CTL0_REG *)0x400012C0))
// model

/** 0x4000 12C4 PCLK_CTL1 **/
union PCLK_CTL1_REG{
	unsigned int reg;
	struct PCLK_CTL1_BITS{
		unsigned int :2;
		unsigned int _T1CLKEN:1;
		unsigned int _T2CLKEN:1;
		unsigned int _T3CLKEN:1;
		unsigned int _T4CLKEN:1;
		unsigned int :5;
		unsigned int _ADC0CLKEN:1;
		unsigned int :2;
		unsigned int _DAC0CLKEN:1;
		unsigned int :1;
		unsigned int _CMPCLKEN:1;
		unsigned int _T0CLKEN:1;
		unsigned int :1;
		unsigned int _USART0CLKEN:1;
		unsigned int _USART1CLKEN:1;
		unsigned int _USART2CLKEN:1;
		unsigned int _USART3CLKEN:1;
		unsigned int :1;
		unsigned int _SPI0CLKEN:1;
		unsigned int _SPI1CLKEN:1;
		unsigned int _I2C0CLKEN:1;
		unsigned int _I2C1CLKEN:1;
		unsigned int :2;
		unsigned int _MPUCLKEN:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL1 (*((volatile union PCLK_CTL1_REG *)0x400012C4))
// model

/** 0x4000 12C8 PCLK_CTL2 **/
union PCLK_CTL2_REG{
	unsigned int reg;
	struct PCLK_CTL2_BITS{
		unsigned int :5;
		unsigned int _WWDTCLKEN:1;
		unsigned int :2;
		unsigned int _EPWM11CLKEN:1;
		unsigned int _EPWM12CLKEN:1;
		unsigned int _EPWM13CLKEN:1;
		unsigned int _EPWM14CLKEN:1;
		unsigned int _DMA0CLKEN:1;
		unsigned int :8;
		unsigned int _T5CLKEN:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL2 (*((volatile union PCLK_CTL2_REG *)0x400012C8))
// model

/** 0x4000 12CC PCLK_CTL3 **/
union PCLK_CTL3_REG{
	unsigned int reg;
	struct PCLK_CTL3_BITS{
		unsigned int :12;
		unsigned int _CMUCLKEN:1;
		unsigned int _CRCCLKEN:1;
		unsigned int :13;
		unsigned int _EWDTCLKEN:1;
		unsigned int :1;
		unsigned int _CANFD6CLKEN:1;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL3 (*((volatile union PCLK_CTL3_REG *)0x400012CC))
// model

/** 0x4000 12D0 PCLK_CTL4 **/
union PCLK_CTL4_REG{
	unsigned int reg;
	struct PCLK_CTL4_BITS{
		unsigned int :10;
		unsigned int _ECC1CLKEN:1;
		unsigned int :9;
		unsigned int _ECC0CLKEN:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL4 (*((volatile union PCLK_CTL4_REG *)0x400012D0))
// modelBKP

/** 0x4000 0D00 BKP_CTL **/
union BKP_CTL_REG{
	unsigned int reg;
	struct BKP_CTL_BITS{
		unsigned int :31;
		unsigned int _BKPRST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_CTL (*((volatile union BKP_CTL_REG *)0x40000D00))
// model

/** 0x4000 0D40 BKP_DATA0 **/
union BKP_DATA0_REG{
	unsigned int reg;
	struct BKP_DATA0_BITS{
		unsigned int _BKPDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA0 (*((volatile union BKP_DATA0_REG *)0x40000D40))
// model

/** 0x4000 0D44 BKP_DATA1 **/
union BKP_DATA1_REG{
	unsigned int reg;
	struct BKP_DATA1_BITS{
		unsigned int _BKPDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA1 (*((volatile union BKP_DATA1_REG *)0x40000D44))
// model

/** 0x4000 0D48 BKP_DATA2 **/
union BKP_DATA2_REG{
	unsigned int reg;
	struct BKP_DATA2_BITS{
		unsigned int _BKPDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA2 (*((volatile union BKP_DATA2_REG *)0x40000D48))
// model

/** 0x4000 0D4C BKP_DATA3 **/
union BKP_DATA3_REG{
	unsigned int reg;
	struct BKP_DATA3_BITS{
		unsigned int _BKPDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA3 (*((volatile union BKP_DATA3_REG *)0x40000D4C))
// model

/** 0x4000 0D50 BKP_DATA4 **/
union BKP_DATA4_REG{
	unsigned int reg;
	struct BKP_DATA4_BITS{
		unsigned int _BKPDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA4 (*((volatile union BKP_DATA4_REG *)0x40000D50))
// model

/** 0x4000 0D54 BKP_DATA5 **/
union BKP_DATA5_REG{
	unsigned int reg;
	struct BKP_DATA5_BITS{
		unsigned int _BKPDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA5 (*((volatile union BKP_DATA5_REG *)0x40000D54))
// model

/** 0x4000 0D58 BKP_DATA6 **/
union BKP_DATA6_REG{
	unsigned int reg;
	struct BKP_DATA6_BITS{
		unsigned int _BKPDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA6 (*((volatile union BKP_DATA6_REG *)0x40000D58))
// model

/** 0x4000 0D5C BKP_DATA7 **/
union BKP_DATA7_REG{
	unsigned int reg;
	struct BKP_DATA7_BITS{
		unsigned int _BKPDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA7 (*((volatile union BKP_DATA7_REG *)0x40000D5C))
// modelFLASH

/** 0x4020 0100 FLASH_ISPCON0 **/
union FLASH_ISPCON0_REG{
	unsigned int reg;
	struct FLASH_ISPCON0_BITS{
		unsigned int _NVMLOCK:1;
		unsigned int _FLASHLOCK:1;
		unsigned int _CFGLOCK:1;
		unsigned int :1;
		unsigned int _IFEN:1;
		unsigned int _STANDBY1:1;
		unsigned int :1;
		unsigned int _USERLOCK:1;
		unsigned int _DFLOCK:1;
		unsigned int _PFLOCK:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCON0 (*((volatile union FLASH_ISPCON0_REG *)0x40200100))
// model

/** 0x4020 0104 FLASH_ISPCON1 **/
union FLASH_ISPCON1_REG{
	unsigned int reg;
	struct FLASH_ISPCON1_BITS{
		unsigned int _IPSEL:1;
		unsigned int _RECALLEN:1;
		unsigned int _CONFEN:1;
		unsigned int :12;
		unsigned int _CHIPONEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCON1 (*((volatile union FLASH_ISPCON1_REG *)0x40200104))
// model

/** 0x4020 0108 FLASH_ISPCMD **/
union FLASH_ISPCMD_REG{
	unsigned int reg;
	struct FLASH_ISPCMD_BITS{
		unsigned int _CMD:5;
		unsigned int _WSIZE:6;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCMD (*((volatile union FLASH_ISPCMD_REG *)0x40200108))
// model

/** 0x4020 010C FLASH_ISPTRG **/
union FLASH_ISPTRG_REG{
	unsigned int reg;
	struct FLASH_ISPTRG_BITS{
		unsigned int _ISPGO:1;
		unsigned int :31;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPTRG (*((volatile union FLASH_ISPTRG_REG *)0x4020010C))
// model

/** 0x4020 0114 FLASH_CFG **/
union FLASH_CFG_REG{
	unsigned int reg;
	struct FLASH_CFG_BITS{
		unsigned int _TCFG:4;
		unsigned int :2;
		unsigned int _PREFETCHEN:1;
		unsigned int _ECCREADEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFG (*((volatile union FLASH_CFG_REG *)0x40200114))
// model

/** 0x4020 0118 FLASH_USERUNLOCK **/
union FLASH_USERUNLOCK_REG{
	unsigned int reg;
	struct FLASH_USERUNLOCK_BITS{
		unsigned int _USERUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_USERUNLOCK (*((volatile union FLASH_USERUNLOCK_REG *)0x40200118))
// model

/** 0x4020 011C FLASH_ISPADDR **/
union FLASH_ISPADDR_REG{
	unsigned int reg;
	struct FLASH_ISPADDR_BITS{
		unsigned int :3;
		unsigned int _SADDR:16;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPADDR (*((volatile union FLASH_ISPADDR_REG *)0x4020011C))
// model

/** 0x4020 0120 FLASH_STATE **/
union FLASH_STATE_REG{
	unsigned int reg;
	struct FLASH_STATE_BITS{
		unsigned int _CFGERROR:1;
		unsigned int _SIGDONE:1;
		unsigned int _TBIT:1;
		unsigned int _TBUSY:1;
		unsigned int :8;
		unsigned int _DDBG:1;
		unsigned int _BDBGREM:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_STATE (*((volatile union FLASH_STATE_REG *)0x40200120))
// model

/** 0x4020 0128 FLASH_NVMUNLOCK **/
union FLASH_NVMUNLOCK_REG{
	unsigned int reg;
	struct FLASH_NVMUNLOCK_BITS{
		unsigned int _NUMUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_NVMUNLOCK (*((volatile union FLASH_NVMUNLOCK_REG *)0x40200128))
// model

/** 0x4020 012C FLASH_PROUNLOCK **/
union FLASH_PROUNLOCK_REG{
	unsigned int reg;
	struct FLASH_PROUNLOCK_BITS{
		unsigned int _PROUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_PROUNLOCK (*((volatile union FLASH_PROUNLOCK_REG *)0x4020012C))
// model

/** 0x4020 0130 FLASH_CFGUNLOCK **/
union FLASH_CFGUNLOCK_REG{
	unsigned int reg;
	struct FLASH_CFGUNLOCK_BITS{
		unsigned int _CFGUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFGUNLOCK (*((volatile union FLASH_CFGUNLOCK_REG *)0x40200130))
// model

/** 0x4020 0131  FLASH_CHIPONLOCK **/
union  FLASH_CHIPONLOCK_REG{
	unsigned int reg;
	struct  FLASH_CHIPONLOCK_BITS{
		unsigned int _CFGUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  FLASH_CHIPONLOCK (*((volatile union  FLASH_CHIPONLOCK_REG *)0x40200131))
// model

/** 0x4020 0138 FLASH_CSSTART **/
union FLASH_CSSTART_REG{
	unsigned int reg;
	struct FLASH_CSSTART_BITS{
		unsigned int :4;
		unsigned int _CKSTADDR:17;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTART (*((volatile union FLASH_CSSTART_REG *)0x40200138))
// model

/** 0x4020 013C FLASH_CSSTOP **/
union FLASH_CSSTOP_REG{
	unsigned int reg;
	struct FLASH_CSSTOP_BITS{
		unsigned int :4;
		unsigned int _CKSPADDR:17;
		unsigned int :10;
		unsigned int _SIGGO:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTOP (*((volatile union FLASH_CSSTOP_REG *)0x4020013C))
// model

/** 0x4020 0140 FLASH_CSRES0 **/
union FLASH_CSRES0_REG{
	unsigned int reg;
	struct FLASH_CSRES0_BITS{
		unsigned int _CKSPRES0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES0 (*((volatile union FLASH_CSRES0_REG *)0x40200140))
// model

/** 0x4020 0144 FLASH_CSRES1 **/
union FLASH_CSRES1_REG{
	unsigned int reg;
	struct FLASH_CSRES1_BITS{
		unsigned int _CKSPRES1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES1 (*((volatile union FLASH_CSRES1_REG *)0x40200144))
// model

/** 0x4020 0148 FLASH_CSRES2 **/
union FLASH_CSRES2_REG{
	unsigned int reg;
	struct FLASH_CSRES2_BITS{
		unsigned int _CKSPRES2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES2 (*((volatile union FLASH_CSRES2_REG *)0x40200148))
// model

/** 0x4020 014C FLASH_CSRES3 **/
union FLASH_CSRES3_REG{
	unsigned int reg;
	struct FLASH_CSRES3_BITS{
		unsigned int _CKSPRES3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES3 (*((volatile union FLASH_CSRES3_REG *)0x4020014C))
// modelECC0

/** 0x4000 1480 ECC0_CTL **/
union ECC0_CTL_REG{
	unsigned int reg;
	struct ECC0_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_CTL (*((volatile union ECC0_CTL_REG *)0x40001480))
// model

/** 0x4000 1484 ECC0_INT **/
union ECC0_INT_REG{
	unsigned int reg;
	struct ECC0_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_INT (*((volatile union ECC0_INT_REG *)0x40001484))
// model

/** 0x4000 1488 ECC0_ERRADDR **/
union ECC0_ERRADDR_REG{
	unsigned int reg;
	struct ECC0_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_ERRADDR (*((volatile union ECC0_ERRADDR_REG *)0x40001488))
// model

/** 0x4000 1490 ECC0_EBR0 **/
union ECC0_EBR0_REG{
	unsigned int reg;
	struct ECC0_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_EBR0 (*((volatile union ECC0_EBR0_REG *)0x40001490))
// model

/** 0x4000 1494 ECC0_EBR1 **/
union ECC0_EBR1_REG{
	unsigned int reg;
	struct ECC0_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_EBR1 (*((volatile union ECC0_EBR1_REG *)0x40001494))
// model

/** 0x4000 1498 ECC0_EBR2 **/
union ECC0_EBR2_REG{
	unsigned int reg;
	struct ECC0_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_EBR2 (*((volatile union ECC0_EBR2_REG *)0x40001498))
// modelECC1

/** 0x4000 1580 ECC1_CTL **/
union ECC1_CTL_REG{
	unsigned int reg;
	struct ECC1_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_CTL (*((volatile union ECC1_CTL_REG *)0x40001580))
// model

/** 0x4000 1584 ECC1_INT **/
union ECC1_INT_REG{
	unsigned int reg;
	struct ECC1_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_INT (*((volatile union ECC1_INT_REG *)0x40001584))
// model

/** 0x4000 1588 ECC1_ERRADDR **/
union ECC1_ERRADDR_REG{
	unsigned int reg;
	struct ECC1_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_ERRADDR (*((volatile union ECC1_ERRADDR_REG *)0x40001588))
// model

/** 0x4000 1590 ECC1_EBR0 **/
union ECC1_EBR0_REG{
	unsigned int reg;
	struct ECC1_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_EBR0 (*((volatile union ECC1_EBR0_REG *)0x40001590))
// model

/** 0x4000 1594 ECC1_EBR1 **/
union ECC1_EBR1_REG{
	unsigned int reg;
	struct ECC1_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_EBR1 (*((volatile union ECC1_EBR1_REG *)0x40001594))
// model

/** 0x4000 1598 ECC1_EBR2 **/
union ECC1_EBR2_REG{
	unsigned int reg;
	struct ECC1_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_EBR2 (*((volatile union ECC1_EBR2_REG *)0x40001598))
// modelCRC

/** 0x4000 1A80 CRC_CTL **/
union CRC_CTL_REG{
	unsigned int reg;
	struct CRC_CTL_BITS{
		unsigned int _RSET:1;
		unsigned int :1;
		unsigned int _DATASIZE:2;
		unsigned int _DATAREV:2;
		unsigned int _DATAOUTSWAP:2;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_CTL (*((volatile union CRC_CTL_REG *)0x40001A80))
// model

/** 0x4000 1A84 CRC_DATA **/
union CRC_DATA_REG{
	unsigned int reg;
	struct CRC_DATA_BITS{
		unsigned int _CRCDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_DATA (*((volatile union CRC_DATA_REG *)0x40001A84))
// model

/** 0x4000 1A88 CRC_RSLT **/
union CRC_RSLT_REG{
	unsigned int reg;
	struct CRC_RSLT_BITS{
		unsigned int _CRCRSLT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RSLT (*((volatile union CRC_RSLT_REG *)0x40001A88))
// model

/** 0x4000 1A8C CRC_INIT **/
union CRC_INIT_REG{
	unsigned int reg;
	struct CRC_INIT_BITS{
		unsigned int _CRCINIT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_INIT (*((volatile union CRC_INIT_REG *)0x40001A8C))
// model

/** 0x4000 1A90 CRC_PLN **/
union CRC_PLN_REG{
	unsigned int reg;
	struct CRC_PLN_BITS{
		unsigned int _CRCPLN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_PLN (*((volatile union CRC_PLN_REG *)0x40001A90))
// model

/** 0x4000 1A94 CRC_RXOR **/
union CRC_RXOR_REG{
	unsigned int reg;
	struct CRC_RXOR_BITS{
		unsigned int _CRCRXOR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RXOR (*((volatile union CRC_RXOR_REG *)0x40001A94))
// model

/** 0x4000 1A98 CRC_IDATA **/
union CRC_IDATA_REG{
	unsigned int reg;
	struct CRC_IDATA_BITS{
		unsigned int _CRCIDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_IDATA (*((volatile union CRC_IDATA_REG *)0x40001A98))
// model

/** 0x4000 1A9C CRC_TEMP **/
union CRC_TEMP_REG{
	unsigned int reg;
	struct CRC_TEMP_BITS{
		unsigned int _CRCTEMP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_TEMP (*((volatile union CRC_TEMP_REG *)0x40001A9C))
// modelCMU

/** 0x4000 1400 CMU_CTL **/
union CMU_CTL_REG{
	unsigned int reg;
	struct CMU_CTL_BITS{
		unsigned int _CMUEN1:1;
		unsigned int _CMUEN2:1;
		unsigned int _CMUEN3:1;
		unsigned int _CMUEN4:1;
		unsigned int _FHHIC1:1;
		unsigned int _FLLIC1:1;
		unsigned int _FHHIC2:1;
		unsigned int _FLLIC2:1;
		unsigned int _FHHIC3:1;
		unsigned int _FLLIC3:1;
		unsigned int _FHHIC4:1;
		unsigned int _FLLIC4:1;
		unsigned int _CH1REFIC:1;
		unsigned int _CH2REFIC:1;
		unsigned int _CH3REFIC:1;
		unsigned int _CH4REFIC:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_CTL (*((volatile union CMU_CTL_REG *)0x40001400))
// model

/** 0x4000 1404 CMU_INT **/
union CMU_INT_REG{
	unsigned int reg;
	struct CMU_INT_BITS{
		unsigned int _FHHIF1:1;
		unsigned int _FLLIF1:1;
		unsigned int _FHHIF2:1;
		unsigned int _FLLIF2:1;
		unsigned int _FHHIF3:1;
		unsigned int _FLLIF3:1;
		unsigned int _FHHIF4:1;
		unsigned int _FLLIF4:1;
		unsigned int _FHHIE1:1;
		unsigned int _FLLIE1:1;
		unsigned int _FHHIE2:1;
		unsigned int _FLLIE2:1;
		unsigned int _FHHIE3:1;
		unsigned int _FLLIE3:1;
		unsigned int _FHHIE4:1;
		unsigned int _FLLIE4:1;
		unsigned int _CH1REFIE:1;
		unsigned int _CH2REFIE:1;
		unsigned int _CH3REFIE:1;
		unsigned int _CH4REFIE:1;
		unsigned int _CH1REFIF:1;
		unsigned int _CH2REFIF:1;
		unsigned int _CH3REFIF:1;
		unsigned int _CH4REFIF:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_INT (*((volatile union CMU_INT_REG *)0x40001404))
// model

/** 0x4000 1408 CMU_REFCNT1 **/
union CMU_REFCNT1_REG{
	unsigned int reg;
	struct CMU_REFCNT1_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT1 (*((volatile union CMU_REFCNT1_REG *)0x40001408))
// model

/** 0x4000 140C CMU_HTC1 **/
union CMU_HTC1_REG{
	unsigned int reg;
	struct CMU_HTC1_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC1 (*((volatile union CMU_HTC1_REG *)0x4000140C))
// model

/** 0x4000 1410 CMU_LTC1 **/
union CMU_LTC1_REG{
	unsigned int reg;
	struct CMU_LTC1_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC1 (*((volatile union CMU_LTC1_REG *)0x40001410))
// model

/** 0x4000 1414 CMU_REFCNT2 **/
union CMU_REFCNT2_REG{
	unsigned int reg;
	struct CMU_REFCNT2_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT2 (*((volatile union CMU_REFCNT2_REG *)0x40001414))
// model

/** 0x4000 1418 CMU_HTC2 **/
union CMU_HTC2_REG{
	unsigned int reg;
	struct CMU_HTC2_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC2 (*((volatile union CMU_HTC2_REG *)0x40001418))
// model

/** 0x4000 141C CMU_LTC2 **/
union CMU_LTC2_REG{
	unsigned int reg;
	struct CMU_LTC2_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC2 (*((volatile union CMU_LTC2_REG *)0x4000141C))
// model

/** 0x4000 1420 CMU_REFCNT3 **/
union CMU_REFCNT3_REG{
	unsigned int reg;
	struct CMU_REFCNT3_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT3 (*((volatile union CMU_REFCNT3_REG *)0x40001420))
// model

/** 0x4000 1424 CMU_HTC3 **/
union CMU_HTC3_REG{
	unsigned int reg;
	struct CMU_HTC3_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC3 (*((volatile union CMU_HTC3_REG *)0x40001424))
// model

/** 0x4000 1428 CMU_LTC3 **/
union CMU_LTC3_REG{
	unsigned int reg;
	struct CMU_LTC3_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC3 (*((volatile union CMU_LTC3_REG *)0x40001428))
// model

/** 0x4000 142C CMU_REFCNT4 **/
union CMU_REFCNT4_REG{
	unsigned int reg;
	struct CMU_REFCNT4_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT4 (*((volatile union CMU_REFCNT4_REG *)0x4000142C))
// model

/** 0x4000 1430 CMU_HTC4 **/
union CMU_HTC4_REG{
	unsigned int reg;
	struct CMU_HTC4_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC4 (*((volatile union CMU_HTC4_REG *)0x40001430))
// model

/** 0x4000 1434 CMU_LTC4 **/
union CMU_LTC4_REG{
	unsigned int reg;
	struct CMU_LTC4_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC4 (*((volatile union CMU_LTC4_REG *)0x40001434))
// model

/** 0x4000 1438 CMU_INTFLAG **/
union CMU_INTFLAG_REG{
	unsigned int reg;
	struct CMU_INTFLAG_BITS{
		unsigned int _CH1INTREF:1;
		unsigned int _CH2INTREF:1;
		unsigned int _CH3INTREF:1;
		unsigned int _CH4INTREF:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_INTFLAG (*((volatile union CMU_INTFLAG_REG *)0x40001438))
// modelPM

/** 0x4000 1080 PM_CTL0 **/
union PM_CTL0_REG{
	unsigned int reg;
	struct PM_CTL0_BITS{
		unsigned int _LPMS:3;
		unsigned int :2;
		unsigned int _LPREN:1;
		unsigned int _OCALLOCK:1;
		unsigned int _BKPWR:1;
		unsigned int _HSIEN:1;
		unsigned int :3;
		unsigned int _VCOREPD12SELB:1;
		unsigned int :2;
		unsigned int _PORDELAYSEL:1;
		unsigned int _IWDTRMSEL:1;
		unsigned int :4;
		unsigned int _IWDTCLR:1;
		unsigned int _BKPREGCLR:1;
		unsigned int _LPBGON:1;
		unsigned int _LDO18EN:1;
		unsigned int _MRBGEN:1;
		unsigned int :3;
		unsigned int _LSIEN:1;
		unsigned int :1;
		unsigned int _IOLATCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL0 (*((volatile union PM_CTL0_REG *)0x40001080))
// model

/** 0x4000 1084 PM_CTL1 **/
union PM_CTL1_REG{
	unsigned int reg;
	struct PM_CTL1_BITS{
		unsigned int _PVDEN:1;
		unsigned int _LPRTYPE:1;
		unsigned int _PVDS:3;
		unsigned int _VREFEN:1;
		unsigned int _VREFSEL:2;
		unsigned int _LPDEBUG:1;
		unsigned int _P18LVLSENB:1;
		unsigned int _RAMECCEN:1;
		unsigned int :5;
		unsigned int _MONV12EN:1;
		unsigned int _MONV18EN:1;
		unsigned int :1;
		unsigned int _MONV24EN:1;
		unsigned int :7;
		unsigned int _P18OE:1;
		unsigned int :2;
		unsigned int _PVDWKEN:1;
		unsigned int _BOREN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL1 (*((volatile union PM_CTL1_REG *)0x40001084))
// model

/** 0x4000 1088 PM_STA0 **/
union PM_STA0_REG{
	unsigned int reg;
	struct PM_STA0_BITS{
		unsigned int _LPRSTA:1;
		unsigned int _LPRUNF:1;
		unsigned int :20;
		unsigned int _BKPPORIF:1;
		unsigned int _NRSTIF:1;
		unsigned int _PORIF:1;
		unsigned int _WSRSTF:1;
		unsigned int _BORF:1;
		unsigned int _PORF:1;
		unsigned int _WKPPINF:1;
		unsigned int :1;
		unsigned int _IWDTF:1;
		unsigned int _RSTFC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA0 (*((volatile union PM_STA0_REG *)0x40001088))
// model

/** 0x4000 108C PM_STA1 **/
union PM_STA1_REG{
	unsigned int reg;
	struct PM_STA1_BITS{
		unsigned int _PVDSTA:1;
		unsigned int :10;
		unsigned int _WKP6STA:1;
		unsigned int _WKP7STA:1;
		unsigned int _WKP8STA:1;
		unsigned int _WKP9STA:1;
		unsigned int _WKP10STA:1;
		unsigned int _WKP11STA:1;
		unsigned int _WKP12STA:1;
		unsigned int :1;
		unsigned int _PMCERROR:1;
		unsigned int :2;
		unsigned int _POR18FINISH:1;
		unsigned int _OVDIF:1;
		unsigned int _OVDIC:1;
		unsigned int _OVDIE:1;
		unsigned int _PMCIF:1;
		unsigned int _WKP1STA:1;
		unsigned int _WKP2STA:1;
		unsigned int _WKP3STA:1;
		unsigned int _WKP4STA:1;
		unsigned int _WKP5STA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA1 (*((volatile union PM_STA1_REG *)0x4000108C))
// model

/** 0x4000 1090 PM_STAC **/
union PM_STAC_REG{
	unsigned int reg;
	struct PM_STAC_BITS{
		unsigned int _FVRMS:2;
		unsigned int _WKP6EN:1;
		unsigned int _WKP7EN:1;
		unsigned int _WKP8EN:1;
		unsigned int _WKP9EN:1;
		unsigned int _WKP10EN:1;
		unsigned int _WKP11EN:1;
		unsigned int _WKP12EN:1;
		unsigned int _WKP6P:1;
		unsigned int _WKP7P:1;
		unsigned int _WKP8P:1;
		unsigned int _WKP9P:1;
		unsigned int _WKP10P:1;
		unsigned int _WKP11P:1;
		unsigned int _WKP12P:1;
		unsigned int _WKP6SC:1;
		unsigned int _WKP7SC:1;
		unsigned int _WKP8SC:1;
		unsigned int _WKP9SC:1;
		unsigned int _WKP10SC:1;
		unsigned int _WKP11SC:1;
		unsigned int _WKP12SC:1;
		unsigned int :1;
		unsigned int _INTLF4MEN:1;
		unsigned int :1;
		unsigned int _PMCIC:1;
		unsigned int _WKP1SC:1;
		unsigned int _WKP2SC:1;
		unsigned int _WKP3SC:1;
		unsigned int _WKP4SC:1;
		unsigned int _WKP5SC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STAC (*((volatile union PM_STAC_REG *)0x40001090))
// model

/** 0x4000 1094 PM_CTL2 **/
union PM_CTL2_REG{
	unsigned int reg;
	struct PM_CTL2_BITS{
		unsigned int :2;
		unsigned int _EWDTLPEN:1;
		unsigned int :3;
		unsigned int _EWMCLKLPEN:1;
		unsigned int :1;
		unsigned int _POR18SHD:1;
		unsigned int _VF12INF0:1;
		unsigned int _VF12INF1:1;
		unsigned int _VF12EN:1;
		unsigned int _TTSEL:2;
		unsigned int _TTPRESEN:1;
		unsigned int _TTWKPEN:1;
		unsigned int :1;
		unsigned int _GPIOALPEN:1;
		unsigned int :1;
		unsigned int _PMCIE:1;
		unsigned int :2;
		unsigned int _WKP1P:1;
		unsigned int _WKP2P:1;
		unsigned int _WKP3P:1;
		unsigned int _WKP4P:1;
		unsigned int _WKP5P:1;
		unsigned int _WKP1EN:1;
		unsigned int _WKP2EN:1;
		unsigned int _WKP3EN:1;
		unsigned int _WKP4EN:1;
		unsigned int _WKP5EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL2 (*((volatile union PM_CTL2_REG *)0x40001094))
// model

/** 0x4000 10AC PM_CTL3 **/
union PM_CTL3_REG{
	unsigned int reg;
	struct PM_CTL3_BITS{
		unsigned int _PMIWDTEN:1;
		unsigned int _BORSEL:2;
		unsigned int _BORHSEN:1;
		unsigned int _FVRCAPLESSEN:1;
		unsigned int _FVRCAPLESSMODE:1;
		unsigned int _BORWKPEN:1;
		unsigned int _Flash_TPON:1;
		unsigned int _Flash_TP:2;
		unsigned int _EN_COMP_VREF1V:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL3 (*((volatile union PM_CTL3_REG *)0x400010AC))
// modelCANFD

/** 0x4000 4000 CANFD_CTL0 **/
union CANFD_CTL0_REG{
	unsigned int reg;
	struct CANFD_CTL0_BITS{
		unsigned int _MAXMB:7;
		unsigned int :1;
		unsigned int _NRFIDFM:2;
		unsigned int :1;
		unsigned int _FDEN:1;
		unsigned int _ATXEN:1;
		unsigned int _LPRIOEN:1;
		unsigned int :2;
		unsigned int _IRMQ:1;
		unsigned int _SRXDIS:1;
		unsigned int :2;
		unsigned int _DMACK:1;
		unsigned int _WRNEN:1;
		unsigned int :1;
		unsigned int _SUPV:1;
		unsigned int _HALTACK:1;
		unsigned int _SOFTRST:1;
		unsigned int :1;
		unsigned int _NOTRDY:1;
		unsigned int _HALT:1;
		unsigned int _NRFEN:1;
		unsigned int _SETUPEN:1;
		unsigned int _DISEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_CTL0 (*((volatile union CANFD_CTL0_REG *)0x40004000))
// model

/** 0x4000 4004 CANFD_CTL1 **/
union CANFD_CTL1_REG{
	unsigned int reg;
	struct CANFD_CTL1_BITS{
		unsigned int _PROPSEG:3;
		unsigned int _LOM:1;
		unsigned int _LBUF:1;
		unsigned int _TSYN:1;
		unsigned int _BOFFREC:1;
		unsigned int _SMP:1;
		unsigned int :2;
		unsigned int _RWRNMSK:1;
		unsigned int _TWRNMSK:1;
		unsigned int _LPB:1;
		unsigned int _CLKSRC:1;
		unsigned int _ERRMSK:1;
		unsigned int _BOFFMSK:1;
		unsigned int _PSEG2:3;
		unsigned int _PSEG1:3;
		unsigned int _RJW:2;
		unsigned int _PRESDIV:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_CTL1 (*((volatile union CANFD_CTL1_REG *)0x40004004))
// model

/** 0x4000 4008 CANFD_TIMER **/
union CANFD_TIMER_REG{
	unsigned int reg;
	struct CANFD_TIMER_BITS{
		unsigned int _TIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_TIMER (*((volatile union CANFD_TIMER_REG *)0x40004008))
// model

/** 0x4000 4010 CANFD_RXMGMASK **/
union CANFD_RXMGMASK_REG{
	unsigned int reg;
	struct CANFD_RXMGMASK_BITS{
		unsigned int _MG:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXMGMASK (*((volatile union CANFD_RXMGMASK_REG *)0x40004010))
// model

/** 0x4000 401C CANFD_ECR **/
union CANFD_ECR_REG{
	unsigned int reg;
	struct CANFD_ECR_BITS{
		unsigned int _TXERRCNT:8;
		unsigned int _RXERRCNT:8;
		unsigned int _TXERRCNT_FD:8;
		unsigned int _RXERRCNT_FD:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ECR (*((volatile union CANFD_ECR_REG *)0x4000401C))
// model

/** 0x4000 4020 CANFD_ESR1 **/
union CANFD_ESR1_REG{
	unsigned int reg;
	struct CANFD_ESR1_BITS{
		unsigned int _WAKINT:1;
		unsigned int _ERRINT:1;
		unsigned int _BOFFINT:1;
		unsigned int _RXSTA:1;
		unsigned int :1;
		unsigned int _FLTCONF:1;
		unsigned int _TXSTA:1;
		unsigned int _IDLE:1;
		unsigned int _RXWRN:1;
		unsigned int _TXWRN:1;
		unsigned int _STFERR:1;
		unsigned int _FRMERR:1;
		unsigned int _CRCERR:1;
		unsigned int _ACKERR:1;
		unsigned int _BIT0ERR:1;
		unsigned int _BIT1ERR:1;
		unsigned int _RWRNINT:1;
		unsigned int _TWRNINT:1;
		unsigned int _SYNCH:1;
		unsigned int _BOFFDONEINT:1;
		unsigned int _ERRINT_FD:1;
		unsigned int _ERROVER:1;
		unsigned int :4;
		unsigned int _STFERR_FD:1;
		unsigned int _FRMERR_FD:1;
		unsigned int _CRCERR_FD:1;
		unsigned int :1;
		unsigned int _BIT0ERR_FD:1;
		unsigned int _BIT1ERR_FD:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ESR1 (*((volatile union CANFD_ESR1_REG *)0x40004020))
// model

/** 0x4000 4024 CANFD_IMASK2 **/
union CANFD_IMASK2_REG{
	unsigned int reg;
	struct CANFD_IMASK2_BITS{
		unsigned int _BUF63TO32M:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_IMASK2 (*((volatile union CANFD_IMASK2_REG *)0x40004024))
// model

/** 0x4000 4028 CANFD_IMASK1 **/
union CANFD_IMASK1_REG{
	unsigned int reg;
	struct CANFD_IMASK1_BITS{
		unsigned int _BUF31TO0M:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_IMASK1 (*((volatile union CANFD_IMASK1_REG *)0x40004028))
// model

/** 0x4000 402C CANFD_IFLAG2 **/
union CANFD_IFLAG2_REG{
	unsigned int reg;
	struct CANFD_IFLAG2_BITS{
		unsigned int _BUF63TO32I:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_IFLAG2 (*((volatile union CANFD_IFLAG2_REG *)0x4000402C))
// model

/** 0x4000 4030 CANFD_IFLAG1 **/
union CANFD_IFLAG1_REG{
	unsigned int reg;
	struct CANFD_IFLAG1_BITS{
		unsigned int _BUF0I:1;
		unsigned int _BUF4TO1I:4;
		unsigned int _BUF5I:1;
		unsigned int _BUF6I:1;
		unsigned int _BUF7I:1;
		unsigned int _BUF31TO8I:24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_IFLAG1 (*((volatile union CANFD_IFLAG1_REG *)0x40004030))
// model

/** 0x4000 4034 CANFD_CTL2 **/
union CANFD_CTL2_REG{
	unsigned int reg;
	struct CANFD_CTL2_BITS{
		unsigned int :6;
		unsigned int _TSTAMPCAP:2;
		unsigned int _MBTSBASE:2;
		unsigned int :1;
		unsigned int _EDFLTDIS:1;
		unsigned int _ISOCANFDEN:1;
		unsigned int _BTE:1;
		unsigned int _PREXCEN:1;
		unsigned int _TIMER_SRC:1;
		unsigned int _EACEN:1;
		unsigned int _RRS:1;
		unsigned int _MRP:1;
		unsigned int _TASD:5;
		unsigned int _RFFN:4;
		unsigned int _WRMFRZ:1;
		unsigned int _ECRWRE:1;
		unsigned int _BOFFDONEMSK:1;
		unsigned int _ERRMSK_FAST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_CTL2 (*((volatile union CANFD_CTL2_REG *)0x40004034))
// model

/** 0x4000 4038 CANFD_ESR2 **/
union CANFD_ESR2_REG{
	unsigned int reg;
	struct CANFD_ESR2_BITS{
		unsigned int :13;
		unsigned int _IMB:1;
		unsigned int _VPS:1;
		unsigned int _TWAMSK:1;
		unsigned int _LPTM:7;
		unsigned int :8;
		unsigned int _TWAINT:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ESR2 (*((volatile union CANFD_ESR2_REG *)0x40004038))
// model

/** 0x4000 4044 CANFD_CRCR **/
union CANFD_CRCR_REG{
	unsigned int reg;
	struct CANFD_CRCR_BITS{
		unsigned int _TXCRC:15;
		unsigned int :1;
		unsigned int _MBCRC:7;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_CRCR (*((volatile union CANFD_CRCR_REG *)0x40004044))
// model

/** 0x4000 4048 CANFD_NRFGM **/
union CANFD_NRFGM_REG{
	unsigned int reg;
	struct CANFD_NRFGM_BITS{
		unsigned int _RFMG:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_NRFGM (*((volatile union CANFD_NRFGM_REG *)0x40004048))
// model

/** 0x4000 404C CANFD_NRFFIR **/
union CANFD_NRFFIR_REG{
	unsigned int reg;
	struct CANFD_NRFFIR_BITS{
		unsigned int _IDFIR:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_NRFFIR (*((volatile union CANFD_NRFFIR_REG *)0x4000404C))
// model

/** 0x4000 4050 CANFD_CBT **/
union CANFD_CBT_REG{
	unsigned int reg;
	struct CANFD_CBT_BITS{
		unsigned int _EPSEG2:5;
		unsigned int _EPSEG1:5;
		unsigned int _EPROPSEG:6;
		unsigned int _ERJW:5;
		unsigned int _EPRESDIV:10;
		unsigned int _BTF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_CBT (*((volatile union CANFD_CBT_REG *)0x40004050))
// model

/** 0x4000 4880 CANFD_RXIMR0 **/
union CANFD_RXIMR0_REG{
	unsigned int reg;
	struct CANFD_RXIMR0_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR0 (*((volatile union CANFD_RXIMR0_REG *)0x40004880))
// model

/** 0x4000 4884 CANFD_RXIMR1 **/
union CANFD_RXIMR1_REG{
	unsigned int reg;
	struct CANFD_RXIMR1_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR1 (*((volatile union CANFD_RXIMR1_REG *)0x40004884))
// model

/** 0x4000 4888 CANFD_RXIMR2 **/
union CANFD_RXIMR2_REG{
	unsigned int reg;
	struct CANFD_RXIMR2_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR2 (*((volatile union CANFD_RXIMR2_REG *)0x40004888))
// model

/** 0x4000 488C CANFD_RXIMR3 **/
union CANFD_RXIMR3_REG{
	unsigned int reg;
	struct CANFD_RXIMR3_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR3 (*((volatile union CANFD_RXIMR3_REG *)0x4000488C))
// model

/** 0x4000 4890 CANFD_RXIMR4 **/
union CANFD_RXIMR4_REG{
	unsigned int reg;
	struct CANFD_RXIMR4_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR4 (*((volatile union CANFD_RXIMR4_REG *)0x40004890))
// model

/** 0x4000 4894 CANFD_RXIMR5 **/
union CANFD_RXIMR5_REG{
	unsigned int reg;
	struct CANFD_RXIMR5_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR5 (*((volatile union CANFD_RXIMR5_REG *)0x40004894))
// model

/** 0x4000 4898 CANFD_RXIMR6 **/
union CANFD_RXIMR6_REG{
	unsigned int reg;
	struct CANFD_RXIMR6_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR6 (*((volatile union CANFD_RXIMR6_REG *)0x40004898))
// model

/** 0x4000 489C CANFD_RXIMR7 **/
union CANFD_RXIMR7_REG{
	unsigned int reg;
	struct CANFD_RXIMR7_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR7 (*((volatile union CANFD_RXIMR7_REG *)0x4000489C))
// model

/** 0x4000 48A0 CANFD_RXIMR8 **/
union CANFD_RXIMR8_REG{
	unsigned int reg;
	struct CANFD_RXIMR8_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR8 (*((volatile union CANFD_RXIMR8_REG *)0x400048A0))
// model

/** 0x4000 48A4 CANFD_RXIMR9 **/
union CANFD_RXIMR9_REG{
	unsigned int reg;
	struct CANFD_RXIMR9_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR9 (*((volatile union CANFD_RXIMR9_REG *)0x400048A4))
// model

/** 0x4000 48A8 CANFD_RXIMR10 **/
union CANFD_RXIMR10_REG{
	unsigned int reg;
	struct CANFD_RXIMR10_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR10 (*((volatile union CANFD_RXIMR10_REG *)0x400048A8))
// model

/** 0x4000 48AC CANFD_RXIMR11 **/
union CANFD_RXIMR11_REG{
	unsigned int reg;
	struct CANFD_RXIMR11_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR11 (*((volatile union CANFD_RXIMR11_REG *)0x400048AC))
// model

/** 0x4000 48B0 CANFD_RXIMR12 **/
union CANFD_RXIMR12_REG{
	unsigned int reg;
	struct CANFD_RXIMR12_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR12 (*((volatile union CANFD_RXIMR12_REG *)0x400048B0))
// model

/** 0x4000 48B4 CANFD_RXIMR13 **/
union CANFD_RXIMR13_REG{
	unsigned int reg;
	struct CANFD_RXIMR13_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR13 (*((volatile union CANFD_RXIMR13_REG *)0x400048B4))
// model

/** 0x4000 48B8 CANFD_RXIMR14 **/
union CANFD_RXIMR14_REG{
	unsigned int reg;
	struct CANFD_RXIMR14_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR14 (*((volatile union CANFD_RXIMR14_REG *)0x400048B8))
// model

/** 0x4000 48BC CANFD_RXIMR15 **/
union CANFD_RXIMR15_REG{
	unsigned int reg;
	struct CANFD_RXIMR15_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR15 (*((volatile union CANFD_RXIMR15_REG *)0x400048BC))
// model

/** 0x4000 48C0 CANFD_RXIMR16 **/
union CANFD_RXIMR16_REG{
	unsigned int reg;
	struct CANFD_RXIMR16_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR16 (*((volatile union CANFD_RXIMR16_REG *)0x400048C0))
// model

/** 0x4000 48C4 CANFD_RXIMR17 **/
union CANFD_RXIMR17_REG{
	unsigned int reg;
	struct CANFD_RXIMR17_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR17 (*((volatile union CANFD_RXIMR17_REG *)0x400048C4))
// model

/** 0x4000 48C8 CANFD_RXIMR18 **/
union CANFD_RXIMR18_REG{
	unsigned int reg;
	struct CANFD_RXIMR18_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR18 (*((volatile union CANFD_RXIMR18_REG *)0x400048C8))
// model

/** 0x4000 48CC CANFD_RXIMR19 **/
union CANFD_RXIMR19_REG{
	unsigned int reg;
	struct CANFD_RXIMR19_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR19 (*((volatile union CANFD_RXIMR19_REG *)0x400048CC))
// model

/** 0x4000 48D0 CANFD_RXIMR20 **/
union CANFD_RXIMR20_REG{
	unsigned int reg;
	struct CANFD_RXIMR20_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR20 (*((volatile union CANFD_RXIMR20_REG *)0x400048D0))
// model

/** 0x4000 48D4 CANFD_RXIMR21 **/
union CANFD_RXIMR21_REG{
	unsigned int reg;
	struct CANFD_RXIMR21_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR21 (*((volatile union CANFD_RXIMR21_REG *)0x400048D4))
// model

/** 0x4000 48D8 CANFD_RXIMR22 **/
union CANFD_RXIMR22_REG{
	unsigned int reg;
	struct CANFD_RXIMR22_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR22 (*((volatile union CANFD_RXIMR22_REG *)0x400048D8))
// model

/** 0x4000 48DC CANFD_RXIMR23 **/
union CANFD_RXIMR23_REG{
	unsigned int reg;
	struct CANFD_RXIMR23_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR23 (*((volatile union CANFD_RXIMR23_REG *)0x400048DC))
// model

/** 0x4000 48E0 CANFD_RXIMR24 **/
union CANFD_RXIMR24_REG{
	unsigned int reg;
	struct CANFD_RXIMR24_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR24 (*((volatile union CANFD_RXIMR24_REG *)0x400048E0))
// model

/** 0x4000 48E4 CANFD_RXIMR25 **/
union CANFD_RXIMR25_REG{
	unsigned int reg;
	struct CANFD_RXIMR25_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR25 (*((volatile union CANFD_RXIMR25_REG *)0x400048E4))
// model

/** 0x4000 48E8 CANFD_RXIMR26 **/
union CANFD_RXIMR26_REG{
	unsigned int reg;
	struct CANFD_RXIMR26_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR26 (*((volatile union CANFD_RXIMR26_REG *)0x400048E8))
// model

/** 0x4000 48EC CANFD_RXIMR27 **/
union CANFD_RXIMR27_REG{
	unsigned int reg;
	struct CANFD_RXIMR27_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR27 (*((volatile union CANFD_RXIMR27_REG *)0x400048EC))
// model

/** 0x4000 48F0 CANFD_RXIMR28 **/
union CANFD_RXIMR28_REG{
	unsigned int reg;
	struct CANFD_RXIMR28_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR28 (*((volatile union CANFD_RXIMR28_REG *)0x400048F0))
// model

/** 0x4000 48F4 CANFD_RXIMR29 **/
union CANFD_RXIMR29_REG{
	unsigned int reg;
	struct CANFD_RXIMR29_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR29 (*((volatile union CANFD_RXIMR29_REG *)0x400048F4))
// model

/** 0x4000 48F8 CANFD_RXIMR30 **/
union CANFD_RXIMR30_REG{
	unsigned int reg;
	struct CANFD_RXIMR30_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR30 (*((volatile union CANFD_RXIMR30_REG *)0x400048F8))
// model

/** 0x4000 48FC CANFD_RXIMR31 **/
union CANFD_RXIMR31_REG{
	unsigned int reg;
	struct CANFD_RXIMR31_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR31 (*((volatile union CANFD_RXIMR31_REG *)0x400048FC))
// model

/** 0x4000 4900 CANFD_RXIMR32 **/
union CANFD_RXIMR32_REG{
	unsigned int reg;
	struct CANFD_RXIMR32_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR32 (*((volatile union CANFD_RXIMR32_REG *)0x40004900))
// model

/** 0x4000 4904 CANFD_RXIMR33 **/
union CANFD_RXIMR33_REG{
	unsigned int reg;
	struct CANFD_RXIMR33_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR33 (*((volatile union CANFD_RXIMR33_REG *)0x40004904))
// model

/** 0x4000 4908 CANFD_RXIMR34 **/
union CANFD_RXIMR34_REG{
	unsigned int reg;
	struct CANFD_RXIMR34_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR34 (*((volatile union CANFD_RXIMR34_REG *)0x40004908))
// model

/** 0x4000 490C CANFD_RXIMR35 **/
union CANFD_RXIMR35_REG{
	unsigned int reg;
	struct CANFD_RXIMR35_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR35 (*((volatile union CANFD_RXIMR35_REG *)0x4000490C))
// model

/** 0x4000 4910 CANFD_RXIMR36 **/
union CANFD_RXIMR36_REG{
	unsigned int reg;
	struct CANFD_RXIMR36_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR36 (*((volatile union CANFD_RXIMR36_REG *)0x40004910))
// model

/** 0x4000 4914 CANFD_RXIMR37 **/
union CANFD_RXIMR37_REG{
	unsigned int reg;
	struct CANFD_RXIMR37_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR37 (*((volatile union CANFD_RXIMR37_REG *)0x40004914))
// model

/** 0x4000 4918 CANFD_RXIMR38 **/
union CANFD_RXIMR38_REG{
	unsigned int reg;
	struct CANFD_RXIMR38_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR38 (*((volatile union CANFD_RXIMR38_REG *)0x40004918))
// model

/** 0x4000 491C CANFD_RXIMR39 **/
union CANFD_RXIMR39_REG{
	unsigned int reg;
	struct CANFD_RXIMR39_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR39 (*((volatile union CANFD_RXIMR39_REG *)0x4000491C))
// model

/** 0x4000 4920 CANFD_RXIMR40 **/
union CANFD_RXIMR40_REG{
	unsigned int reg;
	struct CANFD_RXIMR40_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR40 (*((volatile union CANFD_RXIMR40_REG *)0x40004920))
// model

/** 0x4000 4924 CANFD_RXIMR41 **/
union CANFD_RXIMR41_REG{
	unsigned int reg;
	struct CANFD_RXIMR41_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR41 (*((volatile union CANFD_RXIMR41_REG *)0x40004924))
// model

/** 0x4000 4928 CANFD_RXIMR42 **/
union CANFD_RXIMR42_REG{
	unsigned int reg;
	struct CANFD_RXIMR42_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR42 (*((volatile union CANFD_RXIMR42_REG *)0x40004928))
// model

/** 0x4000 492C CANFD_RXIMR43 **/
union CANFD_RXIMR43_REG{
	unsigned int reg;
	struct CANFD_RXIMR43_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR43 (*((volatile union CANFD_RXIMR43_REG *)0x4000492C))
// model

/** 0x4000 4930 CANFD_RXIMR44 **/
union CANFD_RXIMR44_REG{
	unsigned int reg;
	struct CANFD_RXIMR44_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR44 (*((volatile union CANFD_RXIMR44_REG *)0x40004930))
// model

/** 0x4000 4934 CANFD_RXIMR45 **/
union CANFD_RXIMR45_REG{
	unsigned int reg;
	struct CANFD_RXIMR45_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR45 (*((volatile union CANFD_RXIMR45_REG *)0x40004934))
// model

/** 0x4000 4938 CANFD_RXIMR46 **/
union CANFD_RXIMR46_REG{
	unsigned int reg;
	struct CANFD_RXIMR46_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR46 (*((volatile union CANFD_RXIMR46_REG *)0x40004938))
// model

/** 0x4000 493C CANFD_RXIMR47 **/
union CANFD_RXIMR47_REG{
	unsigned int reg;
	struct CANFD_RXIMR47_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR47 (*((volatile union CANFD_RXIMR47_REG *)0x4000493C))
// model

/** 0x4000 4940 CANFD_RXIMR48 **/
union CANFD_RXIMR48_REG{
	unsigned int reg;
	struct CANFD_RXIMR48_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR48 (*((volatile union CANFD_RXIMR48_REG *)0x40004940))
// model

/** 0x4000 4944 CANFD_RXIMR49 **/
union CANFD_RXIMR49_REG{
	unsigned int reg;
	struct CANFD_RXIMR49_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR49 (*((volatile union CANFD_RXIMR49_REG *)0x40004944))
// model

/** 0x4000 4948 CANFD_RXIMR50 **/
union CANFD_RXIMR50_REG{
	unsigned int reg;
	struct CANFD_RXIMR50_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR50 (*((volatile union CANFD_RXIMR50_REG *)0x40004948))
// model

/** 0x4000 494C CANFD_RXIMR51 **/
union CANFD_RXIMR51_REG{
	unsigned int reg;
	struct CANFD_RXIMR51_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR51 (*((volatile union CANFD_RXIMR51_REG *)0x4000494C))
// model

/** 0x4000 4950 CANFD_RXIMR52 **/
union CANFD_RXIMR52_REG{
	unsigned int reg;
	struct CANFD_RXIMR52_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR52 (*((volatile union CANFD_RXIMR52_REG *)0x40004950))
// model

/** 0x4000 4954 CANFD_RXIMR53 **/
union CANFD_RXIMR53_REG{
	unsigned int reg;
	struct CANFD_RXIMR53_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR53 (*((volatile union CANFD_RXIMR53_REG *)0x40004954))
// model

/** 0x4000 4958 CANFD_RXIMR54 **/
union CANFD_RXIMR54_REG{
	unsigned int reg;
	struct CANFD_RXIMR54_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR54 (*((volatile union CANFD_RXIMR54_REG *)0x40004958))
// model

/** 0x4000 495C CANFD_RXIMR55 **/
union CANFD_RXIMR55_REG{
	unsigned int reg;
	struct CANFD_RXIMR55_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR55 (*((volatile union CANFD_RXIMR55_REG *)0x4000495C))
// model

/** 0x4000 4960 CANFD_RXIMR56 **/
union CANFD_RXIMR56_REG{
	unsigned int reg;
	struct CANFD_RXIMR56_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR56 (*((volatile union CANFD_RXIMR56_REG *)0x40004960))
// model

/** 0x4000 4964 CANFD_RXIMR57 **/
union CANFD_RXIMR57_REG{
	unsigned int reg;
	struct CANFD_RXIMR57_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR57 (*((volatile union CANFD_RXIMR57_REG *)0x40004964))
// model

/** 0x4000 4968 CANFD_RXIMR58 **/
union CANFD_RXIMR58_REG{
	unsigned int reg;
	struct CANFD_RXIMR58_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR58 (*((volatile union CANFD_RXIMR58_REG *)0x40004968))
// model

/** 0x4000 496C CANFD_RXIMR59 **/
union CANFD_RXIMR59_REG{
	unsigned int reg;
	struct CANFD_RXIMR59_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR59 (*((volatile union CANFD_RXIMR59_REG *)0x4000496C))
// model

/** 0x4000 4970 CANFD_RXIMR60 **/
union CANFD_RXIMR60_REG{
	unsigned int reg;
	struct CANFD_RXIMR60_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR60 (*((volatile union CANFD_RXIMR60_REG *)0x40004970))
// model

/** 0x4000 4974 CANFD_RXIMR61 **/
union CANFD_RXIMR61_REG{
	unsigned int reg;
	struct CANFD_RXIMR61_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR61 (*((volatile union CANFD_RXIMR61_REG *)0x40004974))
// model

/** 0x4000 4978 CANFD_RXIMR62 **/
union CANFD_RXIMR62_REG{
	unsigned int reg;
	struct CANFD_RXIMR62_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR62 (*((volatile union CANFD_RXIMR62_REG *)0x40004978))
// model

/** 0x4000 497C CANFD_RXIMR63 **/
union CANFD_RXIMR63_REG{
	unsigned int reg;
	struct CANFD_RXIMR63_BITS{
		unsigned int _IM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RXIMR63 (*((volatile union CANFD_RXIMR63_REG *)0x4000497C))
// model

/** 0x4000 4AE0 CANFD_MECR **/
union CANFD_MECR_REG{
	unsigned int reg;
	struct CANFD_MECR_BITS{
		unsigned int :7;
		unsigned int _NCEFAFRZ:1;
		unsigned int _ECCDIS:1;
		unsigned int _RERRDIS:1;
		unsigned int :3;
		unsigned int _EXTERRIE:1;
		unsigned int _FAERRIE:1;
		unsigned int _HAERRIE:1;
		unsigned int _CEI_MSK:1;
		unsigned int :1;
		unsigned int _FANCEI_MSK:1;
		unsigned int _HANCEI_MSK:1;
		unsigned int :11;
		unsigned int _ECRWRDIS:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_MECR (*((volatile union CANFD_MECR_REG *)0x40004AE0))
// model

/** 0x4000 4AF0 CANFD_RERRAR **/
union CANFD_RERRAR_REG{
	unsigned int reg;
	struct CANFD_RERRAR_BITS{
		unsigned int _ERRADDR:14;
		unsigned int :2;
		unsigned int _SAID:3;
		unsigned int :5;
		unsigned int _NCE:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RERRAR (*((volatile union CANFD_RERRAR_REG *)0x40004AF0))
// model

/** 0x4000 4AF4 CANFD_RERRDR **/
union CANFD_RERRDR_REG{
	unsigned int reg;
	struct CANFD_RERRDR_BITS{
		unsigned int _RDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RERRDR (*((volatile union CANFD_RERRDR_REG *)0x40004AF4))
// model

/** 0x4000 4AF8 CANFD_RERRSYNR **/
union CANFD_RERRSYNR_REG{
	unsigned int reg;
	struct CANFD_RERRSYNR_BITS{
		unsigned int _SYND0:5;
		unsigned int :2;
		unsigned int _BE0:1;
		unsigned int _SYND1:5;
		unsigned int :2;
		unsigned int _BE1:1;
		unsigned int _SYND2:5;
		unsigned int :2;
		unsigned int _BE2:1;
		unsigned int _SYND3:5;
		unsigned int :2;
		unsigned int _BE3:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_RERRSYNR (*((volatile union CANFD_RERRSYNR_REG *)0x40004AF8))
// model

/** 0x4000 4AFC CANFD_ERRSR **/
union CANFD_ERRSR_REG{
	unsigned int reg;
	struct CANFD_ERRSR_BITS{
		unsigned int _CEIOF:1;
		unsigned int :1;
		unsigned int _FANCEIOF:1;
		unsigned int _HANCEIOF:1;
		unsigned int :12;
		unsigned int _CEIF:1;
		unsigned int :1;
		unsigned int _FANCEIF:1;
		unsigned int _HANCEIF:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERRSR (*((volatile union CANFD_ERRSR_REG *)0x40004AFC))
// model

/** 0x4000 4BF0 CANFD_EPRS **/
union CANFD_EPRS_REG{
	unsigned int reg;
	struct CANFD_EPRS_BITS{
		unsigned int _ENPRESDIV:10;
		unsigned int :6;
		unsigned int _EDPRESDIV:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_EPRS (*((volatile union CANFD_EPRS_REG *)0x40004BF0))
// model

/** 0x4000 4BFC CANFD_ETDC **/
union CANFD_ETDC_REG{
	unsigned int reg;
	struct CANFD_ETDC_BITS{
		unsigned int _ETDCVAL:8;
		unsigned int :7;
		unsigned int _ETDCFAIL:1;
		unsigned int _ETDCOFF:7;
		unsigned int :7;
		unsigned int _TDMDIS:1;
		unsigned int _ETDCEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ETDC (*((volatile union CANFD_ETDC_REG *)0x40004BFC))
// model

/** 0x4000 4C00 CANFD_FDCTL **/
union CANFD_FDCTL_REG{
	unsigned int reg;
	struct CANFD_FDCTL_BITS{
		unsigned int _TDCVAL:6;
		unsigned int :2;
		unsigned int _TDCOFF:5;
		unsigned int :1;
		unsigned int _TDCFAIL:1;
		unsigned int _TDCEN:1;
		unsigned int _MBDSR0:2;
		unsigned int :1;
		unsigned int _MBDSR1:2;
		unsigned int :10;
		unsigned int _FDRATE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_FDCTL (*((volatile union CANFD_FDCTL_REG *)0x40004C00))
// model

/** 0x4000 4C04 CANFD_FDCBT **/
union CANFD_FDCBT_REG{
	unsigned int reg;
	struct CANFD_FDCBT_BITS{
		unsigned int _FPSEG2:3;
		unsigned int :2;
		unsigned int _FPSEG1:3;
		unsigned int _FPROPSEG:7;
		unsigned int :1;
		unsigned int _FRJW:3;
		unsigned int :1;
		unsigned int _FPRESDIV:10;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_FDCBT (*((volatile union CANFD_FDCBT_REG *)0x40004C04))
// model

/** 0x4000 4C08 CANFD_FDCRC **/
union CANFD_FDCRC_REG{
	unsigned int reg;
	struct CANFD_FDCRC_BITS{
		unsigned int _FD_TXCRC:21;
		unsigned int :3;
		unsigned int _FD_MBCRC:7;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_FDCRC (*((volatile union CANFD_FDCRC_REG *)0x40004C08))
// model

/** 0x4000 4C0C CANFD_ERFCR **/
union CANFD_ERFCR_REG{
	unsigned int reg;
	struct CANFD_ERFCR_BITS{
		unsigned int _ERFWM:5;
		unsigned int :3;
		unsigned int _NFE:6;
		unsigned int :2;
		unsigned int _NEXIF:7;
		unsigned int :8;
		unsigned int _ERFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFCR (*((volatile union CANFD_ERFCR_REG *)0x40004C0C))
// model

/** 0x4000 4C10 CANFD_ERFIER **/
union CANFD_ERFIER_REG{
	unsigned int reg;
	struct CANFD_ERFIER_BITS{
		unsigned int :28;
		unsigned int _ERFDAIE:1;
		unsigned int _ERFWMIIE:1;
		unsigned int _ERFOVFIE:1;
		unsigned int _ERFUFWIE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFIER (*((volatile union CANFD_ERFIER_REG *)0x40004C10))
// model

/** 0x4000 4C14 CANFD_ERFSR **/
union CANFD_ERFSR_REG{
	unsigned int reg;
	struct CANFD_ERFSR_BITS{
		unsigned int _ERFEL:6;
		unsigned int :10;
		unsigned int _ERFF:1;
		unsigned int _ERFE:1;
		unsigned int :9;
		unsigned int _ERFCLR:1;
		unsigned int _ERFDA:1;
		unsigned int _ERFWMI:1;
		unsigned int _ERFOVF:1;
		unsigned int _ERFUFW:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFSR (*((volatile union CANFD_ERFSR_REG *)0x40004C14))
// model

/** 0x4000 7000 CANFD_ERFFEL0 **/
union CANFD_ERFFEL0_REG{
	unsigned int reg;
	struct CANFD_ERFFEL0_BITS{
		unsigned int _FEL:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFFEL0 (*((volatile union CANFD_ERFFEL0_REG *)0x40007000))
// model

/** 0x4000 7004 CANFD_ERFFEL1 **/
union CANFD_ERFFEL1_REG{
	unsigned int reg;
	struct CANFD_ERFFEL1_BITS{
		unsigned int _FEL:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFFEL1 (*((volatile union CANFD_ERFFEL1_REG *)0x40007004))
// model

/** 0x4000 7008 CANFD_ERFFEL2 **/
union CANFD_ERFFEL2_REG{
	unsigned int reg;
	struct CANFD_ERFFEL2_BITS{
		unsigned int _FEL:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFFEL2 (*((volatile union CANFD_ERFFEL2_REG *)0x40007008))
// model

/** 0x4000 700C CANFD_ERFFEL3 **/
union CANFD_ERFFEL3_REG{
	unsigned int reg;
	struct CANFD_ERFFEL3_BITS{
		unsigned int _FEL:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFFEL3 (*((volatile union CANFD_ERFFEL3_REG *)0x4000700C))
// model

/** 0x4000 7010 CANFD_ERFFEL4 **/
union CANFD_ERFFEL4_REG{
	unsigned int reg;
	struct CANFD_ERFFEL4_BITS{
		unsigned int _FEL:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFFEL4 (*((volatile union CANFD_ERFFEL4_REG *)0x40007010))
// model

/** 0x4000 7014 CANFD_ERFFEL5 **/
union CANFD_ERFFEL5_REG{
	unsigned int reg;
	struct CANFD_ERFFEL5_BITS{
		unsigned int _FEL:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_ERFFEL5 (*((volatile union CANFD_ERFFEL5_REG *)0x40007014))
// model

/** 0x4000 7028 CANFD_DIV **/
union CANFD_DIV_REG{
	unsigned int reg;
	struct CANFD_DIV_BITS{
		unsigned int _CLK_SEL:2;
		unsigned int _CLK_DIV:3;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD_DIV (*((volatile union CANFD_DIV_REG *)0x40007028))
#endif
