/************************************************************
*       Header file for the KungFu32  C
*       *       Microcontroller
*
*       Copyright 2012-2020 ChipON, All rights reserved
*************************************************************/

#ifndef  _KF32R1ALLOVER_H_
#define  _KF32R1ALLOVER_H_

struct all_bit{
		unsigned int _b0:1;
		unsigned int _b1:1;
		unsigned int _b2:1;
		unsigned int _b3:1;
		unsigned int _b4:1;
		unsigned int _b5:1;
		unsigned int _b6:1;
		unsigned int _b7:1;
		unsigned int _b8:1;
		unsigned int _b9:1;
		unsigned int _b10:1;
		unsigned int _b11:1;
		unsigned int _b12:1;
		unsigned int _b13:1;
		unsigned int _b14:1;
		unsigned int _b15:1;
		unsigned int _b16:1;
		unsigned int _b17:1;
		unsigned int _b18:1;
		unsigned int _b19:1;
		unsigned int _b20:1;
		unsigned int _b21:1;
		unsigned int _b22:1;
		unsigned int _b23:1;
		unsigned int _b24:1;
		unsigned int _b25:1;
		unsigned int _b26:1;
		unsigned int _b27:1;
		unsigned int _b28:1;
		unsigned int _b29:1;
		unsigned int _b30:1;
		unsigned int _b31:1;
};
// modelOSC

/** 0x4000 0000 OSC_CTL0 **/
union OSC_CTL0_REG{
	unsigned int reg;
	struct OSC_CTL0_BITS{
		unsigned int _PMWREN:1;
		unsigned int _SCKS:3;
		unsigned int _LFCKEN:1;
		unsigned int :1;
		unsigned int _LFCKS:1;
		unsigned int :1;
		unsigned int _HFCKEN:1;
		unsigned int _HFCKS:3;
		unsigned int _PLL0CKS:1;
		unsigned int :3;
		unsigned int _SCKDIV:3;
		unsigned int :1;
		unsigned int _HFCKDIV:4;
		unsigned int _LFCKDIV:3;
		unsigned int :3;
		unsigned int :1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL0 (*((volatile union OSC_CTL0_REG *)0x40000000))
// model

/** 0x4000 0004 OSC_CTL1 **/
union OSC_CTL1_REG{
	unsigned int reg;
	struct OSC_CTL1_BITS{
		unsigned int _CK48MEN:1;
		unsigned int _CK48MS:3;
		unsigned int _CK48DIV:2;
		unsigned int :10;
		unsigned int _FSCM:1;
		unsigned int :8;
		unsigned int _CLKOUTS:3;
		unsigned int _CLKOE:1;
		unsigned int _CLKOUTDIV:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL1 (*((volatile union OSC_CTL1_REG *)0x40000004))
// model

/** 0x4000 0008 OSC_INT **/
union OSC_INT_REG{
	unsigned int reg;
	struct OSC_INT_BITS{
		unsigned int _ILFIF:1;
		unsigned int _IHFIF:1;
		unsigned int _ELFIF:1;
		unsigned int _EHFIF:1;
		unsigned int _PLLIF:1;
		unsigned int :1;
		unsigned int _LP4MIF:1;
		unsigned int _CKFIF:1;
		unsigned int _ILFIE:1;
		unsigned int _IHFIE:1;
		unsigned int _ELFIE:1;
		unsigned int _EHFIE:1;
		unsigned int _PLLIE:1;
		unsigned int :1;
		unsigned int _LP4MIE:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_INT (*((volatile union OSC_INT_REG *)0x40000008))
// model

/** 0x4000 000C OSC_CTL2 **/
union OSC_CTL2_REG{
	unsigned int reg;
	struct OSC_CTL2_BITS{
		unsigned int _INTLFSWEN:1;
		unsigned int _INTHFSWEN:1;
		unsigned int _EXTLFSWEN:1;
		unsigned int _EXTHFSWEN:1;
		unsigned int _PLLSWEN:1;
		unsigned int :1;
		unsigned int _LP4MSWEN:1;
		unsigned int :9;
		unsigned int _ELFDLY:4;
		unsigned int _EHFDLY:4;
		unsigned int _PLLDLY:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL2 (*((volatile union OSC_CTL2_REG *)0x4000000C))
// model

/** 0x4000 0010 OSC_HFOSCCAL0 **/
union OSC_HFOSCCAL0_REG{
	unsigned int reg;
	struct OSC_HFOSCCAL0_BITS{
		unsigned int _CTAT0:1;
		unsigned int _CTAT1:1;
		unsigned int _CTAT2:1;
		unsigned int _CTAT3:1;
		unsigned int _CTAT4:1;
		unsigned int _PTAT0:1;
		unsigned int _PTAT1:1;
		unsigned int _PTAT2:1;
		unsigned int _PTAT3:1;
		unsigned int _PTAT4:1;
		unsigned int :7;
		unsigned int _SCALEDIV32:1;
		unsigned int _SCALEDIV16:1;
		unsigned int _SCALEDIV8:1;
		unsigned int _SCALEDIV4:1;
		unsigned int _SCALEDIV2:1;
		unsigned int _SCALE1X:1;
		unsigned int _SCALE2X:1;
		unsigned int _SCALE4X:1;
		unsigned int _SCALE8X:1;
		unsigned int _SCALE16X0:1;
		unsigned int _SCALE16X1:1;
		unsigned int _SCALE16X2:1;
		unsigned int _SCALE16X3:1;
		unsigned int _SCALE16X4:1;
		unsigned int _SCALE32X:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HFOSCCAL0 (*((volatile union OSC_HFOSCCAL0_REG *)0x40000010))
// model

/** 0x4000 0014 OSC_HFOSCCAL1 **/
union OSC_HFOSCCAL1_REG{
	unsigned int reg;
	struct OSC_HFOSCCAL1_BITS{
		unsigned int _HLSW:1;
		unsigned int _HSXTALEXEN:1;
		unsigned int _HSFSEN:1;
		unsigned int _SELGAIN0:1;
		unsigned int _SELGAIN1:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HFOSCCAL1 (*((volatile union OSC_HFOSCCAL1_REG *)0x40000014))
// modelQEI1

/** 0x4000 0080 QEI1_CTL0 **/
union QEI1_CTL0_REG{
	unsigned int reg;
	struct QEI1_CTL0_BITS{
		unsigned int _TXDIR:1;
		unsigned int _TXDIROUT:1;
		unsigned int _INDEX:1;
		unsigned int _TXCS:1;
		unsigned int _INDRES:1;
		unsigned int _QEIMOD0:1;
		unsigned int _QEIMOD1:1;
		unsigned int _QEIMOD2:1;
		unsigned int _CNTERRIF:1;
		unsigned int _PHEIF:1;
		unsigned int _TXIF:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI1_CTL0 (*((volatile union QEI1_CTL0_REG *)0x40000080))
// model

/** 0x4000 0084 QEI1_CTL1 **/
union QEI1_CTL1_REG{
	unsigned int reg;
	struct QEI1_CTL1_BITS{
		unsigned int _SWPAB:1;
		unsigned int _QEICK0:1;
		unsigned int _QEICK1:1;
		unsigned int _QEICK2:1;
		unsigned int _QEIOUT:1;
		unsigned int _QEICLK0:1;
		unsigned int _QEICLK1:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI1_CTL1 (*((volatile union QEI1_CTL1_REG *)0x40000084))
// modelT8

/** 0x4000 0088 T8_CNT **/
union T8_CNT_REG{
	unsigned int reg;
	struct T8_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T8_CNT (*((volatile union T8_CNT_REG *)0x40000088))
// model

/** 0x4000 008C T8_PPX **/
union T8_PPX_REG{
	unsigned int reg;
	struct T8_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T8_PPX (*((volatile union T8_PPX_REG *)0x4000008C))
// model

/** 0x4000 0090 T8_PRSC **/
union T8_PRSC_REG{
	unsigned int reg;
	struct T8_PRSC_BITS{
		unsigned int _TXPRSC:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T8_PRSC (*((volatile union T8_PRSC_REG *)0x40000090))
// modelQEI1

/** 0x4000 0094 QEI1_DIER **/
union QEI1_DIER_REG{
	unsigned int reg;
	struct QEI1_DIER_BITS{
		unsigned int _CNTERRIE:1;
		unsigned int _PHEIE:1;
		unsigned int _TXIE:1;
		unsigned int _CNTERRIC:1;
		unsigned int _PHEIC:1;
		unsigned int _TXIC:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI1_DIER (*((volatile union QEI1_DIER_REG *)0x40000094))
// modelT1

/** 0x4000 0100 T1_CNT **/
union T1_CNT_REG{
	unsigned int reg;
	struct T1_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CNT (*((volatile union T1_CNT_REG *)0x40000100))
// model

/** 0x4000 0104 T1_CTL1 **/
union T1_CTL1_REG{
	unsigned int reg;
	struct T1_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL1 (*((volatile union T1_CTL1_REG *)0x40000104))
// model

/** 0x4000 0108 T1_CTL2 **/
union T1_CTL2_REG{
	unsigned int reg;
	struct T1_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL2 (*((volatile union T1_CTL2_REG *)0x40000108))
// model

/** 0x4000 010C T1_PRSC **/
union T1_PRSC_REG{
	unsigned int reg;
	struct T1_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PRSC (*((volatile union T1_PRSC_REG *)0x4000010C))
// model

/** 0x4000 0110 T1_PPX **/
union T1_PPX_REG{
	unsigned int reg;
	struct T1_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PPX (*((volatile union T1_PPX_REG *)0x40000110))
// model

/** 0x4000 0114 T1_UDTIMx **/
union T1_UDTIMx_REG{
	unsigned int reg;
	struct T1_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_UDTIMx (*((volatile union T1_UDTIMx_REG *)0x40000114))
// modelCCP1

/** 0x4000 0120 CCP1_C1 **/
union CCP1_C1_REG{
	unsigned int reg;
	struct CCP1_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C1 (*((volatile union CCP1_C1_REG *)0x40000120))
// model

/** 0x4000 0124 CCP1_C2 **/
union CCP1_C2_REG{
	unsigned int reg;
	struct CCP1_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C2 (*((volatile union CCP1_C2_REG *)0x40000124))
// model

/** 0x4000 0128 CCP1_C3 **/
union CCP1_C3_REG{
	unsigned int reg;
	struct CCP1_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C3 (*((volatile union CCP1_C3_REG *)0x40000128))
// model

/** 0x4000 012C CCP1_C4 **/
union CCP1_C4_REG{
	unsigned int reg;
	struct CCP1_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C4 (*((volatile union CCP1_C4_REG *)0x4000012C))
// model

/** 0x4000 0130 CCP1_SRIC **/
union CCP1_SRIC_REG{
	unsigned int reg;
	struct CCP1_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_SRIC (*((volatile union CCP1_SRIC_REG *)0x40000130))
// model

/** 0x4000 0134 CCP1_DF **/
union CCP1_DF_REG{
	unsigned int reg;
	struct CCP1_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_DF (*((volatile union CCP1_DF_REG *)0x40000134))
// model

/** 0x4000 0140 CCP1_CTL1 **/
union CCP1_CTL1_REG{
	unsigned int reg;
	struct CCP1_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL1 (*((volatile union CCP1_CTL1_REG *)0x40000140))
// model

/** 0x4000 0144 CCP1_R1 **/
union CCP1_R1_REG{
	unsigned int reg;
	struct CCP1_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R1 (*((volatile union CCP1_R1_REG *)0x40000144))
// model

/** 0x4000 0148 CCP1_R2 **/
union CCP1_R2_REG{
	unsigned int reg;
	struct CCP1_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R2 (*((volatile union CCP1_R2_REG *)0x40000148))
// model

/** 0x4000 014C CCP1_R3 **/
union CCP1_R3_REG{
	unsigned int reg;
	struct CCP1_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R3 (*((volatile union CCP1_R3_REG *)0x4000014C))
// model

/** 0x4000 0150 CCP1_R4 **/
union CCP1_R4_REG{
	unsigned int reg;
	struct CCP1_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R4 (*((volatile union CCP1_R4_REG *)0x40000150))
// model

/** 0x4000 0154 CCP1_CTL2 **/
union CCP1_CTL2_REG{
	unsigned int reg;
	struct CCP1_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL2 (*((volatile union CCP1_CTL2_REG *)0x40000154))
// model

/** 0x4000 0158 CCP1_CTL3 **/
union CCP1_CTL3_REG{
	unsigned int reg;
	struct CCP1_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL3 (*((volatile union CCP1_CTL3_REG *)0x40000158))
// model

/** 0x4000 015C CCP1_EGIF **/
union CCP1_EGIF_REG{
	unsigned int reg;
	struct CCP1_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_EGIF (*((volatile union CCP1_EGIF_REG *)0x4000015C))
// modelT2

/** 0x4000 0180 T2_CNT **/
union T2_CNT_REG{
	unsigned int reg;
	struct T2_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CNT (*((volatile union T2_CNT_REG *)0x40000180))
// model

/** 0x4000 0184 T2_CTL1 **/
union T2_CTL1_REG{
	unsigned int reg;
	struct T2_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL1 (*((volatile union T2_CTL1_REG *)0x40000184))
// model

/** 0x4000 0188 T2_CTL2 **/
union T2_CTL2_REG{
	unsigned int reg;
	struct T2_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL2 (*((volatile union T2_CTL2_REG *)0x40000188))
// model

/** 0x4000 018C T2_PRSC **/
union T2_PRSC_REG{
	unsigned int reg;
	struct T2_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PRSC (*((volatile union T2_PRSC_REG *)0x4000018C))
// model

/** 0x4000 0190 T2_PPX **/
union T2_PPX_REG{
	unsigned int reg;
	struct T2_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PPX (*((volatile union T2_PPX_REG *)0x40000190))
// model

/** 0x4000 0194 T2_UDTIMx **/
union T2_UDTIMx_REG{
	unsigned int reg;
	struct T2_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_UDTIMx (*((volatile union T2_UDTIMx_REG *)0x40000194))
// modelCCP2

/** 0x4000 01A0 CCP2_C1 **/
union CCP2_C1_REG{
	unsigned int reg;
	struct CCP2_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C1 (*((volatile union CCP2_C1_REG *)0x400001A0))
// model

/** 0x4000 01A4 CCP2_C2 **/
union CCP2_C2_REG{
	unsigned int reg;
	struct CCP2_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C2 (*((volatile union CCP2_C2_REG *)0x400001A4))
// model

/** 0x4000 01A8 CCP2_C3 **/
union CCP2_C3_REG{
	unsigned int reg;
	struct CCP2_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C3 (*((volatile union CCP2_C3_REG *)0x400001A8))
// model

/** 0x4000 01AC CCP2_C4 **/
union CCP2_C4_REG{
	unsigned int reg;
	struct CCP2_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C4 (*((volatile union CCP2_C4_REG *)0x400001AC))
// model

/** 0x4000 01B0 CCP2_SRIC **/
union CCP2_SRIC_REG{
	unsigned int reg;
	struct CCP2_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_SRIC (*((volatile union CCP2_SRIC_REG *)0x400001B0))
// model

/** 0x4000 01B4 CCP2_DF **/
union CCP2_DF_REG{
	unsigned int reg;
	struct CCP2_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_DF (*((volatile union CCP2_DF_REG *)0x400001B4))
// model

/** 0x4000 01C0 CCP2_CTL1 **/
union CCP2_CTL1_REG{
	unsigned int reg;
	struct CCP2_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL1 (*((volatile union CCP2_CTL1_REG *)0x400001C0))
// model

/** 0x4000 01C4 CCP2_R1 **/
union CCP2_R1_REG{
	unsigned int reg;
	struct CCP2_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R1 (*((volatile union CCP2_R1_REG *)0x400001C4))
// model

/** 0x4000 01C8 CCP2_R2 **/
union CCP2_R2_REG{
	unsigned int reg;
	struct CCP2_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R2 (*((volatile union CCP2_R2_REG *)0x400001C8))
// model

/** 0x4000 01CC CCP2_R3 **/
union CCP2_R3_REG{
	unsigned int reg;
	struct CCP2_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R3 (*((volatile union CCP2_R3_REG *)0x400001CC))
// model

/** 0x4000 01D0 CCP2_R4 **/
union CCP2_R4_REG{
	unsigned int reg;
	struct CCP2_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R4 (*((volatile union CCP2_R4_REG *)0x400001D0))
// model

/** 0x4000 01D4 CCP2_CTL2 **/
union CCP2_CTL2_REG{
	unsigned int reg;
	struct CCP2_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL2 (*((volatile union CCP2_CTL2_REG *)0x400001D4))
// model

/** 0x4000 01D8 CCP2_CTL3 **/
union CCP2_CTL3_REG{
	unsigned int reg;
	struct CCP2_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL3 (*((volatile union CCP2_CTL3_REG *)0x400001D8))
// model

/** 0x4000 01DC CCP2_EGIF **/
union CCP2_EGIF_REG{
	unsigned int reg;
	struct CCP2_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_EGIF (*((volatile union CCP2_EGIF_REG *)0x400001DC))
// modelT3

/** 0x4000 0200 T3_CNT **/
union T3_CNT_REG{
	unsigned int reg;
	struct T3_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CNT (*((volatile union T3_CNT_REG *)0x40000200))
// model

/** 0x4000 0204 T3_CTL1 **/
union T3_CTL1_REG{
	unsigned int reg;
	struct T3_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL1 (*((volatile union T3_CTL1_REG *)0x40000204))
// model

/** 0x4000 0208 T3_CTL2 **/
union T3_CTL2_REG{
	unsigned int reg;
	struct T3_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL2 (*((volatile union T3_CTL2_REG *)0x40000208))
// model

/** 0x4000 020C T3_PRSC **/
union T3_PRSC_REG{
	unsigned int reg;
	struct T3_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PRSC (*((volatile union T3_PRSC_REG *)0x4000020C))
// model

/** 0x4000 0210 T3_PPX **/
union T3_PPX_REG{
	unsigned int reg;
	struct T3_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PPX (*((volatile union T3_PPX_REG *)0x40000210))
// model

/** 0x4000 0214 T3_UDTIMx **/
union T3_UDTIMx_REG{
	unsigned int reg;
	struct T3_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_UDTIMx (*((volatile union T3_UDTIMx_REG *)0x40000214))
// modelCCP3

/** 0x4000 0220 CCP3_C1 **/
union CCP3_C1_REG{
	unsigned int reg;
	struct CCP3_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C1 (*((volatile union CCP3_C1_REG *)0x40000220))
// model

/** 0x4000 0224 CCP3_C2 **/
union CCP3_C2_REG{
	unsigned int reg;
	struct CCP3_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C2 (*((volatile union CCP3_C2_REG *)0x40000224))
// model

/** 0x4000 0228 CCP3_C3 **/
union CCP3_C3_REG{
	unsigned int reg;
	struct CCP3_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C3 (*((volatile union CCP3_C3_REG *)0x40000228))
// model

/** 0x4000 022C CCP3_C4 **/
union CCP3_C4_REG{
	unsigned int reg;
	struct CCP3_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C4 (*((volatile union CCP3_C4_REG *)0x4000022C))
// model

/** 0x4000 0230 CCP3_SRIC **/
union CCP3_SRIC_REG{
	unsigned int reg;
	struct CCP3_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_SRIC (*((volatile union CCP3_SRIC_REG *)0x40000230))
// model

/** 0x4000 0234 CCP3_DF **/
union CCP3_DF_REG{
	unsigned int reg;
	struct CCP3_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_DF (*((volatile union CCP3_DF_REG *)0x40000234))
// model

/** 0x4000 0240 CCP3_CTL1 **/
union CCP3_CTL1_REG{
	unsigned int reg;
	struct CCP3_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL1 (*((volatile union CCP3_CTL1_REG *)0x40000240))
// model

/** 0x4000 0244 CCP3_R1 **/
union CCP3_R1_REG{
	unsigned int reg;
	struct CCP3_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R1 (*((volatile union CCP3_R1_REG *)0x40000244))
// model

/** 0x4000 0248 CCP3_R2 **/
union CCP3_R2_REG{
	unsigned int reg;
	struct CCP3_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R2 (*((volatile union CCP3_R2_REG *)0x40000248))
// model

/** 0x4000 024C CCP3_R3 **/
union CCP3_R3_REG{
	unsigned int reg;
	struct CCP3_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R3 (*((volatile union CCP3_R3_REG *)0x4000024C))
// model

/** 0x4000 0250 CCP3_R4 **/
union CCP3_R4_REG{
	unsigned int reg;
	struct CCP3_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R4 (*((volatile union CCP3_R4_REG *)0x40000250))
// model

/** 0x4000 0254 CCP3_CTL2 **/
union CCP3_CTL2_REG{
	unsigned int reg;
	struct CCP3_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL2 (*((volatile union CCP3_CTL2_REG *)0x40000254))
// model

/** 0x4000 0258 CCP3_CTL3 **/
union CCP3_CTL3_REG{
	unsigned int reg;
	struct CCP3_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL3 (*((volatile union CCP3_CTL3_REG *)0x40000258))
// model

/** 0x4000 025C CCP3_EGIF **/
union CCP3_EGIF_REG{
	unsigned int reg;
	struct CCP3_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_EGIF (*((volatile union CCP3_EGIF_REG *)0x4000025C))
// modelT4

/** 0x4000 0280 T4_CNT **/
union T4_CNT_REG{
	unsigned int reg;
	struct T4_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CNT (*((volatile union T4_CNT_REG *)0x40000280))
// model

/** 0x4000 0284 T4_CTL1 **/
union T4_CTL1_REG{
	unsigned int reg;
	struct T4_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL1 (*((volatile union T4_CTL1_REG *)0x40000284))
// model

/** 0x4000 0288 T4_CTL2 **/
union T4_CTL2_REG{
	unsigned int reg;
	struct T4_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL2 (*((volatile union T4_CTL2_REG *)0x40000288))
// model

/** 0x4000 028C T4_PRSC **/
union T4_PRSC_REG{
	unsigned int reg;
	struct T4_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PRSC (*((volatile union T4_PRSC_REG *)0x4000028C))
// model

/** 0x4000 0290 T4_PPX **/
union T4_PPX_REG{
	unsigned int reg;
	struct T4_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PPX (*((volatile union T4_PPX_REG *)0x40000290))
// model

/** 0x4000 0294 T4_UDTIMx **/
union T4_UDTIMx_REG{
	unsigned int reg;
	struct T4_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_UDTIMx (*((volatile union T4_UDTIMx_REG *)0x40000294))
// modelCCP4

/** 0x4000 02A0 CCP4_C1 **/
union CCP4_C1_REG{
	unsigned int reg;
	struct CCP4_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C1 (*((volatile union CCP4_C1_REG *)0x400002A0))
// model

/** 0x4000 02A4 CCP4_C2 **/
union CCP4_C2_REG{
	unsigned int reg;
	struct CCP4_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C2 (*((volatile union CCP4_C2_REG *)0x400002A4))
// model

/** 0x4000 02A8 CCP4_C3 **/
union CCP4_C3_REG{
	unsigned int reg;
	struct CCP4_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C3 (*((volatile union CCP4_C3_REG *)0x400002A8))
// model

/** 0x4000 02AC CCP4_C4 **/
union CCP4_C4_REG{
	unsigned int reg;
	struct CCP4_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C4 (*((volatile union CCP4_C4_REG *)0x400002AC))
// model

/** 0x4000 02B0 CCP4_SRIC **/
union CCP4_SRIC_REG{
	unsigned int reg;
	struct CCP4_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_SRIC (*((volatile union CCP4_SRIC_REG *)0x400002B0))
// model

/** 0x4000 02B4 CCP4_DF **/
union CCP4_DF_REG{
	unsigned int reg;
	struct CCP4_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_DF (*((volatile union CCP4_DF_REG *)0x400002B4))
// model

/** 0x4000 02C0 CCP4_CTL1 **/
union CCP4_CTL1_REG{
	unsigned int reg;
	struct CCP4_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL1 (*((volatile union CCP4_CTL1_REG *)0x400002C0))
// model

/** 0x4000 02C4 CCP4_R1 **/
union CCP4_R1_REG{
	unsigned int reg;
	struct CCP4_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R1 (*((volatile union CCP4_R1_REG *)0x400002C4))
// model

/** 0x4000 02C8 CCP4_R2 **/
union CCP4_R2_REG{
	unsigned int reg;
	struct CCP4_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R2 (*((volatile union CCP4_R2_REG *)0x400002C8))
// model

/** 0x4000 02CC CCP4_R3 **/
union CCP4_R3_REG{
	unsigned int reg;
	struct CCP4_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R3 (*((volatile union CCP4_R3_REG *)0x400002CC))
// model

/** 0x4000 02D0 CCP4_R4 **/
union CCP4_R4_REG{
	unsigned int reg;
	struct CCP4_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R4 (*((volatile union CCP4_R4_REG *)0x400002D0))
// model

/** 0x4000 02D4 CCP4_CTL2 **/
union CCP4_CTL2_REG{
	unsigned int reg;
	struct CCP4_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL2 (*((volatile union CCP4_CTL2_REG *)0x400002D4))
// model

/** 0x4000 02D8 CCP4_CTL3 **/
union CCP4_CTL3_REG{
	unsigned int reg;
	struct CCP4_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL3 (*((volatile union CCP4_CTL3_REG *)0x400002D8))
// model

/** 0x4000 02DC CCP4_EGIF **/
union CCP4_EGIF_REG{
	unsigned int reg;
	struct CCP4_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_EGIF (*((volatile union CCP4_EGIF_REG *)0x400002DC))
// modelT5

/** 0x4000 0300 T5_CNT **/
union T5_CNT_REG{
	unsigned int reg;
	struct T5_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CNT (*((volatile union T5_CNT_REG *)0x40000300))
// modelT6

/** 0x4000 0304 T6_CNT **/
union T6_CNT_REG{
	unsigned int reg;
	struct T6_CNT_BITS{
		unsigned int _TZCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CNT (*((volatile union T6_CNT_REG *)0x40000304))
// modelT5

/** 0x4000 0308 T5_PPX **/
union T5_PPX_REG{
	unsigned int reg;
	struct T5_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PPX (*((volatile union T5_PPX_REG *)0x40000308))
// modelT6

/** 0x4000 030C T6_PPX **/
union T6_PPX_REG{
	unsigned int reg;
	struct T6_PPX_BITS{
		unsigned int _PPZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PPX (*((volatile union T6_PPX_REG *)0x4000030C))
// modelT5

/** 0x4000 0310 T5_PRSC **/
union T5_PRSC_REG{
	unsigned int reg;
	struct T5_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PRSC (*((volatile union T5_PRSC_REG *)0x40000310))
// modelT6

/** 0x4000 0314 T6_PRSC **/
union T6_PRSC_REG{
	unsigned int reg;
	struct T6_PRSC_BITS{
		unsigned int _TZCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PRSC (*((volatile union T6_PRSC_REG *)0x40000314))
// modelT5

/** 0x4000 0318 T5_CCR0 **/
union T5_CCR0_REG{
	unsigned int reg;
	struct T5_CCR0_BITS{
		unsigned int _TXCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCR0 (*((volatile union T5_CCR0_REG *)0x40000318))
// model

/** 0x4000 031C T5_CCR1 **/
union T5_CCR1_REG{
	unsigned int reg;
	struct T5_CCR1_BITS{
		unsigned int _TXCCR1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCR1 (*((volatile union T5_CCR1_REG *)0x4000031C))
// modelT6

/** 0x4000 0320 T6_CCR0 **/
union T6_CCR0_REG{
	unsigned int reg;
	struct T6_CCR0_BITS{
		unsigned int _TZCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CCR0 (*((volatile union T6_CCR0_REG *)0x40000320))
// modelT5

/** 0x4000 0324 T5_CTL **/
union T5_CTL_REG{
	unsigned int reg;
	struct T5_CTL_BITS{
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXEN:1;
		unsigned int _TXCKBS:4;
		unsigned int _TXDIR:1;
		unsigned int _TXCLK:2;
		unsigned int _TXADAUTO:1;
		unsigned int _TXOFS:2;
		unsigned int _TXCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CTL (*((volatile union T5_CTL_REG *)0x40000324))
// modelT6

/** 0x4000 0328 T6_CTL **/
union T6_CTL_REG{
	unsigned int reg;
	struct T6_CTL_BITS{
		unsigned int _TZCS:1;
		unsigned int _TZSY:1;
		unsigned int _TZEN:1;
		unsigned int _TZCKBS:4;
		unsigned int _TZDIR:1;
		unsigned int _TZCLK:2;
		unsigned int _TZADAUTO:1;
		unsigned int _TZOFS0:1;
		unsigned int _TZOFS1:1;
		unsigned int _TZCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CTL (*((volatile union T6_CTL_REG *)0x40000328))
// modelECCP5

/** 0x4000 032C ECCP5_PDCTL **/
union ECCP5_PDCTL_REG{
	unsigned int reg;
	struct ECCP5_PDCTL_BITS{
		unsigned int _CPE0:1;
		unsigned int _CPE1:1;
		unsigned int _CMPE:1;
		unsigned int _TI0_EN:1;
		unsigned int _TI1_EN:1;
		unsigned int _TI2_EN:1;
		unsigned int :1;
		unsigned int _SMPEN:1;
		unsigned int _RDA:3;
		unsigned int :1;
		unsigned int _CPD:3;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PDCTL (*((volatile union ECCP5_PDCTL_REG *)0x4000032C))
// model

/** 0x4000 0330 ECCP5_PXASCTL **/
union ECCP5_PXASCTL_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL_BITS{
		unsigned int _PXASS:1;
		unsigned int :31;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL (*((volatile union ECCP5_PXASCTL_REG *)0x40000330))
// model

/** 0x4000 0380 ECCP5_CTL1 **/
union ECCP5_CTL1_REG{
	unsigned int reg;
	struct ECCP5_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL1 (*((volatile union ECCP5_CTL1_REG *)0x40000380))
// model

/** 0x4000 0384 ECCP5_R1 **/
union ECCP5_R1_REG{
	unsigned int reg;
	struct ECCP5_R1_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R1 (*((volatile union ECCP5_R1_REG *)0x40000384))
// model

/** 0x4000 0388 ECCP5_R2 **/
union ECCP5_R2_REG{
	unsigned int reg;
	struct ECCP5_R2_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R2 (*((volatile union ECCP5_R2_REG *)0x40000388))
// model

/** 0x4000 038C ECCP5_R3 **/
union ECCP5_R3_REG{
	unsigned int reg;
	struct ECCP5_R3_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R3 (*((volatile union ECCP5_R3_REG *)0x4000038C))
// model

/** 0x4000 0390 ECCP5_R4 **/
union ECCP5_R4_REG{
	unsigned int reg;
	struct ECCP5_R4_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R4 (*((volatile union ECCP5_R4_REG *)0x40000390))
// model

/** 0x4000 0394 ECCP5_PxUDCTL **/
union ECCP5_PxUDCTL_REG{
	unsigned int reg;
	struct ECCP5_PxUDCTL_BITS{
		unsigned int _PXUDEN0:1;
		unsigned int _PXUDEN1:1;
		unsigned int _PXUDEVT0:1;
		unsigned int _PXUDEVT1:1;
		unsigned int _PXUDEVT2:1;
		unsigned int _PXUDEVT3:1;
		unsigned int _PXMPEN:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PxUDCTL (*((volatile union ECCP5_PxUDCTL_REG *)0x40000394))
// model

/** 0x4000 0398 ECCP5_CTL2 **/
union ECCP5_CTL2_REG{
	unsigned int reg;
	struct ECCP5_CTL2_BITS{
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:3;
		unsigned int _TXMSSYNC:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _TZSMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL2 (*((volatile union ECCP5_CTL2_REG *)0x40000398))
// model

/** 0x4000 039C ECCP5_PXDTCTL **/
union ECCP5_PXDTCTL_REG{
	unsigned int reg;
	struct ECCP5_PXDTCTL_BITS{
		unsigned int _PXDC:8;
		unsigned int _PZDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXDTCTL (*((volatile union ECCP5_PXDTCTL_REG *)0x4000039C))
// model

/** 0x4000 03A0 ECCP5_PWMXOC **/
union ECCP5_PWMXOC_REG{
	unsigned int reg;
	struct ECCP5_PWMXOC_BITS{
		unsigned int _PXOC1L:2;
		unsigned int _PXOC1H:2;
		unsigned int _PXOC2L:2;
		unsigned int _PXOC2H:2;
		unsigned int _PXOC3L:2;
		unsigned int _PXOC3H:2;
		unsigned int _PXOC4L:2;
		unsigned int _PXOC4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PWMXOC (*((volatile union ECCP5_PWMXOC_REG *)0x400003A0))
// model

/** 0x4000 03A4 ECCP5_PXATRCTL **/
union ECCP5_PXATRCTL_REG{
	unsigned int reg;
	struct ECCP5_PXATRCTL_BITS{
		unsigned int :8;
		unsigned int _PXCH1MOD:1;
		unsigned int _PXCH2MOD:1;
		unsigned int _PXCH3MOD:1;
		unsigned int _PXCH4MOD:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXATRCTL (*((volatile union ECCP5_PXATRCTL_REG *)0x400003A4))
// model

/** 0x4000 03A8 ECCP5_PXASCTL0 **/
union ECCP5_PXASCTL0_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL0_BITS{
		unsigned int _PXASS1:2;
		unsigned int _PXASS2:2;
		unsigned int _PXASS3:2;
		unsigned int _PXASS4:2;
		unsigned int _PXASE1:1;
		unsigned int _PXASE2:1;
		unsigned int _PXASE3:1;
		unsigned int _PXASE4:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL0 (*((volatile union ECCP5_PXASCTL0_REG *)0x400003A8))
// model

/** 0x4000 03AC ECCP5_PXASCTL1 **/
union ECCP5_PXASCTL1_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL1_BITS{
		unsigned int _PXSS1L:2;
		unsigned int _PXSS1H:2;
		unsigned int _PXSS2L:2;
		unsigned int _PXSS2H:2;
		unsigned int _PXSS3L:2;
		unsigned int _PXSS3H:2;
		unsigned int _PXSS4L:2;
		unsigned int _PXSS4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL1 (*((volatile union ECCP5_PXASCTL1_REG *)0x400003AC))
// model

/** 0x4000 03B0 ECCP5_ZPDCTL0 **/
union ECCP5_ZPDCTL0_REG{
	unsigned int reg;
	struct ECCP5_ZPDCTL0_BITS{
		unsigned int _ZPD1FLAG:1;
		unsigned int _ZPD2FLAG:1;
		unsigned int _ZPD3FLAG:1;
		unsigned int _ZPD4FLAG:1;
		unsigned int _ZPD1TWIN:1;
		unsigned int _ZPD2TWIN:1;
		unsigned int _ZPD3TWIN:1;
		unsigned int _ZPD4TWIN:1;
		unsigned int _ZCLK:4;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_ZPDCTL0 (*((volatile union ECCP5_ZPDCTL0_REG *)0x400003B0))
// model

/** 0x4000 03B4 ECCP5_ZPDCTL1 **/
union ECCP5_ZPDCTL1_REG{
	unsigned int reg;
	struct ECCP5_ZPDCTL1_BITS{
		unsigned int _ZPD1S:3;
		unsigned int _ZPD2S:3;
		unsigned int _ZPD3S:3;
		unsigned int _ZPD4S:3;
		unsigned int _ZPD1EN:1;
		unsigned int _ZPD2EN:1;
		unsigned int _ZPD3EN:1;
		unsigned int _ZPD4EN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_ZPDCTL1 (*((volatile union ECCP5_ZPDCTL1_REG *)0x400003B4))
// model

/** 0x4000 03B8 ECCP5_ZPDPORT **/
union ECCP5_ZPDPORT_REG{
	unsigned int reg;
	struct ECCP5_ZPDPORT_BITS{
		unsigned int _ZPORT0:1;
		unsigned int _ZPORT1:1;
		unsigned int _ZPORT2:1;
		unsigned int _ZPORT3:1;
		unsigned int _ZPORT4:1;
		unsigned int _ZPORT5:1;
		unsigned int _ZPORT6:1;
		unsigned int _ZPORT7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_ZPDPORT (*((volatile union ECCP5_ZPDPORT_REG *)0x400003B8))
// model

/** 0x4000 03BC ECCP5_IE **/
union ECCP5_IE_REG{
	unsigned int reg;
	struct ECCP5_IE_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TZIE:1;
		unsigned int _TXIE:1;
		unsigned int _TZUIE:1;
		unsigned int _TXUIE:1;
		unsigned int _CPIE:1;
		unsigned int _PDIE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_IE (*((volatile union ECCP5_IE_REG *)0x400003BC))
// model

/** 0x4000 03C0 ECCP5_EGIF **/
union ECCP5_EGIF_REG{
	unsigned int reg;
	struct ECCP5_EGIF_BITS{
		unsigned int _CPIF:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TZIF:1;
		unsigned int _TXIF:1;
		unsigned int _TZUIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PDIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_EGIF (*((volatile union ECCP5_EGIF_REG *)0x400003C0))
// modelT5

/** 0x4000 03C4 T5_UDTIMX **/
union T5_UDTIMX_REG{
	unsigned int reg;
	struct T5_UDTIMX_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_UDTIMX (*((volatile union T5_UDTIMX_REG *)0x400003C4))
// modelT6

/** 0x4000 03C8 T6_UDTIMZ **/
union T6_UDTIMZ_REG{
	unsigned int reg;
	struct T6_UDTIMZ_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_UDTIMZ (*((volatile union T6_UDTIMZ_REG *)0x400003C8))
// modelECCP5

/** 0x4000 03CC ECCP5_DF **/
union ECCP5_DF_REG{
	unsigned int reg;
	struct ECCP5_DF_BITS{
		unsigned int _CH1DF:1;
		unsigned int _CH2DF:1;
		unsigned int _CH3DF:1;
		unsigned int _CH4DF:1;
		unsigned int _CLSDF:1;
		unsigned int _TRIGDF:1;
		unsigned int _TZUDF:1;
		unsigned int _TXUDF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DF (*((volatile union ECCP5_DF_REG *)0x400003CC))
// model

/** 0x4000 03D0 ECCP5_C1 **/
union ECCP5_C1_REG{
	unsigned int reg;
	struct ECCP5_C1_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C1 (*((volatile union ECCP5_C1_REG *)0x400003D0))
// model

/** 0x4000 03D4 ECCP5_C2 **/
union ECCP5_C2_REG{
	unsigned int reg;
	struct ECCP5_C2_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C2 (*((volatile union ECCP5_C2_REG *)0x400003D4))
// model

/** 0x4000 03D8 ECCP5_C3 **/
union ECCP5_C3_REG{
	unsigned int reg;
	struct ECCP5_C3_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C3 (*((volatile union ECCP5_C3_REG *)0x400003D8))
// model

/** 0x4000 03DC ECCP5_C4 **/
union ECCP5_C4_REG{
	unsigned int reg;
	struct ECCP5_C4_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C4 (*((volatile union ECCP5_C4_REG *)0x400003DC))
// model

/** 0x4000 03E4 ECCP5_DE **/
union ECCP5_DE_REG{
	unsigned int reg;
	struct ECCP5_DE_BITS{
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CLSDE:1;
		unsigned int _TXTDE:1;
		unsigned int _TZUDE:1;
		unsigned int _TXUDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DE (*((volatile union ECCP5_DE_REG *)0x400003E4))
// model

/** 0x4000 03E8 ECCP5_SRIC **/
union ECCP5_SRIC_REG{
	unsigned int reg;
	struct ECCP5_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TZIC:1;
		unsigned int _TXIC:1;
		unsigned int _TZUIC:1;
		unsigned int _TXUIC:1;
		unsigned int _CPIC:1;
		unsigned int _PDIC:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_SRIC (*((volatile union ECCP5_SRIC_REG *)0x400003E8))
// model

/** 0x4000 03EC ECCP5_CTL3 **/
union ECCP5_CTL3_REG{
	unsigned int reg;
	struct ECCP5_CTL3_BITS{
		unsigned int _PXSPMST:1;
		unsigned int _TUNITE:1;
		unsigned int _PRSEN:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL3 (*((volatile union ECCP5_CTL3_REG *)0x400003EC))
// modelT9

/** 0x4000 0400 T9_CNT **/
union T9_CNT_REG{
	unsigned int reg;
	struct T9_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CNT (*((volatile union T9_CNT_REG *)0x40000400))
// modelT10

/** 0x4000 0404 T10_CNT **/
union T10_CNT_REG{
	unsigned int reg;
	struct T10_CNT_BITS{
		unsigned int _TZCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CNT (*((volatile union T10_CNT_REG *)0x40000404))
// modelT9

/** 0x4000 0408 T9_PPX **/
union T9_PPX_REG{
	unsigned int reg;
	struct T9_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_PPX (*((volatile union T9_PPX_REG *)0x40000408))
// modelT10

/** 0x4000 040C T10_PPX **/
union T10_PPX_REG{
	unsigned int reg;
	struct T10_PPX_BITS{
		unsigned int _PPZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_PPX (*((volatile union T10_PPX_REG *)0x4000040C))
// modelT9

/** 0x4000 0410 T9_PRSC **/
union T9_PRSC_REG{
	unsigned int reg;
	struct T9_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_PRSC (*((volatile union T9_PRSC_REG *)0x40000410))
// modelT10

/** 0x4000 0414 T10_PRSC **/
union T10_PRSC_REG{
	unsigned int reg;
	struct T10_PRSC_BITS{
		unsigned int _TZCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_PRSC (*((volatile union T10_PRSC_REG *)0x40000414))
// modelT9

/** 0x4000 0418 T9_CCR0 **/
union T9_CCR0_REG{
	unsigned int reg;
	struct T9_CCR0_BITS{
		unsigned int _TXCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CCR0 (*((volatile union T9_CCR0_REG *)0x40000418))
// model

/** 0x4000 041C T9_CCR1 **/
union T9_CCR1_REG{
	unsigned int reg;
	struct T9_CCR1_BITS{
		unsigned int _TXCCR1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CCR1 (*((volatile union T9_CCR1_REG *)0x4000041C))
// modelT10

/** 0x4000 0420 T10_CCR0 **/
union T10_CCR0_REG{
	unsigned int reg;
	struct T10_CCR0_BITS{
		unsigned int _TZCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CCR0 (*((volatile union T10_CCR0_REG *)0x40000420))
// modelT9

/** 0x4000 0424 T9_CTL **/
union T9_CTL_REG{
	unsigned int reg;
	struct T9_CTL_BITS{
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXEN:1;
		unsigned int _TXCKBS:4;
		unsigned int _TXDIR:1;
		unsigned int _TXCLK:2;
		unsigned int _TXADAUTO:1;
		unsigned int _TXOFS:2;
		unsigned int _TXCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CTL (*((volatile union T9_CTL_REG *)0x40000424))
// modelT10

/** 0x4000 0428 T10_CTL **/
union T10_CTL_REG{
	unsigned int reg;
	struct T10_CTL_BITS{
		unsigned int _TZCS:1;
		unsigned int _TZSY:1;
		unsigned int _TZEN:1;
		unsigned int _TZCKBS:4;
		unsigned int _TZDIR:1;
		unsigned int _TZCLK:2;
		unsigned int _TZADAUTO:1;
		unsigned int _TZOFS:2;
		unsigned int _TZCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CTL (*((volatile union T10_CTL_REG *)0x40000428))
// modelECCP9

/** 0x4000 042C ECCP9_PDCTL **/
union ECCP9_PDCTL_REG{
	unsigned int reg;
	struct ECCP9_PDCTL_BITS{
		unsigned int _CPE0:1;
		unsigned int _CPE1:1;
		unsigned int _CMPE:1;
		unsigned int _TI0_EN:1;
		unsigned int _TI1_EN:1;
		unsigned int _TI2_EN:1;
		unsigned int :1;
		unsigned int _SMPEN:1;
		unsigned int _RDA:3;
		unsigned int :1;
		unsigned int _CPD:3;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PDCTL (*((volatile union ECCP9_PDCTL_REG *)0x4000042C))
// model

/** 0x4000 0430 ECCP9_PXASCTL **/
union ECCP9_PXASCTL_REG{
	unsigned int reg;
	struct ECCP9_PXASCTL_BITS{
		unsigned int _PXASS:1;
		unsigned int :31;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXASCTL (*((volatile union ECCP9_PXASCTL_REG *)0x40000430))
// model

/** 0x4000 0480 ECCP9_CTL1 **/
union ECCP9_CTL1_REG{
	unsigned int reg;
	struct ECCP9_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL1 (*((volatile union ECCP9_CTL1_REG *)0x40000480))
// model

/** 0x4000 0484 ECCP9_R1 **/
union ECCP9_R1_REG{
	unsigned int reg;
	struct ECCP9_R1_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R1 (*((volatile union ECCP9_R1_REG *)0x40000484))
// model

/** 0x4000 0488 ECCP9_R2 **/
union ECCP9_R2_REG{
	unsigned int reg;
	struct ECCP9_R2_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R2 (*((volatile union ECCP9_R2_REG *)0x40000488))
// model

/** 0x4000 048C ECCP9_R3 **/
union ECCP9_R3_REG{
	unsigned int reg;
	struct ECCP9_R3_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R3 (*((volatile union ECCP9_R3_REG *)0x4000048C))
// model

/** 0x4000 0490 ECCP9_R4 **/
union ECCP9_R4_REG{
	unsigned int reg;
	struct ECCP9_R4_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R4 (*((volatile union ECCP9_R4_REG *)0x40000490))
// model

/** 0x4000 0494 ECCP9_PxUDCTL **/
union ECCP9_PxUDCTL_REG{
	unsigned int reg;
	struct ECCP9_PxUDCTL_BITS{
		unsigned int _PxUDEN0:1;
		unsigned int _PxUDEN1:1;
		unsigned int _PxUDEVT0:1;
		unsigned int _PxUDEVT1:1;
		unsigned int _PxUDEVT2:1;
		unsigned int _PxUDEVT3:1;
		unsigned int _PXMPEN:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PxUDCTL (*((volatile union ECCP9_PxUDCTL_REG *)0x40000494))
// model

/** 0x4000 0498 ECCP9_CTL2 **/
union ECCP9_CTL2_REG{
	unsigned int reg;
	struct ECCP9_CTL2_BITS{
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:3;
		unsigned int _TXMSSYNC:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _TZSMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL2 (*((volatile union ECCP9_CTL2_REG *)0x40000498))
// model

/** 0x4000 049C ECCP9_PXDTCTL **/
union ECCP9_PXDTCTL_REG{
	unsigned int reg;
	struct ECCP9_PXDTCTL_BITS{
		unsigned int _PxDC:8;
		unsigned int _PzDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXDTCTL (*((volatile union ECCP9_PXDTCTL_REG *)0x4000049C))
// model

/** 0x4000 04A0 ECCP9_PWMXOC **/
union ECCP9_PWMXOC_REG{
	unsigned int reg;
	struct ECCP9_PWMXOC_BITS{
		unsigned int _PXOC1L:2;
		unsigned int _PXOC1H:2;
		unsigned int _PXOC2L:2;
		unsigned int _PXOC2H:2;
		unsigned int _PXOC3L:2;
		unsigned int _PXOC3H:2;
		unsigned int _PXOC4L:2;
		unsigned int _PXOC4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PWMXOC (*((volatile union ECCP9_PWMXOC_REG *)0x400004A0))
// model

/** 0x4000 04A4 ECCP9_PXATRCTL **/
union ECCP9_PXATRCTL_REG{
	unsigned int reg;
	struct ECCP9_PXATRCTL_BITS{
		unsigned int :8;
		unsigned int _PxCH1MOD:1;
		unsigned int _PxCH2MOD:1;
		unsigned int _PxCH3MOD:1;
		unsigned int _PxCH4MOD:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXATRCTL (*((volatile union ECCP9_PXATRCTL_REG *)0x400004A4))
// model

/** 0x4000 04A8 ECCP9_PXASCTL0 **/
union ECCP9_PXASCTL0_REG{
	unsigned int reg;
	struct ECCP9_PXASCTL0_BITS{
		unsigned int _PXASS1:2;
		unsigned int _PXASS2:2;
		unsigned int _PXASS3:2;
		unsigned int _PXASS4:2;
		unsigned int _PXASE1:1;
		unsigned int _PXASE2:1;
		unsigned int _PXASE3:1;
		unsigned int _PXASE4:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXASCTL0 (*((volatile union ECCP9_PXASCTL0_REG *)0x400004A8))
// model

/** 0x4000 04AC ECCP9_PXASCTL1 **/
union ECCP9_PXASCTL1_REG{
	unsigned int reg;
	struct ECCP9_PXASCTL1_BITS{
		unsigned int _PXSS1L:2;
		unsigned int _PXSS1H:2;
		unsigned int _PXSS2L:2;
		unsigned int _PXSS2H:2;
		unsigned int _PXSS3L:2;
		unsigned int _PXSS3H:2;
		unsigned int _PXSS4L:2;
		unsigned int _PXSS4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXASCTL1 (*((volatile union ECCP9_PXASCTL1_REG *)0x400004AC))
// model

/** 0x4000 04B0 ECCP9_ZPDCTL0 **/
union ECCP9_ZPDCTL0_REG{
	unsigned int reg;
	struct ECCP9_ZPDCTL0_BITS{
		unsigned int _ZPD1FLAG:1;
		unsigned int _ZPD2FLAG:1;
		unsigned int _ZPD3FLAG:1;
		unsigned int _ZPD4FLAG:1;
		unsigned int _ZPD1TWIN:1;
		unsigned int _ZPD2TWIN:1;
		unsigned int _ZPD3TWIN:1;
		unsigned int _ZPD4TWIN:1;
		unsigned int _ZCLK:4;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_ZPDCTL0 (*((volatile union ECCP9_ZPDCTL0_REG *)0x400004B0))
// model

/** 0x4000 04B4 ECCP9_ZPDCTL1 **/
union ECCP9_ZPDCTL1_REG{
	unsigned int reg;
	struct ECCP9_ZPDCTL1_BITS{
		unsigned int _ZPD1S:3;
		unsigned int _ZPD2S:3;
		unsigned int _ZPD3S:3;
		unsigned int _ZPD4S:3;
		unsigned int _ZPD1EN:1;
		unsigned int _ZPD2EN:1;
		unsigned int _ZPD3EN:1;
		unsigned int _ZPD4EN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_ZPDCTL1 (*((volatile union ECCP9_ZPDCTL1_REG *)0x400004B4))
// model

/** 0x4000 04B8 ECCP9_ZPDPORT **/
union ECCP9_ZPDPORT_REG{
	unsigned int reg;
	struct ECCP9_ZPDPORT_BITS{
		unsigned int _ZPORT0:1;
		unsigned int _ZPORT1:1;
		unsigned int _ZPORT2:1;
		unsigned int _ZPORT3:1;
		unsigned int _ZPORT4:1;
		unsigned int _ZPORT5:1;
		unsigned int _ZPORT6:1;
		unsigned int _ZPORT7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_ZPDPORT (*((volatile union ECCP9_ZPDPORT_REG *)0x400004B8))
// model

/** 0x4000 04BC ECCP9_IE **/
union ECCP9_IE_REG{
	unsigned int reg;
	struct ECCP9_IE_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TZIE:1;
		unsigned int _TXIE:1;
		unsigned int _TZUIE:1;
		unsigned int _TXUIE:1;
		unsigned int _CPIE:1;
		unsigned int _PDIE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_IE (*((volatile union ECCP9_IE_REG *)0x400004BC))
// model

/** 0x4000 04C0 ECCP9_EGIF **/
union ECCP9_EGIF_REG{
	unsigned int reg;
	struct ECCP9_EGIF_BITS{
		unsigned int _CPIF:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TZIF:1;
		unsigned int _TXIF:1;
		unsigned int _TZUIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PDIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_EGIF (*((volatile union ECCP9_EGIF_REG *)0x400004C0))
// modelT9

/** 0x4000 04C4 T9_UDTIMx **/
union T9_UDTIMx_REG{
	unsigned int reg;
	struct T9_UDTIMx_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_UDTIMx (*((volatile union T9_UDTIMx_REG *)0x400004C4))
// modelT10

/** 0x4000 04C8 T10_UDTIMx **/
union T10_UDTIMx_REG{
	unsigned int reg;
	struct T10_UDTIMx_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_UDTIMx (*((volatile union T10_UDTIMx_REG *)0x400004C8))
// modelECCP9

/** 0x4000 04CC ECCP9_DF **/
union ECCP9_DF_REG{
	unsigned int reg;
	struct ECCP9_DF_BITS{
		unsigned int _CH1DF:1;
		unsigned int _CH2DF:1;
		unsigned int _CH3DF:1;
		unsigned int _CH4DF:1;
		unsigned int _CLSDF:1;
		unsigned int _TRIGDF:1;
		unsigned int _TZUDF:1;
		unsigned int _TXUDF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_DF (*((volatile union ECCP9_DF_REG *)0x400004CC))
// model

/** 0x4000 04D0 ECCP9_C1 **/
union ECCP9_C1_REG{
	unsigned int reg;
	struct ECCP9_C1_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C1 (*((volatile union ECCP9_C1_REG *)0x400004D0))
// model

/** 0x4000 04D4 ECCP9_C2 **/
union ECCP9_C2_REG{
	unsigned int reg;
	struct ECCP9_C2_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C2 (*((volatile union ECCP9_C2_REG *)0x400004D4))
// model

/** 0x4000 04D8 ECCP9_C3 **/
union ECCP9_C3_REG{
	unsigned int reg;
	struct ECCP9_C3_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C3 (*((volatile union ECCP9_C3_REG *)0x400004D8))
// model

/** 0x4000 04DC ECCP9_C4 **/
union ECCP9_C4_REG{
	unsigned int reg;
	struct ECCP9_C4_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C4 (*((volatile union ECCP9_C4_REG *)0x400004DC))
// model

/** 0x4000 04E4 ECCP9_DE **/
union ECCP9_DE_REG{
	unsigned int reg;
	struct ECCP9_DE_BITS{
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CLSDE:1;
		unsigned int _TXTDE:1;
		unsigned int _TZUDE:1;
		unsigned int _TXUDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_DE (*((volatile union ECCP9_DE_REG *)0x400004E4))
// model

/** 0x4000 04E8 ECCP9_SRIC **/
union ECCP9_SRIC_REG{
	unsigned int reg;
	struct ECCP9_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TZIC:1;
		unsigned int _TXIC:1;
		unsigned int _TZUIC:1;
		unsigned int _TXUIC:1;
		unsigned int _CPIC:1;
		unsigned int _PDIC:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_SRIC (*((volatile union ECCP9_SRIC_REG *)0x400004E8))
// model

/** 0x4000 04EC ECCP9_CTL3 **/
union ECCP9_CTL3_REG{
	unsigned int reg;
	struct ECCP9_CTL3_BITS{
		unsigned int _PXSPMST:1;
		unsigned int _TUNITE:1;
		unsigned int _PRSEN:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL3 (*((volatile union ECCP9_CTL3_REG *)0x400004EC))
// modelQEI0

/** 0x4000 0500 QEI0_CTL0 **/
union QEI0_CTL0_REG{
	unsigned int reg;
	struct QEI0_CTL0_BITS{
		unsigned int _TXDIR:1;
		unsigned int _TXDIROUT:1;
		unsigned int _INDEX:1;
		unsigned int _TXCS:1;
		unsigned int _INDRES:1;
		unsigned int _QEIMOD:3;
		unsigned int _CNTERRIF:1;
		unsigned int _PHEIF:1;
		unsigned int _TXIF:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI0_CTL0 (*((volatile union QEI0_CTL0_REG *)0x40000500))
// model

/** 0x4000 0504 QEI0_CTL1 **/
union QEI0_CTL1_REG{
	unsigned int reg;
	struct QEI0_CTL1_BITS{
		unsigned int _SWPAB:1;
		unsigned int _QEICK0:1;
		unsigned int _QEICK1:1;
		unsigned int _QEICK2:1;
		unsigned int _QEIOUT:1;
		unsigned int _QEICLK0:1;
		unsigned int _QEICLK1:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI0_CTL1 (*((volatile union QEI0_CTL1_REG *)0x40000504))
// modelT7

/** 0x4000 0508 T7_CNT **/
union T7_CNT_REG{
	unsigned int reg;
	struct T7_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T7_CNT (*((volatile union T7_CNT_REG *)0x40000508))
// model

/** 0x4000 050C T7_PPX **/
union T7_PPX_REG{
	unsigned int reg;
	struct T7_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T7_PPX (*((volatile union T7_PPX_REG *)0x4000050C))
// model

/** 0x4000 0510 T7_PRSC **/
union T7_PRSC_REG{
	unsigned int reg;
	struct T7_PRSC_BITS{
		unsigned int _TXPRSC:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T7_PRSC (*((volatile union T7_PRSC_REG *)0x40000510))
// modelQEI0

/** 0x4000 0514 QEI0_DIER **/
union QEI0_DIER_REG{
	unsigned int reg;
	struct QEI0_DIER_BITS{
		unsigned int _CNTERRIE:1;
		unsigned int _PHEIE:1;
		unsigned int _TXIE:1;
		unsigned int _CNTERRIC:1;
		unsigned int _PHEIC:1;
		unsigned int _TXIC:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI0_DIER (*((volatile union QEI0_DIER_REG *)0x40000514))
// modelADC0

/** 0x4000 0580 ADC0_CTL0 **/
union ADC0_CTL0_REG{
	unsigned int reg;
	struct ADC0_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int _TP:3;
		unsigned int _TPEN:1;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _DMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int :4;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CTL0 (*((volatile union ADC0_CTL0_REG *)0x40000580))
// model

/** 0x4000 0584 ADC0_CTL1 **/
union ADC0_CTL1_REG{
	unsigned int reg;
	struct ADC0_CTL1_BITS{
		unsigned int :2;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :5;
		unsigned int _REF0:1;
		unsigned int _REF1:1;
		unsigned int _REF2:1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CTL1 (*((volatile union ADC0_CTL1_REG *)0x40000584))
// model

/** 0x4000 0588 ADC0_SCANSQ0 **/
union ADC0_SCANSQ0_REG{
	unsigned int reg;
	struct ADC0_SCANSQ0_BITS{
		unsigned int _SSQ0:6;
		unsigned int _SSQ1:6;
		unsigned int _SSQ2:6;
		unsigned int _SSQ3:6;
		unsigned int _SSQ4:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ0 (*((volatile union ADC0_SCANSQ0_REG *)0x40000588))
// model

/** 0x4000 058C ADC0_SCANSQ1 **/
union ADC0_SCANSQ1_REG{
	unsigned int reg;
	struct ADC0_SCANSQ1_BITS{
		unsigned int _SSQ5:6;
		unsigned int _SSQ6:6;
		unsigned int _SSQ7:6;
		unsigned int _SSQ8:6;
		unsigned int _SSQ9:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ1 (*((volatile union ADC0_SCANSQ1_REG *)0x4000058C))
// model

/** 0x4000 0590 ADC0_SCANSQ2 **/
union ADC0_SCANSQ2_REG{
	unsigned int reg;
	struct ADC0_SCANSQ2_BITS{
		unsigned int _SSQ10:6;
		unsigned int _SSQ11:6;
		unsigned int _SSQ12:6;
		unsigned int _SSQ13:6;
		unsigned int _SSQ14:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ2 (*((volatile union ADC0_SCANSQ2_REG *)0x40000590))
// model

/** 0x4000 05C4 ADC0_SCANSQ3 **/
union ADC0_SCANSQ3_REG{
	unsigned int reg;
	struct ADC0_SCANSQ3_BITS{
		unsigned int _SSQ15:6;
		unsigned int :14;
		unsigned int _WDCH:6;
		unsigned int :2;
		unsigned int _SLEN:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ3 (*((volatile union ADC0_SCANSQ3_REG *)0x400005C4))
// model

/** 0x4000 0594 ADC0_HSCANSQ **/
union ADC0_HSCANSQ_REG{
	unsigned int reg;
	struct ADC0_HSCANSQ_BITS{
		unsigned int _HSSQ1:6;
		unsigned int _HSSQ2:6;
		unsigned int _HSSQ3:6;
		unsigned int _HSSQ4:6;
		unsigned int :4;
		unsigned int _HSLEN:2;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HSCANSQ (*((volatile union ADC0_HSCANSQ_REG *)0x40000594))
// model

/** 0x4000 0598 ADC0_WDH **/
union ADC0_WDH_REG{
	unsigned int reg;
	struct ADC0_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_WDH (*((volatile union ADC0_WDH_REG *)0x40000598))
// model

/** 0x4000 059C ADC0_WDL **/
union ADC0_WDL_REG{
	unsigned int reg;
	struct ADC0_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_WDL (*((volatile union ADC0_WDL_REG *)0x4000059C))
// model

/** 0x4000 05A0 ADC0_DATA **/
union ADC0_DATA_REG{
	unsigned int reg;
	struct ADC0_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_DATA (*((volatile union ADC0_DATA_REG *)0x400005A0))
// model

/** 0x4000 05A4 ADC0_HPDATA0 **/
union ADC0_HPDATA0_REG{
	unsigned int reg;
	struct ADC0_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA0 (*((volatile union ADC0_HPDATA0_REG *)0x400005A4))
// model

/** 0x4000 05A8 ADC0_HPDATA1 **/
union ADC0_HPDATA1_REG{
	unsigned int reg;
	struct ADC0_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA1 (*((volatile union ADC0_HPDATA1_REG *)0x400005A8))
// model

/** 0x4000 05AC ADC0_HPDATA2 **/
union ADC0_HPDATA2_REG{
	unsigned int reg;
	struct ADC0_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA2 (*((volatile union ADC0_HPDATA2_REG *)0x400005AC))
// model

/** 0x4000 05B0 ADC0_HPDATA3 **/
union ADC0_HPDATA3_REG{
	unsigned int reg;
	struct ADC0_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA3 (*((volatile union ADC0_HPDATA3_REG *)0x400005B0))
// model

/** 0x4000 05B4 ADC0_HPOFF0 **/
union ADC0_HPOFF0_REG{
	unsigned int reg;
	struct ADC0_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF0 (*((volatile union ADC0_HPOFF0_REG *)0x400005B4))
// model

/** 0x4000 05B8 ADC0_HPOFF1 **/
union ADC0_HPOFF1_REG{
	unsigned int reg;
	struct ADC0_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF1 (*((volatile union ADC0_HPOFF1_REG *)0x400005B8))
// model

/** 0x4000 05BC ADC0_HPOFF2 **/
union ADC0_HPOFF2_REG{
	unsigned int reg;
	struct ADC0_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF2 (*((volatile union ADC0_HPOFF2_REG *)0x400005BC))
// model

/** 0x4000 05C0 ADC0_HPOFF3 **/
union ADC0_HPOFF3_REG{
	unsigned int reg;
	struct ADC0_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF3 (*((volatile union ADC0_HPOFF3_REG *)0x400005C0))
// model

/** 0x4000 05D0 ADC0_STATE **/
union ADC0_STATE_REG{
	unsigned int reg;
	struct ADC0_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int _CCR3N:1;
		unsigned int _CCR3H:1;
		unsigned int _CCR4N:1;
		unsigned int _CCR4H:1;
		unsigned int _CCR5N:1;
		unsigned int _CCR5H:1;
		unsigned int _TSSELTOADCIS0:1;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int _TSSELTOADCIS1:1;
		unsigned int _TSSELTOADCIS2:1;
		unsigned int _TRIMERROR0:1;
		unsigned int _TRIMERROR1:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_STATE (*((volatile union ADC0_STATE_REG *)0x400005D0))
// model

/** 0x4000 05D4 ADC0_DELAY **/
union ADC0_DELAY_REG{
	unsigned int reg;
	struct ADC0_DELAY_BITS{
		unsigned int _FDELAY:6;
		unsigned int :10;
		unsigned int _SDELAY:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_DELAY (*((volatile union ADC0_DELAY_REG *)0x400005D4))
// modelADC1

/** 0x4000 0600 ADC1_CTL0 **/
union ADC1_CTL0_REG{
	unsigned int reg;
	struct ADC1_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int _TP:3;
		unsigned int _TPEN:1;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _DMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int :4;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CTL0 (*((volatile union ADC1_CTL0_REG *)0x40000600))
// model

/** 0x4000 0604 ADC1_CTL1 **/
union ADC1_CTL1_REG{
	unsigned int reg;
	struct ADC1_CTL1_BITS{
		unsigned int :2;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :5;
		unsigned int _REF0:1;
		unsigned int _REF1:1;
		unsigned int _REF2:1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CTL1 (*((volatile union ADC1_CTL1_REG *)0x40000604))
// model

/** 0x4000 0608 ADC1_SCANSQ0 **/
union ADC1_SCANSQ0_REG{
	unsigned int reg;
	struct ADC1_SCANSQ0_BITS{
		unsigned int _SSQ0:6;
		unsigned int _SSQ1:6;
		unsigned int _SSQ2:6;
		unsigned int _SSQ3:6;
		unsigned int _SSQ4:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ0 (*((volatile union ADC1_SCANSQ0_REG *)0x40000608))
// model

/** 0x4000 060C ADC1_SCANSQ1 **/
union ADC1_SCANSQ1_REG{
	unsigned int reg;
	struct ADC1_SCANSQ1_BITS{
		unsigned int _SSQ5:6;
		unsigned int _SSQ6:6;
		unsigned int _SSQ7:6;
		unsigned int _SSQ8:6;
		unsigned int _SSQ9:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ1 (*((volatile union ADC1_SCANSQ1_REG *)0x4000060C))
// model

/** 0x4000 0610 ADC1_SCANSQ2 **/
union ADC1_SCANSQ2_REG{
	unsigned int reg;
	struct ADC1_SCANSQ2_BITS{
		unsigned int _SSQ10:6;
		unsigned int _SSQ11:6;
		unsigned int _SSQ12:6;
		unsigned int _SSQ13:6;
		unsigned int _SSQ14:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ2 (*((volatile union ADC1_SCANSQ2_REG *)0x40000610))
// model

/** 0x4000 0644 ADC1_SCANSQ3 **/
union ADC1_SCANSQ3_REG{
	unsigned int reg;
	struct ADC1_SCANSQ3_BITS{
		unsigned int _SSQ15:6;
		unsigned int :14;
		unsigned int _WDCH:6;
		unsigned int :2;
		unsigned int _SLEN:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ3 (*((volatile union ADC1_SCANSQ3_REG *)0x40000644))
// model

/** 0x4000 0614 ADC1_HSCANSQ **/
union ADC1_HSCANSQ_REG{
	unsigned int reg;
	struct ADC1_HSCANSQ_BITS{
		unsigned int _HSSQ1:6;
		unsigned int _HSSQ2:6;
		unsigned int _HSSQ3:6;
		unsigned int _HSSQ4:6;
		unsigned int :4;
		unsigned int _HSLEN:2;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HSCANSQ (*((volatile union ADC1_HSCANSQ_REG *)0x40000614))
// model

/** 0x4000 0618 ADC1_WDH **/
union ADC1_WDH_REG{
	unsigned int reg;
	struct ADC1_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_WDH (*((volatile union ADC1_WDH_REG *)0x40000618))
// model

/** 0x4000 061C ADC1_WDL **/
union ADC1_WDL_REG{
	unsigned int reg;
	struct ADC1_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_WDL (*((volatile union ADC1_WDL_REG *)0x4000061C))
// model

/** 0x4000 0620 ADC1_DATA **/
union ADC1_DATA_REG{
	unsigned int reg;
	struct ADC1_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_DATA (*((volatile union ADC1_DATA_REG *)0x40000620))
// model

/** 0x4000 0624 ADC1_HPDATA0 **/
union ADC1_HPDATA0_REG{
	unsigned int reg;
	struct ADC1_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA0 (*((volatile union ADC1_HPDATA0_REG *)0x40000624))
// model

/** 0x4000 0628 ADC1_HPDATA1 **/
union ADC1_HPDATA1_REG{
	unsigned int reg;
	struct ADC1_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA1 (*((volatile union ADC1_HPDATA1_REG *)0x40000628))
// model

/** 0x4000 062C ADC1_HPDATA2 **/
union ADC1_HPDATA2_REG{
	unsigned int reg;
	struct ADC1_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA2 (*((volatile union ADC1_HPDATA2_REG *)0x4000062C))
// model

/** 0x4000 0630 ADC1_HPDATA3 **/
union ADC1_HPDATA3_REG{
	unsigned int reg;
	struct ADC1_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA3 (*((volatile union ADC1_HPDATA3_REG *)0x40000630))
// model

/** 0x4000 0634 ADC1_HPOFF0 **/
union ADC1_HPOFF0_REG{
	unsigned int reg;
	struct ADC1_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF0 (*((volatile union ADC1_HPOFF0_REG *)0x40000634))
// model

/** 0x4000 0638 ADC1_HPOFF1 **/
union ADC1_HPOFF1_REG{
	unsigned int reg;
	struct ADC1_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF1 (*((volatile union ADC1_HPOFF1_REG *)0x40000638))
// model

/** 0x4000 063C ADC1_HPOFF2 **/
union ADC1_HPOFF2_REG{
	unsigned int reg;
	struct ADC1_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF2 (*((volatile union ADC1_HPOFF2_REG *)0x4000063C))
// model

/** 0x4000 0640 ADC1_HPOFF3 **/
union ADC1_HPOFF3_REG{
	unsigned int reg;
	struct ADC1_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF3 (*((volatile union ADC1_HPOFF3_REG *)0x40000640))
// model

/** 0x4000 0650 ADC1_STATE **/
union ADC1_STATE_REG{
	unsigned int reg;
	struct ADC1_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int _CCR3N:1;
		unsigned int _CCR3H:1;
		unsigned int _CCR4N:1;
		unsigned int _CCR4H:1;
		unsigned int _CCR5N:1;
		unsigned int _CCR5H:1;
		unsigned int _TSSELTOADCIS0:1;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int _TSSELTOADCIS1:1;
		unsigned int _TSSELTOADCIS2:1;
		unsigned int _TRIMERROR0:1;
		unsigned int _TRIMERROR1:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_STATE (*((volatile union ADC1_STATE_REG *)0x40000650))
// modelADC2

/** 0x4000 0680 ADC2_CTL0 **/
union ADC2_CTL0_REG{
	unsigned int reg;
	struct ADC2_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int _TP:3;
		unsigned int _TPEN:1;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _DMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int :4;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CTL0 (*((volatile union ADC2_CTL0_REG *)0x40000680))
// model

/** 0x4000 0684 ADC2_CTL1 **/
union ADC2_CTL1_REG{
	unsigned int reg;
	struct ADC2_CTL1_BITS{
		unsigned int :2;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :5;
		unsigned int _REF0:1;
		unsigned int _REF1:1;
		unsigned int _REF2:1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CTL1 (*((volatile union ADC2_CTL1_REG *)0x40000684))
// model

/** 0x4000 0688 ADC2_SCANSQ0 **/
union ADC2_SCANSQ0_REG{
	unsigned int reg;
	struct ADC2_SCANSQ0_BITS{
		unsigned int _SSQ0:6;
		unsigned int _SSQ1:6;
		unsigned int _SSQ2:6;
		unsigned int _SSQ3:6;
		unsigned int _SSQ4:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ0 (*((volatile union ADC2_SCANSQ0_REG *)0x40000688))
// model

/** 0x4000 068C ADC2_SCANSQ1 **/
union ADC2_SCANSQ1_REG{
	unsigned int reg;
	struct ADC2_SCANSQ1_BITS{
		unsigned int _SSQ5:6;
		unsigned int _SSQ6:6;
		unsigned int _SSQ7:6;
		unsigned int _SSQ8:6;
		unsigned int _SSQ9:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ1 (*((volatile union ADC2_SCANSQ1_REG *)0x4000068C))
// model

/** 0x4000 0690 ADC2_SCANSQ2 **/
union ADC2_SCANSQ2_REG{
	unsigned int reg;
	struct ADC2_SCANSQ2_BITS{
		unsigned int _SSQ10:6;
		unsigned int _SSQ11:6;
		unsigned int _SSQ12:6;
		unsigned int _SSQ13:6;
		unsigned int _SSQ14:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ2 (*((volatile union ADC2_SCANSQ2_REG *)0x40000690))
// model

/** 0x4000 06C4 ADC2_SCANSQ3 **/
union ADC2_SCANSQ3_REG{
	unsigned int reg;
	struct ADC2_SCANSQ3_BITS{
		unsigned int _SSQ15:6;
		unsigned int :14;
		unsigned int _WDCH:6;
		unsigned int :2;
		unsigned int _SLEN:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ3 (*((volatile union ADC2_SCANSQ3_REG *)0x400006C4))
// model

/** 0x4000 0694 ADC2_HSCANSQ **/
union ADC2_HSCANSQ_REG{
	unsigned int reg;
	struct ADC2_HSCANSQ_BITS{
		unsigned int _HSSQ1:6;
		unsigned int _HSSQ2:6;
		unsigned int _HSSQ3:6;
		unsigned int _HSSQ4:6;
		unsigned int :4;
		unsigned int _HSLEN:2;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HSCANSQ (*((volatile union ADC2_HSCANSQ_REG *)0x40000694))
// model

/** 0x4000 0698 ADC2_WDH **/
union ADC2_WDH_REG{
	unsigned int reg;
	struct ADC2_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_WDH (*((volatile union ADC2_WDH_REG *)0x40000698))
// model

/** 0x4000 069C ADC2_WDL **/
union ADC2_WDL_REG{
	unsigned int reg;
	struct ADC2_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_WDL (*((volatile union ADC2_WDL_REG *)0x4000069C))
// model

/** 0x4000 06A0 ADC2_DATA **/
union ADC2_DATA_REG{
	unsigned int reg;
	struct ADC2_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_DATA (*((volatile union ADC2_DATA_REG *)0x400006A0))
// model

/** 0x4000 06A4 ADC2_HPDATA0 **/
union ADC2_HPDATA0_REG{
	unsigned int reg;
	struct ADC2_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA0 (*((volatile union ADC2_HPDATA0_REG *)0x400006A4))
// model

/** 0x4000 06A8 ADC2_HPDATA1 **/
union ADC2_HPDATA1_REG{
	unsigned int reg;
	struct ADC2_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA1 (*((volatile union ADC2_HPDATA1_REG *)0x400006A8))
// model

/** 0x4000 06AC ADC2_HPDATA2 **/
union ADC2_HPDATA2_REG{
	unsigned int reg;
	struct ADC2_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA2 (*((volatile union ADC2_HPDATA2_REG *)0x400006AC))
// model

/** 0x4000 06B0 ADC2_HPDATA3 **/
union ADC2_HPDATA3_REG{
	unsigned int reg;
	struct ADC2_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA3 (*((volatile union ADC2_HPDATA3_REG *)0x400006B0))
// model

/** 0x4000 06B4 ADC2_HPOFF0 **/
union ADC2_HPOFF0_REG{
	unsigned int reg;
	struct ADC2_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF0 (*((volatile union ADC2_HPOFF0_REG *)0x400006B4))
// model

/** 0x4000 06B8 ADC2_HPOFF1 **/
union ADC2_HPOFF1_REG{
	unsigned int reg;
	struct ADC2_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF1 (*((volatile union ADC2_HPOFF1_REG *)0x400006B8))
// model

/** 0x4000 06BC ADC2_HPOFF2 **/
union ADC2_HPOFF2_REG{
	unsigned int reg;
	struct ADC2_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF2 (*((volatile union ADC2_HPOFF2_REG *)0x400006BC))
// model

/** 0x4000 06C0 ADC2_HPOFF3 **/
union ADC2_HPOFF3_REG{
	unsigned int reg;
	struct ADC2_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF3 (*((volatile union ADC2_HPOFF3_REG *)0x400006C0))
// model

/** 0x4000 06D0 ADC2_STATE **/
union ADC2_STATE_REG{
	unsigned int reg;
	struct ADC2_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int _CCR3N:1;
		unsigned int _CCR3H:1;
		unsigned int _CCR4N:1;
		unsigned int _CCR4H:1;
		unsigned int _CCR5N:1;
		unsigned int _CCR5H:1;
		unsigned int _TSSELTOADCIS0:1;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int _TSSELTOADCIS1:1;
		unsigned int _TSSELTOADCIS2:1;
		unsigned int _TRIMERROR0:1;
		unsigned int _TRIMERROR1:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_STATE (*((volatile union ADC2_STATE_REG *)0x400006D0))
// modelDAC0

/** 0x4000 0700 DAC0_CTL **/
union DAC0_CTL_REG{
	unsigned int reg;
	struct DAC0_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL (*((volatile union DAC0_CTL_REG *)0x40000700))
// model

/** 0x4000 0704 DAC0_DAHD **/
union DAC0_DAHD_REG{
	unsigned int reg;
	struct DAC0_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DAHD (*((volatile union DAC0_DAHD_REG *)0x40000704))
// model

/** 0x4000 0708 DAC0_DATA **/
union DAC0_DATA_REG{
	unsigned int reg;
	struct DAC0_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DATA (*((volatile union DAC0_DATA_REG *)0x40000708))
// model

/** 0x4000 070C DAC0_CTL1 **/
union DAC0_CTL1_REG{
	unsigned int reg;
	struct DAC0_CTL1_BITS{
		unsigned int _SEL:1;
		unsigned int _RFS0:1;
		unsigned int _RFS1:1;
		unsigned int :1;
		unsigned int _CLK0:1;
		unsigned int _CLK1:1;
		unsigned int _BUFEN:1;
		unsigned int :2;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL1 (*((volatile union DAC0_CTL1_REG *)0x4000070C))
// model

/** 0x4000 0714 DAC0_CAL **/
union DAC0_CAL_REG{
	unsigned int reg;
	struct DAC0_CAL_BITS{
		unsigned int _TPEN:1;
		unsigned int _TP:2;
		unsigned int :12;
		unsigned int _BUFTRIM:1;
		unsigned int _NNEGATRIM:4;
		unsigned int _NPOSITRIM:4;
		unsigned int _PNEGATRIM:4;
		unsigned int _PPOSITRIM:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CAL (*((volatile union DAC0_CAL_REG *)0x40000714))
// modelDAC1

/** 0x4000 0780 DAC1_CTL **/
union DAC1_CTL_REG{
	unsigned int reg;
	struct DAC1_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CTL (*((volatile union DAC1_CTL_REG *)0x40000780))
// model

/** 0x4000 0784 DAC1_DAHD **/
union DAC1_DAHD_REG{
	unsigned int reg;
	struct DAC1_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_DAHD (*((volatile union DAC1_DAHD_REG *)0x40000784))
// model

/** 0x4000 0788 DAC1_DATA **/
union DAC1_DATA_REG{
	unsigned int reg;
	struct DAC1_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_DATA (*((volatile union DAC1_DATA_REG *)0x40000788))
// model

/** 0x4000 078C DAC1_CTL1 **/
union DAC1_CTL1_REG{
	unsigned int reg;
	struct DAC1_CTL1_BITS{
		unsigned int _SEL:1;
		unsigned int _RFS0:1;
		unsigned int _RFS1:1;
		unsigned int :1;
		unsigned int _CLK0:1;
		unsigned int _CLK1:1;
		unsigned int _BUFEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CTL1 (*((volatile union DAC1_CTL1_REG *)0x4000078C))
// model

/** 0x4000 0794 DAC1_CAL **/
union DAC1_CAL_REG{
	unsigned int reg;
	struct DAC1_CAL_BITS{
		unsigned int _TPEN:1;
		unsigned int _TP:2;
		unsigned int :12;
		unsigned int _BUFTRIM:1;
		unsigned int _NNEGATRIM:4;
		unsigned int _NPOSITRIM:4;
		unsigned int _PNEGATRIM:4;
		unsigned int _PPOSITRIM:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CAL (*((volatile union DAC1_CAL_REG *)0x40000794))
// modelCMP

/** 0x4000 0800 CMP_CTL0 **/
union CMP_CTL0_REG{
	unsigned int reg;
	struct CMP_CTL0_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int :1;
		unsigned int _FDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int _HYS:3;
		unsigned int :1;
		unsigned int _NMOD:3;
		unsigned int :1;
		unsigned int _PMOD:3;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL0 (*((volatile union CMP_CTL0_REG *)0x40000800))
// model

/** 0x4000 0804 CMP_CTL1 **/
union CMP_CTL1_REG{
	unsigned int reg;
	struct CMP_CTL1_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int :1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int _HYS:3;
		unsigned int :1;
		unsigned int _NMOD:3;
		unsigned int :1;
		unsigned int _PMOD:3;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL1 (*((volatile union CMP_CTL1_REG *)0x40000804))
// model

/** 0x4000 0808 CMP_CTL2 **/
union CMP_CTL2_REG{
	unsigned int reg;
	struct CMP_CTL2_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int :1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int _HYS:3;
		unsigned int :1;
		unsigned int _NMOD:3;
		unsigned int :1;
		unsigned int _PMOD:3;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL2 (*((volatile union CMP_CTL2_REG *)0x40000808))
// model

/** 0x4000 080C CMP_CTL3 **/
union CMP_CTL3_REG{
	unsigned int reg;
	struct CMP_CTL3_BITS{
		unsigned int _C3EN:1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int :1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int :2;
		unsigned int _HYS:3;
		unsigned int :1;
		unsigned int _NMOD:3;
		unsigned int :1;
		unsigned int _PMOD:3;
		unsigned int _PSEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL3 (*((volatile union CMP_CTL3_REG *)0x4000080C))
// model

/** 0x4000 0810 CMP_CTL4 **/
union CMP_CTL4_REG{
	unsigned int reg;
	struct CMP_CTL4_BITS{
		unsigned int _C0EN:1;
		unsigned int _C1EN:1;
		unsigned int _C2EN:1;
		unsigned int _FLTINSEL:1;
		unsigned int _BEMFEN:1;
		unsigned int _HALSEL:1;
		unsigned int _TRIM0:1;
		unsigned int _TRIM1:1;
		unsigned int :2;
		unsigned int _C3IFREN:1;
		unsigned int _C3IFFEN:1;
		unsigned int _C0IE:1;
		unsigned int _C1IE:1;
		unsigned int _C2IE:1;
		unsigned int _C3IE:1;
		unsigned int _C0IC:1;
		unsigned int _C1IC:1;
		unsigned int _C2IC:1;
		unsigned int _C3IC:1;
		unsigned int _CMPOUTSEL:2;
		unsigned int :1;
		unsigned int _CIFMS:1;
		unsigned int _C0IF:1;
		unsigned int _C1IF:1;
		unsigned int _C2IF:1;
		unsigned int _C3IF:1;
		unsigned int _C0OUT:1;
		unsigned int _C1OUT:1;
		unsigned int _C2OUT:1;
		unsigned int _C3OUT:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL4 (*((volatile union CMP_CTL4_REG *)0x40000810))
// modelT0

/** 0x4000 0880 T0_CNT **/
union T0_CNT_REG{
	unsigned int reg;
	struct T0_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CNT (*((volatile union T0_CNT_REG *)0x40000880))
// model

/** 0x4000 0884 T0_CTL1 **/
union T0_CTL1_REG{
	unsigned int reg;
	struct T0_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL1 (*((volatile union T0_CTL1_REG *)0x40000884))
// model

/** 0x4000 0888 T0_CTL2 **/
union T0_CTL2_REG{
	unsigned int reg;
	struct T0_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL2 (*((volatile union T0_CTL2_REG *)0x40000888))
// model

/** 0x4000 088C T0_PRSC **/
union T0_PRSC_REG{
	unsigned int reg;
	struct T0_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PRSC (*((volatile union T0_PRSC_REG *)0x4000088C))
// model

/** 0x4000 0890 T0_PPX **/
union T0_PPX_REG{
	unsigned int reg;
	struct T0_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PPX (*((volatile union T0_PPX_REG *)0x40000890))
// model

/** 0x4000 0894 T0_UDTIMx **/
union T0_UDTIMx_REG{
	unsigned int reg;
	struct T0_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_UDTIMx (*((volatile union T0_UDTIMx_REG *)0x40000894))
// modelCCP0

/** 0x4000 08A0 CCP0_C1 **/
union CCP0_C1_REG{
	unsigned int reg;
	struct CCP0_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C1 (*((volatile union CCP0_C1_REG *)0x400008A0))
// model

/** 0x4000 08A4 CCP0_C2 **/
union CCP0_C2_REG{
	unsigned int reg;
	struct CCP0_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C2 (*((volatile union CCP0_C2_REG *)0x400008A4))
// model

/** 0x4000 08A8 CCP0_C3 **/
union CCP0_C3_REG{
	unsigned int reg;
	struct CCP0_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C3 (*((volatile union CCP0_C3_REG *)0x400008A8))
// model

/** 0x4000 08AC CCP0_C4 **/
union CCP0_C4_REG{
	unsigned int reg;
	struct CCP0_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C4 (*((volatile union CCP0_C4_REG *)0x400008AC))
// model

/** 0x4000 08B0 CCP0_SRIC **/
union CCP0_SRIC_REG{
	unsigned int reg;
	struct CCP0_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_SRIC (*((volatile union CCP0_SRIC_REG *)0x400008B0))
// model

/** 0x4000 08B4 CCP0_DF **/
union CCP0_DF_REG{
	unsigned int reg;
	struct CCP0_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_DF (*((volatile union CCP0_DF_REG *)0x400008B4))
// model

/** 0x4000 08C0 CCP0_CTL1 **/
union CCP0_CTL1_REG{
	unsigned int reg;
	struct CCP0_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL1 (*((volatile union CCP0_CTL1_REG *)0x400008C0))
// model

/** 0x4000 08C4 CCP0_R1 **/
union CCP0_R1_REG{
	unsigned int reg;
	struct CCP0_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R1 (*((volatile union CCP0_R1_REG *)0x400008C4))
// model

/** 0x4000 08C8 CCP0_R2 **/
union CCP0_R2_REG{
	unsigned int reg;
	struct CCP0_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R2 (*((volatile union CCP0_R2_REG *)0x400008C8))
// model

/** 0x4000 08CC CCP0_R3 **/
union CCP0_R3_REG{
	unsigned int reg;
	struct CCP0_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R3 (*((volatile union CCP0_R3_REG *)0x400008CC))
// model

/** 0x4000 08D0 CCP0_R4 **/
union CCP0_R4_REG{
	unsigned int reg;
	struct CCP0_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R4 (*((volatile union CCP0_R4_REG *)0x400008D0))
// model

/** 0x4000 08D4 CCP0_CTL2 **/
union CCP0_CTL2_REG{
	unsigned int reg;
	struct CCP0_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL2 (*((volatile union CCP0_CTL2_REG *)0x400008D4))
// model

/** 0x4000 08D8 CCP0_CTL3 **/
union CCP0_CTL3_REG{
	unsigned int reg;
	struct CCP0_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL3 (*((volatile union CCP0_CTL3_REG *)0x400008D8))
// model

/** 0x4000 08DC CCP0_EGIF **/
union CCP0_EGIF_REG{
	unsigned int reg;
	struct CCP0_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_EGIF (*((volatile union CCP0_EGIF_REG *)0x400008DC))
// modelCT

/** 0x4000 0900 CT_ACFG **/
union CT_ACFG_REG{
	unsigned int reg;
	struct CT_ACFG_BITS{
		unsigned int _CMPFILTDL:3;
		unsigned int :2;
		unsigned int _VALCMPSEL:1;
		unsigned int _SNSCKEN:1;
		unsigned int _GPIOCHARGEEN:1;
		unsigned int _RESVALIWIN:1;
		unsigned int :1;
		unsigned int _TOUCHEN:1;
		unsigned int _MUTUALMODE:1;
		unsigned int _TMODE:1;
		unsigned int _CTSCAN:1;
		unsigned int _CTCTC:3;
		unsigned int _CTSTCH:4;
		unsigned int _CTSPCH:4;
		unsigned int _COARSEMODE:1;
		unsigned int _SCANSGVAL:1;
		unsigned int _RECCMPEX:1;
		unsigned int _CSDCMPEX:1;
		unsigned int _CTTEST:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_ACFG (*((volatile union CT_ACFG_REG *)0x40000900))
// model

/** 0x4000 0904 CT_CMPCFG **/
union CT_CMPCFG_REG{
	unsigned int reg;
	struct CT_CMPCFG_BITS{
		unsigned int _HSCMPEN:1;
		unsigned int _HSCMPINV:1;
		unsigned int _HSAZEN:1;
		unsigned int _RECCMPEN:1;
		unsigned int _RECCMPPOL:2;
		unsigned int _RECCMPPHASE:2;
		unsigned int _FBMODE:1;
		unsigned int _RECAZEN:1;
		unsigned int _HSDUMEN:1;
		unsigned int :4;
		unsigned int _CMPPHASE:1;
		unsigned int _AZTIME:8;
		unsigned int _AZ0SKIP:1;
		unsigned int _AZ1SKIP:1;
		unsigned int _TAZSKIP:1;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_CMPCFG (*((volatile union CT_CMPCFG_REG *)0x40000904))
// model

/** 0x4000 0908 CT_STIE **/
union CT_STIE_REG{
	unsigned int reg;
	struct CT_STIE_BITS{
		unsigned int _SYNCSDCMPOUT:1;
		unsigned int _CONWST:1;
		unsigned int _SYNHSCMPOUT:1;
		unsigned int _CHARGESIG:1;
		unsigned int _CONINITIF:1;
		unsigned int _CONNORMIF:1;
		unsigned int _SCANIF:1;
		unsigned int _CTSENSE:1;
		unsigned int _WREGDONE:1;
		unsigned int :2;
		unsigned int _CONINITIE:1;
		unsigned int _CONNORMIE:1;
		unsigned int _SCANIE:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_STIE (*((volatile union CT_STIE_REG *)0x40000908))
// model

/** 0x4000 090C CT_SCANVALCFG0 **/
union CT_SCANVALCFG0_REG{
	unsigned int reg;
	struct CT_SCANVALCFG0_BITS{
		unsigned int _SCANVAL0:16;
		unsigned int _SCANVAL1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SCANVALCFG0 (*((volatile union CT_SCANVALCFG0_REG *)0x4000090C))
// model

/** 0x4000 0910 CT_SCANVALCFG1 **/
union CT_SCANVALCFG1_REG{
	unsigned int reg;
	struct CT_SCANVALCFG1_BITS{
		unsigned int _SCANVAL2:16;
		unsigned int _SCANVAL3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SCANVALCFG1 (*((volatile union CT_SCANVALCFG1_REG *)0x40000910))
// model

/** 0x4000 0914 CT_CONSAM **/
union CT_CONSAM_REG{
	unsigned int reg;
	struct CT_CONSAM_BITS{
		unsigned int _SEQINIT:16;
		unsigned int _SEQNORM:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_CONSAM (*((volatile union CT_CONSAM_REG *)0x40000914))
// model

/** 0x4000 0918 CT_RESULT **/
union CT_RESULT_REG{
	unsigned int reg;
	struct CT_RESULT_BITS{
		unsigned int _RESULTVAL1:16;
		unsigned int _RESULTVAL2:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_RESULT (*((volatile union CT_RESULT_REG *)0x40000918))
// model

/** 0x4000 091C CT_STATE **/
union CT_STATE_REG{
	unsigned int reg;
	struct CT_STATE_BITS{
		unsigned int _SYNSTATECNT:16;
		unsigned int _BADSENSECNT:8;
		unsigned int _SYNCONSTATE:4;
		unsigned int _TCHANNEL:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_STATE (*((volatile union CT_STATE_REG *)0x4000091C))
// model

/** 0x4000 0920 CT_LFSRCTL **/
union CT_LFSRCTL_REG{
	unsigned int reg;
	struct CT_LFSRCTL_BITS{
		unsigned int _SNSDIV:12;
		unsigned int _LFSRSIZE:3;
		unsigned int _LFSRSHIFT:4;
		unsigned int _LFSRMSBSEL:1;
		unsigned int _LFSRBITUSE:2;
		unsigned int _SNSCKSEL:2;
		unsigned int _PDCKSEL:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_LFSRCTL (*((volatile union CT_LFSRCTL_REG *)0x40000920))
// model

/** 0x4000 0924 CT_SNSWID **/
union CT_SNSWID_REG{
	unsigned int reg;
	struct CT_SNSWID_BITS{
		unsigned int _SNSWID:12;
		unsigned int _SNSPOL:1;
		unsigned int _PHI20VERLAP:1;
		unsigned int _PHI10VERLAP:1;
		unsigned int _SELWID:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SNSWID (*((volatile union CT_SNSWID_REG *)0x40000924))
// model

/** 0x4000 0928 CT_REFBUF **/
union CT_REFBUF_REG{
	unsigned int reg;
	struct CT_REFBUF_BITS{
		unsigned int _BUFEN:1;
		unsigned int _BUFISHRINK:1;
		unsigned int _BUFIBOOST:2;
		unsigned int :11;
		unsigned int _REFVDDEN:1;
		unsigned int _REFIBOOST:2;
		unsigned int _REFFOLLEN:1;
		unsigned int _REFGENEN:1;
		unsigned int _REFGAIN:5;
		unsigned int _VREFLSEL:5;
		unsigned int _REFBYPASS:1;
		unsigned int _REFISHRINK:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_REFBUF (*((volatile union CT_REFBUF_REG *)0x40000928))
// model

/** 0x4000 092C CT_IDACCTL0 **/
union CT_IDACCTL0_REG{
	unsigned int reg;
	struct CT_IDACCTL0_BITS{
		unsigned int _IDACTRIM:8;
		unsigned int _IALEG1EN:1;
		unsigned int _IALEG2EN:1;
		unsigned int _IALEG1MDCTL:1;
		unsigned int _IALEG1MODE:1;
		unsigned int _IALEG2MDCTL:1;
		unsigned int _IALEG2MODE:1;
		unsigned int _IASWMODE:3;
		unsigned int _IAPOLDYN:1;
		unsigned int _IAPOL:2;
		unsigned int _IAVAL:7;
		unsigned int _IARANGE:2;
		unsigned int _IDACAEN:1;
		unsigned int _IAEXTDUMEN:1;
		unsigned int _IDACSBIASEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_IDACCTL0 (*((volatile union CT_IDACCTL0_REG *)0x4000092C))
// model

/** 0x4000 0930 CT_IDACCTL1 **/
union CT_IDACCTL1_REG{
	unsigned int reg;
	struct CT_IDACCTL1_BITS{
		unsigned int :5;
		unsigned int _IBHSCMPEN:1;
		unsigned int _LAGPEN:1;
		unsigned int _LBGPEN:1;
		unsigned int _IBLEG1EN:1;
		unsigned int _IBLEG2EN:1;
		unsigned int _IBLEG1MDCTL:1;
		unsigned int _IBLEG1MODE:1;
		unsigned int _IBLEG2MDCTL:1;
		unsigned int _IBLEG2MODE:1;
		unsigned int _IBSWMODE:3;
		unsigned int _LBPOLDYN:1;
		unsigned int _IBPOL:2;
		unsigned int _IBVAL:7;
		unsigned int _IBRANGE:2;
		unsigned int _IDACBEN:1;
		unsigned int _IBEXTDUMEN:1;
		unsigned int _IDACPCEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_IDACCTL1 (*((volatile union CT_IDACCTL1_REG *)0x40000930))
// model

/** 0x4000 0934 CT_SWCTL3 **/
union CT_SWCTL3_REG{
	unsigned int reg;
	struct CT_SWCTL3_BITS{
		unsigned int _RESBAPU:2;
		unsigned int _RESBAPD:2;
		unsigned int _RESBBPU:2;
		unsigned int _RESBBPD:2;
		unsigned int _SWBAPU:3;
		unsigned int _SWBAPD:3;
		unsigned int _SWBBPU:3;
		unsigned int _SWBBPD:3;
		unsigned int _SWREFSEL:2;
		unsigned int _SWBBID:1;
		unsigned int _SWBAID:1;
		unsigned int _SWIBCB:1;
		unsigned int _SWIAIB:1;
		unsigned int _SWSMBB:2;
		unsigned int _SWHMTB:2;
		unsigned int _SWSMTB:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SWCTL3 (*((volatile union CT_SWCTL3_REG *)0x40000934))
// model

/** 0x4000 0938 CT_SWCTL2 **/
union CT_SWCTL2_REG{
	unsigned int reg;
	struct CT_SWCTL2_BITS{
		unsigned int _SWHMCM:1;
		unsigned int _SWHMCT:1;
		unsigned int :1;
		unsigned int _SWHMBB:1;
		unsigned int _SWHMCA:1;
		unsigned int _SWHMCB:1;
		unsigned int _SWHMCC:1;
		unsigned int _SWHMTA:2;
		unsigned int _SWHNVH:1;
		unsigned int _SWHNVL:1;
		unsigned int _SWHNBA:1;
		unsigned int _SWHNBB:1;
		unsigned int _SWHNBU:1;
		unsigned int _SWSNVH:1;
		unsigned int _SWSNVL:1;
		unsigned int _SWSNBU:1;
		unsigned int _SWSMTA:2;
		unsigned int _SWSMSH:1;
		unsigned int _SWSMXT:1;
		unsigned int _SWSMCG:1;
		unsigned int _SWSMVH:1;
		unsigned int _SWSMCB:1;
		unsigned int _SWSMCA:1;
		unsigned int _SWSMBA:2;
		unsigned int _SWSMCT:2;
		unsigned int _SWSMCM:2;
		unsigned int _SWSMOP:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SWCTL2 (*((volatile union CT_SWCTL2_REG *)0x40000938))
// model

/** 0x4000 093C CT_SWCTL1 **/
union CT_SWCTL1_REG{
	unsigned int reg;
	struct CT_SWCTL1_BITS{
		unsigned int _RESCMCP:2;
		unsigned int _SWCMCP:1;
		unsigned int _SWCMBA:3;
		unsigned int _RESCTCP:2;
		unsigned int _SWCTCP:1;
		unsigned int _SWCTBA:3;
		unsigned int _SWIACM:3;
		unsigned int _SWIACT:3;
		unsigned int _SWIBCM:3;
		unsigned int _SWCTCB:2;
		unsigned int _SWBUBY:1;
		unsigned int _SWBULO:1;
		unsigned int _SWBUHI:1;
		unsigned int _SWBUCT:2;
		unsigned int :3;
		unsigned int _FXIDACAND:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SWCTL1 (*((volatile union CT_SWCTL1_REG *)0x4000093C))
// model

/** 0x4000 0940 CT_SPECIAL **/
union CT_SPECIAL_REG{
	unsigned int reg;
	struct CT_SPECIAL_BITS{
		unsigned int _LFSRCLEAR:1;
		unsigned int _CONINITIC:1;
		unsigned int _CONNORMIC:1;
		unsigned int _SCANIC:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SPECIAL (*((volatile union CT_SPECIAL_REG *)0x40000940))
// model

/** 0x4000 0944 CT_SCANVALCFG2 **/
union CT_SCANVALCFG2_REG{
	unsigned int reg;
	struct CT_SCANVALCFG2_BITS{
		unsigned int _SCANVAL4:16;
		unsigned int _SCANVAL5:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SCANVALCFG2 (*((volatile union CT_SCANVALCFG2_REG *)0x40000944))
// model

/** 0x4000 0948 CT_SCANVALCFG3 **/
union CT_SCANVALCFG3_REG{
	unsigned int reg;
	struct CT_SCANVALCFG3_BITS{
		unsigned int _SCANVAL6:16;
		unsigned int _SCANVAL7:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SCANVALCFG3 (*((volatile union CT_SCANVALCFG3_REG *)0x40000948))
// model

/** 0x4000 094C CT_SCANVALCFG4 **/
union CT_SCANVALCFG4_REG{
	unsigned int reg;
	struct CT_SCANVALCFG4_BITS{
		unsigned int _SCANVAL8:16;
		unsigned int _SCANVAL9:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SCANVALCFG4 (*((volatile union CT_SCANVALCFG4_REG *)0x4000094C))
// model

/** 0x4000 0950 CT_SCANVALCFG5 **/
union CT_SCANVALCFG5_REG{
	unsigned int reg;
	struct CT_SCANVALCFG5_BITS{
		unsigned int _SCANVAL10:16;
		unsigned int _SCANVAL11:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_SCANVALCFG5 (*((volatile union CT_SCANVALCFG5_REG *)0x40000950))
// model

/** 0x4000 0954 CT_DELTAVAL **/
union CT_DELTAVAL_REG{
	unsigned int reg;
	struct CT_DELTAVAL_BITS{
		unsigned int _DELTAVAL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CT_DELTAVAL (*((volatile union CT_DELTAVAL_REG *)0x40000954))
// modelUSART0

/** 0x4000 0980 USART0_CTLR **/
union USART0_CTLR_REG{
	unsigned int reg;
	struct USART0_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_CTLR (*((volatile union USART0_CTLR_REG *)0x40000980))
// model

/** 0x4000 0984 USART0_BRGR **/
union USART0_BRGR_REG{
	unsigned int reg;
	struct USART0_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_BRGR (*((volatile union USART0_BRGR_REG *)0x40000984))
// model

/** 0x4000 0988 USART0_STR **/
union USART0_STR_REG{
	unsigned int reg;
	struct USART0_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_STR (*((volatile union USART0_STR_REG *)0x40000988))
// model

/** 0x4000 098C USART0_TBUFR **/
union USART0_TBUFR_REG{
	unsigned int reg;
	struct USART0_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_TBUFR (*((volatile union USART0_TBUFR_REG *)0x4000098C))
// model

/** 0x4000 098C USART0_RBUFR **/
union USART0_RBUFR_REG{
	unsigned int reg;
	struct USART0_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_RBUFR (*((volatile union USART0_RBUFR_REG *)0x4000098C))
// model

/** 0x4000 0990 USART0_U7816R **/
union USART0_U7816R_REG{
	unsigned int reg;
	struct USART0_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_U7816R (*((volatile union USART0_U7816R_REG *)0x40000990))
// model

/** 0x4000 0994 USART0_IER **/
union USART0_IER_REG{
	unsigned int reg;
	struct USART0_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_IER (*((volatile union USART0_IER_REG *)0x40000994))
// model

/** 0x4000 0998 USART0_ADM **/
union USART0_ADM_REG{
	unsigned int reg;
	struct USART0_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_ADM (*((volatile union USART0_ADM_REG *)0x40000998))
// modelUSART1

/** 0x4000 0A00 USART1_CTLR **/
union USART1_CTLR_REG{
	unsigned int reg;
	struct USART1_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_CTLR (*((volatile union USART1_CTLR_REG *)0x40000A00))
// model

/** 0x4000 0A04 USART1_BRGR **/
union USART1_BRGR_REG{
	unsigned int reg;
	struct USART1_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_BRGR (*((volatile union USART1_BRGR_REG *)0x40000A04))
// model

/** 0x4000 0A08 USART1_STR **/
union USART1_STR_REG{
	unsigned int reg;
	struct USART1_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_STR (*((volatile union USART1_STR_REG *)0x40000A08))
// model

/** 0x4000 0A0C USART1_TBUFR **/
union USART1_TBUFR_REG{
	unsigned int reg;
	struct USART1_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_TBUFR (*((volatile union USART1_TBUFR_REG *)0x40000A0C))
// model

/** 0x4000 0A0C USART1_RBUFR **/
union USART1_RBUFR_REG{
	unsigned int reg;
	struct USART1_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_RBUFR (*((volatile union USART1_RBUFR_REG *)0x40000A0C))
// model

/** 0x4000 0A10 USART1_U7816R **/
union USART1_U7816R_REG{
	unsigned int reg;
	struct USART1_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_U7816R (*((volatile union USART1_U7816R_REG *)0x40000A10))
// model

/** 0x4000 0A14 USART1_IER **/
union USART1_IER_REG{
	unsigned int reg;
	struct USART1_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_IER (*((volatile union USART1_IER_REG *)0x40000A14))
// model

/** 0x4000 0A18 USART1_ADM **/
union USART1_ADM_REG{
	unsigned int reg;
	struct USART1_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_ADM (*((volatile union USART1_ADM_REG *)0x40000A18))
// modelUSART2

/** 0x4000 0A80 USART2_CTLR **/
union USART2_CTLR_REG{
	unsigned int reg;
	struct USART2_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_CTLR (*((volatile union USART2_CTLR_REG *)0x40000A80))
// model

/** 0x4000 0A84 USART2_BRGR **/
union USART2_BRGR_REG{
	unsigned int reg;
	struct USART2_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_BRGR (*((volatile union USART2_BRGR_REG *)0x40000A84))
// model

/** 0x4000 0A88 USART2_STR **/
union USART2_STR_REG{
	unsigned int reg;
	struct USART2_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_STR (*((volatile union USART2_STR_REG *)0x40000A88))
// model

/** 0x4000 0A8C USART2_TBUFR **/
union USART2_TBUFR_REG{
	unsigned int reg;
	struct USART2_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_TBUFR (*((volatile union USART2_TBUFR_REG *)0x40000A8C))
// model

/** 0x4000 0A8C USART2_RBUFR **/
union USART2_RBUFR_REG{
	unsigned int reg;
	struct USART2_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_RBUFR (*((volatile union USART2_RBUFR_REG *)0x40000A8C))
// model

/** 0x4000 0A90 USART2_U7816R **/
union USART2_U7816R_REG{
	unsigned int reg;
	struct USART2_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_U7816R (*((volatile union USART2_U7816R_REG *)0x40000A90))
// model

/** 0x4000 0A94 USART2_IER **/
union USART2_IER_REG{
	unsigned int reg;
	struct USART2_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_IER (*((volatile union USART2_IER_REG *)0x40000A94))
// model

/** 0x4000 0A98 USART2_ADM **/
union USART2_ADM_REG{
	unsigned int reg;
	struct USART2_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_ADM (*((volatile union USART2_ADM_REG *)0x40000A98))
// modelUSART3

/** 0x4000 0B00 USART3_CTLR **/
union USART3_CTLR_REG{
	unsigned int reg;
	struct USART3_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_CTLR (*((volatile union USART3_CTLR_REG *)0x40000B00))
// model

/** 0x4000 0B04 USART3_BRGR **/
union USART3_BRGR_REG{
	unsigned int reg;
	struct USART3_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_BRGR (*((volatile union USART3_BRGR_REG *)0x40000B04))
// model

/** 0x4000 0B08 USART3_STR **/
union USART3_STR_REG{
	unsigned int reg;
	struct USART3_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_STR (*((volatile union USART3_STR_REG *)0x40000B08))
// model

/** 0x4000 0B0C USART3_TBUFR **/
union USART3_TBUFR_REG{
	unsigned int reg;
	struct USART3_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_TBUFR (*((volatile union USART3_TBUFR_REG *)0x40000B0C))
// model

/** 0x4000 0B0C USART3_RBUFR **/
union USART3_RBUFR_REG{
	unsigned int reg;
	struct USART3_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_RBUFR (*((volatile union USART3_RBUFR_REG *)0x40000B0C))
// model

/** 0x4000 0B10 USART3_U7816R **/
union USART3_U7816R_REG{
	unsigned int reg;
	struct USART3_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_U7816R (*((volatile union USART3_U7816R_REG *)0x40000B10))
// model

/** 0x4000 0B14 USART3_IER **/
union USART3_IER_REG{
	unsigned int reg;
	struct USART3_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_IER (*((volatile union USART3_IER_REG *)0x40000B14))
// model

/** 0x4000 0B18 USART3_ADM **/
union USART3_ADM_REG{
	unsigned int reg;
	struct USART3_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_ADM (*((volatile union USART3_ADM_REG *)0x40000B18))
// modelUSART4

/** 0x4000 0B80 USART4_CTLR **/
union USART4_CTLR_REG{
	unsigned int reg;
	struct USART4_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_CTLR (*((volatile union USART4_CTLR_REG *)0x40000B80))
// model

/** 0x4000 0B84 USART4_BRGR **/
union USART4_BRGR_REG{
	unsigned int reg;
	struct USART4_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_BRGR (*((volatile union USART4_BRGR_REG *)0x40000B84))
// model

/** 0x4000 0B88 USART4_STR **/
union USART4_STR_REG{
	unsigned int reg;
	struct USART4_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_STR (*((volatile union USART4_STR_REG *)0x40000B88))
// model

/** 0x4000 0B8C USART4_TBUFR **/
union USART4_TBUFR_REG{
	unsigned int reg;
	struct USART4_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_TBUFR (*((volatile union USART4_TBUFR_REG *)0x40000B8C))
// model

/** 0x4000 0B8C USART4_RBUFR **/
union USART4_RBUFR_REG{
	unsigned int reg;
	struct USART4_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_RBUFR (*((volatile union USART4_RBUFR_REG *)0x40000B8C))
// model

/** 0x4000 0B90 USART4_U7816R **/
union USART4_U7816R_REG{
	unsigned int reg;
	struct USART4_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_U7816R (*((volatile union USART4_U7816R_REG *)0x40000B90))
// model

/** 0x4000 0B94 USART4_IER **/
union USART4_IER_REG{
	unsigned int reg;
	struct USART4_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_IER (*((volatile union USART4_IER_REG *)0x40000B94))
// model

/** 0x4000 0B98 USART4_ADM **/
union USART4_ADM_REG{
	unsigned int reg;
	struct USART4_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_ADM (*((volatile union USART4_ADM_REG *)0x40000B98))
// modelSPI0

/** 0x4000 0C00 SPI0_BRGR **/
union SPI0_BRGR_REG{
	unsigned int reg;
	struct SPI0_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BRGR (*((volatile union SPI0_BRGR_REG *)0x40000C00))
// model

/** 0x4000 0C04 SPI0_CTLR **/
union SPI0_CTLR_REG{
	unsigned int reg;
	struct SPI0_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int :2;
		unsigned int _I2SMOD:1;
		unsigned int :3;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int _TPOEN:1;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_CTLR (*((volatile union SPI0_CTLR_REG *)0x40000C04))
// model

/** 0x4000 0C08 SPI0_BUFR **/
union SPI0_BUFR_REG{
	unsigned int reg;
	struct SPI0_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BUFR (*((volatile union SPI0_BUFR_REG *)0x40000C08))
// model

/** 0x4000 0C0C SPI0_STR **/
union SPI0_STR_REG{
	unsigned int reg;
	struct SPI0_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_STR (*((volatile union SPI0_STR_REG *)0x40000C0C))
// modelSPI1

/** 0x4000 0C80 SPI1_BRGR **/
union SPI1_BRGR_REG{
	unsigned int reg;
	struct SPI1_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BRGR (*((volatile union SPI1_BRGR_REG *)0x40000C80))
// model

/** 0x4000 0C84 SPI1_CTLR **/
union SPI1_CTLR_REG{
	unsigned int reg;
	struct SPI1_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int :2;
		unsigned int _I2SMOD:1;
		unsigned int :3;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int _TPOEN:1;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_CTLR (*((volatile union SPI1_CTLR_REG *)0x40000C84))
// model

/** 0x4000 0C88 SPI1_BUFR **/
union SPI1_BUFR_REG{
	unsigned int reg;
	struct SPI1_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BUFR (*((volatile union SPI1_BUFR_REG *)0x40000C88))
// model

/** 0x4000 0C8C SPI1_STR **/
union SPI1_STR_REG{
	unsigned int reg;
	struct SPI1_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_STR (*((volatile union SPI1_STR_REG *)0x40000C8C))
// modelI2C0

/** 0x4000 0D00 I2C0_CTLR **/
union I2C0_CTLR_REG{
	unsigned int reg;
	struct I2C0_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :6;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int :1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEM:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int :2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_CTLR (*((volatile union I2C0_CTLR_REG *)0x40000D00))
// model

/** 0x4000 0D04 I2C0_SR **/
union I2C0_SR_REG{
	unsigned int reg;
	struct I2C0_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_SR (*((volatile union I2C0_SR_REG *)0x40000D04))
// model

/** 0x4000 0D08 I2C0_BUFR **/
union I2C0_BUFR_REG{
	unsigned int reg;
	struct I2C0_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BUFR (*((volatile union I2C0_BUFR_REG *)0x40000D08))
// model

/** 0x4000 0D0C I2C0_ADDR0 **/
union I2C0_ADDR0_REG{
	unsigned int reg;
	struct I2C0_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR0 (*((volatile union I2C0_ADDR0_REG *)0x40000D0C))
// model

/** 0x4000 0D10 I2C0_BRGR **/
union I2C0_BRGR_REG{
	unsigned int reg;
	struct I2C0_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BRGR (*((volatile union I2C0_BRGR_REG *)0x40000D10))
// model

/** 0x4000 0D14 I2C0_ADDR1 **/
union I2C0_ADDR1_REG{
	unsigned int reg;
	struct I2C0_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR1 (*((volatile union I2C0_ADDR1_REG *)0x40000D14))
// model

/** 0x4000 0D18 I2C0_ADDR2 **/
union I2C0_ADDR2_REG{
	unsigned int reg;
	struct I2C0_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR2 (*((volatile union I2C0_ADDR2_REG *)0x40000D18))
// model

/** 0x4000 0D1C I2C0_ADDR3 **/
union I2C0_ADDR3_REG{
	unsigned int reg;
	struct I2C0_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR3 (*((volatile union I2C0_ADDR3_REG *)0x40000D1C))
// model

/** 0x4000 0D20 I2C0_IER **/
union I2C0_IER_REG{
	unsigned int reg;
	struct I2C0_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIF:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_IER (*((volatile union I2C0_IER_REG *)0x40000D20))
// model

/** 0x4000 0D24 I2C0_TPSR **/
union I2C0_TPSR_REG{
	unsigned int reg;
	struct I2C0_TPSR_BITS{
		unsigned int _I2CTPS:12;
		unsigned int _I2CTPOEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_TPSR (*((volatile union I2C0_TPSR_REG *)0x40000D24))
// modelI2C1

/** 0x4000 0D80 I2C1_CTLR **/
union I2C1_CTLR_REG{
	unsigned int reg;
	struct I2C1_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :6;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int :1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEM:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int :2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_CTLR (*((volatile union I2C1_CTLR_REG *)0x40000D80))
// model

/** 0x4000 0D84 I2C1_SR **/
union I2C1_SR_REG{
	unsigned int reg;
	struct I2C1_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_SR (*((volatile union I2C1_SR_REG *)0x40000D84))
// model

/** 0x4000 0D88 I2C1_BUFR **/
union I2C1_BUFR_REG{
	unsigned int reg;
	struct I2C1_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BUFR (*((volatile union I2C1_BUFR_REG *)0x40000D88))
// model

/** 0x4000 0D8C I2C1_ADDR0 **/
union I2C1_ADDR0_REG{
	unsigned int reg;
	struct I2C1_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR0 (*((volatile union I2C1_ADDR0_REG *)0x40000D8C))
// model

/** 0x4000 0D90 I2C1_BRGR **/
union I2C1_BRGR_REG{
	unsigned int reg;
	struct I2C1_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BRGR (*((volatile union I2C1_BRGR_REG *)0x40000D90))
// model

/** 0x4000 0D94 I2C1_ADDR1 **/
union I2C1_ADDR1_REG{
	unsigned int reg;
	struct I2C1_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR1 (*((volatile union I2C1_ADDR1_REG *)0x40000D94))
// model

/** 0x4000 0D98 I2C1_ADDR2 **/
union I2C1_ADDR2_REG{
	unsigned int reg;
	struct I2C1_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR2 (*((volatile union I2C1_ADDR2_REG *)0x40000D98))
// model

/** 0x4000 0D9C I2C1_ADDR3 **/
union I2C1_ADDR3_REG{
	unsigned int reg;
	struct I2C1_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR3 (*((volatile union I2C1_ADDR3_REG *)0x40000D9C))
// model

/** 0x4000 0DA0 I2C1_IER **/
union I2C1_IER_REG{
	unsigned int reg;
	struct I2C1_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIF:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_IER (*((volatile union I2C1_IER_REG *)0x40000DA0))
// model

/** 0x4000 0DA4 I2C1_TPSR **/
union I2C1_TPSR_REG{
	unsigned int reg;
	struct I2C1_TPSR_BITS{
		unsigned int _I2CTPS:12;
		unsigned int _I2CTPOEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_TPSR (*((volatile union I2C1_TPSR_REG *)0x40000DA4))
// modelI2C2

/** 0x4000 0E00 I2C2_CTLR **/
union I2C2_CTLR_REG{
	unsigned int reg;
	struct I2C2_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :6;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int :1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEM:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int :2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_CTLR (*((volatile union I2C2_CTLR_REG *)0x40000E00))
// model

/** 0x4000 0E04 I2C2_SR **/
union I2C2_SR_REG{
	unsigned int reg;
	struct I2C2_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_SR (*((volatile union I2C2_SR_REG *)0x40000E04))
// model

/** 0x4000 0E08 I2C2_BUFR **/
union I2C2_BUFR_REG{
	unsigned int reg;
	struct I2C2_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_BUFR (*((volatile union I2C2_BUFR_REG *)0x40000E08))
// model

/** 0x4000 0E0C I2C2_ADDR0 **/
union I2C2_ADDR0_REG{
	unsigned int reg;
	struct I2C2_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR0 (*((volatile union I2C2_ADDR0_REG *)0x40000E0C))
// model

/** 0x4000 0E10 I2C2_BRGR **/
union I2C2_BRGR_REG{
	unsigned int reg;
	struct I2C2_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_BRGR (*((volatile union I2C2_BRGR_REG *)0x40000E10))
// model

/** 0x4000 0E14 I2C2_ADDR1 **/
union I2C2_ADDR1_REG{
	unsigned int reg;
	struct I2C2_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR1 (*((volatile union I2C2_ADDR1_REG *)0x40000E14))
// model

/** 0x4000 0E18 I2C2_ADDR2 **/
union I2C2_ADDR2_REG{
	unsigned int reg;
	struct I2C2_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR2 (*((volatile union I2C2_ADDR2_REG *)0x40000E18))
// model

/** 0x4000 0E1C I2C2_ADDR3 **/
union I2C2_ADDR3_REG{
	unsigned int reg;
	struct I2C2_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR3 (*((volatile union I2C2_ADDR3_REG *)0x40000E1C))
// model

/** 0x4000 0E20 I2C2_IER **/
union I2C2_IER_REG{
	unsigned int reg;
	struct I2C2_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIF:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_IER (*((volatile union I2C2_IER_REG *)0x40000E20))
// model

/** 0x4000 0E24 I2C2_TPSR **/
union I2C2_TPSR_REG{
	unsigned int reg;
	struct I2C2_TPSR_BITS{
		unsigned int _I2CTPS:12;
		unsigned int _I2CTPOEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_TPSR (*((volatile union I2C2_TPSR_REG *)0x40000E24))
// modelLCD

/** 0x4000 0E80 LCD_CTL **/
union LCD_CTL_REG{
	unsigned int reg;
	struct LCD_CTL_BITS{
		unsigned int _LP:4;
		unsigned int :1;
		unsigned int _LCDA:1;
		unsigned int _BIASMD:1;
		unsigned int _WFT:1;
		unsigned int :2;
		unsigned int _CS:2;
		unsigned int _PUMPEN:1;
		unsigned int _VLCDMD:1;
		unsigned int :1;
		unsigned int _VLCDS:1;
		unsigned int :1;
		unsigned int _FR:4;
		unsigned int _LMUX:3;
		unsigned int _TRIMCPVOL:3;
		unsigned int _VLCDPEN:1;
		unsigned int _IOEN:1;
		unsigned int :1;
		unsigned int _LCDENANALOG:1;
		unsigned int _LCDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_CTL (*((volatile union LCD_CTL_REG *)0x40000E80))
// model

/** 0x4000 0E84 LCD_PTL **/
union LCD_PTL_REG{
	unsigned int reg;
	struct LCD_PTL_BITS{
		unsigned int _ATIC:3;
		unsigned int _BPC:2;
		unsigned int _APC:2;
		unsigned int _IF:3;
		unsigned int _TS:3;
		unsigned int _SPEN:1;
		unsigned int _FLKSTU:1;
		unsigned int _FLKEN:1;
		unsigned int _FOFF:8;
		unsigned int _FON:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_PTL (*((volatile union LCD_PTL_REG *)0x40000E84))
// model

/** 0x4000 0E88 LCD_INTCTL **/
union LCD_INTCTL_REG{
	unsigned int reg;
	struct LCD_INTCTL_BITS{
		unsigned int _FRAMIE:1;
		unsigned int _FCKOFFIE:1;
		unsigned int _FCKONIE:1;
		unsigned int _UDDIE:1;
		unsigned int _FRAMIF:1;
		unsigned int _FCKOFFIF:1;
		unsigned int _FCKONIF:1;
		unsigned int :3;
		unsigned int _LCDDEAD:1;
		unsigned int _UDR:1;
		unsigned int _UDDIF:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_INTCTL (*((volatile union LCD_INTCTL_REG *)0x40000E88))
// model

/** 0x4000 0E8C LCD_SEL0 **/
union LCD_SEL0_REG{
	unsigned int reg;
	struct LCD_SEL0_BITS{
		unsigned int _SEGSEL0:1;
		unsigned int _SEGSEL1:1;
		unsigned int _SEGSEL2:1;
		unsigned int _SEGSEL3:1;
		unsigned int _SEGSEL4:1;
		unsigned int _SEGSEL5:1;
		unsigned int _SEGSEL6:1;
		unsigned int _SEGSEL7:1;
		unsigned int _SEGSEL8:1;
		unsigned int _SEGSEL9:1;
		unsigned int _SEGSEL10:1;
		unsigned int _SEGSEL11:1;
		unsigned int _SEGSEL12:1;
		unsigned int _SEGSEL13:1;
		unsigned int _SEGSEL14:1;
		unsigned int _SEGSEL15:1;
		unsigned int _SEGSEL16:1;
		unsigned int _SEGSEL17:1;
		unsigned int _SEGSEL18:1;
		unsigned int _SEGSEL19:1;
		unsigned int _SEGSEL20:1;
		unsigned int _SEGSEL21:1;
		unsigned int _SEGSEL22:1;
		unsigned int _SEGSEL23:1;
		unsigned int _SEGSEL24:1;
		unsigned int _SEGSEL25:1;
		unsigned int _SEGSEL26:1;
		unsigned int _SEGSEL27:1;
		unsigned int _SEGSEL28:1;
		unsigned int _SEGSEL29:1;
		unsigned int _SEGSEL30:1;
		unsigned int _SEGSEL31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_SEL0 (*((volatile union LCD_SEL0_REG *)0x40000E8C))
// model

/** 0x4000 0E90 LCD_SEL1 **/
union LCD_SEL1_REG{
	unsigned int reg;
	struct LCD_SEL1_BITS{
		unsigned int _SEGSEL32:1;
		unsigned int _SEGSEL33:1;
		unsigned int _SEGSEL34:1;
		unsigned int _SEGSEL35:1;
		unsigned int _SEGSEL36:1;
		unsigned int _SEGSEL37:1;
		unsigned int _SEGSEL38:1;
		unsigned int _SEGSEL39:1;
		unsigned int _SEGSEL40:1;
		unsigned int _SEGSEL41:1;
		unsigned int _SEGSEL42:1;
		unsigned int _SEGSEL43:1;
		unsigned int _SEGSEL44:1;
		unsigned int _SEGSEL45:1;
		unsigned int _SEGSEL46:1;
		unsigned int _SEGSEL47:1;
		unsigned int _COM0SEL0:1;
		unsigned int _COM1SEL0:1;
		unsigned int _COM2SEL0:1;
		unsigned int _COM3SEL0:1;
		unsigned int _COM4SEL0:1;
		unsigned int _COM5SEL0:1;
		unsigned int _COM6SEL0:1;
		unsigned int _COM7SEL0:1;
		unsigned int _COM0SEL1:1;
		unsigned int _COM1SEL1:1;
		unsigned int _COM2SEL1:1;
		unsigned int _COM3SEL1:1;
		unsigned int _COM4SEL1:1;
		unsigned int _COM5SEL1:1;
		unsigned int _COM6SEL1:1;
		unsigned int _COM7SEL1:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_SEL1 (*((volatile union LCD_SEL1_REG *)0x40000E90))
// model

/** 0x4000 0E94 LCD_SEG0 **/
union LCD_SEG0_REG{
	unsigned int reg;
	struct LCD_SEG0_BITS{
		unsigned int _SEG0:1;
		unsigned int _SEG1:1;
		unsigned int _SEG2:1;
		unsigned int _SEG3:1;
		unsigned int _SEG4:1;
		unsigned int _SEG5:1;
		unsigned int _SEG6:1;
		unsigned int _SEG7:1;
		unsigned int _SEG8:1;
		unsigned int _SEG9:1;
		unsigned int _SEG10:1;
		unsigned int _SEG11:1;
		unsigned int _SEG12:1;
		unsigned int _SEG13:1;
		unsigned int _SEG14:1;
		unsigned int _SEG15:1;
		unsigned int _SEG16:1;
		unsigned int _SEG17:1;
		unsigned int _SEG18:1;
		unsigned int _SEG19:1;
		unsigned int _SEG20:1;
		unsigned int _SEG21:1;
		unsigned int _SEG22:1;
		unsigned int _SEG23:1;
		unsigned int _SEG24:1;
		unsigned int _SEG25:1;
		unsigned int _SEG26:1;
		unsigned int _SEG27:1;
		unsigned int _SEG28:1;
		unsigned int _SEG29:1;
		unsigned int _SEG30:1;
		unsigned int _SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_SEG0 (*((volatile union LCD_SEG0_REG *)0x40000E94))
// model

/** 0x4000 0E98 LCD_SEG1 **/
union LCD_SEG1_REG{
	unsigned int reg;
	struct LCD_SEG1_BITS{
		unsigned int _SEG32:1;
		unsigned int _SEG33:1;
		unsigned int _SEG34:1;
		unsigned int _SEG35:1;
		unsigned int _SEG36:1;
		unsigned int _SEG37:1;
		unsigned int _SEG38:1;
		unsigned int _SEG39:1;
		unsigned int _SEG40:1;
		unsigned int _SEG41:1;
		unsigned int _SEG42:1;
		unsigned int _SEG43:1;
		unsigned int _SEG44:1;
		unsigned int _SEG45:1;
		unsigned int _SEG46:1;
		unsigned int _SEG47:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_SEG1 (*((volatile union LCD_SEG1_REG *)0x40000E98))
// model

/** 0x4000 0EC0 LCD_DATA0 **/
union LCD_DATA0_REG{
	unsigned int reg;
	struct LCD_DATA0_BITS{
		unsigned int _COM0SEG0:1;
		unsigned int _COM0SEG1:1;
		unsigned int _COM0SEG2:1;
		unsigned int _COM0SEG3:1;
		unsigned int _COM0SEG4:1;
		unsigned int _COM0SEG5:1;
		unsigned int _COM0SEG6:1;
		unsigned int _COM0SEG7:1;
		unsigned int _COM0SEG8:1;
		unsigned int _COM0SEG9:1;
		unsigned int _COM0SEG10:1;
		unsigned int _COM0SEG11:1;
		unsigned int _COM0SEG12:1;
		unsigned int _COM0SEG13:1;
		unsigned int _COM0SEG14:1;
		unsigned int _COM0SEG15:1;
		unsigned int _COM0SEG16:1;
		unsigned int _COM0SEG17:1;
		unsigned int _COM0SEG18:1;
		unsigned int _COM0SEG19:1;
		unsigned int _COM0SEG20:1;
		unsigned int _COM0SEG21:1;
		unsigned int _COM0SEG22:1;
		unsigned int _COM0SEG23:1;
		unsigned int _COM0SEG24:1;
		unsigned int _COM0SEG25:1;
		unsigned int _COM0SEG26:1;
		unsigned int _COM0SEG27:1;
		unsigned int _COM0SEG28:1;
		unsigned int _COM0SEG29:1;
		unsigned int _COM0SEG30:1;
		unsigned int _COM0SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA0 (*((volatile union LCD_DATA0_REG *)0x40000EC0))
// model

/** 0x4000 0EC4 LCD_DATA1 **/
union LCD_DATA1_REG{
	unsigned int reg;
	struct LCD_DATA1_BITS{
		unsigned int _COM1SEG0:1;
		unsigned int _COM1SEG1:1;
		unsigned int _COM1SEG2:1;
		unsigned int _COM1SEG3:1;
		unsigned int _COM1SEG4:1;
		unsigned int _COM1SEG5:1;
		unsigned int _COM1SEG6:1;
		unsigned int _COM1SEG7:1;
		unsigned int _COM1SEG8:1;
		unsigned int _COM1SEG9:1;
		unsigned int _COM1SEG10:1;
		unsigned int _COM1SEG11:1;
		unsigned int _COM1SEG12:1;
		unsigned int _COM1SEG13:1;
		unsigned int _COM1SEG14:1;
		unsigned int _COM1SEG15:1;
		unsigned int _COM1SEG16:1;
		unsigned int _COM1SEG17:1;
		unsigned int _COM1SEG18:1;
		unsigned int _COM1SEG19:1;
		unsigned int _COM1SEG20:1;
		unsigned int _COM1SEG21:1;
		unsigned int _COM1SEG22:1;
		unsigned int _COM1SEG23:1;
		unsigned int _COM1SEG24:1;
		unsigned int _COM1SEG25:1;
		unsigned int _COM1SEG26:1;
		unsigned int _COM1SEG27:1;
		unsigned int _COM1SEG28:1;
		unsigned int _COM1SEG29:1;
		unsigned int _COM1SEG30:1;
		unsigned int _COM1SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA1 (*((volatile union LCD_DATA1_REG *)0x40000EC4))
// model

/** 0x4000 0EC8 LCD_DATA2 **/
union LCD_DATA2_REG{
	unsigned int reg;
	struct LCD_DATA2_BITS{
		unsigned int _COM2SEG0:1;
		unsigned int _COM2SEG1:1;
		unsigned int _COM2SEG2:1;
		unsigned int _COM2SEG3:1;
		unsigned int _COM2SEG4:1;
		unsigned int _COM2SEG5:1;
		unsigned int _COM2SEG6:1;
		unsigned int _COM2SEG7:1;
		unsigned int _COM2SEG8:1;
		unsigned int _COM2SEG9:1;
		unsigned int _COM2SEG10:1;
		unsigned int _COM2SEG11:1;
		unsigned int _COM2SEG12:1;
		unsigned int _COM2SEG13:1;
		unsigned int _COM2SEG14:1;
		unsigned int _COM2SEG15:1;
		unsigned int _COM2SEG16:1;
		unsigned int _COM2SEG17:1;
		unsigned int _COM2SEG18:1;
		unsigned int _COM2SEG19:1;
		unsigned int _COM2SEG20:1;
		unsigned int _COM2SEG21:1;
		unsigned int _COM2SEG22:1;
		unsigned int _COM2SEG23:1;
		unsigned int _COM2SEG24:1;
		unsigned int _COM2SEG25:1;
		unsigned int _COM2SEG26:1;
		unsigned int _COM2SEG27:1;
		unsigned int _COM2SEG28:1;
		unsigned int _COM2SEG29:1;
		unsigned int _COM2SEG30:1;
		unsigned int _COM2SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA2 (*((volatile union LCD_DATA2_REG *)0x40000EC8))
// model

/** 0x4000 0ECC LCD_DATA3 **/
union LCD_DATA3_REG{
	unsigned int reg;
	struct LCD_DATA3_BITS{
		unsigned int _COM3SEG0:1;
		unsigned int _COM3SEG1:1;
		unsigned int _COM3SEG2:1;
		unsigned int _COM3SEG3:1;
		unsigned int _COM3SEG4:1;
		unsigned int _COM3SEG5:1;
		unsigned int _COM3SEG6:1;
		unsigned int _COM3SEG7:1;
		unsigned int _COM3SEG8:1;
		unsigned int _COM3SEG9:1;
		unsigned int _COM3SEG10:1;
		unsigned int _COM3SEG11:1;
		unsigned int _COM3SEG12:1;
		unsigned int _COM3SEG13:1;
		unsigned int _COM3SEG14:1;
		unsigned int _COM3SEG15:1;
		unsigned int _COM3SEG16:1;
		unsigned int _COM3SEG17:1;
		unsigned int _COM3SEG18:1;
		unsigned int _COM3SEG19:1;
		unsigned int _COM3SEG20:1;
		unsigned int _COM3SEG21:1;
		unsigned int _COM3SEG22:1;
		unsigned int _COM3SEG23:1;
		unsigned int _COM3SEG24:1;
		unsigned int _COM3SEG25:1;
		unsigned int _COM3SEG26:1;
		unsigned int _COM3SEG27:1;
		unsigned int _COM3SEG28:1;
		unsigned int _COM3SEG29:1;
		unsigned int _COM3SEG30:1;
		unsigned int _COM3SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA3 (*((volatile union LCD_DATA3_REG *)0x40000ECC))
// model

/** 0x4000 0ED0 LCD_DATA4 **/
union LCD_DATA4_REG{
	unsigned int reg;
	struct LCD_DATA4_BITS{
		unsigned int _COM4SEG0:1;
		unsigned int _COM4SEG1:1;
		unsigned int _COM4SEG2:1;
		unsigned int _COM4SEG3:1;
		unsigned int _COM4SEG4:1;
		unsigned int _COM4SEG5:1;
		unsigned int _COM4SEG6:1;
		unsigned int _COM4SEG7:1;
		unsigned int _COM4SEG8:1;
		unsigned int _COM4SEG9:1;
		unsigned int _COM4SEG10:1;
		unsigned int _COM4SEG11:1;
		unsigned int _COM4SEG12:1;
		unsigned int _COM4SEG13:1;
		unsigned int _COM4SEG14:1;
		unsigned int _COM4SEG15:1;
		unsigned int _COM4SEG16:1;
		unsigned int _COM4SEG17:1;
		unsigned int _COM4SEG18:1;
		unsigned int _COM4SEG19:1;
		unsigned int _COM4SEG20:1;
		unsigned int _COM4SEG21:1;
		unsigned int _COM4SEG22:1;
		unsigned int _COM4SEG23:1;
		unsigned int _COM4SEG24:1;
		unsigned int _COM4SEG25:1;
		unsigned int _COM4SEG26:1;
		unsigned int _COM4SEG27:1;
		unsigned int _COM4SEG28:1;
		unsigned int _COM4SEG29:1;
		unsigned int _COM4SEG30:1;
		unsigned int _COM4SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA4 (*((volatile union LCD_DATA4_REG *)0x40000ED0))
// model

/** 0x4000 0ED4 LCD_DATA5 **/
union LCD_DATA5_REG{
	unsigned int reg;
	struct LCD_DATA5_BITS{
		unsigned int _COM5SEG0:1;
		unsigned int _COM5SEG1:1;
		unsigned int _COM5SEG2:1;
		unsigned int _COM5SEG3:1;
		unsigned int _COM5SEG4:1;
		unsigned int _COM5SEG5:1;
		unsigned int _COM5SEG6:1;
		unsigned int _COM5SEG7:1;
		unsigned int _COM5SEG8:1;
		unsigned int _COM5SEG9:1;
		unsigned int _COM5SEG10:1;
		unsigned int _COM5SEG11:1;
		unsigned int _COM5SEG12:1;
		unsigned int _COM5SEG13:1;
		unsigned int _COM5SEG14:1;
		unsigned int _COM5SEG15:1;
		unsigned int _COM5SEG16:1;
		unsigned int _COM5SEG17:1;
		unsigned int _COM5SEG18:1;
		unsigned int _COM5SEG19:1;
		unsigned int _COM5SEG20:1;
		unsigned int _COM5SEG21:1;
		unsigned int _COM5SEG22:1;
		unsigned int _COM5SEG23:1;
		unsigned int _COM5SEG24:1;
		unsigned int _COM5SEG25:1;
		unsigned int _COM5SEG26:1;
		unsigned int _COM5SEG27:1;
		unsigned int _COM5SEG28:1;
		unsigned int _COM5SEG29:1;
		unsigned int _COM5SEG30:1;
		unsigned int _COM5SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA5 (*((volatile union LCD_DATA5_REG *)0x40000ED4))
// model

/** 0x4000 0ED8 LCD_DATA6 **/
union LCD_DATA6_REG{
	unsigned int reg;
	struct LCD_DATA6_BITS{
		unsigned int _COM6SEG0:1;
		unsigned int _COM6SEG1:1;
		unsigned int _COM6SEG2:1;
		unsigned int _COM6SEG3:1;
		unsigned int _COM6SEG4:1;
		unsigned int _COM6SEG5:1;
		unsigned int _COM6SEG6:1;
		unsigned int _COM6SEG7:1;
		unsigned int _COM6SEG8:1;
		unsigned int _COM6SEG9:1;
		unsigned int _COM6SEG10:1;
		unsigned int _COM6SEG11:1;
		unsigned int _COM6SEG12:1;
		unsigned int _COM6SEG13:1;
		unsigned int _COM6SEG14:1;
		unsigned int _COM6SEG15:1;
		unsigned int _COM6SEG16:1;
		unsigned int _COM6SEG17:1;
		unsigned int _COM6SEG18:1;
		unsigned int _COM6SEG19:1;
		unsigned int _COM6SEG20:1;
		unsigned int _COM6SEG21:1;
		unsigned int _COM6SEG22:1;
		unsigned int _COM6SEG23:1;
		unsigned int _COM6SEG24:1;
		unsigned int _COM6SEG25:1;
		unsigned int _COM6SEG26:1;
		unsigned int _COM6SEG27:1;
		unsigned int _COM6SEG28:1;
		unsigned int _COM6SEG29:1;
		unsigned int _COM6SEG30:1;
		unsigned int _COM6SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA6 (*((volatile union LCD_DATA6_REG *)0x40000ED8))
// model

/** 0x4000 0EDC LCD_DATA7 **/
union LCD_DATA7_REG{
	unsigned int reg;
	struct LCD_DATA7_BITS{
		unsigned int _COM7SEG0:1;
		unsigned int _COM7SEG1:1;
		unsigned int _COM7SEG2:1;
		unsigned int _COM7SEG3:1;
		unsigned int _COM7SEG4:1;
		unsigned int _COM7SEG5:1;
		unsigned int _COM7SEG6:1;
		unsigned int _COM7SEG7:1;
		unsigned int _COM7SEG8:1;
		unsigned int _COM7SEG9:1;
		unsigned int _COM7SEG10:1;
		unsigned int _COM7SEG11:1;
		unsigned int _COM7SEG12:1;
		unsigned int _COM7SEG13:1;
		unsigned int _COM7SEG14:1;
		unsigned int _COM7SEG15:1;
		unsigned int _COM7SEG16:1;
		unsigned int _COM7SEG17:1;
		unsigned int _COM7SEG18:1;
		unsigned int _COM7SEG19:1;
		unsigned int _COM7SEG20:1;
		unsigned int _COM7SEG21:1;
		unsigned int _COM7SEG22:1;
		unsigned int _COM7SEG23:1;
		unsigned int _COM7SEG24:1;
		unsigned int _COM7SEG25:1;
		unsigned int _COM7SEG26:1;
		unsigned int _COM7SEG27:1;
		unsigned int _COM7SEG28:1;
		unsigned int _COM7SEG29:1;
		unsigned int _COM7SEG30:1;
		unsigned int _COM7SEG31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA7 (*((volatile union LCD_DATA7_REG *)0x40000EDC))
// model

/** 0x4000 0EE0 LCD_DATA8 **/
union LCD_DATA8_REG{
	unsigned int reg;
	struct LCD_DATA8_BITS{
		unsigned int _COM0SEG32:1;
		unsigned int _COM0SEG33:1;
		unsigned int _COM0SEG34:1;
		unsigned int _COM0SEG35:1;
		unsigned int _COM0SEG36:1;
		unsigned int _COM0SEG37:1;
		unsigned int _COM0SEG38:1;
		unsigned int _COM0SEG39:1;
		unsigned int _COM1SEG32:1;
		unsigned int _COM1SEG33:1;
		unsigned int _COM1SEG34:1;
		unsigned int _COM1SEG35:1;
		unsigned int _COM1SEG36:1;
		unsigned int _COM1SEG37:1;
		unsigned int _COM1SEG38:1;
		unsigned int _COM1SEG39:1;
		unsigned int _COM2SEG32:1;
		unsigned int _COM2SEG33:1;
		unsigned int _COM2SEG34:1;
		unsigned int _COM2SEG35:1;
		unsigned int _COM2SEG36:1;
		unsigned int _COM2SEG37:1;
		unsigned int _COM2SEG38:1;
		unsigned int _COM2SEG39:1;
		unsigned int _COM3SEG32:1;
		unsigned int _COM3SEG33:1;
		unsigned int _COM3SEG34:1;
		unsigned int _COM3SEG35:1;
		unsigned int _COM3SEG36:1;
		unsigned int _COM3SEG37:1;
		unsigned int _COM3SEG38:1;
		unsigned int _COM3SEG39:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA8 (*((volatile union LCD_DATA8_REG *)0x40000EE0))
// model

/** 0x4000 0EE4 LCD_DATA9 **/
union LCD_DATA9_REG{
	unsigned int reg;
	struct LCD_DATA9_BITS{
		unsigned int _COM4SEG32:1;
		unsigned int _COM4SEG33:1;
		unsigned int _COM4SEG34:1;
		unsigned int _COM4SEG35:1;
		unsigned int _COM4SEG36:1;
		unsigned int _COM4SEG37:1;
		unsigned int _COM4SEG38:1;
		unsigned int _COM4SEG39:1;
		unsigned int _COM5SEG32:1;
		unsigned int _COM5SEG33:1;
		unsigned int _COM5SEG34:1;
		unsigned int _COM5SEG35:1;
		unsigned int _COM5SEG36:1;
		unsigned int _COM5SEG37:1;
		unsigned int _COM5SEG38:1;
		unsigned int _COM5SEG39:1;
		unsigned int _COM6SEG32:1;
		unsigned int _COM6SEG33:1;
		unsigned int _COM6SEG34:1;
		unsigned int _COM6SEG35:1;
		unsigned int _COM6SEG36:1;
		unsigned int _COM6SEG37:1;
		unsigned int _COM6SEG38:1;
		unsigned int _COM6SEG39:1;
		unsigned int _COM7SEG32:1;
		unsigned int _COM7SEG33:1;
		unsigned int _COM7SEG34:1;
		unsigned int _COM7SEG35:1;
		unsigned int _COM7SEG36:1;
		unsigned int _COM7SEG37:1;
		unsigned int _COM7SEG38:1;
		unsigned int _COM7SEG39:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA9 (*((volatile union LCD_DATA9_REG *)0x40000EE4))
// model

/** 0x4000 0EE8 LCD_DATA10 **/
union LCD_DATA10_REG{
	unsigned int reg;
	struct LCD_DATA10_BITS{
		unsigned int _COM0SEG40:1;
		unsigned int _COM0SEG41:1;
		unsigned int _COM0SEG42:1;
		unsigned int _COM0SEG43:1;
		unsigned int _COM0SEG44:1;
		unsigned int _COM0SEG45:1;
		unsigned int _COM0SEG46:1;
		unsigned int _COM0SEG47:1;
		unsigned int _COM1SEG40:1;
		unsigned int _COM1SEG41:1;
		unsigned int _COM1SEG42:1;
		unsigned int _COM1SEG43:1;
		unsigned int _COM1SEG44:1;
		unsigned int _COM1SEG45:1;
		unsigned int _COM1SEG46:1;
		unsigned int _COM1SEG47:1;
		unsigned int _COM2SEG40:1;
		unsigned int _COM2SEG41:1;
		unsigned int _COM2SEG42:1;
		unsigned int _COM2SEG43:1;
		unsigned int _COM2SEG44:1;
		unsigned int _COM2SEG45:1;
		unsigned int _COM2SEG46:1;
		unsigned int _COM2SEG47:1;
		unsigned int _COM3SEG40:1;
		unsigned int _COM3SEG41:1;
		unsigned int _COM3SEG42:1;
		unsigned int _COM3SEG43:1;
		unsigned int _COM3SEG44:1;
		unsigned int _COM3SEG45:1;
		unsigned int _COM3SEG46:1;
		unsigned int _COM3SEG47:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA10 (*((volatile union LCD_DATA10_REG *)0x40000EE8))
// model

/** 0x4000 0EEC LCD_DATA11 **/
union LCD_DATA11_REG{
	unsigned int reg;
	struct LCD_DATA11_BITS{
		unsigned int _COM4SEG40:1;
		unsigned int _COM4SEG41:1;
		unsigned int _COM4SEG42:1;
		unsigned int _COM4SEG43:1;
		unsigned int _COM4SEG44:1;
		unsigned int _COM4SEG45:1;
		unsigned int _COM4SEG46:1;
		unsigned int _COM4SEG47:1;
		unsigned int _COM5SEG40:1;
		unsigned int _COM5SEG41:1;
		unsigned int _COM5SEG42:1;
		unsigned int _COM5SEG43:1;
		unsigned int _COM5SEG44:1;
		unsigned int _COM5SEG45:1;
		unsigned int _COM5SEG46:1;
		unsigned int _COM5SEG47:1;
		unsigned int _COM6SEG40:1;
		unsigned int _COM6SEG41:1;
		unsigned int _COM6SEG42:1;
		unsigned int _COM6SEG43:1;
		unsigned int _COM6SEG44:1;
		unsigned int _COM6SEG45:1;
		unsigned int _COM6SEG46:1;
		unsigned int _COM6SEG47:1;
		unsigned int _COM7SEG40:1;
		unsigned int _COM7SEG41:1;
		unsigned int _COM7SEG42:1;
		unsigned int _COM7SEG43:1;
		unsigned int _COM7SEG44:1;
		unsigned int _COM7SEG45:1;
		unsigned int _COM7SEG46:1;
		unsigned int _COM7SEG47:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LCD_DATA11 (*((volatile union LCD_DATA11_REG *)0x40000EEC))
// modelRTC

/** 0x4000 0F00 RTC_CR **/
union RTC_CR_REG{
	unsigned int reg;
	struct RTC_CR_BITS{
		unsigned int _RTCEN:1;
		unsigned int _LD:1;
		unsigned int _RTOFF:1;
		unsigned int _CNF:1;
		unsigned int _HT:1;
		unsigned int _LIF:1;
		unsigned int _RESET:1;
		unsigned int :1;
		unsigned int _RTCSRT:8;
		unsigned int _RTCTT:3;
		unsigned int _SUB1H:1;
		unsigned int _ADD1H:1;
		unsigned int _TSEN:1;
		unsigned int _TSEDGE:1;
		unsigned int _TTOE:1;
		unsigned int _RTCCAL:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_CR (*((volatile union RTC_CR_REG *)0x40000F00))
// model

/** 0x4000 0F04 RTC_ALRA **/
union RTC_ALRA_REG{
	unsigned int reg;
	struct RTC_ALRA_BITS{
		unsigned int _ALRSA:7;
		unsigned int _ASENA:1;
		unsigned int _ALRMA:7;
		unsigned int _AMENA:1;
		unsigned int _ALRHA:6;
		unsigned int _AMPMA:1;
		unsigned int _AHENA:1;
		unsigned int _ALRWA:3;
		unsigned int _AWENA:1;
		unsigned int :3;
		unsigned int _ALRENA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_ALRA (*((volatile union RTC_ALRA_REG *)0x40000F04))
// model

/** 0x4000 0F08 RTC_TMR **/
union RTC_TMR_REG{
	unsigned int reg;
	struct RTC_TMR_BITS{
		unsigned int _SEC:7;
		unsigned int :1;
		unsigned int _MIN:7;
		unsigned int :1;
		unsigned int _HOUR:6;
		unsigned int _AMPM:1;
		unsigned int :1;
		unsigned int _WEK:3;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMR (*((volatile union RTC_TMR_REG *)0x40000F08))
// model

/** 0x4000 0F0C RTC_DTR **/
union RTC_DTR_REG{
	unsigned int reg;
	struct RTC_DTR_BITS{
		unsigned int _DAY:6;
		unsigned int :2;
		unsigned int _MTH:5;
		unsigned int :3;
		unsigned int _YEAR:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_DTR (*((volatile union RTC_DTR_REG *)0x40000F0C))
// model

/** 0x4000 0F10 RTC_ALRB **/
union RTC_ALRB_REG{
	unsigned int reg;
	struct RTC_ALRB_BITS{
		unsigned int _ALRSB:7;
		unsigned int _ASENB:1;
		unsigned int _ALRMB:7;
		unsigned int _AMENB:1;
		unsigned int _ALRHB:6;
		unsigned int _AMPMB:1;
		unsigned int _AHENB:1;
		unsigned int _ALRWB:3;
		unsigned int _AWENB:1;
		unsigned int :3;
		unsigned int _ALRENB:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_ALRB (*((volatile union RTC_ALRB_REG *)0x40000F10))
// model

/** 0x4000 0F14 RTC_TMER **/
union RTC_TMER_REG{
	unsigned int reg;
	struct RTC_TMER_BITS{
		unsigned int _TMR0:16;
		unsigned int _TMR1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMER (*((volatile union RTC_TMER_REG *)0x40000F14))
// model

/** 0x4000 0F18 RTC_TCR **/
union RTC_TCR_REG{
	unsigned int reg;
	struct RTC_TCR_BITS{
		unsigned int _TMR0C:4;
		unsigned int _TMR1C:4;
		unsigned int _TMR0EN:1;
		unsigned int _TMR1EN:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TCR (*((volatile union RTC_TCR_REG *)0x40000F18))
// model

/** 0x4000 0F1C RTC_IER **/
union RTC_IER_REG{
	unsigned int reg;
	struct RTC_IER_BITS{
		unsigned int _SECIE:1;
		unsigned int _MINIE:1;
		unsigned int _HOURIE:1;
		unsigned int _DAYIE:1;
		unsigned int _ALRAIE:1;
		unsigned int _ALRBIE:1;
		unsigned int _TTIE:1;
		unsigned int :1;
		unsigned int _RTCT0IE:1;
		unsigned int _RTCT1IE:1;
		unsigned int _TSOVFIE:1;
		unsigned int _TSIE:1;
		unsigned int :4;
		unsigned int _TP0S:3;
		unsigned int _TP1S:3;
		unsigned int _TPEN:1;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_IER (*((volatile union RTC_IER_REG *)0x40000F1C))
// model

/** 0x4000 0F20 RTC_IFR **/
union RTC_IFR_REG{
	unsigned int reg;
	struct RTC_IFR_BITS{
		unsigned int _SECIF:1;
		unsigned int _MINIF:1;
		unsigned int _HOURIF:1;
		unsigned int _DAYIF:1;
		unsigned int _ALRAIF:1;
		unsigned int _ALRBIF:1;
		unsigned int _TTIF:1;
		unsigned int :1;
		unsigned int _RTCT0IF:1;
		unsigned int _RTCT1IF:1;
		unsigned int _TSOVFIF:1;
		unsigned int _TSIF:1;
		unsigned int :4;
		unsigned int _SECIC:1;
		unsigned int _MINIC:1;
		unsigned int _HOURIC:1;
		unsigned int _DAYIC:1;
		unsigned int _ALRAIC:1;
		unsigned int _ALRBIC:1;
		unsigned int _TTIC:1;
		unsigned int :1;
		unsigned int _RTCT0IC:1;
		unsigned int _RTCT1IC:1;
		unsigned int _TSOVFIC:1;
		unsigned int _TSIC:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_IFR (*((volatile union RTC_IFR_REG *)0x40000F20))
// model

/** 0x4000 0F24 RTC_TMBR **/
union RTC_TMBR_REG{
	unsigned int reg;
	struct RTC_TMBR_BITS{
		unsigned int _SECB:7;
		unsigned int :1;
		unsigned int _MINB:7;
		unsigned int :1;
		unsigned int _HOURB:6;
		unsigned int _AMPMB:1;
		unsigned int :1;
		unsigned int _WEKB:3;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMBR (*((volatile union RTC_TMBR_REG *)0x40000F24))
// model

/** 0x4000 0F28 RTC_DTBR **/
union RTC_DTBR_REG{
	unsigned int reg;
	struct RTC_DTBR_BITS{
		unsigned int _DAYB:6;
		unsigned int :2;
		unsigned int _MTHB:5;
		unsigned int :3;
		unsigned int _YEARB:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_DTBR (*((volatile union RTC_DTBR_REG *)0x40000F28))
// modelUSB

/** 0x4000 0F80 USB_UCON **/
union USB_UCON_REG{
	unsigned int reg;
	struct USB_UCON_BITS{
		unsigned int _PPB0:1;
		unsigned int _DB1:1;
		unsigned int _UPUEN:1;
		unsigned int :1;
		unsigned int _SPEEDEN:1;
		unsigned int :2;
		unsigned int _EYETEST:1;
		unsigned int :1;
		unsigned int _USBEN:1;
		unsigned int _RESUME:1;
		unsigned int _SUSPEND:1;
		unsigned int _PKTDIS:1;
		unsigned int _SE0:1;
		unsigned int _DBRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UCON (*((volatile union USB_UCON_REG *)0x40000F80))
// model

/** 0x4000 0F84 USB_USTAT **/
union USB_USTAT_REG{
	unsigned int reg;
	struct USB_USTAT_BITS{
		unsigned int :1;
		unsigned int _DBI:1;
		unsigned int _PDIR:1;
		unsigned int _PEP:4;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_USTAT (*((volatile union USB_USTAT_REG *)0x40000F84))
// model

/** 0x4000 0F88 USB_UADDR **/
union USB_UADDR_REG{
	unsigned int reg;
	struct USB_UADDR_BITS{
		unsigned int _UADDR:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UADDR (*((volatile union USB_UADDR_REG *)0x40000F88))
// model

/** 0x4000 0F8C USB_UFRAME **/
union USB_UFRAME_REG{
	unsigned int reg;
	struct USB_UFRAME_BITS{
		unsigned int _UFRM:11;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UFRAME (*((volatile union USB_UFRAME_REG *)0x40000F8C))
// model

/** 0x4000 0F90 USB_UIR **/
union USB_UIR_REG{
	unsigned int reg;
	struct USB_UIR_BITS{
		unsigned int _ERRIF:1;
		unsigned int _RSTIF:1;
		unsigned int _TRNSIF:1;
		unsigned int _ACTVIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _STLIF:1;
		unsigned int _SOFIF:1;
		unsigned int :1;
		unsigned int _DFN8EIF:1;
		unsigned int _CRC5EIF:1;
		unsigned int _CRC16EIF:1;
		unsigned int _PIDEIF:1;
		unsigned int _BTOEIF:1;
		unsigned int _BTSEIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UIR (*((volatile union USB_UIR_REG *)0x40000F90))
// model

/** 0x4000 0F94 USB_UIE **/
union USB_UIE_REG{
	unsigned int reg;
	struct USB_UIE_BITS{
		unsigned int _ERRIE:1;
		unsigned int _RSTIE:1;
		unsigned int _TRNSIE:1;
		unsigned int _ACTVIE:1;
		unsigned int _IDLEIE:1;
		unsigned int _STLIE:1;
		unsigned int _SOFIE:1;
		unsigned int :1;
		unsigned int _DFN8EIE:1;
		unsigned int _CRC5EIE:1;
		unsigned int _CRC16EIE:1;
		unsigned int _PIDEIE:1;
		unsigned int _BTOEIE:1;
		unsigned int _BTSEIE:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UIE (*((volatile union USB_UIE_REG *)0x40000F94))
// model

/** 0x4000 0F98 USB_UEP0 **/
union USB_UEP0_REG{
	unsigned int reg;
	struct USB_UEP0_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP0 (*((volatile union USB_UEP0_REG *)0x40000F98))
// model

/** 0x4000 0F9C USB_UEP1 **/
union USB_UEP1_REG{
	unsigned int reg;
	struct USB_UEP1_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP1 (*((volatile union USB_UEP1_REG *)0x40000F9C))
// model

/** 0x4000 0FA0 USB_UEP2 **/
union USB_UEP2_REG{
	unsigned int reg;
	struct USB_UEP2_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP2 (*((volatile union USB_UEP2_REG *)0x40000FA0))
// model

/** 0x4000 0FA4 USB_UEP3 **/
union USB_UEP3_REG{
	unsigned int reg;
	struct USB_UEP3_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP3 (*((volatile union USB_UEP3_REG *)0x40000FA4))
// model

/** 0x4000 0FA8 USB_UEP4 **/
union USB_UEP4_REG{
	unsigned int reg;
	struct USB_UEP4_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP4 (*((volatile union USB_UEP4_REG *)0x40000FA8))
// model

/** 0x4000 0FAC USB_UEP5 **/
union USB_UEP5_REG{
	unsigned int reg;
	struct USB_UEP5_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP5 (*((volatile union USB_UEP5_REG *)0x40000FAC))
// model

/** 0x4000 0FB0 USB_UEP6 **/
union USB_UEP6_REG{
	unsigned int reg;
	struct USB_UEP6_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP6 (*((volatile union USB_UEP6_REG *)0x40000FB0))
// model

/** 0x4000 0FB4 USB_UEP7 **/
union USB_UEP7_REG{
	unsigned int reg;
	struct USB_UEP7_BITS{
		unsigned int _EPSTL:1;
		unsigned int _EPIN:1;
		unsigned int _EPOUT:1;
		unsigned int _EPCONDIS:1;
		unsigned int _EPHSHK:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UEP7 (*((volatile union USB_UEP7_REG *)0x40000FB4))
// model

/** 0x4000 0FB8 USB_UDB **/
union USB_UDB_REG{
	unsigned int reg;
	struct USB_UDB_BITS{
		unsigned int _DEBUG:3;
		unsigned int :1;
		unsigned int _DEBUGEN:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USB_UDB (*((volatile union USB_UDB_REG *)0x40000FB8))
// modelCAN0

/** 0x4000 1100 CAN0_CTLR **/
union CAN0_CTLR_REG{
	unsigned int reg;
	struct CAN0_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int :1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int :4;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_CTLR (*((volatile union CAN0_CTLR_REG *)0x40001100))
// model

/** 0x4000 1104 CAN0_BRGR **/
union CAN0_BRGR_REG{
	unsigned int reg;
	struct CAN0_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_BRGR (*((volatile union CAN0_BRGR_REG *)0x40001104))
// model

/** 0x4000 1108 CAN0_RCR **/
union CAN0_RCR_REG{
	unsigned int reg;
	struct CAN0_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_RCR (*((volatile union CAN0_RCR_REG *)0x40001108))
// model

/** 0x4000 110C CAN0_EROR **/
union CAN0_EROR_REG{
	unsigned int reg;
	struct CAN0_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_EROR (*((volatile union CAN0_EROR_REG *)0x4000110C))
// model

/** 0x4000 1110 CAN0_ACRR **/
union CAN0_ACRR_REG{
	unsigned int reg;
	struct CAN0_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_ACRR (*((volatile union CAN0_ACRR_REG *)0x40001110))
// model

/** 0x4000 1114 CAN0_MSKR **/
union CAN0_MSKR_REG{
	unsigned int reg;
	struct CAN0_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_MSKR (*((volatile union CAN0_MSKR_REG *)0x40001114))
// model

/** 0x4000 1118 CAN0_IER **/
union CAN0_IER_REG{
	unsigned int reg;
	struct CAN0_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CANTXDE:1;
		unsigned int _CANRXDE:1;
		unsigned int _CANRFIE:1;
		unsigned int :5;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :6;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _LPCANGPIOSEL1:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_IER (*((volatile union CAN0_IER_REG *)0x40001118))
// model

/** 0x4000 111C CAN0_IFR **/
union CAN0_IFR_REG{
	unsigned int reg;
	struct CAN0_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_IFR (*((volatile union CAN0_IFR_REG *)0x4000111C))
// model

/** 0x4000 1120 CAN0_INFR **/
union CAN0_INFR_REG{
	unsigned int reg;
	struct CAN0_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_INFR (*((volatile union CAN0_INFR_REG *)0x40001120))
// model

/** 0x4000 1124 CAN0_TX0R **/
union CAN0_TX0R_REG{
	unsigned int reg;
	struct CAN0_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_TX0R (*((volatile union CAN0_TX0R_REG *)0x40001124))
// model

/** 0x4000 1128 CAN0_TX1R **/
union CAN0_TX1R_REG{
	unsigned int reg;
	struct CAN0_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_TX1R (*((volatile union CAN0_TX1R_REG *)0x40001128))
// model

/** 0x4000 112C CAN0_TX2R **/
union CAN0_TX2R_REG{
	unsigned int reg;
	struct CAN0_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_TX2R (*((volatile union CAN0_TX2R_REG *)0x4000112C))
// model

/** 0x4000 1130 CAN0_RXDATA0 **/
union CAN0_RXDATA0_REG{
	unsigned int reg;
	struct CAN0_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_RXDATA0 (*((volatile union CAN0_RXDATA0_REG *)0x40001130))
// model

/** 0x4000 1134 CAN0_RXDATA1 **/
union CAN0_RXDATA1_REG{
	unsigned int reg;
	struct CAN0_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_RXDATA1 (*((volatile union CAN0_RXDATA1_REG *)0x40001134))
// model

/** 0x4000 1138 CAN0_RXDATA2 **/
union CAN0_RXDATA2_REG{
	unsigned int reg;
	struct CAN0_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_RXDATA2 (*((volatile union CAN0_RXDATA2_REG *)0x40001138))
// model

/** 0x4000 113C CAN0_RXDATA3 **/
union CAN0_RXDATA3_REG{
	unsigned int reg;
	struct CAN0_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN0_RXDATA3 (*((volatile union CAN0_RXDATA3_REG *)0x4000113C))
// modelCAN1

/** 0x4000 1180 CAN1_CTLR **/
union CAN1_CTLR_REG{
	unsigned int reg;
	struct CAN1_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int :1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int :4;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_CTLR (*((volatile union CAN1_CTLR_REG *)0x40001180))
// model

/** 0x4000 1184 CAN1_BRGR **/
union CAN1_BRGR_REG{
	unsigned int reg;
	struct CAN1_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_BRGR (*((volatile union CAN1_BRGR_REG *)0x40001184))
// model

/** 0x4000 1188 CAN1_RCR **/
union CAN1_RCR_REG{
	unsigned int reg;
	struct CAN1_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_RCR (*((volatile union CAN1_RCR_REG *)0x40001188))
// model

/** 0x4000 118C CAN1_EROR **/
union CAN1_EROR_REG{
	unsigned int reg;
	struct CAN1_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_EROR (*((volatile union CAN1_EROR_REG *)0x4000118C))
// model

/** 0x4000 1190 CAN1_ACRR **/
union CAN1_ACRR_REG{
	unsigned int reg;
	struct CAN1_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_ACRR (*((volatile union CAN1_ACRR_REG *)0x40001190))
// model

/** 0x4000 1194 CAN1_MSKR **/
union CAN1_MSKR_REG{
	unsigned int reg;
	struct CAN1_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_MSKR (*((volatile union CAN1_MSKR_REG *)0x40001194))
// model

/** 0x4000 1198 CAN1_IER **/
union CAN1_IER_REG{
	unsigned int reg;
	struct CAN1_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CANTXDE:1;
		unsigned int _CANRXDE:1;
		unsigned int _CANRFIE:1;
		unsigned int :5;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_IER (*((volatile union CAN1_IER_REG *)0x40001198))
// model

/** 0x4000 119C CAN1_IFR **/
union CAN1_IFR_REG{
	unsigned int reg;
	struct CAN1_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_IFR (*((volatile union CAN1_IFR_REG *)0x4000119C))
// model

/** 0x4000 11A0 CAN1_INFR **/
union CAN1_INFR_REG{
	unsigned int reg;
	struct CAN1_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_INFR (*((volatile union CAN1_INFR_REG *)0x400011A0))
// model

/** 0x4000 11A4 CAN1_TX0R **/
union CAN1_TX0R_REG{
	unsigned int reg;
	struct CAN1_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_TX0R (*((volatile union CAN1_TX0R_REG *)0x400011A4))
// model

/** 0x4000 11A8 CAN1_TX1R **/
union CAN1_TX1R_REG{
	unsigned int reg;
	struct CAN1_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_TX1R (*((volatile union CAN1_TX1R_REG *)0x400011A8))
// model

/** 0x4000 11AC CAN1_TX2R **/
union CAN1_TX2R_REG{
	unsigned int reg;
	struct CAN1_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_TX2R (*((volatile union CAN1_TX2R_REG *)0x400011AC))
// model

/** 0x4000 11B0 CAN1_RXDATA0 **/
union CAN1_RXDATA0_REG{
	unsigned int reg;
	struct CAN1_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_RXDATA0 (*((volatile union CAN1_RXDATA0_REG *)0x400011B0))
// model

/** 0x4000 11B4 CAN1_RXDATA1 **/
union CAN1_RXDATA1_REG{
	unsigned int reg;
	struct CAN1_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_RXDATA1 (*((volatile union CAN1_RXDATA1_REG *)0x400011B4))
// model

/** 0x4000 11B8 CAN1_RXDATA2 **/
union CAN1_RXDATA2_REG{
	unsigned int reg;
	struct CAN1_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_RXDATA2 (*((volatile union CAN1_RXDATA2_REG *)0x400011B8))
// model

/** 0x4000 11BC CAN1_RXDATA3 **/
union CAN1_RXDATA3_REG{
	unsigned int reg;
	struct CAN1_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN1_RXDATA3 (*((volatile union CAN1_RXDATA3_REG *)0x400011BC))
// modelIWDT

/** 0x4000 1200 IWDT_CTL **/
union IWDT_CTL_REG{
	unsigned int reg;
	struct IWDT_CTL_BITS{
		unsigned int _IWDTPS:4;
		unsigned int _IWDTOVF:12;
		unsigned int :14;
		unsigned int _TPEN:1;
		unsigned int _IWDTEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_CTL (*((volatile union IWDT_CTL_REG *)0x40001200))
// model

/** 0x4000 1204 IWDT_FD **/
union IWDT_FD_REG{
	unsigned int reg;
	struct IWDT_FD_BITS{
		unsigned int _IWDTFD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_FD (*((volatile union IWDT_FD_REG *)0x40001204))
// modelWWDT

/** 0x4000 1280 WWDT_CTL **/
union WWDT_CTL_REG{
	unsigned int reg;
	struct WWDT_CTL_BITS{
		unsigned int _WWDTEN:1;
		unsigned int _WWDTIE:1;
		unsigned int _WWDTIF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WWDTIC:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL (*((volatile union WWDT_CTL_REG *)0x40001280))
// model

/** 0x4000 1284 WWDT_CNT **/
union WWDT_CNT_REG{
	unsigned int reg;
	struct WWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :8;
		unsigned int _TPEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CNT (*((volatile union WWDT_CNT_REG *)0x40001284))
// modelBKP

/** 0x4000 1400 BKP_CTL **/
union BKP_CTL_REG{
	unsigned int reg;
	struct BKP_CTL_BITS{
		unsigned int :1;
		unsigned int _EXTHFBYP:1;
		unsigned int _EXTLFBYP:1;
		unsigned int :5;
		unsigned int _RTCCLK:2;
		unsigned int :6;
		unsigned int _TAMP1EN:1;
		unsigned int _TAMP2EN:1;
		unsigned int _TAMP3EN:1;
		unsigned int :1;
		unsigned int _TAMP1LVL:1;
		unsigned int _TAMP2LVL:1;
		unsigned int _TAMP3LVL:1;
		unsigned int :8;
		unsigned int _BKDRST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_CTL (*((volatile union BKP_CTL_REG *)0x40001400))
// model

/** 0x4000 1404 BKP_INT **/
union BKP_INT_REG{
	unsigned int reg;
	struct BKP_INT_BITS{
		unsigned int _TAMP1IC:1;
		unsigned int _TAMP2IC:1;
		unsigned int _TAMP3IC:1;
		unsigned int :5;
		unsigned int _TAMP1IE:1;
		unsigned int _TAMP2IE:1;
		unsigned int _TAMP3IE:1;
		unsigned int :5;
		unsigned int _TAMP1IF:1;
		unsigned int _TAMP2IF:1;
		unsigned int _TAMP3IF:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_INT (*((volatile union BKP_INT_REG *)0x40001404))
// model

/** 0x4000 1440 BKP_DATA0 **/
union BKP_DATA0_REG{
	unsigned int reg;
	struct BKP_DATA0_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA0 (*((volatile union BKP_DATA0_REG *)0x40001440))
// model

/** 0x4000 1444 BKP_DATA1 **/
union BKP_DATA1_REG{
	unsigned int reg;
	struct BKP_DATA1_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA1 (*((volatile union BKP_DATA1_REG *)0x40001444))
// model

/** 0x4000 1448 BKP_DATA2 **/
union BKP_DATA2_REG{
	unsigned int reg;
	struct BKP_DATA2_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA2 (*((volatile union BKP_DATA2_REG *)0x40001448))
// model

/** 0x4000 144C BKP_DATA3 **/
union BKP_DATA3_REG{
	unsigned int reg;
	struct BKP_DATA3_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA3 (*((volatile union BKP_DATA3_REG *)0x4000144C))
// model

/** 0x4000 1450 BKP_DATA4 **/
union BKP_DATA4_REG{
	unsigned int reg;
	struct BKP_DATA4_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA4 (*((volatile union BKP_DATA4_REG *)0x40001450))
// model

/** 0x4000 1454 BKP_DATA5 **/
union BKP_DATA5_REG{
	unsigned int reg;
	struct BKP_DATA5_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA5 (*((volatile union BKP_DATA5_REG *)0x40001454))
// model

/** 0x4000 1458 BKP_DATA6 **/
union BKP_DATA6_REG{
	unsigned int reg;
	struct BKP_DATA6_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA6 (*((volatile union BKP_DATA6_REG *)0x40001458))
// model

/** 0x4000 145C BKP_DATA7 **/
union BKP_DATA7_REG{
	unsigned int reg;
	struct BKP_DATA7_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA7 (*((volatile union BKP_DATA7_REG *)0x4000145C))
// model

/** 0x4000 1460 BKP_DATA8 **/
union BKP_DATA8_REG{
	unsigned int reg;
	struct BKP_DATA8_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA8 (*((volatile union BKP_DATA8_REG *)0x40001460))
// model

/** 0x4000 1464 BKP_DATA9 **/
union BKP_DATA9_REG{
	unsigned int reg;
	struct BKP_DATA9_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA9 (*((volatile union BKP_DATA9_REG *)0x40001464))
// model

/** 0x4000 1468 BKP_DATA10 **/
union BKP_DATA10_REG{
	unsigned int reg;
	struct BKP_DATA10_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA10 (*((volatile union BKP_DATA10_REG *)0x40001468))
// model

/** 0x4000 146C BKP_DATA11 **/
union BKP_DATA11_REG{
	unsigned int reg;
	struct BKP_DATA11_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA11 (*((volatile union BKP_DATA11_REG *)0x4000146C))
// model

/** 0x4000 1470 BKP_DATA12 **/
union BKP_DATA12_REG{
	unsigned int reg;
	struct BKP_DATA12_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA12 (*((volatile union BKP_DATA12_REG *)0x40001470))
// model

/** 0x4000 1474 BKP_DATA13 **/
union BKP_DATA13_REG{
	unsigned int reg;
	struct BKP_DATA13_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA13 (*((volatile union BKP_DATA13_REG *)0x40001474))
// model

/** 0x4000 1478 BKP_DATA14 **/
union BKP_DATA14_REG{
	unsigned int reg;
	struct BKP_DATA14_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA14 (*((volatile union BKP_DATA14_REG *)0x40001478))
// model

/** 0x4000 147C BKP_DATA15 **/
union BKP_DATA15_REG{
	unsigned int reg;
	struct BKP_DATA15_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA15 (*((volatile union BKP_DATA15_REG *)0x4000147C))
// model

/** 0x4000 1480 BKP_DATA16 **/
union BKP_DATA16_REG{
	unsigned int reg;
	struct BKP_DATA16_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA16 (*((volatile union BKP_DATA16_REG *)0x40001480))
// model

/** 0x4000 1484 BKP_DATA17 **/
union BKP_DATA17_REG{
	unsigned int reg;
	struct BKP_DATA17_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA17 (*((volatile union BKP_DATA17_REG *)0x40001484))
// model

/** 0x4000 1488 BKP_DATA18 **/
union BKP_DATA18_REG{
	unsigned int reg;
	struct BKP_DATA18_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA18 (*((volatile union BKP_DATA18_REG *)0x40001488))
// model

/** 0x4000 148C BKP_DATA19 **/
union BKP_DATA19_REG{
	unsigned int reg;
	struct BKP_DATA19_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA19 (*((volatile union BKP_DATA19_REG *)0x4000148C))
// model

/** 0x4000 1490 BKP_DATA20 **/
union BKP_DATA20_REG{
	unsigned int reg;
	struct BKP_DATA20_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA20 (*((volatile union BKP_DATA20_REG *)0x40001490))
// model

/** 0x4000 1494 BKP_DATA21 **/
union BKP_DATA21_REG{
	unsigned int reg;
	struct BKP_DATA21_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA21 (*((volatile union BKP_DATA21_REG *)0x40001494))
// model

/** 0x4000 1498 BKP_DATA22 **/
union BKP_DATA22_REG{
	unsigned int reg;
	struct BKP_DATA22_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA22 (*((volatile union BKP_DATA22_REG *)0x40001498))
// model

/** 0x4000 149C BKP_DATA23 **/
union BKP_DATA23_REG{
	unsigned int reg;
	struct BKP_DATA23_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA23 (*((volatile union BKP_DATA23_REG *)0x4000149C))
// model

/** 0x4000 14A0 BKP_DATA24 **/
union BKP_DATA24_REG{
	unsigned int reg;
	struct BKP_DATA24_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA24 (*((volatile union BKP_DATA24_REG *)0x400014A0))
// model

/** 0x4000 14A4 BKP_DATA25 **/
union BKP_DATA25_REG{
	unsigned int reg;
	struct BKP_DATA25_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA25 (*((volatile union BKP_DATA25_REG *)0x400014A4))
// model

/** 0x4000 14A8 BKP_DATA26 **/
union BKP_DATA26_REG{
	unsigned int reg;
	struct BKP_DATA26_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA26 (*((volatile union BKP_DATA26_REG *)0x400014A8))
// model

/** 0x4000 14AC BKP_DATA27 **/
union BKP_DATA27_REG{
	unsigned int reg;
	struct BKP_DATA27_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA27 (*((volatile union BKP_DATA27_REG *)0x400014AC))
// model

/** 0x4000 14B0 BKP_DATA28 **/
union BKP_DATA28_REG{
	unsigned int reg;
	struct BKP_DATA28_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA28 (*((volatile union BKP_DATA28_REG *)0x400014B0))
// model

/** 0x4000 14B4 BKP_DATA29 **/
union BKP_DATA29_REG{
	unsigned int reg;
	struct BKP_DATA29_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA29 (*((volatile union BKP_DATA29_REG *)0x400014B4))
// model

/** 0x4000 14B8 BKP_DATA30 **/
union BKP_DATA30_REG{
	unsigned int reg;
	struct BKP_DATA30_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA30 (*((volatile union BKP_DATA30_REG *)0x400014B8))
// model

/** 0x4000 14BC BKP_DATA31 **/
union BKP_DATA31_REG{
	unsigned int reg;
	struct BKP_DATA31_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA31 (*((volatile union BKP_DATA31_REG *)0x400014BC))
// modelRST

/** 0x4000 1500 RST_CTL0 **/
union RST_CTL0_REG{
	unsigned int reg;
	struct RST_CTL0_BITS{
		unsigned int _GPIOARST:1;
		unsigned int _GPIOBRST:1;
		unsigned int _GPIOCRST:1;
		unsigned int _GPIODRST:1;
		unsigned int _GPIOERST:1;
		unsigned int _GPIOFRST:1;
		unsigned int _GPIOGRST:1;
		unsigned int _GPIOHRST:1;
		unsigned int :23;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL0 (*((volatile union RST_CTL0_REG *)0x40001500))
// model

/** 0x4000 1504 RST_CTL1 **/
union RST_CTL1_REG{
	unsigned int reg;
	struct RST_CTL1_BITS{
		unsigned int :1;
		unsigned int _QEI1RST:1;
		unsigned int _T1RST:1;
		unsigned int _T2RST:1;
		unsigned int _T3RST:1;
		unsigned int _T4RST:1;
		unsigned int _T5T6RST:1;
		unsigned int :1;
		unsigned int _T9T10RST:1;
		unsigned int :1;
		unsigned int _QEI0RST:1;
		unsigned int _ADC0RST:1;
		unsigned int _ADC1RST:1;
		unsigned int _ADC2RST:1;
		unsigned int _DAC0RST:1;
		unsigned int _DAC1RST:1;
		unsigned int _CMPRST:1;
		unsigned int _T0RST:1;
		unsigned int _CTOUCHRST:1;
		unsigned int _USART0RST:1;
		unsigned int _USART1RST:1;
		unsigned int _USART2RST:1;
		unsigned int _USART3RST:1;
		unsigned int _USART4RST:1;
		unsigned int _SPI0RST:1;
		unsigned int _SPI1RST:1;
		unsigned int _I2C0RST:1;
		unsigned int _I2C1RST:1;
		unsigned int _I2C2RST:1;
		unsigned int _LCDRST:1;
		unsigned int :1;
		unsigned int _USBRST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL1 (*((volatile union RST_CTL1_REG *)0x40001504))
// model

/** 0x4000 1508 RST_CTL2 **/
union RST_CTL2_REG{
	unsigned int reg;
	struct RST_CTL2_BITS{
		unsigned int :1;
		unsigned int :1;
		unsigned int _CAN0RST:1;
		unsigned int _CAN1RST:1;
		unsigned int :1;
		unsigned int _WWDTRST:1;
		unsigned int :5;
		unsigned int :1;
		unsigned int _DMA0RST:1;
		unsigned int :1;
		unsigned int _DMA1RST:1;
		unsigned int :1;
		unsigned int _T14RST:1;
		unsigned int _T15RST:1;
		unsigned int _CAN2RST:1;
		unsigned int _CAN3RST:1;
		unsigned int :1;
		unsigned int _T18RST:1;
		unsigned int _T19RST:1;
		unsigned int _T20RST:1;
		unsigned int _T21RST:1;
		unsigned int _T22RST:1;
		unsigned int _T23RST:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _USART5RST:1;
		unsigned int _USART6RST:1;
		unsigned int _USART7RST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL2 (*((volatile union RST_CTL2_REG *)0x40001508))
// model

/** 0x4000 150C RST_CTL3 **/
union RST_CTL3_REG{
	unsigned int reg;
	struct RST_CTL3_BITS{
		unsigned int :1;
		unsigned int _SPI2RST:1;
		unsigned int _SPI3RST:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _I2C3RST:1;
		unsigned int :4;
		unsigned int :1;
		unsigned int _CRCRST:1;
		unsigned int _AESRST:1;
		unsigned int _LEDRST:1;
		unsigned int _EXICRST:1;
		unsigned int _CAN4RST:1;
		unsigned int _CAN5RST:1;
		unsigned int _CFGLRST:1;
		unsigned int _OPRST:1;
		unsigned int :10;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL3 (*((volatile union RST_CTL3_REG *)0x4000150C))
// modelPM

/** 0x4000 1580 PM_CTL0 **/
union PM_CTL0_REG{
	unsigned int reg;
	struct PM_CTL0_BITS{
		unsigned int _LPMS:3;
		unsigned int _MEMSEL:1;
		unsigned int _NRSTEN:1;
		unsigned int _LPREN:1;
		unsigned int _OCAL0LOCK:1;
		unsigned int _BKPWR:1;
		unsigned int _HSIEN:1;
		unsigned int _PDMDELAY0:1;
		unsigned int _PDMDELAY1:1;
		unsigned int _PDMSEL:1;
		unsigned int :1;
		unsigned int _PHERIIOSEL:1;
		unsigned int _BKPPORDELAYSEL:1;
		unsigned int _PORDELAYSEL:1;
		unsigned int _IWDTRMSEL:1;
		unsigned int _LSECONF:1;
		unsigned int _LP4MEN:1;
		unsigned int _LPRAMSEL:1;
		unsigned int _DPRAMASEL:1;
		unsigned int _IWDTCLR:1;
		unsigned int _BKPREGCLR:1;
		unsigned int _LPBGON:1;
		unsigned int _LDO18EN:1;
		unsigned int _MRBGEN:1;
		unsigned int :1;
		unsigned int _LSEEXEN:1;
		unsigned int _LSEEN:1;
		unsigned int _LSIEN:1;
		unsigned int _VDDPORON:1;
		unsigned int _IOLATCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL0 (*((volatile union PM_CTL0_REG *)0x40001580))
// model

/** 0x4000 1584 PM_CTL1 **/
union PM_CTL1_REG{
	unsigned int reg;
	struct PM_CTL1_BITS{
		unsigned int _PVDEN:1;
		unsigned int :1;
		unsigned int _PVDS:3;
		unsigned int _VREFEN:1;
		unsigned int _VREFSEL:2;
		unsigned int :3;
		unsigned int :1;
		unsigned int _BATBORSEL:3;
		unsigned int _BATBOREN:1;
		unsigned int :5;
		unsigned int :1;
		unsigned int _BUFCLKDIV:3;
		unsigned int _BUFCLKEN:1;
		unsigned int _INTBUFEN:1;
		unsigned int _P18OE:1;
		unsigned int _TSOE:1;
		unsigned int _TSEN:1;
		unsigned int _LPBOREN:1;
		unsigned int _BOREN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL1 (*((volatile union PM_CTL1_REG *)0x40001584))
// model

/** 0x4000 1588 PM_STA0 **/
union PM_STA0_REG{
	unsigned int reg;
	struct PM_STA0_BITS{
		unsigned int _LPRSTA:1;
		unsigned int _LPRUNF:1;
		unsigned int :23;
		unsigned int _WSRSTF:1;
		unsigned int _BORF:1;
		unsigned int _PORF:1;
		unsigned int _WKPPINF:1;
		unsigned int _RTCALRF:1;
		unsigned int _IWDTF:1;
		unsigned int _RSTFC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA0 (*((volatile union PM_STA0_REG *)0x40001588))
// model

/** 0x4000 158C PM_STA1 **/
union PM_STA1_REG{
	unsigned int reg;
	struct PM_STA1_BITS{
		unsigned int _PVDSTA:1;
		unsigned int :21;
		unsigned int _POR18STA:1;
		unsigned int _VBATBORSAT:1;
		unsigned int :3;
		unsigned int _WKP1STA:1;
		unsigned int _WKP2STA:1;
		unsigned int _WKP3STA:1;
		unsigned int _WKP4STA:1;
		unsigned int _WKP5STA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA1 (*((volatile union PM_STA1_REG *)0x4000158C))
// model

/** 0x4000 1590 PM_STAC **/
union PM_STAC_REG{
	unsigned int reg;
	struct PM_STAC_BITS{
		unsigned int :27;
		unsigned int _WKP1SC:1;
		unsigned int _WKP2SC:1;
		unsigned int _WKP3SC:1;
		unsigned int _WKP4SC:1;
		unsigned int _WKP5SC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STAC (*((volatile union PM_STAC_REG *)0x40001590))
// model

/** 0x4000 1594 PM_CTL2 **/
union PM_CTL2_REG{
	unsigned int reg;
	struct PM_CTL2_BITS{
		unsigned int _CAN0LPEN:1;
		unsigned int _CCP0LPEN:1;
		unsigned int _LCDLPEN:1;
		unsigned int _USART0LPEN:1;
		unsigned int _CAN0CLKLPEN:1;
		unsigned int _CCP0CLKLPEN:1;
		unsigned int _LCDCLKLPEN:1;
		unsigned int _USART0CLKLPEN:1;
		unsigned int _POR18SHD:1;
		unsigned int _VF12INF0:1;
		unsigned int _VF12INF1:1;
		unsigned int _VF12EN:1;
		unsigned int _RTCTSEL:2;
		unsigned int _RTCTPEN:1;
		unsigned int _RTCTWEN:1;
		unsigned int _CT_RESET:1;
		unsigned int :3;
		unsigned int _VBKPORSHD:1;
		unsigned int _VBKPOREN:1;
		unsigned int _WKP1P:1;
		unsigned int _WKP2P:1;
		unsigned int _WKP3P:1;
		unsigned int _WKP4P:1;
		unsigned int _WKP5P:1;
		unsigned int _WKP1EN:1;
		unsigned int _WKP2EN:1;
		unsigned int _WKP3EN:1;
		unsigned int _WKP4EN:1;
		unsigned int _WKP5EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL2 (*((volatile union PM_CTL2_REG *)0x40001594))
// model

/** 0x4000 1598 PM_CAL0 **/
union PM_CAL0_REG{
	unsigned int reg;
	struct PM_CAL0_BITS{
		unsigned int _BGTRIMFLLDO:4;
		unsigned int _BGTRIMMRLDO:4;
		unsigned int _BGTRIMREFBUF:5;
		unsigned int _MRHVTRIM:2;
		unsigned int _MRHVEN:1;
		unsigned int _MRTRIM:2;
		unsigned int _BOR_VREF_SEL:1;
		unsigned int :1;
		unsigned int _BORSEL:2;
		unsigned int _FLBGEN:1;
		unsigned int _BOR_HSEN:1;
		unsigned int _ZEROTISTRIM:2;
		unsigned int _FLBG:3;
		unsigned int _LPRSEL:1;
		unsigned int _MRBGSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL0 (*((volatile union PM_CAL0_REG *)0x40001598))
// model

/** 0x4000 159C PM_CAL1 **/
union PM_CAL1_REG{
	unsigned int reg;
	struct PM_CAL1_BITS{
		unsigned int _LSETRIMNBIAS:2;
		unsigned int _LSETRIMBIAS:4;
		unsigned int _LP4MTRIM:9;
		unsigned int _HSESEL:1;
		unsigned int _LPBGTRIMPUMP:3;
		unsigned int _LSESEL:1;
		unsigned int _LPTRIMBIAS:3;
		unsigned int _SPCPUR:1;
		unsigned int _LSITRIMCAP:5;
		unsigned int _LSITRIMBIAS:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL1 (*((volatile union PM_CAL1_REG *)0x4000159C))
// model

/** 0x4000 15A0 PM_CAL2 **/
union PM_CAL2_REG{
	unsigned int reg;
	struct PM_CAL2_BITS{
		unsigned int _MRDEL:2;
		unsigned int _VCOREDEL:2;
		unsigned int _LPRDEL:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL2 (*((volatile union PM_CAL2_REG *)0x400015A0))
// modelDMA0

/** 0x4000 1600 DMA0_CTLR1 **/
union DMA0_CTLR1_REG{
	unsigned int reg;
	struct DMA0_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR1 (*((volatile union DMA0_CTLR1_REG *)0x40001600))
// model

/** 0x4000 1604 DMA0_CTLR2 **/
union DMA0_CTLR2_REG{
	unsigned int reg;
	struct DMA0_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR2 (*((volatile union DMA0_CTLR2_REG *)0x40001604))
// model

/** 0x4000 1608 DMA0_CTLR3 **/
union DMA0_CTLR3_REG{
	unsigned int reg;
	struct DMA0_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR3 (*((volatile union DMA0_CTLR3_REG *)0x40001608))
// model

/** 0x4000 160C DMA0_CTLR4 **/
union DMA0_CTLR4_REG{
	unsigned int reg;
	struct DMA0_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR4 (*((volatile union DMA0_CTLR4_REG *)0x4000160C))
// model

/** 0x4000 1610 DMA0_CTLR5 **/
union DMA0_CTLR5_REG{
	unsigned int reg;
	struct DMA0_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR5 (*((volatile union DMA0_CTLR5_REG *)0x40001610))
// model

/** 0x4000 1614 DMA0_CTLR6 **/
union DMA0_CTLR6_REG{
	unsigned int reg;
	struct DMA0_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR6 (*((volatile union DMA0_CTLR6_REG *)0x40001614))
// model

/** 0x4000 1618 DMA0_CTLR7 **/
union DMA0_CTLR7_REG{
	unsigned int reg;
	struct DMA0_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR7 (*((volatile union DMA0_CTLR7_REG *)0x40001618))
// model

/** 0x4000 1620 DMA0_PADDR1 **/
union DMA0_PADDR1_REG{
	unsigned int reg;
	struct DMA0_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR1 (*((volatile union DMA0_PADDR1_REG *)0x40001620))
// model

/** 0x4000 1624 DMA0_PADDR2 **/
union DMA0_PADDR2_REG{
	unsigned int reg;
	struct DMA0_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR2 (*((volatile union DMA0_PADDR2_REG *)0x40001624))
// model

/** 0x4000 1628 DMA0_PADDR3 **/
union DMA0_PADDR3_REG{
	unsigned int reg;
	struct DMA0_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR3 (*((volatile union DMA0_PADDR3_REG *)0x40001628))
// model

/** 0x4000 162C DMA0_PADDR4 **/
union DMA0_PADDR4_REG{
	unsigned int reg;
	struct DMA0_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR4 (*((volatile union DMA0_PADDR4_REG *)0x4000162C))
// model

/** 0x4000 1630 DMA0_PADDR5 **/
union DMA0_PADDR5_REG{
	unsigned int reg;
	struct DMA0_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR5 (*((volatile union DMA0_PADDR5_REG *)0x40001630))
// model

/** 0x4000 1634 DMA0_PADDR6 **/
union DMA0_PADDR6_REG{
	unsigned int reg;
	struct DMA0_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR6 (*((volatile union DMA0_PADDR6_REG *)0x40001634))
// model

/** 0x4000 1638 DMA0_PADDR7 **/
union DMA0_PADDR7_REG{
	unsigned int reg;
	struct DMA0_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR7 (*((volatile union DMA0_PADDR7_REG *)0x40001638))
// model

/** 0x4000 1640 DMA0_MADDR1 **/
union DMA0_MADDR1_REG{
	unsigned int reg;
	struct DMA0_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR1 (*((volatile union DMA0_MADDR1_REG *)0x40001640))
// model

/** 0x4000 1644 DMA0_MADDR2 **/
union DMA0_MADDR2_REG{
	unsigned int reg;
	struct DMA0_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR2 (*((volatile union DMA0_MADDR2_REG *)0x40001644))
// model

/** 0x4000 1648 DMA0_MADDR3 **/
union DMA0_MADDR3_REG{
	unsigned int reg;
	struct DMA0_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR3 (*((volatile union DMA0_MADDR3_REG *)0x40001648))
// model

/** 0x4000 164C DMA0_MADDR4 **/
union DMA0_MADDR4_REG{
	unsigned int reg;
	struct DMA0_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR4 (*((volatile union DMA0_MADDR4_REG *)0x4000164C))
// model

/** 0x4000 1650 DMA0_MADDR5 **/
union DMA0_MADDR5_REG{
	unsigned int reg;
	struct DMA0_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR5 (*((volatile union DMA0_MADDR5_REG *)0x40001650))
// model

/** 0x4000 1654 DMA0_MADDR6 **/
union DMA0_MADDR6_REG{
	unsigned int reg;
	struct DMA0_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR6 (*((volatile union DMA0_MADDR6_REG *)0x40001654))
// model

/** 0x4000 1658 DMA0_MADDR7 **/
union DMA0_MADDR7_REG{
	unsigned int reg;
	struct DMA0_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR7 (*((volatile union DMA0_MADDR7_REG *)0x40001658))
// model

/** 0x4000 1660 DMA0_CPAR1 **/
union DMA0_CPAR1_REG{
	unsigned int reg;
	struct DMA0_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR1 (*((volatile union DMA0_CPAR1_REG *)0x40001660))
// model

/** 0x4000 1664 DMA0_CPAR2 **/
union DMA0_CPAR2_REG{
	unsigned int reg;
	struct DMA0_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR2 (*((volatile union DMA0_CPAR2_REG *)0x40001664))
// model

/** 0x4000 1668 DMA0_CPAR3 **/
union DMA0_CPAR3_REG{
	unsigned int reg;
	struct DMA0_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR3 (*((volatile union DMA0_CPAR3_REG *)0x40001668))
// model

/** 0x4000 166C DMA0_CPAR4 **/
union DMA0_CPAR4_REG{
	unsigned int reg;
	struct DMA0_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR4 (*((volatile union DMA0_CPAR4_REG *)0x4000166C))
// model

/** 0x4000 1670 DMA0_CPAR5 **/
union DMA0_CPAR5_REG{
	unsigned int reg;
	struct DMA0_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR5 (*((volatile union DMA0_CPAR5_REG *)0x40001670))
// model

/** 0x4000 1674 DMA0_CPAR6 **/
union DMA0_CPAR6_REG{
	unsigned int reg;
	struct DMA0_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR6 (*((volatile union DMA0_CPAR6_REG *)0x40001674))
// model

/** 0x4000 1678 DMA0_CPAR7 **/
union DMA0_CPAR7_REG{
	unsigned int reg;
	struct DMA0_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR7 (*((volatile union DMA0_CPAR7_REG *)0x40001678))
// model

/** 0x4000 1680 DMA0_CMAR1 **/
union DMA0_CMAR1_REG{
	unsigned int reg;
	struct DMA0_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR1 (*((volatile union DMA0_CMAR1_REG *)0x40001680))
// model

/** 0x4000 1684 DMA0_CMAR2 **/
union DMA0_CMAR2_REG{
	unsigned int reg;
	struct DMA0_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR2 (*((volatile union DMA0_CMAR2_REG *)0x40001684))
// model

/** 0x4000 1688 DMA0_CMAR3 **/
union DMA0_CMAR3_REG{
	unsigned int reg;
	struct DMA0_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR3 (*((volatile union DMA0_CMAR3_REG *)0x40001688))
// model

/** 0x4000 168C DMA0_CMAR4 **/
union DMA0_CMAR4_REG{
	unsigned int reg;
	struct DMA0_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR4 (*((volatile union DMA0_CMAR4_REG *)0x4000168C))
// model

/** 0x4000 1690 DMA0_CMAR5 **/
union DMA0_CMAR5_REG{
	unsigned int reg;
	struct DMA0_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR5 (*((volatile union DMA0_CMAR5_REG *)0x40001690))
// model

/** 0x4000 1694 DMA0_CMAR6 **/
union DMA0_CMAR6_REG{
	unsigned int reg;
	struct DMA0_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR6 (*((volatile union DMA0_CMAR6_REG *)0x40001694))
// model

/** 0x4000 1698 DMA0_CMAR7 **/
union DMA0_CMAR7_REG{
	unsigned int reg;
	struct DMA0_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR7 (*((volatile union DMA0_CMAR7_REG *)0x40001698))
// model

/** 0x4000 16A0 DMA0_NCT1 **/
union DMA0_NCT1_REG{
	unsigned int reg;
	struct DMA0_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT1 (*((volatile union DMA0_NCT1_REG *)0x400016A0))
// model

/** 0x4000 16A4 DMA0_NCT2 **/
union DMA0_NCT2_REG{
	unsigned int reg;
	struct DMA0_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT2 (*((volatile union DMA0_NCT2_REG *)0x400016A4))
// model

/** 0x4000 16A8 DMA0_NCT3 **/
union DMA0_NCT3_REG{
	unsigned int reg;
	struct DMA0_NCT3_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT3 (*((volatile union DMA0_NCT3_REG *)0x400016A8))
// model

/** 0x4000 16AC DMA0_NCT4 **/
union DMA0_NCT4_REG{
	unsigned int reg;
	struct DMA0_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT4 (*((volatile union DMA0_NCT4_REG *)0x400016AC))
// model

/** 0x4000 16B0 DMA0_NCT5 **/
union DMA0_NCT5_REG{
	unsigned int reg;
	struct DMA0_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT5 (*((volatile union DMA0_NCT5_REG *)0x400016B0))
// model

/** 0x4000 16B4 DMA0_NCT6 **/
union DMA0_NCT6_REG{
	unsigned int reg;
	struct DMA0_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT6 (*((volatile union DMA0_NCT6_REG *)0x400016B4))
// model

/** 0x4000 16B8 DMA0_NCT7 **/
union DMA0_NCT7_REG{
	unsigned int reg;
	struct DMA0_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT7 (*((volatile union DMA0_NCT7_REG *)0x400016B8))
// model

/** 0x4000 16C0 DMA0_LIFR **/
union DMA0_LIFR_REG{
	unsigned int reg;
	struct DMA0_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_LIFR (*((volatile union DMA0_LIFR_REG *)0x400016C0))
// model

/** 0x4000 16C4 DMA0_LIER **/
union DMA0_LIER_REG{
	unsigned int reg;
	struct DMA0_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIE7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_LIER (*((volatile union DMA0_LIER_REG *)0x400016C4))
// modelDMA1

/** 0x4000 1700 DMA1_CTLR1 **/
union DMA1_CTLR1_REG{
	unsigned int reg;
	struct DMA1_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR1 (*((volatile union DMA1_CTLR1_REG *)0x40001700))
// model

/** 0x4000 1704 DMA1_CTLR2 **/
union DMA1_CTLR2_REG{
	unsigned int reg;
	struct DMA1_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR2 (*((volatile union DMA1_CTLR2_REG *)0x40001704))
// model

/** 0x4000 1708 DMA1_CTLR3 **/
union DMA1_CTLR3_REG{
	unsigned int reg;
	struct DMA1_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR3 (*((volatile union DMA1_CTLR3_REG *)0x40001708))
// model

/** 0x4000 170C DMA1_CTLR4 **/
union DMA1_CTLR4_REG{
	unsigned int reg;
	struct DMA1_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR4 (*((volatile union DMA1_CTLR4_REG *)0x4000170C))
// model

/** 0x4000 1710 DMA1_CTLR5 **/
union DMA1_CTLR5_REG{
	unsigned int reg;
	struct DMA1_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR5 (*((volatile union DMA1_CTLR5_REG *)0x40001710))
// model

/** 0x4000 1714 DMA1_CTLR6 **/
union DMA1_CTLR6_REG{
	unsigned int reg;
	struct DMA1_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR6 (*((volatile union DMA1_CTLR6_REG *)0x40001714))
// model

/** 0x4000 1718 DMA1_CTLR7 **/
union DMA1_CTLR7_REG{
	unsigned int reg;
	struct DMA1_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int :2;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int :1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR7 (*((volatile union DMA1_CTLR7_REG *)0x40001718))
// model

/** 0x4000 1720 DMA1_PADDR1 **/
union DMA1_PADDR1_REG{
	unsigned int reg;
	struct DMA1_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR1 (*((volatile union DMA1_PADDR1_REG *)0x40001720))
// model

/** 0x4000 1724 DMA1_PADDR2 **/
union DMA1_PADDR2_REG{
	unsigned int reg;
	struct DMA1_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR2 (*((volatile union DMA1_PADDR2_REG *)0x40001724))
// model

/** 0x4000 1728 DMA1_PADDR3 **/
union DMA1_PADDR3_REG{
	unsigned int reg;
	struct DMA1_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR3 (*((volatile union DMA1_PADDR3_REG *)0x40001728))
// model

/** 0x4000 172C DMA1_PADDR4 **/
union DMA1_PADDR4_REG{
	unsigned int reg;
	struct DMA1_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR4 (*((volatile union DMA1_PADDR4_REG *)0x4000172C))
// model

/** 0x4000 1730 DMA1_PADDR5 **/
union DMA1_PADDR5_REG{
	unsigned int reg;
	struct DMA1_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR5 (*((volatile union DMA1_PADDR5_REG *)0x40001730))
// model

/** 0x4000 1734 DMA1_PADDR6 **/
union DMA1_PADDR6_REG{
	unsigned int reg;
	struct DMA1_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR6 (*((volatile union DMA1_PADDR6_REG *)0x40001734))
// model

/** 0x4000 1738 DMA1_PADDR7 **/
union DMA1_PADDR7_REG{
	unsigned int reg;
	struct DMA1_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR7 (*((volatile union DMA1_PADDR7_REG *)0x40001738))
// model

/** 0x4000 1740 DMA1_MADDR1 **/
union DMA1_MADDR1_REG{
	unsigned int reg;
	struct DMA1_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR1 (*((volatile union DMA1_MADDR1_REG *)0x40001740))
// model

/** 0x4000 1744 DMA1_MADDR2 **/
union DMA1_MADDR2_REG{
	unsigned int reg;
	struct DMA1_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR2 (*((volatile union DMA1_MADDR2_REG *)0x40001744))
// model

/** 0x4000 1748 DMA1_MADDR3 **/
union DMA1_MADDR3_REG{
	unsigned int reg;
	struct DMA1_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR3 (*((volatile union DMA1_MADDR3_REG *)0x40001748))
// model

/** 0x4000 174C DMA1_MADDR4 **/
union DMA1_MADDR4_REG{
	unsigned int reg;
	struct DMA1_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR4 (*((volatile union DMA1_MADDR4_REG *)0x4000174C))
// model

/** 0x4000 1750 DMA1_MADDR5 **/
union DMA1_MADDR5_REG{
	unsigned int reg;
	struct DMA1_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR5 (*((volatile union DMA1_MADDR5_REG *)0x40001750))
// model

/** 0x4000 1754 DMA1_MADDR6 **/
union DMA1_MADDR6_REG{
	unsigned int reg;
	struct DMA1_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR6 (*((volatile union DMA1_MADDR6_REG *)0x40001754))
// model

/** 0x4000 1758 DMA1_MADDR7 **/
union DMA1_MADDR7_REG{
	unsigned int reg;
	struct DMA1_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR7 (*((volatile union DMA1_MADDR7_REG *)0x40001758))
// model

/** 0x4000 1760 DMA1_CPAR1 **/
union DMA1_CPAR1_REG{
	unsigned int reg;
	struct DMA1_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR1 (*((volatile union DMA1_CPAR1_REG *)0x40001760))
// model

/** 0x4000 1764 DMA1_CPAR2 **/
union DMA1_CPAR2_REG{
	unsigned int reg;
	struct DMA1_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR2 (*((volatile union DMA1_CPAR2_REG *)0x40001764))
// model

/** 0x4000 1768 DMA1_CPAR3 **/
union DMA1_CPAR3_REG{
	unsigned int reg;
	struct DMA1_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR3 (*((volatile union DMA1_CPAR3_REG *)0x40001768))
// model

/** 0x4000 176C DMA1_CPAR4 **/
union DMA1_CPAR4_REG{
	unsigned int reg;
	struct DMA1_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR4 (*((volatile union DMA1_CPAR4_REG *)0x4000176C))
// model

/** 0x4000 1770 DMA1_CPAR5 **/
union DMA1_CPAR5_REG{
	unsigned int reg;
	struct DMA1_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR5 (*((volatile union DMA1_CPAR5_REG *)0x40001770))
// model

/** 0x4000 1774 DMA1_CPAR6 **/
union DMA1_CPAR6_REG{
	unsigned int reg;
	struct DMA1_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR6 (*((volatile union DMA1_CPAR6_REG *)0x40001774))
// model

/** 0x4000 1778 DMA1_CPAR7 **/
union DMA1_CPAR7_REG{
	unsigned int reg;
	struct DMA1_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR7 (*((volatile union DMA1_CPAR7_REG *)0x40001778))
// model

/** 0x4000 1780 DMA1_CMAR1 **/
union DMA1_CMAR1_REG{
	unsigned int reg;
	struct DMA1_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR1 (*((volatile union DMA1_CMAR1_REG *)0x40001780))
// model

/** 0x4000 1784 DMA1_CMAR2 **/
union DMA1_CMAR2_REG{
	unsigned int reg;
	struct DMA1_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR2 (*((volatile union DMA1_CMAR2_REG *)0x40001784))
// model

/** 0x4000 1788 DMA1_CMAR3 **/
union DMA1_CMAR3_REG{
	unsigned int reg;
	struct DMA1_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR3 (*((volatile union DMA1_CMAR3_REG *)0x40001788))
// model

/** 0x4000 178C DMA1_CMAR4 **/
union DMA1_CMAR4_REG{
	unsigned int reg;
	struct DMA1_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR4 (*((volatile union DMA1_CMAR4_REG *)0x4000178C))
// model

/** 0x4000 1790 DMA1_CMAR5 **/
union DMA1_CMAR5_REG{
	unsigned int reg;
	struct DMA1_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR5 (*((volatile union DMA1_CMAR5_REG *)0x40001790))
// model

/** 0x4000 1794 DMA1_CMAR6 **/
union DMA1_CMAR6_REG{
	unsigned int reg;
	struct DMA1_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR6 (*((volatile union DMA1_CMAR6_REG *)0x40001794))
// model

/** 0x4000 1798 DMA1_CMAR7 **/
union DMA1_CMAR7_REG{
	unsigned int reg;
	struct DMA1_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR7 (*((volatile union DMA1_CMAR7_REG *)0x40001798))
// model

/** 0x4000 17A0 DMA1_NCT1 **/
union DMA1_NCT1_REG{
	unsigned int reg;
	struct DMA1_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT1 (*((volatile union DMA1_NCT1_REG *)0x400017A0))
// model

/** 0x4000 17A4 DMA1_NCT2 **/
union DMA1_NCT2_REG{
	unsigned int reg;
	struct DMA1_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT2 (*((volatile union DMA1_NCT2_REG *)0x400017A4))
// model

/** 0x4000 17A8 DMA1_NCT13 **/
union DMA1_NCT13_REG{
	unsigned int reg;
	struct DMA1_NCT13_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT13 (*((volatile union DMA1_NCT13_REG *)0x400017A8))
// model

/** 0x4000 17AC DMA1_NCT4 **/
union DMA1_NCT4_REG{
	unsigned int reg;
	struct DMA1_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT4 (*((volatile union DMA1_NCT4_REG *)0x400017AC))
// model

/** 0x4000 17B0 DMA1_NCT5 **/
union DMA1_NCT5_REG{
	unsigned int reg;
	struct DMA1_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT5 (*((volatile union DMA1_NCT5_REG *)0x400017B0))
// model

/** 0x4000 17B4 DMA1_NCT6 **/
union DMA1_NCT6_REG{
	unsigned int reg;
	struct DMA1_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT6 (*((volatile union DMA1_NCT6_REG *)0x400017B4))
// model

/** 0x4000 17B8 DMA1_NCT7 **/
union DMA1_NCT7_REG{
	unsigned int reg;
	struct DMA1_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT7 (*((volatile union DMA1_NCT7_REG *)0x400017B8))
// model

/** 0x4000 17C0 DMA1_LIFR **/
union DMA1_LIFR_REG{
	unsigned int reg;
	struct DMA1_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_LIFR (*((volatile union DMA1_LIFR_REG *)0x400017C0))
// model

/** 0x4000 17C4 DMA1_LIER **/
union DMA1_LIER_REG{
	unsigned int reg;
	struct DMA1_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_LIER (*((volatile union DMA1_LIER_REG *)0x400017C4))
// modelT14

/** 0x4000 1800 T14_CNT **/
union T14_CNT_REG{
	unsigned int reg;
	struct T14_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CNT (*((volatile union T14_CNT_REG *)0x40001800))
// model

/** 0x4000 1804 T14_CTL1 **/
union T14_CTL1_REG{
	unsigned int reg;
	struct T14_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL1 (*((volatile union T14_CTL1_REG *)0x40001804))
// model

/** 0x4000 1808 T14_CTL2 **/
union T14_CTL2_REG{
	unsigned int reg;
	struct T14_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:2;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _PXSPMST:1;
		unsigned int _PXSPM:1;
		unsigned int _TXTRG:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL2 (*((volatile union T14_CTL2_REG *)0x40001808))
// model

/** 0x4000 180C T14_PRSC **/
union T14_PRSC_REG{
	unsigned int reg;
	struct T14_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PRSC (*((volatile union T14_PRSC_REG *)0x4000180C))
// model

/** 0x4000 1810 T14_PPX **/
union T14_PPX_REG{
	unsigned int reg;
	struct T14_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PPX (*((volatile union T14_PPX_REG *)0x40001810))
// model

/** 0x4000 1814 T14_DIER **/
union T14_DIER_REG{
	unsigned int reg;
	struct T14_DIER_BITS{
		unsigned int _TXUIE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXTDE:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_DIER (*((volatile union T14_DIER_REG *)0x40001814))
// model

/** 0x4000 1818 T14_SR **/
union T14_SR_REG{
	unsigned int reg;
	struct T14_SR_BITS{
		unsigned int _TXUIF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXTDF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_SR (*((volatile union T14_SR_REG *)0x40001818))
// model

/** 0x4000 181C T14_SRIC **/
union T14_SRIC_REG{
	unsigned int reg;
	struct T14_SRIC_BITS{
		unsigned int _TXUIC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXIC:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_SRIC (*((volatile union T14_SRIC_REG *)0x4000181C))
// modelT15

/** 0x4000 1880 T15_CNT **/
union T15_CNT_REG{
	unsigned int reg;
	struct T15_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_CNT (*((volatile union T15_CNT_REG *)0x40001880))
// model

/** 0x4000 1884 T15_CTL1 **/
union T15_CTL1_REG{
	unsigned int reg;
	struct T15_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_CTL1 (*((volatile union T15_CTL1_REG *)0x40001884))
// model

/** 0x4000 1888 T15_CTL2 **/
union T15_CTL2_REG{
	unsigned int reg;
	struct T15_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:2;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _PXSPMST:1;
		unsigned int _PXSPM:1;
		unsigned int _TXTRG:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_CTL2 (*((volatile union T15_CTL2_REG *)0x40001888))
// model

/** 0x4000 188C T15_PRSC **/
union T15_PRSC_REG{
	unsigned int reg;
	struct T15_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_PRSC (*((volatile union T15_PRSC_REG *)0x4000188C))
// model

/** 0x4000 1890 T15_PPX **/
union T15_PPX_REG{
	unsigned int reg;
	struct T15_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_PPX (*((volatile union T15_PPX_REG *)0x40001890))
// model

/** 0x4000 1894 T15_DIER **/
union T15_DIER_REG{
	unsigned int reg;
	struct T15_DIER_BITS{
		unsigned int _TXUIE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXTDE:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_DIER (*((volatile union T15_DIER_REG *)0x40001894))
// model

/** 0x4000 1898 T15_SR **/
union T15_SR_REG{
	unsigned int reg;
	struct T15_SR_BITS{
		unsigned int _TXUIF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXTDF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_SR (*((volatile union T15_SR_REG *)0x40001898))
// model

/** 0x4000 189C T15_SRIC **/
union T15_SRIC_REG{
	unsigned int reg;
	struct T15_SRIC_BITS{
		unsigned int _TXUIC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXIC:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T15_SRIC (*((volatile union T15_SRIC_REG *)0x4000189C))
// modelCAN2

/** 0x4000 1900 CAN2_CTLR **/
union CAN2_CTLR_REG{
	unsigned int reg;
	struct CAN2_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int :1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int :4;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_CTLR (*((volatile union CAN2_CTLR_REG *)0x40001900))
// model

/** 0x4000 1904 CAN2_BRGR **/
union CAN2_BRGR_REG{
	unsigned int reg;
	struct CAN2_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_BRGR (*((volatile union CAN2_BRGR_REG *)0x40001904))
// model

/** 0x4000 1908 CAN2_RCR **/
union CAN2_RCR_REG{
	unsigned int reg;
	struct CAN2_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_RCR (*((volatile union CAN2_RCR_REG *)0x40001908))
// model

/** 0x4000 190C CAN2_EROR **/
union CAN2_EROR_REG{
	unsigned int reg;
	struct CAN2_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_EROR (*((volatile union CAN2_EROR_REG *)0x4000190C))
// model

/** 0x4000 1910 CAN2_ACRR **/
union CAN2_ACRR_REG{
	unsigned int reg;
	struct CAN2_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_ACRR (*((volatile union CAN2_ACRR_REG *)0x40001910))
// model

/** 0x4000 1914 CAN2_MSKR **/
union CAN2_MSKR_REG{
	unsigned int reg;
	struct CAN2_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_MSKR (*((volatile union CAN2_MSKR_REG *)0x40001914))
// model

/** 0x4000 1918 CAN2_IER **/
union CAN2_IER_REG{
	unsigned int reg;
	struct CAN2_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int :8;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_IER (*((volatile union CAN2_IER_REG *)0x40001918))
// model

/** 0x4000 191C CAN2_IFR **/
union CAN2_IFR_REG{
	unsigned int reg;
	struct CAN2_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_IFR (*((volatile union CAN2_IFR_REG *)0x4000191C))
// model

/** 0x4000 1920 CAN2_INFR **/
union CAN2_INFR_REG{
	unsigned int reg;
	struct CAN2_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_INFR (*((volatile union CAN2_INFR_REG *)0x40001920))
// model

/** 0x4000 1924 CAN2_TX0R **/
union CAN2_TX0R_REG{
	unsigned int reg;
	struct CAN2_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_TX0R (*((volatile union CAN2_TX0R_REG *)0x40001924))
// model

/** 0x4000 1928 CAN2_TX1R **/
union CAN2_TX1R_REG{
	unsigned int reg;
	struct CAN2_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_TX1R (*((volatile union CAN2_TX1R_REG *)0x40001928))
// model

/** 0x4000 192C CAN2_TX2R **/
union CAN2_TX2R_REG{
	unsigned int reg;
	struct CAN2_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_TX2R (*((volatile union CAN2_TX2R_REG *)0x4000192C))
// model

/** 0x4000 1930 CAN2_RXDATA0 **/
union CAN2_RXDATA0_REG{
	unsigned int reg;
	struct CAN2_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_RXDATA0 (*((volatile union CAN2_RXDATA0_REG *)0x40001930))
// model

/** 0x4000 1934 CAN2_RXDATA1 **/
union CAN2_RXDATA1_REG{
	unsigned int reg;
	struct CAN2_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_RXDATA1 (*((volatile union CAN2_RXDATA1_REG *)0x40001934))
// model

/** 0x4000 1938 CAN2_RXDATA2 **/
union CAN2_RXDATA2_REG{
	unsigned int reg;
	struct CAN2_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_RXDATA2 (*((volatile union CAN2_RXDATA2_REG *)0x40001938))
// model

/** 0x4000 193C CAN2_RXDATA3 **/
union CAN2_RXDATA3_REG{
	unsigned int reg;
	struct CAN2_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN2_RXDATA3 (*((volatile union CAN2_RXDATA3_REG *)0x4000193C))
// modelCAN3

/** 0x4000 1980 CAN3_CTLR **/
union CAN3_CTLR_REG{
	unsigned int reg;
	struct CAN3_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int :1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int :4;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_CTLR (*((volatile union CAN3_CTLR_REG *)0x40001980))
// model

/** 0x4000 1984 CAN3_BRGR **/
union CAN3_BRGR_REG{
	unsigned int reg;
	struct CAN3_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_BRGR (*((volatile union CAN3_BRGR_REG *)0x40001984))
// model

/** 0x4000 1988 CAN3_RCR **/
union CAN3_RCR_REG{
	unsigned int reg;
	struct CAN3_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_RCR (*((volatile union CAN3_RCR_REG *)0x40001988))
// model

/** 0x4000 198C CAN3_EROR **/
union CAN3_EROR_REG{
	unsigned int reg;
	struct CAN3_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_EROR (*((volatile union CAN3_EROR_REG *)0x4000198C))
// model

/** 0x4000 1990 CAN3_ACRR **/
union CAN3_ACRR_REG{
	unsigned int reg;
	struct CAN3_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_ACRR (*((volatile union CAN3_ACRR_REG *)0x40001990))
// model

/** 0x4000 1994 CAN3_MSKR **/
union CAN3_MSKR_REG{
	unsigned int reg;
	struct CAN3_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_MSKR (*((volatile union CAN3_MSKR_REG *)0x40001994))
// model

/** 0x4000 1998 CAN3_IER **/
union CAN3_IER_REG{
	unsigned int reg;
	struct CAN3_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int :8;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_IER (*((volatile union CAN3_IER_REG *)0x40001998))
// model

/** 0x4000 199C CAN3_IFR **/
union CAN3_IFR_REG{
	unsigned int reg;
	struct CAN3_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_IFR (*((volatile union CAN3_IFR_REG *)0x4000199C))
// model

/** 0x4000 19A0 CAN3_INFR **/
union CAN3_INFR_REG{
	unsigned int reg;
	struct CAN3_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_INFR (*((volatile union CAN3_INFR_REG *)0x400019A0))
// model

/** 0x4000 19A4 CAN3_TX0R **/
union CAN3_TX0R_REG{
	unsigned int reg;
	struct CAN3_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_TX0R (*((volatile union CAN3_TX0R_REG *)0x400019A4))
// model

/** 0x4000 19A8 CAN3_TX1R **/
union CAN3_TX1R_REG{
	unsigned int reg;
	struct CAN3_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_TX1R (*((volatile union CAN3_TX1R_REG *)0x400019A8))
// model

/** 0x4000 19AC CAN3_TX2R **/
union CAN3_TX2R_REG{
	unsigned int reg;
	struct CAN3_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_TX2R (*((volatile union CAN3_TX2R_REG *)0x400019AC))
// model

/** 0x4000 19B0 CAN3_RXDATA0 **/
union CAN3_RXDATA0_REG{
	unsigned int reg;
	struct CAN3_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_RXDATA0 (*((volatile union CAN3_RXDATA0_REG *)0x400019B0))
// model

/** 0x4000 19B4 CAN3_RXDATA1 **/
union CAN3_RXDATA1_REG{
	unsigned int reg;
	struct CAN3_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_RXDATA1 (*((volatile union CAN3_RXDATA1_REG *)0x400019B4))
// model

/** 0x4000 19B8 CAN3_RXDATA2 **/
union CAN3_RXDATA2_REG{
	unsigned int reg;
	struct CAN3_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_RXDATA2 (*((volatile union CAN3_RXDATA2_REG *)0x400019B8))
// model

/** 0x4000 19BC CAN3_RXDATA3 **/
union CAN3_RXDATA3_REG{
	unsigned int reg;
	struct CAN3_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN3_RXDATA3 (*((volatile union CAN3_RXDATA3_REG *)0x400019BC))
// modelT18

/** 0x4000 1A80 T18_CNT **/
union T18_CNT_REG{
	unsigned int reg;
	struct T18_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CNT (*((volatile union T18_CNT_REG *)0x40001A80))
// model

/** 0x4000 1A84 T18_CTL1 **/
union T18_CTL1_REG{
	unsigned int reg;
	struct T18_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CTL1 (*((volatile union T18_CTL1_REG *)0x40001A84))
// model

/** 0x4000 1A88 T18_CTL2 **/
union T18_CTL2_REG{
	unsigned int reg;
	struct T18_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CTL2 (*((volatile union T18_CTL2_REG *)0x40001A88))
// model

/** 0x4000 1A8C T18_PRSC **/
union T18_PRSC_REG{
	unsigned int reg;
	struct T18_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_PRSC (*((volatile union T18_PRSC_REG *)0x40001A8C))
// model

/** 0x4000 1A90 T18_PPX **/
union T18_PPX_REG{
	unsigned int reg;
	struct T18_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_PPX (*((volatile union T18_PPX_REG *)0x40001A90))
// model

/** 0x4000 1A94 T18_UDTIMx **/
union T18_UDTIMx_REG{
	unsigned int reg;
	struct T18_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_UDTIMx (*((volatile union T18_UDTIMx_REG *)0x40001A94))
// modelCCP18

/** 0x4000 1AA0 CCP18_C1 **/
union CCP18_C1_REG{
	unsigned int reg;
	struct CCP18_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C1 (*((volatile union CCP18_C1_REG *)0x40001AA0))
// model

/** 0x4000 1AA4 CCP18_C2 **/
union CCP18_C2_REG{
	unsigned int reg;
	struct CCP18_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C2 (*((volatile union CCP18_C2_REG *)0x40001AA4))
// model

/** 0x4000 1AA8 CCP18_C3 **/
union CCP18_C3_REG{
	unsigned int reg;
	struct CCP18_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C3 (*((volatile union CCP18_C3_REG *)0x40001AA8))
// model

/** 0x4000 1AAC CCP18_C4 **/
union CCP18_C4_REG{
	unsigned int reg;
	struct CCP18_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C4 (*((volatile union CCP18_C4_REG *)0x40001AAC))
// model

/** 0x4000 1AB0 CCP18_SRIC **/
union CCP18_SRIC_REG{
	unsigned int reg;
	struct CCP18_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_SRIC (*((volatile union CCP18_SRIC_REG *)0x40001AB0))
// model

/** 0x4000 1AB4 CCP18_DF **/
union CCP18_DF_REG{
	unsigned int reg;
	struct CCP18_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_DF (*((volatile union CCP18_DF_REG *)0x40001AB4))
// model

/** 0x4000 1AC0 CCP18_CTL1 **/
union CCP18_CTL1_REG{
	unsigned int reg;
	struct CCP18_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL1 (*((volatile union CCP18_CTL1_REG *)0x40001AC0))
// model

/** 0x4000 1AC4 CCP18_R1 **/
union CCP18_R1_REG{
	unsigned int reg;
	struct CCP18_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R1 (*((volatile union CCP18_R1_REG *)0x40001AC4))
// model

/** 0x4000 1AC8 CCP18_R2 **/
union CCP18_R2_REG{
	unsigned int reg;
	struct CCP18_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R2 (*((volatile union CCP18_R2_REG *)0x40001AC8))
// model

/** 0x4000 1ACC CCP18_R3 **/
union CCP18_R3_REG{
	unsigned int reg;
	struct CCP18_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R3 (*((volatile union CCP18_R3_REG *)0x40001ACC))
// model

/** 0x4000 1AD0 CCP18_R4 **/
union CCP18_R4_REG{
	unsigned int reg;
	struct CCP18_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R4 (*((volatile union CCP18_R4_REG *)0x40001AD0))
// model

/** 0x4000 1AD4 CCP18_CTL2 **/
union CCP18_CTL2_REG{
	unsigned int reg;
	struct CCP18_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL2 (*((volatile union CCP18_CTL2_REG *)0x40001AD4))
// model

/** 0x4000 1AD8 CCP18_CTL3 **/
union CCP18_CTL3_REG{
	unsigned int reg;
	struct CCP18_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL3 (*((volatile union CCP18_CTL3_REG *)0x40001AD8))
// model

/** 0x4000 1ADC CCP18_EGIF **/
union CCP18_EGIF_REG{
	unsigned int reg;
	struct CCP18_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_EGIF (*((volatile union CCP18_EGIF_REG *)0x40001ADC))
// modelT19

/** 0x4000 1B00 T19_CNT **/
union T19_CNT_REG{
	unsigned int reg;
	struct T19_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CNT (*((volatile union T19_CNT_REG *)0x40001B00))
// model

/** 0x4000 1B04 T19_CTL1 **/
union T19_CTL1_REG{
	unsigned int reg;
	struct T19_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CTL1 (*((volatile union T19_CTL1_REG *)0x40001B04))
// model

/** 0x4000 1B08 T19_CTL2 **/
union T19_CTL2_REG{
	unsigned int reg;
	struct T19_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CTL2 (*((volatile union T19_CTL2_REG *)0x40001B08))
// model

/** 0x4000 1B0C T19_PRSC **/
union T19_PRSC_REG{
	unsigned int reg;
	struct T19_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_PRSC (*((volatile union T19_PRSC_REG *)0x40001B0C))
// model

/** 0x4000 1B10 T19_PPX **/
union T19_PPX_REG{
	unsigned int reg;
	struct T19_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_PPX (*((volatile union T19_PPX_REG *)0x40001B10))
// model

/** 0x4000 1B14 T19_UDTIMx **/
union T19_UDTIMx_REG{
	unsigned int reg;
	struct T19_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_UDTIMx (*((volatile union T19_UDTIMx_REG *)0x40001B14))
// modelCCP19

/** 0x4000 1B20 CCP19_C1 **/
union CCP19_C1_REG{
	unsigned int reg;
	struct CCP19_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C1 (*((volatile union CCP19_C1_REG *)0x40001B20))
// model

/** 0x4000 1B24 CCP19_C2 **/
union CCP19_C2_REG{
	unsigned int reg;
	struct CCP19_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C2 (*((volatile union CCP19_C2_REG *)0x40001B24))
// model

/** 0x4000 1B28 CCP19_C3 **/
union CCP19_C3_REG{
	unsigned int reg;
	struct CCP19_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C3 (*((volatile union CCP19_C3_REG *)0x40001B28))
// model

/** 0x4000 1B2C CCP19_C4 **/
union CCP19_C4_REG{
	unsigned int reg;
	struct CCP19_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C4 (*((volatile union CCP19_C4_REG *)0x40001B2C))
// model

/** 0x4000 1B30 CCP19_SRIC **/
union CCP19_SRIC_REG{
	unsigned int reg;
	struct CCP19_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_SRIC (*((volatile union CCP19_SRIC_REG *)0x40001B30))
// model

/** 0x4000 1B34 CCP19_DF **/
union CCP19_DF_REG{
	unsigned int reg;
	struct CCP19_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_DF (*((volatile union CCP19_DF_REG *)0x40001B34))
// model

/** 0x4000 1B40 CCP19_CTL1 **/
union CCP19_CTL1_REG{
	unsigned int reg;
	struct CCP19_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL1 (*((volatile union CCP19_CTL1_REG *)0x40001B40))
// model

/** 0x4000 1B44 CCP19_R1 **/
union CCP19_R1_REG{
	unsigned int reg;
	struct CCP19_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R1 (*((volatile union CCP19_R1_REG *)0x40001B44))
// model

/** 0x4000 1B48 CCP19_R2 **/
union CCP19_R2_REG{
	unsigned int reg;
	struct CCP19_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R2 (*((volatile union CCP19_R2_REG *)0x40001B48))
// model

/** 0x4000 1B4C CCP19_R3 **/
union CCP19_R3_REG{
	unsigned int reg;
	struct CCP19_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R3 (*((volatile union CCP19_R3_REG *)0x40001B4C))
// model

/** 0x4000 1B50 CCP19_R4 **/
union CCP19_R4_REG{
	unsigned int reg;
	struct CCP19_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R4 (*((volatile union CCP19_R4_REG *)0x40001B50))
// model

/** 0x4000 1B54 CCP19_CTL2 **/
union CCP19_CTL2_REG{
	unsigned int reg;
	struct CCP19_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL2 (*((volatile union CCP19_CTL2_REG *)0x40001B54))
// model

/** 0x4000 1B58 CCP19_CTL3 **/
union CCP19_CTL3_REG{
	unsigned int reg;
	struct CCP19_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL3 (*((volatile union CCP19_CTL3_REG *)0x40001B58))
// model

/** 0x4000 1B5C CCP19_EGIF **/
union CCP19_EGIF_REG{
	unsigned int reg;
	struct CCP19_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_EGIF (*((volatile union CCP19_EGIF_REG *)0x40001B5C))
// modelT20

/** 0x4000 1B80 T20_CNT **/
union T20_CNT_REG{
	unsigned int reg;
	struct T20_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_CNT (*((volatile union T20_CNT_REG *)0x40001B80))
// model

/** 0x4000 1B84 T20_CTL1 **/
union T20_CTL1_REG{
	unsigned int reg;
	struct T20_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_CTL1 (*((volatile union T20_CTL1_REG *)0x40001B84))
// model

/** 0x4000 1B88 T20_CTL2 **/
union T20_CTL2_REG{
	unsigned int reg;
	struct T20_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_CTL2 (*((volatile union T20_CTL2_REG *)0x40001B88))
// model

/** 0x4000 1B8C T20_PRSC **/
union T20_PRSC_REG{
	unsigned int reg;
	struct T20_PRSC_BITS{
		unsigned int _TXCKS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_PRSC (*((volatile union T20_PRSC_REG *)0x40001B8C))
// model

/** 0x4000 1B90 T20_PPX **/
union T20_PPX_REG{
	unsigned int reg;
	struct T20_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_PPX (*((volatile union T20_PPX_REG *)0x40001B90))
// model

/** 0x4000 1B94 T20_UDTIMx **/
union T20_UDTIMx_REG{
	unsigned int reg;
	struct T20_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_UDTIMx (*((volatile union T20_UDTIMx_REG *)0x40001B94))
// modelCCP20

/** 0x4000 1BA0 CCP20_C1 **/
union CCP20_C1_REG{
	unsigned int reg;
	struct CCP20_C1_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C1 (*((volatile union CCP20_C1_REG *)0x40001BA0))
// model

/** 0x4000 1BA4 CCP20_C2 **/
union CCP20_C2_REG{
	unsigned int reg;
	struct CCP20_C2_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C2 (*((volatile union CCP20_C2_REG *)0x40001BA4))
// model

/** 0x4000 1BA8 CCP20_C3 **/
union CCP20_C3_REG{
	unsigned int reg;
	struct CCP20_C3_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C3 (*((volatile union CCP20_C3_REG *)0x40001BA8))
// model

/** 0x4000 1BAC CCP20_C4 **/
union CCP20_C4_REG{
	unsigned int reg;
	struct CCP20_C4_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C4 (*((volatile union CCP20_C4_REG *)0x40001BAC))
// model

/** 0x4000 1BB0 CCP20_SRIC **/
union CCP20_SRIC_REG{
	unsigned int reg;
	struct CCP20_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_SRIC (*((volatile union CCP20_SRIC_REG *)0x40001BB0))
// model

/** 0x4000 1BB4 CCP20_DF **/
union CCP20_DF_REG{
	unsigned int reg;
	struct CCP20_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_DF (*((volatile union CCP20_DF_REG *)0x40001BB4))
// model

/** 0x4000 1BC0 CCP20_CTL1 **/
union CCP20_CTL1_REG{
	unsigned int reg;
	struct CCP20_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_CTL1 (*((volatile union CCP20_CTL1_REG *)0x40001BC0))
// model

/** 0x4000 1BC4 CCP20_R1 **/
union CCP20_R1_REG{
	unsigned int reg;
	struct CCP20_R1_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R1 (*((volatile union CCP20_R1_REG *)0x40001BC4))
// model

/** 0x4000 1BC8 CCP20_R2 **/
union CCP20_R2_REG{
	unsigned int reg;
	struct CCP20_R2_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R2 (*((volatile union CCP20_R2_REG *)0x40001BC8))
// model

/** 0x4000 1BCC CCP20_R3 **/
union CCP20_R3_REG{
	unsigned int reg;
	struct CCP20_R3_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R3 (*((volatile union CCP20_R3_REG *)0x40001BCC))
// model

/** 0x4000 1BD0 CCP20_R4 **/
union CCP20_R4_REG{
	unsigned int reg;
	struct CCP20_R4_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R4 (*((volatile union CCP20_R4_REG *)0x40001BD0))
// model

/** 0x4000 1BD4 CCP20_CTL2 **/
union CCP20_CTL2_REG{
	unsigned int reg;
	struct CCP20_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_CTL2 (*((volatile union CCP20_CTL2_REG *)0x40001BD4))
// model

/** 0x4000 1BD8 CCP20_CTL3 **/
union CCP20_CTL3_REG{
	unsigned int reg;
	struct CCP20_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_CTL3 (*((volatile union CCP20_CTL3_REG *)0x40001BD8))
// model

/** 0x4000 1BDC CCP20_EGIF **/
union CCP20_EGIF_REG{
	unsigned int reg;
	struct CCP20_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_EGIF (*((volatile union CCP20_EGIF_REG *)0x40001BDC))
// modelT21

/** 0x4000 1C00 T21_CNT **/
union T21_CNT_REG{
	unsigned int reg;
	struct T21_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CNT (*((volatile union T21_CNT_REG *)0x40001C00))
// model

/** 0x4000 1C04 T21_CTL1 **/
union T21_CTL1_REG{
	unsigned int reg;
	struct T21_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CTL1 (*((volatile union T21_CTL1_REG *)0x40001C04))
// model

/** 0x4000 1C08 T21_CTL2 **/
union T21_CTL2_REG{
	unsigned int reg;
	struct T21_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CTL2 (*((volatile union T21_CTL2_REG *)0x40001C08))
// model

/** 0x4000 1C0C T21_PRSC **/
union T21_PRSC_REG{
	unsigned int reg;
	struct T21_PRSC_BITS{
		unsigned int _TXCKS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_PRSC (*((volatile union T21_PRSC_REG *)0x40001C0C))
// model

/** 0x4000 1C10 T21_PPX **/
union T21_PPX_REG{
	unsigned int reg;
	struct T21_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_PPX (*((volatile union T21_PPX_REG *)0x40001C10))
// model

/** 0x4000 1C14 T21_UDTIMx **/
union T21_UDTIMx_REG{
	unsigned int reg;
	struct T21_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_UDTIMx (*((volatile union T21_UDTIMx_REG *)0x40001C14))
// modelCCP21

/** 0x4000 1C20 CCP21_C1 **/
union CCP21_C1_REG{
	unsigned int reg;
	struct CCP21_C1_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C1 (*((volatile union CCP21_C1_REG *)0x40001C20))
// model

/** 0x4000 1C24 CCP21_C2 **/
union CCP21_C2_REG{
	unsigned int reg;
	struct CCP21_C2_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C2 (*((volatile union CCP21_C2_REG *)0x40001C24))
// model

/** 0x4000 1C28 CCP21_C3 **/
union CCP21_C3_REG{
	unsigned int reg;
	struct CCP21_C3_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C3 (*((volatile union CCP21_C3_REG *)0x40001C28))
// model

/** 0x4000 1C2C CCP21_C4 **/
union CCP21_C4_REG{
	unsigned int reg;
	struct CCP21_C4_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C4 (*((volatile union CCP21_C4_REG *)0x40001C2C))
// model

/** 0x4000 1C30 CCP21_SRIC **/
union CCP21_SRIC_REG{
	unsigned int reg;
	struct CCP21_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_SRIC (*((volatile union CCP21_SRIC_REG *)0x40001C30))
// model

/** 0x4000 1C34 CCP21_DF **/
union CCP21_DF_REG{
	unsigned int reg;
	struct CCP21_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_DF (*((volatile union CCP21_DF_REG *)0x40001C34))
// model

/** 0x4000 1C40 CCP21_CTL1 **/
union CCP21_CTL1_REG{
	unsigned int reg;
	struct CCP21_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL1 (*((volatile union CCP21_CTL1_REG *)0x40001C40))
// model

/** 0x4000 1C44 CCP21_R1 **/
union CCP21_R1_REG{
	unsigned int reg;
	struct CCP21_R1_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R1 (*((volatile union CCP21_R1_REG *)0x40001C44))
// model

/** 0x4000 1C48 CCP21_R2 **/
union CCP21_R2_REG{
	unsigned int reg;
	struct CCP21_R2_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R2 (*((volatile union CCP21_R2_REG *)0x40001C48))
// model

/** 0x4000 1C4C CCP21_R3 **/
union CCP21_R3_REG{
	unsigned int reg;
	struct CCP21_R3_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R3 (*((volatile union CCP21_R3_REG *)0x40001C4C))
// model

/** 0x4000 1C50 CCP21_R4 **/
union CCP21_R4_REG{
	unsigned int reg;
	struct CCP21_R4_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R4 (*((volatile union CCP21_R4_REG *)0x40001C50))
// model

/** 0x4000 1C54 CCP21_CTL2 **/
union CCP21_CTL2_REG{
	unsigned int reg;
	struct CCP21_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL2 (*((volatile union CCP21_CTL2_REG *)0x40001C54))
// model

/** 0x4000 1C58 CCP21_CTL3 **/
union CCP21_CTL3_REG{
	unsigned int reg;
	struct CCP21_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL3 (*((volatile union CCP21_CTL3_REG *)0x40001C58))
// model

/** 0x4000 1C5C CCP21_EGIF **/
union CCP21_EGIF_REG{
	unsigned int reg;
	struct CCP21_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_EGIF (*((volatile union CCP21_EGIF_REG *)0x40001C5C))
// modelT22

/** 0x4000 1C80 T22_CNT **/
union T22_CNT_REG{
	unsigned int reg;
	struct T22_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_CNT (*((volatile union T22_CNT_REG *)0x40001C80))
// model

/** 0x4000 1C84 T22_CTL1 **/
union T22_CTL1_REG{
	unsigned int reg;
	struct T22_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK0:1;
		unsigned int _TXCLK1:1;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS0:1;
		unsigned int _TXCMS1:1;
		unsigned int _TXCMS2:1;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_CTL1 (*((volatile union T22_CTL1_REG *)0x40001C84))
// model

/** 0x4000 1C88 T22_CTL2 **/
union T22_CTL2_REG{
	unsigned int reg;
	struct T22_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_CTL2 (*((volatile union T22_CTL2_REG *)0x40001C88))
// model

/** 0x4000 1C8C T22_PRSC **/
union T22_PRSC_REG{
	unsigned int reg;
	struct T22_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_PRSC (*((volatile union T22_PRSC_REG *)0x40001C8C))
// model

/** 0x4000 1C90 T22_PPX **/
union T22_PPX_REG{
	unsigned int reg;
	struct T22_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_PPX (*((volatile union T22_PPX_REG *)0x40001C90))
// model

/** 0x4000 1C94 T22_UDTIMx **/
union T22_UDTIMx_REG{
	unsigned int reg;
	struct T22_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_UDTIMx (*((volatile union T22_UDTIMx_REG *)0x40001C94))
// modelCCP22

/** 0x4000 1CA0 CCP22_C1 **/
union CCP22_C1_REG{
	unsigned int reg;
	struct CCP22_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C1 (*((volatile union CCP22_C1_REG *)0x40001CA0))
// model

/** 0x4000 1CA4 CCP22_C2 **/
union CCP22_C2_REG{
	unsigned int reg;
	struct CCP22_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C2 (*((volatile union CCP22_C2_REG *)0x40001CA4))
// model

/** 0x4000 1CA8 CCP22_C3 **/
union CCP22_C3_REG{
	unsigned int reg;
	struct CCP22_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C3 (*((volatile union CCP22_C3_REG *)0x40001CA8))
// model

/** 0x4000 1CAC CCP22_C4 **/
union CCP22_C4_REG{
	unsigned int reg;
	struct CCP22_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C4 (*((volatile union CCP22_C4_REG *)0x40001CAC))
// model

/** 0x4000 1CB0 CCP22_SRIC **/
union CCP22_SRIC_REG{
	unsigned int reg;
	struct CCP22_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_SRIC (*((volatile union CCP22_SRIC_REG *)0x40001CB0))
// model

/** 0x4000 1CB4 CCP22_DF **/
union CCP22_DF_REG{
	unsigned int reg;
	struct CCP22_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_DF (*((volatile union CCP22_DF_REG *)0x40001CB4))
// model

/** 0x4000 1CC0 CCP22_CTL1 **/
union CCP22_CTL1_REG{
	unsigned int reg;
	struct CCP22_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_CTL1 (*((volatile union CCP22_CTL1_REG *)0x40001CC0))
// model

/** 0x4000 1CC4 CCP22_R1 **/
union CCP22_R1_REG{
	unsigned int reg;
	struct CCP22_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R1 (*((volatile union CCP22_R1_REG *)0x40001CC4))
// model

/** 0x4000 1CC8 CCP22_R2 **/
union CCP22_R2_REG{
	unsigned int reg;
	struct CCP22_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R2 (*((volatile union CCP22_R2_REG *)0x40001CC8))
// model

/** 0x4000 1CCC CCP22_R3 **/
union CCP22_R3_REG{
	unsigned int reg;
	struct CCP22_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R3 (*((volatile union CCP22_R3_REG *)0x40001CCC))
// model

/** 0x4000 1CD0 CCP22_R4 **/
union CCP22_R4_REG{
	unsigned int reg;
	struct CCP22_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R4 (*((volatile union CCP22_R4_REG *)0x40001CD0))
// model

/** 0x4000 1CD4 CCP22_CTL2 **/
union CCP22_CTL2_REG{
	unsigned int reg;
	struct CCP22_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS0:1;
		unsigned int _PXASS1:1;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_CTL2 (*((volatile union CCP22_CTL2_REG *)0x40001CD4))
// model

/** 0x4000 1CD8 CCP22_CTL3 **/
union CCP22_CTL3_REG{
	unsigned int reg;
	struct CCP22_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_CTL3 (*((volatile union CCP22_CTL3_REG *)0x40001CD8))
// model

/** 0x4000 1CDC CCP22_EGIF **/
union CCP22_EGIF_REG{
	unsigned int reg;
	struct CCP22_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_EGIF (*((volatile union CCP22_EGIF_REG *)0x40001CDC))
// modelT23

/** 0x4000 1D00 T23_CNT **/
union T23_CNT_REG{
	unsigned int reg;
	struct T23_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_CNT (*((volatile union T23_CNT_REG *)0x40001D00))
// model

/** 0x4000 1D04 T23_CTL1 **/
union T23_CTL1_REG{
	unsigned int reg;
	struct T23_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_CTL1 (*((volatile union T23_CTL1_REG *)0x40001D04))
// model

/** 0x4000 1D08 T23_CTL2 **/
union T23_CTL2_REG{
	unsigned int reg;
	struct T23_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_CTL2 (*((volatile union T23_CTL2_REG *)0x40001D08))
// model

/** 0x4000 1D0C T23_PRSC **/
union T23_PRSC_REG{
	unsigned int reg;
	struct T23_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_PRSC (*((volatile union T23_PRSC_REG *)0x40001D0C))
// model

/** 0x4000 1D10 T23_PPX **/
union T23_PPX_REG{
	unsigned int reg;
	struct T23_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_PPX (*((volatile union T23_PPX_REG *)0x40001D10))
// model

/** 0x4000 1D14 T23_UDTIMx **/
union T23_UDTIMx_REG{
	unsigned int reg;
	struct T23_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_UDTIMx (*((volatile union T23_UDTIMx_REG *)0x40001D14))
// modelCCP23

/** 0x4000 1D20 CCP23_C1 **/
union CCP23_C1_REG{
	unsigned int reg;
	struct CCP23_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C1 (*((volatile union CCP23_C1_REG *)0x40001D20))
// model

/** 0x4000 1D24 CCP23_C2 **/
union CCP23_C2_REG{
	unsigned int reg;
	struct CCP23_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C2 (*((volatile union CCP23_C2_REG *)0x40001D24))
// model

/** 0x4000 1D28 CCP23_C3 **/
union CCP23_C3_REG{
	unsigned int reg;
	struct CCP23_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C3 (*((volatile union CCP23_C3_REG *)0x40001D28))
// model

/** 0x4000 1D2C CCP23_C4 **/
union CCP23_C4_REG{
	unsigned int reg;
	struct CCP23_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C4 (*((volatile union CCP23_C4_REG *)0x40001D2C))
// model

/** 0x4000 1D30 CCP23_SRIC **/
union CCP23_SRIC_REG{
	unsigned int reg;
	struct CCP23_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_SRIC (*((volatile union CCP23_SRIC_REG *)0x40001D30))
// model

/** 0x4000 1D34 CCP23_DF **/
union CCP23_DF_REG{
	unsigned int reg;
	struct CCP23_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_DF (*((volatile union CCP23_DF_REG *)0x40001D34))
// model

/** 0x4000 1D40 CCP23_CTL1 **/
union CCP23_CTL1_REG{
	unsigned int reg;
	struct CCP23_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_CTL1 (*((volatile union CCP23_CTL1_REG *)0x40001D40))
// model

/** 0x4000 1D44 CCP23_R1 **/
union CCP23_R1_REG{
	unsigned int reg;
	struct CCP23_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R1 (*((volatile union CCP23_R1_REG *)0x40001D44))
// model

/** 0x4000 1D48 CCP23_R2 **/
union CCP23_R2_REG{
	unsigned int reg;
	struct CCP23_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R2 (*((volatile union CCP23_R2_REG *)0x40001D48))
// model

/** 0x4000 1D4C CCP23_R3 **/
union CCP23_R3_REG{
	unsigned int reg;
	struct CCP23_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R3 (*((volatile union CCP23_R3_REG *)0x40001D4C))
// model

/** 0x4000 1D50 CCP23_R4 **/
union CCP23_R4_REG{
	unsigned int reg;
	struct CCP23_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R4 (*((volatile union CCP23_R4_REG *)0x40001D50))
// model

/** 0x4000 1D54 CCP23_CTL2 **/
union CCP23_CTL2_REG{
	unsigned int reg;
	struct CCP23_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int :2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_CTL2 (*((volatile union CCP23_CTL2_REG *)0x40001D54))
// model

/** 0x4000 1D58 CCP23_CTL3 **/
union CCP23_CTL3_REG{
	unsigned int reg;
	struct CCP23_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_CTL3 (*((volatile union CCP23_CTL3_REG *)0x40001D58))
// model

/** 0x4000 1D5C CCP23_EGIF **/
union CCP23_EGIF_REG{
	unsigned int reg;
	struct CCP23_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_EGIF (*((volatile union CCP23_EGIF_REG *)0x40001D5C))
// modelUSART5

/** 0x4000 1E80 USART5_CTLR **/
union USART5_CTLR_REG{
	unsigned int reg;
	struct USART5_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_CTLR (*((volatile union USART5_CTLR_REG *)0x40001E80))
// model

/** 0x4000 1E84 USART5_BRGR **/
union USART5_BRGR_REG{
	unsigned int reg;
	struct USART5_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_BRGR (*((volatile union USART5_BRGR_REG *)0x40001E84))
// model

/** 0x4000 1E88 USART5_STR **/
union USART5_STR_REG{
	unsigned int reg;
	struct USART5_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_STR (*((volatile union USART5_STR_REG *)0x40001E88))
// model

/** 0x4000 1E8C USART5_TBUFR **/
union USART5_TBUFR_REG{
	unsigned int reg;
	struct USART5_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_TBUFR (*((volatile union USART5_TBUFR_REG *)0x40001E8C))
// model

/** 0x4000 1E8C USART5_RBUFR **/
union USART5_RBUFR_REG{
	unsigned int reg;
	struct USART5_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_RBUFR (*((volatile union USART5_RBUFR_REG *)0x40001E8C))
// model

/** 0x4000 1E90 USART5_U7816R **/
union USART5_U7816R_REG{
	unsigned int reg;
	struct USART5_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_U7816R (*((volatile union USART5_U7816R_REG *)0x40001E90))
// model

/** 0x4000 1E94 USART5_IER **/
union USART5_IER_REG{
	unsigned int reg;
	struct USART5_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_IER (*((volatile union USART5_IER_REG *)0x40001E94))
// model

/** 0x4000 1E98 USART5_ADM **/
union USART5_ADM_REG{
	unsigned int reg;
	struct USART5_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_ADM (*((volatile union USART5_ADM_REG *)0x40001E98))
// modelUSART6

/** 0x4000 1F00 USART6_CTLR **/
union USART6_CTLR_REG{
	unsigned int reg;
	struct USART6_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_CTLR (*((volatile union USART6_CTLR_REG *)0x40001F00))
// model

/** 0x4000 1F04 USART6_BRGR **/
union USART6_BRGR_REG{
	unsigned int reg;
	struct USART6_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_BRGR (*((volatile union USART6_BRGR_REG *)0x40001F04))
// model

/** 0x4000 1F08 USART6_STR **/
union USART6_STR_REG{
	unsigned int reg;
	struct USART6_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_STR (*((volatile union USART6_STR_REG *)0x40001F08))
// model

/** 0x4000 1F0C USART6_TBUFR **/
union USART6_TBUFR_REG{
	unsigned int reg;
	struct USART6_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_TBUFR (*((volatile union USART6_TBUFR_REG *)0x40001F0C))
// model

/** 0x4000 1F0C USART6_RBUFR **/
union USART6_RBUFR_REG{
	unsigned int reg;
	struct USART6_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_RBUFR (*((volatile union USART6_RBUFR_REG *)0x40001F0C))
// model

/** 0x4000 1F10 USART6_U7816R **/
union USART6_U7816R_REG{
	unsigned int reg;
	struct USART6_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_U7816R (*((volatile union USART6_U7816R_REG *)0x40001F10))
// model

/** 0x4000 1F14 USART6_IER **/
union USART6_IER_REG{
	unsigned int reg;
	struct USART6_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_IER (*((volatile union USART6_IER_REG *)0x40001F14))
// model

/** 0x4000 1F18 USART6_ADM **/
union USART6_ADM_REG{
	unsigned int reg;
	struct USART6_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_ADM (*((volatile union USART6_ADM_REG *)0x40001F18))
// modelUSART7

/** 0x4000 1F80 USART7_CTLR **/
union USART7_CTLR_REG{
	unsigned int reg;
	struct USART7_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int :1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int :1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int :2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int :2;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLEM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_CTLR (*((volatile union USART7_CTLR_REG *)0x40001F80))
// model

/** 0x4000 1F84 USART7_BRGR **/
union USART7_BRGR_REG{
	unsigned int reg;
	struct USART7_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_BRGR (*((volatile union USART7_BRGR_REG *)0x40001F84))
// model

/** 0x4000 1F88 USART7_STR **/
union USART7_STR_REG{
	unsigned int reg;
	struct USART7_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int :1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_STR (*((volatile union USART7_STR_REG *)0x40001F88))
// model

/** 0x4000 1F8C USART7_TBUFR **/
union USART7_TBUFR_REG{
	unsigned int reg;
	struct USART7_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_TBUFR (*((volatile union USART7_TBUFR_REG *)0x40001F8C))
// model

/** 0x4000 1F8C USART7_RBUFR **/
union USART7_RBUFR_REG{
	unsigned int reg;
	struct USART7_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_RBUFR (*((volatile union USART7_RBUFR_REG *)0x40001F8C))
// model

/** 0x4000 1F90 USART7_U7816R **/
union USART7_U7816R_REG{
	unsigned int reg;
	struct USART7_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int :2;
		unsigned int _CLKDIV:8;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_U7816R (*((volatile union USART7_U7816R_REG *)0x40001F90))
// model

/** 0x4000 1F94 USART7_IER **/
union USART7_IER_REG{
	unsigned int reg;
	struct USART7_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREEIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int :4;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int :11;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_IER (*((volatile union USART7_IER_REG *)0x40001F94))
// model

/** 0x4000 1F98 USART7_ADM **/
union USART7_ADM_REG{
	unsigned int reg;
	struct USART7_ADM_BITS{
		unsigned int _ADM0:1;
		unsigned int _ADM1:1;
		unsigned int _ADM2:1;
		unsigned int _ADM3:1;
		unsigned int _ADM4:1;
		unsigned int _ADM5:1;
		unsigned int _ADM6:1;
		unsigned int _ADM7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_ADM (*((volatile union USART7_ADM_REG *)0x40001F98))
// modelSPI2

/** 0x4000 2080 SPI2_BRGR **/
union SPI2_BRGR_REG{
	unsigned int reg;
	struct SPI2_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_BRGR (*((volatile union SPI2_BRGR_REG *)0x40002080))
// model

/** 0x4000 2084 SPI2_CTLR **/
union SPI2_CTLR_REG{
	unsigned int reg;
	struct SPI2_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int :2;
		unsigned int _I2SMOD:1;
		unsigned int :3;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int _TPOEN:1;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_CTLR (*((volatile union SPI2_CTLR_REG *)0x40002084))
// model

/** 0x4000 2088 SPI2_BUFR **/
union SPI2_BUFR_REG{
	unsigned int reg;
	struct SPI2_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_BUFR (*((volatile union SPI2_BUFR_REG *)0x40002088))
// model

/** 0x4000 208C SPI2_STR **/
union SPI2_STR_REG{
	unsigned int reg;
	struct SPI2_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_STR (*((volatile union SPI2_STR_REG *)0x4000208C))
// modelSPI3

/** 0x4000 2100 SPI3_BRGR **/
union SPI3_BRGR_REG{
	unsigned int reg;
	struct SPI3_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_BRGR (*((volatile union SPI3_BRGR_REG *)0x40002100))
// model

/** 0x4000 2104 SPI3_CTLR **/
union SPI3_CTLR_REG{
	unsigned int reg;
	struct SPI3_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int :2;
		unsigned int _I2SMOD:1;
		unsigned int :3;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int _TPOEN:1;
		unsigned int _TP:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_CTLR (*((volatile union SPI3_CTLR_REG *)0x40002104))
// model

/** 0x4000 2108 SPI3_BUFR **/
union SPI3_BUFR_REG{
	unsigned int reg;
	struct SPI3_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_BUFR (*((volatile union SPI3_BUFR_REG *)0x40002108))
// model

/** 0x4000 210C SPI3_STR **/
union SPI3_STR_REG{
	unsigned int reg;
	struct SPI3_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_STR (*((volatile union SPI3_STR_REG *)0x4000210C))
// modelI2C3

/** 0x4000 2380 I2C3_CTLR **/
union I2C3_CTLR_REG{
	unsigned int reg;
	struct I2C3_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :6;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int :1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEM:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int :2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_CTLR (*((volatile union I2C3_CTLR_REG *)0x40002380))
// model

/** 0x4000 2384 I2C3_SR **/
union I2C3_SR_REG{
	unsigned int reg;
	struct I2C3_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_SR (*((volatile union I2C3_SR_REG *)0x40002384))
// model

/** 0x4000 2388 I2C3_BUFR **/
union I2C3_BUFR_REG{
	unsigned int reg;
	struct I2C3_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_BUFR (*((volatile union I2C3_BUFR_REG *)0x40002388))
// model

/** 0x4000 238C I2C3_ADDR0 **/
union I2C3_ADDR0_REG{
	unsigned int reg;
	struct I2C3_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR0 (*((volatile union I2C3_ADDR0_REG *)0x4000238C))
// model

/** 0x4000 2390 I2C3_BRGR **/
union I2C3_BRGR_REG{
	unsigned int reg;
	struct I2C3_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_BRGR (*((volatile union I2C3_BRGR_REG *)0x40002390))
// model

/** 0x4000 2394 I2C3_ADDR1 **/
union I2C3_ADDR1_REG{
	unsigned int reg;
	struct I2C3_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR1 (*((volatile union I2C3_ADDR1_REG *)0x40002394))
// model

/** 0x4000 2398 I2C3_ADDR2 **/
union I2C3_ADDR2_REG{
	unsigned int reg;
	struct I2C3_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR2 (*((volatile union I2C3_ADDR2_REG *)0x40002398))
// model

/** 0x4000 239C I2C3_ADDR3 **/
union I2C3_ADDR3_REG{
	unsigned int reg;
	struct I2C3_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR3 (*((volatile union I2C3_ADDR3_REG *)0x4000239C))
// model

/** 0x4000 23A0 I2C3_IER **/
union I2C3_IER_REG{
	unsigned int reg;
	struct I2C3_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIF:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_IER (*((volatile union I2C3_IER_REG *)0x400023A0))
// model

/** 0x4000 23A4 I2C3_TPSR **/
union I2C3_TPSR_REG{
	unsigned int reg;
	struct I2C3_TPSR_BITS{
		unsigned int _I2CTPS:12;
		unsigned int _I2CTPOEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_TPSR (*((volatile union I2C3_TPSR_REG *)0x400023A4))
// modelPLL

/** 0x4000 2580 PLL_CTL **/
union PLL_CTL_REG{
	unsigned int reg;
	struct PLL_CTL_BITS{
		unsigned int _PDRST:1;
		unsigned int :1;
		unsigned int _M:14;
		unsigned int _N:4;
		unsigned int _OD:2;
		unsigned int :2;
		unsigned int _TSZEROIS:1;
		unsigned int _TSVREF2V:1;
		unsigned int _TSVREF0P5:1;
		unsigned int _TSMRBG:1;
		unsigned int _TSLSRCIS:1;
		unsigned int _TSLPBG:1;
		unsigned int _TSLCDIS:1;
		unsigned int _TSHSILDO12:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PLL_CTL (*((volatile union PLL_CTL_REG *)0x40002580))
// modelPCLK

/** 0x4000 2640 PCLK_CTL0 **/
union PCLK_CTL0_REG{
	unsigned int reg;
	struct PCLK_CTL0_BITS{
		unsigned int _GPIOACLKEN:1;
		unsigned int _GPIOBCLKEN:1;
		unsigned int _GPIOCCLKEN:1;
		unsigned int _GPIODCLKEN:1;
		unsigned int _GPIOECLKEN:1;
		unsigned int _GPIOFCLKEN:1;
		unsigned int _GPIOGCLKEN:1;
		unsigned int _GPIOHCLKEN:1;
		unsigned int :23;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL0 (*((volatile union PCLK_CTL0_REG *)0x40002640))
// model

/** 0x4000 2644 PCLK_CTL1 **/
union PCLK_CTL1_REG{
	unsigned int reg;
	struct PCLK_CTL1_BITS{
		unsigned int :1;
		unsigned int _QEI1CLKEN:1;
		unsigned int _T1CLKEN:1;
		unsigned int _T2CLKEN:1;
		unsigned int _T3CLKEN:1;
		unsigned int _T4CLKEN:1;
		unsigned int _T5T6CLKEN:1;
		unsigned int :1;
		unsigned int _T9T10CLKEN:1;
		unsigned int :1;
		unsigned int _QEI0CLKEN:1;
		unsigned int _ADC0CLKEN:1;
		unsigned int _ADC1CLKEN:1;
		unsigned int _ADC2CLKEN:1;
		unsigned int _DAC0CLKEN:1;
		unsigned int _DAC1CLKEN:1;
		unsigned int _CMPCLKEN:1;
		unsigned int _T0CLKEN:1;
		unsigned int _CTOUCHCLKEN:1;
		unsigned int _USART0CLKEN:1;
		unsigned int _USART1CLKEN:1;
		unsigned int _USART2CLKEN:1;
		unsigned int _USART3CLKEN:1;
		unsigned int _USART4CLKEN:1;
		unsigned int _SPI0CLKEN:1;
		unsigned int _SPI1CLKEN:1;
		unsigned int _I2C0CLKEN:1;
		unsigned int _I2C1CLKEN:1;
		unsigned int _I2C2CLKEN:1;
		unsigned int _LCDCLKEN:1;
		unsigned int :1;
		unsigned int _USBCLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL1 (*((volatile union PCLK_CTL1_REG *)0x40002644))
// model

/** 0x4000 2648 PCLK_CTL2 **/
union PCLK_CTL2_REG{
	unsigned int reg;
	struct PCLK_CTL2_BITS{
		unsigned int :1;
		unsigned int :1;
		unsigned int _CAN0CLKEN:1;
		unsigned int _CAN1CLKEN:1;
		unsigned int :1;
		unsigned int _WWDTCLKEN:1;
		unsigned int :5;
		unsigned int :1;
		unsigned int _DMA0CLKEN:1;
		unsigned int :1;
		unsigned int _DMA1CLKEN:1;
		unsigned int :1;
		unsigned int _T14CLKEN:1;
		unsigned int _T15CLKEN:1;
		unsigned int _CAN2CLKEN:1;
		unsigned int _CAN3CLKEN:1;
		unsigned int :1;
		unsigned int _T18CLKEN:1;
		unsigned int _T19CLKEN:1;
		unsigned int _T20CLKEN:1;
		unsigned int _T21CLKEN:1;
		unsigned int _T22CLKEN:1;
		unsigned int _T23CLKEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _USART5CLKEN:1;
		unsigned int _USART6CLKEN:1;
		unsigned int _USART7CLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL2 (*((volatile union PCLK_CTL2_REG *)0x40002648))
// model

/** 0x4000 264C PCLK_CTL3 **/
union PCLK_CTL3_REG{
	unsigned int reg;
	struct PCLK_CTL3_BITS{
		unsigned int :1;
		unsigned int _SPI2CLKEN:1;
		unsigned int _SPI3CLKEN:1;
		unsigned int :4;
		unsigned int _I2C3CLKEN:1;
		unsigned int :5;
		unsigned int _CRCCLKEN:1;
		unsigned int _AESCLKEN:1;
		unsigned int _LEDCLKEN:1;
		unsigned int _EXICCLKEN:1;
		unsigned int _CAN4CLKEN:1;
		unsigned int _CAN5CLKEN:1;
		unsigned int _CFGLCLKEN:1;
		unsigned int _OPCLKEN:1;
		unsigned int :10;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL3 (*((volatile union PCLK_CTL3_REG *)0x4000264C))
// modelCRC

/** 0X4000 2680 CRC_CTL **/
union CRC_CTL_REG{
	unsigned int reg;
	struct CRC_CTL_BITS{
		unsigned int _RSET:1;
		unsigned int :1;
		unsigned int _DATASIZE:2;
		unsigned int :1;
		unsigned int _DATAREV:1;
		unsigned int :1;
		unsigned int _RSLTREV:1;
		unsigned int :23;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_CTL (*((volatile union CRC_CTL_REG *)0x40002680))
// model

/** 0X4000 2684 CRC_DATA **/
union CRC_DATA_REG{
	unsigned int reg;
	struct CRC_DATA_BITS{
		unsigned int _CRCDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_DATA (*((volatile union CRC_DATA_REG *)0x40002684))
// model

/** 0X4000 2688 CRC_RSLT **/
union CRC_RSLT_REG{
	unsigned int reg;
	struct CRC_RSLT_BITS{
		unsigned int _CRCRSLT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RSLT (*((volatile union CRC_RSLT_REG *)0x40002688))
// model

/** 0X4000 268C CRC_INIT **/
union CRC_INIT_REG{
	unsigned int reg;
	struct CRC_INIT_BITS{
		unsigned int _CRCINIT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_INIT (*((volatile union CRC_INIT_REG *)0x4000268C))
// model

/** 0X4000 2690 CRC_PLN **/
union CRC_PLN_REG{
	unsigned int reg;
	struct CRC_PLN_BITS{
		unsigned int _CRCPLN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_PLN (*((volatile union CRC_PLN_REG *)0x40002690))
// model

/** 0X4000 2694 CRC_RXOR **/
union CRC_RXOR_REG{
	unsigned int reg;
	struct CRC_RXOR_BITS{
		unsigned int _CRCRXOR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RXOR (*((volatile union CRC_RXOR_REG *)0x40002694))
// model

/** 0X4000 2698 CRC_IDATA **/
union CRC_IDATA_REG{
	unsigned int reg;
	struct CRC_IDATA_BITS{
		unsigned int _CRCIDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_IDATA (*((volatile union CRC_IDATA_REG *)0x40002698))
// model

/** 0X4000 269C CRC_TEMP **/
union CRC_TEMP_REG{
	unsigned int reg;
	struct CRC_TEMP_BITS{
		unsigned int _CRCTEMP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_TEMP (*((volatile union CRC_TEMP_REG *)0x4000269C))
// modelAES

/** 0x4000 2700 AES_CTL **/
union AES_CTL_REG{
	unsigned int reg;
	struct AES_CTL_BITS{
		unsigned int _OFBEN:1;
		unsigned int _AESCS:2;
		unsigned int _AESDIV:3;
		unsigned int :1;
		unsigned int _AESRUN:1;
		unsigned int :7;
		unsigned int _AESFIE:1;
		unsigned int :7;
		unsigned int _AESFIC:1;
		unsigned int :7;
		unsigned int _AESFIF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_CTL (*((volatile union AES_CTL_REG *)0x40002700))
// model

/** 0X4000 2710 AES_KEY0 **/
union AES_KEY0_REG{
	unsigned int reg;
	struct AES_KEY0_BITS{
		unsigned int _AESKEY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEY0 (*((volatile union AES_KEY0_REG *)0x40002710))
// model

/** 0X4000 2714 AES_KEY1 **/
union AES_KEY1_REG{
	unsigned int reg;
	struct AES_KEY1_BITS{
		unsigned int _AESKEY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEY1 (*((volatile union AES_KEY1_REG *)0x40002714))
// model

/** 0X4000 2718 AES_KEY2 **/
union AES_KEY2_REG{
	unsigned int reg;
	struct AES_KEY2_BITS{
		unsigned int _AESKEY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEY2 (*((volatile union AES_KEY2_REG *)0x40002718))
// model

/** 0X4000 271C AES_KEY3 **/
union AES_KEY3_REG{
	unsigned int reg;
	struct AES_KEY3_BITS{
		unsigned int _AESKEY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEY3 (*((volatile union AES_KEY3_REG *)0x4000271C))
// model

/** 0X4000 2720 AES_INPUT0 **/
union AES_INPUT0_REG{
	unsigned int reg;
	struct AES_INPUT0_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT0 (*((volatile union AES_INPUT0_REG *)0x40002720))
// model

/** 0X4000 2724 AES_INPUT1 **/
union AES_INPUT1_REG{
	unsigned int reg;
	struct AES_INPUT1_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT1 (*((volatile union AES_INPUT1_REG *)0x40002724))
// model

/** 0X4000 2728 AES_INPUT2 **/
union AES_INPUT2_REG{
	unsigned int reg;
	struct AES_INPUT2_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT2 (*((volatile union AES_INPUT2_REG *)0x40002728))
// model

/** 0X4000 272C AES_INPUT3 **/
union AES_INPUT3_REG{
	unsigned int reg;
	struct AES_INPUT3_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT3 (*((volatile union AES_INPUT3_REG *)0x4000272C))
// model

/** 0X4000 2730 AES_OUTPUT0 **/
union AES_OUTPUT0_REG{
	unsigned int reg;
	struct AES_OUTPUT0_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT0 (*((volatile union AES_OUTPUT0_REG *)0x40002730))
// model

/** 0X4000 2734 AES_OUTPUT1 **/
union AES_OUTPUT1_REG{
	unsigned int reg;
	struct AES_OUTPUT1_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT1 (*((volatile union AES_OUTPUT1_REG *)0x40002734))
// model

/** 0X4000 2738 AES_OUTPUT2 **/
union AES_OUTPUT2_REG{
	unsigned int reg;
	struct AES_OUTPUT2_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT2 (*((volatile union AES_OUTPUT2_REG *)0x40002738))
// model

/** 0X4000 273C AES_OUTPUT3 **/
union AES_OUTPUT3_REG{
	unsigned int reg;
	struct AES_OUTPUT3_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT3 (*((volatile union AES_OUTPUT3_REG *)0x4000273C))
// modelLED

/** 0X4000 2780 LED_DATA0 **/
union LED_DATA0_REG{
	unsigned int reg;
	struct LED_DATA0_BITS{
		unsigned int _COM0SEG0:1;
		unsigned int _COM0SEG1:1;
		unsigned int _COM0SEG2:1;
		unsigned int _COM0SEG3:1;
		unsigned int _COM0SEG4:1;
		unsigned int _COM0SEG5:1;
		unsigned int _COM0SEG6:1;
		unsigned int _COM0SEG7:1;
		unsigned int _COM0SEG8:1;
		unsigned int _COM0SEG9:1;
		unsigned int _COM0SEG10:1;
		unsigned int _COM0SEG11:1;
		unsigned int _COM0SEG12:1;
		unsigned int _COM0SEG13:1;
		unsigned int _COM0SEG14:1;
		unsigned int _COM0SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA0 (*((volatile union LED_DATA0_REG *)0x40002780))
// model

/** 0X4000 2784 LED_DATA1 **/
union LED_DATA1_REG{
	unsigned int reg;
	struct LED_DATA1_BITS{
		unsigned int _COM1SEG0:1;
		unsigned int _COM1SEG1:1;
		unsigned int _COM1SEG2:1;
		unsigned int _COM1SEG3:1;
		unsigned int _COM1SEG4:1;
		unsigned int _COM1SEG5:1;
		unsigned int _COM1SEG6:1;
		unsigned int _COM1SEG7:1;
		unsigned int _COM1SEG8:1;
		unsigned int _COM1SEG9:1;
		unsigned int _COM1SEG10:1;
		unsigned int _COM1SEG11:1;
		unsigned int _COM1SEG12:1;
		unsigned int _COM1SEG13:1;
		unsigned int _COM1SEG14:1;
		unsigned int _COM1SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA1 (*((volatile union LED_DATA1_REG *)0x40002784))
// model

/** 0X4000 2788 LED_DATA2 **/
union LED_DATA2_REG{
	unsigned int reg;
	struct LED_DATA2_BITS{
		unsigned int _COM2SEG0:1;
		unsigned int _COM2SEG1:1;
		unsigned int _COM2SEG2:1;
		unsigned int _COM2SEG3:1;
		unsigned int _COM2SEG4:1;
		unsigned int _COM2SEG5:1;
		unsigned int _COM2SEG6:1;
		unsigned int _COM2SEG7:1;
		unsigned int _COM2SEG8:1;
		unsigned int _COM2SEG9:1;
		unsigned int _COM2SEG10:1;
		unsigned int _COM2SEG11:1;
		unsigned int _COM2SEG12:1;
		unsigned int _COM2SEG13:1;
		unsigned int _COM2SEG14:1;
		unsigned int _COM2SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA2 (*((volatile union LED_DATA2_REG *)0x40002788))
// model

/** 0X4000 278C LED_DATA3 **/
union LED_DATA3_REG{
	unsigned int reg;
	struct LED_DATA3_BITS{
		unsigned int _COM3SEG0:1;
		unsigned int _COM3SEG1:1;
		unsigned int _COM3SEG2:1;
		unsigned int _COM3SEG3:1;
		unsigned int _COM3SEG4:1;
		unsigned int _COM3SEG5:1;
		unsigned int _COM3SEG6:1;
		unsigned int _COM3SEG7:1;
		unsigned int _COM3SEG8:1;
		unsigned int _COM3SEG9:1;
		unsigned int _COM3SEG10:1;
		unsigned int _COM3SEG11:1;
		unsigned int _COM3SEG12:1;
		unsigned int _COM3SEG13:1;
		unsigned int _COM3SEG14:1;
		unsigned int _COM3SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA3 (*((volatile union LED_DATA3_REG *)0x4000278C))
// model

/** 0X4000 2790 LED_DATA4 **/
union LED_DATA4_REG{
	unsigned int reg;
	struct LED_DATA4_BITS{
		unsigned int _COM4SEG0:1;
		unsigned int _COM4SEG1:1;
		unsigned int _COM4SEG2:1;
		unsigned int _COM4SEG3:1;
		unsigned int _COM4SEG4:1;
		unsigned int _COM4SEG5:1;
		unsigned int _COM4SEG6:1;
		unsigned int _COM4SEG7:1;
		unsigned int _COM4SEG8:1;
		unsigned int _COM4SEG9:1;
		unsigned int _COM4SEG10:1;
		unsigned int _COM4SEG11:1;
		unsigned int _COM4SEG12:1;
		unsigned int _COM4SEG13:1;
		unsigned int _COM4SEG14:1;
		unsigned int _COM4SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA4 (*((volatile union LED_DATA4_REG *)0x40002790))
// model

/** 0X4000 2794 LED_DATA5 **/
union LED_DATA5_REG{
	unsigned int reg;
	struct LED_DATA5_BITS{
		unsigned int _COM5SEG0:1;
		unsigned int _COM5SEG1:1;
		unsigned int _COM5SEG2:1;
		unsigned int _COM5SEG3:1;
		unsigned int _COM5SEG4:1;
		unsigned int _COM5SEG5:1;
		unsigned int _COM5SEG6:1;
		unsigned int _COM5SEG7:1;
		unsigned int _COM5SEG8:1;
		unsigned int _COM5SEG9:1;
		unsigned int _COM5SEG10:1;
		unsigned int _COM5SEG11:1;
		unsigned int _COM5SEG12:1;
		unsigned int _COM5SEG13:1;
		unsigned int _COM5SEG14:1;
		unsigned int _COM5SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA5 (*((volatile union LED_DATA5_REG *)0x40002794))
// model

/** 0X4000 2798 LED_DATA6 **/
union LED_DATA6_REG{
	unsigned int reg;
	struct LED_DATA6_BITS{
		unsigned int _COM6SEG0:1;
		unsigned int _COM6SEG1:1;
		unsigned int _COM6SEG2:1;
		unsigned int _COM6SEG3:1;
		unsigned int _COM6SEG4:1;
		unsigned int _COM6SEG5:1;
		unsigned int _COM6SEG6:1;
		unsigned int _COM6SEG7:1;
		unsigned int _COM6SEG8:1;
		unsigned int _COM6SEG9:1;
		unsigned int _COM6SEG10:1;
		unsigned int _COM6SEG11:1;
		unsigned int _COM6SEG12:1;
		unsigned int _COM6SEG13:1;
		unsigned int _COM6SEG14:1;
		unsigned int _COM6SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA6 (*((volatile union LED_DATA6_REG *)0x40002798))
// model

/** 0X4000 279C LED_DATA7 **/
union LED_DATA7_REG{
	unsigned int reg;
	struct LED_DATA7_BITS{
		unsigned int _COM7SEG0:1;
		unsigned int _COM7SEG1:1;
		unsigned int _COM7SEG2:1;
		unsigned int _COM7SEG3:1;
		unsigned int _COM7SEG4:1;
		unsigned int _COM7SEG5:1;
		unsigned int _COM7SEG6:1;
		unsigned int _COM7SEG7:1;
		unsigned int _COM7SEG8:1;
		unsigned int _COM7SEG9:1;
		unsigned int _COM7SEG10:1;
		unsigned int _COM7SEG11:1;
		unsigned int _COM7SEG12:1;
		unsigned int _COM7SEG13:1;
		unsigned int _COM7SEG14:1;
		unsigned int _COM7SEG15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_DATA7 (*((volatile union LED_DATA7_REG *)0x4000279C))
// model

/** 0X4000 27A0 LED_CTL0 **/
union LED_CTL0_REG{
	unsigned int reg;
	struct LED_CTL0_BITS{
		unsigned int _CKS0:4;
		unsigned int _CKS1:4;
		unsigned int _CS:2;
		unsigned int _PNS:2;
		unsigned int :2;
		unsigned int _LEDBR:1;
		unsigned int _LEDEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_CTL0 (*((volatile union LED_CTL0_REG *)0x400027A0))
// model

/** 0X4000 27A4 LED_CTL1 **/
union LED_CTL1_REG{
	unsigned int reg;
	struct LED_CTL1_BITS{
		unsigned int _FRAMEF:1;
		unsigned int :1;
		unsigned int _LUM:3;
		unsigned int _COMEN:3;
		unsigned int _SEG8EN:1;
		unsigned int _SEG12EN:1;
		unsigned int _SEG16EN:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define LED_CTL1 (*((volatile union LED_CTL1_REG *)0x400027A4))
// modelEXIC

/** 0X4000 2800 EXIC_CTL0 **/
union EXIC_CTL0_REG{
	unsigned int reg;
	struct EXIC_CTL0_BITS{
		unsigned int _EXICEN:1;
		unsigned int _CSEN:1;
		unsigned int _DCSEL:1;
		unsigned int _WRITEEN:1;
		unsigned int _READEN:1;
		unsigned int :3;
		unsigned int _TDMAEN:1;
		unsigned int _RDMAEN:1;
		unsigned int :6;
		unsigned int _WENDEN:1;
		unsigned int _RENDIE:1;
		unsigned int :10;
		unsigned int _WRITE1EN:1;
		unsigned int _READ1EN:1;
		unsigned int _DATATR:1;
		unsigned int _MODESEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_CTL0 (*((volatile union EXIC_CTL0_REG *)0x40002800))
// model

/** 0X4000 2804 EXIC_CTL1 **/
union EXIC_CTL1_REG{
	unsigned int reg;
	struct EXIC_CTL1_BITS{
		unsigned int _EXICCS:2;
		unsigned int :2;
		unsigned int _PULSEWIDTH:4;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_CTL1 (*((volatile union EXIC_CTL1_REG *)0x40002804))
// model

/** 0X4000 2808 EXIC_STATE **/
union EXIC_STATE_REG{
	unsigned int reg;
	struct EXIC_STATE_BITS{
		unsigned int _WENDIF:1;
		unsigned int _RENDIF:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_STATE (*((volatile union EXIC_STATE_REG *)0x40002808))
// model

/** 0X4000 2810 EXIC_WRITEBUF **/
union EXIC_WRITEBUF_REG{
	unsigned int reg;
	struct EXIC_WRITEBUF_BITS{
		unsigned int _WRITEBUF:18;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_WRITEBUF (*((volatile union EXIC_WRITEBUF_REG *)0x40002810))
// model

/** 0X4000 2814 EXIC_READBUF **/
union EXIC_READBUF_REG{
	unsigned int reg;
	struct EXIC_READBUF_BITS{
		unsigned int _READBUF:18;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_READBUF (*((volatile union EXIC_READBUF_REG *)0x40002814))
// modelCAN4

/** 0x4000 2880 CAN4_CTLR **/
union CAN4_CTLR_REG{
	unsigned int reg;
	struct CAN4_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int :1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int :4;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_CTLR (*((volatile union CAN4_CTLR_REG *)0x40002880))
// model

/** 0x4000 2884 CAN4_BRGR **/
union CAN4_BRGR_REG{
	unsigned int reg;
	struct CAN4_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_BRGR (*((volatile union CAN4_BRGR_REG *)0x40002884))
// model

/** 0x4000 2888 CAN4_RCR **/
union CAN4_RCR_REG{
	unsigned int reg;
	struct CAN4_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RCR (*((volatile union CAN4_RCR_REG *)0x40002888))
// model

/** 0x4000 288C CAN4_EROR **/
union CAN4_EROR_REG{
	unsigned int reg;
	struct CAN4_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_EROR (*((volatile union CAN4_EROR_REG *)0x4000288C))
// model

/** 0x4000 2890 CAN4_ACRR **/
union CAN4_ACRR_REG{
	unsigned int reg;
	struct CAN4_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACRR (*((volatile union CAN4_ACRR_REG *)0x40002890))
// model

/** 0x4000 2894 CAN4_MSKR **/
union CAN4_MSKR_REG{
	unsigned int reg;
	struct CAN4_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSKR (*((volatile union CAN4_MSKR_REG *)0x40002894))
// model

/** 0x4000 2898 CAN4_IER **/
union CAN4_IER_REG{
	unsigned int reg;
	struct CAN4_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int :8;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_IER (*((volatile union CAN4_IER_REG *)0x40002898))
// model

/** 0x4000 289C CAN4_IFR **/
union CAN4_IFR_REG{
	unsigned int reg;
	struct CAN4_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_IFR (*((volatile union CAN4_IFR_REG *)0x4000289C))
// model

/** 0x4000 28A0 CAN4_INFR **/
union CAN4_INFR_REG{
	unsigned int reg;
	struct CAN4_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_INFR (*((volatile union CAN4_INFR_REG *)0x400028A0))
// model

/** 0x4000 28A4 CAN4_TX0R **/
union CAN4_TX0R_REG{
	unsigned int reg;
	struct CAN4_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_TX0R (*((volatile union CAN4_TX0R_REG *)0x400028A4))
// model

/** 0x4000 28A8 CAN4_TX1R **/
union CAN4_TX1R_REG{
	unsigned int reg;
	struct CAN4_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_TX1R (*((volatile union CAN4_TX1R_REG *)0x400028A8))
// model

/** 0x4000 28AC CAN4_TX2R **/
union CAN4_TX2R_REG{
	unsigned int reg;
	struct CAN4_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_TX2R (*((volatile union CAN4_TX2R_REG *)0x400028AC))
// model

/** 0x4000 28B0 CAN4_RXDATA0 **/
union CAN4_RXDATA0_REG{
	unsigned int reg;
	struct CAN4_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA0 (*((volatile union CAN4_RXDATA0_REG *)0x400028B0))
// model

/** 0x4000 28B4 CAN4_RXDATA1 **/
union CAN4_RXDATA1_REG{
	unsigned int reg;
	struct CAN4_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA1 (*((volatile union CAN4_RXDATA1_REG *)0x400028B4))
// model

/** 0x4000 28B8 CAN4_RXDATA2 **/
union CAN4_RXDATA2_REG{
	unsigned int reg;
	struct CAN4_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA2 (*((volatile union CAN4_RXDATA2_REG *)0x400028B8))
// model

/** 0x4000 28BC CAN4_RXDATA3 **/
union CAN4_RXDATA3_REG{
	unsigned int reg;
	struct CAN4_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA3 (*((volatile union CAN4_RXDATA3_REG *)0x400028BC))
// modelCAN5

/** 0x4000 2900 CAN5_CTLR **/
union CAN5_CTLR_REG{
	unsigned int reg;
	struct CAN5_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int :1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int :4;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:5;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_CTLR (*((volatile union CAN5_CTLR_REG *)0x40002900))
// model

/** 0x4000 2904 CAN5_BRGR **/
union CAN5_BRGR_REG{
	unsigned int reg;
	struct CAN5_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_BRGR (*((volatile union CAN5_BRGR_REG *)0x40002904))
// model

/** 0x4000 2908 CAN5_RCR **/
union CAN5_RCR_REG{
	unsigned int reg;
	struct CAN5_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_RCR (*((volatile union CAN5_RCR_REG *)0x40002908))
// model

/** 0x4000 290C CAN5_EROR **/
union CAN5_EROR_REG{
	unsigned int reg;
	struct CAN5_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_EROR (*((volatile union CAN5_EROR_REG *)0x4000290C))
// model

/** 0x4000 2910 CAN5_ACRR **/
union CAN5_ACRR_REG{
	unsigned int reg;
	struct CAN5_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_ACRR (*((volatile union CAN5_ACRR_REG *)0x40002910))
// model

/** 0x4000 2914 CAN5_MSKR **/
union CAN5_MSKR_REG{
	unsigned int reg;
	struct CAN5_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_MSKR (*((volatile union CAN5_MSKR_REG *)0x40002914))
// model

/** 0x4000 2918 CAN5_IER **/
union CAN5_IER_REG{
	unsigned int reg;
	struct CAN5_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int :8;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_IER (*((volatile union CAN5_IER_REG *)0x40002918))
// model

/** 0x4000 291C CAN5_IFR **/
union CAN5_IFR_REG{
	unsigned int reg;
	struct CAN5_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_IFR (*((volatile union CAN5_IFR_REG *)0x4000291C))
// model

/** 0x4000 2920 CAN5_INFR **/
union CAN5_INFR_REG{
	unsigned int reg;
	struct CAN5_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_INFR (*((volatile union CAN5_INFR_REG *)0x40002920))
// model

/** 0x4000 2924 CAN5_TX0R **/
union CAN5_TX0R_REG{
	unsigned int reg;
	struct CAN5_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_TX0R (*((volatile union CAN5_TX0R_REG *)0x40002924))
// model

/** 0x4000 2928 CAN5_TX1R **/
union CAN5_TX1R_REG{
	unsigned int reg;
	struct CAN5_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_TX1R (*((volatile union CAN5_TX1R_REG *)0x40002928))
// model

/** 0x4000 292C CAN5_TX2R **/
union CAN5_TX2R_REG{
	unsigned int reg;
	struct CAN5_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_TX2R (*((volatile union CAN5_TX2R_REG *)0x4000292C))
// model

/** 0x4000 2930 CAN5_RXDATA0 **/
union CAN5_RXDATA0_REG{
	unsigned int reg;
	struct CAN5_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_RXDATA0 (*((volatile union CAN5_RXDATA0_REG *)0x40002930))
// model

/** 0x4000 2934 CAN5_RXDATA1 **/
union CAN5_RXDATA1_REG{
	unsigned int reg;
	struct CAN5_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_RXDATA1 (*((volatile union CAN5_RXDATA1_REG *)0x40002934))
// model

/** 0x4000 2938 CAN5_RXDATA2 **/
union CAN5_RXDATA2_REG{
	unsigned int reg;
	struct CAN5_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_RXDATA2 (*((volatile union CAN5_RXDATA2_REG *)0x40002938))
// model

/** 0x4000 293C CAN5_RXDATA3 **/
union CAN5_RXDATA3_REG{
	unsigned int reg;
	struct CAN5_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN5_RXDATA3 (*((volatile union CAN5_RXDATA3_REG *)0x4000293C))
// modelCFGL1

/** 0x4000 2980 CFGL1_CTL0 **/
union CFGL1_CTL0_REG{
	unsigned int reg;
	struct CFGL1_CTL0_BITS{
		unsigned int _TPSEL:3;
		unsigned int _REGIN:1;
		unsigned int _D1S:3;
		unsigned int :1;
		unsigned int _D2S:3;
		unsigned int :1;
		unsigned int _D3S:3;
		unsigned int :1;
		unsigned int _D4S:3;
		unsigned int :1;
		unsigned int _G1POL:1;
		unsigned int _G2POL:1;
		unsigned int _G3POL:1;
		unsigned int _G4POL:1;
		unsigned int _POL:1;
		unsigned int _MD:3;
		unsigned int _INTN:1;
		unsigned int _INTP:1;
		unsigned int _OE:1;
		unsigned int _EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL1_CTL0 (*((volatile union CFGL1_CTL0_REG *)0x40002980))
// model

/** 0x4000 2984 CFGL1_CTL1 **/
union CFGL1_CTL1_REG{
	unsigned int reg;
	struct CFGL1_CTL1_BITS{
		unsigned int _G1D1N:1;
		unsigned int _G1D1T:1;
		unsigned int _G1D2N:1;
		unsigned int _G1D2T:1;
		unsigned int _G1D3N:1;
		unsigned int _G1D3T:1;
		unsigned int _G1D4N:1;
		unsigned int _G1D4T:1;
		unsigned int _G2D1N:1;
		unsigned int _G2D1T:1;
		unsigned int _G2D2N:1;
		unsigned int _G2D2T:1;
		unsigned int _G2D3N:1;
		unsigned int _G2D3T:1;
		unsigned int _G2D4N:1;
		unsigned int _G2D4T:1;
		unsigned int _G3D1N:1;
		unsigned int _G3D1T:1;
		unsigned int _G3D2N:1;
		unsigned int _G3D2T:1;
		unsigned int _G3D3N:1;
		unsigned int _G3D3T:1;
		unsigned int _G3D4N:1;
		unsigned int _G3D4T:1;
		unsigned int _G4D1N:1;
		unsigned int _G4D1T:1;
		unsigned int _G4D2N:1;
		unsigned int _G4D2T:1;
		unsigned int _G4D3N:1;
		unsigned int _G4D3T:1;
		unsigned int _G4D4N:1;
		unsigned int _G4D4T:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL1_CTL1 (*((volatile union CFGL1_CTL1_REG *)0x40002984))
// modelCFGL2

/** 0x4000 2988 CFGL2_CTL0 **/
union CFGL2_CTL0_REG{
	unsigned int reg;
	struct CFGL2_CTL0_BITS{
		unsigned int _TPSEL:3;
		unsigned int _REGIN:1;
		unsigned int _D1S:3;
		unsigned int :1;
		unsigned int _D2S:3;
		unsigned int :1;
		unsigned int _D3S:3;
		unsigned int :1;
		unsigned int _D4S:3;
		unsigned int :1;
		unsigned int _G1POL:1;
		unsigned int _G2POL:1;
		unsigned int _G3POL:1;
		unsigned int _G4POL:1;
		unsigned int _POL:1;
		unsigned int _MD:3;
		unsigned int _INTN:1;
		unsigned int _INTP:1;
		unsigned int _OE:1;
		unsigned int _EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL2_CTL0 (*((volatile union CFGL2_CTL0_REG *)0x40002988))
// model

/** 0x4000 298C CFGL2_CTL1 **/
union CFGL2_CTL1_REG{
	unsigned int reg;
	struct CFGL2_CTL1_BITS{
		unsigned int _G1D1N:1;
		unsigned int _G1D1T:1;
		unsigned int _G1D2N:1;
		unsigned int _G1D2T:1;
		unsigned int _G1D3N:1;
		unsigned int _G1D3T:1;
		unsigned int _G1D4N:1;
		unsigned int _G1D4T:1;
		unsigned int _G2D1N:1;
		unsigned int _G2D1T:1;
		unsigned int _G2D2N:1;
		unsigned int _G2D2T:1;
		unsigned int _G2D3N:1;
		unsigned int _G2D3T:1;
		unsigned int _G2D4N:1;
		unsigned int _G2D4T:1;
		unsigned int _G3D1N:1;
		unsigned int _G3D1T:1;
		unsigned int _G3D2N:1;
		unsigned int _G3D2T:1;
		unsigned int _G3D3N:1;
		unsigned int _G3D3T:1;
		unsigned int _G3D4N:1;
		unsigned int _G3D4T:1;
		unsigned int _G4D1N:1;
		unsigned int _G4D1T:1;
		unsigned int _G4D2N:1;
		unsigned int _G4D2T:1;
		unsigned int _G4D3N:1;
		unsigned int _G4D3T:1;
		unsigned int _G4D4N:1;
		unsigned int _G4D4T:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL2_CTL1 (*((volatile union CFGL2_CTL1_REG *)0x4000298C))
// modelCFGL

/** 0x4000 2990 CFGL_IFR **/
union CFGL_IFR_REG{
	unsigned int reg;
	struct CFGL_IFR_BITS{
		unsigned int _CFGL1OUT:1;
		unsigned int _CFGL2OUT:1;
		unsigned int :6;
		unsigned int _CFGL1IF:1;
		unsigned int _CFGL2IF:1;
		unsigned int :18;
		unsigned int _CFGL1IE:1;
		unsigned int _CFGL2IE:1;
		unsigned int _CFGL1SYNCEN:1;
		unsigned int _CFGL2SYNCEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL_IFR (*((volatile union CFGL_IFR_REG *)0x40002990))
// modelOP

/** 0x4000 2A00 OP_CAL **/
union OP_CAL_REG{
	unsigned int reg;
	struct OP_CAL_BITS{
		unsigned int _OP0CAL:6;
		unsigned int :2;
		unsigned int _OP1CAL:6;
		unsigned int :2;
		unsigned int _OP2CAL:6;
		unsigned int :2;
		unsigned int _OP3CAL:6;
		unsigned int :2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP_CAL (*((volatile union OP_CAL_REG *)0x40002A00))
// model

/** 0X4000 2A04 OP_CTL0 **/
union OP_CTL0_REG{
	unsigned int reg;
	struct OP_CTL0_BITS{
		unsigned int _OP0EN:1;
		unsigned int _OP1EN:1;
		unsigned int _OP2EN:1;
		unsigned int _OP3EN:1;
		unsigned int _OP0OUTEN:1;
		unsigned int _OP1OUTEN:1;
		unsigned int _OP2OUTEN:1;
		unsigned int _OP3OUTEN:1;
		unsigned int _OP3VINPSEL:2;
		unsigned int :5;
		unsigned int :1;
		unsigned int _OP0GAIN10X:1;
		unsigned int _OP0GAIN20X:1;
		unsigned int _OP0GAIN40X:1;
		unsigned int _OP0GAIN80X:1;
		unsigned int _OP1GAIN10X:1;
		unsigned int _OP1GAIN20X:1;
		unsigned int _OP1GAIN40X:1;
		unsigned int _OP1GAIN80X:1;
		unsigned int _OP2GAIN10X:1;
		unsigned int _OP2GAIN20X:1;
		unsigned int _OP2GAIN40X:1;
		unsigned int _OP2GAIN80X:1;
		unsigned int :3;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP_CTL0 (*((volatile union OP_CTL0_REG *)0x40002A04))
// model

/** 0X4000 2A08 OP_CTL1 **/
union OP_CTL1_REG{
	unsigned int reg;
	struct OP_CTL1_BITS{
		unsigned int _OP0CAP:3;
		unsigned int _OP0CAPEN:1;
		unsigned int _OP1CAP:3;
		unsigned int _OP1CAPEN:1;
		unsigned int _OP2CAP:3;
		unsigned int _OP2CAPEN:1;
		unsigned int :19;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP_CTL1 (*((volatile union OP_CTL1_REG *)0x40002A08))
// modelINT

/** 0x4020 0000 INT_CTL0 **/
union INT_CTL0_REG{
	unsigned int reg;
	struct INT_CTL0_BITS{
		unsigned int _AIE:1;
		unsigned int _PRIGROUP:2;
		unsigned int :1;
		unsigned int _INTPENDING:1;
		unsigned int _INTPREEMPT:1;
		unsigned int _FAULTMASK:1;
		unsigned int _DSALIGN:1;
		unsigned int :4;
		unsigned int _PRIBASE:4;
		unsigned int _INTPEND:7;
		unsigned int :1;
		unsigned int _INTACT:7;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL0 (*((volatile union INT_CTL0_REG *)0x40200000))
// model

/** 0x4020 0004 INT_EIE0 **/
union INT_EIE0_REG{
	unsigned int reg;
	struct INT_EIE0_BITS{
		unsigned int :3;
		unsigned int _HADRFAULTIE:1;
		unsigned int _ECCIE:1;
		unsigned int _STACKIE:1;
		unsigned int _ARIFAULTIE:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _SVCIE:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIE:1;
		unsigned int _SYSTICKIE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE0 (*((volatile union INT_EIE0_REG *)0x40200004))
// model

/** 0x4020 000C INT_EIE1 **/
union INT_EIE1_REG{
	unsigned int reg;
	struct INT_EIE1_BITS{
		unsigned int _WWDTIE:1;
		unsigned int _EINT16IE:1;
		unsigned int _EINT0IE:1;
		unsigned int _EINT1IE:1;
		unsigned int _EINT2IE:1;
		unsigned int _EINT3IE:1;
		unsigned int _EINT4IE:1;
		unsigned int _EINT9TO5IE:1;
		unsigned int _EINT15TO10IE:1;
		unsigned int _T1IE:1;
		unsigned int _T3IE:1;
		unsigned int _T5IE:1;
		unsigned int _T6IE:1;
		unsigned int _QEIIE:1;
		unsigned int _CAN2IE:1;
		unsigned int _CAN3IE:1;
		unsigned int _CAN4IE:1;
		unsigned int _T14IE:1;
		unsigned int _T15IE:1;
		unsigned int _CAN5IE:1;
		unsigned int _EXICIE:1;
		unsigned int _ADC0IE:1;
		unsigned int _ADC1IE:1;
		unsigned int _CFGLIE:1;
		unsigned int _LCDIE:1;
		unsigned int _T0IE:1;
		unsigned int _DMA0IE:1;
		unsigned int _CMPIE:1;
		unsigned int _USART0IE:1;
		unsigned int _USART1IE:1;
		unsigned int _SPI0IE:1;
		unsigned int _SPI1IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE1 (*((volatile union INT_EIE1_REG *)0x4020000C))
// model

/** 0x4020 0014 INT_EIE2 **/
union INT_EIE2_REG{
	unsigned int reg;
	struct INT_EIE2_BITS{
		unsigned int _DMA1IE:1;
		unsigned int _EINT19TO17IE:1;
		unsigned int _CAN0IE:1;
		unsigned int _CAN1IE:1;
		unsigned int _T9IE:1;
		unsigned int _T10IE:1;
		unsigned int _EINT21TO20IE:1;
		unsigned int _EINT31TO22IE:1;
		unsigned int _OSCIE:1;
		unsigned int _I2C0IE:1;
		unsigned int _I2C1IE:1;
		unsigned int _I2C2IE:1;
		unsigned int _USBIE:1;
		unsigned int _T2IE:1;
		unsigned int _T4IE:1;
		unsigned int _CTOUCHIE:1;
		unsigned int _USART2IE:1;
		unsigned int _USART3IE:1;
		unsigned int _USART4IE:1;
		unsigned int _SPI2IE:1;
		unsigned int _SPI3IE:1;
		unsigned int _ADC2IE:1;
		unsigned int _T18IE:1;
		unsigned int _T19IE:1;
		unsigned int _T22T23IE:1;
		unsigned int _WKPIE:1;
		unsigned int _T20IE:1;
		unsigned int _T21IE:1;
		unsigned int _I2C3IE:1;
		unsigned int _USART5IE:1;
		unsigned int _USART6IE:1;
		unsigned int _USART7IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE2 (*((volatile union INT_EIE2_REG *)0x40200014))
// model

/** 0x4020 001C INT_EIF0 **/
union INT_EIF0_REG{
	unsigned int reg;
	struct INT_EIF0_BITS{
		unsigned int :2;
		unsigned int _NMIIF:1;
		unsigned int _HARDFAULTIF:1;
		unsigned int _ECCIF:1;
		unsigned int _STACKIF:1;
		unsigned int _ARIFAULTIF:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _SVCIF:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIF:1;
		unsigned int _SYSTICKIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF0 (*((volatile union INT_EIF0_REG *)0x4020001C))
// model

/** 0x4020 0024 INT_EIF1 **/
union INT_EIF1_REG{
	unsigned int reg;
	struct INT_EIF1_BITS{
		unsigned int _WWDTIF:1;
		unsigned int _EINT16IF:1;
		unsigned int _EINT0IF:1;
		unsigned int _EINT1IF:1;
		unsigned int _EINT2IF:1;
		unsigned int _EINT3IF:1;
		unsigned int _EINT4IF:1;
		unsigned int _EINT9TO5IF:1;
		unsigned int _EINT15TO10IF:1;
		unsigned int _T1IF:1;
		unsigned int _T3IF:1;
		unsigned int _T5IF:1;
		unsigned int _T6IF:1;
		unsigned int _QEIIF:1;
		unsigned int _CAN2IF:1;
		unsigned int _CAN3IF:1;
		unsigned int _CAN4IF:1;
		unsigned int _T14IF:1;
		unsigned int _T15IF:1;
		unsigned int _CAN5IF:1;
		unsigned int _EXIRIF:1;
		unsigned int _ADC0IF:1;
		unsigned int _ADC1IF:1;
		unsigned int _CFGLIF:1;
		unsigned int _LCDIF:1;
		unsigned int _T0IF:1;
		unsigned int _DMA0IF:1;
		unsigned int _CMPIF:1;
		unsigned int _USART0IF:1;
		unsigned int _USART1IF:1;
		unsigned int _SPI0IF:1;
		unsigned int _SPI1IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF1 (*((volatile union INT_EIF1_REG *)0x40200024))
// model

/** 0x4020 002C INT_EIF2 **/
union INT_EIF2_REG{
	unsigned int reg;
	struct INT_EIF2_BITS{
		unsigned int _DMA1IF:1;
		unsigned int _EINT19TO17IF:1;
		unsigned int _CAN0IF:1;
		unsigned int _CAN1IF:1;
		unsigned int _T9IF:1;
		unsigned int _T10IF:1;
		unsigned int _EINT21TO20IF:1;
		unsigned int _EINT31TO22IF:1;
		unsigned int _OSCIF:1;
		unsigned int _I2C0IF:1;
		unsigned int _I2C1IF:1;
		unsigned int _I2C2IF:1;
		unsigned int _USBIF:1;
		unsigned int _T2IF:1;
		unsigned int _T4IF:1;
		unsigned int _CTOUCHIF:1;
		unsigned int _USART2IF:1;
		unsigned int _USART3IF:1;
		unsigned int _USART4IF:1;
		unsigned int _SPI2IF:1;
		unsigned int _SPI3IF:1;
		unsigned int _ADC2IF:1;
		unsigned int _T18IF:1;
		unsigned int _T19IF:1;
		unsigned int _T22T23IF:1;
		unsigned int _WKPIF:1;
		unsigned int _T20IF:1;
		unsigned int _T21IF:1;
		unsigned int _I2C3IF:1;
		unsigned int _USART5IF:1;
		unsigned int _USART6IF:1;
		unsigned int _USART7IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF2 (*((volatile union INT_EIF2_REG *)0x4020002C))
// model

/** 0x4020 0034 INT_IP0 **/
union INT_IP0_REG{
	unsigned int reg;
	struct INT_IP0_BITS{
		unsigned int _PRI4:8;
		unsigned int _PRI5:8;
		unsigned int _PRI6:8;
		unsigned int _PRI7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP0 (*((volatile union INT_IP0_REG *)0x40200034))
// model

/** 0x4020 0038 INT_IP1 **/
union INT_IP1_REG{
	unsigned int reg;
	struct INT_IP1_BITS{
		unsigned int _PRI8:8;
		unsigned int _PRI9:8;
		unsigned int _PRI10:8;
		unsigned int _PRI11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP1 (*((volatile union INT_IP1_REG *)0x40200038))
// model

/** 0x4020 003C INT_IP2 **/
union INT_IP2_REG{
	unsigned int reg;
	struct INT_IP2_BITS{
		unsigned int _PRI12:8;
		unsigned int _PRI13:8;
		unsigned int _PRI14:8;
		unsigned int _PRI15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP2 (*((volatile union INT_IP2_REG *)0x4020003C))
// model

/** 0x4020 0040 INT_IP3 **/
union INT_IP3_REG{
	unsigned int reg;
	struct INT_IP3_BITS{
		unsigned int _PR16:8;
		unsigned int _PRI17:8;
		unsigned int _PRI18:8;
		unsigned int _PRI19:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP3 (*((volatile union INT_IP3_REG *)0x40200040))
// model

/** 0x4020 0044 INT_IP4 **/
union INT_IP4_REG{
	unsigned int reg;
	struct INT_IP4_BITS{
		unsigned int _PRI20:8;
		unsigned int _PRI21:8;
		unsigned int _PRI22:8;
		unsigned int _PRI23:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP4 (*((volatile union INT_IP4_REG *)0x40200044))
// model

/** 0x4020 0048 INT_IP5 **/
union INT_IP5_REG{
	unsigned int reg;
	struct INT_IP5_BITS{
		unsigned int _PRI24:8;
		unsigned int _PRI25:8;
		unsigned int _PRI26:8;
		unsigned int _PRI27:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP5 (*((volatile union INT_IP5_REG *)0x40200048))
// model

/** 0x4020 004C INT_IP6 **/
union INT_IP6_REG{
	unsigned int reg;
	struct INT_IP6_BITS{
		unsigned int _PRI28:8;
		unsigned int _PRI29:8;
		unsigned int _PRI30:8;
		unsigned int _PRI31:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP6 (*((volatile union INT_IP6_REG *)0x4020004C))
// model

/** 0x4020 0050 INT_IP7 **/
union INT_IP7_REG{
	unsigned int reg;
	struct INT_IP7_BITS{
		unsigned int _PRI32:8;
		unsigned int _PRI33:8;
		unsigned int _PRI34:8;
		unsigned int _PRI35:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP7 (*((volatile union INT_IP7_REG *)0x40200050))
// model

/** 0x4020 0054 INT_IP8 **/
union INT_IP8_REG{
	unsigned int reg;
	struct INT_IP8_BITS{
		unsigned int _PRI36:8;
		unsigned int _PRI37:8;
		unsigned int _PRI38:8;
		unsigned int _PRI39:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP8 (*((volatile union INT_IP8_REG *)0x40200054))
// model

/** 0x4020 0058 INT_IP9 **/
union INT_IP9_REG{
	unsigned int reg;
	struct INT_IP9_BITS{
		unsigned int _PRI40:8;
		unsigned int _PRI41:8;
		unsigned int _PRI42:8;
		unsigned int _PRI43:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP9 (*((volatile union INT_IP9_REG *)0x40200058))
// model

/** 0x4020 005C INT_IP10 **/
union INT_IP10_REG{
	unsigned int reg;
	struct INT_IP10_BITS{
		unsigned int _PRI44:8;
		unsigned int _PRI45:8;
		unsigned int _PRI46:8;
		unsigned int _PRI47:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP10 (*((volatile union INT_IP10_REG *)0x4020005C))
// model

/** 0x4020 0060 INT_IP11 **/
union INT_IP11_REG{
	unsigned int reg;
	struct INT_IP11_BITS{
		unsigned int _PRI48:8;
		unsigned int _PRI49:8;
		unsigned int _PRI50:8;
		unsigned int _PRI51:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP11 (*((volatile union INT_IP11_REG *)0x40200060))
// model

/** 0x4020 0064 INT_IP12 **/
union INT_IP12_REG{
	unsigned int reg;
	struct INT_IP12_BITS{
		unsigned int _PRI52:8;
		unsigned int _PRI53:8;
		unsigned int _PRI54:8;
		unsigned int _PRI55:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP12 (*((volatile union INT_IP12_REG *)0x40200064))
// model

/** 0x4020 0068 INT_IP13 **/
union INT_IP13_REG{
	unsigned int reg;
	struct INT_IP13_BITS{
		unsigned int _PRI56:8;
		unsigned int _PRI57:8;
		unsigned int _PRI58:8;
		unsigned int _PRI59:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP13 (*((volatile union INT_IP13_REG *)0x40200068))
// model

/** 0x4020 006C INT_IP14 **/
union INT_IP14_REG{
	unsigned int reg;
	struct INT_IP14_BITS{
		unsigned int _PRI60:8;
		unsigned int _PRI61:8;
		unsigned int _PRI62:8;
		unsigned int _PRI63:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP14 (*((volatile union INT_IP14_REG *)0x4020006C))
// model

/** 0x4020 0070 INT_IP15 **/
union INT_IP15_REG{
	unsigned int reg;
	struct INT_IP15_BITS{
		unsigned int _PRI64:8;
		unsigned int _PRI65:8;
		unsigned int _PRI66:8;
		unsigned int _PRI67:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP15 (*((volatile union INT_IP15_REG *)0x40200070))
// model

/** 0x4020 0074 INT_IP16 **/
union INT_IP16_REG{
	unsigned int reg;
	struct INT_IP16_BITS{
		unsigned int _PRI68:8;
		unsigned int _PRI69:8;
		unsigned int _PRI70:8;
		unsigned int _PRI71:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP16 (*((volatile union INT_IP16_REG *)0x40200074))
// model

/** 0x4020 0078 INT_IP17 **/
union INT_IP17_REG{
	unsigned int reg;
	struct INT_IP17_BITS{
		unsigned int _PRI72:8;
		unsigned int _PRI73:8;
		unsigned int _PRI74:8;
		unsigned int _PRI75:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP17 (*((volatile union INT_IP17_REG *)0x40200078))
// model

/** 0x4020 007C INT_IP18 **/
union INT_IP18_REG{
	unsigned int reg;
	struct INT_IP18_BITS{
		unsigned int _PRI76:8;
		unsigned int _PRI77:8;
		unsigned int _PRI78:8;
		unsigned int _PRI79:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP18 (*((volatile union INT_IP18_REG *)0x4020007C))
// model

/** 0x4020 0080 INT_EINTMASK **/
union INT_EINTMASK_REG{
	unsigned int reg;
	struct INT_EINTMASK_BITS{
		unsigned int _EINTM:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTMASK (*((volatile union INT_EINTMASK_REG *)0x40200080))
// model

/** 0x4020 0084 INT_EINTRISE **/
union INT_EINTRISE_REG{
	unsigned int reg;
	struct INT_EINTRISE_BITS{
		unsigned int _EINTRI:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTRISE (*((volatile union INT_EINTRISE_REG *)0x40200084))
// model

/** 0x4020 0088 INT_EINTFALL **/
union INT_EINTFALL_REG{
	unsigned int reg;
	struct INT_EINTFALL_BITS{
		unsigned int _EINTFA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTFALL (*((volatile union INT_EINTFALL_REG *)0x40200088))
// model

/** 0x4020 008C INT_EINTF **/
union INT_EINTF_REG{
	unsigned int reg;
	struct INT_EINTF_BITS{
		unsigned int _EINTIF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTF (*((volatile union INT_EINTF_REG *)0x4020008C))
// model

/** 0x4020 0094 INT_EINTSS0 **/
union INT_EINTSS0_REG{
	unsigned int reg;
	struct INT_EINTSS0_BITS{
		unsigned int _EINTSOU0:4;
		unsigned int _EINTSOU1:4;
		unsigned int _EINTSOU2:4;
		unsigned int _EINTSOU3:4;
		unsigned int _EINTSOU4:4;
		unsigned int _EINTSOU5:4;
		unsigned int _EINTSOU6:4;
		unsigned int _EINTSOU7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTSS0 (*((volatile union INT_EINTSS0_REG *)0x40200094))
// model

/** 0x4020 0098 INT_EINTSS1 **/
union INT_EINTSS1_REG{
	unsigned int reg;
	struct INT_EINTSS1_BITS{
		unsigned int _EINTSOU8:4;
		unsigned int _EINTSOU9:4;
		unsigned int _EINTSOU10:4;
		unsigned int _EINTSOU11:4;
		unsigned int _EINTSOU12:4;
		unsigned int _EINTSOU13:4;
		unsigned int _EINTSOU14:4;
		unsigned int _EINTSOU15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTSS1 (*((volatile union INT_EINTSS1_REG *)0x40200098))
// model

/** 0x4020 009C INT_CTL1 **/
union INT_CTL1_REG{
	unsigned int reg;
	struct INT_CTL1_BITS{
		unsigned int _INTDELY:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL1 (*((volatile union INT_CTL1_REG *)0x4020009C))
// modelST

/** 0x4020 00A0 ST_CTL **/
union ST_CTL_REG{
	unsigned int reg;
	struct ST_CTL_BITS{
		unsigned int _STEN:1;
		unsigned int _TICKINTEN:1;
		unsigned int _STCLKS:1;
		unsigned int :13;
		unsigned int _COUNTZERO:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CTL (*((volatile union ST_CTL_REG *)0x402000A0))
// model

/** 0x4020 00A4 ST_RELOAD **/
union ST_RELOAD_REG{
	unsigned int reg;
	struct ST_RELOAD_BITS{
		unsigned int _STRELOAD:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_RELOAD (*((volatile union ST_RELOAD_REG *)0x402000A4))
// model

/** 0x4020 00A8 ST_CV **/
union ST_CV_REG{
	unsigned int reg;
	struct ST_CV_BITS{
		unsigned int _STCV:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CV (*((volatile union ST_CV_REG *)0x402000A8))
// model

/** 0x4020 00AC ST_CALI **/
union ST_CALI_REG{
	unsigned int reg;
	struct ST_CALI_BITS{
		unsigned int _STCALIB:24;
		unsigned int :6;
		unsigned int _SKEW:1;
		unsigned int _STCLKREF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CALI (*((volatile union ST_CALI_REG *)0x402000AC))
// modelSYS

/** 0x4020 00B0 SYS_PSW **/
union SYS_PSW_REG{
	unsigned int reg;
	struct SYS_PSW_BITS{
		unsigned int :28;
		unsigned int _V:1;
		unsigned int _C:1;
		unsigned int _Z:1;
		unsigned int _N:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSW (*((volatile union SYS_PSW_REG *)0x402000B0))
// model

/** 0x4020 00B4 SYS_MCTL **/
union SYS_MCTL_REG{
	unsigned int reg;
	struct SYS_MCTL_BITS{
		unsigned int :1;
		unsigned int _SLEEPONEXIT:1;
		unsigned int _SLEEPDEEP:1;
		unsigned int :1;
		unsigned int _SLPONMOD:1;
		unsigned int :4;
		unsigned int _STACKALIGN:1;
		unsigned int :5;
		unsigned int _SUSTA:1;
		unsigned int _SPSEL:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MCTL (*((volatile union SYS_MCTL_REG *)0x402000B4))
// model

/** 0x4020 00B8 SYS_ARCTL **/
union SYS_ARCTL_REG{
	unsigned int reg;
	struct SYS_ARCTL_BITS{
		unsigned int :1;
		unsigned int _VECTRST:1;
		unsigned int _SYSTEMRST:1;
		unsigned int _IDC:1;
		unsigned int _CDMAR:1;
		unsigned int _CDMAAM:1;
		unsigned int :1;
		unsigned int :9;
		unsigned int _ARKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_ARCTL (*((volatile union SYS_ARCTL_REG *)0x402000B8))
// model

/** 0x4020 00BC SYS_VECTOFF **/
union SYS_VECTOFF_REG{
	unsigned int reg;
	struct SYS_VECTOFF_BITS{
		unsigned int _TBLOFF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_VECTOFF (*((volatile union SYS_VECTOFF_REG *)0x402000BC))
// model

/** 0x4020 00C4 SYS_RAMSPA **/
union SYS_RAMSPA_REG{
	unsigned int reg;
	struct SYS_RAMSPA_BITS{
		unsigned int _RAMSPA:26;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_RAMSPA (*((volatile union SYS_RAMSPA_REG *)0x402000C4))
// model

/** 0x4020 00C8 SYS_MEMCTL **/
union SYS_MEMCTL_REG{
	unsigned int reg;
	struct SYS_MEMCTL_BITS{
		unsigned int _MEMM0:1;
		unsigned int _MEMM1:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MEMCTL (*((volatile union SYS_MEMCTL_REG *)0x402000C8))
// modelFLASH

/** 0X4020 0100 FLASH_ISPCON0 **/
union FLASH_ISPCON0_REG{
	unsigned int reg;
	struct FLASH_ISPCON0_BITS{
		unsigned int _NVMLOCK:1;
		unsigned int _FLASHLOCK:1;
		unsigned int _CFGLOCK:1;
		unsigned int _DWEN:1;
		unsigned int _IFEN:1;
		unsigned int _STANDBY1:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCON0 (*((volatile union FLASH_ISPCON0_REG *)0x40200100))
// model

/** 0X4020 0104 FLASH_ISPCON1 **/
union FLASH_ISPCON1_REG{
	unsigned int reg;
	struct FLASH_ISPCON1_BITS{
		unsigned int _IPSEL:1;
		unsigned int _RECALLEN:1;
		unsigned int _CONFEN:1;
		unsigned int :12;
		unsigned int _CHIPONEM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCON1 (*((volatile union FLASH_ISPCON1_REG *)0x40200104))
// model

/** 0X4020 0108 FLASH_ISPCMD **/
union FLASH_ISPCMD_REG{
	unsigned int reg;
	struct FLASH_ISPCMD_BITS{
		unsigned int _CMD:5;
		unsigned int _WSIZE:6;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCMD (*((volatile union FLASH_ISPCMD_REG *)0x40200108))
// model

/** 0X4020 010C FLASH_ISPTRG **/
union FLASH_ISPTRG_REG{
	unsigned int reg;
	struct FLASH_ISPTRG_BITS{
		unsigned int _ISPG0:1;
		unsigned int :31;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPTRG (*((volatile union FLASH_ISPTRG_REG *)0x4020010C))
// model

/** 0X4020 0114 FLASH_CFG **/
union FLASH_CFG_REG{
	unsigned int reg;
	struct FLASH_CFG_BITS{
		unsigned int _TCFG:4;
		unsigned int :2;
		unsigned int _PREFETCHEN:1;
		unsigned int _ECCREADEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFG (*((volatile union FLASH_CFG_REG *)0x40200114))
// model

/** 0X4020 011C FLASH_ISPADDR **/
union FLASH_ISPADDR_REG{
	unsigned int reg;
	struct FLASH_ISPADDR_BITS{
		unsigned int _SADDR:20;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPADDR (*((volatile union FLASH_ISPADDR_REG *)0x4020011C))
// model

/** 0X4020 0120 FLASH_STATE **/
union FLASH_STATE_REG{
	unsigned int reg;
	struct FLASH_STATE_BITS{
		unsigned int _CFGERROR:1;
		unsigned int _SIGDONE:1;
		unsigned int _TBIT:1;
		unsigned int _TBUSY:1;
		unsigned int :8;
		unsigned int _BDBG:1;
		unsigned int _BDBGREM:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_STATE (*((volatile union FLASH_STATE_REG *)0x40200120))
// model

/** 0X4020 0128 FLASH_NVMUNLOCK **/
union FLASH_NVMUNLOCK_REG{
	unsigned int reg;
	struct FLASH_NVMUNLOCK_BITS{
		unsigned int _NVMUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_NVMUNLOCK (*((volatile union FLASH_NVMUNLOCK_REG *)0x40200128))
// model

/** 0X4020 012C FLASH_PROUNLOCK **/
union FLASH_PROUNLOCK_REG{
	unsigned int reg;
	struct FLASH_PROUNLOCK_BITS{
		unsigned int _PROUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_PROUNLOCK (*((volatile union FLASH_PROUNLOCK_REG *)0x4020012C))
// model

/** 0X4020 0130 FLASH_CFGUNLOCK **/
union FLASH_CFGUNLOCK_REG{
	unsigned int reg;
	struct FLASH_CFGUNLOCK_BITS{
		unsigned int _CFGUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFGUNLOCK (*((volatile union FLASH_CFGUNLOCK_REG *)0x40200130))
// model

/** 0X4020 0138 FLASH_CSSTART **/
union FLASH_CSSTART_REG{
	unsigned int reg;
	struct FLASH_CSSTART_BITS{
		unsigned int :4;
		unsigned int _CKSTADDR:16;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTART (*((volatile union FLASH_CSSTART_REG *)0x40200138))
// model

/** 0X4020 013C FLASH_CSSTOP **/
union FLASH_CSSTOP_REG{
	unsigned int reg;
	struct FLASH_CSSTOP_BITS{
		unsigned int :4;
		unsigned int _CKSPADDR:16;
		unsigned int _SIGG0:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTOP (*((volatile union FLASH_CSSTOP_REG *)0x4020013C))
// model

/** 0X4020 0140 FLASH_CSRES0 **/
union FLASH_CSRES0_REG{
	unsigned int reg;
	struct FLASH_CSRES0_BITS{
		unsigned int _CKSPRES0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES0 (*((volatile union FLASH_CSRES0_REG *)0x40200140))
// model

/** 0X4020 0144 FLASH_CSRES1 **/
union FLASH_CSRES1_REG{
	unsigned int reg;
	struct FLASH_CSRES1_BITS{
		unsigned int _CKSPRES1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES1 (*((volatile union FLASH_CSRES1_REG *)0x40200144))
// model

/** 0X4020 0148 FLASH_CSRES2 **/
union FLASH_CSRES2_REG{
	unsigned int reg;
	struct FLASH_CSRES2_BITS{
		unsigned int _CKSPRES2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES2 (*((volatile union FLASH_CSRES2_REG *)0x40200148))
// model

/** 0X4020 014C FLASH_CSRES3 **/
union FLASH_CSRES3_REG{
	unsigned int reg;
	struct FLASH_CSRES3_BITS{
		unsigned int _CKSPRES3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES3 (*((volatile union FLASH_CSRES3_REG *)0x4020014C))
// modelSYS

/** 0x4020 0200 SYS_CORETP0 **/
union SYS_CORETP0_REG{
	unsigned int reg;
	struct SYS_CORETP0_BITS{
		unsigned int _TP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_CORETP0 (*((volatile union SYS_CORETP0_REG *)0x40200200))
// model

/** 0x4020 0204 SYS_CORETP1 **/
union SYS_CORETP1_REG{
	unsigned int reg;
	struct SYS_CORETP1_BITS{
		unsigned int _TP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_CORETP1 (*((volatile union SYS_CORETP1_REG *)0x40200204))
// model

/** 0x4020 0208 SYS_CORETP2 **/
union SYS_CORETP2_REG{
	unsigned int reg;
	struct SYS_CORETP2_BITS{
		unsigned int _TP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_CORETP2 (*((volatile union SYS_CORETP2_REG *)0x40200208))
// model

/** 0x4020 020C SYS_CORETP3 **/
union SYS_CORETP3_REG{
	unsigned int reg;
	struct SYS_CORETP3_BITS{
		unsigned int _TP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_CORETP3 (*((volatile union SYS_CORETP3_REG *)0x4020020C))
// modelGPIOA

/** 0x5000 0000 GPIOA_PIR **/
union GPIOA_PIR_REG{
	unsigned int reg;
	struct GPIOA_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PIR (*((volatile union GPIOA_PIR_REG *)0x50000000))
// model

/** 0x5000 0004 GPIOA_POR **/
union GPIOA_POR_REG{
	unsigned int reg;
	struct GPIOA_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_POR (*((volatile union GPIOA_POR_REG *)0x50000004))
// model

/** 0x5000 0008 GPIOA_PUR **/
union GPIOA_PUR_REG{
	unsigned int reg;
	struct GPIOA_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PUR (*((volatile union GPIOA_PUR_REG *)0x50000008))
// model

/** 0x5000 000C GPIOA_PDR **/
union GPIOA_PDR_REG{
	unsigned int reg;
	struct GPIOA_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PDR (*((volatile union GPIOA_PDR_REG *)0x5000000C))
// model

/** 0x5000 0010 GPIOA_PODR **/
union GPIOA_PODR_REG{
	unsigned int reg;
	struct GPIOA_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PODR (*((volatile union GPIOA_PODR_REG *)0x50000010))
// model

/** 0x5000 0014 GPIOA_PMOD **/
union GPIOA_PMOD_REG{
	unsigned int reg;
	struct GPIOA_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PMOD (*((volatile union GPIOA_PMOD_REG *)0x50000014))
// model

/** 0x5000 0018 GPIOA_OMOD **/
union GPIOA_OMOD_REG{
	unsigned int reg;
	struct GPIOA_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_OMOD (*((volatile union GPIOA_OMOD_REG *)0x50000018))
// model

/** 0x5000 001C GPIOA_LOCK **/
union GPIOA_LOCK_REG{
	unsigned int reg;
	struct GPIOA_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_LOCK (*((volatile union GPIOA_LOCK_REG *)0x5000001C))
// model

/** 0x5000 0020 GPIOA_RMPL **/
union GPIOA_RMPL_REG{
	unsigned int reg;
	struct GPIOA_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPL (*((volatile union GPIOA_RMPL_REG *)0x50000020))
// model

/** 0x5000 0024 GPIOA_RMPH **/
union GPIOA_RMPH_REG{
	unsigned int reg;
	struct GPIOA_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPH (*((volatile union GPIOA_RMPH_REG *)0x50000024))
// modelGPIOB

/** 0x5000 0040 GPIOB_PIR **/
union GPIOB_PIR_REG{
	unsigned int reg;
	struct GPIOB_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PIR (*((volatile union GPIOB_PIR_REG *)0x50000040))
// model

/** 0x5000 0044 GPIOB_POR **/
union GPIOB_POR_REG{
	unsigned int reg;
	struct GPIOB_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_POR (*((volatile union GPIOB_POR_REG *)0x50000044))
// model

/** 0x5000 0048 GPIOB_PUR **/
union GPIOB_PUR_REG{
	unsigned int reg;
	struct GPIOB_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PUR (*((volatile union GPIOB_PUR_REG *)0x50000048))
// model

/** 0x5000 004C GPIOB_PDR **/
union GPIOB_PDR_REG{
	unsigned int reg;
	struct GPIOB_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PDR (*((volatile union GPIOB_PDR_REG *)0x5000004C))
// model

/** 0x5000 0050 GPIOB_PODR **/
union GPIOB_PODR_REG{
	unsigned int reg;
	struct GPIOB_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PODR (*((volatile union GPIOB_PODR_REG *)0x50000050))
// model

/** 0x5000 0054 GPIOB_PMOD **/
union GPIOB_PMOD_REG{
	unsigned int reg;
	struct GPIOB_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PMOD (*((volatile union GPIOB_PMOD_REG *)0x50000054))
// model

/** 0x5000 0058 GPIOB_OMOD **/
union GPIOB_OMOD_REG{
	unsigned int reg;
	struct GPIOB_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_OMOD (*((volatile union GPIOB_OMOD_REG *)0x50000058))
// model

/** 0x5000 005C GPIOB_LOCK **/
union GPIOB_LOCK_REG{
	unsigned int reg;
	struct GPIOB_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_LOCK (*((volatile union GPIOB_LOCK_REG *)0x5000005C))
// model

/** 0x5000 0060 GPIOB_RMPL **/
union GPIOB_RMPL_REG{
	unsigned int reg;
	struct GPIOB_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPL (*((volatile union GPIOB_RMPL_REG *)0x50000060))
// model

/** 0x5000 0064 GPIOB_RMPH **/
union GPIOB_RMPH_REG{
	unsigned int reg;
	struct GPIOB_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPH (*((volatile union GPIOB_RMPH_REG *)0x50000064))
// model

/** 0x5000 0068 GPIOB_UHS **/
union GPIOB_UHS_REG{
	unsigned int reg;
	struct GPIOB_UHS_BITS{
		unsigned int _UHSEN0:1;
		unsigned int _UHSEN1:1;
		unsigned int _UHSEN2:1;
		unsigned int _UHSEN3:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_UHS (*((volatile union GPIOB_UHS_REG *)0x50000068))
// modelGPIOC

/** 0x5000 0080 GPIOC_PIR **/
union GPIOC_PIR_REG{
	unsigned int reg;
	struct GPIOC_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PIR (*((volatile union GPIOC_PIR_REG *)0x50000080))
// model

/** 0x5000 0084 GPIOC_POR **/
union GPIOC_POR_REG{
	unsigned int reg;
	struct GPIOC_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_POR (*((volatile union GPIOC_POR_REG *)0x50000084))
// model

/** 0x5000 0088 GPIOC_PUR **/
union GPIOC_PUR_REG{
	unsigned int reg;
	struct GPIOC_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PUR (*((volatile union GPIOC_PUR_REG *)0x50000088))
// model

/** 0x5000 008C GPIOC_PDR **/
union GPIOC_PDR_REG{
	unsigned int reg;
	struct GPIOC_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PDR (*((volatile union GPIOC_PDR_REG *)0x5000008C))
// model

/** 0x5000 0090 GPIOC_PODR **/
union GPIOC_PODR_REG{
	unsigned int reg;
	struct GPIOC_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PODR (*((volatile union GPIOC_PODR_REG *)0x50000090))
// model

/** 0x5000 0094 GPIOC_PMOD **/
union GPIOC_PMOD_REG{
	unsigned int reg;
	struct GPIOC_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PMOD (*((volatile union GPIOC_PMOD_REG *)0x50000094))
// model

/** 0x5000 0098 GPIOC_OMOD **/
union GPIOC_OMOD_REG{
	unsigned int reg;
	struct GPIOC_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_OMOD (*((volatile union GPIOC_OMOD_REG *)0x50000098))
// model

/** 0x5000 009C GPIOC_LOCK **/
union GPIOC_LOCK_REG{
	unsigned int reg;
	struct GPIOC_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_LOCK (*((volatile union GPIOC_LOCK_REG *)0x5000009C))
// model

/** 0x5000 00A0 GPIOC_RMPL **/
union GPIOC_RMPL_REG{
	unsigned int reg;
	struct GPIOC_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPL (*((volatile union GPIOC_RMPL_REG *)0x500000A0))
// model

/** 0x5000 00A4 GPIOC_RMPH **/
union GPIOC_RMPH_REG{
	unsigned int reg;
	struct GPIOC_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPH (*((volatile union GPIOC_RMPH_REG *)0x500000A4))
// modelGPIOD

/** 0x5000 00C0 GPIOD_PIR **/
union GPIOD_PIR_REG{
	unsigned int reg;
	struct GPIOD_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PIR (*((volatile union GPIOD_PIR_REG *)0x500000C0))
// model

/** 0x5000 00C4 GPIOD_POR **/
union GPIOD_POR_REG{
	unsigned int reg;
	struct GPIOD_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_POR (*((volatile union GPIOD_POR_REG *)0x500000C4))
// model

/** 0x5000 00C8 GPIOD_PUR **/
union GPIOD_PUR_REG{
	unsigned int reg;
	struct GPIOD_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PUR (*((volatile union GPIOD_PUR_REG *)0x500000C8))
// model

/** 0x5000 00CC GPIOD_PDR **/
union GPIOD_PDR_REG{
	unsigned int reg;
	struct GPIOD_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PDR (*((volatile union GPIOD_PDR_REG *)0x500000CC))
// model

/** 0x5000 00D0 GPIOD_PODR **/
union GPIOD_PODR_REG{
	unsigned int reg;
	struct GPIOD_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PODR (*((volatile union GPIOD_PODR_REG *)0x500000D0))
// model

/** 0x5000 00D4 GPIOD_PMOD **/
union GPIOD_PMOD_REG{
	unsigned int reg;
	struct GPIOD_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PMOD (*((volatile union GPIOD_PMOD_REG *)0x500000D4))
// model

/** 0x5000 00D8 GPIOD_OMOD **/
union GPIOD_OMOD_REG{
	unsigned int reg;
	struct GPIOD_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_OMOD (*((volatile union GPIOD_OMOD_REG *)0x500000D8))
// model

/** 0x5000 00DC GPIOD_LOCK **/
union GPIOD_LOCK_REG{
	unsigned int reg;
	struct GPIOD_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_LOCK (*((volatile union GPIOD_LOCK_REG *)0x500000DC))
// model

/** 0x5000 00E0 GPIOD_RMPL **/
union GPIOD_RMPL_REG{
	unsigned int reg;
	struct GPIOD_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPL (*((volatile union GPIOD_RMPL_REG *)0x500000E0))
// model

/** 0x5000 00E4 GPIOD_RMPH **/
union GPIOD_RMPH_REG{
	unsigned int reg;
	struct GPIOD_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPH (*((volatile union GPIOD_RMPH_REG *)0x500000E4))
// modelGPIOE

/** 0x5000 0100 GPIOE_PIR **/
union GPIOE_PIR_REG{
	unsigned int reg;
	struct GPIOE_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PIR (*((volatile union GPIOE_PIR_REG *)0x50000100))
// model

/** 0x5000 0104 GPIOE_POR **/
union GPIOE_POR_REG{
	unsigned int reg;
	struct GPIOE_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_POR (*((volatile union GPIOE_POR_REG *)0x50000104))
// model

/** 0x5000 0108 GPIOE_PUR **/
union GPIOE_PUR_REG{
	unsigned int reg;
	struct GPIOE_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PUR (*((volatile union GPIOE_PUR_REG *)0x50000108))
// model

/** 0x5000 010C GPIOE_PDR **/
union GPIOE_PDR_REG{
	unsigned int reg;
	struct GPIOE_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PDR (*((volatile union GPIOE_PDR_REG *)0x5000010C))
// model

/** 0x5000 0110 GPIOE_PODR **/
union GPIOE_PODR_REG{
	unsigned int reg;
	struct GPIOE_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PODR (*((volatile union GPIOE_PODR_REG *)0x50000110))
// model

/** 0x5000 0114 GPIOE_PMOD **/
union GPIOE_PMOD_REG{
	unsigned int reg;
	struct GPIOE_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PMOD (*((volatile union GPIOE_PMOD_REG *)0x50000114))
// model

/** 0x5000 0118 GPIOE_OMOD **/
union GPIOE_OMOD_REG{
	unsigned int reg;
	struct GPIOE_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_OMOD (*((volatile union GPIOE_OMOD_REG *)0x50000118))
// model

/** 0x5000 011C GPIOE_LOCK **/
union GPIOE_LOCK_REG{
	unsigned int reg;
	struct GPIOE_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_LOCK (*((volatile union GPIOE_LOCK_REG *)0x5000011C))
// model

/** 0x5000 0120 GPIOE_RMPL **/
union GPIOE_RMPL_REG{
	unsigned int reg;
	struct GPIOE_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMPL (*((volatile union GPIOE_RMPL_REG *)0x50000120))
// model

/** 0x5000 0124 GPIOE_RMPH **/
union GPIOE_RMPH_REG{
	unsigned int reg;
	struct GPIOE_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMPH (*((volatile union GPIOE_RMPH_REG *)0x50000124))
// modelGPIOF

/** 0x5000 0140 GPIOF_PIR **/
union GPIOF_PIR_REG{
	unsigned int reg;
	struct GPIOF_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PIR (*((volatile union GPIOF_PIR_REG *)0x50000140))
// model

/** 0x5000 0144 GPIOF_POR **/
union GPIOF_POR_REG{
	unsigned int reg;
	struct GPIOF_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_POR (*((volatile union GPIOF_POR_REG *)0x50000144))
// model

/** 0x5000 0148 GPIOF_PUR **/
union GPIOF_PUR_REG{
	unsigned int reg;
	struct GPIOF_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PUR (*((volatile union GPIOF_PUR_REG *)0x50000148))
// model

/** 0x5000 014C GPIOF_PDR **/
union GPIOF_PDR_REG{
	unsigned int reg;
	struct GPIOF_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PDR (*((volatile union GPIOF_PDR_REG *)0x5000014C))
// model

/** 0x5000 0150 GPIOF_PODR **/
union GPIOF_PODR_REG{
	unsigned int reg;
	struct GPIOF_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PODR (*((volatile union GPIOF_PODR_REG *)0x50000150))
// model

/** 0x5000 0154 GPIOF_PMOD **/
union GPIOF_PMOD_REG{
	unsigned int reg;
	struct GPIOF_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PMOD (*((volatile union GPIOF_PMOD_REG *)0x50000154))
// model

/** 0x5000 0158 GPIOF_OMOD **/
union GPIOF_OMOD_REG{
	unsigned int reg;
	struct GPIOF_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_OMOD (*((volatile union GPIOF_OMOD_REG *)0x50000158))
// model

/** 0x5000 015C GPIOF_LOCK **/
union GPIOF_LOCK_REG{
	unsigned int reg;
	struct GPIOF_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_LOCK (*((volatile union GPIOF_LOCK_REG *)0x5000015C))
// model

/** 0x5000 0160 GPIOF_RMPL **/
union GPIOF_RMPL_REG{
	unsigned int reg;
	struct GPIOF_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMPL (*((volatile union GPIOF_RMPL_REG *)0x50000160))
// model

/** 0x5000 0164 GPIOF_RMPH **/
union GPIOF_RMPH_REG{
	unsigned int reg;
	struct GPIOF_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMPH (*((volatile union GPIOF_RMPH_REG *)0x50000164))
// modelGPIOG

/** 0x5000 0180 GPIOG_PIR **/
union GPIOG_PIR_REG{
	unsigned int reg;
	struct GPIOG_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PIR (*((volatile union GPIOG_PIR_REG *)0x50000180))
// model

/** 0x5000 0184 GPIOG_POR **/
union GPIOG_POR_REG{
	unsigned int reg;
	struct GPIOG_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_POR (*((volatile union GPIOG_POR_REG *)0x50000184))
// model

/** 0x5000 0188 GPIOG_PUR **/
union GPIOG_PUR_REG{
	unsigned int reg;
	struct GPIOG_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PUR (*((volatile union GPIOG_PUR_REG *)0x50000188))
// model

/** 0x5000 018C GPIOG_PDR **/
union GPIOG_PDR_REG{
	unsigned int reg;
	struct GPIOG_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PDR (*((volatile union GPIOG_PDR_REG *)0x5000018C))
// model

/** 0x5000 0190 GPIOG_PODR **/
union GPIOG_PODR_REG{
	unsigned int reg;
	struct GPIOG_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PODR (*((volatile union GPIOG_PODR_REG *)0x50000190))
// model

/** 0x5000 0194 GPIOG_PMOD **/
union GPIOG_PMOD_REG{
	unsigned int reg;
	struct GPIOG_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PMOD (*((volatile union GPIOG_PMOD_REG *)0x50000194))
// model

/** 0x5000 0198 GPIOG_OMOD **/
union GPIOG_OMOD_REG{
	unsigned int reg;
	struct GPIOG_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_OMOD (*((volatile union GPIOG_OMOD_REG *)0x50000198))
// model

/** 0x5000 019C GPIOG_LOCK **/
union GPIOG_LOCK_REG{
	unsigned int reg;
	struct GPIOG_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_LOCK (*((volatile union GPIOG_LOCK_REG *)0x5000019C))
// model

/** 0x5000 01A0 GPIOG_RMPL **/
union GPIOG_RMPL_REG{
	unsigned int reg;
	struct GPIOG_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMPL (*((volatile union GPIOG_RMPL_REG *)0x500001A0))
// model

/** 0x5000 01A4 GPIOG_RMPH **/
union GPIOG_RMPH_REG{
	unsigned int reg;
	struct GPIOG_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMPH (*((volatile union GPIOG_RMPH_REG *)0x500001A4))
// modelGPIOH

/** 0x5000 01C0 GPIOH_PIR **/
union GPIOH_PIR_REG{
	unsigned int reg;
	struct GPIOH_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PIR (*((volatile union GPIOH_PIR_REG *)0x500001C0))
// model

/** 0x5000 01C4 GPIOH_POR **/
union GPIOH_POR_REG{
	unsigned int reg;
	struct GPIOH_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_POR (*((volatile union GPIOH_POR_REG *)0x500001C4))
// model

/** 0x5000 01C8 GPIOH_PUR **/
union GPIOH_PUR_REG{
	unsigned int reg;
	struct GPIOH_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PUR (*((volatile union GPIOH_PUR_REG *)0x500001C8))
// model

/** 0x5000 01CC GPIOH_PDR **/
union GPIOH_PDR_REG{
	unsigned int reg;
	struct GPIOH_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PDR (*((volatile union GPIOH_PDR_REG *)0x500001CC))
// model

/** 0x5000 01D0 GPIOH_PODR **/
union GPIOH_PODR_REG{
	unsigned int reg;
	struct GPIOH_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PODR (*((volatile union GPIOH_PODR_REG *)0x500001D0))
// model

/** 0x5000 01D4 GPIOH_PMOD **/
union GPIOH_PMOD_REG{
	unsigned int reg;
	struct GPIOH_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PMOD (*((volatile union GPIOH_PMOD_REG *)0x500001D4))
// model

/** 0x5000 01D8 GPIOH_OMOD **/
union GPIOH_OMOD_REG{
	unsigned int reg;
	struct GPIOH_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_OMOD (*((volatile union GPIOH_OMOD_REG *)0x500001D8))
// model

/** 0x5000 01DC GPIOH_LOCK **/
union GPIOH_LOCK_REG{
	unsigned int reg;
	struct GPIOH_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_LOCK (*((volatile union GPIOH_LOCK_REG *)0x500001DC))
// model

/** 0x5000 01E0 GPIOH_RMPL **/
union GPIOH_RMPL_REG{
	unsigned int reg;
	struct GPIOH_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMPL (*((volatile union GPIOH_RMPL_REG *)0x500001E0))
// model

/** 0x5000 01E4 GPIOH_RMPH **/
union GPIOH_RMPH_REG{
	unsigned int reg;
	struct GPIOH_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMPH (*((volatile union GPIOH_RMPH_REG *)0x500001E4))
#endif
