//*****************************************************************************
//
// IQmathLib.h - IQmath library C language function definitions.
//
//*****************************************************************************

.ifndef __IQMATHLIB_H__
.equ __IQMATHLIB_H__,	1
 

//*****************************************************************************
//
// The IQ format to be used when the IQ format is not explicitly specified
// (such as _IQcos instead of _IQ16cos).  This value must be between 1 and 30,
// inclusive.
//
//*****************************************************************************

//*****************************************************************************
//
// Various Useful Constant Definitions:
//
//*****************************************************************************
.equ     MAX_IQ_POS,              0x7FFFFFFF
.equ     MAX_IQ_NEG,              0x80000000
.equ     MIN_IQ_POS,              1
.equ     MIN_IQ_NEG,              0xFFFFFFFF

//*****************************************************************************
//
// The types for the various IQ formats.
//
//*****************************************************************************

//*****************************************************************************
//
// Convert an IQ number to a floating point value.
//
//*****************************************************************************
.import _IQ30toF
.import  _IQ29toF
.import  _IQ28toF
.import  _IQ27toF
.import  _IQ26toF
.import  _IQ25toF
.import  _IQ24toF
.import  _IQ23toF
.import  _IQ22toF
.import  _IQ21toF
.import  _IQ20toF
.import  _IQ19toF
.import  _IQ18toF
.import  _IQ17toF
.import  _IQ16toF
.import  _IQ15toF
.import  _IQ14toF
.import  _IQ13toF
.import  _IQ12toF
.import  _IQ11toF
.import  _IQ10toF
.import  _IQ9toF
.import  _IQ8toF
.import  _IQ7toF
.import  _IQ6toF
.import  _IQ5toF
.import  _IQ4toF
.import  _IQ3toF
.import  _IQ2toF
.import  _IQ1toF
//*****************************************************************************
//
// Convert an IQ number to a double-precision floating point value.
//
//*****************************************************************************
.import _IQ30toD
.import _IQ29toD
.import _IQ28toD
.import _IQ27toD
.import _IQ26toD
.import _IQ25toD
.import _IQ24toD
.import _IQ23toD
.import _IQ22toD
.import _IQ21toD
.import _IQ20toD
.import _IQ19toD
.import _IQ18toD
.import _IQ17toD
.import _IQ16toD
.import _IQ15toD
.import _IQ14toD
.import _IQ13toD
.import _IQ12toD
.import _IQ11toD
.import _IQ10toD
.import _IQ9toD
.import _IQ8toD
.import _IQ7toD
.import _IQ6toD
.import _IQ5toD
.import _IQ4toD
.import _IQ3toD
.import _IQ2toD
.import _IQ1toD

//*****************************************************************************
//
// Multiplies two IQ numbers.
//
//*************************************************
.import  _IQ30mpy
.import  _IQ29mpy
.import  _IQ28mpy
.import  _IQ27mpy
.import  _IQ26mpy
.import  _IQ25mpy
.import  _IQ24mpy
.import  _IQ23mpy
.import  _IQ22mpy
.import  _IQ21mpy
.import  _IQ20mpy
.import  _IQ19mpy
.import  _IQ18mpy
.import  _IQ17mpy
.import  _IQ16mpy
.import  _IQ15mpy
.import  _IQ14mpy
.import  _IQ13mpy
.import  _IQ12mpy
.import  _IQ11mpy
.import  _IQ10mpy
.import _IQ9mpy
.import _IQ8mpy
.import _IQ7mpy
.import _IQ6mpy
.import _IQ5mpy
.import _IQ4mpy
.import _IQ3mpy
.import _IQ2mpy
.import _IQ1mpy



//*****************************************************************************
//
// Multiplies two IQ numbers, with rounding.
//
//*****************************************************************************
.import  _IQ30rmpy
.import  _IQ29rmpy
.import  _IQ28rmpy
.import  _IQ27rmpy
.import  _IQ26rmpy
.import  _IQ25rmpy
.import  _IQ24rmpy
.import  _IQ23rmpy
.import  _IQ22rmpy
.import  _IQ21rmpy
.import  _IQ20rmpy
.import  _IQ19rmpy
.import  _IQ18rmpy
.import  _IQ17rmpy
.import  _IQ16rmpy
.import  _IQ15rmpy
.import  _IQ14rmpy
.import  _IQ13rmpy
.import  _IQ12rmpy
.import  _IQ11rmpy
.import  _IQ10rmpy
.import _IQ9rmpy
.import _IQ8rmpy
.import _IQ7rmpy
.import _IQ6rmpy
.import _IQ5rmpy
.import _IQ4rmpy
.import _IQ3rmpy
.import _IQ2rmpy
.import _IQ1rmpy

//*****************************************************************************
//
// Multiplies two IQ numbers, with rounding and saturation.
//
//*****************************************************************************
.import   _IQ30rsmpy
.import   _IQ29rsmpy
.import   _IQ28rsmpy
.import   _IQ27rsmpy
.import   _IQ26rsmpy
.import   _IQ25rsmpy
.import   _IQ24rsmpy
.import   _IQ23rsmpy
.import   _IQ22rsmpy
.import   _IQ21rsmpy
.import   _IQ20rsmpy
.import   _IQ19rsmpy
.import   _IQ18rsmpy
.import   _IQ17rsmpy
.import   _IQ16rsmpy
.import   _IQ15rsmpy
.import   _IQ14rsmpy
.import   _IQ13rsmpy
.import   _IQ12rsmpy
.import   _IQ11rsmpy
.import   _IQ10rsmpy
.import  _IQ9rsmpy
.import  _IQ8rsmpy
.import  _IQ7rsmpy
.import  _IQ6rsmpy
.import  _IQ5rsmpy
.import  _IQ4rsmpy
.import  _IQ3rsmpy
.import  _IQ2rsmpy
.import  _IQ1rsmpy

//*****************************************************************************
//
// Divides two IQ numbers.
//
//*****************************************************************************
.import  _IQ30div
.import  _IQ29div
.import  _IQ28div
.import  _IQ27div
.import  _IQ26div
.import  _IQ25div
.import  _IQ24div
.import  _IQ23div
.import  _IQ22div
.import  _IQ21div
.import  _IQ20div
.import  _IQ19div
.import  _IQ18div
.import  _IQ17div
.import  _IQ16div
.import  _IQ15div
.import  _IQ14div
.import  _IQ13div
.import  _IQ12div
.import  _IQ11div
.import  _IQ10div
.import _IQ9div
.import _IQ8div
.import _IQ7div
.import _IQ6div
.import _IQ5div
.import _IQ4div
.import _IQ3div
.import _IQ2div
.import _IQ1div

//*****************************************************************************
//
// Computes the sin of an IQ number.
//
//*****************************************************************************
.import  _IQ30sin
.import  _IQ29sin
.import  _IQ28sin
.import  _IQ27sin
.import  _IQ26sin
.import  _IQ25sin
.import  _IQ24sin
.import  _IQ23sin
.import  _IQ22sin
.import  _IQ21sin
.import  _IQ20sin
.import  _IQ19sin
.import  _IQ18sin
.import  _IQ17sin
.import  _IQ16sin
.import  _IQ15sin
.import  _IQ14sin
.import  _IQ13sin
.import  _IQ12sin
.import  _IQ11sin
.import  _IQ10sin
.import _IQ9sin
.import _IQ8sin
.import _IQ7sin
.import _IQ6sin
.import _IQ5sin
.import _IQ4sin
.import _IQ3sin
.import _IQ2sin
.import _IQ1sin


//*****************************************************************************
//
// Computes the sin of an IQ number, using cycles per unit instead of radians.
//
//*****************************************************************************
.import  _IQ30sinPU
.import  _IQ29sinPU
.import  _IQ28sinPU
.import  _IQ27sinPU
.import  _IQ26sinPU
.import  _IQ25sinPU
.import  _IQ24sinPU
.import  _IQ23sinPU
.import  _IQ22sinPU
.import  _IQ21sinPU
.import  _IQ20sinPU
.import  _IQ19sinPU
.import  _IQ18sinPU
.import  _IQ17sinPU
.import  _IQ16sinPU
.import  _IQ15sinPU
.import  _IQ14sinPU
.import  _IQ13sinPU
.import  _IQ12sinPU
.import  _IQ11sinPU
.import  _IQ10sinPU
.import _IQ9sinPU
.import _IQ8sinPU
.import _IQ7sinPU
.import _IQ6sinPU
.import _IQ5sinPU
.import _IQ4sinPU
.import _IQ3sinPU
.import _IQ2sinPU
.import _IQ1sinPU


//*****************************************************************************
//
// Computes the arcsin of an IQ number.
//
//*****************************************************************************
.import  _IQ30asin
.import  _IQ29asin
.import  _IQ28asin
.import  _IQ27asin
.import  _IQ26asin
.import  _IQ25asin
.import  _IQ24asin
.import  _IQ23asin
.import  _IQ22asin
.import  _IQ21asin
.import  _IQ20asin
.import  _IQ19asin
.import  _IQ18asin
.import  _IQ17asin
.import  _IQ16asin
.import  _IQ15asin
.import  _IQ14asin
.import  _IQ13asin
.import  _IQ12asin
.import  _IQ11asin
.import  _IQ10asin
.import _IQ9asin
.import _IQ8asin
.import _IQ7asin
.import _IQ6asin
.import _IQ5asin
.import _IQ4asin
.import _IQ3asin
.import _IQ2asin
.import _IQ1asin

//*****************************************************************************
//
// Computes the cos of an IQ number.
//
//*****************************************************************************
.import  _IQ30cos
.import  _IQ29cos
.import  _IQ28cos
.import  _IQ27cos
.import  _IQ26cos
.import  _IQ25cos
.import  _IQ24cos
.import  _IQ23cos
.import  _IQ22cos
.import  _IQ21cos
.import  _IQ20cos
.import  _IQ19cos
.import  _IQ18cos
.import  _IQ17cos
.import  _IQ16cos
.import  _IQ15cos
.import  _IQ14cos
.import  _IQ13cos
.import  _IQ12cos
.import  _IQ11cos
.import  _IQ10cos
.import _IQ9cos
.import _IQ8cos
.import _IQ7cos
.import _IQ6cos
.import _IQ5cos
.import _IQ4cos
.import _IQ3cos
.import _IQ2cos
.import _IQ1cos

//*****************************************************************************
//
// Computes the cos of an IQ number, using cycles per unit instead of radians.
//
//*****************************************************************************
.import  _IQ30cosPU
.import  _IQ29cosPU
.import  _IQ28cosPU
.import  _IQ27cosPU
.import  _IQ26cosPU
.import  _IQ25cosPU
.import  _IQ24cosPU
.import  _IQ23cosPU
.import  _IQ22cosPU
.import  _IQ21cosPU
.import  _IQ20cosPU
.import  _IQ19cosPU
.import  _IQ18cosPU
.import  _IQ17cosPU
.import  _IQ16cosPU
.import  _IQ15cosPU
.import  _IQ14cosPU
.import  _IQ13cosPU
.import  _IQ12cosPU
.import  _IQ11cosPU
.import  _IQ10cosPU
.import _IQ9cosPU
.import _IQ8cosPU
.import _IQ7cosPU
.import _IQ6cosPU
.import _IQ5cosPU
.import _IQ4cosPU
.import _IQ3cosPU
.import _IQ2cosPU
.import _IQ1cosPU


//*****************************************************************************
//
// Computes the arctan of a coordinate specified by two IQ numbers.
//
//*****************************************************************************
.import  _IQ30atan2
.import  _IQ29atan2
.import  _IQ28atan2
.import  _IQ27atan2
.import  _IQ26atan2
.import  _IQ25atan2
.import  _IQ24atan2
.import  _IQ23atan2
.import  _IQ22atan2
.import  _IQ21atan2
.import  _IQ20atan2
.import  _IQ19atan2
.import  _IQ18atan2
.import  _IQ17atan2
.import  _IQ16atan2
.import  _IQ15atan2
.import  _IQ14atan2
.import  _IQ13atan2
.import  _IQ12atan2
.import  _IQ11atan2
.import  _IQ10atan2
.import  _IQ9atan2
.import  _IQ8atan2
.import  _IQ7atan2
.import  _IQ6atan2
.import  _IQ5atan2
.import  _IQ4atan2
.import  _IQ3atan2
.import  _IQ2atan2
.import  _IQ1atan2

//*****************************************************************************
//
// Computes the arctan of a coordinate specified by two IQ numbers, returning
// the value in cycles per unit instead of radians.
//
//*****************************************************************************
.import   _IQ30atan2PU
.import   _IQ29atan2PU
.import   _IQ28atan2PU
.import   _IQ27atan2PU
.import   _IQ26atan2PU
.import   _IQ25atan2PU
.import   _IQ24atan2PU
.import   _IQ23atan2PU
.import   _IQ22atan2PU
.import   _IQ21atan2PU
.import   _IQ20atan2PU
.import   _IQ19atan2PU
.import   _IQ18atan2PU
.import   _IQ17atan2PU
.import   _IQ16atan2PU
.import   _IQ15atan2PU
.import   _IQ14atan2PU
.import   _IQ13atan2PU
.import   _IQ12atan2PU
.import   _IQ11atan2PU
.import   _IQ10atan2PU
.import  _IQ9atan2PU
.import  _IQ8atan2PU
.import  _IQ7atan2PU
.import  _IQ6atan2PU
.import  _IQ5atan2PU
.import  _IQ4atan2PU
.import  _IQ3atan2PU
.import  _IQ2atan2PU
.import  _IQ1atan2PU


//*****************************************************************************
//
// Computes the square root of an IQ number.
//
//*****************************************************************************
.import  _IQ30sqrt
.import  _IQ29sqrt
.import  _IQ28sqrt
.import  _IQ27sqrt
.import  _IQ26sqrt
.import  _IQ25sqrt
.import  _IQ24sqrt
.import  _IQ23sqrt
.import  _IQ22sqrt
.import  _IQ21sqrt
.import  _IQ20sqrt
.import  _IQ19sqrt
.import  _IQ18sqrt
.import  _IQ17sqrt
.import  _IQ16sqrt
.import  _IQ15sqrt
.import  _IQ14sqrt
.import  _IQ13sqrt
.import  _IQ12sqrt
.import  _IQ11sqrt
.import  _IQ10sqrt
.import _IQ9sqrt
.import _IQ8sqrt
.import _IQ7sqrt
.import _IQ6sqrt
.import _IQ5sqrt
.import _IQ4sqrt
.import _IQ3sqrt
.import _IQ2sqrt
.import _IQ1sqrt


//*****************************************************************************
//
// Computes 1 over the square root of an IQ number.
//
//*****************************************************************************
.import  _IQ30isqrt
.import  _IQ29isqrt
.import  _IQ28isqrt
.import  _IQ27isqrt
.import  _IQ26isqrt
.import  _IQ25isqrt
.import  _IQ24isqrt
.import  _IQ23isqrt
.import  _IQ22isqrt
.import  _IQ21isqrt
.import  _IQ20isqrt
.import  _IQ19isqrt
.import  _IQ18isqrt
.import  _IQ17isqrt
.import  _IQ16isqrt
.import  _IQ15isqrt
.import  _IQ14isqrt
.import  _IQ13isqrt
.import  _IQ12isqrt
.import  _IQ11isqrt
.import  _IQ10isqrt
.import _IQ9isqrt
.import _IQ8isqrt
.import _IQ7isqrt
.import _IQ6isqrt
.import _IQ5isqrt
.import _IQ4isqrt
.import _IQ3isqrt
.import _IQ2isqrt
.import _IQ1isqrt


//*****************************************************************************
//
// Computes e^x of an IQ number.
//
//*****************************************************************************
.import  _IQ30exp
.import  _IQ29exp
.import  _IQ28exp
.import  _IQ27exp
.import  _IQ26exp
.import  _IQ25exp
.import  _IQ24exp
.import  _IQ23exp
.import  _IQ22exp
.import  _IQ21exp
.import  _IQ20exp
.import  _IQ19exp
.import  _IQ18exp
.import  _IQ17exp
.import  _IQ16exp
.import  _IQ15exp
.import  _IQ14exp
.import  _IQ13exp
.import  _IQ12exp
.import  _IQ11exp
.import  _IQ10exp
.import _IQ9exp
.import _IQ8exp
.import _IQ7exp
.import _IQ6exp
.import _IQ5exp
.import _IQ4exp
.import _IQ3exp
.import _IQ2exp
.import _IQ1exp


//*****************************************************************************
//
// Computes 2^x of an IQ number.
//
//*****************************************************************************
.import  _IQ30exp2
.import  _IQ29exp2
.import  _IQ28exp2
.import  _IQ27exp2
.import  _IQ26exp2
.import  _IQ25exp2
.import  _IQ24exp2
.import  _IQ23exp2
.import  _IQ22exp2
.import  _IQ21exp2
.import  _IQ20exp2
.import  _IQ19exp2
.import  _IQ18exp2
.import  _IQ17exp2
.import  _IQ16exp2
.import  _IQ15exp2
.import  _IQ14exp2
.import  _IQ13exp2
.import  _IQ12exp2
.import  _IQ11exp2
.import  _IQ10exp2
.import _IQ9exp2
.import _IQ8exp2
.import _IQ7exp2
.import _IQ6exp2
.import _IQ5exp2
.import _IQ4exp2
.import _IQ3exp2
.import _IQ2exp2
.import _IQ1exp2



//*****************************************************************************
//
// Computes the fractional portion of an IQ number.
//
//*****************************************************************************
.import  _IQ30frac
.import  _IQ29frac
.import  _IQ28frac
.import  _IQ27frac
.import  _IQ26frac
.import  _IQ25frac
.import  _IQ24frac
.import  _IQ23frac
.import  _IQ22frac
.import  _IQ21frac
.import  _IQ20frac
.import  _IQ19frac
.import  _IQ18frac
.import  _IQ17frac
.import  _IQ16frac
.import  _IQ15frac
.import  _IQ14frac
.import  _IQ13frac
.import  _IQ12frac
.import  _IQ11frac
.import  _IQ10frac
.import _IQ9frac
.import _IQ8frac
.import _IQ7frac
.import _IQ6frac
.import _IQ5frac
.import _IQ4frac
.import _IQ3frac
.import _IQ2frac
.import _IQ1frac





//*****************************************************************************
//
// Multiplies an IQ number by an integer, and returns the integer portion.
//
//*****************************************************************************
.import  _IQ30mpyI32int
.import  _IQ29mpyI32int
.import  _IQ28mpyI32int
.import  _IQ27mpyI32int
.import  _IQ26mpyI32int
.import  _IQ25mpyI32int
.import  _IQ24mpyI32int
.import  _IQ23mpyI32int
.import  _IQ22mpyI32int
.import  _IQ21mpyI32int
.import  _IQ20mpyI32int
.import  _IQ19mpyI32int
.import  _IQ18mpyI32int
.import  _IQ17mpyI32int
.import  _IQ16mpyI32int
.import  _IQ15mpyI32int
.import  _IQ14mpyI32int
.import  _IQ13mpyI32int
.import  _IQ12mpyI32int
.import  _IQ11mpyI32int
.import  _IQ10mpyI32int
.import _IQ9mpyI32int
.import _IQ8mpyI32int
.import _IQ7mpyI32int
.import _IQ6mpyI32int
.import _IQ5mpyI32int
.import _IQ4mpyI32int
.import _IQ3mpyI32int
.import _IQ2mpyI32int
.import _IQ1mpyI32int


//*****************************************************************************
//
// Multiplies an IQ number by an integer, and returns the fractional portion.
//
//*****************************************************************************
.import   _IQ30mpyI32frac
.import   _IQ29mpyI32frac
.import   _IQ28mpyI32frac
.import   _IQ27mpyI32frac
.import   _IQ26mpyI32frac
.import   _IQ25mpyI32frac
.import   _IQ24mpyI32frac
.import   _IQ23mpyI32frac
.import   _IQ22mpyI32frac
.import   _IQ21mpyI32frac
.import   _IQ20mpyI32frac
.import   _IQ19mpyI32frac
.import   _IQ18mpyI32frac
.import   _IQ17mpyI32frac
.import   _IQ16mpyI32frac
.import   _IQ15mpyI32frac
.import   _IQ14mpyI32frac
.import   _IQ13mpyI32frac
.import   _IQ12mpyI32frac
.import   _IQ11mpyI32frac
.import   _IQ10mpyI32frac
.import  _IQ9mpyI32frac
.import  _IQ8mpyI32frac
.import  _IQ7mpyI32frac
.import  _IQ6mpyI32frac
.import  _IQ5mpyI32frac
.import  _IQ4mpyI32frac
.import  _IQ3mpyI32frac
.import  _IQ2mpyI32frac
.import  _IQ1mpyI32frac


//*****************************************************************************
//
// Computes the square root of A^2 + B^2 using IQ numbers.
//
//*****************************************************************************
.import  _IQ30mag
.import  _IQ29mag
.import  _IQ28mag
.import  _IQ27mag
.import  _IQ26mag
.import  _IQ25mag
.import  _IQ24mag
.import  _IQ23mag
.import  _IQ22mag
.import  _IQ21mag
.import  _IQ20mag
.import  _IQ19mag
.import  _IQ18mag
.import  _IQ17mag
.import  _IQ16mag
.import  _IQ15mag
.import  _IQ14mag
.import  _IQ13mag
.import  _IQ12mag
.import  _IQ11mag
.import  _IQ10mag
.import _IQ9mag
.import _IQ8mag
.import _IQ7mag
.import _IQ6mag
.import _IQ5mag
.import _IQ4mag
.import _IQ3mag
.import _IQ2mag
.import _IQ1mag


//*****************************************************************************
//
// Converts a string into an IQ number.
//
//*****************************************************************************
.import _atoIQN

//*****************************************************************************
//
// Converts an IQ number into a string.
//
//*****************************************************************************
.import __IQNtoa

//*****************************************************************************
//
// Computes the absolute value of an IQ number.
//
//*****************************************************************************


//*****************************************************************************
//
// Computes the log value of an IQ number.
//
//*****************************************************************************
.import   _IQ30log
.import   _IQ29log
.import   _IQ28log
.import   _IQ27log
.import   _IQ26log
.import   _IQ25log
.import   _IQ24log
.import   _IQ23log
.import   _IQ22log
.import   _IQ21log
.import   _IQ20log
.import   _IQ19log
.import   _IQ18log
.import   _IQ17log
.import   _IQ16log
.import   _IQ15log
.import   _IQ14log
.import   _IQ13log
.import   _IQ12log
.import   _IQ11log
.import   _IQ10log
.import   _IQ9log
.import   _IQ8log
.import   _IQ7log
.import   _IQ6log
.import   _IQ5log
.import   _IQ4log
.import   _IQ3log
.import   _IQ2log
.import   _IQ1log



.endif // __IQMATHLIB_H__
