/* Definitions of target machine for GNU compiler,
   for KungFu32 Processor.
   Copyright (C) 1993, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2007,
   2008, 2009 Free Software Foundation, Inc.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 3, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

#ifndef GCC_KUNGFU32_H
#define GCC_KUNGFU32_H

#define _KF32_V1_r0_r15	1

#define HAVE_PRE_MODIFY_REG  1
#define HAVE_POST_INCREMENT 1
#define HAVE_PRE_DECREMENT  1
#define HAVE_POST_DECREMENT  1
#define HAVE_PRE_INCREMENT  1
#define HAVE_POST_INCREMENT  1

/* RBE: need to move these elsewhere.  */
#undef	LIKE_PPC_ABI 
#define	KUNGFU32_STRUCT_ARGS
/* RBE: end of "move elsewhere".  */

/* Run-time Target Specification.  */
#define TARGET_KUNGFU32

#define TARGET_DEFAULT 0

/* Get tree.c to declare a target-specific specialization of
   merge_decl_attributes.  */
#define TARGET_DLLIMPORT_DECL_ATTRIBUTES 1

#define TARGET_CPU_CPP_BUILTINS()					  \
  do									  \
    {									  \
      builtin_define ("NO_TRAMPOLINES");					  \
      builtin_define ("__SOFTFP__");            \
      builtin_define ("__kf32__");            \
      builtin_define ("__kungfu32__");            \
    }									  \
  while (0)


#include "config/kf32/kf32-opts.h"

#undef  CPP_SPEC
#define CPP_SPEC "%{m210:%{mlittle-endian:%ethe m210 does not have little endian support}}"

/* We don't have a -lg library, so don't put it in the list.  */
#undef	LIB_SPEC
#define LIB_SPEC "%{!shared: %{!p:%{!pg:-lc}}%{p:-lc_p}%{pg:-lc_p}}"

#undef	ASM_SPEC
#define	ASM_SPEC "%{mbig-endian:-EB} %{m210:-cpu=210 -EB}"

#undef  LINK_SPEC
#define LINK_SPEC "%{mbig-endian:-EB} %{m210:-EB} -X"


#ifndef TARGET_DEFAULT_PUSH_ABI

  #ifdef   Is_Not_Use_PushList_Command
    #define TARGET_DEFAULT_PUSH_ABI KF32_PUSH_ABI_NoList
  #else
    #ifdef Is_Use_PushList_Command_ButResaveLR
      #define TARGET_DEFAULT_PUSH_ABI KF32_PUSH_ABI_ListButLR
    #else
      #define TARGET_DEFAULT_PUSH_ABI KF32_PUSH_ABI_ALLList
    #endif
  #endif
  
#endif

#define Is_Use_PushList_Command_ABI   (kf32_push_abi == KF32_PUSH_ABI_ALLList)

#define Is_Use_PushList_Command_ButResaveLR_ABI   (kf32_push_abi == KF32_PUSH_ABI_ListButLR)

#define Is_Not_Use_PushList_Command_ABI   (kf32_push_abi == KF32_PUSH_ABI_NoList)

#ifndef TARGET_DEFAULT_FUNCTION_ABI
#define TARGET_DEFAULT_FUNCTION_ABI 	KF32_Function_ABI_V2
#endif

/* Handle pragmas for compatibility with Intel's compilers.  */
/* Also abuse this to register additional C specific EABI attributes.  */
#define REGISTER_TARGET_PRAGMAS() do {					\
  c_register_pragma (0, "long_calls", kungfu32_pr_long_calls);		\
  c_register_pragma (0, "no_long_calls", kungfu32_pr_no_long_calls);		\
  c_register_pragma (0, "long_calls_off", kungfu32_pr_long_calls_off);	\
  c_register_pragma ("kungfu32", "section",   kungfu32_pragma_section); \
} while (0)

enum KUNGFU32_section_kind
{ 
  KUNGFU32_SECTION_KIND_DEFAULT,

  KUNGFU32_SECTION_KIND_TEXT,

  KUNGFU32_SECTION_KIND_RODATA,
  KUNGFU32_SECTION_KIND_RDATA,
  
  KUNGFU32_SECTION_KIND_DATA, 
  KUNGFU32_SECTION_KIND_BSS,

  KUNGFU32_SECTION_KIND_INDATA,
  KUNGFU32_SECTION_KIND_INRODATA,
  KUNGFU32_SECTION_KIND_INRDATA,
  
  KUNGFU32_SECTION_KIND_SDATA,
  COUNT_OF_KUNGFU32_SECTION_KINDS  /* must be last */
};

/* Names of the various data areas used on the v850.  */
extern tree KUNGFU32_default_section_names [(int) COUNT_OF_KUNGFU32_SECTION_KINDS];
extern tree KUNGFU32_current_section_names [(int) COUNT_OF_KUNGFU32_SECTION_KINDS];

#ifndef MULTILIB_DEFAULTS
#define MULTILIB_DEFAULTS { "mlittle-endian", "kf32" }
#endif

/* The ability to have 4 byte alignment is being suppressed for now.
   If this ability is reenabled, you must disable the definition below
   *and* edit t-kungfu32 to enable multilibs for 4 byte alignment code.  */
#undef TARGET_8ALIGN
#define TARGET_8ALIGN 1

extern char * kungfu32_current_function_name;
 
/* The KungFu32 ABI says that bitfields are unsigned by default.  */
#define CC1_SPEC "-funsigned-bitfields"

/* Target machine storage Layout.  */

#define PROMOTE_MODE(MODE,UNSIGNEDP,TYPE)  	\
  if (GET_MODE_CLASS (MODE) == MODE_INT         \
      && GET_MODE_SIZE (MODE) < UNITS_PER_WORD) \
    {						\
        if((MODE) == QImode) \
        UNSIGNEDP = 1;\
        if((MODE) == HImode) \
        UNSIGNEDP = 1;\
        (MODE) = SImode;				\
    }


/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields.  */
#define BITS_BIG_ENDIAN  0

/* Define this if most significant byte of a word is the lowest numbered.  */
#define BYTES_BIG_ENDIAN 0 

/* KF32 only support little-endian layout  */
#define WORDS_BIG_ENDIAN 0 


#define MAX_BITS_PER_WORD 32

/* Width of a word, in units (bytes).  */
#define UNITS_PER_WORD	4

/* A C expression for the size in bits of the type `long long' on the
   target machine.  If you don't define this, the default is two
   words.  */
#define LONG_LONG_TYPE_SIZE 64

/* wchar_t is unsigned short.  */
#undef WCHAR_TYPE
#define WCHAR_TYPE "short unsigned int"
#define WCHAR_TYPE_SIZE 16

/* Allocation boundary (in *bits*) for storing arguments in argument list.  */
#define PARM_BOUNDARY  	32

/* Boundary (in *bits*) on which stack pointer should be aligned.  */
#define STACK_BOUNDARY   32

/* Largest increment in UNITS we allow the stack to grow in a single operation.  */
extern int kungfu32_stack_increment;
#define STACK_UNITS_MAXSTEP  4096

/* Allocation boundary (in *bits*) for the code of a function.  */
#define FUNCTION_BOUNDARY   32 

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY  32

/* No data type wants to be aligned rounder than this.  */
#define BIGGEST_ALIGNMENT   32

/* The best alignment to use in cases where we have a choice.  */
#define FASTEST_ALIGNMENT 32

/* Every structures size must be a multiple of 8 bits.  */
#define STRUCTURE_SIZE_BOUNDARY 8

/* Look at the fundamental type that is used for a bit-field and use 
   that to impose alignment on the enclosing structure.
   struct s {int a:8}; should have same alignment as "int", not "char".  */
#define	PCC_BITFIELD_TYPE_MATTERS	1

/* Largest integer machine mode for structures.  If undefined, the default
   is GET_MODE_SIZE(DImode).  */
#define MAX_FIXED_MODE_SIZE 32

/* Make strings word-aligned so strcpy from constants will be faster.  */
#define CONSTANT_ALIGNMENT(EXP, ALIGN)  \
  ((TREE_CODE (EXP) == STRING_CST	\
    && (ALIGN) < FASTEST_ALIGNMENT)	\
   ? FASTEST_ALIGNMENT : (ALIGN))

/* Make arrays of chars word-aligned for the same reasons.  */
#define DATA_ALIGNMENT(TYPE, ALIGN)		\
  (TREE_CODE (TYPE) == ARRAY_TYPE		\
   && TYPE_MODE (TREE_TYPE (TYPE)) == QImode	\
   && (ALIGN) < FASTEST_ALIGNMENT ? FASTEST_ALIGNMENT : (ALIGN))
     
/* Set this nonzero if move instructions will actually fail to work
   when given unaligned data.  */
#define STRICT_ALIGNMENT 1

/* Standard register usage.  */

/* Register allocation for our first guess 

	r0-r4		arguments
	r0-r1   return value
	r5		    scratch
	r6      frame pointer
	r7-r12		call saved regs.
	r13		    link register
	r14         stack pointer
	r15         pc
	ap		arg pointer (doesn't really exist, always eliminated)
	c               c bit
	fp		frame pointer (doesn't really exist, always eliminated)
*/
/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.
   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.

   KungFu32 has 16 integer registers and 2 control registers + the arg
   pointer.  */

#define FIRST_PSEUDO_REGISTER 18 

#define R0_REG  0	/* Where literals are forced.  */
#define R1_REG  1	/* Where literals are forced.  */
#define SCRATCH_REG  5	/* scratch reg to update the sp.  */
#define LK_REG	13	/* Overloaded on general register.  */
#define AP_REG  16	/* Fake arg pointer register.  */
/* RBE: kungfu32.md depends on CC_REG being set to 18.  */
#define CC_REG	17	/* Can't name it C_REG.  */
#define FIRST_REG_TO_SAVE 6
#define LAST_REG_TO_SAVE 13
/* Specify the registers used for certain standard purposes.
   The values of these macros are register numbers.  */


#define PC_REGNUM  15 /* Define this if the program counter is overloaded on a register.  */
#define STACK_POINTER_REGNUM 14 /* Register to use for pushing function arguments.  */
#define FRAME_POINTER_REGNUM 6 /* When we need FP, use r6.  */

/* The assembler's names for the registers.  RFP need not always be used as
   the Real framepointer; it can also be used as a normal general register.
   Note that the name `fp' is horribly misleading since `fp' is in fact only
   the argument-and-return-context pointer.  */
#if _KF32_V1_r0_r15
#define REGISTER_NAMES  				\
{				                   	\
  "r0", "r1", "r2",  "r3",  "r4",  "r5",  "r6",  "r7", 	\
  "r8", "r9", "r10", "r11", "r12", "lr", "sp", "pc",	\
  "apvirtual",  "c"\
}
#else
		#define REGISTER_NAMES  				\
		{				                   	\
		  "r0", "r1", "r2",  "r3",  "r4",  "r5",  "r6",  "r7", 	\
		  "r8", "r9", "r10", "r11", "r12", "lr", "sp", "pc",	\
		  "r16", "r17", "r18",  "r19",  "r20",  "r21",  "r22",  "r23", 	\
		  "r24", "r25", "r26",  "r27",  "r28",  "r29",  "r30",  "r31", 	\
		  "apvirtual",  "c"\
		}
#endif

#if _KF32_V1_r0_r15
/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.  */
#define FIXED_REGISTERS  \
 /*  r0  r1  r2  r3  r4  r5  r6  r7  r8  r9  r10 r11 r12 lr  sp  pc */ \
   {  0,  0,   0,  0,   0,  0,   0,  0,   0,   0,  0,    0,     0,  0,  1,  1, \
 /*  vap c */ \
     1,  1}
#else
		/* 1 for registers that have pervasive standard uses
		   and are not available for the register allocator.  */
		#define FIXED_REGISTERS  \
		 /*  r0  r1  r2  r3  r4  r5  r6  r7  r8  r9  r10 r11 r12 lr  sp  pc */ \
		   { 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1, \
		 /*  r16 r17 r18 r19 r20 r21 r22 r23 r24 r25 r26 r27 r28 r29 r30 r31 */ \
			 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,\
		 /*  vap c */ \
		     1,  1}
#endif

/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you like.  */

#if _KF32_V1_r0_r15
#define CALL_USED_REGISTERS \
 /*  r0  r1  	r2  r3  r4  	r5   r6  r7  r8  r9  r10 r11 r12 lr  sp  pc */ \
   { 1,  1,  	1,  1,  1,  	1,  	0,  0,  0,   0,   0,  0,    0,     0,   1,  1, \
 /*  vap c*/ \
     1,  1}
#else
		#define CALL_USED_REGISTERS \
		 /*  r0  r1  r2  r3  r4  r5  r6  r7  r8  r9  r10 r11 r12 lr  sp  pc */ \
		   { 1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  1, \
		 /*  r16 r17 r18 r19 r20 r21 r22 r23 r24 r25 r26 r27 r28 r29 r30 r31*/ \
			 1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0, \
		 /*  vap c*/ \
		     1,  1}
#endif

#if _KF32_V1_r0_r15
#define REG_ALLOC_ORDER  \
 /*r5  r4   r3   r2  r1  r0   r6  r7  r8   r9   r10    r11   r12   lr    sp   	pc */ \
  { 5,   4,   3,    2,  1,   0,   6,  7,  8,    9,    10,     11,   12,    13,   14,     15, \
/*vap c*/ \
  16, 17}
#else
	#define REG_ALLOC_ORDER  \
		 /*r5  r4   r3   r2  r1  r0  r6 r7 r8  r9  r10  r11  r12   lr  sp   pc */ \
		  {5,  4,   3,   2,  1,  0,  6, 7, 8,  9,  10,  11,  12,  13, 14,  15, \
		 /*r16 r17  r18  r19 r20 r21 r22 r23 r24 r25 r26 r27 r28 r29 r30 r31*/ \
		   16, 17,  18,  19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, \
		/*vap c*/ \
		  32, 33}
#endif

/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.

   On the KungFu32 regs are UNITS_PER_WORD bits wide; */
#define HARD_REGNO_NREGS(REGNO, MODE)  \
   (((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD))

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE.
   We may keep double values in even registers.  */
#if 0
#define HARD_REGNO_MODE_OK(REGNO, MODE)  \
  (GET_MODE_SIZE (MODE) > UNITS_PER_WORD ? (((REGNO) & 1) == 0) : (REGNO < 16))
#endif

#if _KF32_V1_r0_r15
#define HARD_REGNO_MODE_OK(REGNO, MODE)  \
  (GET_MODE_SIZE (MODE) > UNITS_PER_WORD ? (REGNO < 13) : (REGNO < 16))
#else
		#define HARD_REGNO_MODE_OK(REGNO, MODE)  \
			  (GET_MODE_SIZE (MODE) > UNITS_PER_WORD ? (REGNO < 13 || \
									((REGNO) >= 16 && ((REGNO) & 1) == 0)) : (REGNO < 32))
#endif

/* Value is 1 if it is a good idea to tie two pseudo registers
   when one has mode MODE1 and one has mode MODE2.
   If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
   for any hard reg, then this must be 0 for correct output.  */
#define MODES_TIEABLE_P(MODE1, MODE2) \
  ((MODE1) == (MODE2) || GET_MODE_CLASS (MODE1) == GET_MODE_CLASS (MODE2))

/* Definitions for register eliminations.

   We have two registers that can be eliminated on the KungFu32.  First, the
   frame pointer register can often be eliminated in favor of the stack
   pointer register.  Secondly, the argument pointer register can always be
   eliminated; it is replaced with either the stack or frame pointer.  */

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM	16

/* Register in which the static-chain is passed to a function.  */
#define STATIC_CHAIN_REGNUM 5	

/* This is an array of structures.  Each structure initializes one pair
   of eliminable registers.  The "from" register number is given first,
   followed by "to".  Eliminations of the same "from" register are listed
   in order of preference.  */
/* ld/stw  Rn  , [sp+offset8]. the range of the Rn is from R0 to R7.
 I do not think we can eliminate the fp and ap with the sp*/
#define ELIMINABLE_REGS				\
{{ ARG_POINTER_REGNUM, STACK_POINTER_REGNUM},	\
 { ARG_POINTER_REGNUM,   FRAME_POINTER_REGNUM},	\
 { FRAME_POINTER_REGNUM,   STACK_POINTER_REGNUM},}

/* Define the offset between two registers, one to be eliminated, and the other
   its replacement, at the start of a routine.  */
#define INITIAL_ELIMINATION_OFFSET(FROM, TO, OFFSET) \
  OFFSET = kf32_initial_elimination_offset (FROM, TO)

/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.
 
   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */

/* The KungFu32 has only general registers. There are
   also some special purpose registers: the T bit register, the
   procedure Link and the Count Registers.  */
enum reg_class
{
  NO_REGS,
  LOW_REGS,
  HIGH_REGS,
  BASE_REGS,
  GENERAL_REGS,
  C_REGS,
  ALL_REGS,
  LIM_REG_CLASSES
};

#define N_REG_CLASSES  (int) LIM_REG_CLASSES

/* Give names of register classes as strings for dump file.  */
#define REG_CLASS_NAMES  \
{			\
  "NO_REGS",		\
  "LOW_REGS",		\
  "HIGH_REGS",		\
  "BASE_REGS",		\
  "GENERAL_REGS",	\
  "C_REGS",		\
  "ALL_REGS",		\
}

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

/* ??? STACK_POINTER_REGNUM should be excluded from LRW_REGS.  */
#if _KF32_V1_r0_r15
#define REG_CLASS_CONTENTS      	\
{					\
  {0x00000000},  /* NO_REGS       */	\
  {0x000000FF},  /* LOW_REGS      */	\
  {0x0000FF00},  /* HIGH_REGS      */	\
  {0x000040FF},  /* BASE_REGS      */	\
  {0x0001FFFF},  /* GENERAL_REGS  */	\
  {0x00020000},  /* C_REGS        */	\
  {0x0003FFFF}   /* ALL_REGS      */	\
}
#else
	#define REG_CLASS_CONTENTS      	\
		{					\
		  {0x00000000,0x00000000},  /* NO_REGS       */	\
		  {0x000000FF,0x00000000},  /* LOW_REGS      */	\
		  {0x0000FF00,0x00000000},  /* HIGH_REGS      */	\
		  {0x0000FFFF,0x00000000},  /* L_REGS      */	\
		  {0xFFFF0000,0x00000000},  /* H_REGS      */	\
		  {0xFFFFFFFF,0x00000000},  /* BASE_REGS      */	\
		  {0xFFFFFFFF,0x00000001},  /* GENERAL_REGS  */	\
		  {0x00000000,0x00000002},  /* C_REGS        */	\
		  {0xFFFFFFFF,0x00000003}   /* ALL_REGS      */	\
		}
#endif
/* The same information, inverted:
   Return the class number of the smallest class containing
   reg number REGNO.  This could be a conditional expression
   or could index an array.  */

extern const enum reg_class regno_reg_class[FIRST_PSEUDO_REGISTER];
#define REGNO_REG_CLASS(REGNO) regno_reg_class[REGNO]

/* The class value for index registers, and the one for base regs.  */
#define INDEX_REG_CLASS  LOW_REGS

#if _KF32_V1_r0_r15
#define MODE_CODE_BASE_REG_CLASS(MODE, AS,OCODE, ICODE)	\
(GET_MODE_SIZE(MODE) <= 4 ?\
((OCODE) == POST_INC ? GENERAL_REGS:\
((OCODE) == MEM && (ICODE) == SCRATCH) ? GENERAL_REGS:\
((OCODE) == PLUS && (ICODE) == REG) ? LOW_REGS:\
((OCODE) == PLUS && (ICODE) == CONST_INT && (GET_MODE_SIZE(MODE) == 4)) ? BASE_REGS :\
((OCODE) == PLUS && (ICODE) == CONST_INT) ? LOW_REGS: NO_REGS):\
((OCODE) == PRE_INC ? GENERAL_REGS:\
((OCODE) == MEM && (ICODE) == SCRATCH) ? BASE_REGS:\
((OCODE) == PLUS && (ICODE) == REG) ? LOW_REGS:\
((OCODE) == PLUS && (ICODE) == CONST_INT) ? BASE_REGS : NO_REGS)\
)
#else
	#define MODE_CODE_BASE_REG_CLASS(MODE, AS,OCODE, ICODE)	\
		((OCODE) == POST_INC ? BASE_REGS:\
		((OCODE) == MEM && ((ICODE) == SCRATCH || ((ICODE) == REG))) ? BASE_REGS:\
		((OCODE) == PLUS && (ICODE) == REG) ? BASE_REGS:\
		((OCODE) == PLUS && (ICODE) == CONST_INT) ? BASE_REGS: NO_REGS)
#endif

/*can not use sp + reg to access the memory*/

/*#define MODE_BASE_REG_REG_CLASS(MODE)	 LOW_REGS*/

/* Get reg_class from a letter such as appears in the machine 
   description.  */
extern const enum reg_class reg_class_from_letter[];

/* The letters I, J, K, L, M, N, O, and P in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.
	I: loadable by movl/movh (0..0xffff)
	J: offset within the ld Rn, sp+offset8 instruction(0..0xff)
	K: the arithmetic operand 0..0x7f
	L: the shift immediate  0..31
	P: the triple arithmetic operand 0..7
	M: powers of two, constants loadable by bgeni
	N: powers of two minus 1, constants loadable by bmaski, including -1
        O: allowed by cmov with two constants +/- 1 of each other

   Others defined for use after reload
        Q: constant 1
	R: a label
        S: 0/1/2 cleared bits out of 32	[for bclri's]
        T: 2 set bits out of 32	[for bseti's]
        U: constant 0
        xxxS: 1 cleared bit out of 32 (complement of power of 2). for bclri
        xxxT: 2 cleared bits out of 32. for pairs of bclris.  */
#define CONST_OK_FOR_I(VALUE) (((HOST_WIDE_INT)(VALUE)) >= 0 && ((HOST_WIDE_INT)(VALUE)) <= 0xffff) 
#define CONST_OK_FOR_J(VALUE) (((HOST_WIDE_INT)(VALUE)) >= 0 && ((HOST_WIDE_INT)(VALUE)) <= 0xff) 
#define CONST_OK_FOR_K(VALUE) (((HOST_WIDE_INT)(VALUE)) >= 0 && ((HOST_WIDE_INT)(VALUE)) <= 0x7f)
#define CONST_OK_FOR_L(VALUE) (((HOST_WIDE_INT)(VALUE)) >= 0 && ((HOST_WIDE_INT)(VALUE)) <= 31)
#define CONST_OK_FOR_P(VALUE) (((HOST_WIDE_INT)(VALUE)) >= 0 && ((HOST_WIDE_INT)(VALUE)) <= 7)
#define CONST_OK_FOR_M(VALUE) (((HOST_WIDE_INT)(VALUE)) >= 0 && ((HOST_WIDE_INT)(VALUE)) <= 3)

#define CONST_OK_FOR_N(VALUE) (((HOST_WIDE_INT)(VALUE)) == -1 || (exact_log2 ((VALUE) + 1) >= 0 && exact_log2 ((VALUE) + 1) <= 30))

#define CONST_OK_FOR_O(VALUE) (CONST_OK_FOR_I(VALUE) || \
                               CONST_OK_FOR_M(VALUE) || \
                               CONST_OK_FOR_N(VALUE) || \
                               CONST_OK_FOR_M((HOST_WIDE_INT)(VALUE) - 1) || \
                               CONST_OK_FOR_N((HOST_WIDE_INT)(VALUE) + 1))



/* Similar, but for floating constants, and defining letters G and H.
   Here VALUE is the CONST_DOUBLE rtx itself.  */
/*
#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C) \
   ((C) == 'G' ? CONST_OK_FOR_I (CONST_DOUBLE_HIGH (VALUE)) \
	      && CONST_OK_FOR_I (CONST_DOUBLE_LOW (VALUE))  \
    : 0)
*/
/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.  */
#define PREFERRED_RELOAD_CLASS(X, CLASS) kf32_reload_class (X, CLASS)

/* Return the register class of a scratch register needed to copy IN into
   or out of a register in CLASS in MODE.  If it can be done directly,
   NO_REGS is returned.  */
/*using target_secondary_reload hook to replace this obsolete macro*/
#define SECONDARY_RELOAD_CLASS(CLASS, MODE, X) kf32_secondary_reload_class(X,CLASS)


/* Return the maximum number of consecutive registers
   needed to represent mode MODE in a register of class CLASS. 

   On KungFu32 this is the size of MODE in words.  */
#define CLASS_MAX_NREGS(CLASS, MODE)  \
     (ROUND_ADVANCE (GET_MODE_SIZE (MODE)))

/* Stack layout; function entry, exit and calling.  */

/* Define the number of register that can hold parameters.
   These two macros are used only in other macro definitions below.  */
/*R8-R12 to hold the parameters */
#define NPARM_REGS 5 
#define FIRST_PARM_REG 0
/*R8-R9 to reture the value*/
#define FIRST_RET_REG 0 

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
#define STACK_GROWS_DOWNWARD  

#define STACK_PUSH_CODE PRE_DEC

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */
#define STARTING_FRAME_OFFSET  0

/* If defined, the maximum amount of space required for outgoing arguments
   will be computed and placed into the variable
   `crtl->outgoing_args_size'.  No space will be pushed
   onto the stack for each call; instead, the function prologue should
   increase the stack frame size by this amount.  */
#define ACCUMULATE_OUTGOING_ARGS 1

/* Offset of first parameter from the argument pointer register value.  */
#define FIRST_PARM_OFFSET(FNDECL)  0

/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.  */
#define FUNCTION_VALUE(VALTYPE, FUNC)  kungfu32_function_value (VALTYPE, FUNC)

/* Don't default to pcc-struct-return, because gcc is the only compiler, and
   we want to retain compatibility with older gcc versions.  */
#define DEFAULT_PCC_STRUCT_RETURN 0

/* Define how to find the value returned by a library function
   assuming the value has mode MODE.  */
#define LIBCALL_VALUE(MODE)  gen_rtx_REG (MODE, FIRST_RET_REG)

/* 1 if N is a possible register number for a function value.
   On the KF32, only r0 can return results.  */
#define FUNCTION_VALUE_REGNO_P(REGNO)  ((REGNO) == FIRST_RET_REG)

/* 1 if N is a possible register number for function argument passing.  */
#define FUNCTION_ARG_REGNO_P(REGNO)  \
  ((REGNO) >= FIRST_PARM_REG && (REGNO) < (NPARM_REGS + FIRST_PARM_REG))

/* Define a data type for recording info about an argument list
   during the scan of that argument list.  This data type should
   hold all necessary information about the function itself
   and about the args processed so far, enough to enable macros
   such as FUNCTION_ARG to determine where the next arg should go.

   On KungFu32, this is a single integer, which is a number of words
   of arguments scanned so far (including the invisible argument,
   if any, which holds the structure-value-address).
   Thus NARGREGS or more means all following args should go on the stack.  */
#define CUMULATIVE_ARGS  int

#define ROUND_ADVANCE(SIZE)	\
  ((SIZE + UNITS_PER_WORD - 1) / UNITS_PER_WORD)

/* Round a register number up to a proper boundary for an arg of mode 
   MODE. 
   
   We round to an even reg for things larger than a word.  */
#if 0
#define ROUND_REG(X, MODE) 				\
    (GET_MODE_UNIT_SIZE ((MODE)) > UNITS_PER_WORD 	\
   ? ((X) + ((X) & 1)) : (X))
#endif

/*did not round to the even reg*/
#define ROUND_REG(X, MODE) 			X	

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.

   On KungFu32, the offset always starts at 0: the first parm reg is always
   the same reg.  */
#define INIT_CUMULATIVE_ARGS(CUM, FNTYPE, LIBNAME, INDIRECT, N_NAMED_ARGS) \
  ((CUM) = 0)

/* Call the function profiler with a given profile label.  */
#define FUNCTION_PROFILER(STREAM,LABELNO)		

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */
#define EXIT_IGNORE_STACK 1 

/* Length in units of the trampoline for entering a nested function.  */
#define TRAMPOLINE_SIZE  12

/* Alignment required for a trampoline in bits.  */
#define TRAMPOLINE_ALIGNMENT  32

/* Macros to check register numbers against specific register classes.  */
/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */
#define REGNO_MODE_CODE_OK_FOR_BASE_P(REGNO, MODE,AS,OCODE, ICODE)	\
	(GET_MODE_SIZE(MODE) <= 4 ? \
((OCODE) == POST_INC ? ((REGNO) < 16 || (unsigned) reg_renumber[(REGNO)] < 16):\
((OCODE) == MEM && (ICODE) == SCRATCH) ? ((REGNO) < 16 || (unsigned) reg_renumber[(REGNO)] < 16):\
((OCODE) == PLUS && (ICODE) == REG) ? ((REGNO) < 8 || (unsigned) reg_renumber[(REGNO)] < 8):\
((OCODE) == PLUS && (ICODE) == CONST_INT) ? ((REGNO) < 8 || (unsigned) reg_renumber[(REGNO)] < 8 || \
((REGNO) == STACK_POINTER_REGNUM || (reg_renumber[(REGNO)] == STACK_POINTER_REGNUM))) : 0) :\
((OCODE) == PRE_INC ? ((REGNO) < 16 || (unsigned) reg_renumber[(REGNO)] < 16):\
((OCODE) == MEM && (ICODE) == SCRATCH) ? ((REGNO) < 8 || (unsigned) reg_renumber[(REGNO)] < 8):\
((OCODE) == PLUS && (ICODE) == REG) ? ((REGNO) < 8 || (unsigned) reg_renumber[(REGNO)] < 8):\
((OCODE) == PLUS && (ICODE) == CONST_INT) ? ((REGNO) < 8 || (unsigned) reg_renumber[(REGNO)] < 8 || \
(REGNO) == STACK_POINTER_REGNUM || (reg_renumber[(REGNO)] == STACK_POINTER_REGNUM)) : 0)\
)

#define REGNO_MODE_OK_FOR_BASE_P(REGNO,MODE)  \
  ((REGNO) < 8 || (unsigned) reg_renumber[(REGNO)] < 8 || \
   (REGNO == STACK_POINTER_REGNUM || \
       (reg_renumber[REGNO] == STACK_POINTER_REGNUM)))

/* Maximum number of registers that can appear in a valid memory   address.  
 ĴԳֱȷڴַһ㶼12.
*/
#define MAX_REGS_PER_ADDRESS 2 

/* Recognize any constant value that is a valid address.  */
#define CONSTANT_ADDRESS_P(X) 	 (GET_CODE (X) == LABEL_REF) 


/* Nonzero if X is a hard reg that can be used as a base reg
   or if it is a pseudo reg.  */
#define REG_OK_FOR_BASE_NONSTRICT_P(X) \
    	(REGNO (X) <= 7 || REGNO (X) >= FIRST_PSEUDO_REGISTER ||\
		 (REGNO(X) == FRAME_POINTER_REGNUM) || \
		 (REGNO(X) == STACK_POINTER_REGNUM))

#define REG_OK_FOR_LONG_BASE_NONSTRICT_P(X) \
    	(REGNO (X) <= 7 || REGNO (X) >= FIRST_PSEUDO_REGISTER ||\
		 (REGNO(X) == FRAME_POINTER_REGNUM) || \
		 (REGNO(X) == STACK_POINTER_REGNUM))

/* Nonzero if X is a hard reg that can be used as an index
   or if it is a pseudo reg.  */
#define REG_OK_FOR_INDEX_NONSTRICT_P(X)	\
    	(REGNO (X) <= 7 || REGNO (X) >= FIRST_PSEUDO_REGISTER) 

#define REG_OK_FOR_LONG_INDEX_NONSTRICT_P(X)	\
    	(REGNO (X) <= 7 || REGNO (X) >= FIRST_PSEUDO_REGISTER) 

/* Nonzero if X is a hard reg that can be used as a base reg.  */
#define REG_OK_FOR_BASE_STRICT_P(X,MODE)	\
    	(REGNO (X) <= 7 ||\
		 (REGNO(X) == FRAME_POINTER_REGNUM) || \
		 (REGNO(X) == STACK_POINTER_REGNUM))

/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_STRICT_P(X) \
    	(REGNO (X) <= 7 ) 

#define REGNO_OK_FOR_INDEX_P(REGNO)\
    	(REGNO  <= 7 || ((unsigned) reg_renumber[REGNO] <= 7)) 

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address.

   The other macros defined here are used only in GO_IF_LEGITIMATE_ADDRESS.  */
#define BASE_REGISTER_RTX_P(X)  \
  (GET_CODE (X) == REG && REG_OK_FOR_BASE_P (X))

#define INDEX_REGISTER_RTX_P(X)  \
  (GET_CODE (X) == REG && REG_OK_FOR_INDEX_P (X))


/* Jump to LABEL if X is a valid address RTX.  This must also take
   REG_OK_STRICT into account when deciding about valid registers, but it uses
   the above macros so we are in luck.  
 
   Allow  REG
	  REG+disp 
	  REG+REG

   A legitimate index for a QI is 0..31, for HI is 0..62, for SI is 0..124,
   and for DI is 0..120 because we use two SI loads, etc.  */
#if 0
#define LEGITIMIZE_RELOAD_ADDRESS(X, MODE, OPNUM, TYPE, IND_LEVELS, WIN)   \
do {									      \
  rtx new_x = kf32_legitimize_reload_address (&X, MODE, OPNUM, TYPE, IND_LEVELS); \
  if (new_x)								      \
    {									      \
      X = new_x;							      \
      goto WIN;								      \
    }									      \
} while (0)

#endif
/* Specify the machine mode that this machine uses
   for the index in the tablejump instruction.  */
#define CASE_VECTOR_MODE SImode

/* 'char' is signed by default.  */
#define DEFAULT_SIGNED_CHAR  0

/* The type of size_t unsigned int.  */
#define SIZE_TYPE "unsigned int"

/* Max number of bytes we can move from memory to memory
   in one reasonably fast instruction.  */
#define MOVE_MAX 4

/* Define if operations between registers always perform the operation
   on the full register even if a narrower mode is specified.  */
#define WORD_REGISTER_OPERATIONS

/* Define if loading in MODE, an integral mode narrower than BITS_PER_WORD
   will either zero-extend or sign-extend.  The value of this macro should
   be the code that says which one of the two operations is implicitly
   done, UNKNOWN if none.  */
#define LOAD_EXTEND_OP(MODE) ZERO_EXTEND

/* Nonzero if access to memory by bytes is slow and undesirable.  */
#define SLOW_BYTE_ACCESS 1 

/* Shift counts are truncated to 6-bits (0 to 63) instead of the expected
   5-bits, so we can not define SHIFT_COUNT_TRUNCATED to true for this
   target.  */
#define SHIFT_COUNT_TRUNCATED 0

/* All integers have the same format so truncation is easy.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC,INPREC)  1

/* The machine modes of pointers and functions.  */
#define Pmode          SImode
#define FUNCTION_MODE  Pmode

/* Compute extra cost of moving data between one register class
   and another.  All register moves are cheap.  */
#define REGISTER_MOVE_COST(MODE, FROM, TO) \
   (((FROM) == HIGH_REGS || (TO) == HIGH_REGS) ? 4 : 2)

/* Moves to and from memory are quite expensive */
#define MEMORY_MOVE_COST(M, CLASS, IN)			\
   ((GET_MODE_SIZE (M) < 4 ? 8 : 2 * GET_MODE_SIZE (M))	\
    * (CLASS == LOW_REGS ? 1 : 2))

/* Assembler output control.  */
#define ASM_COMMENT_START "\t//"

#define ASM_APP_ON		"// inline asm begin\n"
#define ASM_APP_OFF	"// inline asm end\n"

#define FILE_ASM_OP     "\t.file\n"

/* Switch to the text or data segment.  */
#define TEXT_SECTION_ASM_OP  "\t.text"
#define DATA_SECTION_ASM_OP  "\t.data"

/* Support a read-only data section.  */
#if  0
#define READONLY_DATA_SECTION_ASM_OP			"\t.section\t.rodata"
#define READONLY_DATA_SECTION_ASM_OPRAM			"\t.section\t.inrodata"
#else
#define READONLY_DATA_SECTION_ASM_OP			"\t.section\t.text"
#define READONLY_DATA_SECTION_ASM_OPRAM			"\t.section\t.indata"
#endif

#undef  CTORS_SECTION_ASM_OP
#define CTORS_SECTION_ASM_OP	"\t.section\t.ctors,\"aw\""
#undef  DTORS_SECTION_ASM_OP
#define DTORS_SECTION_ASM_OP	"\t.section\t.dtors,\"aw\""

/* Use .init_array/.fini_array section for constructors and destructors. */
#undef TARGET_ASM_CONSTRUCTOR
#define TARGET_ASM_CONSTRUCTOR default_elf_init_array_asm_out_constructor
#undef TARGET_ASM_DESTRUCTOR
#define TARGET_ASM_DESTRUCTOR default_elf_fini_array_asm_out_destructor

/* //############################################################################# */
/*лһͨĶ.  */
#undef  TARGET_ASM_NAMED_SECTION
#define TARGET_ASM_NAMED_SECTION  kungfu32_asm_named_section
/* //############################################################################# */
#undef TARGET_OPTION_OVERRIDE
#define TARGET_OPTION_OVERRIDE kungfu32_option_override

/* //############################################################################# */
/* Globalizing directive for a label.  */
#define GLOBAL_ASM_OP "\t.export\t"

/* The prefix to add to user-visible assembler symbols.  */
#undef  USER_LABEL_PREFIX
#define USER_LABEL_PREFIX ""
/* //############################################################################# */
/* This is how to output an insn to push a register on the stack.
   It need not be very fast code.  */
/*the following macros are used to support the functional profile
 I do not think we need to define these macros at present.
 So comment them*/
#if 0
#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)  \
  fprintf (FILE, "\tsubi\t %s,%d\n\tstw\t %s,(%s)\n",	\
	   reg_names[STACK_POINTER_REGNUM],		\
	   (STACK_BOUNDARY / BITS_PER_UNIT),		\
	   reg_names[REGNO],				\
	   reg_names[STACK_POINTER_REGNUM])

/* Length in instructions of the code output by ASM_OUTPUT_REG_PUSH.  */
#define REG_PUSH_LENGTH 2

/* This is how to output an insn to pop a register from the stack.  */
#define ASM_OUTPUT_REG_POP(FILE,REGNO)  \
  fprintf (FILE, "\tldw\t %s,(%s)\n\taddi\t %s,%d\n",	\
	   reg_names[REGNO],				\
	   reg_names[STACK_POINTER_REGNUM],		\
	   reg_names[STACK_POINTER_REGNUM],		\
	   (STACK_BOUNDARY / BITS_PER_UNIT))
#endif
/* //############################################################################# ǩ׷ûǰ׺ */
/* Output a reference to a label.  */
#undef  ASM_OUTPUT_LABELREF
#define ASM_OUTPUT_LABELREF(STREAM, NAME)  \
  fprintf (STREAM, "%s%s", USER_LABEL_PREFIX, \
	   (* targetm.strip_name_encoding) (NAME))
/* //############################################################################# 2logֽڶ */
/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes.  */
#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
  if ((LOG) != 0)			\
    fprintf (FILE, "\t.align\t%d\n", LOG)
/* //############################################################################# Ϣ */
#ifndef ASM_DECLARE_RESULT
#define ASM_DECLARE_RESULT(FILE, RESULT)
#endif
/* //############################################################################# */

#define MULTIPLE_SYMBOL_SPACES 1

#define SUPPORTS_ONE_ONLY 1

/* A pair of macros to output things for the callgraph data.
   VALUE means (to the tools that reads this info later):
  	0 a call from src to dst
  	1 the call is special (e.g. dst is "unknown" or "alloca")
  	2 the call is special (e.g., the src is a table instead of routine)
  
   Frame sizes are augmented with timestamps to help later tools 
   differentiate between static entities with same names in different
   files.  */
/*the following macros will emit some special directives for kungfu32's tools
 Comment them at first*/
#if 0
extern long kungfu32_current_compilation_timestamp;
#define	ASM_OUTPUT_CG_NODE(FILE,SRCNAME,VALUE)				\
  do									\
    {									\
      if (kungfu32_current_compilation_timestamp == 0)			\
        kungfu32_current_compilation_timestamp = time (0);			\
      fprintf ((FILE),"\t.equ\t__$frame$size$_%s_$_%08lx,%d\n",		\
             (SRCNAME), kungfu32_current_compilation_timestamp, (VALUE));	\
    }									\
  while (0)

#define	ASM_OUTPUT_CG_EDGE(FILE,SRCNAME,DSTNAME,VALUE)		\
  do								\
    {								\
      fprintf ((FILE),"\t.equ\t__$function$call$_%s_$_%s,%d\n",	\
             (SRCNAME), (DSTNAME), (VALUE));			\
    }								\
  while (0)
#endif


/* //#############################################################################*/
/* ڲǩַǩֺк.  */
#undef  ASM_GENERATE_INTERNAL_LABEL
#define ASM_GENERATE_INTERNAL_LABEL(STRING, PREFIX, NUM)  \
  sprintf (STRING, ".%s%ld", PREFIX, (long) NUM)


/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* Jump tables 32 bit .  */
#undef  ASM_OUTPUT_CASE_LABEL
#define ASM_OUTPUT_CASE_LABEL(STREAM,PREFIX,NUM,TABLE) \
  fprintf (STREAM, "\t.align 2\n.%s%d:\n", PREFIX, NUM);

/* Եַ. ΪתΪ붨ģвá.  */
#define ASM_OUTPUT_ADDR_DIFF_ELT(STREAM,BODY,VALUE,REL)  \
  fputs ("- - - ASM_OUTPUT_ADDR_DIFF_ELT called!\n", STREAM)

/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */

/* һԪ.  */
#define ASM_OUTPUT_ADDR_VEC_ELT(STREAM,VALUE)  \
    fprintf (STREAM, "\t.long\t.L%d\n", VALUE)


/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* Output various types of constants.  */

/* This is how to output an assembler line
   that says to advance the location counter by SIZE bytes.  */
#undef  ASM_OUTPUT_SKIP
#define ASM_OUTPUT_SKIP(FILE,SIZE)  \
  fprintf (FILE, "\t.fill %d, 1\n", (int)(SIZE))


/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* This says how to output an assembler line
   to define a global common symbol, with alignment information.  */
/* XXX - for now we ignore the alignment.  */     
#undef  ASM_OUTPUT_ALIGNED_COMMON
#define ASM_OUTPUT_ALIGNED_COMMON(FILE, NAME, SIZE, ALIGN)	\
  do								\
    {								\
      if (kungfu32_dllexport_name_p (NAME))			\
	KUNGFU32_EXPORT_NAME (FILE, NAME)				\
      if (! kungfu32_dllimport_name_p (NAME))			\
        {							\
          fputs ("\t.comm\t", FILE);				\
          assemble_name (FILE, NAME);				\
          fprintf (FILE, ",%lu\n", (unsigned long)(SIZE));	\
        }							\
    }								\
  while (0)
/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* This says how to output an assembler line
   to define a local common symbol....  */
#undef  ASM_OUTPUT_LOCAL
#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)	\
  (fputs ("\t.lcomm\t", FILE),				\
  assemble_name (FILE, NAME),				\
  fprintf (FILE, ",%d\n", (int)SIZE))
/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* ... and how to define a local common symbol whose alignment
   we wish to specify.  ALIGN comes in as bits, we have to turn
   it into bytes.  */
#undef  ASM_OUTPUT_ALIGNED_LOCAL
#define ASM_OUTPUT_ALIGNED_LOCAL(FILE, NAME, SIZE, ALIGN)		\
  do									\
    {									\
      fputs ("\t.bss\t", (FILE));					\
      assemble_name ((FILE), (NAME));					\
      fprintf ((FILE), ",%d,%d\n", (int)(SIZE), (ALIGN) / BITS_PER_UNIT);\
    }									\
  while (0)
/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
/* Print operand X (an rtx) in assembler syntax to file FILE.
   CODE is a letter or dot (`z' in `%z0') or 0 if no letter was specified.
   For `%' followed by punctuation, CODE is the punctuation and X is null.  */
#define PRINT_OPERAND(STREAM, X, CODE)  kungfu32_print_operand (STREAM, X, CODE)

/* Print a memory address as an operand to reference that memory location.  */
#define PRINT_OPERAND_ADDRESS(STREAM,X)  kungfu32_print_operand_address (STREAM, X)

#define PRINT_OPERAND_PUNCT_VALID_P(CHAR) \
  ((CHAR)=='.' || (CHAR) == '#' || (CHAR) == '*' || (CHAR) == '^' || (CHAR) == '!')
/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
/*to support some builtins*/
/*support the __builtin_return_address()*/
#define RETURN_ADDR_RTX(COUNT,FRAME) \
	kf32_return_addr(COUNT,FRAME)

#define FINAL_PRESCAN_INSN kf32_final_prescan_insn
/* //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/
#endif /* ! GCC_KUNGFU32_H */
