/* Prototypes for exported functions defined in kf32.c
   Copyright (C) 2000, 2002, 2003, 2004, 2005, 2007
   Free Software Foundation, Inc.
   Contributed by Nick Clifton (nickc@redhat.com)

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GCC is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

extern const char * kungfu32_output_jump_label_table	(void);
extern void         kungfu32_expand_prolog          	(void);
extern void         kungfu32_expand_epilog          	(void);
extern HOST_WIDE_INT           kungfu32_const_ok_for_inline    	(HOST_WIDE_INT);
extern HOST_WIDE_INT           kf32_const_ok_for_inline    	(HOST_WIDE_INT);
extern HOST_WIDE_INT           kf32_try_constant_tricks (HOST_WIDE_INT value, HOST_WIDE_INT * x, HOST_WIDE_INT * y);
extern HOST_WIDE_INT           kungfu32_num_ones               	(HOST_WIDE_INT);
extern HOST_WIDE_INT           kungfu32_num_zeros              	(HOST_WIDE_INT);
extern HOST_WIDE_INT           kf32_num_ones               	(HOST_WIDE_INT);
extern HOST_WIDE_INT           kf32_num_zeros              	(HOST_WIDE_INT);
extern bool         kf32_llong_val              	(HOST_WIDE_INT);
extern HOST_WIDE_INT           kungfu32_initial_elimination_offset	(HOST_WIDE_INT , HOST_WIDE_INT );
extern HOST_WIDE_INT           kungfu32_const_trick_uses_not   	(HOST_WIDE_INT);
extern void         kungfu32_override_options       	(void);
extern HOST_WIDE_INT           kungfu32_dllexport_name_p       	(const char *);
extern HOST_WIDE_INT           kungfu32_dllimport_name_p       	(const char *);
extern HOST_WIDE_INT           kungfu32_naked_function_p       	(void);
extern bool			kf32_legitimate_address_p(enum machine_mode mode,rtx op,bool strict_p);
extern rtx			kf32_legitimize_reload_address (rtx *, enum machine_mode, HOST_WIDE_INT , HOST_WIDE_INT ,
					    HOST_WIDE_INT );

extern rtx			kf32_return_addr(HOST_WIDE_INT , rtx);
/*extern void         kf32_hardware_loop (void);*/
extern void kf32_final_prescan_insn(rtx insn, rtx *opvec, int noperands);

extern void kf32_secondary_reload_addr (rtx reg, rtx mem, rtx scratch, bool store_p);
#ifdef TREE_CODE
#ifdef HAVE_MACHINE_MODES
extern HOST_WIDE_INT           kungfu32_num_arg_regs           	(enum machine_mode, const_tree);
#endif /* HAVE_MACHINE_MODES */

#ifdef RTX_CODE
extern rtx          kungfu32_function_value         	(const_tree, const_tree);
#endif /* RTX_CODE */
#endif /* TREE_CODE */

extern bool kungfu32_is_long_call_p (tree);
extern void kungfu32_pr_long_calls (struct cpp_reader *);
extern void kungfu32_pr_no_long_calls (struct cpp_reader *);
extern void kungfu32_pr_long_calls_off (struct cpp_reader *);
extern void kungfu32_lang_object_attributes_init(void);

extern void kungfu32_pragma_section		    (struct cpp_reader *);

#ifdef RTX_CODE

extern const char * kungfu32_output_bclri         		(rtx, HOST_WIDE_INT );
extern const char * kf32_output_clr_insn         	(rtx, HOST_WIDE_INT );
extern bool         kf32_peephole_p         	    (rtx, rtx,rtx );
extern bool         kf32_peephole_shift_p         	    (rtx, rtx,rtx );
extern const char * kf32_output_set_insn         	(rtx, HOST_WIDE_INT );
extern const char * kungfu32_output_bseti         		(rtx, HOST_WIDE_INT );
extern const char * kungfu32_output_cmov          		(rtx *, HOST_WIDE_INT , const char *);
extern char *       kungfu32_output_call          		(rtx *, HOST_WIDE_INT );
extern HOST_WIDE_INT           kungfu32_is_dead                	(rtx, rtx);
extern HOST_WIDE_INT           kungfu32_expand_insv            	(rtx *);
extern bool         kungfu32_expand_block_move      	(rtx *);
extern const char * kungfu32_output_andn          		(rtx, rtx *);
extern void         kungfu32_print_operand_address  	(FILE *, rtx);
extern void         kungfu32_print_operand          	(FILE *, rtx, HOST_WIDE_INT );
extern bool         kungfu32_gen_compare	        	(RTX_CODE, rtx, rtx);
extern HOST_WIDE_INT           kungfu32_symbolic_address_p     	(rtx);
extern bool         kungfu32_r15_operand_p			(rtx);
extern enum reg_class kungfu32_secondary_reload_class	(enum reg_class, enum machine_mode, rtx);
extern enum reg_class kungfu32_reload_class 		(rtx, enum reg_class);
extern HOST_WIDE_INT           kungfu32_is_same_reg            	(rtx, rtx);
extern HOST_WIDE_INT           kungfu32_arith_S_operand         	(rtx);

#ifdef HAVE_MACHINE_MODES
extern const char * kungfu32_output_move          		(rtx, rtx *, enum machine_mode);
extern const char * kungfu32_output_movedouble    		(rtx *, enum machine_mode);
extern HOST_WIDE_INT           const_ok_for_kungfu32_127                  (HOST_WIDE_INT);
extern HOST_WIDE_INT           const_ok_for_kf32_255                  (HOST_WIDE_INT);

extern bool kf32_mem_operand(rtx mem);
extern bool kf32_stack_mem(rtx mem);
extern bool kf32_mem_post_format(rtx mem);
extern bool kf32_mem_two_low_regs_format(rtx mem);
extern bool kf32_mem_short_offset(rtx mem);
extern bool kf32_mem_long_offset(rtx mem);
extern bool kf32_mem_pre_modify_format(rtx mem);
extern const char * kf32_output_move_const (rtx operands[],
	                    enum machine_mode mode ATTRIBUTE_UNUSED);

extern const char * kf32_output_move_RjiaR_H (rtx operands[],
	                    enum machine_mode mode ATTRIBUTE_UNUSED);

extern const char * kf32_output_ADD_ADDC_DI(rtx operands[],
						enum machine_mode mode ATTRIBUTE_UNUSED);

extern const char * kf32_output_SUB_SUBC_DI(rtx operands[],
                  enum machine_mode mode ATTRIBUTE_UNUSED);

extern const char * kf32_output_movedouble(rtx operands[],
						enum machine_mode mode ATTRIBUTE_UNUSED);
extern const char * kf32_output_return(void);
extern void kf32_gen_cbranch (enum rtx_code code, rtx op0, rtx op1,rtx op2);
extern bool kungfu32_mem_two_low_regs_condition (rtx mem);

#ifdef TREE_CODE
#endif /* TREE_CODE */
#endif /* HAVE_MACHINE_MODES */
#endif /* RTX_CODE */
