#ifndef	_TIME_H_
#define _TIME_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _STDDEF_H_
#include <stddef.h>
#endif /* _STDDEF_H_ */


typedef	long	time_t;		/* for representing times in seconds */
typedef	long	clock_t;

struct tm {
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
};

//+++++++++++++++++++++++++++++++++++++++++++++++++++
// only extern for lib,you should must write the function (adapters bases on the chip resource) in project 
extern unsigned char RtcReadTime(struct tm *timeptr);
extern unsigned char RtcWriteTime(struct tm *timeptr);

//+++++++++++++++++++++++++++++++++++++++++++++++++++
#define LEAP_YEAR(year) ((year%4)==0)
 // get time,if parameter is not null,the resutlt also assign to it  
#define clock()		time(NULL);
extern time_t	time(time_t *);		/* seconds since 00:00:00 Jan 1 1970 */
extern void	timeTm(struct tm *);
 // set time

extern char	stime(struct tm * );
extern char	stime2(time_t *);

// time interval ,units:second
#define	difftime(t1, t0)	((long double)((time_t)(t1)-(time_t)(t0)))


//conversion of object to value
extern time_t		mktime(struct tm *);

//conversion of time to string
extern char *	asctime	(struct tm *	);	/* converts struct tm to ascii time */
extern char *	ctime	(time_t *		);	/* current local time in ascii form */

// conversion of  value to object
extern struct tm *	localtime(time_t *);	/* local time */
extern struct tm *	gmtime( time_t *);		/* Universal time */

extern void gmtimeTM( time_t *timep,struct tm *inTmTime );
//###############################################

#ifdef __cplusplus
}
#endif
#endif /* _TIME_H_ */

