/*****************************************************************************/
/* @file:    stdlib.h                                                        */
/* @version: V1.01                                                           */
/* @purpose: This include file contains the function declarations for        */
/*           commonly used library functions                                 */
/*                                                                           */
/*****************************************************************************/

#ifndef _STDLIB_H
#define	_STDLIB_H

#include "malloc.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef	unsigned int size_t;
#endif

#ifndef __cplusplus
#ifndef _WCHAR_T
typedef unsigned short wchar_t;
#define _WCHAR_T
#endif
#endif

#ifndef	NULL
#define	NULL	0
#endif

#define EXIT_SUCCESS    (0)
#define EXIT_FAILURE    (1)
#define RAND_MAX        (0x7FFFFFFFU)
#define MB_CUR_MAX      (1)

typedef struct  {
                        int quot;
                        int rem;
                } div_t;

typedef struct  {
                        long quot;
                        long rem;
                } ldiv_t;

//#if     __STDC_VERSION__ >= 199901L
typedef struct  {
                        long long quot;
                        long long rem;
                } lldiv_t;

extern  long long               llabs    ( long long );
extern  long long               atoll    ( const char * );
extern  lldiv_t                 lldiv    ( long long, long long );
//#endif

extern  int                     abs      ( int );
extern  long                    labs     ( long );
extern  void                    _Exit    ( int ) __attribute__((__noreturn__));
extern  void                    exit     ( int ) __attribute__((__noreturn__));
//##################################################################################################

extern  double   				atof     ( const char * );
extern  int                     atoi     ( const char * );
extern  long                    atol     ( const char * );


/* convert an unsigned/signed integer to ASCII string */
extern void 		uitoa (unsigned int, char *, unsigned char);
extern void 		itoa (int, char*, unsigned char);

/* convert an unsigned/signed long integer to ASCII string */
extern void 		ultoa (unsigned long, char *, unsigned char);
extern void 		ltoa (long, char*, unsigned char);

/* -------------------------------------------------------------------------
 * Non-standard C-like format specification for , to be combined
 * with the precision value:
 *
 * F format: [-]ddd.ddd rounded to 'prec' fractional digits (prec >= 0)
 * E format: [-]d.ddde+-dd rounded to 'prec' fractional digits (prec >= 0)
 * G format: use format E if exp < -4 or exp >= prec; format F otherwise
 * -------------------------------------------------------------------------*/

#define PREC_F  0x20    /* F format */
#define PREC_E  0x40    /* E format */
#define PREC_G  0x00    /* G format */
#define PREC_P  0x1f    /* precision value (0..31) */
#define PREC_D  0x06    /* default precision when none specified */

#define PREC(f,p)  ((f)|(p))    /* Combine format and precision */

extern void ftoa(float, char*, unsigned char);
//##################################################################################################


extern  div_t                   div      ( int, int );
extern  ldiv_t                  ldiv     ( long, long );
extern  void *                  bsearch  ( const void *, const void *, size_t, size_t,
                                           int (*)( const void *, const void * ) );
extern  char *                 getenv   ( const char * );
extern  void                   qsort    ( void *, size_t, size_t,
                                           int (*)( const void *, const void * ) );
extern  int                    rand     ( void );
extern  void                   srand    ( unsigned int );


extern  long                    strtol   (const char *st, char **endptr, int base);
extern  unsigned long           strtoul  (const char *st, char **endptr, int base);
extern  long long               strtoll  (const char *st, char **endptr, int base);
extern  unsigned long long      strtoull (const char *st, char **endptr,int base);
extern  float                   strtof   (const char *st, char **endptr);
extern  double                  strtod   (const char *st, char **endptr);
#define	strtold(x,y)			strtod   (x, y)




#ifdef __cplusplus
}
#endif
#endif	/* _STDLIB_H */