/*
 *  $Id$
 */

#ifndef _MACHINE__DEFAULT_TYPES_H
#define _MACHINE__DEFAULT_TYPES_H

#include <sys/features.h>

/*
 * Guess on types by examining *_MIN / *_MAX defines.
 */
/* ------------------------------------- */

#define __EXP(x) __##x##__

/* ------------------------------------- */
/* Check if "long long" is 64bit wide */
#define __have_longlong64 1


/* Check if "long" is 64bit or 32bit wide */
#define __have_long32 1
/* ------------------------------------- */
#ifdef __cplusplus
extern "C" {
#endif
/* ------------------------------------- */
#ifndef	NULL
	#define	NULL	0
#endif
/* ------------------------------------- */
#ifdef __INT8_TYPE__
	typedef __INT8_TYPE__ __int8_t;
	#ifdef __UINT8_TYPE__
		typedef __UINT8_TYPE__ __uint8_t;
	#else
		typedef unsigned __INT8_TYPE__ __uint8_t;
	#endif
	#define ___int8_t_defined 1
#elif __EXP(SCHAR_MAX) == 0x7f
	typedef signed char __int8_t ;
	typedef unsigned char __uint8_t ;
	#define ___int8_t_defined 1
#endif
/* ------------------------------------- */
#ifdef __INT16_TYPE__
	typedef __INT16_TYPE__ __int16_t;
	#ifdef __UINT16_TYPE__
		typedef __UINT16_TYPE__ __uint16_t;
	#else
		typedef unsigned __INT16_TYPE__ __uint16_t;
	#endif
	#define ___int16_t_defined 1

#else
	typedef signed short __int16_t;
	typedef unsigned short __uint16_t;
	#define ___int16_t_defined 1
#endif
/* ------------------------------------- */
#ifdef __INT32_TYPE__
	typedef __INT32_TYPE__ __int32_t;
	#ifdef __UINT32_TYPE__
		typedef __UINT32_TYPE__ __uint32_t;
	#else
		typedef unsigned __INT32_TYPE__ __uint32_t;
	#endif
	#define ___int32_t_defined 1
#else
	typedef signed int 		__int32_t;
	typedef unsigned int 	__uint32_t;
	#define ___int32_t_defined 1
#endif
/* ------------------------------------- */
#ifdef __INT64_TYPE__
	typedef __INT64_TYPE__ __int64_t;
	#ifdef __UINT64_TYPE__
		typedef __UINT64_TYPE__ __uint64_t;
	#else
		typedef unsigned __INT64_TYPE__ __uint64_t;
	#endif
	#define ___int64_t_defined 1

#else
	typedef signed long long __int64_t;
	typedef unsigned long long __uint64_t;
	#define ___int64_t_defined 1
#endif
/* ------------------------------------- */
#ifdef __INT_LEAST8_TYPE__
	typedef __INT_LEAST8_TYPE__ __int_least8_t;
	#ifdef __UINT_LEAST8_TYPE__
		typedef __UINT_LEAST8_TYPE__ __uint_least8_t;
	#else
		typedef unsigned __INT_LEAST8_TYPE__ __uint_least8_t;
	#endif
	#define ___int_least8_t_defined 1
#else
	typedef __int8_t __int_least8_t;
	typedef __uint8_t __uint_least8_t;
	#define ___int_least8_t_defined 1

#endif
/* ------------------------------------- */
#ifdef __INT_LEAST16_TYPE__
	typedef __INT_LEAST16_TYPE__ __int_least16_t;
	#ifdef __UINT_LEAST16_TYPE__
	typedef __UINT_LEAST16_TYPE__ __uint_least16_t;
	#else
	typedef unsigned __INT_LEAST16_TYPE__ __uint_least16_t;
	#endif
	#define ___int_least16_t_defined 1
#else
	typedef __int16_t __int_least16_t;
	typedef __uint16_t __uint_least16_t;
	#define ___int_least16_t_defined 1
#endif
/* ------------------------------------- */
#ifdef __INT_LEAST32_TYPE__
	typedef __INT_LEAST32_TYPE__ __int_least32_t;
	#ifdef __UINT_LEAST32_TYPE__
		typedef __UINT_LEAST32_TYPE__ __uint_least32_t;
	#else
		typedef unsigned __INT_LEAST32_TYPE__ __uint_least32_t;
	#endif
	#define ___int_least32_t_defined 1
#else
	typedef __int32_t __int_least32_t;
	typedef __uint32_t __uint_least32_t;
	#define ___int_least32_t_defined 1
#endif
/* ------------------------------------- */
#ifdef __INT_LEAST64_TYPE__
	typedef __INT_LEAST64_TYPE__ __int_least64_t;
	#ifdef __UINT_LEAST64_TYPE__
		typedef __UINT_LEAST64_TYPE__ __uint_least64_t;
	#else
		typedef unsigned __INT_LEAST64_TYPE__ __uint_least64_t;
	#endif
	#define ___int_least64_t_defined 1
#else
	typedef __int64_t __int_least64_t;
	typedef __uint64_t __uint_least64_t;
	#define ___int_least64_t_defined 1
#endif
/* ------------------------------------- */
#if defined(__INTMAX_TYPE__)
	typedef __INTMAX_TYPE__ __intmax_t;
#else
	typedef signed long long __intmax_t;
#endif
/* ------------------------------------- */
#if defined(__UINTMAX_TYPE__)
typedef __UINTMAX_TYPE__ __uintmax_t;
#else
typedef unsigned long long __uintmax_t;
#endif
/* ------------------------------------- */
#ifdef __INTPTR_TYPE__
	typedef __INTPTR_TYPE__ __intptr_t;
	#ifdef __UINTPTR_TYPE__
	typedef __UINTPTR_TYPE__ __uintptr_t;
	#else
	typedef unsigned __INTPTR_TYPE__ __uintptr_t;
	#endif
#elif defined(__PTRDIFF_TYPE__)
	typedef __PTRDIFF_TYPE__ __intptr_t;
	typedef unsigned __PTRDIFF_TYPE__ __uintptr_t;
#else
	typedef int __intptr_t;
	typedef unsigned int __uintptr_t;
#endif
/* ------------------------------------- */
#undef __EXP
/* ------------------------------------- */
#ifdef __cplusplus
}
#endif

#endif /* _MACHINE__DEFAULT_TYPES_H */
