/* Copyright (c) 2017  SiFive Inc. All rights reserved.

   This copyrighted material is made available to anyone wishing to use,
   modify, copy, or redistribute it subject to the terms and conditions
   of the FreeBSD License.   This program is distributed in the hope that
   it will be useful, but WITHOUT ANY WARRANTY expressed or implied,
   including the implied warranties of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  A copy of this license is available at
   http://www.opensource.org/licenses.
*/

#ifndef _FENV_H
#define _FENV_H

#include <sys/fenv.h>
/* ------------------------------------- */
#ifdef __cplusplus
extern "C" {
#endif
/* ------------------------------------- */
/*
 * Exception flags.
 */

/* Exception */
int feclearexcept(int excepts);
int fegetexceptflag(fexcept_t *flagp, int excepts);
int feraiseexcept(int excepts);
int fesetexceptflag(const fexcept_t *flagp, int excepts);
int fetestexcept(int excepts);

/* Rounding mode */
int fegetround(void);
int fesetround(int rounding_mode);

/* Float environment */
int fegetenv(fenv_t *envp);
int feholdexcept(fenv_t *envp);
int fesetenv(const fenv_t *envp);
int feupdateenv(const fenv_t *envp);
/* ------------------------------------- */
#ifdef __cplusplus
}
#endif
/* ------------------------------------- */
#endif
