/************************************************************
*       Header file for the KungFu32  C
*       *       Microcontroller
*
*       Copyright 2012-2020 ChipON, All rights reserved
*************************************************************/

#ifndef  _KF32R3ALLOVER_H_
#define  _KF32R3ALLOVER_H_

struct all_bit{
		unsigned int _b0:1;
		unsigned int _b1:1;
		unsigned int _b2:1;
		unsigned int _b3:1;
		unsigned int _b4:1;
		unsigned int _b5:1;
		unsigned int _b6:1;
		unsigned int _b7:1;
		unsigned int _b8:1;
		unsigned int _b9:1;
		unsigned int _b10:1;
		unsigned int _b11:1;
		unsigned int _b12:1;
		unsigned int _b13:1;
		unsigned int _b14:1;
		unsigned int _b15:1;
		unsigned int _b16:1;
		unsigned int _b17:1;
		unsigned int _b18:1;
		unsigned int _b19:1;
		unsigned int _b20:1;
		unsigned int _b21:1;
		unsigned int _b22:1;
		unsigned int _b23:1;
		unsigned int _b24:1;
		unsigned int _b25:1;
		unsigned int _b26:1;
		unsigned int _b27:1;
		unsigned int _b28:1;
		unsigned int _b29:1;
		unsigned int _b30:1;
		unsigned int _b31:1;
};
// modelGPIOA

/** 0x5000 0000 GPIOA_PIR **/
union GPIOA_PIR_REG{
	unsigned int reg;
	struct GPIOA_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PIR (*((volatile union GPIOA_PIR_REG *)0x50000000))
// model

/** 0x5000 0004 GPIOA_POR **/
union GPIOA_POR_REG{
	unsigned int reg;
	struct GPIOA_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_POR (*((volatile union GPIOA_POR_REG *)0x50000004))
// model

/** 0x5000 0008 GPIOA_PUR **/
union GPIOA_PUR_REG{
	unsigned int reg;
	struct GPIOA_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PUR (*((volatile union GPIOA_PUR_REG *)0x50000008))
// model

/** 0x5000 000C GPIOA_PDR **/
union GPIOA_PDR_REG{
	unsigned int reg;
	struct GPIOA_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PDR (*((volatile union GPIOA_PDR_REG *)0x5000000C))
// model

/** 0x5000 0010 GPIOA_PODR **/
union GPIOA_PODR_REG{
	unsigned int reg;
	struct GPIOA_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PODR (*((volatile union GPIOA_PODR_REG *)0x50000010))
// model

/** 0x5000 0014 GPIOA_PMOD **/
union GPIOA_PMOD_REG{
	unsigned int reg;
	struct GPIOA_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PMOD (*((volatile union GPIOA_PMOD_REG *)0x50000014))
// model

/** 0x5000 0018 GPIOA_OMOD **/
union GPIOA_OMOD_REG{
	unsigned int reg;
	struct GPIOA_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_OMOD (*((volatile union GPIOA_OMOD_REG *)0x50000018))
// model

/** 0x5000 001C GPIOA_LOCK **/
union GPIOA_LOCK_REG{
	unsigned int reg;
	struct GPIOA_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_LOCK (*((volatile union GPIOA_LOCK_REG *)0x5000001C))
// model

/** 0x5000 0020 GPIOA_RMPL **/
union GPIOA_RMPL_REG{
	unsigned int reg;
	struct GPIOA_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPL (*((volatile union GPIOA_RMPL_REG *)0x50000020))
// model

/** 0x5000 0024 GPIOA_RMPH **/
union GPIOA_RMPH_REG{
	unsigned int reg;
	struct GPIOA_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPH (*((volatile union GPIOA_RMPH_REG *)0x50000024))
// model

/** 0x5000 0034 GPIOA_RMP_MSB **/
union GPIOA_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOA_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMP_MSB (*((volatile union GPIOA_RMP_MSB_REG *)0x50000034))
// model

/** 0x5000 0038 GPIOA_SDE **/
union GPIOA_SDE_REG{
	unsigned int reg;
	struct GPIOA_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_SDE (*((volatile union GPIOA_SDE_REG *)0x50000038))
// model

/** 0x5000 003C GPIOA_SDCTL **/
union GPIOA_SDCTL_REG{
	unsigned int reg;
	struct GPIOA_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_SDCTL (*((volatile union GPIOA_SDCTL_REG *)0x5000003C))
// modelGPIOB

/** 0x5000 0040 GPIOB_PIR **/
union GPIOB_PIR_REG{
	unsigned int reg;
	struct GPIOB_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PIR (*((volatile union GPIOB_PIR_REG *)0x50000040))
// model

/** 0x5000 0044 GPIOB_POR **/
union GPIOB_POR_REG{
	unsigned int reg;
	struct GPIOB_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_POR (*((volatile union GPIOB_POR_REG *)0x50000044))
// model

/** 0x5000 0048 GPIOB_PUR **/
union GPIOB_PUR_REG{
	unsigned int reg;
	struct GPIOB_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PUR (*((volatile union GPIOB_PUR_REG *)0x50000048))
// model

/** 0x5000 004C GPIOB_PDR **/
union GPIOB_PDR_REG{
	unsigned int reg;
	struct GPIOB_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PDR (*((volatile union GPIOB_PDR_REG *)0x5000004C))
// model

/** 0x5000 0050 GPIOB_PODR **/
union GPIOB_PODR_REG{
	unsigned int reg;
	struct GPIOB_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PODR (*((volatile union GPIOB_PODR_REG *)0x50000050))
// model

/** 0x5000 0054 GPIOB_PMOD **/
union GPIOB_PMOD_REG{
	unsigned int reg;
	struct GPIOB_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PMOD (*((volatile union GPIOB_PMOD_REG *)0x50000054))
// model

/** 0x5000 0058 GPIOB_OMOD **/
union GPIOB_OMOD_REG{
	unsigned int reg;
	struct GPIOB_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_OMOD (*((volatile union GPIOB_OMOD_REG *)0x50000058))
// model

/** 0x5000 005C GPIOB_LOCK **/
union GPIOB_LOCK_REG{
	unsigned int reg;
	struct GPIOB_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_LOCK (*((volatile union GPIOB_LOCK_REG *)0x5000005C))
// model

/** 0x5000 0060 GPIOB_RMPL **/
union GPIOB_RMPL_REG{
	unsigned int reg;
	struct GPIOB_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPL (*((volatile union GPIOB_RMPL_REG *)0x50000060))
// model

/** 0x5000 0064 GPIOB_RMPH **/
union GPIOB_RMPH_REG{
	unsigned int reg;
	struct GPIOB_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPH (*((volatile union GPIOB_RMPH_REG *)0x50000064))
// model

/** 0x5000 0074 GPIOB_RMP_MSB **/
union GPIOB_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOB_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMP_MSB (*((volatile union GPIOB_RMP_MSB_REG *)0x50000074))
// model

/** 0x5000 0078 GPIOB_SDE **/
union GPIOB_SDE_REG{
	unsigned int reg;
	struct GPIOB_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_SDE (*((volatile union GPIOB_SDE_REG *)0x50000078))
// model

/** 0x5000 007C GPIOB_SDCTL **/
union GPIOB_SDCTL_REG{
	unsigned int reg;
	struct GPIOB_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_SDCTL (*((volatile union GPIOB_SDCTL_REG *)0x5000007C))
// modelGPIOC

/** 0x5000 0080 GPIOC_PIR **/
union GPIOC_PIR_REG{
	unsigned int reg;
	struct GPIOC_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PIR (*((volatile union GPIOC_PIR_REG *)0x50000080))
// model

/** 0x5000 0084 GPIOC_POR **/
union GPIOC_POR_REG{
	unsigned int reg;
	struct GPIOC_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_POR (*((volatile union GPIOC_POR_REG *)0x50000084))
// model

/** 0x5000 0088 GPIOC_PUR **/
union GPIOC_PUR_REG{
	unsigned int reg;
	struct GPIOC_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PUR (*((volatile union GPIOC_PUR_REG *)0x50000088))
// model

/** 0x5000 008C GPIOC_PDR **/
union GPIOC_PDR_REG{
	unsigned int reg;
	struct GPIOC_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PDR (*((volatile union GPIOC_PDR_REG *)0x5000008C))
// model

/** 0x5000 0090 GPIOC_PODR **/
union GPIOC_PODR_REG{
	unsigned int reg;
	struct GPIOC_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PODR (*((volatile union GPIOC_PODR_REG *)0x50000090))
// model

/** 0x5000 0094 GPIOC_PMOD **/
union GPIOC_PMOD_REG{
	unsigned int reg;
	struct GPIOC_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PMOD (*((volatile union GPIOC_PMOD_REG *)0x50000094))
// model

/** 0x5000 0098 GPIOC_OMOD **/
union GPIOC_OMOD_REG{
	unsigned int reg;
	struct GPIOC_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_OMOD (*((volatile union GPIOC_OMOD_REG *)0x50000098))
// model

/** 0x5000 009C GPIOC_LOCK **/
union GPIOC_LOCK_REG{
	unsigned int reg;
	struct GPIOC_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_LOCK (*((volatile union GPIOC_LOCK_REG *)0x5000009C))
// model

/** 0x5000 00A0 GPIOC_RMPL **/
union GPIOC_RMPL_REG{
	unsigned int reg;
	struct GPIOC_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPL (*((volatile union GPIOC_RMPL_REG *)0x500000A0))
// model

/** 0x5000 00A4 GPIOC_RMPH **/
union GPIOC_RMPH_REG{
	unsigned int reg;
	struct GPIOC_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPH (*((volatile union GPIOC_RMPH_REG *)0x500000A4))
// model

/** 0x5000 00B4 GPIOC_RMP_MSB **/
union GPIOC_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOC_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMP_MSB (*((volatile union GPIOC_RMP_MSB_REG *)0x500000B4))
// model

/** 0x5000 00B8 GPIOC_SDE **/
union GPIOC_SDE_REG{
	unsigned int reg;
	struct GPIOC_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_SDE (*((volatile union GPIOC_SDE_REG *)0x500000B8))
// model

/** 0x5000 00BC GPIOC_SDCTL **/
union GPIOC_SDCTL_REG{
	unsigned int reg;
	struct GPIOC_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_SDCTL (*((volatile union GPIOC_SDCTL_REG *)0x500000BC))
// modelGPIOD

/** 0x5000 00C0 GPIOD_PIR **/
union GPIOD_PIR_REG{
	unsigned int reg;
	struct GPIOD_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PIR (*((volatile union GPIOD_PIR_REG *)0x500000C0))
// model

/** 0x5000 00C4 GPIOD_POR **/
union GPIOD_POR_REG{
	unsigned int reg;
	struct GPIOD_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_POR (*((volatile union GPIOD_POR_REG *)0x500000C4))
// model

/** 0x5000 00C8 GPIOD_PUR **/
union GPIOD_PUR_REG{
	unsigned int reg;
	struct GPIOD_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PUR (*((volatile union GPIOD_PUR_REG *)0x500000C8))
// model

/** 0x5000 00CC GPIOD_PDR **/
union GPIOD_PDR_REG{
	unsigned int reg;
	struct GPIOD_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PDR (*((volatile union GPIOD_PDR_REG *)0x500000CC))
// model

/** 0x5000 00D0 GPIOD_PODR **/
union GPIOD_PODR_REG{
	unsigned int reg;
	struct GPIOD_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PODR (*((volatile union GPIOD_PODR_REG *)0x500000D0))
// model

/** 0x5000 00D4 GPIOD_PMOD **/
union GPIOD_PMOD_REG{
	unsigned int reg;
	struct GPIOD_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PMOD (*((volatile union GPIOD_PMOD_REG *)0x500000D4))
// model

/** 0x5000 00D8 GPIOD_OMOD **/
union GPIOD_OMOD_REG{
	unsigned int reg;
	struct GPIOD_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_OMOD (*((volatile union GPIOD_OMOD_REG *)0x500000D8))
// model

/** 0x5000 00DC GPIOD_LOCK **/
union GPIOD_LOCK_REG{
	unsigned int reg;
	struct GPIOD_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_LOCK (*((volatile union GPIOD_LOCK_REG *)0x500000DC))
// model

/** 0x5000 00E0 GPIOD_RMPL **/
union GPIOD_RMPL_REG{
	unsigned int reg;
	struct GPIOD_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPL (*((volatile union GPIOD_RMPL_REG *)0x500000E0))
// model

/** 0x5000 00E4 GPIOD_RMPH **/
union GPIOD_RMPH_REG{
	unsigned int reg;
	struct GPIOD_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPH (*((volatile union GPIOD_RMPH_REG *)0x500000E4))
// model

/** 0x5000 00F4 GPIOD_RMP_MSB **/
union GPIOD_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOD_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMP_MSB (*((volatile union GPIOD_RMP_MSB_REG *)0x500000F4))
// model

/** 0x5000 00F8 GPIOD_SDE **/
union GPIOD_SDE_REG{
	unsigned int reg;
	struct GPIOD_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_SDE (*((volatile union GPIOD_SDE_REG *)0x500000F8))
// model

/** 0x5000 00FC GPIOD_SDCTL **/
union GPIOD_SDCTL_REG{
	unsigned int reg;
	struct GPIOD_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_SDCTL (*((volatile union GPIOD_SDCTL_REG *)0x500000FC))
// modelGPIOE

/** 0x5000 0100 GPIOE_PIR **/
union GPIOE_PIR_REG{
	unsigned int reg;
	struct GPIOE_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PIR (*((volatile union GPIOE_PIR_REG *)0x50000100))
// model

/** 0x5000 0104 GPIOE_POR **/
union GPIOE_POR_REG{
	unsigned int reg;
	struct GPIOE_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_POR (*((volatile union GPIOE_POR_REG *)0x50000104))
// model

/** 0x5000 0108 GPIOE_PUR **/
union GPIOE_PUR_REG{
	unsigned int reg;
	struct GPIOE_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PUR (*((volatile union GPIOE_PUR_REG *)0x50000108))
// model

/** 0x5000 010C GPIOE_PDR **/
union GPIOE_PDR_REG{
	unsigned int reg;
	struct GPIOE_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PDR (*((volatile union GPIOE_PDR_REG *)0x5000010C))
// model

/** 0x5000 0110 GPIOE_PODR **/
union GPIOE_PODR_REG{
	unsigned int reg;
	struct GPIOE_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PODR (*((volatile union GPIOE_PODR_REG *)0x50000110))
// model

/** 0x5000 0114 GPIOE_PMOD **/
union GPIOE_PMOD_REG{
	unsigned int reg;
	struct GPIOE_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PMOD (*((volatile union GPIOE_PMOD_REG *)0x50000114))
// model

/** 0x5000 0118 GPIOE_OMOD **/
union GPIOE_OMOD_REG{
	unsigned int reg;
	struct GPIOE_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_OMOD (*((volatile union GPIOE_OMOD_REG *)0x50000118))
// model

/** 0x5000 011C GPIOE_LOCK **/
union GPIOE_LOCK_REG{
	unsigned int reg;
	struct GPIOE_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_LOCK (*((volatile union GPIOE_LOCK_REG *)0x5000011C))
// model

/** 0x5000 0120 GPIOE_RMPL **/
union GPIOE_RMPL_REG{
	unsigned int reg;
	struct GPIOE_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMPL (*((volatile union GPIOE_RMPL_REG *)0x50000120))
// model

/** 0x5000 0124 GPIOE_RMPH **/
union GPIOE_RMPH_REG{
	unsigned int reg;
	struct GPIOE_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMPH (*((volatile union GPIOE_RMPH_REG *)0x50000124))
// model

/** 0x5000 0134 GPIOE_RMP_MSB **/
union GPIOE_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOE_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMP_MSB (*((volatile union GPIOE_RMP_MSB_REG *)0x50000134))
// model

/** 0x5000 0138 GPIOE_SDE **/
union GPIOE_SDE_REG{
	unsigned int reg;
	struct GPIOE_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_SDE (*((volatile union GPIOE_SDE_REG *)0x50000138))
// model

/** 0x5000 013C GPIOE_SDCTL **/
union GPIOE_SDCTL_REG{
	unsigned int reg;
	struct GPIOE_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_SDCTL (*((volatile union GPIOE_SDCTL_REG *)0x5000013C))
// modelGPIOF

/** 0x5000 0140 GPIOF_PIR **/
union GPIOF_PIR_REG{
	unsigned int reg;
	struct GPIOF_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PIR (*((volatile union GPIOF_PIR_REG *)0x50000140))
// model

/** 0x5000 0144 GPIOF_POR **/
union GPIOF_POR_REG{
	unsigned int reg;
	struct GPIOF_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_POR (*((volatile union GPIOF_POR_REG *)0x50000144))
// model

/** 0x5000 0148 GPIOF_PUR **/
union GPIOF_PUR_REG{
	unsigned int reg;
	struct GPIOF_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PUR (*((volatile union GPIOF_PUR_REG *)0x50000148))
// model

/** 0x5000 014C GPIOF_PDR **/
union GPIOF_PDR_REG{
	unsigned int reg;
	struct GPIOF_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PDR (*((volatile union GPIOF_PDR_REG *)0x5000014C))
// model

/** 0x5000 0150 GPIOF_PODR **/
union GPIOF_PODR_REG{
	unsigned int reg;
	struct GPIOF_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PODR (*((volatile union GPIOF_PODR_REG *)0x50000150))
// model

/** 0x5000 0154 GPIOF_PMOD **/
union GPIOF_PMOD_REG{
	unsigned int reg;
	struct GPIOF_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PMOD (*((volatile union GPIOF_PMOD_REG *)0x50000154))
// model

/** 0x5000 0158 GPIOF_OMOD **/
union GPIOF_OMOD_REG{
	unsigned int reg;
	struct GPIOF_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_OMOD (*((volatile union GPIOF_OMOD_REG *)0x50000158))
// model

/** 0x5000 015C GPIOF_LOCK **/
union GPIOF_LOCK_REG{
	unsigned int reg;
	struct GPIOF_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_LOCK (*((volatile union GPIOF_LOCK_REG *)0x5000015C))
// model

/** 0x5000 0160 GPIOF_RMPL **/
union GPIOF_RMPL_REG{
	unsigned int reg;
	struct GPIOF_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMPL (*((volatile union GPIOF_RMPL_REG *)0x50000160))
// model

/** 0x5000 0164 GPIOF_RMPH **/
union GPIOF_RMPH_REG{
	unsigned int reg;
	struct GPIOF_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMPH (*((volatile union GPIOF_RMPH_REG *)0x50000164))
// model

/** 0x5000 0174 GPIOF_RMP_MSB **/
union GPIOF_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOF_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMP_MSB (*((volatile union GPIOF_RMP_MSB_REG *)0x50000174))
// model

/** 0x5000 0178 GPIOF_SDE **/
union GPIOF_SDE_REG{
	unsigned int reg;
	struct GPIOF_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_SDE (*((volatile union GPIOF_SDE_REG *)0x50000178))
// model

/** 0x5000 017C GPIOF_SDCTL **/
union GPIOF_SDCTL_REG{
	unsigned int reg;
	struct GPIOF_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_SDCTL (*((volatile union GPIOF_SDCTL_REG *)0x5000017C))
// modelGPIOG

/** 0x5000 0180 GPIOG_PIR **/
union GPIOG_PIR_REG{
	unsigned int reg;
	struct GPIOG_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PIR (*((volatile union GPIOG_PIR_REG *)0x50000180))
// model

/** 0x5000 0184 GPIOG_POR **/
union GPIOG_POR_REG{
	unsigned int reg;
	struct GPIOG_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_POR (*((volatile union GPIOG_POR_REG *)0x50000184))
// model

/** 0x5000 0188 GPIOG_PUR **/
union GPIOG_PUR_REG{
	unsigned int reg;
	struct GPIOG_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PUR (*((volatile union GPIOG_PUR_REG *)0x50000188))
// model

/** 0x5000 018C GPIOG_PDR **/
union GPIOG_PDR_REG{
	unsigned int reg;
	struct GPIOG_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PDR (*((volatile union GPIOG_PDR_REG *)0x5000018C))
// model

/** 0x5000 0190 GPIOG_PODR **/
union GPIOG_PODR_REG{
	unsigned int reg;
	struct GPIOG_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PODR (*((volatile union GPIOG_PODR_REG *)0x50000190))
// model

/** 0x5000 0194 GPIOG_PMOD **/
union GPIOG_PMOD_REG{
	unsigned int reg;
	struct GPIOG_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PMOD (*((volatile union GPIOG_PMOD_REG *)0x50000194))
// model

/** 0x5000 0198 GPIOG_OMOD **/
union GPIOG_OMOD_REG{
	unsigned int reg;
	struct GPIOG_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_OMOD (*((volatile union GPIOG_OMOD_REG *)0x50000198))
// model

/** 0x5000 019C GPIOG_LOCK **/
union GPIOG_LOCK_REG{
	unsigned int reg;
	struct GPIOG_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_LOCK (*((volatile union GPIOG_LOCK_REG *)0x5000019C))
// model

/** 0x5000 01A0 GPIOG_RMPL **/
union GPIOG_RMPL_REG{
	unsigned int reg;
	struct GPIOG_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMPL (*((volatile union GPIOG_RMPL_REG *)0x500001A0))
// model

/** 0x5000 01A4 GPIOG_RMPH **/
union GPIOG_RMPH_REG{
	unsigned int reg;
	struct GPIOG_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMPH (*((volatile union GPIOG_RMPH_REG *)0x500001A4))
// model

/** 0x5000 01B4 GPIOG_RMP_MSB **/
union GPIOG_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOG_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMP_MSB (*((volatile union GPIOG_RMP_MSB_REG *)0x500001B4))
// model

/** 0x5000 01B8 GPIOG_SDE **/
union GPIOG_SDE_REG{
	unsigned int reg;
	struct GPIOG_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_SDE (*((volatile union GPIOG_SDE_REG *)0x500001B8))
// model

/** 0x5000 01BC GPIOG_SDCTL **/
union GPIOG_SDCTL_REG{
	unsigned int reg;
	struct GPIOG_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_SDCTL (*((volatile union GPIOG_SDCTL_REG *)0x500001BC))
// modelGPIOH

/** 0x5000 01C0 GPIOH_PIR **/
union GPIOH_PIR_REG{
	unsigned int reg;
	struct GPIOH_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PIR (*((volatile union GPIOH_PIR_REG *)0x500001C0))
// model

/** 0x5000 01C4 GPIOH_POR **/
union GPIOH_POR_REG{
	unsigned int reg;
	struct GPIOH_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_POR (*((volatile union GPIOH_POR_REG *)0x500001C4))
// model

/** 0x5000 01C8 GPIOH_PUR **/
union GPIOH_PUR_REG{
	unsigned int reg;
	struct GPIOH_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PUR (*((volatile union GPIOH_PUR_REG *)0x500001C8))
// model

/** 0x5000 01CC GPIOH_PDR **/
union GPIOH_PDR_REG{
	unsigned int reg;
	struct GPIOH_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PDR (*((volatile union GPIOH_PDR_REG *)0x500001CC))
// model

/** 0x5000 01D0 GPIOH_PODR **/
union GPIOH_PODR_REG{
	unsigned int reg;
	struct GPIOH_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PODR (*((volatile union GPIOH_PODR_REG *)0x500001D0))
// model

/** 0x5000 01D4 GPIOH_PMOD **/
union GPIOH_PMOD_REG{
	unsigned int reg;
	struct GPIOH_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PMOD (*((volatile union GPIOH_PMOD_REG *)0x500001D4))
// model

/** 0x5000 01D8 GPIOH_OMOD **/
union GPIOH_OMOD_REG{
	unsigned int reg;
	struct GPIOH_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_OMOD (*((volatile union GPIOH_OMOD_REG *)0x500001D8))
// model

/** 0x5000 01DC GPIOH_LOCK **/
union GPIOH_LOCK_REG{
	unsigned int reg;
	struct GPIOH_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_LOCK (*((volatile union GPIOH_LOCK_REG *)0x500001DC))
// model

/** 0x5000 01E0 GPIOH_RMPL **/
union GPIOH_RMPL_REG{
	unsigned int reg;
	struct GPIOH_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMPL (*((volatile union GPIOH_RMPL_REG *)0x500001E0))
// model

/** 0x5000 01E4 GPIOH_RMPH **/
union GPIOH_RMPH_REG{
	unsigned int reg;
	struct GPIOH_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMPH (*((volatile union GPIOH_RMPH_REG *)0x500001E4))
// model

/** 0x5000 01F4 GPIOH_RMP_MSB **/
union GPIOH_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOH_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMP_MSB (*((volatile union GPIOH_RMP_MSB_REG *)0x500001F4))
// model

/** 0x5000 01F8 GPIOH_SDE **/
union GPIOH_SDE_REG{
	unsigned int reg;
	struct GPIOH_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_SDE (*((volatile union GPIOH_SDE_REG *)0x500001F8))
// model

/** 0x5000 01FC GPIOH_SDCTL **/
union GPIOH_SDCTL_REG{
	unsigned int reg;
	struct GPIOH_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_SDCTL (*((volatile union GPIOH_SDCTL_REG *)0x500001FC))
// modelGPIOJ

/** 0x5000 0200 GPIOJ_PIR **/
union GPIOJ_PIR_REG{
	unsigned int reg;
	struct GPIOJ_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_PIR (*((volatile union GPIOJ_PIR_REG *)0x50000200))
// model

/** 0x5000 0204 GPIOJ_POR **/
union GPIOJ_POR_REG{
	unsigned int reg;
	struct GPIOJ_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_POR (*((volatile union GPIOJ_POR_REG *)0x50000204))
// model

/** 0x5000 0208 GPIOJ_PUR **/
union GPIOJ_PUR_REG{
	unsigned int reg;
	struct GPIOJ_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_PUR (*((volatile union GPIOJ_PUR_REG *)0x50000208))
// model

/** 0x5000 020C GPIOJ_PDR **/
union GPIOJ_PDR_REG{
	unsigned int reg;
	struct GPIOJ_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_PDR (*((volatile union GPIOJ_PDR_REG *)0x5000020C))
// model

/** 0x5000 0210 GPIOJ_PODR **/
union GPIOJ_PODR_REG{
	unsigned int reg;
	struct GPIOJ_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_PODR (*((volatile union GPIOJ_PODR_REG *)0x50000210))
// model

/** 0x5000 0214 GPIOJ_PMOD **/
union GPIOJ_PMOD_REG{
	unsigned int reg;
	struct GPIOJ_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_PMOD (*((volatile union GPIOJ_PMOD_REG *)0x50000214))
// model

/** 0x5000 0218 GPIOJ_OMOD **/
union GPIOJ_OMOD_REG{
	unsigned int reg;
	struct GPIOJ_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_OMOD (*((volatile union GPIOJ_OMOD_REG *)0x50000218))
// model

/** 0x5000 021C GPIOJ_LOCK **/
union GPIOJ_LOCK_REG{
	unsigned int reg;
	struct GPIOJ_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_LOCK (*((volatile union GPIOJ_LOCK_REG *)0x5000021C))
// model

/** 0x5000 0220 GPIOJ_RMPL **/
union GPIOJ_RMPL_REG{
	unsigned int reg;
	struct GPIOJ_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_RMPL (*((volatile union GPIOJ_RMPL_REG *)0x50000220))
// model

/** 0x5000 0224 GPIOJ_RMPH **/
union GPIOJ_RMPH_REG{
	unsigned int reg;
	struct GPIOJ_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_RMPH (*((volatile union GPIOJ_RMPH_REG *)0x50000224))
// model

/** 0x5000 0234 GPIOJ_RMP_MSB **/
union GPIOJ_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOJ_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_RMP_MSB (*((volatile union GPIOJ_RMP_MSB_REG *)0x50000234))
// model

/** 0x5000 0238 GPIOJ_SDE **/
union GPIOJ_SDE_REG{
	unsigned int reg;
	struct GPIOJ_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_SDE (*((volatile union GPIOJ_SDE_REG *)0x50000238))
// model

/** 0x5000 023C GPIOJ_SDCTL **/
union GPIOJ_SDCTL_REG{
	unsigned int reg;
	struct GPIOJ_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_SDCTL (*((volatile union GPIOJ_SDCTL_REG *)0x5000023C))
// modelGPIOK

/** 0x5000 0240 GPIOK_PIR **/
union GPIOK_PIR_REG{
	unsigned int reg;
	struct GPIOK_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_PIR (*((volatile union GPIOK_PIR_REG *)0x50000240))
// model

/** 0x5000 0244 GPIOK_POR **/
union GPIOK_POR_REG{
	unsigned int reg;
	struct GPIOK_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_POR (*((volatile union GPIOK_POR_REG *)0x50000244))
// model

/** 0x5000 0248 GPIOK_PUR **/
union GPIOK_PUR_REG{
	unsigned int reg;
	struct GPIOK_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_PUR (*((volatile union GPIOK_PUR_REG *)0x50000248))
// model

/** 0x5000 024C GPIOK_PDR **/
union GPIOK_PDR_REG{
	unsigned int reg;
	struct GPIOK_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_PDR (*((volatile union GPIOK_PDR_REG *)0x5000024C))
// model

/** 0x5000 0250 GPIOK_PODR **/
union GPIOK_PODR_REG{
	unsigned int reg;
	struct GPIOK_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_PODR (*((volatile union GPIOK_PODR_REG *)0x50000250))
// model

/** 0x5000 0254 GPIOK_PMOD **/
union GPIOK_PMOD_REG{
	unsigned int reg;
	struct GPIOK_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_PMOD (*((volatile union GPIOK_PMOD_REG *)0x50000254))
// model

/** 0x5000 0258 GPIOK_OMOD **/
union GPIOK_OMOD_REG{
	unsigned int reg;
	struct GPIOK_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_OMOD (*((volatile union GPIOK_OMOD_REG *)0x50000258))
// model

/** 0x5000 025C GPIOK_LOCK **/
union GPIOK_LOCK_REG{
	unsigned int reg;
	struct GPIOK_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_LOCK (*((volatile union GPIOK_LOCK_REG *)0x5000025C))
// model

/** 0x5000 0260 GPIOK_RMPL **/
union GPIOK_RMPL_REG{
	unsigned int reg;
	struct GPIOK_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_RMPL (*((volatile union GPIOK_RMPL_REG *)0x50000260))
// model

/** 0x5000 0264 GPIOK_RMPH **/
union GPIOK_RMPH_REG{
	unsigned int reg;
	struct GPIOK_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_RMPH (*((volatile union GPIOK_RMPH_REG *)0x50000264))
// model

/** 0x5000 0274 GPIOK_RMP_MSB **/
union GPIOK_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOK_RMP_MSB_BITS{
		unsigned int _RMPMSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_RMP_MSB (*((volatile union GPIOK_RMP_MSB_REG *)0x50000274))
// model

/** 0x5000 0278 GPIOK_SDE **/
union GPIOK_SDE_REG{
	unsigned int reg;
	struct GPIOK_SDE_BITS{
		unsigned int _SDEN:16;
		unsigned int _SDEF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_SDE (*((volatile union GPIOK_SDE_REG *)0x50000278))
// model

/** 0x5000 027C GPIOK_SDCTL **/
union GPIOK_SDCTL_REG{
	unsigned int reg;
	struct GPIOK_SDCTL_BITS{
		unsigned int _SWSAMCLK:1;
		unsigned int _LINKEN:1;
		unsigned int _PSDEF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_SDCTL (*((volatile union GPIOK_SDCTL_REG *)0x5000027C))
// modelGPIOA

/** 0x5000 1000 GPIOA_INTMS **/
union GPIOA_INTMS_REG{
	unsigned int reg;
	struct GPIOA_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTMS (*((volatile union GPIOA_INTMS_REG *)0x50001000))
// model

/** 0x5000 1004 GPIOA_INTRISE **/
union GPIOA_INTRISE_REG{
	unsigned int reg;
	struct GPIOA_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTRISE (*((volatile union GPIOA_INTRISE_REG *)0x50001004))
// model

/** 0x5000 1008 GPIOA_INTFALL **/
union GPIOA_INTFALL_REG{
	unsigned int reg;
	struct GPIOA_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTFALL (*((volatile union GPIOA_INTFALL_REG *)0x50001008))
// model

/** 0x5000 100C GPIOA_INTIE **/
union GPIOA_INTIE_REG{
	unsigned int reg;
	struct GPIOA_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTIE (*((volatile union GPIOA_INTIE_REG *)0x5000100C))
// model

/** 0x5000 1010 GPIOA_INTIF **/
union GPIOA_INTIF_REG{
	unsigned int reg;
	struct GPIOA_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_INTIF (*((volatile union GPIOA_INTIF_REG *)0x50001010))
// modelGPIOB

/** 0x5000 1040 GPIOB_INTMS **/
union GPIOB_INTMS_REG{
	unsigned int reg;
	struct GPIOB_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTMS (*((volatile union GPIOB_INTMS_REG *)0x50001040))
// model

/** 0x5000 1044 GPIOB_INTRISE **/
union GPIOB_INTRISE_REG{
	unsigned int reg;
	struct GPIOB_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTRISE (*((volatile union GPIOB_INTRISE_REG *)0x50001044))
// model

/** 0x5000 1048 GPIOB_INTFALL **/
union GPIOB_INTFALL_REG{
	unsigned int reg;
	struct GPIOB_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTFALL (*((volatile union GPIOB_INTFALL_REG *)0x50001048))
// model

/** 0x5000 104C GPIOB_INTIE **/
union GPIOB_INTIE_REG{
	unsigned int reg;
	struct GPIOB_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTIE (*((volatile union GPIOB_INTIE_REG *)0x5000104C))
// model

/** 0x5000 1050 GPIOB_INTIF **/
union GPIOB_INTIF_REG{
	unsigned int reg;
	struct GPIOB_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_INTIF (*((volatile union GPIOB_INTIF_REG *)0x50001050))
// modelGPIOC

/** 0x5000 1080 GPIOC_INTMS **/
union GPIOC_INTMS_REG{
	unsigned int reg;
	struct GPIOC_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTMS (*((volatile union GPIOC_INTMS_REG *)0x50001080))
// model

/** 0x5000 1084 GPIOC_INTRISE **/
union GPIOC_INTRISE_REG{
	unsigned int reg;
	struct GPIOC_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTRISE (*((volatile union GPIOC_INTRISE_REG *)0x50001084))
// model

/** 0x5000 1088 GPIOC_INTFALL **/
union GPIOC_INTFALL_REG{
	unsigned int reg;
	struct GPIOC_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTFALL (*((volatile union GPIOC_INTFALL_REG *)0x50001088))
// model

/** 0x5000 108C GPIOC_INTIE **/
union GPIOC_INTIE_REG{
	unsigned int reg;
	struct GPIOC_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTIE (*((volatile union GPIOC_INTIE_REG *)0x5000108C))
// model

/** 0x5000 1090 GPIOC_INTIF **/
union GPIOC_INTIF_REG{
	unsigned int reg;
	struct GPIOC_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_INTIF (*((volatile union GPIOC_INTIF_REG *)0x50001090))
// modelGPIOD

/** 0x5000 10C0 GPIOD_INTMS **/
union GPIOD_INTMS_REG{
	unsigned int reg;
	struct GPIOD_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTMS (*((volatile union GPIOD_INTMS_REG *)0x500010C0))
// model

/** 0x5000 10C4 GPIOD_INTRISE **/
union GPIOD_INTRISE_REG{
	unsigned int reg;
	struct GPIOD_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTRISE (*((volatile union GPIOD_INTRISE_REG *)0x500010C4))
// model

/** 0x5000 10C8 GPIOD_INTFALL **/
union GPIOD_INTFALL_REG{
	unsigned int reg;
	struct GPIOD_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTFALL (*((volatile union GPIOD_INTFALL_REG *)0x500010C8))
// model

/** 0x5000 10CC GPIOD_INTIE **/
union GPIOD_INTIE_REG{
	unsigned int reg;
	struct GPIOD_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTIE (*((volatile union GPIOD_INTIE_REG *)0x500010CC))
// model

/** 0x5000 10D0 GPIOD_INTIF **/
union GPIOD_INTIF_REG{
	unsigned int reg;
	struct GPIOD_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_INTIF (*((volatile union GPIOD_INTIF_REG *)0x500010D0))
// modelGPIOE

/** 0x5000 1100 GPIOE_INTMS **/
union GPIOE_INTMS_REG{
	unsigned int reg;
	struct GPIOE_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_INTMS (*((volatile union GPIOE_INTMS_REG *)0x50001100))
// model

/** 0x5000 1104 GPIOE_INTRISE **/
union GPIOE_INTRISE_REG{
	unsigned int reg;
	struct GPIOE_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_INTRISE (*((volatile union GPIOE_INTRISE_REG *)0x50001104))
// model

/** 0x5000 1108 GPIOE_INTFALL **/
union GPIOE_INTFALL_REG{
	unsigned int reg;
	struct GPIOE_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_INTFALL (*((volatile union GPIOE_INTFALL_REG *)0x50001108))
// model

/** 0x5000 110C GPIOE_INTIE **/
union GPIOE_INTIE_REG{
	unsigned int reg;
	struct GPIOE_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_INTIE (*((volatile union GPIOE_INTIE_REG *)0x5000110C))
// model

/** 0x5000 1110 GPIOE_INTIF **/
union GPIOE_INTIF_REG{
	unsigned int reg;
	struct GPIOE_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_INTIF (*((volatile union GPIOE_INTIF_REG *)0x50001110))
// modelGPIOF

/** 0x5000 1140 GPIOF_INTMS **/
union GPIOF_INTMS_REG{
	unsigned int reg;
	struct GPIOF_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_INTMS (*((volatile union GPIOF_INTMS_REG *)0x50001140))
// model

/** 0x5000 1144 GPIOF_INTRISE **/
union GPIOF_INTRISE_REG{
	unsigned int reg;
	struct GPIOF_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_INTRISE (*((volatile union GPIOF_INTRISE_REG *)0x50001144))
// model

/** 0x5000 1148 GPIOF_INTFALL **/
union GPIOF_INTFALL_REG{
	unsigned int reg;
	struct GPIOF_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_INTFALL (*((volatile union GPIOF_INTFALL_REG *)0x50001148))
// model

/** 0x5000 114C GPIOF_INTIE **/
union GPIOF_INTIE_REG{
	unsigned int reg;
	struct GPIOF_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_INTIE (*((volatile union GPIOF_INTIE_REG *)0x5000114C))
// model

/** 0x5000 1150 GPIOF_INTIF **/
union GPIOF_INTIF_REG{
	unsigned int reg;
	struct GPIOF_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_INTIF (*((volatile union GPIOF_INTIF_REG *)0x50001150))
// modelIONMI

/** 0x5000 117C IONMI_CTLR **/
union IONMI_CTLR_REG{
	unsigned int reg;
	struct IONMI_CTLR_BITS{
		unsigned int _IONMIEN:1;
		unsigned int _FLTWR:3;
		unsigned int _FCKDIV:3;
		unsigned int :1;
		unsigned int _IRQMS:3;
		unsigned int _FLTEN:1;
		unsigned int _FLTCKS:1;
		unsigned int _IONMIIC:1;
		unsigned int _IONMIIF:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IONMI_CTLR (*((volatile union IONMI_CTLR_REG *)0x5000117C))
// modelGPIOG

/** 0x5000 1180 GPIOG_INTMS **/
union GPIOG_INTMS_REG{
	unsigned int reg;
	struct GPIOG_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_INTMS (*((volatile union GPIOG_INTMS_REG *)0x50001180))
// model

/** 0x5000 1184 GPIOG_INTRISE **/
union GPIOG_INTRISE_REG{
	unsigned int reg;
	struct GPIOG_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_INTRISE (*((volatile union GPIOG_INTRISE_REG *)0x50001184))
// model

/** 0x5000 1188 GPIOG_INTFALL **/
union GPIOG_INTFALL_REG{
	unsigned int reg;
	struct GPIOG_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_INTFALL (*((volatile union GPIOG_INTFALL_REG *)0x50001188))
// model

/** 0x5000 118C GPIOG_INTIE **/
union GPIOG_INTIE_REG{
	unsigned int reg;
	struct GPIOG_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_INTIE (*((volatile union GPIOG_INTIE_REG *)0x5000118C))
// model

/** 0x5000 1190 GPIOG_INTIF **/
union GPIOG_INTIF_REG{
	unsigned int reg;
	struct GPIOG_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_INTIF (*((volatile union GPIOG_INTIF_REG *)0x50001190))
// modelGPIOH

/** 0x5000 11C0 GPIOH_INTMS **/
union GPIOH_INTMS_REG{
	unsigned int reg;
	struct GPIOH_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_INTMS (*((volatile union GPIOH_INTMS_REG *)0x500011C0))
// model

/** 0x5000 11C4 GPIOH_INTRISE **/
union GPIOH_INTRISE_REG{
	unsigned int reg;
	struct GPIOH_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_INTRISE (*((volatile union GPIOH_INTRISE_REG *)0x500011C4))
// model

/** 0x5000 11C8 GPIOH_INTFALL **/
union GPIOH_INTFALL_REG{
	unsigned int reg;
	struct GPIOH_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_INTFALL (*((volatile union GPIOH_INTFALL_REG *)0x500011C8))
// model

/** 0x5000 11CC GPIOH_INTIE **/
union GPIOH_INTIE_REG{
	unsigned int reg;
	struct GPIOH_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_INTIE (*((volatile union GPIOH_INTIE_REG *)0x500011CC))
// model

/** 0x5000 11D0 GPIOH_INTIF **/
union GPIOH_INTIF_REG{
	unsigned int reg;
	struct GPIOH_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_INTIF (*((volatile union GPIOH_INTIF_REG *)0x500011D0))
// modelGPIOJ

/** 0x5000 1200 GPIOJ_INTMS **/
union GPIOJ_INTMS_REG{
	unsigned int reg;
	struct GPIOJ_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_INTMS (*((volatile union GPIOJ_INTMS_REG *)0x50001200))
// model

/** 0x5000 1204 GPIOJ_INTRISE **/
union GPIOJ_INTRISE_REG{
	unsigned int reg;
	struct GPIOJ_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_INTRISE (*((volatile union GPIOJ_INTRISE_REG *)0x50001204))
// model

/** 0x5000 1208 GPIOJ_INTFALL **/
union GPIOJ_INTFALL_REG{
	unsigned int reg;
	struct GPIOJ_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_INTFALL (*((volatile union GPIOJ_INTFALL_REG *)0x50001208))
// model

/** 0x5000 120C GPIOJ_INTIE **/
union GPIOJ_INTIE_REG{
	unsigned int reg;
	struct GPIOJ_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_INTIE (*((volatile union GPIOJ_INTIE_REG *)0x5000120C))
// model

/** 0x5000 1210 GPIOJ_INTIF **/
union GPIOJ_INTIF_REG{
	unsigned int reg;
	struct GPIOJ_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOJ_INTIF (*((volatile union GPIOJ_INTIF_REG *)0x50001210))
// modelGPIOK

/** 0x5000 1240 GPIOK_INTMS **/
union GPIOK_INTMS_REG{
	unsigned int reg;
	struct GPIOK_INTMS_BITS{
		unsigned int _INTMS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_INTMS (*((volatile union GPIOK_INTMS_REG *)0x50001240))
// model

/** 0x5000 1244 GPIOK_INTRISE **/
union GPIOK_INTRISE_REG{
	unsigned int reg;
	struct GPIOK_INTRISE_BITS{
		unsigned int _INTRISE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_INTRISE (*((volatile union GPIOK_INTRISE_REG *)0x50001244))
// model

/** 0x5000 1248 GPIOK_INTFALL **/
union GPIOK_INTFALL_REG{
	unsigned int reg;
	struct GPIOK_INTFALL_BITS{
		unsigned int _INTFALL:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_INTFALL (*((volatile union GPIOK_INTFALL_REG *)0x50001248))
// model

/** 0x5000 124C GPIOK_INTIE **/
union GPIOK_INTIE_REG{
	unsigned int reg;
	struct GPIOK_INTIE_BITS{
		unsigned int _INTIE:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_INTIE (*((volatile union GPIOK_INTIE_REG *)0x5000124C))
// model

/** 0x5000 1250 GPIOK_INTIF **/
union GPIOK_INTIF_REG{
	unsigned int reg;
	struct GPIOK_INTIF_BITS{
		unsigned int _INTFLAG:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOK_INTIF (*((volatile union GPIOK_INTIF_REG *)0x50001250))
// modelFlexRM

/** 0x4000 2D80 FlexRM_CTL **/
union FlexRM_CTL_REG{
	unsigned int reg;
	struct FlexRM_CTL_BITS{
		unsigned int _G0EN:1;
		unsigned int _G1EN:1;
		unsigned int _G2EN:1;
		unsigned int _G3EN:1;
		unsigned int _G4EN:1;
		unsigned int _G5EN:1;
		unsigned int _G6EN:1;
		unsigned int _G7EN:1;
		unsigned int _G8EN:1;
		unsigned int _G9EN:1;
		unsigned int _G10EN:1;
		unsigned int _G11EN:1;
		unsigned int _CH0TRSEL:1;
		unsigned int _CH1TRSEL:1;
		unsigned int _CH2TRSEL:1;
		unsigned int _CH3TRSEL:1;
		unsigned int _CH4TRSEL:1;
		unsigned int _CH5TRSEL:1;
		unsigned int _CH6TRSEL:1;
		unsigned int _CH7TRSEL:1;
		unsigned int _CH8TRSEL:1;
		unsigned int _CH9TRSEL:1;
		unsigned int _CH10TRSEL:1;
		unsigned int _CH11TRSEL:1;
		unsigned int _G12EN:1;
		unsigned int _G13EN:1;
		unsigned int _G14EN:1;
		unsigned int _G15EN:1;
		unsigned int _CH12TRSEL:1;
		unsigned int _CH13TRSEL:1;
		unsigned int _CH14TRSEL:1;
		unsigned int _CH15TRSEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_CTL (*((volatile union FlexRM_CTL_REG *)0x40002D80))
// model

/** 0x4000 2D84 FlexRM_GPSR0 **/
union FlexRM_GPSR0_REG{
	unsigned int reg;
	struct FlexRM_GPSR0_BITS{
		unsigned int _G0PS:4;
		unsigned int _G1PS:4;
		unsigned int _G2PS:4;
		unsigned int _G3PS:4;
		unsigned int _G4PS:4;
		unsigned int _G5PS:4;
		unsigned int _G6PS:4;
		unsigned int _G7PS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GPSR0 (*((volatile union FlexRM_GPSR0_REG *)0x40002D84))
// model

/** 0x4000 2D88 FlexRM_GPSR1 **/
union FlexRM_GPSR1_REG{
	unsigned int reg;
	struct FlexRM_GPSR1_BITS{
		unsigned int _G8PS:4;
		unsigned int _G9PS:4;
		unsigned int _G10PS:4;
		unsigned int _G11PS:4;
		unsigned int _G12PS:4;
		unsigned int _G13PS:4;
		unsigned int _G14PS:4;
		unsigned int _G15PS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GPSR1 (*((volatile union FlexRM_GPSR1_REG *)0x40002D88))
// model

/** 0x4000 2D8C FlexRM_GCSR0 **/
union FlexRM_GCSR0_REG{
	unsigned int reg;
	struct FlexRM_GCSR0_BITS{
		unsigned int _CH0OS:4;
		unsigned int _G0CIS:4;
		unsigned int _CH1OS:4;
		unsigned int _G1CIS:4;
		unsigned int _CH2OS:4;
		unsigned int _G2CIS:4;
		unsigned int _CH3OS:4;
		unsigned int _G3CIS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR0 (*((volatile union FlexRM_GCSR0_REG *)0x40002D8C))
// model

/** 0x4000 2D90 FlexRM_GCSR1 **/
union FlexRM_GCSR1_REG{
	unsigned int reg;
	struct FlexRM_GCSR1_BITS{
		unsigned int _CH4OS:4;
		unsigned int _G4CIS:4;
		unsigned int _CH5OS:4;
		unsigned int _G5CIS:4;
		unsigned int _CH6OS:4;
		unsigned int _G6CIS:4;
		unsigned int _CH7OS:4;
		unsigned int _G7CIS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR1 (*((volatile union FlexRM_GCSR1_REG *)0x40002D90))
// model

/** 0x4000 2D94 FlexRM_GCSR2 **/
union FlexRM_GCSR2_REG{
	unsigned int reg;
	struct FlexRM_GCSR2_BITS{
		unsigned int _CH8OS:4;
		unsigned int _G8CIS:4;
		unsigned int _CH9OS:4;
		unsigned int _G9CIS:4;
		unsigned int _CH10OS:4;
		unsigned int _G10CIS:4;
		unsigned int _CH11OS:4;
		unsigned int _G11CIS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR2 (*((volatile union FlexRM_GCSR2_REG *)0x40002D94))
// model

/** 0x4000 2D98 FlexRM_GCSR3 **/
union FlexRM_GCSR3_REG{
	unsigned int reg;
	struct FlexRM_GCSR3_BITS{
		unsigned int _G12CIS:4;
		unsigned int _CH12OS:4;
		unsigned int _G13CIS:4;
		unsigned int _CH13OS:4;
		unsigned int _G14CIS:4;
		unsigned int _CH14OS:4;
		unsigned int _G15CIS:4;
		unsigned int _CH15OS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR3 (*((volatile union FlexRM_GCSR3_REG *)0x40002D98))
// modelOSC

/** 0x4000 3900 OSC_CTL0 **/
union OSC_CTL0_REG{
	unsigned int reg;
	struct OSC_CTL0_BITS{
		unsigned int _PMWREN:1;
		unsigned int _SCKS:3;
		unsigned int _LFCKEN:1;
		unsigned int :1;
		unsigned int _LFCKS:2;
		unsigned int _HFCKEN:1;
		unsigned int _HFCKS:3;
		unsigned int _PLL0CKS:1;
		unsigned int _PLL1CKS:1;
		unsigned int :2;
		unsigned int _SCKDIV:3;
		unsigned int :1;
		unsigned int _HFCKDIV:4;
		unsigned int _LFCKDIV:3;
		unsigned int :1;
		unsigned int _PLL0DIV:1;
		unsigned int _PLL1DIV:1;
		unsigned int :1;
		unsigned int _PMCALWREN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL0 (*((volatile union OSC_CTL0_REG *)0x40003900))
// model

/** 0x4000 3904 OSC_CTL1 **/
union OSC_CTL1_REG{
	unsigned int reg;
	struct OSC_CTL1_BITS{
		unsigned int _LPHFDLY:4;
		unsigned int _TESTEN_STOP:1;
		unsigned int _HSEHYEN:1;
		unsigned int _HF1CKEN:1;
		unsigned int _HF1CKS:3;
		unsigned int _HF1CKDIV:4;
		unsigned int _SCLKPMCDIV:2;
		unsigned int _FSCM:1;
		unsigned int _FSCMGAP:3;
		unsigned int :1;
		unsigned int _FSCMS:3;
		unsigned int _CLKOUTS:4;
		unsigned int _CLKOE:1;
		unsigned int _CLKOUTDIV:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL1 (*((volatile union OSC_CTL1_REG *)0x40003904))
// model

/** 0x4000 3908 OSC_INT **/
union OSC_INT_REG{
	unsigned int reg;
	struct OSC_INT_BITS{
		unsigned int _ILFIF:1;
		unsigned int _IHFIF:1;
		unsigned int _ELFIF:1;
		unsigned int _EHFIF:1;
		unsigned int _PLL0IF:1;
		unsigned int _PLL1IF:1;
		unsigned int _LPHFIF:1;
		unsigned int _CKFIF:1;
		unsigned int _ILFIE:1;
		unsigned int _IHFIE:1;
		unsigned int _ELFIE:1;
		unsigned int _EHFIE:1;
		unsigned int _PLL0IE:1;
		unsigned int _PLL1IE:1;
		unsigned int _LPHFIE:1;
		unsigned int :1;
		unsigned int _LPLFIF:1;
		unsigned int :7;
		unsigned int _LPLFIE:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_INT (*((volatile union OSC_INT_REG *)0x40003908))
// model

/** 0x4000 390C OSC_CTL2 **/
union OSC_CTL2_REG{
	unsigned int reg;
	struct OSC_CTL2_BITS{
		unsigned int _INTLFSWEN:1;
		unsigned int _INTHFSWEN:1;
		unsigned int _EXTLFSWEN:1;
		unsigned int _EXTHFSWEN:1;
		unsigned int _PLL0SWEN:1;
		unsigned int _PLL1SWEN:1;
		unsigned int _LPHFSWEN:1;
		unsigned int _LPLFSWEN:1;
		unsigned int _ILFDLY:4;
		unsigned int _IHFDLY:4;
		unsigned int _ELFDLY:4;
		unsigned int _EHFDLY:4;
		unsigned int _PLL0DLY:4;
		unsigned int _PLL1DLY:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL2 (*((volatile union OSC_CTL2_REG *)0x4000390C))
// model

/** 0x4000 3918 OSC_CTL3 **/
union OSC_CTL3_REG{
	unsigned int reg;
	struct OSC_CTL3_BITS{
		unsigned int _HSXTALEXEN:1;
		unsigned int _HSEMODESEL:1;
		unsigned int _GMBOOST:4;
		unsigned int :3;
		unsigned int _XTHR2M:1;
		unsigned int _XTHR470K:1;
		unsigned int _XTHR200K:1;
		unsigned int :1;
		unsigned int _XTHCOMPEN:1;
		unsigned int _XTHCOMPI:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL3 (*((volatile union OSC_CTL3_REG *)0x40003918))
// model

/** 0x4000 3920 OSC_HF2CTL **/
union OSC_HF2CTL_REG{
	unsigned int reg;
	struct OSC_HF2CTL_BITS{
		unsigned int _OSC2EN:1;
		unsigned int _OSC2LDOTSEN:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HF2CTL (*((volatile union OSC_HF2CTL_REG *)0x40003920))
// model

/** 0x4000 3930 OSC_HF3CTL **/
union OSC_HF3CTL_REG{
	unsigned int reg;
	struct OSC_HF3CTL_BITS{
		unsigned int _OSC3EN:1;
		unsigned int _ZVT3TS:1;
		unsigned int _BGTS:1;
		unsigned int _LDO12TS:1;
		unsigned int _LDO15TS:1;
		unsigned int _ZVTTS:1;
		unsigned int _VCOREOEN:1;
		unsigned int _FLASHPOWOEN:1;
		unsigned int _LPPHERIOEN:1;
		unsigned int _RAMAPOWOEN:1;
		unsigned int _RAMBPOWOEN:1;
		unsigned int _FVRCAPMONEN:1;
		unsigned int _FVRCAPLESSMONEN:1;
		unsigned int _FVRCAPLESSOEN:1;
		unsigned int _FVRCAPOEN:1;
		unsigned int _FLASHV12OEN:1;
		unsigned int _VREF1VOEN:1;
		unsigned int :10;
		unsigned int _OSCSEL:1;
		unsigned int _PROCMONEN:1;
		unsigned int _TEMPMONEN:1;
		unsigned int _PROCMONTS:1;
		unsigned int _TEMPMONTS:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_HF3CTL (*((volatile union OSC_HF3CTL_REG *)0x40003930))
// modelPLL0

/** 0x4000 2580 PLL0_CTL **/
union PLL0_CTL_REG{
	unsigned int reg;
	struct PLL0_CTL_BITS{
		unsigned int _PDRST:1;
		unsigned int :1;
		unsigned int _M:14;
		unsigned int _N:4;
		unsigned int _OD:2;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PLL0_CTL (*((volatile union PLL0_CTL_REG *)0x40002580))
// modelPLL1

/** 0x4000 2584 PLL1_CTL **/
union PLL1_CTL_REG{
	unsigned int reg;
	struct PLL1_CTL_BITS{
		unsigned int _PDRST:1;
		unsigned int :1;
		unsigned int _M:14;
		unsigned int _N:4;
		unsigned int _OD:2;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PLL1_CTL (*((volatile union PLL1_CTL_REG *)0x40002584))
// modelMPU

/** 0x4000 5A00 MPU_CTLESR **/
union MPU_CTLESR_REG{
	unsigned int reg;
	struct MPU_CTLESR_BITS{
		unsigned int _MPUEN:1;
		unsigned int :7;
		unsigned int _NRGD:4;
		unsigned int _NSP:4;
		unsigned int _HREV:4;
		unsigned int _SPERIF0:1;
		unsigned int _SPERIF1:1;
		unsigned int _SPERIF2:1;
		unsigned int _SPERIF3:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_CTLESR (*((volatile union MPU_CTLESR_REG *)0x40005A00))
// model

/** 0x4000 5A04 MPU_IER **/
union MPU_IER_REG{
	unsigned int reg;
	struct MPU_IER_BITS{
		unsigned int :16;
		unsigned int _SPERIC0:1;
		unsigned int _SPERIC1:1;
		unsigned int _SPERIC2:1;
		unsigned int _SPERIC3:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_IER (*((volatile union MPU_IER_REG *)0x40005A04))
// model

/** 0x4000 5A08 MPU_IDR **/
union MPU_IDR_REG{
	unsigned int reg;
	struct MPU_IDR_BITS{
		unsigned int _CPID:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_IDR (*((volatile union MPU_IDR_REG *)0x40005A08))
// model

/** 0x4000 5A10 MPU_ERRARS0 **/
union MPU_ERRARS0_REG{
	unsigned int reg;
	struct MPU_ERRARS0_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS0 (*((volatile union MPU_ERRARS0_REG *)0x40005A10))
// model

/** 0x4000 5A14 MPU_ERRDRS0 **/
union MPU_ERRDRS0_REG{
	unsigned int reg;
	struct MPU_ERRDRS0_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS0 (*((volatile union MPU_ERRDRS0_REG *)0x40005A14))
// model

/** 0x4000 5A18 MPU_ERRARS1 **/
union MPU_ERRARS1_REG{
	unsigned int reg;
	struct MPU_ERRARS1_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS1 (*((volatile union MPU_ERRARS1_REG *)0x40005A18))
// model

/** 0x4000 5A1C MPU_ERRDRS1 **/
union MPU_ERRDRS1_REG{
	unsigned int reg;
	struct MPU_ERRDRS1_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS1 (*((volatile union MPU_ERRDRS1_REG *)0x40005A1C))
// model

/** 0x4000 5A20 MPU_ERRARS2 **/
union MPU_ERRARS2_REG{
	unsigned int reg;
	struct MPU_ERRARS2_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS2 (*((volatile union MPU_ERRARS2_REG *)0x40005A20))
// model

/** 0x4000 5A24 MPU_ERRDRS2 **/
union MPU_ERRDRS2_REG{
	unsigned int reg;
	struct MPU_ERRDRS2_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS2 (*((volatile union MPU_ERRDRS2_REG *)0x40005A24))
// model

/** 0x4000 5A28 MPU_ERRARS3 **/
union MPU_ERRARS3_REG{
	unsigned int reg;
	struct MPU_ERRARS3_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRARS3 (*((volatile union MPU_ERRARS3_REG *)0x40005A28))
// model

/** 0x4000 5A2C MPU_ERRDRS3 **/
union MPU_ERRDRS3_REG{
	unsigned int reg;
	struct MPU_ERRDRS3_BITS{
		unsigned int _ERRRW:1;
		unsigned int _ERRATR:3;
		unsigned int _ERRMNU:4;
		unsigned int _ERRPID:8;
		unsigned int _ERRACD:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_ERRDRS3 (*((volatile union MPU_ERRDRS3_REG *)0x40005A2C))
// model

/** 0x4000 5B00 MPU_RGDE0W0 **/
union MPU_RGDE0W0_REG{
	unsigned int reg;
	struct MPU_RGDE0W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE0W0 (*((volatile union MPU_RGDE0W0_REG *)0x40005B00))
// model

/** 0x4000 5B04 MPU_RGDE0W1 **/
union MPU_RGDE0W1_REG{
	unsigned int reg;
	struct MPU_RGDE0W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE0W1 (*((volatile union MPU_RGDE0W1_REG *)0x40005B04))
// model

/** 0x4000 5B08 MPU_RGDE0W2 **/
union MPU_RGDE0W2_REG{
	unsigned int reg;
	struct MPU_RGDE0W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE0W2 (*((volatile union MPU_RGDE0W2_REG *)0x40005B08))
// model

/** 0x4000 5B0C MPU_RGDE0W3 **/
union MPU_RGDE0W3_REG{
	unsigned int reg;
	struct MPU_RGDE0W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE0W3 (*((volatile union MPU_RGDE0W3_REG *)0x40005B0C))
// model

/** 0x4000 5B10 MPU_RGDE1W0 **/
union MPU_RGDE1W0_REG{
	unsigned int reg;
	struct MPU_RGDE1W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W0 (*((volatile union MPU_RGDE1W0_REG *)0x40005B10))
// model

/** 0x4000 5B14 MPU_RGDE1W1 **/
union MPU_RGDE1W1_REG{
	unsigned int reg;
	struct MPU_RGDE1W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W1 (*((volatile union MPU_RGDE1W1_REG *)0x40005B14))
// model

/** 0x4000 5B18 MPU_RGDE1W2 **/
union MPU_RGDE1W2_REG{
	unsigned int reg;
	struct MPU_RGDE1W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W2 (*((volatile union MPU_RGDE1W2_REG *)0x40005B18))
// model

/** 0x4000 5B1C MPU_RGDE1W3 **/
union MPU_RGDE1W3_REG{
	unsigned int reg;
	struct MPU_RGDE1W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE1W3 (*((volatile union MPU_RGDE1W3_REG *)0x40005B1C))
// model

/** 0x4000 5B20 MPU_RGDE2W0 **/
union MPU_RGDE2W0_REG{
	unsigned int reg;
	struct MPU_RGDE2W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W0 (*((volatile union MPU_RGDE2W0_REG *)0x40005B20))
// model

/** 0x4000 5B24 MPU_RGDE2W1 **/
union MPU_RGDE2W1_REG{
	unsigned int reg;
	struct MPU_RGDE2W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W1 (*((volatile union MPU_RGDE2W1_REG *)0x40005B24))
// model

/** 0x4000 5B28 MPU_RGDE2W2 **/
union MPU_RGDE2W2_REG{
	unsigned int reg;
	struct MPU_RGDE2W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W2 (*((volatile union MPU_RGDE2W2_REG *)0x40005B28))
// model

/** 0x4000 5B2C MPU_RGDE2W3 **/
union MPU_RGDE2W3_REG{
	unsigned int reg;
	struct MPU_RGDE2W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE2W3 (*((volatile union MPU_RGDE2W3_REG *)0x40005B2C))
// model

/** 0x4000 5B30 MPU_RGDE3W0 **/
union MPU_RGDE3W0_REG{
	unsigned int reg;
	struct MPU_RGDE3W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W0 (*((volatile union MPU_RGDE3W0_REG *)0x40005B30))
// model

/** 0x4000 5B34 MPU_RGDE3W1 **/
union MPU_RGDE3W1_REG{
	unsigned int reg;
	struct MPU_RGDE3W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W1 (*((volatile union MPU_RGDE3W1_REG *)0x40005B34))
// model

/** 0x4000 5B38 MPU_RGDE3W2 **/
union MPU_RGDE3W2_REG{
	unsigned int reg;
	struct MPU_RGDE3W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W2 (*((volatile union MPU_RGDE3W2_REG *)0x40005B38))
// model

/** 0x4000 5B3C MPU_RGDE3W3 **/
union MPU_RGDE3W3_REG{
	unsigned int reg;
	struct MPU_RGDE3W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE3W3 (*((volatile union MPU_RGDE3W3_REG *)0x40005B3C))
// model

/** 0x4000 5B40 MPU_RGDE4W0 **/
union MPU_RGDE4W0_REG{
	unsigned int reg;
	struct MPU_RGDE4W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W0 (*((volatile union MPU_RGDE4W0_REG *)0x40005B40))
// model

/** 0x4000 5B44 MPU_RGDE4W1 **/
union MPU_RGDE4W1_REG{
	unsigned int reg;
	struct MPU_RGDE4W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W1 (*((volatile union MPU_RGDE4W1_REG *)0x40005B44))
// model

/** 0x4000 5B48 MPU_RGDE4W2 **/
union MPU_RGDE4W2_REG{
	unsigned int reg;
	struct MPU_RGDE4W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W2 (*((volatile union MPU_RGDE4W2_REG *)0x40005B48))
// model

/** 0x4000 5B4C MPU_RGDE4W3 **/
union MPU_RGDE4W3_REG{
	unsigned int reg;
	struct MPU_RGDE4W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE4W3 (*((volatile union MPU_RGDE4W3_REG *)0x40005B4C))
// model

/** 0x4000 5B50 MPU_RGDE5W0 **/
union MPU_RGDE5W0_REG{
	unsigned int reg;
	struct MPU_RGDE5W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W0 (*((volatile union MPU_RGDE5W0_REG *)0x40005B50))
// model

/** 0x4000 5B54 MPU_RGDE5W1 **/
union MPU_RGDE5W1_REG{
	unsigned int reg;
	struct MPU_RGDE5W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W1 (*((volatile union MPU_RGDE5W1_REG *)0x40005B54))
// model

/** 0x4000 5B58 MPU_RGDE5W2 **/
union MPU_RGDE5W2_REG{
	unsigned int reg;
	struct MPU_RGDE5W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W2 (*((volatile union MPU_RGDE5W2_REG *)0x40005B58))
// model

/** 0x4000 5B5C MPU_RGDE5W3 **/
union MPU_RGDE5W3_REG{
	unsigned int reg;
	struct MPU_RGDE5W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE5W3 (*((volatile union MPU_RGDE5W3_REG *)0x40005B5C))
// model

/** 0x4000 5B60 MPU_RGDE6W0 **/
union MPU_RGDE6W0_REG{
	unsigned int reg;
	struct MPU_RGDE6W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W0 (*((volatile union MPU_RGDE6W0_REG *)0x40005B60))
// model

/** 0x4000 5B64 MPU_RGDE6W1 **/
union MPU_RGDE6W1_REG{
	unsigned int reg;
	struct MPU_RGDE6W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W1 (*((volatile union MPU_RGDE6W1_REG *)0x40005B64))
// model

/** 0x4000 5B68 MPU_RGDE6W2 **/
union MPU_RGDE6W2_REG{
	unsigned int reg;
	struct MPU_RGDE6W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W2 (*((volatile union MPU_RGDE6W2_REG *)0x40005B68))
// model

/** 0x4000 5B6C MPU_RGDE6W3 **/
union MPU_RGDE6W3_REG{
	unsigned int reg;
	struct MPU_RGDE6W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE6W3 (*((volatile union MPU_RGDE6W3_REG *)0x40005B6C))
// model

/** 0x4000 5B70 MPU_RGDE7W0 **/
union MPU_RGDE7W0_REG{
	unsigned int reg;
	struct MPU_RGDE7W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W0 (*((volatile union MPU_RGDE7W0_REG *)0x40005B70))
// model

/** 0x4000 5B74 MPU_RGDE7W1 **/
union MPU_RGDE7W1_REG{
	unsigned int reg;
	struct MPU_RGDE7W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W1 (*((volatile union MPU_RGDE7W1_REG *)0x40005B74))
// model

/** 0x4000 5B78 MPU_RGDE7W2 **/
union MPU_RGDE7W2_REG{
	unsigned int reg;
	struct MPU_RGDE7W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W2 (*((volatile union MPU_RGDE7W2_REG *)0x40005B78))
// model

/** 0x4000 5B7C MPU_RGDE7W3 **/
union MPU_RGDE7W3_REG{
	unsigned int reg;
	struct MPU_RGDE7W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE7W3 (*((volatile union MPU_RGDE7W3_REG *)0x40005B7C))
// model

/** 0x4000 5B80 MPU_RGDE8W0 **/
union MPU_RGDE8W0_REG{
	unsigned int reg;
	struct MPU_RGDE8W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W0 (*((volatile union MPU_RGDE8W0_REG *)0x40005B80))
// model

/** 0x4000 5B84 MPU_RGDE8W1 **/
union MPU_RGDE8W1_REG{
	unsigned int reg;
	struct MPU_RGDE8W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W1 (*((volatile union MPU_RGDE8W1_REG *)0x40005B84))
// model

/** 0x4000 5B88 MPU_RGDE8W2 **/
union MPU_RGDE8W2_REG{
	unsigned int reg;
	struct MPU_RGDE8W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W2 (*((volatile union MPU_RGDE8W2_REG *)0x40005B88))
// model

/** 0x4000 5B8C MPU_RGDE8W3 **/
union MPU_RGDE8W3_REG{
	unsigned int reg;
	struct MPU_RGDE8W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE8W3 (*((volatile union MPU_RGDE8W3_REG *)0x40005B8C))
// model

/** 0x4000 5B90 MPU_RGDE9W0 **/
union MPU_RGDE9W0_REG{
	unsigned int reg;
	struct MPU_RGDE9W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W0 (*((volatile union MPU_RGDE9W0_REG *)0x40005B90))
// model

/** 0x4000 5B94 MPU_RGDE9W1 **/
union MPU_RGDE9W1_REG{
	unsigned int reg;
	struct MPU_RGDE9W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W1 (*((volatile union MPU_RGDE9W1_REG *)0x40005B94))
// model

/** 0x4000 5B98 MPU_RGDE9W2 **/
union MPU_RGDE9W2_REG{
	unsigned int reg;
	struct MPU_RGDE9W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W2 (*((volatile union MPU_RGDE9W2_REG *)0x40005B98))
// model

/** 0x4000 5B9C MPU_RGDE9W3 **/
union MPU_RGDE9W3_REG{
	unsigned int reg;
	struct MPU_RGDE9W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE9W3 (*((volatile union MPU_RGDE9W3_REG *)0x40005B9C))
// model

/** 0x4000 5BA0 MPU_RGDE10W0 **/
union MPU_RGDE10W0_REG{
	unsigned int reg;
	struct MPU_RGDE10W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W0 (*((volatile union MPU_RGDE10W0_REG *)0x40005BA0))
// model

/** 0x4000 5BA4 MPU_RGDE10W1 **/
union MPU_RGDE10W1_REG{
	unsigned int reg;
	struct MPU_RGDE10W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W1 (*((volatile union MPU_RGDE10W1_REG *)0x40005BA4))
// model

/** 0x4000 5BA8 MPU_RGDE10W2 **/
union MPU_RGDE10W2_REG{
	unsigned int reg;
	struct MPU_RGDE10W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W2 (*((volatile union MPU_RGDE10W2_REG *)0x40005BA8))
// model

/** 0x4000 5BAC MPU_RGDE10W3 **/
union MPU_RGDE10W3_REG{
	unsigned int reg;
	struct MPU_RGDE10W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE10W3 (*((volatile union MPU_RGDE10W3_REG *)0x40005BAC))
// model

/** 0x4000 5BB0 MPU_RGDE11W0 **/
union MPU_RGDE11W0_REG{
	unsigned int reg;
	struct MPU_RGDE11W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W0 (*((volatile union MPU_RGDE11W0_REG *)0x40005BB0))
// model

/** 0x4000 5BB4 MPU_RGDE11W1 **/
union MPU_RGDE11W1_REG{
	unsigned int reg;
	struct MPU_RGDE11W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W1 (*((volatile union MPU_RGDE11W1_REG *)0x40005BB4))
// model

/** 0x4000 5BB8 MPU_RGDE11W2 **/
union MPU_RGDE11W2_REG{
	unsigned int reg;
	struct MPU_RGDE11W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W2 (*((volatile union MPU_RGDE11W2_REG *)0x40005BB8))
// model

/** 0x4000 5BBC MPU_RGDE11W3 **/
union MPU_RGDE11W3_REG{
	unsigned int reg;
	struct MPU_RGDE11W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE11W3 (*((volatile union MPU_RGDE11W3_REG *)0x40005BBC))
// model

/** 0x4000 5BC0 MPU_RGDE12W0 **/
union MPU_RGDE12W0_REG{
	unsigned int reg;
	struct MPU_RGDE12W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W0 (*((volatile union MPU_RGDE12W0_REG *)0x40005BC0))
// model

/** 0x4000 5BC4 MPU_RGDE12W1 **/
union MPU_RGDE12W1_REG{
	unsigned int reg;
	struct MPU_RGDE12W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W1 (*((volatile union MPU_RGDE12W1_REG *)0x40005BC4))
// model

/** 0x4000 5BC8 MPU_RGDE12W2 **/
union MPU_RGDE12W2_REG{
	unsigned int reg;
	struct MPU_RGDE12W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W2 (*((volatile union MPU_RGDE12W2_REG *)0x40005BC8))
// model

/** 0x4000 5BCC MPU_RGDE12W3 **/
union MPU_RGDE12W3_REG{
	unsigned int reg;
	struct MPU_RGDE12W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE12W3 (*((volatile union MPU_RGDE12W3_REG *)0x40005BCC))
// model

/** 0x4000 5BD0 MPU_RGDE13W0 **/
union MPU_RGDE13W0_REG{
	unsigned int reg;
	struct MPU_RGDE13W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W0 (*((volatile union MPU_RGDE13W0_REG *)0x40005BD0))
// model

/** 0x4000 5BD4 MPU_RGDE13W1 **/
union MPU_RGDE13W1_REG{
	unsigned int reg;
	struct MPU_RGDE13W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W1 (*((volatile union MPU_RGDE13W1_REG *)0x40005BD4))
// model

/** 0x4000 5BD8 MPU_RGDE13W2 **/
union MPU_RGDE13W2_REG{
	unsigned int reg;
	struct MPU_RGDE13W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W2 (*((volatile union MPU_RGDE13W2_REG *)0x40005BD8))
// model

/** 0x4000 5BDC MPU_RGDE13W3 **/
union MPU_RGDE13W3_REG{
	unsigned int reg;
	struct MPU_RGDE13W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE13W3 (*((volatile union MPU_RGDE13W3_REG *)0x40005BDC))
// model

/** 0x4000 5BE0 MPU_RGDE14W0 **/
union MPU_RGDE14W0_REG{
	unsigned int reg;
	struct MPU_RGDE14W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W0 (*((volatile union MPU_RGDE14W0_REG *)0x40005BE0))
// model

/** 0x4000 5BE4 MPU_RGDE14W1 **/
union MPU_RGDE14W1_REG{
	unsigned int reg;
	struct MPU_RGDE14W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W1 (*((volatile union MPU_RGDE14W1_REG *)0x40005BE4))
// model

/** 0x4000 5BE8 MPU_RGDE14W2 **/
union MPU_RGDE14W2_REG{
	unsigned int reg;
	struct MPU_RGDE14W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W2 (*((volatile union MPU_RGDE14W2_REG *)0x40005BE8))
// model

/** 0x4000 5BEC MPU_RGDE14W3 **/
union MPU_RGDE14W3_REG{
	unsigned int reg;
	struct MPU_RGDE14W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE14W3 (*((volatile union MPU_RGDE14W3_REG *)0x40005BEC))
// model

/** 0x4000 5BF0 MPU_RGDE15W0 **/
union MPU_RGDE15W0_REG{
	unsigned int reg;
	struct MPU_RGDE15W0_BITS{
		unsigned int :5;
		unsigned int _STRADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W0 (*((volatile union MPU_RGDE15W0_REG *)0x40005BF0))
// model

/** 0x4000 5BF4 MPU_RGDE15W1 **/
union MPU_RGDE15W1_REG{
	unsigned int reg;
	struct MPU_RGDE15W1_BITS{
		unsigned int :5;
		unsigned int _ENDADDR:27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W1 (*((volatile union MPU_RGDE15W1_REG *)0x40005BF4))
// model

/** 0x4000 5BF8 MPU_RGDE15W2 **/
union MPU_RGDE15W2_REG{
	unsigned int reg;
	struct MPU_RGDE15W2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W2 (*((volatile union MPU_RGDE15W2_REG *)0x40005BF8))
// model

/** 0x4000 5BFC MPU_RGDE15W3 **/
union MPU_RGDE15W3_REG{
	unsigned int reg;
	struct MPU_RGDE15W3_BITS{
		unsigned int _RGDEVLD:1;
		unsigned int :15;
		unsigned int _PIDMSK:8;
		unsigned int _PID:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDE15W3 (*((volatile union MPU_RGDE15W3_REG *)0x40005BFC))
// model

/** 0x4000 5D00 MPU_RGDEACC0 **/
union MPU_RGDEACC0_REG{
	unsigned int reg;
	struct MPU_RGDEACC0_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC0 (*((volatile union MPU_RGDEACC0_REG *)0x40005D00))
// model

/** 0x4000 5D04 MPU_RGDEACC1 **/
union MPU_RGDEACC1_REG{
	unsigned int reg;
	struct MPU_RGDEACC1_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC1 (*((volatile union MPU_RGDEACC1_REG *)0x40005D04))
// model

/** 0x4000 5D08 MPU_RGDEACC2 **/
union MPU_RGDEACC2_REG{
	unsigned int reg;
	struct MPU_RGDEACC2_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC2 (*((volatile union MPU_RGDEACC2_REG *)0x40005D08))
// model

/** 0x4000 5D0C MPU_RGDEACC3 **/
union MPU_RGDEACC3_REG{
	unsigned int reg;
	struct MPU_RGDEACC3_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC3 (*((volatile union MPU_RGDEACC3_REG *)0x40005D0C))
// model

/** 0x4000 5D10 MPU_RGDEACC4 **/
union MPU_RGDEACC4_REG{
	unsigned int reg;
	struct MPU_RGDEACC4_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC4 (*((volatile union MPU_RGDEACC4_REG *)0x40005D10))
// model

/** 0x4000 5D14 MPU_RGDEACC5 **/
union MPU_RGDEACC5_REG{
	unsigned int reg;
	struct MPU_RGDEACC5_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC5 (*((volatile union MPU_RGDEACC5_REG *)0x40005D14))
// model

/** 0x4000 5D18 MPU_RGDEACC6 **/
union MPU_RGDEACC6_REG{
	unsigned int reg;
	struct MPU_RGDEACC6_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC6 (*((volatile union MPU_RGDEACC6_REG *)0x40005D18))
// model

/** 0x4000 5D1C MPU_RGDEACC7 **/
union MPU_RGDEACC7_REG{
	unsigned int reg;
	struct MPU_RGDEACC7_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC7 (*((volatile union MPU_RGDEACC7_REG *)0x40005D1C))
// model

/** 0x4000 5D20 MPU_RGDEACC8 **/
union MPU_RGDEACC8_REG{
	unsigned int reg;
	struct MPU_RGDEACC8_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC8 (*((volatile union MPU_RGDEACC8_REG *)0x40005D20))
// model

/** 0x4000 5D24 MPU_RGDEACC9 **/
union MPU_RGDEACC9_REG{
	unsigned int reg;
	struct MPU_RGDEACC9_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC9 (*((volatile union MPU_RGDEACC9_REG *)0x40005D24))
// model

/** 0x4000 5D28 MPU_RGDEACC10 **/
union MPU_RGDEACC10_REG{
	unsigned int reg;
	struct MPU_RGDEACC10_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC10 (*((volatile union MPU_RGDEACC10_REG *)0x40005D28))
// model

/** 0x4000 5D2C MPU_RGDEACC11 **/
union MPU_RGDEACC11_REG{
	unsigned int reg;
	struct MPU_RGDEACC11_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC11 (*((volatile union MPU_RGDEACC11_REG *)0x40005D2C))
// model

/** 0x4000 5D30 MPU_RGDEACC12 **/
union MPU_RGDEACC12_REG{
	unsigned int reg;
	struct MPU_RGDEACC12_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC12 (*((volatile union MPU_RGDEACC12_REG *)0x40005D30))
// model

/** 0x4000 5D34 MPU_RGDEACC13 **/
union MPU_RGDEACC13_REG{
	unsigned int reg;
	struct MPU_RGDEACC13_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC13 (*((volatile union MPU_RGDEACC13_REG *)0x40005D34))
// model

/** 0x4000 5D38 MPU_RGDEACC14 **/
union MPU_RGDEACC14_REG{
	unsigned int reg;
	struct MPU_RGDEACC14_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC14 (*((volatile union MPU_RGDEACC14_REG *)0x40005D38))
// model

/** 0x4000 5D3C MPU_RGDEACC15 **/
union MPU_RGDEACC15_REG{
	unsigned int reg;
	struct MPU_RGDEACC15_BITS{
		unsigned int _M0UMAC:3;
		unsigned int _M0SMAC:2;
		unsigned int _M0PEN:1;
		unsigned int _M1UMAC:3;
		unsigned int _M1SMAC:2;
		unsigned int _M1PEN:1;
		unsigned int _M2UMAC:3;
		unsigned int _M2SMAC:2;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define MPU_RGDEACC15 (*((volatile union MPU_RGDEACC15_REG *)0x40005D3C))
// modelINT

/** 0x4020 0000 INT_CTL0 **/
union INT_CTL0_REG{
	unsigned int reg;
	struct INT_CTL0_BITS{
		unsigned int _AIE:1;
		unsigned int _PRIGROUP:2;
		unsigned int :1;
		unsigned int _INTPENDING:1;
		unsigned int _INTPREEMPT:1;
		unsigned int _FAULTMASK:1;
		unsigned int _DSALIGN:1;
		unsigned int :4;
		unsigned int _PRIBASE:4;
		unsigned int _INTPEND:7;
		unsigned int :1;
		unsigned int _INTACT:7;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL0 (*((volatile union INT_CTL0_REG *)0x40200000))
// model

/** 0x4020 009C INT_CTL1 **/
union INT_CTL1_REG{
	unsigned int reg;
	struct INT_CTL1_BITS{
		unsigned int _INTDELY:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL1 (*((volatile union INT_CTL1_REG *)0x4020009C))
// model

/** 0x4020 0004 INT_EIE0 **/
union INT_EIE0_REG{
	unsigned int reg;
	struct INT_EIE0_BITS{
		unsigned int :3;
		unsigned int _HADRFAULTIE:1;
		unsigned int :1;
		unsigned int _STACKIE:1;
		unsigned int _ARIFAULTIE:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SVCIE:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIE:1;
		unsigned int _SYSTICKIE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE0 (*((volatile union INT_EIE0_REG *)0x40200004))
// model

/** 0x4020 000C INT_EIE1 **/
union INT_EIE1_REG{
	unsigned int reg;
	struct INT_EIE1_BITS{
		unsigned int _WWDTIE:1;
		unsigned int _EINT16IE:1;
		unsigned int _PAIE:1;
		unsigned int _PBIE:1;
		unsigned int _PCIE:1;
		unsigned int _PDIE:1;
		unsigned int _PEIE:1;
		unsigned int _PFIE:1;
		unsigned int _PXIE:1;
		unsigned int _T1IE:1;
		unsigned int _T3IE:1;
		unsigned int _T5IE:1;
		unsigned int _T6IE:1;
		unsigned int _QEI0IE:1;
		unsigned int _QEI1IE:1;
		unsigned int _ECFGLIE:1;
		unsigned int _CAN4IE:1;
		unsigned int _T14IE:1;
		unsigned int _RNGIE:1;
		unsigned int _FDC2IE:1;
		unsigned int _EXMCIE:1;
		unsigned int _ADC0IE:1;
		unsigned int _ADC1IE:1;
		unsigned int _CFGLIE:1;
		unsigned int _T11IE:1;
		unsigned int _T0IE:1;
		unsigned int _DMA0IE:1;
		unsigned int _CMPIE:1;
		unsigned int _USART0IE:1;
		unsigned int _USART1IE:1;
		unsigned int _SPI0IE:1;
		unsigned int _SPI1IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE1 (*((volatile union INT_EIE1_REG *)0x4020000C))
// model

/** 0x4020 0014 INT_EIE2 **/
union INT_EIE2_REG{
	unsigned int reg;
	struct INT_EIE2_BITS{
		unsigned int _DMA1IE:1;
		unsigned int _EINT19TO17IE:1;
		unsigned int _CANFD6IE:1;
		unsigned int _CANFD7IE:1;
		unsigned int _FDC0IE:1;
		unsigned int _FDC1IE:1;
		unsigned int _EINT31TO20IE:1;
		unsigned int _CMUIE:1;
		unsigned int _OSCIE:1;
		unsigned int _I2C0IE:1;
		unsigned int _I2C1IE:1;
		unsigned int _I2C2IE:1;
		unsigned int _T12IE:1;
		unsigned int _T2IE:1;
		unsigned int _T4IE:1;
		unsigned int _T13IE:1;
		unsigned int _USART2IE:1;
		unsigned int _T16IE:1;
		unsigned int _USART4IE:1;
		unsigned int _SPI2IE:1;
		unsigned int _SPI3IE:1;
		unsigned int _ADC2IE:1;
		unsigned int _T18IE:1;
		unsigned int _T19IE:1;
		unsigned int _HRCAP0IE:1;
		unsigned int _WKPIE:1;
		unsigned int _HRCAP1IE:1;
		unsigned int _T21IE:1;
		unsigned int _I2C3IE:1;
		unsigned int _USART5IE:1;
		unsigned int _HRCAP2IE:1;
		unsigned int _USART7IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE2 (*((volatile union INT_EIE2_REG *)0x40200014))
// model

/** 0x4020 0018 INT_EIE3 **/
union INT_EIE3_REG{
	unsigned int reg;
	struct INT_EIE3_BITS{
		unsigned int _USART3IE:1;
		unsigned int _USART6IE:1;
		unsigned int _USART8IE:1;
		unsigned int _USART9IE:1;
		unsigned int _USART10IE:1;
		unsigned int _USART11IE:1;
		unsigned int _USART12IE:1;
		unsigned int _USART13IE:1;
		unsigned int _USART14IE:1;
		unsigned int _USART15IE:1;
		unsigned int _CANFD8IE:1;
		unsigned int _CANFD9IE:1;
		unsigned int _CANFD10IE:1;
		unsigned int _CANFD11IE:1;
		unsigned int _CANFD12IE:1;
		unsigned int _CANFD13IE:1;
		unsigned int _T31IE:1;
		unsigned int _T32IE:1;
		unsigned int _T33IE:1;
		unsigned int _T36IE:1;
		unsigned int _T9IE:1;
		unsigned int _T10IE:1;
		unsigned int _T25IE:1;
		unsigned int _T26IE:1;
		unsigned int _T20IE:1;
		unsigned int _T22IE:1;
		unsigned int _T23IE:1;
		unsigned int _SRAMECCIE:1;
		unsigned int _DRAMECCIE:1;
		unsigned int _CACHEECCIE:1;
		unsigned int _FLASHECCIE:1;
		unsigned int _ISMUIE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE3 (*((volatile union INT_EIE3_REG *)0x40200018))
// model

/** 0x4020 0300  INT_EIE4 **/
union  INT_EIE4_REG{
	unsigned int reg;
	struct  INT_EIE4_BITS{
		unsigned int _QSPIIE:1;
		unsigned int _CTOUCHIE:1;
		unsigned int _HRCAP3IE:1;
		unsigned int _HRCAP4IE:1;
		unsigned int _HRCAP5IE:1;
		unsigned int _AESIE:1;
		unsigned int _BUSERRIE:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  INT_EIE4 (*((volatile union  INT_EIE4_REG *)0x40200300))
// model

/** 0x4020 001C INT_EIF0 **/
union INT_EIF0_REG{
	unsigned int reg;
	struct INT_EIF0_BITS{
		unsigned int :2;
		unsigned int _NMIIF:1;
		unsigned int _HARDAFULTIF:1;
		unsigned int :1;
		unsigned int _STACKIF:1;
		unsigned int _ARIFAULTIF:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SVCIF:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIF:1;
		unsigned int _SYSTICKIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF0 (*((volatile union INT_EIF0_REG *)0x4020001C))
// model

/** 0x4020 0024 INT_EIF1 **/
union INT_EIF1_REG{
	unsigned int reg;
	struct INT_EIF1_BITS{
		unsigned int _WWDTIF:1;
		unsigned int _EINT16IF:1;
		unsigned int _PAIF:1;
		unsigned int _PBIF:1;
		unsigned int _PCIF:1;
		unsigned int _PDIF:1;
		unsigned int _PEIF:1;
		unsigned int _PFIF:1;
		unsigned int _PXIF:1;
		unsigned int _T1IF:1;
		unsigned int _T3IF:1;
		unsigned int _T5IF:1;
		unsigned int _T6IF:1;
		unsigned int _QEI0IF:1;
		unsigned int _QEI1IF:1;
		unsigned int _ECFGLIF:1;
		unsigned int _CAN4IF:1;
		unsigned int _T14IF:1;
		unsigned int _RNGIF:1;
		unsigned int _FDC2IF:1;
		unsigned int _EXMCIF:1;
		unsigned int _ADC0IF:1;
		unsigned int _ADC1IF:1;
		unsigned int _CFGLIF:1;
		unsigned int _T11IF:1;
		unsigned int _T0IF:1;
		unsigned int _DMA0IF:1;
		unsigned int _CMPIF:1;
		unsigned int _USART0IF:1;
		unsigned int _USART1IF:1;
		unsigned int _SPI0IF:1;
		unsigned int _SPI1IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF1 (*((volatile union INT_EIF1_REG *)0x40200024))
// model

/** 0x4020 002C INT_EIF2 **/
union INT_EIF2_REG{
	unsigned int reg;
	struct INT_EIF2_BITS{
		unsigned int _DMA1IF:1;
		unsigned int _EINT19TO17IF:1;
		unsigned int _CANFD6IF:1;
		unsigned int _CANFD7IF:1;
		unsigned int _FDC0IF:1;
		unsigned int _FDC1IF:1;
		unsigned int _EINT31TO20IF:1;
		unsigned int _CMUIE:1;
		unsigned int _OSCIF:1;
		unsigned int _I2C0IF:1;
		unsigned int _I2C1IF:1;
		unsigned int _I2C2IF:1;
		unsigned int _T12IF:1;
		unsigned int _T2IF:1;
		unsigned int _T4IF:1;
		unsigned int _T13IF:1;
		unsigned int _USART2IF:1;
		unsigned int _T16IF:1;
		unsigned int _USART4IF:1;
		unsigned int _SPI2IF:1;
		unsigned int _SPI3IF:1;
		unsigned int _ADC2IF:1;
		unsigned int _T18IF:1;
		unsigned int _T19IF:1;
		unsigned int _HRCAP0IF:1;
		unsigned int _WKPIF:1;
		unsigned int _HRCAP1IF:1;
		unsigned int _T21IF:1;
		unsigned int _I2C3IF:1;
		unsigned int _USART5IF:1;
		unsigned int _HRCAP2IF:1;
		unsigned int _USART7IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF2 (*((volatile union INT_EIF2_REG *)0x4020002C))
// model

/** 0x4020 0030 INT_EIF3 **/
union INT_EIF3_REG{
	unsigned int reg;
	struct INT_EIF3_BITS{
		unsigned int _USART3IF:1;
		unsigned int _USART6IF:1;
		unsigned int _USART8IF:1;
		unsigned int _USART9IF:1;
		unsigned int _USART10IF:1;
		unsigned int _USART11IF:1;
		unsigned int _USART12IF:1;
		unsigned int _USART13IF:1;
		unsigned int _USART14IF:1;
		unsigned int _USART15IF:1;
		unsigned int _CANFD8IF:1;
		unsigned int _CANFD9IF:1;
		unsigned int _CANFD10IF:1;
		unsigned int _CANFD11IF:1;
		unsigned int _CANFD12IF:1;
		unsigned int _CANFD13IF:1;
		unsigned int _T31IF:1;
		unsigned int _T32IF:1;
		unsigned int _T33IF:1;
		unsigned int _T36IF:1;
		unsigned int _T9IF:1;
		unsigned int _T10IF:1;
		unsigned int _T25IF:1;
		unsigned int _T26IF:1;
		unsigned int _T20IF:1;
		unsigned int _T22IF:1;
		unsigned int _T23IF:1;
		unsigned int _SRAMECCIF:1;
		unsigned int _DRAMECCIF:1;
		unsigned int _CACHEECCIF:1;
		unsigned int _FLASHECCIF:1;
		unsigned int _ISMUIF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF3 (*((volatile union INT_EIF3_REG *)0x40200030))
// model

/** 0x4020 0304 INT_EIF4 **/
union INT_EIF4_REG{
	unsigned int reg;
	struct INT_EIF4_BITS{
		unsigned int _QSPIIF:1;
		unsigned int _CTOUCHIF:1;
		unsigned int _HRCAP3IF:1;
		unsigned int _HRCAP4IF:1;
		unsigned int _HRCAP5IF:1;
		unsigned int _AESIF:1;
		unsigned int _BUSERRIF:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF4 (*((volatile union INT_EIF4_REG *)0x40200304))
// model

/** 0x4020 0034 INT_IP0 **/
union INT_IP0_REG{
	unsigned int reg;
	struct INT_IP0_BITS{
		unsigned int _PRI4:8;
		unsigned int _PRI5:8;
		unsigned int _PRI6:8;
		unsigned int _PRI7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP0 (*((volatile union INT_IP0_REG *)0x40200034))
// model

/** 0x4020 0038 INT_IP1 **/
union INT_IP1_REG{
	unsigned int reg;
	struct INT_IP1_BITS{
		unsigned int _PRI8:8;
		unsigned int _PRI9:8;
		unsigned int _PRI10:8;
		unsigned int _PRI11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP1 (*((volatile union INT_IP1_REG *)0x40200038))
// model

/** 0x4020 003C INT_IP2 **/
union INT_IP2_REG{
	unsigned int reg;
	struct INT_IP2_BITS{
		unsigned int _PRI12:8;
		unsigned int _PRI13:8;
		unsigned int _PRI14:8;
		unsigned int _PRI15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP2 (*((volatile union INT_IP2_REG *)0x4020003C))
// model

/** 0x4020 0040 INT_IP3 **/
union INT_IP3_REG{
	unsigned int reg;
	struct INT_IP3_BITS{
		unsigned int _PRI16:8;
		unsigned int _PRI17:8;
		unsigned int _PRI18:8;
		unsigned int _PRI19:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP3 (*((volatile union INT_IP3_REG *)0x40200040))
// model

/** 0x4020 0044 INT_IP4 **/
union INT_IP4_REG{
	unsigned int reg;
	struct INT_IP4_BITS{
		unsigned int _PRI20:8;
		unsigned int _PRI21:8;
		unsigned int _PRI22:8;
		unsigned int _PRI23:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP4 (*((volatile union INT_IP4_REG *)0x40200044))
// model

/** 0x4020 0048 INT_IP5 **/
union INT_IP5_REG{
	unsigned int reg;
	struct INT_IP5_BITS{
		unsigned int _PRI24:8;
		unsigned int _PRI25:8;
		unsigned int _PRI26:8;
		unsigned int _PRI27:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP5 (*((volatile union INT_IP5_REG *)0x40200048))
// model

/** 0x4020 004C INT_IP6 **/
union INT_IP6_REG{
	unsigned int reg;
	struct INT_IP6_BITS{
		unsigned int _PRI28:8;
		unsigned int _PRI29:8;
		unsigned int _PRI30:8;
		unsigned int _PRI31:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP6 (*((volatile union INT_IP6_REG *)0x4020004C))
// model

/** 0x4020 0050 INT_IP7 **/
union INT_IP7_REG{
	unsigned int reg;
	struct INT_IP7_BITS{
		unsigned int _PRI32:8;
		unsigned int _PRI33:8;
		unsigned int _PRI34:8;
		unsigned int _PRI35:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP7 (*((volatile union INT_IP7_REG *)0x40200050))
// model

/** 0x4020 0054 INT_IP8 **/
union INT_IP8_REG{
	unsigned int reg;
	struct INT_IP8_BITS{
		unsigned int _PR36:8;
		unsigned int _PRI37:8;
		unsigned int _PRI38:8;
		unsigned int _PRI339:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP8 (*((volatile union INT_IP8_REG *)0x40200054))
// model

/** 0x4020 0058 INT_IP9 **/
union INT_IP9_REG{
	unsigned int reg;
	struct INT_IP9_BITS{
		unsigned int _PRI40:8;
		unsigned int _PRI41:8;
		unsigned int _PRI42:8;
		unsigned int _PRI43:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP9 (*((volatile union INT_IP9_REG *)0x40200058))
// model

/** 0x4020 005C INT_IP10 **/
union INT_IP10_REG{
	unsigned int reg;
	struct INT_IP10_BITS{
		unsigned int _PRI44:8;
		unsigned int _PRI45:8;
		unsigned int _PRI46:8;
		unsigned int _PRI47:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP10 (*((volatile union INT_IP10_REG *)0x4020005C))
// model

/** 0x4020 0060 INT_IP11 **/
union INT_IP11_REG{
	unsigned int reg;
	struct INT_IP11_BITS{
		unsigned int _PRI48:8;
		unsigned int _PRI49:8;
		unsigned int _PRI50:8;
		unsigned int _PRI51:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP11 (*((volatile union INT_IP11_REG *)0x40200060))
// model

/** 0x4020 0064 INT_IP12 **/
union INT_IP12_REG{
	unsigned int reg;
	struct INT_IP12_BITS{
		unsigned int _PRI52:8;
		unsigned int _PRI53:8;
		unsigned int _PRI54:8;
		unsigned int _PRI55:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP12 (*((volatile union INT_IP12_REG *)0x40200064))
// model

/** 0x4020 0068 INT_IP13 **/
union INT_IP13_REG{
	unsigned int reg;
	struct INT_IP13_BITS{
		unsigned int _PRI56:8;
		unsigned int _PRI57:8;
		unsigned int _PRI58:8;
		unsigned int _PRI59:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP13 (*((volatile union INT_IP13_REG *)0x40200068))
// model

/** 0x4020 006C INT_IP14 **/
union INT_IP14_REG{
	unsigned int reg;
	struct INT_IP14_BITS{
		unsigned int _PRI60:8;
		unsigned int _PRI61:8;
		unsigned int _PRI62:8;
		unsigned int _PRI63:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP14 (*((volatile union INT_IP14_REG *)0x4020006C))
// model

/** 0x4020 0070 INT_IP15 **/
union INT_IP15_REG{
	unsigned int reg;
	struct INT_IP15_BITS{
		unsigned int _PRI64:8;
		unsigned int _PRI65:8;
		unsigned int _PRI66:8;
		unsigned int _PRI67:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP15 (*((volatile union INT_IP15_REG *)0x40200070))
// model

/** 0x4020 0074 INT_IP16 **/
union INT_IP16_REG{
	unsigned int reg;
	struct INT_IP16_BITS{
		unsigned int _PRI68:8;
		unsigned int _PRI69:8;
		unsigned int _PRI70:8;
		unsigned int _PRI71:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP16 (*((volatile union INT_IP16_REG *)0x40200074))
// model

/** 0x4020 0078 INT_IP17 **/
union INT_IP17_REG{
	unsigned int reg;
	struct INT_IP17_BITS{
		unsigned int _PRI72:8;
		unsigned int _PRI73:8;
		unsigned int _PRI74:8;
		unsigned int _PRI75:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP17 (*((volatile union INT_IP17_REG *)0x40200078))
// model

/** 0x4020 007C INT_IP18 **/
union INT_IP18_REG{
	unsigned int reg;
	struct INT_IP18_BITS{
		unsigned int _PRI76:8;
		unsigned int _PRI77:8;
		unsigned int _PRI78:8;
		unsigned int _PRI79:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP18 (*((volatile union INT_IP18_REG *)0x4020007C))
// model

/** 0x4020 00E0 INT_IP19 **/
union INT_IP19_REG{
	unsigned int reg;
	struct INT_IP19_BITS{
		unsigned int _PRI80:8;
		unsigned int _PRI81:8;
		unsigned int _PRI82:8;
		unsigned int _PRI83:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP19 (*((volatile union INT_IP19_REG *)0x402000E0))
// model

/** 0x4020 00E4 INT_IP20 **/
union INT_IP20_REG{
	unsigned int reg;
	struct INT_IP20_BITS{
		unsigned int _PRI84:8;
		unsigned int _PRI85:8;
		unsigned int _PRI86:8;
		unsigned int _PRI87:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP20 (*((volatile union INT_IP20_REG *)0x402000E4))
// model

/** 0x4020 00E8 INT_IP21 **/
union INT_IP21_REG{
	unsigned int reg;
	struct INT_IP21_BITS{
		unsigned int _PRI88:8;
		unsigned int _PRI89:8;
		unsigned int _PRI90:8;
		unsigned int _PRI91:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP21 (*((volatile union INT_IP21_REG *)0x402000E8))
// model

/** 0x4020 00EC INT_IP22 **/
union INT_IP22_REG{
	unsigned int reg;
	struct INT_IP22_BITS{
		unsigned int _PRI92:8;
		unsigned int _PRI93:8;
		unsigned int _PRI94:8;
		unsigned int _PRI95:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP22 (*((volatile union INT_IP22_REG *)0x402000EC))
// model

/** 0x4020 00F0 INT_IP23 **/
union INT_IP23_REG{
	unsigned int reg;
	struct INT_IP23_BITS{
		unsigned int _PRI96:8;
		unsigned int _PRI97:8;
		unsigned int _PRI98:8;
		unsigned int _PRI99:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP23 (*((volatile union INT_IP23_REG *)0x402000F0))
// model

/** 0x4020 00F4 INT_IP24 **/
union INT_IP24_REG{
	unsigned int reg;
	struct INT_IP24_BITS{
		unsigned int _PRI100:8;
		unsigned int _PRI101:8;
		unsigned int _PRI102:8;
		unsigned int _PRI103:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP24 (*((volatile union INT_IP24_REG *)0x402000F4))
// model

/** 0x4020 00F8 INT_IP25 **/
union INT_IP25_REG{
	unsigned int reg;
	struct INT_IP25_BITS{
		unsigned int _PRI104:8;
		unsigned int _PRI105:8;
		unsigned int _PRI106:8;
		unsigned int _PRI107:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP25 (*((volatile union INT_IP25_REG *)0x402000F8))
// model

/** 0x4020 00FC INT_IP26 **/
union INT_IP26_REG{
	unsigned int reg;
	struct INT_IP26_BITS{
		unsigned int _PRI108:8;
		unsigned int _PRI109:8;
		unsigned int _PRI110:8;
		unsigned int _PRI111:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP26 (*((volatile union INT_IP26_REG *)0x402000FC))
// model

/** 0x4020 0308 INT_IP27 **/
union INT_IP27_REG{
	unsigned int reg;
	struct INT_IP27_BITS{
		unsigned int _PRI112:8;
		unsigned int _PRI113:8;
		unsigned int _PRI114:8;
		unsigned int _PRI115:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP27 (*((volatile union INT_IP27_REG *)0x40200308))
// model

/** 0x4020 030C INT_IP28 **/
union INT_IP28_REG{
	unsigned int reg;
	struct INT_IP28_BITS{
		unsigned int _PRI116:8;
		unsigned int _PRI117:8;
		unsigned int _PRI118:8;
		unsigned int _PRI119:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP28 (*((volatile union INT_IP28_REG *)0x4020030C))
// model

/** 0x4020 0310 INT_IP29 **/
union INT_IP29_REG{
	unsigned int reg;
	struct INT_IP29_BITS{
		unsigned int _PRI120:8;
		unsigned int _PRI121:8;
		unsigned int _PRI122:8;
		unsigned int _PRI123:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP29 (*((volatile union INT_IP29_REG *)0x40200310))
// model

/** 0x4020 0314 INT_IP30 **/
union INT_IP30_REG{
	unsigned int reg;
	struct INT_IP30_BITS{
		unsigned int _PRI124:8;
		unsigned int _PRI125:8;
		unsigned int _PRI126:8;
		unsigned int _PRI127:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP30 (*((volatile union INT_IP30_REG *)0x40200314))
// model

/** 0x4020 0080 INT_EINTMASK **/
union INT_EINTMASK_REG{
	unsigned int reg;
	struct INT_EINTMASK_BITS{
		unsigned int :16;
		unsigned int _EINTM:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTMASK (*((volatile union INT_EINTMASK_REG *)0x40200080))
// model

/** 0x4020 0084 INT_EINTRISE **/
union INT_EINTRISE_REG{
	unsigned int reg;
	struct INT_EINTRISE_BITS{
		unsigned int :16;
		unsigned int _EINTRI:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTRISE (*((volatile union INT_EINTRISE_REG *)0x40200084))
// model

/** 0x4020 0088 INT_EINTFALL **/
union INT_EINTFALL_REG{
	unsigned int reg;
	struct INT_EINTFALL_BITS{
		unsigned int :16;
		unsigned int _EINTFA:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTFALL (*((volatile union INT_EINTFALL_REG *)0x40200088))
// model

/** 0x4020 008C INT_EINTF **/
union INT_EINTF_REG{
	unsigned int reg;
	struct INT_EINTF_BITS{
		unsigned int :16;
		unsigned int _EINTIF:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTF (*((volatile union INT_EINTF_REG *)0x4020008C))
// model

/** 0x4020 0090 INT_EINTEL **/
union INT_EINTEL_REG{
	unsigned int reg;
	struct INT_EINTEL_BITS{
		unsigned int :16;
		unsigned int _EINTEL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTEL (*((volatile union INT_EINTEL_REG *)0x40200090))
// modelSYS

/** 0x4020 00B0 SYS_PSW **/
union SYS_PSW_REG{
	unsigned int reg;
	struct SYS_PSW_BITS{
		unsigned int :28;
		unsigned int _V:1;
		unsigned int _C:1;
		unsigned int _Z:1;
		unsigned int _N:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSW (*((volatile union SYS_PSW_REG *)0x402000B0))
// model

/** 0x4020 00B4 SYS_MCTL **/
union SYS_MCTL_REG{
	unsigned int reg;
	struct SYS_MCTL_BITS{
		unsigned int :1;
		unsigned int _SLEEPONEXIT:1;
		unsigned int _SLEEPDEEP:1;
		unsigned int :1;
		unsigned int _SLPONMOD:1;
		unsigned int :4;
		unsigned int _STACKALIGN:1;
		unsigned int :5;
		unsigned int _SUSTA:1;
		unsigned int _SPSEL:1;
		unsigned int :13;
		unsigned int _RUNOUT:1;
		unsigned int _FETCHOUT:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MCTL (*((volatile union SYS_MCTL_REG *)0x402000B4))
// model

/** 0x4020 00B8 SYS_ARCTL **/
union SYS_ARCTL_REG{
	unsigned int reg;
	struct SYS_ARCTL_BITS{
		unsigned int :1;
		unsigned int _VECTRST:1;
		unsigned int _SYSTEMRST:1;
		unsigned int :1;
		unsigned int _CDMAR:1;
		unsigned int _CDMAAM:1;
		unsigned int _CRWDC:1;
		unsigned int _CDMADC:1;
		unsigned int _CDBUGBS:1;
		unsigned int _CDMALDC:2;
		unsigned int _ROMLOCK:1;
		unsigned int _RAMWMS:1;
		unsigned int _CDMAHEC:1;
		unsigned int _FTRIMFAULT:1;
		unsigned int _PTRIMFAULT:1;
		unsigned int _ARKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_ARCTL (*((volatile union SYS_ARCTL_REG *)0x402000B8))
// model

/** 0x4020 00BC SYS_VECTOFF **/
union SYS_VECTOFF_REG{
	unsigned int reg;
	struct SYS_VECTOFF_BITS{
		unsigned int _TBLOFF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_VECTOFF (*((volatile union SYS_VECTOFF_REG *)0x402000BC))
// model

/** 0x4020 00C0 CACHE_CTLR **/
union CACHE_CTLR_REG{
	unsigned int reg;
	struct CACHE_CTLR_BITS{
		unsigned int _CACHEEN:1;
		unsigned int _CACHERST:1;
		unsigned int _ICWR2LEN:1;
		unsigned int _ICRD2LEN:1;
		unsigned int _CECCEN:1;
		unsigned int :6;
		unsigned int _CACHETEN:1;
		unsigned int _BUSTEN:1;
		unsigned int _BUSTSTART:1;
		unsigned int _BUSTMODE:1;
		unsigned int _BUSTD0:1;
		unsigned int _BUSTD1:1;
		unsigned int _BUSRERR:1;
		unsigned int _BUSWERR:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CACHE_CTLR (*((volatile union CACHE_CTLR_REG *)0x402000C0))
// model

/** 0x4020 00C4 SYS_RAMSPA **/
union SYS_RAMSPA_REG{
	unsigned int reg;
	struct SYS_RAMSPA_BITS{
		unsigned int _RAMSPA:26;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_RAMSPA (*((volatile union SYS_RAMSPA_REG *)0x402000C4))
// model

/** 0x4020 00C8 SYS_MEMCTL **/
union SYS_MEMCTL_REG{
	unsigned int reg;
	struct SYS_MEMCTL_BITS{
		unsigned int _MEMM:2;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MEMCTL (*((volatile union SYS_MEMCTL_REG *)0x402000C8))
// model

/** 0x4020 00CC SYS_MSPSPA **/
union SYS_MSPSPA_REG{
	unsigned int reg;
	struct SYS_MSPSPA_BITS{
		unsigned int _MSPSPAL:16;
		unsigned int _MSPSPAH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MSPSPA (*((volatile union SYS_MSPSPA_REG *)0x402000CC))
// model

/** 0x4020 00D0 SYS_PSPSPA **/
union SYS_PSPSPA_REG{
	unsigned int reg;
	struct SYS_PSPSPA_BITS{
		unsigned int _PSPSPAL:16;
		unsigned int _PSPSPAH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSPSPA (*((volatile union SYS_PSPSPA_REG *)0x402000D0))
// modelDMA0

/** 0x4000 1600 DMA0_CTLR1 **/
union DMA0_CTLR1_REG{
	unsigned int reg;
	struct DMA0_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR1 (*((volatile union DMA0_CTLR1_REG *)0x40001600))
// model

/** 0x4000 1604 DMA0_CTLR2 **/
union DMA0_CTLR2_REG{
	unsigned int reg;
	struct DMA0_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR2 (*((volatile union DMA0_CTLR2_REG *)0x40001604))
// model

/** 0x4000 1608 DMA0_CTLR3 **/
union DMA0_CTLR3_REG{
	unsigned int reg;
	struct DMA0_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR3 (*((volatile union DMA0_CTLR3_REG *)0x40001608))
// model

/** 0x4000 160C DMA0_CTLR4 **/
union DMA0_CTLR4_REG{
	unsigned int reg;
	struct DMA0_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR4 (*((volatile union DMA0_CTLR4_REG *)0x4000160C))
// model

/** 0x4000 1610 DMA0_CTLR5 **/
union DMA0_CTLR5_REG{
	unsigned int reg;
	struct DMA0_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR5 (*((volatile union DMA0_CTLR5_REG *)0x40001610))
// model

/** 0x4000 1614 DMA0_CTLR6 **/
union DMA0_CTLR6_REG{
	unsigned int reg;
	struct DMA0_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR6 (*((volatile union DMA0_CTLR6_REG *)0x40001614))
// model

/** 0x4000 1618 DMA0_CTLR7 **/
union DMA0_CTLR7_REG{
	unsigned int reg;
	struct DMA0_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR7 (*((volatile union DMA0_CTLR7_REG *)0x40001618))
// model

/** 0x4000 1620 DMA0_PADDR1 **/
union DMA0_PADDR1_REG{
	unsigned int reg;
	struct DMA0_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR1 (*((volatile union DMA0_PADDR1_REG *)0x40001620))
// model

/** 0x4000 1624 DMA0_PADDR2 **/
union DMA0_PADDR2_REG{
	unsigned int reg;
	struct DMA0_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR2 (*((volatile union DMA0_PADDR2_REG *)0x40001624))
// model

/** 0x4000 1628 DMA0_PADDR3 **/
union DMA0_PADDR3_REG{
	unsigned int reg;
	struct DMA0_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR3 (*((volatile union DMA0_PADDR3_REG *)0x40001628))
// model

/** 0x4000 162C DMA0_PADDR4 **/
union DMA0_PADDR4_REG{
	unsigned int reg;
	struct DMA0_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR4 (*((volatile union DMA0_PADDR4_REG *)0x4000162C))
// model

/** 0x4000 1630 DMA0_PADDR5 **/
union DMA0_PADDR5_REG{
	unsigned int reg;
	struct DMA0_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR5 (*((volatile union DMA0_PADDR5_REG *)0x40001630))
// model

/** 0x4000 1634 DMA0_PADDR6 **/
union DMA0_PADDR6_REG{
	unsigned int reg;
	struct DMA0_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR6 (*((volatile union DMA0_PADDR6_REG *)0x40001634))
// model

/** 0x4000 1638 DMA0_PADDR7 **/
union DMA0_PADDR7_REG{
	unsigned int reg;
	struct DMA0_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR7 (*((volatile union DMA0_PADDR7_REG *)0x40001638))
// model

/** 0x4000 1640 DMA0_MADDR1 **/
union DMA0_MADDR1_REG{
	unsigned int reg;
	struct DMA0_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR1 (*((volatile union DMA0_MADDR1_REG *)0x40001640))
// model

/** 0x4000 1644 DMA0_MADDR2 **/
union DMA0_MADDR2_REG{
	unsigned int reg;
	struct DMA0_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR2 (*((volatile union DMA0_MADDR2_REG *)0x40001644))
// model

/** 0x4000 1648 DMA0_MADDR3 **/
union DMA0_MADDR3_REG{
	unsigned int reg;
	struct DMA0_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR3 (*((volatile union DMA0_MADDR3_REG *)0x40001648))
// model

/** 0x4000 164C DMA0_MADDR4 **/
union DMA0_MADDR4_REG{
	unsigned int reg;
	struct DMA0_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR4 (*((volatile union DMA0_MADDR4_REG *)0x4000164C))
// model

/** 0x4000 1650 DMA0_MADDR5 **/
union DMA0_MADDR5_REG{
	unsigned int reg;
	struct DMA0_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR5 (*((volatile union DMA0_MADDR5_REG *)0x40001650))
// model

/** 0x4000 1654 DMA0_MADDR6 **/
union DMA0_MADDR6_REG{
	unsigned int reg;
	struct DMA0_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR6 (*((volatile union DMA0_MADDR6_REG *)0x40001654))
// model

/** 0x4000 1658 DMA0_MADDR7 **/
union DMA0_MADDR7_REG{
	unsigned int reg;
	struct DMA0_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR7 (*((volatile union DMA0_MADDR7_REG *)0x40001658))
// model

/** 0x4000 1660 DMA0_CPAR1 **/
union DMA0_CPAR1_REG{
	unsigned int reg;
	struct DMA0_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR1 (*((volatile union DMA0_CPAR1_REG *)0x40001660))
// model

/** 0x4000 1664 DMA0_CPAR2 **/
union DMA0_CPAR2_REG{
	unsigned int reg;
	struct DMA0_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR2 (*((volatile union DMA0_CPAR2_REG *)0x40001664))
// model

/** 0x4000 1668 DMA0_CPAR3 **/
union DMA0_CPAR3_REG{
	unsigned int reg;
	struct DMA0_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR3 (*((volatile union DMA0_CPAR3_REG *)0x40001668))
// model

/** 0x4000 166C DMA0_CPAR4 **/
union DMA0_CPAR4_REG{
	unsigned int reg;
	struct DMA0_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR4 (*((volatile union DMA0_CPAR4_REG *)0x4000166C))
// model

/** 0x4000 1670 DMA0_CPAR5 **/
union DMA0_CPAR5_REG{
	unsigned int reg;
	struct DMA0_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR5 (*((volatile union DMA0_CPAR5_REG *)0x40001670))
// model

/** 0x4000 1674 DMA0_CPAR6 **/
union DMA0_CPAR6_REG{
	unsigned int reg;
	struct DMA0_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR6 (*((volatile union DMA0_CPAR6_REG *)0x40001674))
// model

/** 0x4000 1678 DMA0_CPAR7 **/
union DMA0_CPAR7_REG{
	unsigned int reg;
	struct DMA0_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR7 (*((volatile union DMA0_CPAR7_REG *)0x40001678))
// model

/** 0x4000 1680 DMA0_CMAR1 **/
union DMA0_CMAR1_REG{
	unsigned int reg;
	struct DMA0_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR1 (*((volatile union DMA0_CMAR1_REG *)0x40001680))
// model

/** 0x4000 1684 DMA0_CMAR2 **/
union DMA0_CMAR2_REG{
	unsigned int reg;
	struct DMA0_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR2 (*((volatile union DMA0_CMAR2_REG *)0x40001684))
// model

/** 0x4000 1688 DMA0_CMAR3 **/
union DMA0_CMAR3_REG{
	unsigned int reg;
	struct DMA0_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR3 (*((volatile union DMA0_CMAR3_REG *)0x40001688))
// model

/** 0x4000 168C DMA0_CMAR4 **/
union DMA0_CMAR4_REG{
	unsigned int reg;
	struct DMA0_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR4 (*((volatile union DMA0_CMAR4_REG *)0x4000168C))
// model

/** 0x4000 1690 DMA0_CMAR5 **/
union DMA0_CMAR5_REG{
	unsigned int reg;
	struct DMA0_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR5 (*((volatile union DMA0_CMAR5_REG *)0x40001690))
// model

/** 0x4000 1694 DMA0_CMAR6 **/
union DMA0_CMAR6_REG{
	unsigned int reg;
	struct DMA0_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR6 (*((volatile union DMA0_CMAR6_REG *)0x40001694))
// model

/** 0x4000 1698 DMA0_CMAR7 **/
union DMA0_CMAR7_REG{
	unsigned int reg;
	struct DMA0_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR7 (*((volatile union DMA0_CMAR7_REG *)0x40001698))
// model

/** 0x4000 16A0 DMA0_NCT1 **/
union DMA0_NCT1_REG{
	unsigned int reg;
	struct DMA0_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT1 (*((volatile union DMA0_NCT1_REG *)0x400016A0))
// model

/** 0x4000 16A4 DMA0_NCT2 **/
union DMA0_NCT2_REG{
	unsigned int reg;
	struct DMA0_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT2 (*((volatile union DMA0_NCT2_REG *)0x400016A4))
// model

/** 0x4000 16A8 DMA0_NCT3 **/
union DMA0_NCT3_REG{
	unsigned int reg;
	struct DMA0_NCT3_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT3 (*((volatile union DMA0_NCT3_REG *)0x400016A8))
// model

/** 0x4000 16AC DMA0_NCT4 **/
union DMA0_NCT4_REG{
	unsigned int reg;
	struct DMA0_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT4 (*((volatile union DMA0_NCT4_REG *)0x400016AC))
// model

/** 0x4000 16B0 DMA0_NCT5 **/
union DMA0_NCT5_REG{
	unsigned int reg;
	struct DMA0_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT5 (*((volatile union DMA0_NCT5_REG *)0x400016B0))
// model

/** 0x4000 16B4 DMA0_NCT6 **/
union DMA0_NCT6_REG{
	unsigned int reg;
	struct DMA0_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT6 (*((volatile union DMA0_NCT6_REG *)0x400016B4))
// model

/** 0x4000 16B8 DMA0_NCT7 **/
union DMA0_NCT7_REG{
	unsigned int reg;
	struct DMA0_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT7 (*((volatile union DMA0_NCT7_REG *)0x400016B8))
// model

/** 0x4000 16C0 DMA0_LIFR **/
union DMA0_LIFR_REG{
	unsigned int reg;
	struct DMA0_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_LIFR (*((volatile union DMA0_LIFR_REG *)0x400016C0))
// model

/** 0x4000 16C4 DMA0_LIER **/
union DMA0_LIER_REG{
	unsigned int reg;
	struct DMA0_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIE7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_LIER (*((volatile union DMA0_LIER_REG *)0x400016C4))
// model

/** 0x4000 16C8 DMA0_MUXL **/
union DMA0_MUXL_REG{
	unsigned int reg;
	struct DMA0_MUXL_BITS{
		unsigned int _SOURCE1:6;
		unsigned int :1;
		unsigned int _TRGEN1:1;
		unsigned int _SOURCE2:6;
		unsigned int :1;
		unsigned int _TRGEN2:1;
		unsigned int _SOURCE3:6;
		unsigned int :1;
		unsigned int _TRGEN3:1;
		unsigned int _SOURCE4:6;
		unsigned int :1;
		unsigned int _TRGEN4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MUXL (*((volatile union DMA0_MUXL_REG *)0x400016C8))
// model

/** 0x4000 16CC DMA0_MUXH **/
union DMA0_MUXH_REG{
	unsigned int reg;
	struct DMA0_MUXH_BITS{
		unsigned int _SOURCE5:6;
		unsigned int :1;
		unsigned int _TRGEN5:1;
		unsigned int _SOURCE6:6;
		unsigned int :1;
		unsigned int _TRGEN6:1;
		unsigned int _SOURCE7:6;
		unsigned int :1;
		unsigned int _TRGEN7:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MUXH (*((volatile union DMA0_MUXH_REG *)0x400016CC))
// modelDMA1

/** 0x4000 1700 DMA1_CTLR1 **/
union DMA1_CTLR1_REG{
	unsigned int reg;
	struct DMA1_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR1 (*((volatile union DMA1_CTLR1_REG *)0x40001700))
// model

/** 0x4000 1704 DMA1_CTLR2 **/
union DMA1_CTLR2_REG{
	unsigned int reg;
	struct DMA1_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR2 (*((volatile union DMA1_CTLR2_REG *)0x40001704))
// model

/** 0x4000 1708 DMA1_CTLR3 **/
union DMA1_CTLR3_REG{
	unsigned int reg;
	struct DMA1_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR3 (*((volatile union DMA1_CTLR3_REG *)0x40001708))
// model

/** 0x4000 170C DMA1_CTLR4 **/
union DMA1_CTLR4_REG{
	unsigned int reg;
	struct DMA1_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR4 (*((volatile union DMA1_CTLR4_REG *)0x4000170C))
// model

/** 0x4000 1710 DMA1_CTLR5 **/
union DMA1_CTLR5_REG{
	unsigned int reg;
	struct DMA1_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR5 (*((volatile union DMA1_CTLR5_REG *)0x40001710))
// model

/** 0x4000 1714 DMA1_CTLR6 **/
union DMA1_CTLR6_REG{
	unsigned int reg;
	struct DMA1_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR6 (*((volatile union DMA1_CTLR6_REG *)0x40001714))
// model

/** 0x4000 1718 DMA1_CTLR7 **/
union DMA1_CTLR7_REG{
	unsigned int reg;
	struct DMA1_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int _DMAHALT:1;
		unsigned int :1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR7 (*((volatile union DMA1_CTLR7_REG *)0x40001718))
// model

/** 0x4000 1720 DMA1_PADDR1 **/
union DMA1_PADDR1_REG{
	unsigned int reg;
	struct DMA1_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR1 (*((volatile union DMA1_PADDR1_REG *)0x40001720))
// model

/** 0x4000 1724 DMA1_PADDR2 **/
union DMA1_PADDR2_REG{
	unsigned int reg;
	struct DMA1_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR2 (*((volatile union DMA1_PADDR2_REG *)0x40001724))
// model

/** 0x4000 1728 DMA1_PADDR3 **/
union DMA1_PADDR3_REG{
	unsigned int reg;
	struct DMA1_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR3 (*((volatile union DMA1_PADDR3_REG *)0x40001728))
// model

/** 0x4000 172C DMA1_PADDR4 **/
union DMA1_PADDR4_REG{
	unsigned int reg;
	struct DMA1_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR4 (*((volatile union DMA1_PADDR4_REG *)0x4000172C))
// model

/** 0x4000 1730 DMA1_PADDR5 **/
union DMA1_PADDR5_REG{
	unsigned int reg;
	struct DMA1_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR5 (*((volatile union DMA1_PADDR5_REG *)0x40001730))
// model

/** 0x4000 1734 DMA1_PADDR6 **/
union DMA1_PADDR6_REG{
	unsigned int reg;
	struct DMA1_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR6 (*((volatile union DMA1_PADDR6_REG *)0x40001734))
// model

/** 0x4000 1738 DMA1_PADDR7 **/
union DMA1_PADDR7_REG{
	unsigned int reg;
	struct DMA1_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR7 (*((volatile union DMA1_PADDR7_REG *)0x40001738))
// model

/** 0x4000 1740 DMA1_MADDR1 **/
union DMA1_MADDR1_REG{
	unsigned int reg;
	struct DMA1_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR1 (*((volatile union DMA1_MADDR1_REG *)0x40001740))
// model

/** 0x4000 1744 DMA1_MADDR2 **/
union DMA1_MADDR2_REG{
	unsigned int reg;
	struct DMA1_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR2 (*((volatile union DMA1_MADDR2_REG *)0x40001744))
// model

/** 0x4000 1748 DMA1_MADDR3 **/
union DMA1_MADDR3_REG{
	unsigned int reg;
	struct DMA1_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR3 (*((volatile union DMA1_MADDR3_REG *)0x40001748))
// model

/** 0x4000 174C DMA1_MADDR4 **/
union DMA1_MADDR4_REG{
	unsigned int reg;
	struct DMA1_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR4 (*((volatile union DMA1_MADDR4_REG *)0x4000174C))
// model

/** 0x4000 1750 DMA1_MADDR5 **/
union DMA1_MADDR5_REG{
	unsigned int reg;
	struct DMA1_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR5 (*((volatile union DMA1_MADDR5_REG *)0x40001750))
// model

/** 0x4000 1754 DMA1_MADDR6 **/
union DMA1_MADDR6_REG{
	unsigned int reg;
	struct DMA1_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR6 (*((volatile union DMA1_MADDR6_REG *)0x40001754))
// model

/** 0x4000 1758 DMA1_MADDR7 **/
union DMA1_MADDR7_REG{
	unsigned int reg;
	struct DMA1_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR7 (*((volatile union DMA1_MADDR7_REG *)0x40001758))
// model

/** 0x4000 1760 DMA1_CPAR1 **/
union DMA1_CPAR1_REG{
	unsigned int reg;
	struct DMA1_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR1 (*((volatile union DMA1_CPAR1_REG *)0x40001760))
// model

/** 0x4000 1764 DMA1_CPAR2 **/
union DMA1_CPAR2_REG{
	unsigned int reg;
	struct DMA1_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR2 (*((volatile union DMA1_CPAR2_REG *)0x40001764))
// model

/** 0x4000 1768 DMA1_CPAR3 **/
union DMA1_CPAR3_REG{
	unsigned int reg;
	struct DMA1_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR3 (*((volatile union DMA1_CPAR3_REG *)0x40001768))
// model

/** 0x4000 176C DMA1_CPAR4 **/
union DMA1_CPAR4_REG{
	unsigned int reg;
	struct DMA1_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR4 (*((volatile union DMA1_CPAR4_REG *)0x4000176C))
// model

/** 0x4000 1770 DMA1_CPAR5 **/
union DMA1_CPAR5_REG{
	unsigned int reg;
	struct DMA1_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR5 (*((volatile union DMA1_CPAR5_REG *)0x40001770))
// model

/** 0x4000 1774 DMA1_CPAR6 **/
union DMA1_CPAR6_REG{
	unsigned int reg;
	struct DMA1_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR6 (*((volatile union DMA1_CPAR6_REG *)0x40001774))
// model

/** 0x4000 1778 DMA1_CPAR7 **/
union DMA1_CPAR7_REG{
	unsigned int reg;
	struct DMA1_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR7 (*((volatile union DMA1_CPAR7_REG *)0x40001778))
// model

/** 0x4000 1780 DMA1_CMAR1 **/
union DMA1_CMAR1_REG{
	unsigned int reg;
	struct DMA1_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR1 (*((volatile union DMA1_CMAR1_REG *)0x40001780))
// model

/** 0x4000 1784 DMA1_CMAR2 **/
union DMA1_CMAR2_REG{
	unsigned int reg;
	struct DMA1_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR2 (*((volatile union DMA1_CMAR2_REG *)0x40001784))
// model

/** 0x4000 1788 DMA1_CMAR3 **/
union DMA1_CMAR3_REG{
	unsigned int reg;
	struct DMA1_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR3 (*((volatile union DMA1_CMAR3_REG *)0x40001788))
// model

/** 0x4000 178C DMA1_CMAR4 **/
union DMA1_CMAR4_REG{
	unsigned int reg;
	struct DMA1_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR4 (*((volatile union DMA1_CMAR4_REG *)0x4000178C))
// model

/** 0x4000 1790 DMA1_CMAR5 **/
union DMA1_CMAR5_REG{
	unsigned int reg;
	struct DMA1_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR5 (*((volatile union DMA1_CMAR5_REG *)0x40001790))
// model

/** 0x4000 1794 DMA1_CMAR6 **/
union DMA1_CMAR6_REG{
	unsigned int reg;
	struct DMA1_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR6 (*((volatile union DMA1_CMAR6_REG *)0x40001794))
// model

/** 0x4000 1798 DMA1_CMAR7 **/
union DMA1_CMAR7_REG{
	unsigned int reg;
	struct DMA1_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR7 (*((volatile union DMA1_CMAR7_REG *)0x40001798))
// model

/** 0x4000 17A0 DMA1_NCT1 **/
union DMA1_NCT1_REG{
	unsigned int reg;
	struct DMA1_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT1 (*((volatile union DMA1_NCT1_REG *)0x400017A0))
// model

/** 0x4000 17A4 DMA1_NCT2 **/
union DMA1_NCT2_REG{
	unsigned int reg;
	struct DMA1_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT2 (*((volatile union DMA1_NCT2_REG *)0x400017A4))
// model

/** 0x4000 17A8 DMA1_NCT3 **/
union DMA1_NCT3_REG{
	unsigned int reg;
	struct DMA1_NCT3_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT3 (*((volatile union DMA1_NCT3_REG *)0x400017A8))
// model

/** 0x4000 17AC DMA1_NCT4 **/
union DMA1_NCT4_REG{
	unsigned int reg;
	struct DMA1_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT4 (*((volatile union DMA1_NCT4_REG *)0x400017AC))
// model

/** 0x4000 17B0 DMA1_NCT5 **/
union DMA1_NCT5_REG{
	unsigned int reg;
	struct DMA1_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT5 (*((volatile union DMA1_NCT5_REG *)0x400017B0))
// model

/** 0x4000 17B4 DMA1_NCT6 **/
union DMA1_NCT6_REG{
	unsigned int reg;
	struct DMA1_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT6 (*((volatile union DMA1_NCT6_REG *)0x400017B4))
// model

/** 0x4000 17B8 DMA1_NCT7 **/
union DMA1_NCT7_REG{
	unsigned int reg;
	struct DMA1_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT7 (*((volatile union DMA1_NCT7_REG *)0x400017B8))
// model

/** 0x4000 17C0 DMA1_LIFR **/
union DMA1_LIFR_REG{
	unsigned int reg;
	struct DMA1_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_LIFR (*((volatile union DMA1_LIFR_REG *)0x400017C0))
// model

/** 0x4000 17C4 DMA1_LIER **/
union DMA1_LIER_REG{
	unsigned int reg;
	struct DMA1_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIE7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_LIER (*((volatile union DMA1_LIER_REG *)0x400017C4))
// model

/** 0x4000 17C8 DMA1_MUXL **/
union DMA1_MUXL_REG{
	unsigned int reg;
	struct DMA1_MUXL_BITS{
		unsigned int _SOURCE1:6;
		unsigned int :1;
		unsigned int _TRGEN1:1;
		unsigned int _SOURCE2:6;
		unsigned int :1;
		unsigned int _TRGEN2:1;
		unsigned int _SOURCE3:6;
		unsigned int :1;
		unsigned int _TRGEN3:1;
		unsigned int _SOURCE4:6;
		unsigned int :1;
		unsigned int _TRGEN4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MUXL (*((volatile union DMA1_MUXL_REG *)0x400017C8))
// model

/** 0x4000 17CC DMA1_MUXH **/
union DMA1_MUXH_REG{
	unsigned int reg;
	struct DMA1_MUXH_BITS{
		unsigned int _SOURCE5:6;
		unsigned int :1;
		unsigned int _TRGEN5:1;
		unsigned int _SOURCE6:6;
		unsigned int :1;
		unsigned int _TRGEN6:1;
		unsigned int _SOURCE7:6;
		unsigned int :1;
		unsigned int _TRGEN7:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MUXH (*((volatile union DMA1_MUXH_REG *)0x400017CC))
// modelSYSTICK

/** 0x4020 00A0 ST_CTL **/
union ST_CTL_REG{
	unsigned int reg;
	struct ST_CTL_BITS{
		unsigned int _STEN:1;
		unsigned int _TICKINTEN:1;
		unsigned int _STCLKS:1;
		unsigned int :13;
		unsigned int _COUNTZERO:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CTL (*((volatile union ST_CTL_REG *)0x402000A0))
// model

/** 0x4020 00A4 ST_RELOAD **/
union ST_RELOAD_REG{
	unsigned int reg;
	struct ST_RELOAD_BITS{
		unsigned int _STRELOAD:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_RELOAD (*((volatile union ST_RELOAD_REG *)0x402000A4))
// model

/** 0x4020 00A8 ST_CV **/
union ST_CV_REG{
	unsigned int reg;
	struct ST_CV_BITS{
		unsigned int _STCV:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CV (*((volatile union ST_CV_REG *)0x402000A8))
// model

/** 0x4020 00AC ST_CALI **/
union ST_CALI_REG{
	unsigned int reg;
	struct ST_CALI_BITS{
		unsigned int _STCALIB:24;
		unsigned int :6;
		unsigned int _SKEW:1;
		unsigned int _STCLKREF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CALI (*((volatile union ST_CALI_REG *)0x402000AC))
// modelT14

/** 0x4000 1800 T14_CNT **/
union T14_CNT_REG{
	unsigned int reg;
	struct T14_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CNT (*((volatile union T14_CNT_REG *)0x40001800))
// model

/** 0x4000 1804 T14_CTL1 **/
union T14_CTL1_REG{
	unsigned int reg;
	struct T14_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TRGSEL:2;
		unsigned int _TCKSEL:2;
		unsigned int _READTEN:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL1 (*((volatile union T14_CTL1_REG *)0x40001804))
// model

/** 0x4000 1808 T14_CTL2 **/
union T14_CTL2_REG{
	unsigned int reg;
	struct T14_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:2;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _PXSPMST:1;
		unsigned int _PXSPM:1;
		unsigned int _TXTRG:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL2 (*((volatile union T14_CTL2_REG *)0x40001808))
// model

/** 0x4000 180C T14_PRSC **/
union T14_PRSC_REG{
	unsigned int reg;
	struct T14_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PRSC (*((volatile union T14_PRSC_REG *)0x4000180C))
// model

/** 0x4000 1810 T14_PPX **/
union T14_PPX_REG{
	unsigned int reg;
	struct T14_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PPX (*((volatile union T14_PPX_REG *)0x40001810))
// model

/** 0x4000 1814 T14_DIER **/
union T14_DIER_REG{
	unsigned int reg;
	struct T14_DIER_BITS{
		unsigned int _TXUIE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXTDE:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_DIER (*((volatile union T14_DIER_REG *)0x40001814))
// model

/** 0x4000 1818 T14_SR **/
union T14_SR_REG{
	unsigned int reg;
	struct T14_SR_BITS{
		unsigned int _TXUIF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_SR (*((volatile union T14_SR_REG *)0x40001818))
// model

/** 0x4000 181C T14_SRIC **/
union T14_SRIC_REG{
	unsigned int reg;
	struct T14_SRIC_BITS{
		unsigned int _TXUIC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXIC:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_SRIC (*((volatile union T14_SRIC_REG *)0x4000181C))
// modelT0

/** 0x4000 0880 T0_CNT **/
union T0_CNT_REG{
	unsigned int reg;
	struct T0_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CNT (*((volatile union T0_CNT_REG *)0x40000880))
// model

/** 0x4000 0884 T0_CTL1 **/
union T0_CTL1_REG{
	unsigned int reg;
	struct T0_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL1 (*((volatile union T0_CTL1_REG *)0x40000884))
// model

/** 0x4000 0888 T0_CTL2 **/
union T0_CTL2_REG{
	unsigned int reg;
	struct T0_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL2 (*((volatile union T0_CTL2_REG *)0x40000888))
// model

/** 0x4000 088C T0_PRSC **/
union T0_PRSC_REG{
	unsigned int reg;
	struct T0_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PRSC (*((volatile union T0_PRSC_REG *)0x4000088C))
// model

/** 0x4000 0890 T0_PPX **/
union T0_PPX_REG{
	unsigned int reg;
	struct T0_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PPX (*((volatile union T0_PPX_REG *)0x40000890))
// model

/** 0x4000 0894 T0_UDTIM **/
union T0_UDTIM_REG{
	unsigned int reg;
	struct T0_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_UDTIM (*((volatile union T0_UDTIM_REG *)0x40000894))
// modelT1

/** 0x4000 0100 T1_CNT **/
union T1_CNT_REG{
	unsigned int reg;
	struct T1_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CNT (*((volatile union T1_CNT_REG *)0x40000100))
// model

/** 0x4000 0104 T1_CTL1 **/
union T1_CTL1_REG{
	unsigned int reg;
	struct T1_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL1 (*((volatile union T1_CTL1_REG *)0x40000104))
// model

/** 0x4000 0108 T1_CTL2 **/
union T1_CTL2_REG{
	unsigned int reg;
	struct T1_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL2 (*((volatile union T1_CTL2_REG *)0x40000108))
// model

/** 0x4000 010C T1_PRSC **/
union T1_PRSC_REG{
	unsigned int reg;
	struct T1_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PRSC (*((volatile union T1_PRSC_REG *)0x4000010C))
// model

/** 0x4000 0110 T1_PPX **/
union T1_PPX_REG{
	unsigned int reg;
	struct T1_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PPX (*((volatile union T1_PPX_REG *)0x40000110))
// model

/** 0x4000 0114 T1_UDTIM **/
union T1_UDTIM_REG{
	unsigned int reg;
	struct T1_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_UDTIM (*((volatile union T1_UDTIM_REG *)0x40000114))
// modelT2

/** 0x4000 0180 T2_CNT **/
union T2_CNT_REG{
	unsigned int reg;
	struct T2_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CNT (*((volatile union T2_CNT_REG *)0x40000180))
// model

/** 0x4000 0184 T2_CTL1 **/
union T2_CTL1_REG{
	unsigned int reg;
	struct T2_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL1 (*((volatile union T2_CTL1_REG *)0x40000184))
// model

/** 0x4000 0188 T2_CTL2 **/
union T2_CTL2_REG{
	unsigned int reg;
	struct T2_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL2 (*((volatile union T2_CTL2_REG *)0x40000188))
// model

/** 0x4000 018C T2_PRSC **/
union T2_PRSC_REG{
	unsigned int reg;
	struct T2_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PRSC (*((volatile union T2_PRSC_REG *)0x4000018C))
// model

/** 0x4000 0190 T2_PPX **/
union T2_PPX_REG{
	unsigned int reg;
	struct T2_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PPX (*((volatile union T2_PPX_REG *)0x40000190))
// model

/** 0x4000 0194 T2_UDTIM **/
union T2_UDTIM_REG{
	unsigned int reg;
	struct T2_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_UDTIM (*((volatile union T2_UDTIM_REG *)0x40000194))
// modelT3

/** 0x4000 0200 T3_CNT **/
union T3_CNT_REG{
	unsigned int reg;
	struct T3_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CNT (*((volatile union T3_CNT_REG *)0x40000200))
// model

/** 0x4000 0204 T3_CTL1 **/
union T3_CTL1_REG{
	unsigned int reg;
	struct T3_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL1 (*((volatile union T3_CTL1_REG *)0x40000204))
// model

/** 0x4000 0208 T3_CTL2 **/
union T3_CTL2_REG{
	unsigned int reg;
	struct T3_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL2 (*((volatile union T3_CTL2_REG *)0x40000208))
// model

/** 0x4000 020C T3_PRSC **/
union T3_PRSC_REG{
	unsigned int reg;
	struct T3_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PRSC (*((volatile union T3_PRSC_REG *)0x4000020C))
// model

/** 0x4000 0210 T3_PPX **/
union T3_PPX_REG{
	unsigned int reg;
	struct T3_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PPX (*((volatile union T3_PPX_REG *)0x40000210))
// model

/** 0x4000 0214 T3_UDTIM **/
union T3_UDTIM_REG{
	unsigned int reg;
	struct T3_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_UDTIM (*((volatile union T3_UDTIM_REG *)0x40000214))
// modelT4

/** 0x4000 0280 T4_CNT **/
union T4_CNT_REG{
	unsigned int reg;
	struct T4_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CNT (*((volatile union T4_CNT_REG *)0x40000280))
// model

/** 0x4000 0284 T4_CTL1 **/
union T4_CTL1_REG{
	unsigned int reg;
	struct T4_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL1 (*((volatile union T4_CTL1_REG *)0x40000284))
// model

/** 0x4000 0288 T4_CTL2 **/
union T4_CTL2_REG{
	unsigned int reg;
	struct T4_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL2 (*((volatile union T4_CTL2_REG *)0x40000288))
// model

/** 0x4000 028C T4_PRSC **/
union T4_PRSC_REG{
	unsigned int reg;
	struct T4_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PRSC (*((volatile union T4_PRSC_REG *)0x4000028C))
// model

/** 0x4000 0290 T4_PPX **/
union T4_PPX_REG{
	unsigned int reg;
	struct T4_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PPX (*((volatile union T4_PPX_REG *)0x40000290))
// model

/** 0x4000 0294 T4_UDTIM **/
union T4_UDTIM_REG{
	unsigned int reg;
	struct T4_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_UDTIM (*((volatile union T4_UDTIM_REG *)0x40000294))
// modelT18

/** 0x4000 1A80 T18_CNT **/
union T18_CNT_REG{
	unsigned int reg;
	struct T18_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CNT (*((volatile union T18_CNT_REG *)0x40001A80))
// model

/** 0x4000 1A84 T18_CTL1 **/
union T18_CTL1_REG{
	unsigned int reg;
	struct T18_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CTL1 (*((volatile union T18_CTL1_REG *)0x40001A84))
// model

/** 0x4000 1A88 T18_CTL2 **/
union T18_CTL2_REG{
	unsigned int reg;
	struct T18_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CTL2 (*((volatile union T18_CTL2_REG *)0x40001A88))
// model

/** 0x4000 1A8C T18_PRSC **/
union T18_PRSC_REG{
	unsigned int reg;
	struct T18_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_PRSC (*((volatile union T18_PRSC_REG *)0x40001A8C))
// model

/** 0x4000 1A90 T18_PPX **/
union T18_PPX_REG{
	unsigned int reg;
	struct T18_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_PPX (*((volatile union T18_PPX_REG *)0x40001A90))
// model

/** 0x4000 1A94 T18_UDTIM **/
union T18_UDTIM_REG{
	unsigned int reg;
	struct T18_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_UDTIM (*((volatile union T18_UDTIM_REG *)0x40001A94))
// modelT19

/** 0x4000 1B00 T19_CNT **/
union T19_CNT_REG{
	unsigned int reg;
	struct T19_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CNT (*((volatile union T19_CNT_REG *)0x40001B00))
// model

/** 0x4000 1B04 T19_CTL1 **/
union T19_CTL1_REG{
	unsigned int reg;
	struct T19_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CTL1 (*((volatile union T19_CTL1_REG *)0x40001B04))
// model

/** 0x4000 1B08 T19_CTL2 **/
union T19_CTL2_REG{
	unsigned int reg;
	struct T19_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CTL2 (*((volatile union T19_CTL2_REG *)0x40001B08))
// model

/** 0x4000 1B0C T19_PRSC **/
union T19_PRSC_REG{
	unsigned int reg;
	struct T19_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_PRSC (*((volatile union T19_PRSC_REG *)0x40001B0C))
// model

/** 0x4000 1B10 T19_PPX **/
union T19_PPX_REG{
	unsigned int reg;
	struct T19_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_PPX (*((volatile union T19_PPX_REG *)0x40001B10))
// model

/** 0x4000 1B14 T19_UDTIM **/
union T19_UDTIM_REG{
	unsigned int reg;
	struct T19_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_UDTIM (*((volatile union T19_UDTIM_REG *)0x40001B14))
// modelT20

/** 0x4000 1B80 T20_CNT **/
union T20_CNT_REG{
	unsigned int reg;
	struct T20_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_CNT (*((volatile union T20_CNT_REG *)0x40001B80))
// model

/** 0x4000 1B84 T20_CTL1 **/
union T20_CTL1_REG{
	unsigned int reg;
	struct T20_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_CTL1 (*((volatile union T20_CTL1_REG *)0x40001B84))
// model

/** 0x4000 1B88 T20_CTL2 **/
union T20_CTL2_REG{
	unsigned int reg;
	struct T20_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_CTL2 (*((volatile union T20_CTL2_REG *)0x40001B88))
// model

/** 0x4000 1B8C T20_PRSC **/
union T20_PRSC_REG{
	unsigned int reg;
	struct T20_PRSC_BITS{
		unsigned int _TXCKS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_PRSC (*((volatile union T20_PRSC_REG *)0x40001B8C))
// model

/** 0x4000 1B90 T20_PPX **/
union T20_PPX_REG{
	unsigned int reg;
	struct T20_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_PPX (*((volatile union T20_PPX_REG *)0x40001B90))
// model

/** 0x4000 1B94 T20_UDTIM **/
union T20_UDTIM_REG{
	unsigned int reg;
	struct T20_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T20_UDTIM (*((volatile union T20_UDTIM_REG *)0x40001B94))
// modelT21

/** 0x4000 1C00 T21_CNT **/
union T21_CNT_REG{
	unsigned int reg;
	struct T21_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CNT (*((volatile union T21_CNT_REG *)0x40001C00))
// model

/** 0x4000 1C04 T21_CTL1 **/
union T21_CTL1_REG{
	unsigned int reg;
	struct T21_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CTL1 (*((volatile union T21_CTL1_REG *)0x40001C04))
// model

/** 0x4000 1C08 T21_CTL2 **/
union T21_CTL2_REG{
	unsigned int reg;
	struct T21_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CTL2 (*((volatile union T21_CTL2_REG *)0x40001C08))
// model

/** 0x4000 1C0C T21_PRSC **/
union T21_PRSC_REG{
	unsigned int reg;
	struct T21_PRSC_BITS{
		unsigned int _TXCKS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_PRSC (*((volatile union T21_PRSC_REG *)0x40001C0C))
// model

/** 0x4000 1C10 T21_PPX **/
union T21_PPX_REG{
	unsigned int reg;
	struct T21_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_PPX (*((volatile union T21_PPX_REG *)0x40001C10))
// model

/** 0x4000 1C14 T21_UDTIM **/
union T21_UDTIM_REG{
	unsigned int reg;
	struct T21_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_UDTIM (*((volatile union T21_UDTIM_REG *)0x40001C14))
// modelT22

/** 0x4000 1C80 T22_CNT **/
union T22_CNT_REG{
	unsigned int reg;
	struct T22_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_CNT (*((volatile union T22_CNT_REG *)0x40001C80))
// model

/** 0x4000 1C84 T22_CTL1 **/
union T22_CTL1_REG{
	unsigned int reg;
	struct T22_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_CTL1 (*((volatile union T22_CTL1_REG *)0x40001C84))
// model

/** 0x4000 1C88 T22_CTL2 **/
union T22_CTL2_REG{
	unsigned int reg;
	struct T22_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_CTL2 (*((volatile union T22_CTL2_REG *)0x40001C88))
// model

/** 0x4000 1C8C T22_PRSC **/
union T22_PRSC_REG{
	unsigned int reg;
	struct T22_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_PRSC (*((volatile union T22_PRSC_REG *)0x40001C8C))
// model

/** 0x4000 1C90 T22_PPX **/
union T22_PPX_REG{
	unsigned int reg;
	struct T22_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_PPX (*((volatile union T22_PPX_REG *)0x40001C90))
// model

/** 0x4000 1C94 T22_UDTIM **/
union T22_UDTIM_REG{
	unsigned int reg;
	struct T22_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T22_UDTIM (*((volatile union T22_UDTIM_REG *)0x40001C94))
// modelT23

/** 0x4000 1D00 T23_CNT **/
union T23_CNT_REG{
	unsigned int reg;
	struct T23_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_CNT (*((volatile union T23_CNT_REG *)0x40001D00))
// model

/** 0x4000 1D04 T23_CTL1 **/
union T23_CTL1_REG{
	unsigned int reg;
	struct T23_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int _READTEN:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_CTL1 (*((volatile union T23_CTL1_REG *)0x40001D04))
// model

/** 0x4000 1D08 T23_CTL2 **/
union T23_CTL2_REG{
	unsigned int reg;
	struct T23_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_CTL2 (*((volatile union T23_CTL2_REG *)0x40001D08))
// model

/** 0x4000 1D0C T23_PRSC **/
union T23_PRSC_REG{
	unsigned int reg;
	struct T23_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_PRSC (*((volatile union T23_PRSC_REG *)0x40001D0C))
// model

/** 0x4000 1D10 T23_PPX **/
union T23_PPX_REG{
	unsigned int reg;
	struct T23_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_PPX (*((volatile union T23_PPX_REG *)0x40001D10))
// model

/** 0x4000 1D14 T23_UDTIM **/
union T23_UDTIM_REG{
	unsigned int reg;
	struct T23_UDTIM_BITS{
		unsigned int _TXUD:8;
		unsigned int _TRGPOL:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T23_UDTIM (*((volatile union T23_UDTIM_REG *)0x40001D14))
// modelT5

/** 0x4000 3480 T5_CNT **/
union T5_CNT_REG{
	unsigned int reg;
	struct T5_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CNT (*((volatile union T5_CNT_REG *)0x40003480))
// modelT6

/** 0x4000 3484 T6_CNT **/
union T6_CNT_REG{
	unsigned int reg;
	struct T6_CNT_BITS{
		unsigned int _TZCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CNT (*((volatile union T6_CNT_REG *)0x40003484))
// modelT5

/** 0x4000 3488 T5_PPX **/
union T5_PPX_REG{
	unsigned int reg;
	struct T5_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PPX (*((volatile union T5_PPX_REG *)0x40003488))
// modelT6

/** 0x4000 348C T6_PPZ **/
union T6_PPZ_REG{
	unsigned int reg;
	struct T6_PPZ_BITS{
		unsigned int _PPZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PPZ (*((volatile union T6_PPZ_REG *)0x4000348C))
// modelT5

/** 0x4000 3490 T5_PRSC **/
union T5_PRSC_REG{
	unsigned int reg;
	struct T5_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PRSC (*((volatile union T5_PRSC_REG *)0x40003490))
// modelT6

/** 0x4000 3494 T6_PRSC **/
union T6_PRSC_REG{
	unsigned int reg;
	struct T6_PRSC_BITS{
		unsigned int _TZCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PRSC (*((volatile union T6_PRSC_REG *)0x40003494))
// modelT5

/** 0x4000 3498 T5_CCR0 **/
union T5_CCR0_REG{
	unsigned int reg;
	struct T5_CCR0_BITS{
		unsigned int _TXCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCR0 (*((volatile union T5_CCR0_REG *)0x40003498))
// model

/** 0x4000 349C T5_CCR1 **/
union T5_CCR1_REG{
	unsigned int reg;
	struct T5_CCR1_BITS{
		unsigned int _TXCCR1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCR1 (*((volatile union T5_CCR1_REG *)0x4000349C))
// modelT6

/** 0x4000 34A0 T6_CCR0 **/
union T6_CCR0_REG{
	unsigned int reg;
	struct T6_CCR0_BITS{
		unsigned int _TZCCR:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CCR0 (*((volatile union T6_CCR0_REG *)0x400034A0))
// modelT5

/** 0x4000 34A4 T5_CTL **/
union T5_CTL_REG{
	unsigned int reg;
	struct T5_CTL_BITS{
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXEN:1;
		unsigned int _TXCKBS:4;
		unsigned int _TXDIR:1;
		unsigned int _TXCLK:2;
		unsigned int _TXADAUTO:1;
		unsigned int _TXOFS0:1;
		unsigned int _TXOFS1:1;
		unsigned int _TXCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CTL (*((volatile union T5_CTL_REG *)0x400034A4))
// modelT6

/** 0x4000 34A8 T6_CTL **/
union T6_CTL_REG{
	unsigned int reg;
	struct T6_CTL_BITS{
		unsigned int _TZCS:1;
		unsigned int _TZSY:1;
		unsigned int _TZEN:1;
		unsigned int _TZCKBS:4;
		unsigned int _TZDIR:1;
		unsigned int _TZCLK:2;
		unsigned int _TZADAUTO:1;
		unsigned int _TZOFS0:1;
		unsigned int _TZOFS1:1;
		unsigned int _TZCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CTL (*((volatile union T6_CTL_REG *)0x400034A8))
// modelT5

/** 0x4000 34B4 T5_CCTCTL **/
union T5_CCTCTL_REG{
	unsigned int reg;
	struct T5_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int _TCKFEN:1;
		unsigned int _TCKDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _TXCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCTCTL (*((volatile union T5_CCTCTL_REG *)0x400034B4))
// modelT6

/** 0x4000 34B8 T6_CCTCTL **/
union T6_CCTCTL_REG{
	unsigned int reg;
	struct T6_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int _TCKFEN:1;
		unsigned int _TCKDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _TZCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CCTCTL (*((volatile union T6_CCTCTL_REG *)0x400034B8))
// modelT9

/** 0x4000 3600 T9_CNT **/
union T9_CNT_REG{
	unsigned int reg;
	struct T9_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CNT (*((volatile union T9_CNT_REG *)0x40003600))
// modelT10

/** 0x4000 3604 T10_CNT **/
union T10_CNT_REG{
	unsigned int reg;
	struct T10_CNT_BITS{
		unsigned int _TZCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CNT (*((volatile union T10_CNT_REG *)0x40003604))
// modelT9

/** 0x4000 3608 T9_PPX **/
union T9_PPX_REG{
	unsigned int reg;
	struct T9_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_PPX (*((volatile union T9_PPX_REG *)0x40003608))
// modelT10

/** 0x4000 360C T10_PPZ **/
union T10_PPZ_REG{
	unsigned int reg;
	struct T10_PPZ_BITS{
		unsigned int _PPZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_PPZ (*((volatile union T10_PPZ_REG *)0x4000360C))
// modelT9

/** 0x4000 3610 T9_PRSC **/
union T9_PRSC_REG{
	unsigned int reg;
	struct T9_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_PRSC (*((volatile union T9_PRSC_REG *)0x40003610))
// modelT10

/** 0x4000 3614 T10_PRSC **/
union T10_PRSC_REG{
	unsigned int reg;
	struct T10_PRSC_BITS{
		unsigned int _TZCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_PRSC (*((volatile union T10_PRSC_REG *)0x40003614))
// modelT9

/** 0x4000 3618 T9_CCR0 **/
union T9_CCR0_REG{
	unsigned int reg;
	struct T9_CCR0_BITS{
		unsigned int _TXCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CCR0 (*((volatile union T9_CCR0_REG *)0x40003618))
// model

/** 0x4000 361C T9_CCR1 **/
union T9_CCR1_REG{
	unsigned int reg;
	struct T9_CCR1_BITS{
		unsigned int _TXCCR1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CCR1 (*((volatile union T9_CCR1_REG *)0x4000361C))
// modelT10

/** 0x4000 3620 T10_CCR0 **/
union T10_CCR0_REG{
	unsigned int reg;
	struct T10_CCR0_BITS{
		unsigned int _TZCCR:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CCR0 (*((volatile union T10_CCR0_REG *)0x40003620))
// modelT9

/** 0x4000 3624 T9_CTL **/
union T9_CTL_REG{
	unsigned int reg;
	struct T9_CTL_BITS{
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXEN:1;
		unsigned int _TXCKBS:4;
		unsigned int _TXDIR:1;
		unsigned int _TXCLK:2;
		unsigned int _TXADAUTO:1;
		unsigned int _TXOFS0:1;
		unsigned int _TXOFS1:1;
		unsigned int _TXCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CTL (*((volatile union T9_CTL_REG *)0x40003624))
// modelT10

/** 0x4000 3628 T10_CTL **/
union T10_CTL_REG{
	unsigned int reg;
	struct T10_CTL_BITS{
		unsigned int _TZCS:1;
		unsigned int _TZSY:1;
		unsigned int _TZEN:1;
		unsigned int _TZCKBS:4;
		unsigned int _TZDIR:1;
		unsigned int _TZCLK:2;
		unsigned int _TZADAUTO:1;
		unsigned int _TZOFS0:1;
		unsigned int _TZOFS1:1;
		unsigned int _TZCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CTL (*((volatile union T10_CTL_REG *)0x40003628))
// modelT9

/** 0x4000 3634 T9_CCTCTL **/
union T9_CCTCTL_REG{
	unsigned int reg;
	struct T9_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int _TCKFEN:1;
		unsigned int _TCKDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _TXCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_CCTCTL (*((volatile union T9_CCTCTL_REG *)0x40003634))
// modelT10

/** 0x4000 3638 T10_CCTCTL **/
union T10_CCTCTL_REG{
	unsigned int reg;
	struct T10_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int _TCKFEN:1;
		unsigned int _TCKDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _TZCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_CCTCTL (*((volatile union T10_CCTCTL_REG *)0x40003638))
// modelT25

/** 0x4000 3780 T25_CNT **/
union T25_CNT_REG{
	unsigned int reg;
	struct T25_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_CNT (*((volatile union T25_CNT_REG *)0x40003780))
// modelT26

/** 0x4000 3784 T26_CNT **/
union T26_CNT_REG{
	unsigned int reg;
	struct T26_CNT_BITS{
		unsigned int _TZCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_CNT (*((volatile union T26_CNT_REG *)0x40003784))
// modelT25

/** 0x4000 3788 T25_PPX **/
union T25_PPX_REG{
	unsigned int reg;
	struct T25_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_PPX (*((volatile union T25_PPX_REG *)0x40003788))
// modelT26

/** 0x4000 378C T26_PPZ **/
union T26_PPZ_REG{
	unsigned int reg;
	struct T26_PPZ_BITS{
		unsigned int _PPZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_PPZ (*((volatile union T26_PPZ_REG *)0x4000378C))
// modelT25

/** 0x4000 3790 T25_PRSC **/
union T25_PRSC_REG{
	unsigned int reg;
	struct T25_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_PRSC (*((volatile union T25_PRSC_REG *)0x40003790))
// modelT26

/** 0x4000 3794 T26_PRSC **/
union T26_PRSC_REG{
	unsigned int reg;
	struct T26_PRSC_BITS{
		unsigned int _TZCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_PRSC (*((volatile union T26_PRSC_REG *)0x40003794))
// modelT25

/** 0x4000 3798 T25_CCR0 **/
union T25_CCR0_REG{
	unsigned int reg;
	struct T25_CCR0_BITS{
		unsigned int _TXCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_CCR0 (*((volatile union T25_CCR0_REG *)0x40003798))
// model

/** 0x4000 379C T25_CCR1 **/
union T25_CCR1_REG{
	unsigned int reg;
	struct T25_CCR1_BITS{
		unsigned int _TXCCR1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_CCR1 (*((volatile union T25_CCR1_REG *)0x4000379C))
// modelT26

/** 0x4000 37A0 T26_CCR0 **/
union T26_CCR0_REG{
	unsigned int reg;
	struct T26_CCR0_BITS{
		unsigned int _TZCCR:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_CCR0 (*((volatile union T26_CCR0_REG *)0x400037A0))
// modelT25

/** 0x4000 37A4 T25_CTL **/
union T25_CTL_REG{
	unsigned int reg;
	struct T25_CTL_BITS{
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXEN:1;
		unsigned int _TXCKBS:4;
		unsigned int _TXDIR:1;
		unsigned int _TXCLK:2;
		unsigned int _TXADAUTO:1;
		unsigned int _TXOFS0:1;
		unsigned int _TXOFS1:1;
		unsigned int _TXCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_CTL (*((volatile union T25_CTL_REG *)0x400037A4))
// modelT26

/** 0x4000 37A8 T26_CTL **/
union T26_CTL_REG{
	unsigned int reg;
	struct T26_CTL_BITS{
		unsigned int _TZCS:1;
		unsigned int _TZSY:1;
		unsigned int _TZEN:1;
		unsigned int _TZCKBS:4;
		unsigned int _TZDIR:1;
		unsigned int _TZCLK:2;
		unsigned int _TZADAUTO:1;
		unsigned int _TZOFS0:1;
		unsigned int _TZOFS1:1;
		unsigned int _TZCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_CTL (*((volatile union T26_CTL_REG *)0x400037A8))
// modelT25

/** 0x4000 37B4 T25_CCTCTL **/
union T25_CCTCTL_REG{
	unsigned int reg;
	struct T25_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int _TCKFEN:1;
		unsigned int _TCKDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _TXCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_CCTCTL (*((volatile union T25_CCTCTL_REG *)0x400037B4))
// modelT26

/** 0x4000 37B8 T26_CCTCTL **/
union T26_CCTCTL_REG{
	unsigned int reg;
	struct T26_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int _TCKFEN:1;
		unsigned int _TCKDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _TZCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_CCTCTL (*((volatile union T26_CCTCTL_REG *)0x400037B8))
// modelCCP0

/** 0x4000 08A0 CCP0_C1 **/
union CCP0_C1_REG{
	unsigned int reg;
	struct CCP0_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C1 (*((volatile union CCP0_C1_REG *)0x400008A0))
// model

/** 0x4000 08A4 CCP0_C2 **/
union CCP0_C2_REG{
	unsigned int reg;
	struct CCP0_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C2 (*((volatile union CCP0_C2_REG *)0x400008A4))
// model

/** 0x4000 08A8 CCP0_C3 **/
union CCP0_C3_REG{
	unsigned int reg;
	struct CCP0_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C3 (*((volatile union CCP0_C3_REG *)0x400008A8))
// model

/** 0x4000 08AC CCP0_C4 **/
union CCP0_C4_REG{
	unsigned int reg;
	struct CCP0_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C4 (*((volatile union CCP0_C4_REG *)0x400008AC))
// model

/** 0x4000 08B0 CCP0_SRIC **/
union CCP0_SRIC_REG{
	unsigned int reg;
	struct CCP0_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_SRIC (*((volatile union CCP0_SRIC_REG *)0x400008B0))
// model

/** 0x4000 08B4 CCP0_DF **/
union CCP0_DF_REG{
	unsigned int reg;
	struct CCP0_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_DF (*((volatile union CCP0_DF_REG *)0x400008B4))
// model

/** 0x4000 08C0 CCP0_CTL1 **/
union CCP0_CTL1_REG{
	unsigned int reg;
	struct CCP0_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL1 (*((volatile union CCP0_CTL1_REG *)0x400008C0))
// model

/** 0x4000 08C4 CCP0_R1 **/
union CCP0_R1_REG{
	unsigned int reg;
	struct CCP0_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R1 (*((volatile union CCP0_R1_REG *)0x400008C4))
// model

/** 0x4000 08C8 CCP0_R2 **/
union CCP0_R2_REG{
	unsigned int reg;
	struct CCP0_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R2 (*((volatile union CCP0_R2_REG *)0x400008C8))
// model

/** 0x4000 08CC CCP0_R3 **/
union CCP0_R3_REG{
	unsigned int reg;
	struct CCP0_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R3 (*((volatile union CCP0_R3_REG *)0x400008CC))
// model

/** 0x4000 08D0 CCP0_R4 **/
union CCP0_R4_REG{
	unsigned int reg;
	struct CCP0_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R4 (*((volatile union CCP0_R4_REG *)0x400008D0))
// model

/** 0x4000 08D4 CCP0_CTL2 **/
union CCP0_CTL2_REG{
	unsigned int reg;
	struct CCP0_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL2 (*((volatile union CCP0_CTL2_REG *)0x400008D4))
// model

/** 0x4000 08D8 CCP0_CTL3 **/
union CCP0_CTL3_REG{
	unsigned int reg;
	struct CCP0_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL3 (*((volatile union CCP0_CTL3_REG *)0x400008D8))
// model

/** 0x4000 08DC CCP0_EGIF **/
union CCP0_EGIF_REG{
	unsigned int reg;
	struct CCP0_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_EGIF (*((volatile union CCP0_EGIF_REG *)0x400008DC))
// modelCCP1

/** 0x4000 0120 CCP1_C1 **/
union CCP1_C1_REG{
	unsigned int reg;
	struct CCP1_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C1 (*((volatile union CCP1_C1_REG *)0x40000120))
// model

/** 0x4000 0124 CCP1_C2 **/
union CCP1_C2_REG{
	unsigned int reg;
	struct CCP1_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C2 (*((volatile union CCP1_C2_REG *)0x40000124))
// model

/** 0x4000 0128 CCP1_C3 **/
union CCP1_C3_REG{
	unsigned int reg;
	struct CCP1_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C3 (*((volatile union CCP1_C3_REG *)0x40000128))
// model

/** 0x4000 012C CCP1_C4 **/
union CCP1_C4_REG{
	unsigned int reg;
	struct CCP1_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C4 (*((volatile union CCP1_C4_REG *)0x4000012C))
// model

/** 0x4000 0130 CCP1_SRIC **/
union CCP1_SRIC_REG{
	unsigned int reg;
	struct CCP1_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_SRIC (*((volatile union CCP1_SRIC_REG *)0x40000130))
// model

/** 0x4000 0134 CCP1_DF **/
union CCP1_DF_REG{
	unsigned int reg;
	struct CCP1_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_DF (*((volatile union CCP1_DF_REG *)0x40000134))
// model

/** 0x4000 0140 CCP1_CTL1 **/
union CCP1_CTL1_REG{
	unsigned int reg;
	struct CCP1_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL1 (*((volatile union CCP1_CTL1_REG *)0x40000140))
// model

/** 0x4000 0144 CCP1_R1 **/
union CCP1_R1_REG{
	unsigned int reg;
	struct CCP1_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R1 (*((volatile union CCP1_R1_REG *)0x40000144))
// model

/** 0x4000 0148 CCP1_R2 **/
union CCP1_R2_REG{
	unsigned int reg;
	struct CCP1_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R2 (*((volatile union CCP1_R2_REG *)0x40000148))
// model

/** 0x4000 014C CCP1_R3 **/
union CCP1_R3_REG{
	unsigned int reg;
	struct CCP1_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R3 (*((volatile union CCP1_R3_REG *)0x4000014C))
// model

/** 0x4000 0150 CCP1_R4 **/
union CCP1_R4_REG{
	unsigned int reg;
	struct CCP1_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R4 (*((volatile union CCP1_R4_REG *)0x40000150))
// model

/** 0x4000 0154 CCP1_CTL2 **/
union CCP1_CTL2_REG{
	unsigned int reg;
	struct CCP1_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL2 (*((volatile union CCP1_CTL2_REG *)0x40000154))
// model

/** 0x4000 0158 CCP1_CTL3 **/
union CCP1_CTL3_REG{
	unsigned int reg;
	struct CCP1_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL3 (*((volatile union CCP1_CTL3_REG *)0x40000158))
// model

/** 0x4000 015C CCP1_EGIF **/
union CCP1_EGIF_REG{
	unsigned int reg;
	struct CCP1_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_EGIF (*((volatile union CCP1_EGIF_REG *)0x4000015C))
// modelCCP2

/** 0x4000 01A0 CCP2_C1 **/
union CCP2_C1_REG{
	unsigned int reg;
	struct CCP2_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C1 (*((volatile union CCP2_C1_REG *)0x400001A0))
// model

/** 0x4000 01A4 CCP2_C2 **/
union CCP2_C2_REG{
	unsigned int reg;
	struct CCP2_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C2 (*((volatile union CCP2_C2_REG *)0x400001A4))
// model

/** 0x4000 01A8 CCP2_C3 **/
union CCP2_C3_REG{
	unsigned int reg;
	struct CCP2_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C3 (*((volatile union CCP2_C3_REG *)0x400001A8))
// model

/** 0x4000 01AC CCP2_C4 **/
union CCP2_C4_REG{
	unsigned int reg;
	struct CCP2_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C4 (*((volatile union CCP2_C4_REG *)0x400001AC))
// model

/** 0x4000 01B0 CCP2_SRIC **/
union CCP2_SRIC_REG{
	unsigned int reg;
	struct CCP2_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_SRIC (*((volatile union CCP2_SRIC_REG *)0x400001B0))
// model

/** 0x4000 01B4 CCP2_DF **/
union CCP2_DF_REG{
	unsigned int reg;
	struct CCP2_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_DF (*((volatile union CCP2_DF_REG *)0x400001B4))
// model

/** 0x4000 01C0 CCP2_CTL1 **/
union CCP2_CTL1_REG{
	unsigned int reg;
	struct CCP2_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL1 (*((volatile union CCP2_CTL1_REG *)0x400001C0))
// model

/** 0x4000 01C4 CCP2_R1 **/
union CCP2_R1_REG{
	unsigned int reg;
	struct CCP2_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R1 (*((volatile union CCP2_R1_REG *)0x400001C4))
// model

/** 0x4000 01C8 CCP2_R2 **/
union CCP2_R2_REG{
	unsigned int reg;
	struct CCP2_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R2 (*((volatile union CCP2_R2_REG *)0x400001C8))
// model

/** 0x4000 01CC CCP2_R3 **/
union CCP2_R3_REG{
	unsigned int reg;
	struct CCP2_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R3 (*((volatile union CCP2_R3_REG *)0x400001CC))
// model

/** 0x4000 01D0 CCP2_R4 **/
union CCP2_R4_REG{
	unsigned int reg;
	struct CCP2_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R4 (*((volatile union CCP2_R4_REG *)0x400001D0))
// model

/** 0x4000 01D4 CCP2_CTL2 **/
union CCP2_CTL2_REG{
	unsigned int reg;
	struct CCP2_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL2 (*((volatile union CCP2_CTL2_REG *)0x400001D4))
// model

/** 0x4000 01D8 CCP2_CTL3 **/
union CCP2_CTL3_REG{
	unsigned int reg;
	struct CCP2_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL3 (*((volatile union CCP2_CTL3_REG *)0x400001D8))
// model

/** 0x4000 01DC CCP2_EGIF **/
union CCP2_EGIF_REG{
	unsigned int reg;
	struct CCP2_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_EGIF (*((volatile union CCP2_EGIF_REG *)0x400001DC))
// modelCCP3

/** 0x4000 0220 CCP3_C1 **/
union CCP3_C1_REG{
	unsigned int reg;
	struct CCP3_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C1 (*((volatile union CCP3_C1_REG *)0x40000220))
// model

/** 0x4000 0224 CCP3_C2 **/
union CCP3_C2_REG{
	unsigned int reg;
	struct CCP3_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C2 (*((volatile union CCP3_C2_REG *)0x40000224))
// model

/** 0x4000 0228 CCP3_C3 **/
union CCP3_C3_REG{
	unsigned int reg;
	struct CCP3_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C3 (*((volatile union CCP3_C3_REG *)0x40000228))
// model

/** 0x4000 022C CCP3_C4 **/
union CCP3_C4_REG{
	unsigned int reg;
	struct CCP3_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C4 (*((volatile union CCP3_C4_REG *)0x4000022C))
// model

/** 0x4000 0230 CCP3_SRIC **/
union CCP3_SRIC_REG{
	unsigned int reg;
	struct CCP3_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_SRIC (*((volatile union CCP3_SRIC_REG *)0x40000230))
// model

/** 0x4000 0234 CCP3_DF **/
union CCP3_DF_REG{
	unsigned int reg;
	struct CCP3_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_DF (*((volatile union CCP3_DF_REG *)0x40000234))
// model

/** 0x4000 0240 CCP3_CTL1 **/
union CCP3_CTL1_REG{
	unsigned int reg;
	struct CCP3_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL1 (*((volatile union CCP3_CTL1_REG *)0x40000240))
// model

/** 0x4000 0244 CCP3_R1 **/
union CCP3_R1_REG{
	unsigned int reg;
	struct CCP3_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R1 (*((volatile union CCP3_R1_REG *)0x40000244))
// model

/** 0x4000 0248 CCP3_R2 **/
union CCP3_R2_REG{
	unsigned int reg;
	struct CCP3_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R2 (*((volatile union CCP3_R2_REG *)0x40000248))
// model

/** 0x4000 024C CCP3_R3 **/
union CCP3_R3_REG{
	unsigned int reg;
	struct CCP3_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R3 (*((volatile union CCP3_R3_REG *)0x4000024C))
// model

/** 0x4000 0250 CCP3_R4 **/
union CCP3_R4_REG{
	unsigned int reg;
	struct CCP3_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R4 (*((volatile union CCP3_R4_REG *)0x40000250))
// model

/** 0x4000 0254 CCP3_CTL2 **/
union CCP3_CTL2_REG{
	unsigned int reg;
	struct CCP3_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL2 (*((volatile union CCP3_CTL2_REG *)0x40000254))
// model

/** 0x4000 0258 CCP3_CTL3 **/
union CCP3_CTL3_REG{
	unsigned int reg;
	struct CCP3_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL3 (*((volatile union CCP3_CTL3_REG *)0x40000258))
// model

/** 0x4000 025C CCP3_EGIF **/
union CCP3_EGIF_REG{
	unsigned int reg;
	struct CCP3_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_EGIF (*((volatile union CCP3_EGIF_REG *)0x4000025C))
// modelCCP4

/** 0x4000 02A0 CCP4_C1 **/
union CCP4_C1_REG{
	unsigned int reg;
	struct CCP4_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C1 (*((volatile union CCP4_C1_REG *)0x400002A0))
// model

/** 0x4000 02A4 CCP4_C2 **/
union CCP4_C2_REG{
	unsigned int reg;
	struct CCP4_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C2 (*((volatile union CCP4_C2_REG *)0x400002A4))
// model

/** 0x4000 02A8 CCP4_C3 **/
union CCP4_C3_REG{
	unsigned int reg;
	struct CCP4_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C3 (*((volatile union CCP4_C3_REG *)0x400002A8))
// model

/** 0x4000 02AC CCP4_C4 **/
union CCP4_C4_REG{
	unsigned int reg;
	struct CCP4_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C4 (*((volatile union CCP4_C4_REG *)0x400002AC))
// model

/** 0x4000 02B0 CCP4_SRIC **/
union CCP4_SRIC_REG{
	unsigned int reg;
	struct CCP4_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_SRIC (*((volatile union CCP4_SRIC_REG *)0x400002B0))
// model

/** 0x4000 02B4 CCP4_DF **/
union CCP4_DF_REG{
	unsigned int reg;
	struct CCP4_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_DF (*((volatile union CCP4_DF_REG *)0x400002B4))
// model

/** 0x4000 02C0 CCP4_CTL1 **/
union CCP4_CTL1_REG{
	unsigned int reg;
	struct CCP4_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL1 (*((volatile union CCP4_CTL1_REG *)0x400002C0))
// model

/** 0x4000 02C4 CCP4_R1 **/
union CCP4_R1_REG{
	unsigned int reg;
	struct CCP4_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R1 (*((volatile union CCP4_R1_REG *)0x400002C4))
// model

/** 0x4000 02C8 CCP4_R2 **/
union CCP4_R2_REG{
	unsigned int reg;
	struct CCP4_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R2 (*((volatile union CCP4_R2_REG *)0x400002C8))
// model

/** 0x4000 02CC CCP4_R3 **/
union CCP4_R3_REG{
	unsigned int reg;
	struct CCP4_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R3 (*((volatile union CCP4_R3_REG *)0x400002CC))
// model

/** 0x4000 02D0 CCP4_R4 **/
union CCP4_R4_REG{
	unsigned int reg;
	struct CCP4_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R4 (*((volatile union CCP4_R4_REG *)0x400002D0))
// model

/** 0x4000 02D4 CCP4_CTL2 **/
union CCP4_CTL2_REG{
	unsigned int reg;
	struct CCP4_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL2 (*((volatile union CCP4_CTL2_REG *)0x400002D4))
// model

/** 0x4000 02D8 CCP4_CTL3 **/
union CCP4_CTL3_REG{
	unsigned int reg;
	struct CCP4_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL3 (*((volatile union CCP4_CTL3_REG *)0x400002D8))
// model

/** 0x4000 02DC CCP4_EGIF **/
union CCP4_EGIF_REG{
	unsigned int reg;
	struct CCP4_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_EGIF (*((volatile union CCP4_EGIF_REG *)0x400002DC))
// modelCCP18

/** 0x4000 1AA0 CCP18_C1 **/
union CCP18_C1_REG{
	unsigned int reg;
	struct CCP18_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C1 (*((volatile union CCP18_C1_REG *)0x40001AA0))
// model

/** 0x4000 1AA4 CCP18_C2 **/
union CCP18_C2_REG{
	unsigned int reg;
	struct CCP18_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C2 (*((volatile union CCP18_C2_REG *)0x40001AA4))
// model

/** 0x4000 1AA8 CCP18_C3 **/
union CCP18_C3_REG{
	unsigned int reg;
	struct CCP18_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C3 (*((volatile union CCP18_C3_REG *)0x40001AA8))
// model

/** 0x4000 1AAC CCP18_C4 **/
union CCP18_C4_REG{
	unsigned int reg;
	struct CCP18_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C4 (*((volatile union CCP18_C4_REG *)0x40001AAC))
// model

/** 0x4000 1AB0 CCP18_SRIC **/
union CCP18_SRIC_REG{
	unsigned int reg;
	struct CCP18_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_SRIC (*((volatile union CCP18_SRIC_REG *)0x40001AB0))
// model

/** 0x4000 1AB4 CCP18_DF **/
union CCP18_DF_REG{
	unsigned int reg;
	struct CCP18_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_DF (*((volatile union CCP18_DF_REG *)0x40001AB4))
// model

/** 0x4000 1AC0 CCP18_CTL1 **/
union CCP18_CTL1_REG{
	unsigned int reg;
	struct CCP18_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL1 (*((volatile union CCP18_CTL1_REG *)0x40001AC0))
// model

/** 0x4000 1AC4 CCP18_R1 **/
union CCP18_R1_REG{
	unsigned int reg;
	struct CCP18_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R1 (*((volatile union CCP18_R1_REG *)0x40001AC4))
// model

/** 0x4000 1AC8 CCP18_R2 **/
union CCP18_R2_REG{
	unsigned int reg;
	struct CCP18_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R2 (*((volatile union CCP18_R2_REG *)0x40001AC8))
// model

/** 0x4000 1ACC CCP18_R3 **/
union CCP18_R3_REG{
	unsigned int reg;
	struct CCP18_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R3 (*((volatile union CCP18_R3_REG *)0x40001ACC))
// model

/** 0x4000 1AD0 CCP18_R4 **/
union CCP18_R4_REG{
	unsigned int reg;
	struct CCP18_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R4 (*((volatile union CCP18_R4_REG *)0x40001AD0))
// model

/** 0x4000 1AD4 CCP18_CTL2 **/
union CCP18_CTL2_REG{
	unsigned int reg;
	struct CCP18_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL2 (*((volatile union CCP18_CTL2_REG *)0x40001AD4))
// model

/** 0x4000 1AD8 CCP18_CTL3 **/
union CCP18_CTL3_REG{
	unsigned int reg;
	struct CCP18_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL3 (*((volatile union CCP18_CTL3_REG *)0x40001AD8))
// model

/** 0x4000 1ADC CCP18_EGIF **/
union CCP18_EGIF_REG{
	unsigned int reg;
	struct CCP18_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_EGIF (*((volatile union CCP18_EGIF_REG *)0x40001ADC))
// modelCCP19

/** 0x4000 1B20 CCP19_C1 **/
union CCP19_C1_REG{
	unsigned int reg;
	struct CCP19_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C1 (*((volatile union CCP19_C1_REG *)0x40001B20))
// model

/** 0x4000 1B24 CCP19_C2 **/
union CCP19_C2_REG{
	unsigned int reg;
	struct CCP19_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C2 (*((volatile union CCP19_C2_REG *)0x40001B24))
// model

/** 0x4000 1B28 CCP19_C3 **/
union CCP19_C3_REG{
	unsigned int reg;
	struct CCP19_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C3 (*((volatile union CCP19_C3_REG *)0x40001B28))
// model

/** 0x4000 1B2C CCP19_C4 **/
union CCP19_C4_REG{
	unsigned int reg;
	struct CCP19_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C4 (*((volatile union CCP19_C4_REG *)0x40001B2C))
// model

/** 0x4000 1B30 CCP19_SRIC **/
union CCP19_SRIC_REG{
	unsigned int reg;
	struct CCP19_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_SRIC (*((volatile union CCP19_SRIC_REG *)0x40001B30))
// model

/** 0x4000 1B34 CCP19_DF **/
union CCP19_DF_REG{
	unsigned int reg;
	struct CCP19_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_DF (*((volatile union CCP19_DF_REG *)0x40001B34))
// model

/** 0x4000 1B40 CCP19_CTL1 **/
union CCP19_CTL1_REG{
	unsigned int reg;
	struct CCP19_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL1 (*((volatile union CCP19_CTL1_REG *)0x40001B40))
// model

/** 0x4000 1B44 CCP19_R1 **/
union CCP19_R1_REG{
	unsigned int reg;
	struct CCP19_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R1 (*((volatile union CCP19_R1_REG *)0x40001B44))
// model

/** 0x4000 1B48 CCP19_R2 **/
union CCP19_R2_REG{
	unsigned int reg;
	struct CCP19_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R2 (*((volatile union CCP19_R2_REG *)0x40001B48))
// model

/** 0x4000 1B4C CCP19_R3 **/
union CCP19_R3_REG{
	unsigned int reg;
	struct CCP19_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R3 (*((volatile union CCP19_R3_REG *)0x40001B4C))
// model

/** 0x4000 1B50 CCP19_R4 **/
union CCP19_R4_REG{
	unsigned int reg;
	struct CCP19_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R4 (*((volatile union CCP19_R4_REG *)0x40001B50))
// model

/** 0x4000 1B54 CCP19_CTL2 **/
union CCP19_CTL2_REG{
	unsigned int reg;
	struct CCP19_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL2 (*((volatile union CCP19_CTL2_REG *)0x40001B54))
// model

/** 0x4000 1B58 CCP19_CTL3 **/
union CCP19_CTL3_REG{
	unsigned int reg;
	struct CCP19_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL3 (*((volatile union CCP19_CTL3_REG *)0x40001B58))
// model

/** 0x4000 1B5C CCP19_EGIF **/
union CCP19_EGIF_REG{
	unsigned int reg;
	struct CCP19_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_EGIF (*((volatile union CCP19_EGIF_REG *)0x40001B5C))
// modelCCP20

/** 0x4000 1BA0 CCP20_C1 **/
union CCP20_C1_REG{
	unsigned int reg;
	struct CCP20_C1_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C1 (*((volatile union CCP20_C1_REG *)0x40001BA0))
// model

/** 0x4000 1BA4 CCP20_C2 **/
union CCP20_C2_REG{
	unsigned int reg;
	struct CCP20_C2_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C2 (*((volatile union CCP20_C2_REG *)0x40001BA4))
// model

/** 0x4000 1BA8 CCP20_C3 **/
union CCP20_C3_REG{
	unsigned int reg;
	struct CCP20_C3_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C3 (*((volatile union CCP20_C3_REG *)0x40001BA8))
// model

/** 0x4000 1BAC CCP20_C4 **/
union CCP20_C4_REG{
	unsigned int reg;
	struct CCP20_C4_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_C4 (*((volatile union CCP20_C4_REG *)0x40001BAC))
// model

/** 0x4000 1BB0 CCP20_SRIC **/
union CCP20_SRIC_REG{
	unsigned int reg;
	struct CCP20_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_SRIC (*((volatile union CCP20_SRIC_REG *)0x40001BB0))
// model

/** 0x4000 1BB4 CCP20_DF **/
union CCP20_DF_REG{
	unsigned int reg;
	struct CCP20_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_DF (*((volatile union CCP20_DF_REG *)0x40001BB4))
// model

/** 0x4000 1BC0 CCP20_CTL1 **/
union CCP20_CTL1_REG{
	unsigned int reg;
	struct CCP20_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_CTL1 (*((volatile union CCP20_CTL1_REG *)0x40001BC0))
// model

/** 0x4000 1BC4 CCP20_R1 **/
union CCP20_R1_REG{
	unsigned int reg;
	struct CCP20_R1_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R1 (*((volatile union CCP20_R1_REG *)0x40001BC4))
// model

/** 0x4000 1BC8 CCP20_R2 **/
union CCP20_R2_REG{
	unsigned int reg;
	struct CCP20_R2_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R2 (*((volatile union CCP20_R2_REG *)0x40001BC8))
// model

/** 0x4000 1BCC CCP20_R3 **/
union CCP20_R3_REG{
	unsigned int reg;
	struct CCP20_R3_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R3 (*((volatile union CCP20_R3_REG *)0x40001BCC))
// model

/** 0x4000 1BD0 CCP20_R4 **/
union CCP20_R4_REG{
	unsigned int reg;
	struct CCP20_R4_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_R4 (*((volatile union CCP20_R4_REG *)0x40001BD0))
// model

/** 0x4000 1BD4 CCP20_CTL2 **/
union CCP20_CTL2_REG{
	unsigned int reg;
	struct CCP20_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_CTL2 (*((volatile union CCP20_CTL2_REG *)0x40001BD4))
// model

/** 0x4000 1BD8 CCP20_CTL3 **/
union CCP20_CTL3_REG{
	unsigned int reg;
	struct CCP20_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_CTL3 (*((volatile union CCP20_CTL3_REG *)0x40001BD8))
// model

/** 0x4000 1BDC CCP20_EGIF **/
union CCP20_EGIF_REG{
	unsigned int reg;
	struct CCP20_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP20_EGIF (*((volatile union CCP20_EGIF_REG *)0x40001BDC))
// modelCCP21

/** 0x4000 1C20 CCP21_C1 **/
union CCP21_C1_REG{
	unsigned int reg;
	struct CCP21_C1_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C1 (*((volatile union CCP21_C1_REG *)0x40001C20))
// model

/** 0x4000 1C24 CCP21_C2 **/
union CCP21_C2_REG{
	unsigned int reg;
	struct CCP21_C2_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C2 (*((volatile union CCP21_C2_REG *)0x40001C24))
// model

/** 0x4000 1C28 CCP21_C3 **/
union CCP21_C3_REG{
	unsigned int reg;
	struct CCP21_C3_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C3 (*((volatile union CCP21_C3_REG *)0x40001C28))
// model

/** 0x4000 1C2C CCP21_C4 **/
union CCP21_C4_REG{
	unsigned int reg;
	struct CCP21_C4_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C4 (*((volatile union CCP21_C4_REG *)0x40001C2C))
// model

/** 0x4000 1C30 CCP21_SRIC **/
union CCP21_SRIC_REG{
	unsigned int reg;
	struct CCP21_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_SRIC (*((volatile union CCP21_SRIC_REG *)0x40001C30))
// model

/** 0x4000 1C34 CCP21_DF **/
union CCP21_DF_REG{
	unsigned int reg;
	struct CCP21_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_DF (*((volatile union CCP21_DF_REG *)0x40001C34))
// model

/** 0x4000 1C40 CCP21_CTL1 **/
union CCP21_CTL1_REG{
	unsigned int reg;
	struct CCP21_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL1 (*((volatile union CCP21_CTL1_REG *)0x40001C40))
// model

/** 0x4000 1C44 CCP21_R1 **/
union CCP21_R1_REG{
	unsigned int reg;
	struct CCP21_R1_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R1 (*((volatile union CCP21_R1_REG *)0x40001C44))
// model

/** 0x4000 1C48 CCP21_R2 **/
union CCP21_R2_REG{
	unsigned int reg;
	struct CCP21_R2_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R2 (*((volatile union CCP21_R2_REG *)0x40001C48))
// model

/** 0x4000 1C4C CCP21_R3 **/
union CCP21_R3_REG{
	unsigned int reg;
	struct CCP21_R3_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R3 (*((volatile union CCP21_R3_REG *)0x40001C4C))
// model

/** 0x4000 1C50 CCP21_R4 **/
union CCP21_R4_REG{
	unsigned int reg;
	struct CCP21_R4_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R4 (*((volatile union CCP21_R4_REG *)0x40001C50))
// model

/** 0x4000 1C54 CCP21_CTL2 **/
union CCP21_CTL2_REG{
	unsigned int reg;
	struct CCP21_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL2 (*((volatile union CCP21_CTL2_REG *)0x40001C54))
// model

/** 0x4000 1C58 CCP21_CTL3 **/
union CCP21_CTL3_REG{
	unsigned int reg;
	struct CCP21_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL3 (*((volatile union CCP21_CTL3_REG *)0x40001C58))
// model

/** 0x4000 1C5C CCP21_EGIF **/
union CCP21_EGIF_REG{
	unsigned int reg;
	struct CCP21_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_EGIF (*((volatile union CCP21_EGIF_REG *)0x40001C5C))
// modelCCP22

/** 0x4000 1CA0 CCP22_C1 **/
union CCP22_C1_REG{
	unsigned int reg;
	struct CCP22_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C1 (*((volatile union CCP22_C1_REG *)0x40001CA0))
// model

/** 0x4000 1CA4 CCP22_C2 **/
union CCP22_C2_REG{
	unsigned int reg;
	struct CCP22_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C2 (*((volatile union CCP22_C2_REG *)0x40001CA4))
// model

/** 0x4000 1CA8 CCP22_C3 **/
union CCP22_C3_REG{
	unsigned int reg;
	struct CCP22_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C3 (*((volatile union CCP22_C3_REG *)0x40001CA8))
// model

/** 0x4000 1CAC CCP22_C4 **/
union CCP22_C4_REG{
	unsigned int reg;
	struct CCP22_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_C4 (*((volatile union CCP22_C4_REG *)0x40001CAC))
// model

/** 0x4000 1CB0 CCP22_SRIC **/
union CCP22_SRIC_REG{
	unsigned int reg;
	struct CCP22_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_SRIC (*((volatile union CCP22_SRIC_REG *)0x40001CB0))
// model

/** 0x4000 1CB4 CCP22_DF **/
union CCP22_DF_REG{
	unsigned int reg;
	struct CCP22_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_DF (*((volatile union CCP22_DF_REG *)0x40001CB4))
// model

/** 0x4000 1CC0 CCP22_CTL1 **/
union CCP22_CTL1_REG{
	unsigned int reg;
	struct CCP22_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_CTL1 (*((volatile union CCP22_CTL1_REG *)0x40001CC0))
// model

/** 0x4000 1CC4 CCP22_R1 **/
union CCP22_R1_REG{
	unsigned int reg;
	struct CCP22_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R1 (*((volatile union CCP22_R1_REG *)0x40001CC4))
// model

/** 0x4000 1CC8 CCP22_R2 **/
union CCP22_R2_REG{
	unsigned int reg;
	struct CCP22_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R2 (*((volatile union CCP22_R2_REG *)0x40001CC8))
// model

/** 0x4000 1CCC CCP22_R3 **/
union CCP22_R3_REG{
	unsigned int reg;
	struct CCP22_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R3 (*((volatile union CCP22_R3_REG *)0x40001CCC))
// model

/** 0x4000 1CD0 CCP22_R4 **/
union CCP22_R4_REG{
	unsigned int reg;
	struct CCP22_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_R4 (*((volatile union CCP22_R4_REG *)0x40001CD0))
// model

/** 0x4000 1CD4 CCP22_CTL2 **/
union CCP22_CTL2_REG{
	unsigned int reg;
	struct CCP22_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_CTL2 (*((volatile union CCP22_CTL2_REG *)0x40001CD4))
// model

/** 0x4000 1CD8 CCP22_CTL3 **/
union CCP22_CTL3_REG{
	unsigned int reg;
	struct CCP22_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_CTL3 (*((volatile union CCP22_CTL3_REG *)0x40001CD8))
// model

/** 0x4000 1CDC CCP22_EGIF **/
union CCP22_EGIF_REG{
	unsigned int reg;
	struct CCP22_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP22_EGIF (*((volatile union CCP22_EGIF_REG *)0x40001CDC))
// modelCCP23

/** 0x4000 1D20 CCP23_C1 **/
union CCP23_C1_REG{
	unsigned int reg;
	struct CCP23_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C1 (*((volatile union CCP23_C1_REG *)0x40001D20))
// model

/** 0x4000 1D24 CCP23_C2 **/
union CCP23_C2_REG{
	unsigned int reg;
	struct CCP23_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C2 (*((volatile union CCP23_C2_REG *)0x40001D24))
// model

/** 0x4000 1D28 CCP23_C3 **/
union CCP23_C3_REG{
	unsigned int reg;
	struct CCP23_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C3 (*((volatile union CCP23_C3_REG *)0x40001D28))
// model

/** 0x4000 1D2C CCP23_C4 **/
union CCP23_C4_REG{
	unsigned int reg;
	struct CCP23_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_C4 (*((volatile union CCP23_C4_REG *)0x40001D2C))
// model

/** 0x4000 1D30 CCP23_SRIC **/
union CCP23_SRIC_REG{
	unsigned int reg;
	struct CCP23_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_SRIC (*((volatile union CCP23_SRIC_REG *)0x40001D30))
// model

/** 0x4000 1D34 CCP23_DF **/
union CCP23_DF_REG{
	unsigned int reg;
	struct CCP23_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_DF (*((volatile union CCP23_DF_REG *)0x40001D34))
// model

/** 0x4000 1D40 CCP23_CTL1 **/
union CCP23_CTL1_REG{
	unsigned int reg;
	struct CCP23_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_CTL1 (*((volatile union CCP23_CTL1_REG *)0x40001D40))
// model

/** 0x4000 1D44 CCP23_R1 **/
union CCP23_R1_REG{
	unsigned int reg;
	struct CCP23_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R1 (*((volatile union CCP23_R1_REG *)0x40001D44))
// model

/** 0x4000 1D48 CCP23_R2 **/
union CCP23_R2_REG{
	unsigned int reg;
	struct CCP23_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R2 (*((volatile union CCP23_R2_REG *)0x40001D48))
// model

/** 0x4000 1D4C CCP23_R3 **/
union CCP23_R3_REG{
	unsigned int reg;
	struct CCP23_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R3 (*((volatile union CCP23_R3_REG *)0x40001D4C))
// model

/** 0x4000 1D50 CCP23_R4 **/
union CCP23_R4_REG{
	unsigned int reg;
	struct CCP23_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_R4 (*((volatile union CCP23_R4_REG *)0x40001D50))
// model

/** 0x4000 1D54 CCP23_CTL2 **/
union CCP23_CTL2_REG{
	unsigned int reg;
	struct CCP23_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_CTL2 (*((volatile union CCP23_CTL2_REG *)0x40001D54))
// model

/** 0x4000 1D58 CCP23_CTL3 **/
union CCP23_CTL3_REG{
	unsigned int reg;
	struct CCP23_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_CTL3 (*((volatile union CCP23_CTL3_REG *)0x40001D58))
// model

/** 0x4000 1D5C CCP23_EGIF **/
union CCP23_EGIF_REG{
	unsigned int reg;
	struct CCP23_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP23_EGIF (*((volatile union CCP23_EGIF_REG *)0x40001D5C))
// modelECCP5

/** 0x4000 34AC ECCP5_PDCTL **/
union ECCP5_PDCTL_REG{
	unsigned int reg;
	struct ECCP5_PDCTL_BITS{
		unsigned int _CPE:2;
		unsigned int _CMPE:1;
		unsigned int _TI0EN:1;
		unsigned int _TI1EN:1;
		unsigned int _TI2EN:1;
		unsigned int :1;
		unsigned int _SMPEN:1;
		unsigned int _RDA:3;
		unsigned int :1;
		unsigned int _CPD:3;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PDCTL (*((volatile union ECCP5_PDCTL_REG *)0x400034AC))
// model

/** 0x4000 34B0 ECCP5_PXASCTL **/
union ECCP5_PXASCTL_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL_BITS{
		unsigned int _TXPXASS:2;
		unsigned int _TZPXASS:2;
		unsigned int _TXBKINS:1;
		unsigned int _TZBKINS:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL (*((volatile union ECCP5_PXASCTL_REG *)0x400034B0))
// model

/** 0x4000 34C0 ECCP5_COMH1 **/
union ECCP5_COMH1_REG{
	unsigned int reg;
	struct ECCP5_COMH1_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH1 (*((volatile union ECCP5_COMH1_REG *)0x400034C0))
// model

/** 0x4000 34C4 ECCP5_COML1 **/
union ECCP5_COML1_REG{
	unsigned int reg;
	struct ECCP5_COML1_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML1 (*((volatile union ECCP5_COML1_REG *)0x400034C4))
// model

/** 0x4000 34C8 ECCP5_FAUCTL1 **/
union ECCP5_FAUCTL1_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL1_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL1 (*((volatile union ECCP5_FAUCTL1_REG *)0x400034C8))
// model

/** 0x4000 34CC ECCP5_DITCTL **/
union ECCP5_DITCTL_REG{
	unsigned int reg;
	struct ECCP5_DITCTL_BITS{
		unsigned int _FRCVAL:5;
		unsigned int _DEDEN:1;
		unsigned int _DPEEN:1;
		unsigned int _DCOMEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DITCTL (*((volatile union ECCP5_DITCTL_REG *)0x400034CC))
// model

/** 0x4000 34D0 ECCP5_COMH2 **/
union ECCP5_COMH2_REG{
	unsigned int reg;
	struct ECCP5_COMH2_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH2 (*((volatile union ECCP5_COMH2_REG *)0x400034D0))
// model

/** 0x4000 34D4 ECCP5_COML2 **/
union ECCP5_COML2_REG{
	unsigned int reg;
	struct ECCP5_COML2_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML2 (*((volatile union ECCP5_COML2_REG *)0x400034D4))
// model

/** 0x4000 34D8 ECCP5_FAUCTL2 **/
union ECCP5_FAUCTL2_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL2_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL2 (*((volatile union ECCP5_FAUCTL2_REG *)0x400034D8))
// model

/** 0x4000 34DC ECCP5_CCRCTL **/
union ECCP5_CCRCTL_REG{
	unsigned int reg;
	struct ECCP5_CCRCTL_BITS{
		unsigned int _TXCCR0SEN:1;
		unsigned int _TXCCR1SEN:1;
		unsigned int _TZCCR0SEN:1;
		unsigned int _TXCCR0SEL:1;
		unsigned int _TXCCR1SEL:1;
		unsigned int _TZCCR0SEL:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CCRCTL (*((volatile union ECCP5_CCRCTL_REG *)0x400034DC))
// model

/** 0x4000 34E0 ECCP5_COMH3 **/
union ECCP5_COMH3_REG{
	unsigned int reg;
	struct ECCP5_COMH3_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH3 (*((volatile union ECCP5_COMH3_REG *)0x400034E0))
// model

/** 0x4000 34E4 ECCP5_COML3 **/
union ECCP5_COML3_REG{
	unsigned int reg;
	struct ECCP5_COML3_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML3 (*((volatile union ECCP5_COML3_REG *)0x400034E4))
// model

/** 0x4000 34E8 ECCP5_FAUCTL3 **/
union ECCP5_FAUCTL3_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL3_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL3 (*((volatile union ECCP5_FAUCTL3_REG *)0x400034E8))
// model

/** 0x4000 34F0 ECCP5_COMH4 **/
union ECCP5_COMH4_REG{
	unsigned int reg;
	struct ECCP5_COMH4_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH4 (*((volatile union ECCP5_COMH4_REG *)0x400034F0))
// model

/** 0x4000 34F4 ECCP5_COML4 **/
union ECCP5_COML4_REG{
	unsigned int reg;
	struct ECCP5_COML4_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML4 (*((volatile union ECCP5_COML4_REG *)0x400034F4))
// model

/** 0x4000 34F8 ECCP5_FAUCTL4 **/
union ECCP5_FAUCTL4_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL4_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL4 (*((volatile union ECCP5_FAUCTL4_REG *)0x400034F8))
// model

/** 0x4000 3500 ECCP5_CTL1 **/
union ECCP5_CTL1_REG{
	unsigned int reg;
	struct ECCP5_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL1 (*((volatile union ECCP5_CTL1_REG *)0x40003500))
// model

/** 0x4000 3504 ECCP5_R1 **/
union ECCP5_R1_REG{
	unsigned int reg;
	struct ECCP5_R1_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R1 (*((volatile union ECCP5_R1_REG *)0x40003504))
// model

/** 0x4000 3508 ECCP5_R2 **/
union ECCP5_R2_REG{
	unsigned int reg;
	struct ECCP5_R2_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R2 (*((volatile union ECCP5_R2_REG *)0x40003508))
// model

/** 0x4000 350C ECCP5_R3 **/
union ECCP5_R3_REG{
	unsigned int reg;
	struct ECCP5_R3_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R3 (*((volatile union ECCP5_R3_REG *)0x4000350C))
// model

/** 0x4000 3510 ECCP5_R4 **/
union ECCP5_R4_REG{
	unsigned int reg;
	struct ECCP5_R4_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R4 (*((volatile union ECCP5_R4_REG *)0x40003510))
// model

/** 0x4000 3514 ECCP5_PXUDCTL **/
union ECCP5_PXUDCTL_REG{
	unsigned int reg;
	struct ECCP5_PXUDCTL_BITS{
		unsigned int _PXUDEN0:1;
		unsigned int _PXUDEN1:1;
		unsigned int _PXUDEVT0:1;
		unsigned int _PXUDEVT1:1;
		unsigned int _PXUDEVT2:1;
		unsigned int _PXUDEVT3:1;
		unsigned int _PXMPEN:1;
		unsigned int _TXUDR:1;
		unsigned int _TXIFUDREN:1;
		unsigned int _TZUDR:1;
		unsigned int _TZIFUDREN:1;
		unsigned int _DBUDEN:1;
		unsigned int _READTEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXUDCTL (*((volatile union ECCP5_PXUDCTL_REG *)0x40003514))
// model

/** 0x4000 3518 ECCP5_CTL2 **/
union ECCP5_CTL2_REG{
	unsigned int reg;
	struct ECCP5_CTL2_BITS{
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:3;
		unsigned int _TXMSSYYNC:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _TZSMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL2 (*((volatile union ECCP5_CTL2_REG *)0x40003518))
// model

/** 0x4000 351C ECCP5_PXDTCTL **/
union ECCP5_PXDTCTL_REG{
	unsigned int reg;
	struct ECCP5_PXDTCTL_BITS{
		unsigned int _PXDC:8;
		unsigned int _PZDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXDTCTL (*((volatile union ECCP5_PXDTCTL_REG *)0x4000351C))
// model

/** 0x4000 3520 ECCP5_PWMXOC **/
union ECCP5_PWMXOC_REG{
	unsigned int reg;
	struct ECCP5_PWMXOC_BITS{
		unsigned int _PXOC1L:2;
		unsigned int _PXOC1H:2;
		unsigned int _PXOC2L:2;
		unsigned int _PXOC2H:2;
		unsigned int _PXOC3L:2;
		unsigned int _PXOC3H:2;
		unsigned int _PXOC4L:2;
		unsigned int _PXOC4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PWMXOC (*((volatile union ECCP5_PWMXOC_REG *)0x40003520))
// model

/** 0x4000 3524 ECCP5_PXATRCTL **/
union ECCP5_PXATRCTL_REG{
	unsigned int reg;
	struct ECCP5_PXATRCTL_BITS{
		unsigned int :8;
		unsigned int _PXCH1MOD:1;
		unsigned int _PXCH2MOD:1;
		unsigned int _PXCH3MOD:1;
		unsigned int _PXCH4MOD:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXATRCTL (*((volatile union ECCP5_PXATRCTL_REG *)0x40003524))
// model

/** 0x4000 3528 ECCP5_PXASCTL0 **/
union ECCP5_PXASCTL0_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL0_BITS{
		unsigned int _PXASS1:2;
		unsigned int _PXASS2:2;
		unsigned int _PXASS3:2;
		unsigned int _PXASS4:2;
		unsigned int _PXASE1:1;
		unsigned int _PXASE2:1;
		unsigned int _PXASE3:1;
		unsigned int _PXASE4:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL0 (*((volatile union ECCP5_PXASCTL0_REG *)0x40003528))
// model

/** 0x4000 352C ECCP5_PXASCTL1 **/
union ECCP5_PXASCTL1_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL1_BITS{
		unsigned int _PXSS1L:2;
		unsigned int _PXSS1H:2;
		unsigned int _PXSS2L:2;
		unsigned int _PXSS2H:2;
		unsigned int _PXSS3L:2;
		unsigned int _PXSS3H:2;
		unsigned int _PXSS4L:2;
		unsigned int _PXSS4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL1 (*((volatile union ECCP5_PXASCTL1_REG *)0x4000352C))
// model

/** 0x4000 353C ECCP5_IE **/
union ECCP5_IE_REG{
	unsigned int reg;
	struct ECCP5_IE_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TZIE:1;
		unsigned int _TXIE:1;
		unsigned int _TZUIE:1;
		unsigned int _TXUIE:1;
		unsigned int _CPIE:1;
		unsigned int _PDIE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_IE (*((volatile union ECCP5_IE_REG *)0x4000353C))
// model

/** 0x4000 3540 ECCP5_EGIF **/
union ECCP5_EGIF_REG{
	unsigned int reg;
	struct ECCP5_EGIF_BITS{
		unsigned int _CPIF:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TZIF:1;
		unsigned int _TXIF:1;
		unsigned int _TZUIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PDIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_EGIF (*((volatile union ECCP5_EGIF_REG *)0x40003540))
// modelT5

/** 0x4000 3544 T5_UDTIMX **/
union T5_UDTIMX_REG{
	unsigned int reg;
	struct T5_UDTIMX_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_UDTIMX (*((volatile union T5_UDTIMX_REG *)0x40003544))
// modelT6

/** 0x4000 3548 T6_UDTIMZ **/
union T6_UDTIMZ_REG{
	unsigned int reg;
	struct T6_UDTIMZ_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_UDTIMZ (*((volatile union T6_UDTIMZ_REG *)0x40003548))
// modelECCP5

/** 0x4000 354C ECCP5_DF **/
union ECCP5_DF_REG{
	unsigned int reg;
	struct ECCP5_DF_BITS{
		unsigned int _CH1DF:1;
		unsigned int _CH2DF:1;
		unsigned int _CH3DF:1;
		unsigned int _CH4DF:1;
		unsigned int _CLSDF:1;
		unsigned int _TRIGDF:1;
		unsigned int _TZUDF:1;
		unsigned int _TXUDF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DF (*((volatile union ECCP5_DF_REG *)0x4000354C))
// model

/** 0x4000 3550 ECCP5_C1 **/
union ECCP5_C1_REG{
	unsigned int reg;
	struct ECCP5_C1_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C1 (*((volatile union ECCP5_C1_REG *)0x40003550))
// model

/** 0x4000 3554 ECCP5_C2 **/
union ECCP5_C2_REG{
	unsigned int reg;
	struct ECCP5_C2_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C2 (*((volatile union ECCP5_C2_REG *)0x40003554))
// model

/** 0x4000 3558 ECCP5_C3 **/
union ECCP5_C3_REG{
	unsigned int reg;
	struct ECCP5_C3_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C3 (*((volatile union ECCP5_C3_REG *)0x40003558))
// model

/** 0x4000 355C ECCP5_C4 **/
union ECCP5_C4_REG{
	unsigned int reg;
	struct ECCP5_C4_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C4 (*((volatile union ECCP5_C4_REG *)0x4000355C))
// model

/** 0x4000 3564 ECCP5_DE **/
union ECCP5_DE_REG{
	unsigned int reg;
	struct ECCP5_DE_BITS{
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CLSDE:1;
		unsigned int _TXTDE:1;
		unsigned int _TZUDE:1;
		unsigned int _TXUDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DE (*((volatile union ECCP5_DE_REG *)0x40003564))
// model

/** 0x4000 3568 ECCP5_SRIC **/
union ECCP5_SRIC_REG{
	unsigned int reg;
	struct ECCP5_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TZIC:1;
		unsigned int _TXIC:1;
		unsigned int _TZUIC:1;
		unsigned int _TXUIC:1;
		unsigned int _CPIC:1;
		unsigned int _PDIC:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_SRIC (*((volatile union ECCP5_SRIC_REG *)0x40003568))
// model

/** 0x4000 356C ECCP5_CTL3 **/
union ECCP5_CTL3_REG{
	unsigned int reg;
	struct ECCP5_CTL3_BITS{
		unsigned int _PXSPMST:1;
		unsigned int _TUNITE:1;
		unsigned int _PXRSEN:1;
		unsigned int _COMBEN:1;
		unsigned int _COMINV:2;
		unsigned int _CAPTST:1;
		unsigned int _GTBEN:1;
		unsigned int _GTBEOUT:1;
		unsigned int _CH0HM:1;
		unsigned int _CH1HM:1;
		unsigned int _CH2HM:1;
		unsigned int _CH3HM:1;
		unsigned int _TRGSEL:2;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL3 (*((volatile union ECCP5_CTL3_REG *)0x4000356C))
// model

/** 0x4000 3580 ECCP5_CAPPRSC **/
union ECCP5_CAPPRSC_REG{
	unsigned int reg;
	struct ECCP5_CAPPRSC_BITS{
		unsigned int _CH1CAPPR:4;
		unsigned int _CH2CAPPR:4;
		unsigned int _CH3CAPPR:4;
		unsigned int _CH4CAPPR:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CAPPRSC (*((volatile union ECCP5_CAPPRSC_REG *)0x40003580))
// model

/** 0x4000 3584 ECCP5_CAPTIME **/
union ECCP5_CAPTIME_REG{
	unsigned int reg;
	struct ECCP5_CAPTIME_BITS{
		unsigned int _CH1CAPTIME:4;
		unsigned int _CH2CAPTIME:4;
		unsigned int _CH3CAPTIME:4;
		unsigned int _CH4CAPTIME:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CAPTIME (*((volatile union ECCP5_CAPTIME_REG *)0x40003584))
// model

/** 0x4000 3588 ECCP5_CAPCTL1 **/
union ECCP5_CAPCTL1_REG{
	unsigned int reg;
	struct ECCP5_CAPCTL1_BITS{
		unsigned int _CH1CAPEN:1;
		unsigned int _CH2CAPEN:1;
		unsigned int _CH3CAPEN:1;
		unsigned int _CH4CAPEN:1;
		unsigned int _CH1CAPED:1;
		unsigned int _CH2CAPED:1;
		unsigned int _CH3CAPED:1;
		unsigned int _CH4CAPED:1;
		unsigned int _CH1CMODE:1;
		unsigned int _CH2CMODE:1;
		unsigned int _CH3CMODE:1;
		unsigned int _CH4CMODE:1;
		unsigned int _CH1TIEN:1;
		unsigned int _CH2TIEN:1;
		unsigned int _CH3TIEN:1;
		unsigned int _CH4TIEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CAPCTL1 (*((volatile union ECCP5_CAPCTL1_REG *)0x40003588))
// model

/** 0x4000 358C ECCP5_CAPCTL2 **/
union ECCP5_CAPCTL2_REG{
	unsigned int reg;
	struct ECCP5_CAPCTL2_BITS{
		unsigned int _CH1CAPPIN:3;
		unsigned int _CH2CAPPIN:3;
		unsigned int _CH3CAPPIN:3;
		unsigned int _CH4CAPPIN:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CAPCTL2 (*((volatile union ECCP5_CAPCTL2_REG *)0x4000358C))
// model

/** 0x4000 3590 ECCP5_FLCLKP **/
union ECCP5_FLCLKP_REG{
	unsigned int reg;
	struct ECCP5_FLCLKP_BITS{
		unsigned int _CH1FLCLKP:4;
		unsigned int _CH2FLCLKP:4;
		unsigned int _CH3FLCLKP:4;
		unsigned int _CH4FLCLKP:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FLCLKP (*((volatile union ECCP5_FLCLKP_REG *)0x40003590))
// model

/** 0x4000 3594 ECCP5_FILTER **/
union ECCP5_FILTER_REG{
	unsigned int reg;
	struct ECCP5_FILTER_BITS{
		unsigned int _CH1FILTER:3;
		unsigned int _CH2FILTER:3;
		unsigned int _CH3FILTER:3;
		unsigned int _CH4FILTER:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FILTER (*((volatile union ECCP5_FILTER_REG *)0x40003594))
// model

/** 0x4000 3598 ECCP5_PHSCTLX **/
union ECCP5_PHSCTLX_REG{
	unsigned int reg;
	struct ECCP5_PHSCTLX_BITS{
		unsigned int _PHSENX:1;
		unsigned int _PHSXMODE:1;
		unsigned int _PHSWTX:1;
		unsigned int _PHSXSEL:3;
		unsigned int _PHSXPRSC:4;
		unsigned int _PHSXTIME:4;
		unsigned int _PHSXTIEN:1;
		unsigned int _PHSXDIR:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PHSCTLX (*((volatile union ECCP5_PHSCTLX_REG *)0x40003598))
// model

/** 0x4000 359C ECCP5_PHSCTLZ **/
union ECCP5_PHSCTLZ_REG{
	unsigned int reg;
	struct ECCP5_PHSCTLZ_BITS{
		unsigned int _PHSENZ:1;
		unsigned int _PHSZMODE:1;
		unsigned int _PHSWTZ:1;
		unsigned int _PHSZSEL:3;
		unsigned int _PHSZPRSC:4;
		unsigned int _PHSZTIME:4;
		unsigned int _PHSZTIEN:1;
		unsigned int _PHSZDIR:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PHSCTLZ (*((volatile union ECCP5_PHSCTLZ_REG *)0x4000359C))
// modelT5

/** 0x4000 35A0 T5_PHS **/
union T5_PHS_REG{
	unsigned int reg;
	struct T5_PHS_BITS{
		unsigned int _PHSX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PHS (*((volatile union T5_PHS_REG *)0x400035A0))
// modelT6

/** 0x4000 35A4 T6_PHS **/
union T6_PHS_REG{
	unsigned int reg;
	struct T6_PHS_BITS{
		unsigned int _PHSZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PHS (*((volatile union T6_PHS_REG *)0x400035A4))
// modelECCP5

/** 0x4000 35A8 ECCP5_CTL4 **/
union ECCP5_CTL4_REG{
	unsigned int reg;
	struct ECCP5_CTL4_BITS{
		unsigned int _UDREN:1;
		unsigned int _TRGUDEN0:1;
		unsigned int _TRGUDEN1:1;
		unsigned int _TUDMODE0:1;
		unsigned int _TUDMODE1:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int _CAPFILTEN1:1;
		unsigned int _CAPFILTEN2:1;
		unsigned int _CAPFILTEN3:1;
		unsigned int _CAPFILTEN4:1;
		unsigned int _TRGPOLX:1;
		unsigned int _TRGPOLZ:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL4 (*((volatile union ECCP5_CTL4_REG *)0x400035A8))
// model

/** 0x4000 35AC ECCP5_PXDTCTL2 **/
union ECCP5_PXDTCTL2_REG{
	unsigned int reg;
	struct ECCP5_PXDTCTL2_BITS{
		unsigned int _CH1PXDC:8;
		unsigned int _CH2PXDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXDTCTL2 (*((volatile union ECCP5_PXDTCTL2_REG *)0x400035AC))
// model

/** 0x4000 35B0 ECCP5_PXDTCFG **/
union ECCP5_PXDTCFG_REG{
	unsigned int reg;
	struct ECCP5_PXDTCFG_BITS{
		unsigned int _CH1DTCLK:4;
		unsigned int _CH2DTCLK:4;
		unsigned int _CH3DTCLK:4;
		unsigned int _CH4DTCLK:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXDTCFG (*((volatile union ECCP5_PXDTCFG_REG *)0x400035B0))
// modelECCP9

/** 0x4000 362C ECCP9_PDCTL **/
union ECCP9_PDCTL_REG{
	unsigned int reg;
	struct ECCP9_PDCTL_BITS{
		unsigned int _CPE:2;
		unsigned int _CMPE:1;
		unsigned int _TI0EN:1;
		unsigned int _TI1EN:1;
		unsigned int _TI2EN:1;
		unsigned int :1;
		unsigned int _SMPEN:1;
		unsigned int _RDA:3;
		unsigned int :1;
		unsigned int _CPD:3;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PDCTL (*((volatile union ECCP9_PDCTL_REG *)0x4000362C))
// model

/** 0x4000 3630 ECCP9_PXASCTL **/
union ECCP9_PXASCTL_REG{
	unsigned int reg;
	struct ECCP9_PXASCTL_BITS{
		unsigned int _TXPXASS:2;
		unsigned int _TZPXASS:2;
		unsigned int _TXBKINS:1;
		unsigned int _TZBKINS:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXASCTL (*((volatile union ECCP9_PXASCTL_REG *)0x40003630))
// model

/** 0x4000 3640 ECCP9_COMH1 **/
union ECCP9_COMH1_REG{
	unsigned int reg;
	struct ECCP9_COMH1_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COMH1 (*((volatile union ECCP9_COMH1_REG *)0x40003640))
// model

/** 0x4000 3644 ECCP9_COML1 **/
union ECCP9_COML1_REG{
	unsigned int reg;
	struct ECCP9_COML1_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COML1 (*((volatile union ECCP9_COML1_REG *)0x40003644))
// model

/** 0x4000 3648 ECCP9_FAUCTL1 **/
union ECCP9_FAUCTL1_REG{
	unsigned int reg;
	struct ECCP9_FAUCTL1_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_FAUCTL1 (*((volatile union ECCP9_FAUCTL1_REG *)0x40003648))
// model

/** 0x4000 364C ECCP9_DITCTL **/
union ECCP9_DITCTL_REG{
	unsigned int reg;
	struct ECCP9_DITCTL_BITS{
		unsigned int _FRCVAL:5;
		unsigned int _DEDEN:1;
		unsigned int _DPEEN:1;
		unsigned int _DCOMEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_DITCTL (*((volatile union ECCP9_DITCTL_REG *)0x4000364C))
// model

/** 0x4000 3650 ECCP9_COMH2 **/
union ECCP9_COMH2_REG{
	unsigned int reg;
	struct ECCP9_COMH2_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COMH2 (*((volatile union ECCP9_COMH2_REG *)0x40003650))
// model

/** 0x4000 3654 ECCP9_COML2 **/
union ECCP9_COML2_REG{
	unsigned int reg;
	struct ECCP9_COML2_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COML2 (*((volatile union ECCP9_COML2_REG *)0x40003654))
// model

/** 0x4000 3658 ECCP9_FAUCTL2 **/
union ECCP9_FAUCTL2_REG{
	unsigned int reg;
	struct ECCP9_FAUCTL2_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_FAUCTL2 (*((volatile union ECCP9_FAUCTL2_REG *)0x40003658))
// model

/** 0x4000 365C ECCP9_CCRCTL **/
union ECCP9_CCRCTL_REG{
	unsigned int reg;
	struct ECCP9_CCRCTL_BITS{
		unsigned int _TXCCR0SEN:1;
		unsigned int _TXCCR1SEN:1;
		unsigned int _TZCCR0SEN:1;
		unsigned int _TXCCR0SEL:1;
		unsigned int _TXCCR1SEL:1;
		unsigned int _TZCCR0SEL:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CCRCTL (*((volatile union ECCP9_CCRCTL_REG *)0x4000365C))
// model

/** 0x4000 3660 ECCP9_COMH3 **/
union ECCP9_COMH3_REG{
	unsigned int reg;
	struct ECCP9_COMH3_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COMH3 (*((volatile union ECCP9_COMH3_REG *)0x40003660))
// model

/** 0x4000 3664 ECCP9_COML3 **/
union ECCP9_COML3_REG{
	unsigned int reg;
	struct ECCP9_COML3_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COML3 (*((volatile union ECCP9_COML3_REG *)0x40003664))
// model

/** 0x4000 3668 ECCP9_FAUCTL3 **/
union ECCP9_FAUCTL3_REG{
	unsigned int reg;
	struct ECCP9_FAUCTL3_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_FAUCTL3 (*((volatile union ECCP9_FAUCTL3_REG *)0x40003668))
// model

/** 0x4000 3670 ECCP9_COMH4 **/
union ECCP9_COMH4_REG{
	unsigned int reg;
	struct ECCP9_COMH4_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COMH4 (*((volatile union ECCP9_COMH4_REG *)0x40003670))
// model

/** 0x4000 3674 ECCP9_COML4 **/
union ECCP9_COML4_REG{
	unsigned int reg;
	struct ECCP9_COML4_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_COML4 (*((volatile union ECCP9_COML4_REG *)0x40003674))
// model

/** 0x4000 3678 ECCP9_FAUCTL4 **/
union ECCP9_FAUCTL4_REG{
	unsigned int reg;
	struct ECCP9_FAUCTL4_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_FAUCTL4 (*((volatile union ECCP9_FAUCTL4_REG *)0x40003678))
// model

/** 0x4000 3680 ECCP9_CTL1 **/
union ECCP9_CTL1_REG{
	unsigned int reg;
	struct ECCP9_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL1 (*((volatile union ECCP9_CTL1_REG *)0x40003680))
// model

/** 0x4000 3684 ECCP9_R1 **/
union ECCP9_R1_REG{
	unsigned int reg;
	struct ECCP9_R1_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R1 (*((volatile union ECCP9_R1_REG *)0x40003684))
// model

/** 0x4000 3688 ECCP9_R2 **/
union ECCP9_R2_REG{
	unsigned int reg;
	struct ECCP9_R2_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R2 (*((volatile union ECCP9_R2_REG *)0x40003688))
// model

/** 0x4000 368C ECCP9_R3 **/
union ECCP9_R3_REG{
	unsigned int reg;
	struct ECCP9_R3_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R3 (*((volatile union ECCP9_R3_REG *)0x4000368C))
// model

/** 0x4000 3690 ECCP9_R4 **/
union ECCP9_R4_REG{
	unsigned int reg;
	struct ECCP9_R4_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_R4 (*((volatile union ECCP9_R4_REG *)0x40003690))
// model

/** 0x4000 3694 ECCP9_PXUDCTL **/
union ECCP9_PXUDCTL_REG{
	unsigned int reg;
	struct ECCP9_PXUDCTL_BITS{
		unsigned int _PXUDEN0:1;
		unsigned int _PXUDEN1:1;
		unsigned int _PXUDEVT0:1;
		unsigned int _PXUDEVT1:1;
		unsigned int _PXUDEVT2:1;
		unsigned int _PXUDEVT3:1;
		unsigned int _PXMPEN:1;
		unsigned int _TXUDR:1;
		unsigned int _TXIFUDREN:1;
		unsigned int _TZUDR:1;
		unsigned int _TZIFUDREN:1;
		unsigned int _DBUDEN:1;
		unsigned int _READTEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXUDCTL (*((volatile union ECCP9_PXUDCTL_REG *)0x40003694))
// model

/** 0x4000 3698 ECCP9_CTL2 **/
union ECCP9_CTL2_REG{
	unsigned int reg;
	struct ECCP9_CTL2_BITS{
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:3;
		unsigned int _TXMSSYYNC:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _TZSMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL2 (*((volatile union ECCP9_CTL2_REG *)0x40003698))
// model

/** 0x4000 369C ECCP9_PXDTCTL **/
union ECCP9_PXDTCTL_REG{
	unsigned int reg;
	struct ECCP9_PXDTCTL_BITS{
		unsigned int _PXDC:8;
		unsigned int _PZDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXDTCTL (*((volatile union ECCP9_PXDTCTL_REG *)0x4000369C))
// model

/** 0x4000 36A0 ECCP9_PWMXOC **/
union ECCP9_PWMXOC_REG{
	unsigned int reg;
	struct ECCP9_PWMXOC_BITS{
		unsigned int _PXOC1L:2;
		unsigned int _PXOC1H:2;
		unsigned int _PXOC2L:2;
		unsigned int _PXOC2H:2;
		unsigned int _PXOC3L:2;
		unsigned int _PXOC3H:2;
		unsigned int _PXOC4L:2;
		unsigned int _PXOC4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PWMXOC (*((volatile union ECCP9_PWMXOC_REG *)0x400036A0))
// model

/** 0x4000 36A4 ECCP9_PXATRCTL **/
union ECCP9_PXATRCTL_REG{
	unsigned int reg;
	struct ECCP9_PXATRCTL_BITS{
		unsigned int :8;
		unsigned int _PXCH1MOD:1;
		unsigned int _PXCH2MOD:1;
		unsigned int _PXCH3MOD:1;
		unsigned int _PXCH4MOD:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXATRCTL (*((volatile union ECCP9_PXATRCTL_REG *)0x400036A4))
// model

/** 0x4000 36A8 ECCP9_PXASCTL0 **/
union ECCP9_PXASCTL0_REG{
	unsigned int reg;
	struct ECCP9_PXASCTL0_BITS{
		unsigned int _PXASS1:2;
		unsigned int _PXASS2:2;
		unsigned int _PXASS3:2;
		unsigned int _PXASS4:2;
		unsigned int _PXASE1:1;
		unsigned int _PXASE2:1;
		unsigned int _PXASE3:1;
		unsigned int _PXASE4:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXASCTL0 (*((volatile union ECCP9_PXASCTL0_REG *)0x400036A8))
// model

/** 0x4000 36AC ECCP9_PXASCTL1 **/
union ECCP9_PXASCTL1_REG{
	unsigned int reg;
	struct ECCP9_PXASCTL1_BITS{
		unsigned int _PXSS1L:2;
		unsigned int _PXSS1H:2;
		unsigned int _PXSS2L:2;
		unsigned int _PXSS2H:2;
		unsigned int _PXSS3L:2;
		unsigned int _PXSS3H:2;
		unsigned int _PXSS4L:2;
		unsigned int _PXSS4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXASCTL1 (*((volatile union ECCP9_PXASCTL1_REG *)0x400036AC))
// model

/** 0x4000 36BC ECCP9_IE **/
union ECCP9_IE_REG{
	unsigned int reg;
	struct ECCP9_IE_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TZIE:1;
		unsigned int _TXIE:1;
		unsigned int _TZUIE:1;
		unsigned int _TXUIE:1;
		unsigned int _CPIE:1;
		unsigned int _PDIE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_IE (*((volatile union ECCP9_IE_REG *)0x400036BC))
// model

/** 0x4000 36C0 ECCP9_EGIF **/
union ECCP9_EGIF_REG{
	unsigned int reg;
	struct ECCP9_EGIF_BITS{
		unsigned int _CPIF:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TZIF:1;
		unsigned int _TXIF:1;
		unsigned int _TZUIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PDIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_EGIF (*((volatile union ECCP9_EGIF_REG *)0x400036C0))
// modelT9

/** 0x4000 36C4 T9_UDTIMX **/
union T9_UDTIMX_REG{
	unsigned int reg;
	struct T9_UDTIMX_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_UDTIMX (*((volatile union T9_UDTIMX_REG *)0x400036C4))
// modelT10

/** 0x4000 36C8 T10_UDTIMZ **/
union T10_UDTIMZ_REG{
	unsigned int reg;
	struct T10_UDTIMZ_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_UDTIMZ (*((volatile union T10_UDTIMZ_REG *)0x400036C8))
// modelECCP9

/** 0x4000 36CC ECCP9_DF **/
union ECCP9_DF_REG{
	unsigned int reg;
	struct ECCP9_DF_BITS{
		unsigned int _CH1DF:1;
		unsigned int _CH2DF:1;
		unsigned int _CH3DF:1;
		unsigned int _CH4DF:1;
		unsigned int _CLSDF:1;
		unsigned int _TRIGDF:1;
		unsigned int _TZUDF:1;
		unsigned int _TXUDF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_DF (*((volatile union ECCP9_DF_REG *)0x400036CC))
// model

/** 0x4000 36D0 ECCP9_C1 **/
union ECCP9_C1_REG{
	unsigned int reg;
	struct ECCP9_C1_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C1 (*((volatile union ECCP9_C1_REG *)0x400036D0))
// model

/** 0x4000 36D4 ECCP9_C2 **/
union ECCP9_C2_REG{
	unsigned int reg;
	struct ECCP9_C2_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C2 (*((volatile union ECCP9_C2_REG *)0x400036D4))
// model

/** 0x4000 36D8 ECCP9_C3 **/
union ECCP9_C3_REG{
	unsigned int reg;
	struct ECCP9_C3_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C3 (*((volatile union ECCP9_C3_REG *)0x400036D8))
// model

/** 0x4000 36DC ECCP9_C4 **/
union ECCP9_C4_REG{
	unsigned int reg;
	struct ECCP9_C4_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_C4 (*((volatile union ECCP9_C4_REG *)0x400036DC))
// model

/** 0x4000 36E4 ECCP9_DE **/
union ECCP9_DE_REG{
	unsigned int reg;
	struct ECCP9_DE_BITS{
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CLSDE:1;
		unsigned int _TXTDE:1;
		unsigned int _TZUDE:1;
		unsigned int _TXUDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_DE (*((volatile union ECCP9_DE_REG *)0x400036E4))
// model

/** 0x4000 36E8 ECCP9_SRIC **/
union ECCP9_SRIC_REG{
	unsigned int reg;
	struct ECCP9_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TZIC:1;
		unsigned int _TXIC:1;
		unsigned int _TZUIC:1;
		unsigned int _TXUIC:1;
		unsigned int _CPIC:1;
		unsigned int _PDIC:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_SRIC (*((volatile union ECCP9_SRIC_REG *)0x400036E8))
// model

/** 0x4000 36EC ECCP9_CTL3 **/
union ECCP9_CTL3_REG{
	unsigned int reg;
	struct ECCP9_CTL3_BITS{
		unsigned int _PXSPMST:1;
		unsigned int _TUNITE:1;
		unsigned int _PXRSEN:1;
		unsigned int _COMBEN:1;
		unsigned int _COMINV:2;
		unsigned int _CAPTST:1;
		unsigned int _GTBEN:1;
		unsigned int _GTBEOUT:1;
		unsigned int _CH0HM:1;
		unsigned int _CH1HM:1;
		unsigned int _CH2HM:1;
		unsigned int _CH3HM:1;
		unsigned int _TRGSEL:2;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL3 (*((volatile union ECCP9_CTL3_REG *)0x400036EC))
// model

/** 0x4000 3700 ECCP9_CAPPRSC **/
union ECCP9_CAPPRSC_REG{
	unsigned int reg;
	struct ECCP9_CAPPRSC_BITS{
		unsigned int _CH1CAPPR:4;
		unsigned int _CH2CAPPR:4;
		unsigned int _CH3CAPPR:4;
		unsigned int _CH4CAPPR:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CAPPRSC (*((volatile union ECCP9_CAPPRSC_REG *)0x40003700))
// model

/** 0x4000 3704 ECCP9_CAPTIME **/
union ECCP9_CAPTIME_REG{
	unsigned int reg;
	struct ECCP9_CAPTIME_BITS{
		unsigned int _CH1CAPTIME:4;
		unsigned int _CH2CAPTIME:4;
		unsigned int _CH3CAPTIME:4;
		unsigned int _CH4CAPTIME:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CAPTIME (*((volatile union ECCP9_CAPTIME_REG *)0x40003704))
// model

/** 0x4000 3708 ECCP9_CAPCTL1 **/
union ECCP9_CAPCTL1_REG{
	unsigned int reg;
	struct ECCP9_CAPCTL1_BITS{
		unsigned int _CH1CAPEN:1;
		unsigned int _CH2CAPEN:1;
		unsigned int _CH3CAPEN:1;
		unsigned int _CH4CAPEN:1;
		unsigned int _CH1CAPED:1;
		unsigned int _CH2CAPED:1;
		unsigned int _CH3CAPED:1;
		unsigned int _CH4CAPED:1;
		unsigned int _CH1CMODE:1;
		unsigned int _CH2CMODE:1;
		unsigned int _CH3CMODE:1;
		unsigned int _CH4CMODE:1;
		unsigned int _CH1TIEN:1;
		unsigned int _CH2TIEN:1;
		unsigned int _CH3TIEN:1;
		unsigned int _CH4TIEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CAPCTL1 (*((volatile union ECCP9_CAPCTL1_REG *)0x40003708))
// model

/** 0x4000 370C ECCP9_CAPCTL2 **/
union ECCP9_CAPCTL2_REG{
	unsigned int reg;
	struct ECCP9_CAPCTL2_BITS{
		unsigned int _CH1CAPPIN:3;
		unsigned int _CH2CAPPIN:3;
		unsigned int _CH3CAPPIN:3;
		unsigned int _CH4CAPPIN:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CAPCTL2 (*((volatile union ECCP9_CAPCTL2_REG *)0x4000370C))
// model

/** 0x4000 3710 ECCP9_FLCLKP **/
union ECCP9_FLCLKP_REG{
	unsigned int reg;
	struct ECCP9_FLCLKP_BITS{
		unsigned int _CH1FLCLKP:4;
		unsigned int _CH2FLCLKP:4;
		unsigned int _CH3FLCLKP:4;
		unsigned int _CH4FLCLKP:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_FLCLKP (*((volatile union ECCP9_FLCLKP_REG *)0x40003710))
// model

/** 0x4000 3714 ECCP9_FILTER **/
union ECCP9_FILTER_REG{
	unsigned int reg;
	struct ECCP9_FILTER_BITS{
		unsigned int _CH1FILTER:3;
		unsigned int _CH2FILTER:3;
		unsigned int _CH3FILTER:3;
		unsigned int _CH4FILTER:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_FILTER (*((volatile union ECCP9_FILTER_REG *)0x40003714))
// model

/** 0x4000 3718 ECCP9_PHSCTLX **/
union ECCP9_PHSCTLX_REG{
	unsigned int reg;
	struct ECCP9_PHSCTLX_BITS{
		unsigned int _PHSENX:1;
		unsigned int _PHSXMODE:1;
		unsigned int _PHSWTX:1;
		unsigned int _PHSXSEL:3;
		unsigned int _PHSXPRSC:4;
		unsigned int _PHSXTIME:4;
		unsigned int _PHSXTIEN:1;
		unsigned int _PHSXDIR:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PHSCTLX (*((volatile union ECCP9_PHSCTLX_REG *)0x40003718))
// model

/** 0x4000 371C ECCP9_PHSCTLZ **/
union ECCP9_PHSCTLZ_REG{
	unsigned int reg;
	struct ECCP9_PHSCTLZ_BITS{
		unsigned int _PHSENZ:1;
		unsigned int _PHSZMODE:1;
		unsigned int _PHSWTZ:1;
		unsigned int _PHSZSEL:3;
		unsigned int _PHSZPRSC:4;
		unsigned int _PHSZTIME:4;
		unsigned int _PHSZTIEN:1;
		unsigned int _PHSZDIR:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PHSCTLZ (*((volatile union ECCP9_PHSCTLZ_REG *)0x4000371C))
// modelT9

/** 0x4000 3720 T9_PHS **/
union T9_PHS_REG{
	unsigned int reg;
	struct T9_PHS_BITS{
		unsigned int _PHSX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T9_PHS (*((volatile union T9_PHS_REG *)0x40003720))
// modelT10

/** 0x4000 3724 T10_PHS **/
union T10_PHS_REG{
	unsigned int reg;
	struct T10_PHS_BITS{
		unsigned int _PHSZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T10_PHS (*((volatile union T10_PHS_REG *)0x40003724))
// modelECCP9

/** 0x4000 3728 ECCP9_CTL4 **/
union ECCP9_CTL4_REG{
	unsigned int reg;
	struct ECCP9_CTL4_BITS{
		unsigned int _UDREN:1;
		unsigned int _TRGUDEN0:1;
		unsigned int _TRGUDEN1:1;
		unsigned int _TUDMODE0:1;
		unsigned int _TUDMODE1:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int _CAPFILTEN1:1;
		unsigned int _CAPFILTEN2:1;
		unsigned int _CAPFILTEN3:1;
		unsigned int _CAPFILTEN4:1;
		unsigned int _TRGPOLX:1;
		unsigned int _TRGPOLZ:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_CTL4 (*((volatile union ECCP9_CTL4_REG *)0x40003728))
// model

/** 0x4000 372C ECCP9_PXDTCTL2 **/
union ECCP9_PXDTCTL2_REG{
	unsigned int reg;
	struct ECCP9_PXDTCTL2_BITS{
		unsigned int _CH1PXDC:8;
		unsigned int _CH2PXDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXDTCTL2 (*((volatile union ECCP9_PXDTCTL2_REG *)0x4000372C))
// model

/** 0x4000 3730 ECCP9_PXDTCFG **/
union ECCP9_PXDTCFG_REG{
	unsigned int reg;
	struct ECCP9_PXDTCFG_BITS{
		unsigned int _CH1DTCLK:4;
		unsigned int _CH2DTCLK:4;
		unsigned int _CH3DTCLK:4;
		unsigned int _CH4DTCLK:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP9_PXDTCFG (*((volatile union ECCP9_PXDTCFG_REG *)0x40003730))
// modelECCP25

/** 0x4000 37AC ECCP25_PDCTL **/
union ECCP25_PDCTL_REG{
	unsigned int reg;
	struct ECCP25_PDCTL_BITS{
		unsigned int _CPE:2;
		unsigned int _CMPE:1;
		unsigned int _TI0EN:1;
		unsigned int _TI1EN:1;
		unsigned int _TI2EN:1;
		unsigned int :1;
		unsigned int _SMPEN:1;
		unsigned int _RDA:3;
		unsigned int :1;
		unsigned int _CPD:3;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PDCTL (*((volatile union ECCP25_PDCTL_REG *)0x400037AC))
// model

/** 0x4000 37B0 ECCP25_PXASCTL **/
union ECCP25_PXASCTL_REG{
	unsigned int reg;
	struct ECCP25_PXASCTL_BITS{
		unsigned int _TXPXASS:2;
		unsigned int _TZPXASS:2;
		unsigned int _TXBKINS:1;
		unsigned int _TZBKINS:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXASCTL (*((volatile union ECCP25_PXASCTL_REG *)0x400037B0))
// model

/** 0x4000 37C0 ECCP25_COMH1 **/
union ECCP25_COMH1_REG{
	unsigned int reg;
	struct ECCP25_COMH1_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COMH1 (*((volatile union ECCP25_COMH1_REG *)0x400037C0))
// model

/** 0x4000 37C4 ECCP25_COML1 **/
union ECCP25_COML1_REG{
	unsigned int reg;
	struct ECCP25_COML1_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COML1 (*((volatile union ECCP25_COML1_REG *)0x400037C4))
// model

/** 0x4000 37C8 ECCP25_FAUCTL1 **/
union ECCP25_FAUCTL1_REG{
	unsigned int reg;
	struct ECCP25_FAUCTL1_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_FAUCTL1 (*((volatile union ECCP25_FAUCTL1_REG *)0x400037C8))
// model

/** 0x4000 37CC ECCP25_DITCTL **/
union ECCP25_DITCTL_REG{
	unsigned int reg;
	struct ECCP25_DITCTL_BITS{
		unsigned int _FRCVAL:5;
		unsigned int _DEDEN:1;
		unsigned int _DPEEN:1;
		unsigned int _DCOMEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_DITCTL (*((volatile union ECCP25_DITCTL_REG *)0x400037CC))
// model

/** 0x4000 37D0 ECCP25_COMH2 **/
union ECCP25_COMH2_REG{
	unsigned int reg;
	struct ECCP25_COMH2_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COMH2 (*((volatile union ECCP25_COMH2_REG *)0x400037D0))
// model

/** 0x4000 37D4 ECCP25_COML2 **/
union ECCP25_COML2_REG{
	unsigned int reg;
	struct ECCP25_COML2_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COML2 (*((volatile union ECCP25_COML2_REG *)0x400037D4))
// model

/** 0x4000 37D8 ECCP25_FAUCTL2 **/
union ECCP25_FAUCTL2_REG{
	unsigned int reg;
	struct ECCP25_FAUCTL2_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_FAUCTL2 (*((volatile union ECCP25_FAUCTL2_REG *)0x400037D8))
// model

/** 0x4000 37DC ECCP25_CCRCTL **/
union ECCP25_CCRCTL_REG{
	unsigned int reg;
	struct ECCP25_CCRCTL_BITS{
		unsigned int _TXCCR0SEN:1;
		unsigned int _TXCCR1SEN:1;
		unsigned int _TZCCR0SEN:1;
		unsigned int _TXCCR0SEL:1;
		unsigned int _TXCCR1SEL:1;
		unsigned int _TZCCR0SEL:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CCRCTL (*((volatile union ECCP25_CCRCTL_REG *)0x400037DC))
// model

/** 0x4000 37E0 ECCP25_COMH3 **/
union ECCP25_COMH3_REG{
	unsigned int reg;
	struct ECCP25_COMH3_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COMH3 (*((volatile union ECCP25_COMH3_REG *)0x400037E0))
// model

/** 0x4000 37E4 ECCP25_COML3 **/
union ECCP25_COML3_REG{
	unsigned int reg;
	struct ECCP25_COML3_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COML3 (*((volatile union ECCP25_COML3_REG *)0x400037E4))
// model

/** 0x4000 37E8 ECCP25_FAUCTL3 **/
union ECCP25_FAUCTL3_REG{
	unsigned int reg;
	struct ECCP25_FAUCTL3_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_FAUCTL3 (*((volatile union ECCP25_FAUCTL3_REG *)0x400037E8))
// model

/** 0x4000 37F0 ECCP25_COMH4 **/
union ECCP25_COMH4_REG{
	unsigned int reg;
	struct ECCP25_COMH4_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COMH4 (*((volatile union ECCP25_COMH4_REG *)0x400037F0))
// model

/** 0x4000 37F4 ECCP25_COML4 **/
union ECCP25_COML4_REG{
	unsigned int reg;
	struct ECCP25_COML4_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_COML4 (*((volatile union ECCP25_COML4_REG *)0x400037F4))
// model

/** 0x4000 37F8 ECCP25_FAUCTL4 **/
union ECCP25_FAUCTL4_REG{
	unsigned int reg;
	struct ECCP25_FAUCTL4_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_FAUCTL4 (*((volatile union ECCP25_FAUCTL4_REG *)0x400037F8))
// model

/** 0x4000 3800 ECCP25_CTL1 **/
union ECCP25_CTL1_REG{
	unsigned int reg;
	struct ECCP25_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CTL1 (*((volatile union ECCP25_CTL1_REG *)0x40003800))
// model

/** 0x4000 3804 ECCP25_R1 **/
union ECCP25_R1_REG{
	unsigned int reg;
	struct ECCP25_R1_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_R1 (*((volatile union ECCP25_R1_REG *)0x40003804))
// model

/** 0x4000 3808 ECCP25_R2 **/
union ECCP25_R2_REG{
	unsigned int reg;
	struct ECCP25_R2_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_R2 (*((volatile union ECCP25_R2_REG *)0x40003808))
// model

/** 0x4000 380C ECCP25_R3 **/
union ECCP25_R3_REG{
	unsigned int reg;
	struct ECCP25_R3_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_R3 (*((volatile union ECCP25_R3_REG *)0x4000380C))
// model

/** 0x4000 3810 ECCP25_R4 **/
union ECCP25_R4_REG{
	unsigned int reg;
	struct ECCP25_R4_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_R4 (*((volatile union ECCP25_R4_REG *)0x40003810))
// model

/** 0x4000 3814 ECCP25_PXUDCTL **/
union ECCP25_PXUDCTL_REG{
	unsigned int reg;
	struct ECCP25_PXUDCTL_BITS{
		unsigned int _PXUDEN0:1;
		unsigned int _PXUDEN1:1;
		unsigned int _PXUDEVT0:1;
		unsigned int _PXUDEVT1:1;
		unsigned int _PXUDEVT2:1;
		unsigned int _PXUDEVT3:1;
		unsigned int _PXMPEN:1;
		unsigned int _TXUDR:1;
		unsigned int _TXIFUDREN:1;
		unsigned int _TZUDR:1;
		unsigned int _TZIFUDREN:1;
		unsigned int _DBUDEN:1;
		unsigned int _READTEN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXUDCTL (*((volatile union ECCP25_PXUDCTL_REG *)0x40003814))
// model

/** 0x4000 3818 ECCP25_CTL2 **/
union ECCP25_CTL2_REG{
	unsigned int reg;
	struct ECCP25_CTL2_BITS{
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:3;
		unsigned int _TXMSSYYNC:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _TZSMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CTL2 (*((volatile union ECCP25_CTL2_REG *)0x40003818))
// model

/** 0x4000 381C ECCP25_PXDTCTL **/
union ECCP25_PXDTCTL_REG{
	unsigned int reg;
	struct ECCP25_PXDTCTL_BITS{
		unsigned int _PXDC:8;
		unsigned int _PZDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXDTCTL (*((volatile union ECCP25_PXDTCTL_REG *)0x4000381C))
// model

/** 0x4000 3820 ECCP25_PWMXOC **/
union ECCP25_PWMXOC_REG{
	unsigned int reg;
	struct ECCP25_PWMXOC_BITS{
		unsigned int _PXOC1L:2;
		unsigned int _PXOC1H:2;
		unsigned int _PXOC2L:2;
		unsigned int _PXOC2H:2;
		unsigned int _PXOC3L:2;
		unsigned int _PXOC3H:2;
		unsigned int _PXOC4L:2;
		unsigned int _PXOC4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PWMXOC (*((volatile union ECCP25_PWMXOC_REG *)0x40003820))
// model

/** 0x4000 3824 ECCP25_PXATRCTL **/
union ECCP25_PXATRCTL_REG{
	unsigned int reg;
	struct ECCP25_PXATRCTL_BITS{
		unsigned int :8;
		unsigned int _PXCH1MOD:1;
		unsigned int _PXCH2MOD:1;
		unsigned int _PXCH3MOD:1;
		unsigned int _PXCH4MOD:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXATRCTL (*((volatile union ECCP25_PXATRCTL_REG *)0x40003824))
// model

/** 0x4000 3828 ECCP25_PXASCTL0 **/
union ECCP25_PXASCTL0_REG{
	unsigned int reg;
	struct ECCP25_PXASCTL0_BITS{
		unsigned int _PXASS1:2;
		unsigned int _PXASS2:2;
		unsigned int _PXASS3:2;
		unsigned int _PXASS4:2;
		unsigned int _PXASE1:1;
		unsigned int _PXASE2:1;
		unsigned int _PXASE3:1;
		unsigned int _PXASE4:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXASCTL0 (*((volatile union ECCP25_PXASCTL0_REG *)0x40003828))
// model

/** 0x4000 382C ECCP25_PXASCTL1 **/
union ECCP25_PXASCTL1_REG{
	unsigned int reg;
	struct ECCP25_PXASCTL1_BITS{
		unsigned int _PXSS1L:2;
		unsigned int _PXSS1H:2;
		unsigned int _PXSS2L:2;
		unsigned int _PXSS2H:2;
		unsigned int _PXSS3L:2;
		unsigned int _PXSS3H:2;
		unsigned int _PXSS4L:2;
		unsigned int _PXSS4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXASCTL1 (*((volatile union ECCP25_PXASCTL1_REG *)0x4000382C))
// model

/** 0x4000 383C ECCP25_IE **/
union ECCP25_IE_REG{
	unsigned int reg;
	struct ECCP25_IE_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TZIE:1;
		unsigned int _TXIE:1;
		unsigned int _TZUIE:1;
		unsigned int _TXUIE:1;
		unsigned int _CPIE:1;
		unsigned int _PDIE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_IE (*((volatile union ECCP25_IE_REG *)0x4000383C))
// model

/** 0x4000 3840 ECCP25_EGIF **/
union ECCP25_EGIF_REG{
	unsigned int reg;
	struct ECCP25_EGIF_BITS{
		unsigned int _CPIF:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TZIF:1;
		unsigned int _TXIF:1;
		unsigned int _TZUIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PDIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_EGIF (*((volatile union ECCP25_EGIF_REG *)0x40003840))
// modelT25

/** 0x4000 3844 T25_UDTIMX **/
union T25_UDTIMX_REG{
	unsigned int reg;
	struct T25_UDTIMX_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_UDTIMX (*((volatile union T25_UDTIMX_REG *)0x40003844))
// modelT26

/** 0x4000 3848 T26_UDTIMZ **/
union T26_UDTIMZ_REG{
	unsigned int reg;
	struct T26_UDTIMZ_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_UDTIMZ (*((volatile union T26_UDTIMZ_REG *)0x40003848))
// modelECCP25

/** 0x4000 384C ECCP25_DF **/
union ECCP25_DF_REG{
	unsigned int reg;
	struct ECCP25_DF_BITS{
		unsigned int _CH1DF:1;
		unsigned int _CH2DF:1;
		unsigned int _CH3DF:1;
		unsigned int _CH4DF:1;
		unsigned int _CLSDF:1;
		unsigned int _TRIGDF:1;
		unsigned int _TZUDF:1;
		unsigned int _TXUDF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_DF (*((volatile union ECCP25_DF_REG *)0x4000384C))
// model

/** 0x4000 3850 ECCP25_C1 **/
union ECCP25_C1_REG{
	unsigned int reg;
	struct ECCP25_C1_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_C1 (*((volatile union ECCP25_C1_REG *)0x40003850))
// model

/** 0x4000 3854 ECCP25_C2 **/
union ECCP25_C2_REG{
	unsigned int reg;
	struct ECCP25_C2_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_C2 (*((volatile union ECCP25_C2_REG *)0x40003854))
// model

/** 0x4000 3858 ECCP25_C3 **/
union ECCP25_C3_REG{
	unsigned int reg;
	struct ECCP25_C3_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_C3 (*((volatile union ECCP25_C3_REG *)0x40003858))
// model

/** 0x4000 385C ECCP25_C4 **/
union ECCP25_C4_REG{
	unsigned int reg;
	struct ECCP25_C4_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_C4 (*((volatile union ECCP25_C4_REG *)0x4000385C))
// model

/** 0x4000 3864 ECCP25_DE **/
union ECCP25_DE_REG{
	unsigned int reg;
	struct ECCP25_DE_BITS{
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CLSDE:1;
		unsigned int _TXTDE:1;
		unsigned int _TZUDE:1;
		unsigned int _TXUDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_DE (*((volatile union ECCP25_DE_REG *)0x40003864))
// model

/** 0x4000 3868 ECCP25_SRIC **/
union ECCP25_SRIC_REG{
	unsigned int reg;
	struct ECCP25_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TZIC:1;
		unsigned int _TXIC:1;
		unsigned int _TZUIC:1;
		unsigned int _TXUIC:1;
		unsigned int _CPIC:1;
		unsigned int _PDIC:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_SRIC (*((volatile union ECCP25_SRIC_REG *)0x40003868))
// model

/** 0x4000 386C ECCP25_CTL3 **/
union ECCP25_CTL3_REG{
	unsigned int reg;
	struct ECCP25_CTL3_BITS{
		unsigned int _PXSPMST:1;
		unsigned int _TUNITE:1;
		unsigned int _PXRSEN:1;
		unsigned int _COMBEN:1;
		unsigned int _COMINV:2;
		unsigned int _CAPTST:1;
		unsigned int _GTBEN:1;
		unsigned int _GTBEOUT:1;
		unsigned int _CH0HM:1;
		unsigned int _CH1HM:1;
		unsigned int _CH2HM:1;
		unsigned int _CH3HM:1;
		unsigned int _TRGSEL:2;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CTL3 (*((volatile union ECCP25_CTL3_REG *)0x4000386C))
// model

/** 0x4000 3880 ECCP25_CAPPRSC **/
union ECCP25_CAPPRSC_REG{
	unsigned int reg;
	struct ECCP25_CAPPRSC_BITS{
		unsigned int _CH1CAPPR:4;
		unsigned int _CH2CAPPR:4;
		unsigned int _CH3CAPPR:4;
		unsigned int _CH4CAPPR:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CAPPRSC (*((volatile union ECCP25_CAPPRSC_REG *)0x40003880))
// model

/** 0x4000 3884 ECCP25_CAPTIME **/
union ECCP25_CAPTIME_REG{
	unsigned int reg;
	struct ECCP25_CAPTIME_BITS{
		unsigned int _CH1CAPTIME:4;
		unsigned int _CH2CAPTIME:4;
		unsigned int _CH3CAPTIME:4;
		unsigned int _CH4CAPTIME:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CAPTIME (*((volatile union ECCP25_CAPTIME_REG *)0x40003884))
// model

/** 0x4000 3888 ECCP25_CAPCTL1 **/
union ECCP25_CAPCTL1_REG{
	unsigned int reg;
	struct ECCP25_CAPCTL1_BITS{
		unsigned int _CH1CAPEN:1;
		unsigned int _CH2CAPEN:1;
		unsigned int _CH3CAPEN:1;
		unsigned int _CH4CAPEN:1;
		unsigned int _CH1CAPED:1;
		unsigned int _CH2CAPED:1;
		unsigned int _CH3CAPED:1;
		unsigned int _CH4CAPED:1;
		unsigned int _CH1CMODE:1;
		unsigned int _CH2CMODE:1;
		unsigned int _CH3CMODE:1;
		unsigned int _CH4CMODE:1;
		unsigned int _CH1TIEN:1;
		unsigned int _CH2TIEN:1;
		unsigned int _CH3TIEN:1;
		unsigned int _CH4TIEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CAPCTL1 (*((volatile union ECCP25_CAPCTL1_REG *)0x40003888))
// model

/** 0x4000 388C ECCP25_CAPCTL2 **/
union ECCP25_CAPCTL2_REG{
	unsigned int reg;
	struct ECCP25_CAPCTL2_BITS{
		unsigned int _CH1CAPPIN:3;
		unsigned int _CH2CAPPIN:3;
		unsigned int _CH3CAPPIN:3;
		unsigned int _CH4CAPPIN:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CAPCTL2 (*((volatile union ECCP25_CAPCTL2_REG *)0x4000388C))
// model

/** 0x4000 3890 ECCP25_FLCLKP **/
union ECCP25_FLCLKP_REG{
	unsigned int reg;
	struct ECCP25_FLCLKP_BITS{
		unsigned int _CH1FLCLKP:4;
		unsigned int _CH2FLCLKP:4;
		unsigned int _CH3FLCLKP:4;
		unsigned int _CH4FLCLKP:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_FLCLKP (*((volatile union ECCP25_FLCLKP_REG *)0x40003890))
// model

/** 0x4000 3894 ECCP25_FILTER **/
union ECCP25_FILTER_REG{
	unsigned int reg;
	struct ECCP25_FILTER_BITS{
		unsigned int _CH1FILTER:3;
		unsigned int _CH2FILTER:3;
		unsigned int _CH3FILTER:3;
		unsigned int _CH4FILTER:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_FILTER (*((volatile union ECCP25_FILTER_REG *)0x40003894))
// model

/** 0x4000 3898 ECCP25_PHSCTLX **/
union ECCP25_PHSCTLX_REG{
	unsigned int reg;
	struct ECCP25_PHSCTLX_BITS{
		unsigned int _PHSENX:1;
		unsigned int _PHSXMODE:1;
		unsigned int _PHSWTX:1;
		unsigned int _PHSXSEL:3;
		unsigned int _PHSXPRSC:4;
		unsigned int _PHSXTIME:4;
		unsigned int _PHSXTIEN:1;
		unsigned int _PHSXDIR:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PHSCTLX (*((volatile union ECCP25_PHSCTLX_REG *)0x40003898))
// model

/** 0x4000 389C ECCP25_PHSCTLZ **/
union ECCP25_PHSCTLZ_REG{
	unsigned int reg;
	struct ECCP25_PHSCTLZ_BITS{
		unsigned int _PHSENZ:1;
		unsigned int _PHSZMODE:1;
		unsigned int _PHSWTZ:1;
		unsigned int _PHSZSEL:3;
		unsigned int _PHSZPRSC:4;
		unsigned int _PHSZTIME:4;
		unsigned int _PHSZTIEN:1;
		unsigned int _PHSZDIR:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PHSCTLZ (*((volatile union ECCP25_PHSCTLZ_REG *)0x4000389C))
// modelT25

/** 0x4000 38A0 T25_PHS **/
union T25_PHS_REG{
	unsigned int reg;
	struct T25_PHS_BITS{
		unsigned int _PHSX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T25_PHS (*((volatile union T25_PHS_REG *)0x400038A0))
// modelT26

/** 0x4000 38A4 T26_PHS **/
union T26_PHS_REG{
	unsigned int reg;
	struct T26_PHS_BITS{
		unsigned int _PHSZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T26_PHS (*((volatile union T26_PHS_REG *)0x400038A4))
// modelECCP25

/** 0x4000 38A8 ECCP25_CTL4 **/
union ECCP25_CTL4_REG{
	unsigned int reg;
	struct ECCP25_CTL4_BITS{
		unsigned int _UDREN:1;
		unsigned int _TRGUDEN0:1;
		unsigned int _TRGUDEN1:1;
		unsigned int _TUDMODE0:1;
		unsigned int _TUDMODE1:1;
		unsigned int _CAPDEDEN1:1;
		unsigned int _CAPDEDEN2:1;
		unsigned int _CAPDEDEN3:1;
		unsigned int _CAPDEDEN4:1;
		unsigned int _CAPFILTEN1:1;
		unsigned int _CAPFILTEN2:1;
		unsigned int _CAPFILTEN3:1;
		unsigned int _CAPFILTEN4:1;
		unsigned int _TRGPOLX:1;
		unsigned int _TRGPOLZ:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_CTL4 (*((volatile union ECCP25_CTL4_REG *)0x400038A8))
// model

/** 0x4000 38AC ECCP25_PXDTCTL2 **/
union ECCP25_PXDTCTL2_REG{
	unsigned int reg;
	struct ECCP25_PXDTCTL2_BITS{
		unsigned int _CH1PXDC:8;
		unsigned int _CH2PXDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXDTCTL2 (*((volatile union ECCP25_PXDTCTL2_REG *)0x400038AC))
// model

/** 0x4000 38B0 ECCP25_PXDTCFG **/
union ECCP25_PXDTCFG_REG{
	unsigned int reg;
	struct ECCP25_PXDTCFG_BITS{
		unsigned int _CH1DTCLK:4;
		unsigned int _CH2DTCLK:4;
		unsigned int _CH3DTCLK:4;
		unsigned int _CH4DTCLK:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP25_PXDTCFG (*((volatile union ECCP25_PXDTCFG_REG *)0x400038B0))
// modelT11

/** 0x4000 0300 T11_CNT **/
union T11_CNT_REG{
	unsigned int reg;
	struct T11_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CNT (*((volatile union T11_CNT_REG *)0x40000300))
// model

/** 0x4000 0304 T11_PHS **/
union T11_PHS_REG{
	unsigned int reg;
	struct T11_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PHS (*((volatile union T11_PHS_REG *)0x40000304))
// model

/** 0x4000 0308 T11_PPX **/
union T11_PPX_REG{
	unsigned int reg;
	struct T11_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PPX (*((volatile union T11_PPX_REG *)0x40000308))
// model

/** 0x4000 030C T11_PRSC **/
union T11_PRSC_REG{
	unsigned int reg;
	struct T11_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PRSC (*((volatile union T11_PRSC_REG *)0x4000030C))
// model

/** 0x4000 0310 T11_CTL **/
union T11_CTL_REG{
	unsigned int reg;
	struct T11_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CTL (*((volatile union T11_CTL_REG *)0x40000310))
// modelEPWM11

/** 0x4000 0314 EPWM11_RA **/
union EPWM11_RA_REG{
	unsigned int reg;
	struct EPWM11_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RA (*((volatile union EPWM11_RA_REG *)0x40000314))
// model

/** 0x4000 0318 EPWM11_RB **/
union EPWM11_RB_REG{
	unsigned int reg;
	struct EPWM11_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RB (*((volatile union EPWM11_RB_REG *)0x40000318))
// model

/** 0x4000 031C EPWM11_CTLA **/
union EPWM11_CTLA_REG{
	unsigned int reg;
	struct EPWM11_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CTLA (*((volatile union EPWM11_CTLA_REG *)0x4000031C))
// model

/** 0x4000 0320 EPWM11_CTLB **/
union EPWM11_CTLB_REG{
	unsigned int reg;
	struct EPWM11_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CTLB (*((volatile union EPWM11_CTLB_REG *)0x40000320))
// model

/** 0x4000 0324 EPWM11_DBCTL **/
union EPWM11_DBCTL_REG{
	unsigned int reg;
	struct EPWM11_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DBCTL (*((volatile union EPWM11_DBCTL_REG *)0x40000324))
// model

/** 0x4000 0328 EPWM11_DBT **/
union EPWM11_DBT_REG{
	unsigned int reg;
	struct EPWM11_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DBT (*((volatile union EPWM11_DBT_REG *)0x40000328))
// model

/** 0x4000 032C EPWM11_PCCTL **/
union EPWM11_PCCTL_REG{
	unsigned int reg;
	struct EPWM11_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_PCCTL (*((volatile union EPWM11_PCCTL_REG *)0x4000032C))
// model

/** 0x4000 0330 EPWM11_PXASCTL **/
union EPWM11_PXASCTL_REG{
	unsigned int reg;
	struct EPWM11_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_PXASCTL (*((volatile union EPWM11_PXASCTL_REG *)0x40000330))
// model

/** 0x4000 0334 EPWM11_ETCTL **/
union EPWM11_ETCTL_REG{
	unsigned int reg;
	struct EPWM11_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_ETCTL (*((volatile union EPWM11_ETCTL_REG *)0x40000334))
// model

/** 0x4000 0338 EPWM11_IE **/
union EPWM11_IE_REG{
	unsigned int reg;
	struct EPWM11_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IE (*((volatile union EPWM11_IE_REG *)0x40000338))
// model

/** 0x4000 033C EPWM11_IF **/
union EPWM11_IF_REG{
	unsigned int reg;
	struct EPWM11_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IF (*((volatile union EPWM11_IF_REG *)0x4000033C))
// model

/** 0x4000 0340 EPWM11_IC **/
union EPWM11_IC_REG{
	unsigned int reg;
	struct EPWM11_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IC (*((volatile union EPWM11_IC_REG *)0x40000340))
// model

/** 0x4000 0344 EPWM11_DE **/
union EPWM11_DE_REG{
	unsigned int reg;
	struct EPWM11_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DE (*((volatile union EPWM11_DE_REG *)0x40000344))
// model

/** 0x4000 0348 EPWM11_DF **/
union EPWM11_DF_REG{
	unsigned int reg;
	struct EPWM11_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DF (*((volatile union EPWM11_DF_REG *)0x40000348))
// model

/** 0x4000 0350 EPWM11_HRPWMCTLA **/
union EPWM11_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM11_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRPWMCTLA (*((volatile union EPWM11_HRPWMCTLA_REG *)0x40000350))
// model

/** 0x4000 0354 EPWM11_HRCMPA **/
union EPWM11_HRCMPA_REG{
	unsigned int reg;
	struct EPWM11_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRCMPA (*((volatile union EPWM11_HRCMPA_REG *)0x40000354))
// model

/** 0x4000 0358 EPWM11_CAP **/
union EPWM11_CAP_REG{
	unsigned int reg;
	struct EPWM11_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CAP (*((volatile union EPWM11_CAP_REG *)0x40000358))
// model

/** 0x4000 035C EPWM11_RC **/
union EPWM11_RC_REG{
	unsigned int reg;
	struct EPWM11_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RC (*((volatile union EPWM11_RC_REG *)0x4000035C))
// model

/** 0x4000 0360 EPWM11_RD **/
union EPWM11_RD_REG{
	unsigned int reg;
	struct EPWM11_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RD (*((volatile union EPWM11_RD_REG *)0x40000360))
// model

/** 0x4000 0364 EPWM11_UDCTL **/
union EPWM11_UDCTL_REG{
	unsigned int reg;
	struct EPWM11_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_UDCTL (*((volatile union EPWM11_UDCTL_REG *)0x40000364))
// model

/** 0x4000 0368 EPWM11_SRT **/
union EPWM11_SRT_REG{
	unsigned int reg;
	struct EPWM11_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_SRT (*((volatile union EPWM11_SRT_REG *)0x40000368))
// model

/** 0x4000 036C EPWM11_HRPWMCTLB **/
union EPWM11_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM11_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRPWMCTLB (*((volatile union EPWM11_HRPWMCTLB_REG *)0x4000036C))
// model

/** 0x4000 0370 EPWM11_HRCMPB **/
union EPWM11_HRCMPB_REG{
	unsigned int reg;
	struct EPWM11_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRCMPB (*((volatile union EPWM11_HRCMPB_REG *)0x40000370))
// model

/** 0x4000 0374 EPWM11_HRDB **/
union EPWM11_HRDB_REG{
	unsigned int reg;
	struct EPWM11_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRDB (*((volatile union EPWM11_HRDB_REG *)0x40000374))
// model

/** 0x4000 0378 EPWM11_HRPHS **/
union EPWM11_HRPHS_REG{
	unsigned int reg;
	struct EPWM11_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRPHS (*((volatile union EPWM11_HRPHS_REG *)0x40000378))
// model

/** 0x4000 037C EPWM11_HRCFG **/
union EPWM11_HRCFG_REG{
	unsigned int reg;
	struct EPWM11_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRCFG (*((volatile union EPWM11_HRCFG_REG *)0x4000037C))
// model

/** 0x4000 0380 EPWM11_HRDELAY **/
union EPWM11_HRDELAY_REG{
	unsigned int reg;
	struct EPWM11_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRDELAY (*((volatile union EPWM11_HRDELAY_REG *)0x40000380))
// modelT11

/** 0x4000 0384 T11_CTL2 **/
union T11_CTL2_REG{
	unsigned int reg;
	struct T11_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CTL2 (*((volatile union T11_CTL2_REG *)0x40000384))
// modelEPWM11

/** 0x4000 0388 EPWM11_BWCFG **/
union EPWM11_BWCFG_REG{
	unsigned int reg;
	struct EPWM11_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_BWCFG (*((volatile union EPWM11_BWCFG_REG *)0x40000388))
// model

/** 0x4000 038C EPWM11_BWCNT **/
union EPWM11_BWCNT_REG{
	unsigned int reg;
	struct EPWM11_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_BWCNT (*((volatile union EPWM11_BWCNT_REG *)0x4000038C))
// model

/** 0x4000 0390 EPWM11_ETCTL2 **/
union EPWM11_ETCTL2_REG{
	unsigned int reg;
	struct EPWM11_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_ETCTL2 (*((volatile union EPWM11_ETCTL2_REG *)0x40000390))
// model

/** 0x4000 0394 EPWM11_GLDCTL **/
union EPWM11_GLDCTL_REG{
	unsigned int reg;
	struct EPWM11_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_GLDCTL (*((volatile union EPWM11_GLDCTL_REG *)0x40000394))
// model

/** 0x4000 0398 EPWM11_FILTCTL **/
union EPWM11_FILTCTL_REG{
	unsigned int reg;
	struct EPWM11_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_FILTCTL (*((volatile union EPWM11_FILTCTL_REG *)0x40000398))
// modelT12

/** 0x4000 0400 T12_CNT **/
union T12_CNT_REG{
	unsigned int reg;
	struct T12_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CNT (*((volatile union T12_CNT_REG *)0x40000400))
// model

/** 0x4000 0404 T12_PHS **/
union T12_PHS_REG{
	unsigned int reg;
	struct T12_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PHS (*((volatile union T12_PHS_REG *)0x40000404))
// model

/** 0x4000 0408 T12_PPX **/
union T12_PPX_REG{
	unsigned int reg;
	struct T12_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PPX (*((volatile union T12_PPX_REG *)0x40000408))
// model

/** 0x4000 040C T12_PRSC **/
union T12_PRSC_REG{
	unsigned int reg;
	struct T12_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PRSC (*((volatile union T12_PRSC_REG *)0x4000040C))
// model

/** 0x4000 0410 T12_CTL **/
union T12_CTL_REG{
	unsigned int reg;
	struct T12_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CTL (*((volatile union T12_CTL_REG *)0x40000410))
// modelEPWM12

/** 0x4000 0414 EPWM12_RA **/
union EPWM12_RA_REG{
	unsigned int reg;
	struct EPWM12_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RA (*((volatile union EPWM12_RA_REG *)0x40000414))
// model

/** 0x4000 0418 EPWM12_RB **/
union EPWM12_RB_REG{
	unsigned int reg;
	struct EPWM12_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RB (*((volatile union EPWM12_RB_REG *)0x40000418))
// model

/** 0x4000 041C EPWM12_CTLA **/
union EPWM12_CTLA_REG{
	unsigned int reg;
	struct EPWM12_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CTLA (*((volatile union EPWM12_CTLA_REG *)0x4000041C))
// model

/** 0x4000 0420 EPWM12_CTLB **/
union EPWM12_CTLB_REG{
	unsigned int reg;
	struct EPWM12_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CTLB (*((volatile union EPWM12_CTLB_REG *)0x40000420))
// model

/** 0x4000 0424 EPWM12_DBCTL **/
union EPWM12_DBCTL_REG{
	unsigned int reg;
	struct EPWM12_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DBCTL (*((volatile union EPWM12_DBCTL_REG *)0x40000424))
// model

/** 0x4000 0428 EPWM12_DBT **/
union EPWM12_DBT_REG{
	unsigned int reg;
	struct EPWM12_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DBT (*((volatile union EPWM12_DBT_REG *)0x40000428))
// model

/** 0x4000 042C EPWM12_PCCTL **/
union EPWM12_PCCTL_REG{
	unsigned int reg;
	struct EPWM12_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_PCCTL (*((volatile union EPWM12_PCCTL_REG *)0x4000042C))
// model

/** 0x4000 0430 EPWM12_PXASCTL **/
union EPWM12_PXASCTL_REG{
	unsigned int reg;
	struct EPWM12_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_PXASCTL (*((volatile union EPWM12_PXASCTL_REG *)0x40000430))
// model

/** 0x4000 0434 EPWM12_ETCTL **/
union EPWM12_ETCTL_REG{
	unsigned int reg;
	struct EPWM12_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_ETCTL (*((volatile union EPWM12_ETCTL_REG *)0x40000434))
// model

/** 0x4000 0438 EPWM12_IE **/
union EPWM12_IE_REG{
	unsigned int reg;
	struct EPWM12_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IE (*((volatile union EPWM12_IE_REG *)0x40000438))
// model

/** 0x4000 043C EPWM12_IF **/
union EPWM12_IF_REG{
	unsigned int reg;
	struct EPWM12_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IF (*((volatile union EPWM12_IF_REG *)0x4000043C))
// model

/** 0x4000 0440 EPWM12_IC **/
union EPWM12_IC_REG{
	unsigned int reg;
	struct EPWM12_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IC (*((volatile union EPWM12_IC_REG *)0x40000440))
// model

/** 0x4000 0444 EPWM12_DE **/
union EPWM12_DE_REG{
	unsigned int reg;
	struct EPWM12_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DE (*((volatile union EPWM12_DE_REG *)0x40000444))
// model

/** 0x4000 0448 EPWM12_DF **/
union EPWM12_DF_REG{
	unsigned int reg;
	struct EPWM12_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DF (*((volatile union EPWM12_DF_REG *)0x40000448))
// model

/** 0x4000 0450 EPWM12_HRPWMCTLA **/
union EPWM12_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM12_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRPWMCTLA (*((volatile union EPWM12_HRPWMCTLA_REG *)0x40000450))
// model

/** 0x4000 0454 EPWM12_HRCMPA **/
union EPWM12_HRCMPA_REG{
	unsigned int reg;
	struct EPWM12_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRCMPA (*((volatile union EPWM12_HRCMPA_REG *)0x40000454))
// model

/** 0x4000 0458 EPWM12_CAP **/
union EPWM12_CAP_REG{
	unsigned int reg;
	struct EPWM12_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CAP (*((volatile union EPWM12_CAP_REG *)0x40000458))
// model

/** 0x4000 045C EPWM12_RC **/
union EPWM12_RC_REG{
	unsigned int reg;
	struct EPWM12_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RC (*((volatile union EPWM12_RC_REG *)0x4000045C))
// model

/** 0x4000 0460 EPWM12_RD **/
union EPWM12_RD_REG{
	unsigned int reg;
	struct EPWM12_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RD (*((volatile union EPWM12_RD_REG *)0x40000460))
// model

/** 0x4000 0464 EPWM12_UDCTL **/
union EPWM12_UDCTL_REG{
	unsigned int reg;
	struct EPWM12_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_UDCTL (*((volatile union EPWM12_UDCTL_REG *)0x40000464))
// model

/** 0x4000 0468 EPWM12_SRT **/
union EPWM12_SRT_REG{
	unsigned int reg;
	struct EPWM12_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_SRT (*((volatile union EPWM12_SRT_REG *)0x40000468))
// model

/** 0x4000 046C EPWM12_HRPWMCTLB **/
union EPWM12_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM12_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRPWMCTLB (*((volatile union EPWM12_HRPWMCTLB_REG *)0x4000046C))
// model

/** 0x4000 0470 EPWM12_HRCMPB **/
union EPWM12_HRCMPB_REG{
	unsigned int reg;
	struct EPWM12_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRCMPB (*((volatile union EPWM12_HRCMPB_REG *)0x40000470))
// model

/** 0x4000 0474 EPWM12_HRDB **/
union EPWM12_HRDB_REG{
	unsigned int reg;
	struct EPWM12_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRDB (*((volatile union EPWM12_HRDB_REG *)0x40000474))
// model

/** 0x4000 0478 EPWM12_HRPHS **/
union EPWM12_HRPHS_REG{
	unsigned int reg;
	struct EPWM12_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRPHS (*((volatile union EPWM12_HRPHS_REG *)0x40000478))
// model

/** 0x4000 047C EPWM12_HRCFG **/
union EPWM12_HRCFG_REG{
	unsigned int reg;
	struct EPWM12_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRCFG (*((volatile union EPWM12_HRCFG_REG *)0x4000047C))
// model

/** 0x4000 0480 EPWM12_HRDELAY **/
union EPWM12_HRDELAY_REG{
	unsigned int reg;
	struct EPWM12_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRDELAY (*((volatile union EPWM12_HRDELAY_REG *)0x40000480))
// modelT12

/** 0x4000 0484 T12_CTL2 **/
union T12_CTL2_REG{
	unsigned int reg;
	struct T12_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CTL2 (*((volatile union T12_CTL2_REG *)0x40000484))
// modelEPWM12

/** 0x4000 0488 EPWM12_BWCFG **/
union EPWM12_BWCFG_REG{
	unsigned int reg;
	struct EPWM12_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_BWCFG (*((volatile union EPWM12_BWCFG_REG *)0x40000488))
// model

/** 0x4000 048C EPWM12_BWCNT **/
union EPWM12_BWCNT_REG{
	unsigned int reg;
	struct EPWM12_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_BWCNT (*((volatile union EPWM12_BWCNT_REG *)0x4000048C))
// model

/** 0x4000 0490 EPWM12_ETCTL2 **/
union EPWM12_ETCTL2_REG{
	unsigned int reg;
	struct EPWM12_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_ETCTL2 (*((volatile union EPWM12_ETCTL2_REG *)0x40000490))
// model

/** 0x4000 0494 EPWM12_GLDCTL **/
union EPWM12_GLDCTL_REG{
	unsigned int reg;
	struct EPWM12_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_GLDCTL (*((volatile union EPWM12_GLDCTL_REG *)0x40000494))
// model

/** 0x4000 0498 EPWM12_FILTCTL **/
union EPWM12_FILTCTL_REG{
	unsigned int reg;
	struct EPWM12_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_FILTCTL (*((volatile union EPWM12_FILTCTL_REG *)0x40000498))
// modelT13

/** 0x4000 1000 T13_CNT **/
union T13_CNT_REG{
	unsigned int reg;
	struct T13_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CNT (*((volatile union T13_CNT_REG *)0x40001000))
// model

/** 0x4000 1004 T13_PHS **/
union T13_PHS_REG{
	unsigned int reg;
	struct T13_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PHS (*((volatile union T13_PHS_REG *)0x40001004))
// model

/** 0x4000 1008 T13_PPX **/
union T13_PPX_REG{
	unsigned int reg;
	struct T13_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PPX (*((volatile union T13_PPX_REG *)0x40001008))
// model

/** 0x4000 100C T13_PRSC **/
union T13_PRSC_REG{
	unsigned int reg;
	struct T13_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PRSC (*((volatile union T13_PRSC_REG *)0x4000100C))
// model

/** 0x4000 1010 T13_CTL **/
union T13_CTL_REG{
	unsigned int reg;
	struct T13_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CTL (*((volatile union T13_CTL_REG *)0x40001010))
// modelEPWM13

/** 0x4000 1014 EPWM13_RA **/
union EPWM13_RA_REG{
	unsigned int reg;
	struct EPWM13_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RA (*((volatile union EPWM13_RA_REG *)0x40001014))
// model

/** 0x4000 1018 EPWM13_RB **/
union EPWM13_RB_REG{
	unsigned int reg;
	struct EPWM13_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RB (*((volatile union EPWM13_RB_REG *)0x40001018))
// model

/** 0x4000 101C EPWM13_CTLA **/
union EPWM13_CTLA_REG{
	unsigned int reg;
	struct EPWM13_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CTLA (*((volatile union EPWM13_CTLA_REG *)0x4000101C))
// model

/** 0x4000 1020 EPWM13_CTLB **/
union EPWM13_CTLB_REG{
	unsigned int reg;
	struct EPWM13_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CTLB (*((volatile union EPWM13_CTLB_REG *)0x40001020))
// model

/** 0x4000 1024 EPWM13_DBCTL **/
union EPWM13_DBCTL_REG{
	unsigned int reg;
	struct EPWM13_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DBCTL (*((volatile union EPWM13_DBCTL_REG *)0x40001024))
// model

/** 0x4000 1028 EPWM13_DBT **/
union EPWM13_DBT_REG{
	unsigned int reg;
	struct EPWM13_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DBT (*((volatile union EPWM13_DBT_REG *)0x40001028))
// model

/** 0x4000 102C EPWM13_PCCTL **/
union EPWM13_PCCTL_REG{
	unsigned int reg;
	struct EPWM13_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_PCCTL (*((volatile union EPWM13_PCCTL_REG *)0x4000102C))
// model

/** 0x4000 1030 EPWM13_PXASCTL **/
union EPWM13_PXASCTL_REG{
	unsigned int reg;
	struct EPWM13_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_PXASCTL (*((volatile union EPWM13_PXASCTL_REG *)0x40001030))
// model

/** 0x4000 1034 EPWM13_ETCTL **/
union EPWM13_ETCTL_REG{
	unsigned int reg;
	struct EPWM13_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_ETCTL (*((volatile union EPWM13_ETCTL_REG *)0x40001034))
// model

/** 0x4000 1038 EPWM13_IE **/
union EPWM13_IE_REG{
	unsigned int reg;
	struct EPWM13_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IE (*((volatile union EPWM13_IE_REG *)0x40001038))
// model

/** 0x4000 103C EPWM13_IF **/
union EPWM13_IF_REG{
	unsigned int reg;
	struct EPWM13_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IF (*((volatile union EPWM13_IF_REG *)0x4000103C))
// model

/** 0x4000 1040 EPWM13_IC **/
union EPWM13_IC_REG{
	unsigned int reg;
	struct EPWM13_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IC (*((volatile union EPWM13_IC_REG *)0x40001040))
// model

/** 0x4000 1044 EPWM13_DE **/
union EPWM13_DE_REG{
	unsigned int reg;
	struct EPWM13_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DE (*((volatile union EPWM13_DE_REG *)0x40001044))
// model

/** 0x4000 1048 EPWM13_DF **/
union EPWM13_DF_REG{
	unsigned int reg;
	struct EPWM13_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DF (*((volatile union EPWM13_DF_REG *)0x40001048))
// model

/** 0x4000 1050 EPWM13_HRPWMCTLA **/
union EPWM13_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM13_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRPWMCTLA (*((volatile union EPWM13_HRPWMCTLA_REG *)0x40001050))
// model

/** 0x4000 1054 EPWM13_HRCMPA **/
union EPWM13_HRCMPA_REG{
	unsigned int reg;
	struct EPWM13_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRCMPA (*((volatile union EPWM13_HRCMPA_REG *)0x40001054))
// model

/** 0x4000 1058 EPWM13_CAP **/
union EPWM13_CAP_REG{
	unsigned int reg;
	struct EPWM13_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CAP (*((volatile union EPWM13_CAP_REG *)0x40001058))
// model

/** 0x4000 105C EPWM13_RC **/
union EPWM13_RC_REG{
	unsigned int reg;
	struct EPWM13_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RC (*((volatile union EPWM13_RC_REG *)0x4000105C))
// model

/** 0x4000 1060 EPWM13_RD **/
union EPWM13_RD_REG{
	unsigned int reg;
	struct EPWM13_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RD (*((volatile union EPWM13_RD_REG *)0x40001060))
// model

/** 0x4000 1064 EPWM13_UDCTL **/
union EPWM13_UDCTL_REG{
	unsigned int reg;
	struct EPWM13_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_UDCTL (*((volatile union EPWM13_UDCTL_REG *)0x40001064))
// model

/** 0x4000 1068 EPWM13_SRT **/
union EPWM13_SRT_REG{
	unsigned int reg;
	struct EPWM13_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_SRT (*((volatile union EPWM13_SRT_REG *)0x40001068))
// model

/** 0x4000 106C EPWM13_HRPWMCTLB **/
union EPWM13_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM13_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRPWMCTLB (*((volatile union EPWM13_HRPWMCTLB_REG *)0x4000106C))
// model

/** 0x4000 1070 EPWM13_HRCMPB **/
union EPWM13_HRCMPB_REG{
	unsigned int reg;
	struct EPWM13_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRCMPB (*((volatile union EPWM13_HRCMPB_REG *)0x40001070))
// model

/** 0x4000 1074 EPWM13_HRDB **/
union EPWM13_HRDB_REG{
	unsigned int reg;
	struct EPWM13_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRDB (*((volatile union EPWM13_HRDB_REG *)0x40001074))
// model

/** 0x4000 1078 EPWM13_HRPHS **/
union EPWM13_HRPHS_REG{
	unsigned int reg;
	struct EPWM13_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRPHS (*((volatile union EPWM13_HRPHS_REG *)0x40001078))
// model

/** 0x4000 107C EPWM13_HRCFG **/
union EPWM13_HRCFG_REG{
	unsigned int reg;
	struct EPWM13_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRCFG (*((volatile union EPWM13_HRCFG_REG *)0x4000107C))
// model

/** 0x4000 1080 EPWM13_HRDELAY **/
union EPWM13_HRDELAY_REG{
	unsigned int reg;
	struct EPWM13_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRDELAY (*((volatile union EPWM13_HRDELAY_REG *)0x40001080))
// modelT13

/** 0x4000 1084 T13_CTL2 **/
union T13_CTL2_REG{
	unsigned int reg;
	struct T13_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CTL2 (*((volatile union T13_CTL2_REG *)0x40001084))
// modelEPWM13

/** 0x4000 1088 EPWM13_BWCFG **/
union EPWM13_BWCFG_REG{
	unsigned int reg;
	struct EPWM13_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_BWCFG (*((volatile union EPWM13_BWCFG_REG *)0x40001088))
// model

/** 0x4000 108C EPWM13_BWCNT **/
union EPWM13_BWCNT_REG{
	unsigned int reg;
	struct EPWM13_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_BWCNT (*((volatile union EPWM13_BWCNT_REG *)0x4000108C))
// model

/** 0x4000 1090 EPWM13_ETCTL2 **/
union EPWM13_ETCTL2_REG{
	unsigned int reg;
	struct EPWM13_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_ETCTL2 (*((volatile union EPWM13_ETCTL2_REG *)0x40001090))
// model

/** 0x4000 1094 EPWM13_GLDCTL **/
union EPWM13_GLDCTL_REG{
	unsigned int reg;
	struct EPWM13_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_GLDCTL (*((volatile union EPWM13_GLDCTL_REG *)0x40001094))
// model

/** 0x4000 1098 EPWM13_FILTCTL **/
union EPWM13_FILTCTL_REG{
	unsigned int reg;
	struct EPWM13_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_FILTCTL (*((volatile union EPWM13_FILTCTL_REG *)0x40001098))
// modelT16

/** 0x4000 3380 T16_CNT **/
union T16_CNT_REG{
	unsigned int reg;
	struct T16_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_CNT (*((volatile union T16_CNT_REG *)0x40003380))
// model

/** 0x4000 3384 T16_PHS **/
union T16_PHS_REG{
	unsigned int reg;
	struct T16_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_PHS (*((volatile union T16_PHS_REG *)0x40003384))
// model

/** 0x4000 3388 T16_PPX **/
union T16_PPX_REG{
	unsigned int reg;
	struct T16_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_PPX (*((volatile union T16_PPX_REG *)0x40003388))
// model

/** 0x4000 338C T16_PRSC **/
union T16_PRSC_REG{
	unsigned int reg;
	struct T16_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_PRSC (*((volatile union T16_PRSC_REG *)0x4000338C))
// model

/** 0x4000 3390 T16_CTL **/
union T16_CTL_REG{
	unsigned int reg;
	struct T16_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_CTL (*((volatile union T16_CTL_REG *)0x40003390))
// modelEPWM16

/** 0x4000 3394 EPWM16_RA **/
union EPWM16_RA_REG{
	unsigned int reg;
	struct EPWM16_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RA (*((volatile union EPWM16_RA_REG *)0x40003394))
// model

/** 0x4000 3398 EPWM16_RB **/
union EPWM16_RB_REG{
	unsigned int reg;
	struct EPWM16_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RB (*((volatile union EPWM16_RB_REG *)0x40003398))
// model

/** 0x4000 339C EPWM16_CTLA **/
union EPWM16_CTLA_REG{
	unsigned int reg;
	struct EPWM16_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_CTLA (*((volatile union EPWM16_CTLA_REG *)0x4000339C))
// model

/** 0x4000 33A0 EPWM16_CTLB **/
union EPWM16_CTLB_REG{
	unsigned int reg;
	struct EPWM16_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_CTLB (*((volatile union EPWM16_CTLB_REG *)0x400033A0))
// model

/** 0x4000 33A4 EPWM16_DBCTL **/
union EPWM16_DBCTL_REG{
	unsigned int reg;
	struct EPWM16_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DBCTL (*((volatile union EPWM16_DBCTL_REG *)0x400033A4))
// model

/** 0x4000 33A8 EPWM16_DBT **/
union EPWM16_DBT_REG{
	unsigned int reg;
	struct EPWM16_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DBT (*((volatile union EPWM16_DBT_REG *)0x400033A8))
// model

/** 0x4000 33AC EPWM16_PCCTL **/
union EPWM16_PCCTL_REG{
	unsigned int reg;
	struct EPWM16_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_PCCTL (*((volatile union EPWM16_PCCTL_REG *)0x400033AC))
// model

/** 0x4000 33B0 EPWM16_PXASCTL **/
union EPWM16_PXASCTL_REG{
	unsigned int reg;
	struct EPWM16_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_PXASCTL (*((volatile union EPWM16_PXASCTL_REG *)0x400033B0))
// model

/** 0x4000 33B4 EPWM16_ETCTL **/
union EPWM16_ETCTL_REG{
	unsigned int reg;
	struct EPWM16_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_ETCTL (*((volatile union EPWM16_ETCTL_REG *)0x400033B4))
// model

/** 0x4000 33B8 EPWM16_IE **/
union EPWM16_IE_REG{
	unsigned int reg;
	struct EPWM16_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_IE (*((volatile union EPWM16_IE_REG *)0x400033B8))
// model

/** 0x4000 33BC EPWM16_IF **/
union EPWM16_IF_REG{
	unsigned int reg;
	struct EPWM16_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_IF (*((volatile union EPWM16_IF_REG *)0x400033BC))
// model

/** 0x4000 33C0 EPWM16_IC **/
union EPWM16_IC_REG{
	unsigned int reg;
	struct EPWM16_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_IC (*((volatile union EPWM16_IC_REG *)0x400033C0))
// model

/** 0x4000 33C4 EPWM16_DE **/
union EPWM16_DE_REG{
	unsigned int reg;
	struct EPWM16_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DE (*((volatile union EPWM16_DE_REG *)0x400033C4))
// model

/** 0x4000 33C8 EPWM16_DF **/
union EPWM16_DF_REG{
	unsigned int reg;
	struct EPWM16_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DF (*((volatile union EPWM16_DF_REG *)0x400033C8))
// model

/** 0x4000 33D0 EPWM16_HRPWMCTLA **/
union EPWM16_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM16_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRPWMCTLA (*((volatile union EPWM16_HRPWMCTLA_REG *)0x400033D0))
// model

/** 0x4000 33D4 EPWM16_HRCMPA **/
union EPWM16_HRCMPA_REG{
	unsigned int reg;
	struct EPWM16_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRCMPA (*((volatile union EPWM16_HRCMPA_REG *)0x400033D4))
// model

/** 0x4000 33D8 EPWM16_CAP **/
union EPWM16_CAP_REG{
	unsigned int reg;
	struct EPWM16_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_CAP (*((volatile union EPWM16_CAP_REG *)0x400033D8))
// model

/** 0x4000 33DC EPWM16_RC **/
union EPWM16_RC_REG{
	unsigned int reg;
	struct EPWM16_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RC (*((volatile union EPWM16_RC_REG *)0x400033DC))
// model

/** 0x4000 33E0 EPWM16_RD **/
union EPWM16_RD_REG{
	unsigned int reg;
	struct EPWM16_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RD (*((volatile union EPWM16_RD_REG *)0x400033E0))
// model

/** 0x4000 33E4 EPWM16_UDCTL **/
union EPWM16_UDCTL_REG{
	unsigned int reg;
	struct EPWM16_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_UDCTL (*((volatile union EPWM16_UDCTL_REG *)0x400033E4))
// model

/** 0x4000 33E8 EPWM16_SRT **/
union EPWM16_SRT_REG{
	unsigned int reg;
	struct EPWM16_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_SRT (*((volatile union EPWM16_SRT_REG *)0x400033E8))
// model

/** 0x4000 33EC EPWM16_HRPWMCTLB **/
union EPWM16_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM16_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRPWMCTLB (*((volatile union EPWM16_HRPWMCTLB_REG *)0x400033EC))
// model

/** 0x4000 33F0 EPWM16_HRCMPB **/
union EPWM16_HRCMPB_REG{
	unsigned int reg;
	struct EPWM16_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRCMPB (*((volatile union EPWM16_HRCMPB_REG *)0x400033F0))
// model

/** 0x4000 33F4 EPWM16_HRDB **/
union EPWM16_HRDB_REG{
	unsigned int reg;
	struct EPWM16_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRDB (*((volatile union EPWM16_HRDB_REG *)0x400033F4))
// model

/** 0x4000 33F8 EPWM16_HRPHS **/
union EPWM16_HRPHS_REG{
	unsigned int reg;
	struct EPWM16_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRPHS (*((volatile union EPWM16_HRPHS_REG *)0x400033F8))
// model

/** 0x4000 33FC EPWM16_HRCFG **/
union EPWM16_HRCFG_REG{
	unsigned int reg;
	struct EPWM16_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRCFG (*((volatile union EPWM16_HRCFG_REG *)0x400033FC))
// model

/** 0x4000 3400 EPWM16_HRDELAY **/
union EPWM16_HRDELAY_REG{
	unsigned int reg;
	struct EPWM16_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRDELAY (*((volatile union EPWM16_HRDELAY_REG *)0x40003400))
// modelT16

/** 0x4000 3404 T16_CTL2 **/
union T16_CTL2_REG{
	unsigned int reg;
	struct T16_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_CTL2 (*((volatile union T16_CTL2_REG *)0x40003404))
// modelEPWM16

/** 0x4000 3408 EPWM16_BWCFG **/
union EPWM16_BWCFG_REG{
	unsigned int reg;
	struct EPWM16_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_BWCFG (*((volatile union EPWM16_BWCFG_REG *)0x40003408))
// model

/** 0x4000 340C EPWM16_BWCNT **/
union EPWM16_BWCNT_REG{
	unsigned int reg;
	struct EPWM16_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_BWCNT (*((volatile union EPWM16_BWCNT_REG *)0x4000340C))
// model

/** 0x4000 3410 EPWM16_ETCTL2 **/
union EPWM16_ETCTL2_REG{
	unsigned int reg;
	struct EPWM16_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_ETCTL2 (*((volatile union EPWM16_ETCTL2_REG *)0x40003410))
// model

/** 0x4000 3414 EPWM16_GLDCTL **/
union EPWM16_GLDCTL_REG{
	unsigned int reg;
	struct EPWM16_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_GLDCTL (*((volatile union EPWM16_GLDCTL_REG *)0x40003414))
// model

/** 0x4000 3418 EPWM16_FILTCTL **/
union EPWM16_FILTCTL_REG{
	unsigned int reg;
	struct EPWM16_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_FILTCTL (*((volatile union EPWM16_FILTCTL_REG *)0x40003418))
// modelT31

/** 0x4000 5200 T31_CNT **/
union T31_CNT_REG{
	unsigned int reg;
	struct T31_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T31_CNT (*((volatile union T31_CNT_REG *)0x40005200))
// model

/** 0x4000 5204 T31_PHS **/
union T31_PHS_REG{
	unsigned int reg;
	struct T31_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T31_PHS (*((volatile union T31_PHS_REG *)0x40005204))
// model

/** 0x4000 5208 T31_PPX **/
union T31_PPX_REG{
	unsigned int reg;
	struct T31_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T31_PPX (*((volatile union T31_PPX_REG *)0x40005208))
// model

/** 0x4000 520C T31_PRSC **/
union T31_PRSC_REG{
	unsigned int reg;
	struct T31_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T31_PRSC (*((volatile union T31_PRSC_REG *)0x4000520C))
// model

/** 0x4000 5210 T31_CTL **/
union T31_CTL_REG{
	unsigned int reg;
	struct T31_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T31_CTL (*((volatile union T31_CTL_REG *)0x40005210))
// modelEPWM31

/** 0x4000 5214 EPWM31_RA **/
union EPWM31_RA_REG{
	unsigned int reg;
	struct EPWM31_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_RA (*((volatile union EPWM31_RA_REG *)0x40005214))
// model

/** 0x4000 5218 EPWM31_RB **/
union EPWM31_RB_REG{
	unsigned int reg;
	struct EPWM31_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_RB (*((volatile union EPWM31_RB_REG *)0x40005218))
// model

/** 0x4000 521C EPWM31_CTLA **/
union EPWM31_CTLA_REG{
	unsigned int reg;
	struct EPWM31_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_CTLA (*((volatile union EPWM31_CTLA_REG *)0x4000521C))
// model

/** 0x4000 5220 EPWM31_CTLB **/
union EPWM31_CTLB_REG{
	unsigned int reg;
	struct EPWM31_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_CTLB (*((volatile union EPWM31_CTLB_REG *)0x40005220))
// model

/** 0x4000 5224 EPWM31_DBCTL **/
union EPWM31_DBCTL_REG{
	unsigned int reg;
	struct EPWM31_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_DBCTL (*((volatile union EPWM31_DBCTL_REG *)0x40005224))
// model

/** 0x4000 5228 EPWM31_DBT **/
union EPWM31_DBT_REG{
	unsigned int reg;
	struct EPWM31_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_DBT (*((volatile union EPWM31_DBT_REG *)0x40005228))
// model

/** 0x4000 522C EPWM31_PCCTL **/
union EPWM31_PCCTL_REG{
	unsigned int reg;
	struct EPWM31_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_PCCTL (*((volatile union EPWM31_PCCTL_REG *)0x4000522C))
// model

/** 0x4000 5230 EPWM31_PXASCTL **/
union EPWM31_PXASCTL_REG{
	unsigned int reg;
	struct EPWM31_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_PXASCTL (*((volatile union EPWM31_PXASCTL_REG *)0x40005230))
// model

/** 0x4000 5234 EPWM31_ETCTL **/
union EPWM31_ETCTL_REG{
	unsigned int reg;
	struct EPWM31_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_ETCTL (*((volatile union EPWM31_ETCTL_REG *)0x40005234))
// model

/** 0x4000 5238 EPWM31_IE **/
union EPWM31_IE_REG{
	unsigned int reg;
	struct EPWM31_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_IE (*((volatile union EPWM31_IE_REG *)0x40005238))
// model

/** 0x4000 523C EPWM31_IF **/
union EPWM31_IF_REG{
	unsigned int reg;
	struct EPWM31_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_IF (*((volatile union EPWM31_IF_REG *)0x4000523C))
// model

/** 0x4000 5240 EPWM31_IC **/
union EPWM31_IC_REG{
	unsigned int reg;
	struct EPWM31_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_IC (*((volatile union EPWM31_IC_REG *)0x40005240))
// model

/** 0x4000 5244 EPWM31_DE **/
union EPWM31_DE_REG{
	unsigned int reg;
	struct EPWM31_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_DE (*((volatile union EPWM31_DE_REG *)0x40005244))
// model

/** 0x4000 5248 EPWM31_DF **/
union EPWM31_DF_REG{
	unsigned int reg;
	struct EPWM31_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_DF (*((volatile union EPWM31_DF_REG *)0x40005248))
// model

/** 0x4000 5250 EPWM31_HRPWMCTLA **/
union EPWM31_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM31_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRPWMCTLA (*((volatile union EPWM31_HRPWMCTLA_REG *)0x40005250))
// model

/** 0x4000 5254 EPWM31_HRCMPA **/
union EPWM31_HRCMPA_REG{
	unsigned int reg;
	struct EPWM31_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRCMPA (*((volatile union EPWM31_HRCMPA_REG *)0x40005254))
// model

/** 0x4000 5258 EPWM31_CAP **/
union EPWM31_CAP_REG{
	unsigned int reg;
	struct EPWM31_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_CAP (*((volatile union EPWM31_CAP_REG *)0x40005258))
// model

/** 0x4000 525C EPWM31_RC **/
union EPWM31_RC_REG{
	unsigned int reg;
	struct EPWM31_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_RC (*((volatile union EPWM31_RC_REG *)0x4000525C))
// model

/** 0x4000 5260 EPWM31_RD **/
union EPWM31_RD_REG{
	unsigned int reg;
	struct EPWM31_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_RD (*((volatile union EPWM31_RD_REG *)0x40005260))
// model

/** 0x4000 5264 EPWM31_UDCTL **/
union EPWM31_UDCTL_REG{
	unsigned int reg;
	struct EPWM31_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_UDCTL (*((volatile union EPWM31_UDCTL_REG *)0x40005264))
// model

/** 0x4000 5268 EPWM31_SRT **/
union EPWM31_SRT_REG{
	unsigned int reg;
	struct EPWM31_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_SRT (*((volatile union EPWM31_SRT_REG *)0x40005268))
// model

/** 0x4000 526C EPWM31_HRPWMCTLB **/
union EPWM31_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM31_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRPWMCTLB (*((volatile union EPWM31_HRPWMCTLB_REG *)0x4000526C))
// model

/** 0x4000 5270 EPWM31_HRCMPB **/
union EPWM31_HRCMPB_REG{
	unsigned int reg;
	struct EPWM31_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRCMPB (*((volatile union EPWM31_HRCMPB_REG *)0x40005270))
// model

/** 0x4000 5274 EPWM31_HRDB **/
union EPWM31_HRDB_REG{
	unsigned int reg;
	struct EPWM31_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRDB (*((volatile union EPWM31_HRDB_REG *)0x40005274))
// model

/** 0x4000 5278 EPWM31_HRPHS **/
union EPWM31_HRPHS_REG{
	unsigned int reg;
	struct EPWM31_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRPHS (*((volatile union EPWM31_HRPHS_REG *)0x40005278))
// model

/** 0x4000 527C EPWM31_HRCFG **/
union EPWM31_HRCFG_REG{
	unsigned int reg;
	struct EPWM31_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRCFG (*((volatile union EPWM31_HRCFG_REG *)0x4000527C))
// model

/** 0x4000 5280 EPWM31_HRDELAY **/
union EPWM31_HRDELAY_REG{
	unsigned int reg;
	struct EPWM31_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_HRDELAY (*((volatile union EPWM31_HRDELAY_REG *)0x40005280))
// modelT31

/** 0x4000 5284 T31_CTL2 **/
union T31_CTL2_REG{
	unsigned int reg;
	struct T31_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T31_CTL2 (*((volatile union T31_CTL2_REG *)0x40005284))
// modelEPWM31

/** 0x4000 5288 EPWM31_BWCFG **/
union EPWM31_BWCFG_REG{
	unsigned int reg;
	struct EPWM31_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_BWCFG (*((volatile union EPWM31_BWCFG_REG *)0x40005288))
// model

/** 0x4000 528C EPWM31_BWCNT **/
union EPWM31_BWCNT_REG{
	unsigned int reg;
	struct EPWM31_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_BWCNT (*((volatile union EPWM31_BWCNT_REG *)0x4000528C))
// model

/** 0x4000 5290 EPWM31_ETCTL2 **/
union EPWM31_ETCTL2_REG{
	unsigned int reg;
	struct EPWM31_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_ETCTL2 (*((volatile union EPWM31_ETCTL2_REG *)0x40005290))
// model

/** 0x4000 5294 EPWM31_GLDCTL **/
union EPWM31_GLDCTL_REG{
	unsigned int reg;
	struct EPWM31_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_GLDCTL (*((volatile union EPWM31_GLDCTL_REG *)0x40005294))
// model

/** 0x4000 5298 EPWM31_FILTCTL **/
union EPWM31_FILTCTL_REG{
	unsigned int reg;
	struct EPWM31_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM31_FILTCTL (*((volatile union EPWM31_FILTCTL_REG *)0x40005298))
// modelT32

/** 0x4000 5300 T32_CNT **/
union T32_CNT_REG{
	unsigned int reg;
	struct T32_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T32_CNT (*((volatile union T32_CNT_REG *)0x40005300))
// model

/** 0x4000 5304 T32_PHS **/
union T32_PHS_REG{
	unsigned int reg;
	struct T32_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T32_PHS (*((volatile union T32_PHS_REG *)0x40005304))
// model

/** 0x4000 5308 T32_PPX **/
union T32_PPX_REG{
	unsigned int reg;
	struct T32_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T32_PPX (*((volatile union T32_PPX_REG *)0x40005308))
// model

/** 0x4000 530C T32_PRSC **/
union T32_PRSC_REG{
	unsigned int reg;
	struct T32_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T32_PRSC (*((volatile union T32_PRSC_REG *)0x4000530C))
// model

/** 0x4000 5310 T32_CTL **/
union T32_CTL_REG{
	unsigned int reg;
	struct T32_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T32_CTL (*((volatile union T32_CTL_REG *)0x40005310))
// modelEPWM32

/** 0x4000 5314 EPWM32_RA **/
union EPWM32_RA_REG{
	unsigned int reg;
	struct EPWM32_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_RA (*((volatile union EPWM32_RA_REG *)0x40005314))
// model

/** 0x4000 5318 EPWM32_RB **/
union EPWM32_RB_REG{
	unsigned int reg;
	struct EPWM32_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_RB (*((volatile union EPWM32_RB_REG *)0x40005318))
// model

/** 0x4000 531C EPWM32_CTLA **/
union EPWM32_CTLA_REG{
	unsigned int reg;
	struct EPWM32_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_CTLA (*((volatile union EPWM32_CTLA_REG *)0x4000531C))
// model

/** 0x4000 5320 EPWM32_CTLB **/
union EPWM32_CTLB_REG{
	unsigned int reg;
	struct EPWM32_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_CTLB (*((volatile union EPWM32_CTLB_REG *)0x40005320))
// model

/** 0x4000 5324 EPWM32_DBCTL **/
union EPWM32_DBCTL_REG{
	unsigned int reg;
	struct EPWM32_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_DBCTL (*((volatile union EPWM32_DBCTL_REG *)0x40005324))
// model

/** 0x4000 5328 EPWM32_DBT **/
union EPWM32_DBT_REG{
	unsigned int reg;
	struct EPWM32_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_DBT (*((volatile union EPWM32_DBT_REG *)0x40005328))
// model

/** 0x4000 532C EPWM32_PCCTL **/
union EPWM32_PCCTL_REG{
	unsigned int reg;
	struct EPWM32_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_PCCTL (*((volatile union EPWM32_PCCTL_REG *)0x4000532C))
// model

/** 0x4000 5330 EPWM32_PXASCTL **/
union EPWM32_PXASCTL_REG{
	unsigned int reg;
	struct EPWM32_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_PXASCTL (*((volatile union EPWM32_PXASCTL_REG *)0x40005330))
// model

/** 0x4000 5334 EPWM32_ETCTL **/
union EPWM32_ETCTL_REG{
	unsigned int reg;
	struct EPWM32_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_ETCTL (*((volatile union EPWM32_ETCTL_REG *)0x40005334))
// model

/** 0x4000 5338 EPWM32_IE **/
union EPWM32_IE_REG{
	unsigned int reg;
	struct EPWM32_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_IE (*((volatile union EPWM32_IE_REG *)0x40005338))
// model

/** 0x4000 533C EPWM32_IF **/
union EPWM32_IF_REG{
	unsigned int reg;
	struct EPWM32_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_IF (*((volatile union EPWM32_IF_REG *)0x4000533C))
// model

/** 0x4000 5340 EPWM32_IC **/
union EPWM32_IC_REG{
	unsigned int reg;
	struct EPWM32_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_IC (*((volatile union EPWM32_IC_REG *)0x40005340))
// model

/** 0x4000 5344 EPWM32_DE **/
union EPWM32_DE_REG{
	unsigned int reg;
	struct EPWM32_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_DE (*((volatile union EPWM32_DE_REG *)0x40005344))
// model

/** 0x4000 5348 EPWM32_DF **/
union EPWM32_DF_REG{
	unsigned int reg;
	struct EPWM32_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_DF (*((volatile union EPWM32_DF_REG *)0x40005348))
// model

/** 0x4000 5350 EPWM32_HRPWMCTLA **/
union EPWM32_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM32_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRPWMCTLA (*((volatile union EPWM32_HRPWMCTLA_REG *)0x40005350))
// model

/** 0x4000 5354 EPWM32_HRCMPA **/
union EPWM32_HRCMPA_REG{
	unsigned int reg;
	struct EPWM32_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRCMPA (*((volatile union EPWM32_HRCMPA_REG *)0x40005354))
// model

/** 0x4000 5358 EPWM32_CAP **/
union EPWM32_CAP_REG{
	unsigned int reg;
	struct EPWM32_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_CAP (*((volatile union EPWM32_CAP_REG *)0x40005358))
// model

/** 0x4000 535C EPWM32_RC **/
union EPWM32_RC_REG{
	unsigned int reg;
	struct EPWM32_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_RC (*((volatile union EPWM32_RC_REG *)0x4000535C))
// model

/** 0x4000 5360 EPWM32_RD **/
union EPWM32_RD_REG{
	unsigned int reg;
	struct EPWM32_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_RD (*((volatile union EPWM32_RD_REG *)0x40005360))
// model

/** 0x4000 5364 EPWM32_UDCTL **/
union EPWM32_UDCTL_REG{
	unsigned int reg;
	struct EPWM32_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_UDCTL (*((volatile union EPWM32_UDCTL_REG *)0x40005364))
// model

/** 0x4000 5368 EPWM32_SRT **/
union EPWM32_SRT_REG{
	unsigned int reg;
	struct EPWM32_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_SRT (*((volatile union EPWM32_SRT_REG *)0x40005368))
// model

/** 0x4000 536C EPWM32_HRPWMCTLB **/
union EPWM32_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM32_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRPWMCTLB (*((volatile union EPWM32_HRPWMCTLB_REG *)0x4000536C))
// model

/** 0x4000 5370 EPWM32_HRCMPB **/
union EPWM32_HRCMPB_REG{
	unsigned int reg;
	struct EPWM32_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRCMPB (*((volatile union EPWM32_HRCMPB_REG *)0x40005370))
// model

/** 0x4000 5374 EPWM32_HRDB **/
union EPWM32_HRDB_REG{
	unsigned int reg;
	struct EPWM32_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRDB (*((volatile union EPWM32_HRDB_REG *)0x40005374))
// model

/** 0x4000 5378 EPWM32_HRPHS **/
union EPWM32_HRPHS_REG{
	unsigned int reg;
	struct EPWM32_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRPHS (*((volatile union EPWM32_HRPHS_REG *)0x40005378))
// model

/** 0x4000 537C EPWM32_HRCFG **/
union EPWM32_HRCFG_REG{
	unsigned int reg;
	struct EPWM32_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRCFG (*((volatile union EPWM32_HRCFG_REG *)0x4000537C))
// model

/** 0x4000 5380 EPWM32_HRDELAY **/
union EPWM32_HRDELAY_REG{
	unsigned int reg;
	struct EPWM32_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_HRDELAY (*((volatile union EPWM32_HRDELAY_REG *)0x40005380))
// modelT32

/** 0x4000 5384 T32_CTL2 **/
union T32_CTL2_REG{
	unsigned int reg;
	struct T32_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T32_CTL2 (*((volatile union T32_CTL2_REG *)0x40005384))
// modelEPWM32

/** 0x4000 5388 EPWM32_BWCFG **/
union EPWM32_BWCFG_REG{
	unsigned int reg;
	struct EPWM32_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_BWCFG (*((volatile union EPWM32_BWCFG_REG *)0x40005388))
// model

/** 0x4000 538C EPWM32_BWCNT **/
union EPWM32_BWCNT_REG{
	unsigned int reg;
	struct EPWM32_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_BWCNT (*((volatile union EPWM32_BWCNT_REG *)0x4000538C))
// model

/** 0x4000 5390 EPWM32_ETCTL2 **/
union EPWM32_ETCTL2_REG{
	unsigned int reg;
	struct EPWM32_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_ETCTL2 (*((volatile union EPWM32_ETCTL2_REG *)0x40005390))
// model

/** 0x4000 5394 EPWM32_GLDCTL **/
union EPWM32_GLDCTL_REG{
	unsigned int reg;
	struct EPWM32_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_GLDCTL (*((volatile union EPWM32_GLDCTL_REG *)0x40005394))
// model

/** 0x4000 5398 EPWM32_FILTCTL **/
union EPWM32_FILTCTL_REG{
	unsigned int reg;
	struct EPWM32_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM32_FILTCTL (*((volatile union EPWM32_FILTCTL_REG *)0x40005398))
// modelT33

/** 0x4000 5400 T33_CNT **/
union T33_CNT_REG{
	unsigned int reg;
	struct T33_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T33_CNT (*((volatile union T33_CNT_REG *)0x40005400))
// model

/** 0x4000 5404 T33_PHS **/
union T33_PHS_REG{
	unsigned int reg;
	struct T33_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T33_PHS (*((volatile union T33_PHS_REG *)0x40005404))
// model

/** 0x4000 5408 T33_PPX **/
union T33_PPX_REG{
	unsigned int reg;
	struct T33_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T33_PPX (*((volatile union T33_PPX_REG *)0x40005408))
// model

/** 0x4000 540C T33_PRSC **/
union T33_PRSC_REG{
	unsigned int reg;
	struct T33_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T33_PRSC (*((volatile union T33_PRSC_REG *)0x4000540C))
// model

/** 0x4000 5410 T33_CTL **/
union T33_CTL_REG{
	unsigned int reg;
	struct T33_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T33_CTL (*((volatile union T33_CTL_REG *)0x40005410))
// modelEPWM33

/** 0x4000 5414 EPWM33_RA **/
union EPWM33_RA_REG{
	unsigned int reg;
	struct EPWM33_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_RA (*((volatile union EPWM33_RA_REG *)0x40005414))
// model

/** 0x4000 5418 EPWM33_RB **/
union EPWM33_RB_REG{
	unsigned int reg;
	struct EPWM33_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_RB (*((volatile union EPWM33_RB_REG *)0x40005418))
// model

/** 0x4000 541C EPWM33_CTLA **/
union EPWM33_CTLA_REG{
	unsigned int reg;
	struct EPWM33_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_CTLA (*((volatile union EPWM33_CTLA_REG *)0x4000541C))
// model

/** 0x4000 5420 EPWM33_CTLB **/
union EPWM33_CTLB_REG{
	unsigned int reg;
	struct EPWM33_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_CTLB (*((volatile union EPWM33_CTLB_REG *)0x40005420))
// model

/** 0x4000 5424 EPWM33_DBCTL **/
union EPWM33_DBCTL_REG{
	unsigned int reg;
	struct EPWM33_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_DBCTL (*((volatile union EPWM33_DBCTL_REG *)0x40005424))
// model

/** 0x4000 5428 EPWM33_DBT **/
union EPWM33_DBT_REG{
	unsigned int reg;
	struct EPWM33_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_DBT (*((volatile union EPWM33_DBT_REG *)0x40005428))
// model

/** 0x4000 542C EPWM33_PCCTL **/
union EPWM33_PCCTL_REG{
	unsigned int reg;
	struct EPWM33_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_PCCTL (*((volatile union EPWM33_PCCTL_REG *)0x4000542C))
// model

/** 0x4000 5430 EPWM33_PXASCTL **/
union EPWM33_PXASCTL_REG{
	unsigned int reg;
	struct EPWM33_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_PXASCTL (*((volatile union EPWM33_PXASCTL_REG *)0x40005430))
// model

/** 0x4000 5434 EPWM33_ETCTL **/
union EPWM33_ETCTL_REG{
	unsigned int reg;
	struct EPWM33_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_ETCTL (*((volatile union EPWM33_ETCTL_REG *)0x40005434))
// model

/** 0x4000 5438 EPWM33_IE **/
union EPWM33_IE_REG{
	unsigned int reg;
	struct EPWM33_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_IE (*((volatile union EPWM33_IE_REG *)0x40005438))
// model

/** 0x4000 543C EPWM33_IF **/
union EPWM33_IF_REG{
	unsigned int reg;
	struct EPWM33_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_IF (*((volatile union EPWM33_IF_REG *)0x4000543C))
// model

/** 0x4000 5440 EPWM33_IC **/
union EPWM33_IC_REG{
	unsigned int reg;
	struct EPWM33_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_IC (*((volatile union EPWM33_IC_REG *)0x40005440))
// model

/** 0x4000 5444 EPWM33_DE **/
union EPWM33_DE_REG{
	unsigned int reg;
	struct EPWM33_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_DE (*((volatile union EPWM33_DE_REG *)0x40005444))
// model

/** 0x4000 5448 EPWM33_DF **/
union EPWM33_DF_REG{
	unsigned int reg;
	struct EPWM33_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_DF (*((volatile union EPWM33_DF_REG *)0x40005448))
// model

/** 0x4000 5450 EPWM33_HRPWMCTLA **/
union EPWM33_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM33_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRPWMCTLA (*((volatile union EPWM33_HRPWMCTLA_REG *)0x40005450))
// model

/** 0x4000 5454 EPWM33_HRCMPA **/
union EPWM33_HRCMPA_REG{
	unsigned int reg;
	struct EPWM33_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRCMPA (*((volatile union EPWM33_HRCMPA_REG *)0x40005454))
// model

/** 0x4000 5458 EPWM33_CAP **/
union EPWM33_CAP_REG{
	unsigned int reg;
	struct EPWM33_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_CAP (*((volatile union EPWM33_CAP_REG *)0x40005458))
// model

/** 0x4000 545C EPWM33_RC **/
union EPWM33_RC_REG{
	unsigned int reg;
	struct EPWM33_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_RC (*((volatile union EPWM33_RC_REG *)0x4000545C))
// model

/** 0x4000 5460 EPWM33_RD **/
union EPWM33_RD_REG{
	unsigned int reg;
	struct EPWM33_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_RD (*((volatile union EPWM33_RD_REG *)0x40005460))
// model

/** 0x4000 5464 EPWM33_UDCTL **/
union EPWM33_UDCTL_REG{
	unsigned int reg;
	struct EPWM33_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_UDCTL (*((volatile union EPWM33_UDCTL_REG *)0x40005464))
// model

/** 0x4000 5468 EPWM33_SRT **/
union EPWM33_SRT_REG{
	unsigned int reg;
	struct EPWM33_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_SRT (*((volatile union EPWM33_SRT_REG *)0x40005468))
// model

/** 0x4000 546C EPWM33_HRPWMCTLB **/
union EPWM33_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM33_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRPWMCTLB (*((volatile union EPWM33_HRPWMCTLB_REG *)0x4000546C))
// model

/** 0x4000 5470 EPWM33_HRCMPB **/
union EPWM33_HRCMPB_REG{
	unsigned int reg;
	struct EPWM33_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRCMPB (*((volatile union EPWM33_HRCMPB_REG *)0x40005470))
// model

/** 0x4000 5474 EPWM33_HRDB **/
union EPWM33_HRDB_REG{
	unsigned int reg;
	struct EPWM33_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRDB (*((volatile union EPWM33_HRDB_REG *)0x40005474))
// model

/** 0x4000 5478 EPWM33_HRPHS **/
union EPWM33_HRPHS_REG{
	unsigned int reg;
	struct EPWM33_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRPHS (*((volatile union EPWM33_HRPHS_REG *)0x40005478))
// model

/** 0x4000 547C EPWM33_HRCFG **/
union EPWM33_HRCFG_REG{
	unsigned int reg;
	struct EPWM33_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRCFG (*((volatile union EPWM33_HRCFG_REG *)0x4000547C))
// model

/** 0x4000 5480 EPWM33_HRDELAY **/
union EPWM33_HRDELAY_REG{
	unsigned int reg;
	struct EPWM33_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_HRDELAY (*((volatile union EPWM33_HRDELAY_REG *)0x40005480))
// modelT33

/** 0x4000 5484 T33_CTL2 **/
union T33_CTL2_REG{
	unsigned int reg;
	struct T33_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T33_CTL2 (*((volatile union T33_CTL2_REG *)0x40005484))
// modelEPWM33

/** 0x4000 5488 EPWM33_BWCFG **/
union EPWM33_BWCFG_REG{
	unsigned int reg;
	struct EPWM33_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_BWCFG (*((volatile union EPWM33_BWCFG_REG *)0x40005488))
// model

/** 0x4000 548C EPWM33_BWCNT **/
union EPWM33_BWCNT_REG{
	unsigned int reg;
	struct EPWM33_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_BWCNT (*((volatile union EPWM33_BWCNT_REG *)0x4000548C))
// model

/** 0x4000 5490 EPWM33_ETCTL2 **/
union EPWM33_ETCTL2_REG{
	unsigned int reg;
	struct EPWM33_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_ETCTL2 (*((volatile union EPWM33_ETCTL2_REG *)0x40005490))
// model

/** 0x4000 5494 EPWM33_GLDCTL **/
union EPWM33_GLDCTL_REG{
	unsigned int reg;
	struct EPWM33_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_GLDCTL (*((volatile union EPWM33_GLDCTL_REG *)0x40005494))
// model

/** 0x4000 5498 EPWM33_FILTCTL **/
union EPWM33_FILTCTL_REG{
	unsigned int reg;
	struct EPWM33_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM33_FILTCTL (*((volatile union EPWM33_FILTCTL_REG *)0x40005498))
// modelT36

/** 0x4000 5500 T36_CNT **/
union T36_CNT_REG{
	unsigned int reg;
	struct T36_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T36_CNT (*((volatile union T36_CNT_REG *)0x40005500))
// model

/** 0x4000 5504 T36_PHS **/
union T36_PHS_REG{
	unsigned int reg;
	struct T36_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T36_PHS (*((volatile union T36_PHS_REG *)0x40005504))
// model

/** 0x4000 5508 T36_PPX **/
union T36_PPX_REG{
	unsigned int reg;
	struct T36_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T36_PPX (*((volatile union T36_PPX_REG *)0x40005508))
// model

/** 0x4000 550C T36_PRSC **/
union T36_PRSC_REG{
	unsigned int reg;
	struct T36_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T36_PRSC (*((volatile union T36_PRSC_REG *)0x4000550C))
// model

/** 0x4000 5510 T36_CTL **/
union T36_CTL_REG{
	unsigned int reg;
	struct T36_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL:2;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int _READTEN:1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int :1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T36_CTL (*((volatile union T36_CTL_REG *)0x40005510))
// modelEPWM36

/** 0x4000 5514 EPWM36_RA **/
union EPWM36_RA_REG{
	unsigned int reg;
	struct EPWM36_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_RA (*((volatile union EPWM36_RA_REG *)0x40005514))
// model

/** 0x4000 5518 EPWM36_RB **/
union EPWM36_RB_REG{
	unsigned int reg;
	struct EPWM36_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_RB (*((volatile union EPWM36_RB_REG *)0x40005518))
// model

/** 0x4000 551C EPWM36_CTLA **/
union EPWM36_CTLA_REG{
	unsigned int reg;
	struct EPWM36_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _STSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_CTLA (*((volatile union EPWM36_CTLA_REG *)0x4000551C))
// model

/** 0x4000 5520 EPWM36_CTLB **/
union EPWM36_CTLB_REG{
	unsigned int reg;
	struct EPWM36_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_CTLB (*((volatile union EPWM36_CTLB_REG *)0x40005520))
// model

/** 0x4000 5524 EPWM36_DBCTL **/
union EPWM36_DBCTL_REG{
	unsigned int reg;
	struct EPWM36_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_DBCTL (*((volatile union EPWM36_DBCTL_REG *)0x40005524))
// model

/** 0x4000 5528 EPWM36_DBT **/
union EPWM36_DBT_REG{
	unsigned int reg;
	struct EPWM36_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_DBT (*((volatile union EPWM36_DBT_REG *)0x40005528))
// model

/** 0x4000 552C EPWM36_PCCTL **/
union EPWM36_PCCTL_REG{
	unsigned int reg;
	struct EPWM36_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_PCCTL (*((volatile union EPWM36_PCCTL_REG *)0x4000552C))
// model

/** 0x4000 5530 EPWM36_PXASCTL **/
union EPWM36_PXASCTL_REG{
	unsigned int reg;
	struct EPWM36_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_PXASCTL (*((volatile union EPWM36_PXASCTL_REG *)0x40005530))
// model

/** 0x4000 5534 EPWM36_ETCTL **/
union EPWM36_ETCTL_REG{
	unsigned int reg;
	struct EPWM36_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int :2;
		unsigned int _FRCA:1;
		unsigned int :4;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int :2;
		unsigned int _FRCB:1;
		unsigned int :4;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_ETCTL (*((volatile union EPWM36_ETCTL_REG *)0x40005534))
// model

/** 0x4000 5538 EPWM36_IE **/
union EPWM36_IE_REG{
	unsigned int reg;
	struct EPWM36_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int _CAPIE:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_IE (*((volatile union EPWM36_IE_REG *)0x40005538))
// model

/** 0x4000 553C EPWM36_IF **/
union EPWM36_IF_REG{
	unsigned int reg;
	struct EPWM36_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int _CAPIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_IF (*((volatile union EPWM36_IF_REG *)0x4000553C))
// model

/** 0x4000 5540 EPWM36_IC **/
union EPWM36_IC_REG{
	unsigned int reg;
	struct EPWM36_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int _CAPIC:2;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_IC (*((volatile union EPWM36_IC_REG *)0x40005540))
// model

/** 0x4000 5544 EPWM36_DE **/
union EPWM36_DE_REG{
	unsigned int reg;
	struct EPWM36_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_DE (*((volatile union EPWM36_DE_REG *)0x40005544))
// model

/** 0x4000 5548 EPWM36_DF **/
union EPWM36_DF_REG{
	unsigned int reg;
	struct EPWM36_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_DF (*((volatile union EPWM36_DF_REG *)0x40005548))
// model

/** 0x4000 5550 EPWM36_HRPWMCTLA **/
union EPWM36_HRPWMCTLA_REG{
	unsigned int reg;
	struct EPWM36_HRPWMCTLA_BITS{
		unsigned int _HRENA:1;
		unsigned int _HRSELA:1;
		unsigned int _HRDENA:1;
		unsigned int _HRPENA:1;
		unsigned int _HRRENA:1;
		unsigned int _HRFENA:1;
		unsigned int _HRPHSENA:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRPWMCTLA (*((volatile union EPWM36_HRPWMCTLA_REG *)0x40005550))
// model

/** 0x4000 5554 EPWM36_HRCMPA **/
union EPWM36_HRCMPA_REG{
	unsigned int reg;
	struct EPWM36_HRCMPA_BITS{
		unsigned int _HRCMPA:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRCMPA (*((volatile union EPWM36_HRCMPA_REG *)0x40005554))
// model

/** 0x4000 5558 EPWM36_CAP **/
union EPWM36_CAP_REG{
	unsigned int reg;
	struct EPWM36_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_CAP (*((volatile union EPWM36_CAP_REG *)0x40005558))
// model

/** 0x4000 555C EPWM36_RC **/
union EPWM36_RC_REG{
	unsigned int reg;
	struct EPWM36_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_RC (*((volatile union EPWM36_RC_REG *)0x4000555C))
// model

/** 0x4000 5560 EPWM36_RD **/
union EPWM36_RD_REG{
	unsigned int reg;
	struct EPWM36_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_RD (*((volatile union EPWM36_RD_REG *)0x40005560))
// model

/** 0x4000 5564 EPWM36_UDCTL **/
union EPWM36_UDCTL_REG{
	unsigned int reg;
	struct EPWM36_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_UDCTL (*((volatile union EPWM36_UDCTL_REG *)0x40005564))
// model

/** 0x4000 5568 EPWM36_SRT **/
union EPWM36_SRT_REG{
	unsigned int reg;
	struct EPWM36_SRT_BITS{
		unsigned int _T:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_SRT (*((volatile union EPWM36_SRT_REG *)0x40005568))
// model

/** 0x4000 556C EPWM36_HRPWMCTLB **/
union EPWM36_HRPWMCTLB_REG{
	unsigned int reg;
	struct EPWM36_HRPWMCTLB_BITS{
		unsigned int _HRENB:1;
		unsigned int _HRSELB:1;
		unsigned int _HRDENB:1;
		unsigned int _HRPENB:1;
		unsigned int _HRRENB:1;
		unsigned int _HRFENB:1;
		unsigned int _HRPHSENB:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRPWMCTLB (*((volatile union EPWM36_HRPWMCTLB_REG *)0x4000556C))
// model

/** 0x4000 5570 EPWM36_HRCMPB **/
union EPWM36_HRCMPB_REG{
	unsigned int reg;
	struct EPWM36_HRCMPB_BITS{
		unsigned int _HRCMPB:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRCMPB (*((volatile union EPWM36_HRCMPB_REG *)0x40005570))
// model

/** 0x4000 5574 EPWM36_HRDB **/
union EPWM36_HRDB_REG{
	unsigned int reg;
	struct EPWM36_HRDB_BITS{
		unsigned int _HRF:8;
		unsigned int _HRR:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRDB (*((volatile union EPWM36_HRDB_REG *)0x40005574))
// model

/** 0x4000 5578 EPWM36_HRPHS **/
union EPWM36_HRPHS_REG{
	unsigned int reg;
	struct EPWM36_HRPHS_BITS{
		unsigned int _HRPHS:8;
		unsigned int _HRPRE:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRPHS (*((volatile union EPWM36_HRPHS_REG *)0x40005578))
// model

/** 0x4000 557C EPWM36_HRCFG **/
union EPWM36_HRCFG_REG{
	unsigned int reg;
	struct EPWM36_HRCFG_BITS{
		unsigned int _TIMS:8;
		unsigned int _STEP:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRCFG (*((volatile union EPWM36_HRCFG_REG *)0x4000557C))
// model

/** 0x4000 5580 EPWM36_HRDELAY **/
union EPWM36_HRDELAY_REG{
	unsigned int reg;
	struct EPWM36_HRDELAY_BITS{
		unsigned int _FEDAHR:8;
		unsigned int _REDAHR:8;
		unsigned int _FEDBHR:8;
		unsigned int _REDBHR:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_HRDELAY (*((volatile union EPWM36_HRDELAY_REG *)0x40005580))
// modelT36

/** 0x4000 5584 T36_CTL2 **/
union T36_CTL2_REG{
	unsigned int reg;
	struct T36_CTL2_BITS{
		unsigned int _SWCLRPF:1;
		unsigned int _BWINDEN:1;
		unsigned int _BWINDPOL:1;
		unsigned int _BWINDTSEL:1;
		unsigned int _DUDBEN:1;
		unsigned int _DUDBSEL:1;
		unsigned int _SYNCIOS:1;
		unsigned int _TRGIOS:1;
		unsigned int _CMAFUF:1;
		unsigned int _CMBFUF:1;
		unsigned int _CMCFUF:1;
		unsigned int _CMDFUF:1;
		unsigned int _PPFUF:1;
		unsigned int _PRFUF:1;
		unsigned int _EAFUF:1;
		unsigned int _EBFUF:1;
		unsigned int _HRPAUF:1;
		unsigned int _HRPBUF:1;
		unsigned int _DBTUF:1;
		unsigned int _HRDBUF:1;
		unsigned int _HRPHSUF:1;
		unsigned int _HRCFGUF:1;
		unsigned int _CAPUF:1;
		unsigned int _CAPMOD:1;
		unsigned int _LPHSEN:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T36_CTL2 (*((volatile union T36_CTL2_REG *)0x40005584))
// modelEPWM36

/** 0x4000 5588 EPWM36_BWCFG **/
union EPWM36_BWCFG_REG{
	unsigned int reg;
	struct EPWM36_BWCFG_BITS{
		unsigned int _BWOFFSET:16;
		unsigned int _BWIDTH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_BWCFG (*((volatile union EPWM36_BWCFG_REG *)0x40005588))
// model

/** 0x4000 558C EPWM36_BWCNT **/
union EPWM36_BWCNT_REG{
	unsigned int reg;
	struct EPWM36_BWCNT_BITS{
		unsigned int _OFFCNT:16;
		unsigned int _WITCNT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_BWCNT (*((volatile union EPWM36_BWCNT_REG *)0x4000558C))
// model

/** 0x4000 5590 EPWM36_ETCTL2 **/
union EPWM36_ETCTL2_REG{
	unsigned int reg;
	struct EPWM36_ETCTL2_BITS{
		unsigned int _SELA:3;
		unsigned int _APP:4;
		unsigned int _AT:4;
		unsigned int :5;
		unsigned int _SELB:3;
		unsigned int _BPP:4;
		unsigned int _BT:4;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_ETCTL2 (*((volatile union EPWM36_ETCTL2_REG *)0x40005590))
// model

/** 0x4000 5594 EPWM36_GLDCTL **/
union EPWM36_GLDCTL_REG{
	unsigned int reg;
	struct EPWM36_GLDCTL_BITS{
		unsigned int _CLDPRCS:8;
		unsigned int _HRPBUDEN:1;
		unsigned int _HRPBUDSEL:2;
		unsigned int _DBUDEN:1;
		unsigned int _DBUDSEL:2;
		unsigned int _HRDBUDEN:1;
		unsigned int _HRDBUDSEL:2;
		unsigned int _HRPHSUDEN:1;
		unsigned int _HRPHSUDSEL:2;
		unsigned int _HRCFGUDEN:1;
		unsigned int _HRCFGUDSEL:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_GLDCTL (*((volatile union EPWM36_GLDCTL_REG *)0x40005594))
// model

/** 0x4000 5598 EPWM36_FILTCTL **/
union EPWM36_FILTCTL_REG{
	unsigned int reg;
	struct EPWM36_FILTCTL_BITS{
		unsigned int _CAPFEN:1;
		unsigned int _CFDIV:4;
		unsigned int _CFDELAY:3;
		unsigned int _TXCKFEN:1;
		unsigned int _TCKFDIV:4;
		unsigned int _TCKDELAY:3;
		unsigned int _SYNCFEN:1;
		unsigned int _SYFDIV:4;
		unsigned int _SYDELAY:3;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM36_FILTCTL (*((volatile union EPWM36_FILTCTL_REG *)0x40005598))
// modelADC0

/** 0x4000 0580 ADC0_CTL0 **/
union ADC0_CTL0_REG{
	unsigned int reg;
	struct ADC0_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :4;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CTL0 (*((volatile union ADC0_CTL0_REG *)0x40000580))
// model

/** 0x4000 0584 ADC0_CTL1 **/
union ADC0_CTL1_REG{
	unsigned int reg;
	struct ADC0_CTL1_BITS{
		unsigned int _NOVMODEN:1;
		unsigned int :1;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int _DOUMODCALEN:1;
		unsigned int _NOVIF:1;
		unsigned int _NOVIC:1;
		unsigned int _NOVIE:1;
		unsigned int :1;
		unsigned int _REFSEL:2;
		unsigned int :1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CTL1 (*((volatile union ADC0_CTL1_REG *)0x40000584))
// model

/** 0x4000 0588 ADC0_SCANSQ0 **/
union ADC0_SCANSQ0_REG{
	unsigned int reg;
	struct ADC0_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ0 (*((volatile union ADC0_SCANSQ0_REG *)0x40000588))
// model

/** 0x4000 058C ADC0_SCANSQ1 **/
union ADC0_SCANSQ1_REG{
	unsigned int reg;
	struct ADC0_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ1 (*((volatile union ADC0_SCANSQ1_REG *)0x4000058C))
// model

/** 0x4000 0590 ADC0_SCANSQ2 **/
union ADC0_SCANSQ2_REG{
	unsigned int reg;
	struct ADC0_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ2 (*((volatile union ADC0_SCANSQ2_REG *)0x40000590))
// model

/** 0x4000 05C4 ADC0_SCANSQ3 **/
union ADC0_SCANSQ3_REG{
	unsigned int reg;
	struct ADC0_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ3 (*((volatile union ADC0_SCANSQ3_REG *)0x400005C4))
// model

/** 0x4000 0594 ADC0_HSCANSQ **/
union ADC0_HSCANSQ_REG{
	unsigned int reg;
	struct ADC0_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HSCANSQ (*((volatile union ADC0_HSCANSQ_REG *)0x40000594))
// model

/** 0x4000 0598 ADC0_WDH **/
union ADC0_WDH_REG{
	unsigned int reg;
	struct ADC0_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_WDH (*((volatile union ADC0_WDH_REG *)0x40000598))
// model

/** 0x4000 059C ADC0_WDL **/
union ADC0_WDL_REG{
	unsigned int reg;
	struct ADC0_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_WDL (*((volatile union ADC0_WDL_REG *)0x4000059C))
// model

/** 0x4000 05A0 ADC0_DATA **/
union ADC0_DATA_REG{
	unsigned int reg;
	struct ADC0_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_DATA (*((volatile union ADC0_DATA_REG *)0x400005A0))
// model

/** 0x4000 05A4 ADC0_HPDATA0 **/
union ADC0_HPDATA0_REG{
	unsigned int reg;
	struct ADC0_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA0 (*((volatile union ADC0_HPDATA0_REG *)0x400005A4))
// model

/** 0x4000 05A8 ADC0_HPDATA1 **/
union ADC0_HPDATA1_REG{
	unsigned int reg;
	struct ADC0_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA1 (*((volatile union ADC0_HPDATA1_REG *)0x400005A8))
// model

/** 0x4000 05AC ADC0_HPDATA2 **/
union ADC0_HPDATA2_REG{
	unsigned int reg;
	struct ADC0_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA2 (*((volatile union ADC0_HPDATA2_REG *)0x400005AC))
// model

/** 0x4000 05B0 ADC0_HPDATA3 **/
union ADC0_HPDATA3_REG{
	unsigned int reg;
	struct ADC0_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA3 (*((volatile union ADC0_HPDATA3_REG *)0x400005B0))
// model

/** 0x4000 05B4 ADC0_HPOFF0 **/
union ADC0_HPOFF0_REG{
	unsigned int reg;
	struct ADC0_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF0 (*((volatile union ADC0_HPOFF0_REG *)0x400005B4))
// model

/** 0x4000 05B8 ADC0_HPOFF1 **/
union ADC0_HPOFF1_REG{
	unsigned int reg;
	struct ADC0_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF1 (*((volatile union ADC0_HPOFF1_REG *)0x400005B8))
// model

/** 0x4000 05BC ADC0_HPOFF2 **/
union ADC0_HPOFF2_REG{
	unsigned int reg;
	struct ADC0_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF2 (*((volatile union ADC0_HPOFF2_REG *)0x400005BC))
// model

/** 0x4000 05C0 ADC0_HPOFF3 **/
union ADC0_HPOFF3_REG{
	unsigned int reg;
	struct ADC0_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPOFF3 (*((volatile union ADC0_HPOFF3_REG *)0x400005C0))
// model

/** 0x4000 05D0 ADC0_STATE **/
union ADC0_STATE_REG{
	unsigned int reg;
	struct ADC0_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int :12;
		unsigned int _TSSELTOADCIS0:1;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int _TSSELTOADCIS1:1;
		unsigned int _TSSELTOADCIS2:1;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_STATE (*((volatile union ADC0_STATE_REG *)0x400005D0))
// model

/** 0x4000 05D4 ADC0_DELAY **/
union ADC0_DELAY_REG{
	unsigned int reg;
	struct ADC0_DELAY_BITS{
		unsigned int _FDELAY:6;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_DELAY (*((volatile union ADC0_DELAY_REG *)0x400005D4))
// model

/** 0x4000 05D8 ADC0_SCANCTL **/
union ADC0_SCANCTL_REG{
	unsigned int reg;
	struct ADC0_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:2;
		unsigned int :2;
		unsigned int _NCHNUB:5;
		unsigned int :3;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANCTL (*((volatile union ADC0_SCANCTL_REG *)0x400005D8))
// model

/** 0x4000 05DC ADC0_CCR **/
union ADC0_CCR_REG{
	unsigned int reg;
	struct ADC0_CCR_BITS{
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int _CCR3N:1;
		unsigned int _CCR3H:1;
		unsigned int _CCR4N:1;
		unsigned int _CCR4H:1;
		unsigned int _CCR5N:1;
		unsigned int _CCR5H:1;
		unsigned int _CCR6N:1;
		unsigned int _CCR6H:1;
		unsigned int _CCR7N:1;
		unsigned int _CCR7H:1;
		unsigned int _CCR8N:1;
		unsigned int _CCR8H:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CCR (*((volatile union ADC0_CCR_REG *)0x400005DC))
// modelADC1

/** 0x4000 0600 ADC1_CTL0 **/
union ADC1_CTL0_REG{
	unsigned int reg;
	struct ADC1_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :4;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CTL0 (*((volatile union ADC1_CTL0_REG *)0x40000600))
// model

/** 0x4000 0604 ADC1_CTL1 **/
union ADC1_CTL1_REG{
	unsigned int reg;
	struct ADC1_CTL1_BITS{
		unsigned int _NOVMODEN:1;
		unsigned int :1;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int _DOUMODCALEN:1;
		unsigned int _NOVIF:1;
		unsigned int _NOVIC:1;
		unsigned int _NOVIE:1;
		unsigned int :1;
		unsigned int _REFSEL:2;
		unsigned int :1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CTL1 (*((volatile union ADC1_CTL1_REG *)0x40000604))
// model

/** 0x4000 0608 ADC1_SCANSQ0 **/
union ADC1_SCANSQ0_REG{
	unsigned int reg;
	struct ADC1_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ0 (*((volatile union ADC1_SCANSQ0_REG *)0x40000608))
// model

/** 0x4000 060C ADC1_SCANSQ1 **/
union ADC1_SCANSQ1_REG{
	unsigned int reg;
	struct ADC1_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ1 (*((volatile union ADC1_SCANSQ1_REG *)0x4000060C))
// model

/** 0x4000 0610 ADC1_SCANSQ2 **/
union ADC1_SCANSQ2_REG{
	unsigned int reg;
	struct ADC1_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ2 (*((volatile union ADC1_SCANSQ2_REG *)0x40000610))
// model

/** 0x4000 0644 ADC1_SCANSQ3 **/
union ADC1_SCANSQ3_REG{
	unsigned int reg;
	struct ADC1_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ3 (*((volatile union ADC1_SCANSQ3_REG *)0x40000644))
// model

/** 0x4000 0614 ADC1_HSCANSQ **/
union ADC1_HSCANSQ_REG{
	unsigned int reg;
	struct ADC1_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HSCANSQ (*((volatile union ADC1_HSCANSQ_REG *)0x40000614))
// model

/** 0x4000 0618 ADC1_WDH **/
union ADC1_WDH_REG{
	unsigned int reg;
	struct ADC1_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_WDH (*((volatile union ADC1_WDH_REG *)0x40000618))
// model

/** 0x4000 061C ADC1_WDL **/
union ADC1_WDL_REG{
	unsigned int reg;
	struct ADC1_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_WDL (*((volatile union ADC1_WDL_REG *)0x4000061C))
// model

/** 0x4000 0620 ADC1_DATA **/
union ADC1_DATA_REG{
	unsigned int reg;
	struct ADC1_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_DATA (*((volatile union ADC1_DATA_REG *)0x40000620))
// model

/** 0x4000 0624 ADC1_HPDATA0 **/
union ADC1_HPDATA0_REG{
	unsigned int reg;
	struct ADC1_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA0 (*((volatile union ADC1_HPDATA0_REG *)0x40000624))
// model

/** 0x4000 0628 ADC1_HPDATA1 **/
union ADC1_HPDATA1_REG{
	unsigned int reg;
	struct ADC1_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA1 (*((volatile union ADC1_HPDATA1_REG *)0x40000628))
// model

/** 0x4000 062C ADC1_HPDATA2 **/
union ADC1_HPDATA2_REG{
	unsigned int reg;
	struct ADC1_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA2 (*((volatile union ADC1_HPDATA2_REG *)0x4000062C))
// model

/** 0x4000 0630 ADC1_HPDATA3 **/
union ADC1_HPDATA3_REG{
	unsigned int reg;
	struct ADC1_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA3 (*((volatile union ADC1_HPDATA3_REG *)0x40000630))
// model

/** 0x4000 0634 ADC1_HPOFF0 **/
union ADC1_HPOFF0_REG{
	unsigned int reg;
	struct ADC1_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF0 (*((volatile union ADC1_HPOFF0_REG *)0x40000634))
// model

/** 0x4000 0638 ADC1_HPOFF1 **/
union ADC1_HPOFF1_REG{
	unsigned int reg;
	struct ADC1_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF1 (*((volatile union ADC1_HPOFF1_REG *)0x40000638))
// model

/** 0x4000 063C ADC1_HPOFF2 **/
union ADC1_HPOFF2_REG{
	unsigned int reg;
	struct ADC1_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF2 (*((volatile union ADC1_HPOFF2_REG *)0x4000063C))
// model

/** 0x4000 0640 ADC1_HPOFF3 **/
union ADC1_HPOFF3_REG{
	unsigned int reg;
	struct ADC1_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPOFF3 (*((volatile union ADC1_HPOFF3_REG *)0x40000640))
// model

/** 0x4000 0650 ADC1_STATE **/
union ADC1_STATE_REG{
	unsigned int reg;
	struct ADC1_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int :12;
		unsigned int _TSSELTOADCIS0:1;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int _TSSELTOADCIS1:1;
		unsigned int _TSSELTOADCIS2:1;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_STATE (*((volatile union ADC1_STATE_REG *)0x40000650))
// model

/** 0x4000 0658 ADC1_SCANCTL **/
union ADC1_SCANCTL_REG{
	unsigned int reg;
	struct ADC1_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:2;
		unsigned int :2;
		unsigned int _NCHNUB:5;
		unsigned int :3;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANCTL (*((volatile union ADC1_SCANCTL_REG *)0x40000658))
// model

/** 0x4000 065C ADC1_CCR **/
union ADC1_CCR_REG{
	unsigned int reg;
	struct ADC1_CCR_BITS{
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int _CCR3N:1;
		unsigned int _CCR3H:1;
		unsigned int _CCR4N:1;
		unsigned int _CCR4H:1;
		unsigned int _CCR5N:1;
		unsigned int _CCR5H:1;
		unsigned int _CCR6N:1;
		unsigned int _CCR6H:1;
		unsigned int _CCR7N:1;
		unsigned int _CCR7H:1;
		unsigned int _CCR8N:1;
		unsigned int _CCR8H:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CCR (*((volatile union ADC1_CCR_REG *)0x4000065C))
// modelADC2

/** 0x4000 0680 ADC2_CTL0 **/
union ADC2_CTL0_REG{
	unsigned int reg;
	struct ADC2_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :4;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CTL0 (*((volatile union ADC2_CTL0_REG *)0x40000680))
// model

/** 0x4000 0684 ADC2_CTL1 **/
union ADC2_CTL1_REG{
	unsigned int reg;
	struct ADC2_CTL1_BITS{
		unsigned int _NOVMODEN:1;
		unsigned int :1;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int _DOUMODCALEN:1;
		unsigned int _NOVIF:1;
		unsigned int _NOVIC:1;
		unsigned int _NOVIE:1;
		unsigned int :1;
		unsigned int _REFSEL:2;
		unsigned int :1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CTL1 (*((volatile union ADC2_CTL1_REG *)0x40000684))
// model

/** 0x4000 0688 ADC2_SCANSQ0 **/
union ADC2_SCANSQ0_REG{
	unsigned int reg;
	struct ADC2_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ0 (*((volatile union ADC2_SCANSQ0_REG *)0x40000688))
// model

/** 0x4000 068C ADC2_SCANSQ1 **/
union ADC2_SCANSQ1_REG{
	unsigned int reg;
	struct ADC2_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ1 (*((volatile union ADC2_SCANSQ1_REG *)0x4000068C))
// model

/** 0x4000 0690 ADC2_SCANSQ2 **/
union ADC2_SCANSQ2_REG{
	unsigned int reg;
	struct ADC2_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ2 (*((volatile union ADC2_SCANSQ2_REG *)0x40000690))
// model

/** 0x4000 06C4 ADC2_SCANSQ3 **/
union ADC2_SCANSQ3_REG{
	unsigned int reg;
	struct ADC2_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ3 (*((volatile union ADC2_SCANSQ3_REG *)0x400006C4))
// model

/** 0x4000 0694 ADC2_HSCANSQ **/
union ADC2_HSCANSQ_REG{
	unsigned int reg;
	struct ADC2_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HSCANSQ (*((volatile union ADC2_HSCANSQ_REG *)0x40000694))
// model

/** 0x4000 0698 ADC2_WDH **/
union ADC2_WDH_REG{
	unsigned int reg;
	struct ADC2_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_WDH (*((volatile union ADC2_WDH_REG *)0x40000698))
// model

/** 0x4000 069C ADC2_WDL **/
union ADC2_WDL_REG{
	unsigned int reg;
	struct ADC2_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_WDL (*((volatile union ADC2_WDL_REG *)0x4000069C))
// model

/** 0x4000 06A0 ADC2_DATA **/
union ADC2_DATA_REG{
	unsigned int reg;
	struct ADC2_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_DATA (*((volatile union ADC2_DATA_REG *)0x400006A0))
// model

/** 0x4000 06A4 ADC2_HPDATA0 **/
union ADC2_HPDATA0_REG{
	unsigned int reg;
	struct ADC2_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA0 (*((volatile union ADC2_HPDATA0_REG *)0x400006A4))
// model

/** 0x4000 06A8 ADC2_HPDATA1 **/
union ADC2_HPDATA1_REG{
	unsigned int reg;
	struct ADC2_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA1 (*((volatile union ADC2_HPDATA1_REG *)0x400006A8))
// model

/** 0x4000 06AC ADC2_HPDATA2 **/
union ADC2_HPDATA2_REG{
	unsigned int reg;
	struct ADC2_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA2 (*((volatile union ADC2_HPDATA2_REG *)0x400006AC))
// model

/** 0x4000 06B0 ADC2_HPDATA3 **/
union ADC2_HPDATA3_REG{
	unsigned int reg;
	struct ADC2_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA3 (*((volatile union ADC2_HPDATA3_REG *)0x400006B0))
// model

/** 0x4000 06B4 ADC2_HPOFF0 **/
union ADC2_HPOFF0_REG{
	unsigned int reg;
	struct ADC2_HPOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF0 (*((volatile union ADC2_HPOFF0_REG *)0x400006B4))
// model

/** 0x4000 06B8 ADC2_HPOFF1 **/
union ADC2_HPOFF1_REG{
	unsigned int reg;
	struct ADC2_HPOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF1 (*((volatile union ADC2_HPOFF1_REG *)0x400006B8))
// model

/** 0x4000 06BC ADC2_HPOFF2 **/
union ADC2_HPOFF2_REG{
	unsigned int reg;
	struct ADC2_HPOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF2 (*((volatile union ADC2_HPOFF2_REG *)0x400006BC))
// model

/** 0x4000 06C0 ADC2_HPOFF3 **/
union ADC2_HPOFF3_REG{
	unsigned int reg;
	struct ADC2_HPOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPOFF3 (*((volatile union ADC2_HPOFF3_REG *)0x400006C0))
// model

/** 0x4000 06D0 ADC2_STATE **/
union ADC2_STATE_REG{
	unsigned int reg;
	struct ADC2_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int :12;
		unsigned int _TSSELTOADCIS0:1;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int _TSSELTOADCIS1:1;
		unsigned int _TSSELTOADCIS2:1;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_STATE (*((volatile union ADC2_STATE_REG *)0x400006D0))
// model

/** 0x4000 06D8 ADC2_SCANCTL **/
union ADC2_SCANCTL_REG{
	unsigned int reg;
	struct ADC2_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:2;
		unsigned int :2;
		unsigned int _NCHNUB:5;
		unsigned int :3;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANCTL (*((volatile union ADC2_SCANCTL_REG *)0x400006D8))
// model

/** 0x4000 06DC ADC2_CCR **/
union ADC2_CCR_REG{
	unsigned int reg;
	struct ADC2_CCR_BITS{
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int _CCR3N:1;
		unsigned int _CCR3H:1;
		unsigned int _CCR4N:1;
		unsigned int _CCR4H:1;
		unsigned int _CCR5N:1;
		unsigned int _CCR5H:1;
		unsigned int _CCR6N:1;
		unsigned int _CCR6H:1;
		unsigned int _CCR7N:1;
		unsigned int _CCR7H:1;
		unsigned int _CCR8N:1;
		unsigned int _CCR8H:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CCR (*((volatile union ADC2_CCR_REG *)0x400006DC))
// modelDAC0

/** 0x4000 0700 DAC0_CTL **/
union DAC0_CTL_REG{
	unsigned int reg;
	struct DAC0_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL (*((volatile union DAC0_CTL_REG *)0x40000700))
// model

/** 0x4000 0704 DAC0_DAHD **/
union DAC0_DAHD_REG{
	unsigned int reg;
	struct DAC0_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DAHD (*((volatile union DAC0_DAHD_REG *)0x40000704))
// model

/** 0x4000 0708 DAC0_DATA **/
union DAC0_DATA_REG{
	unsigned int reg;
	struct DAC0_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DATA (*((volatile union DAC0_DATA_REG *)0x40000708))
// model

/** 0x4000 070C DAC0_CTL1 **/
union DAC0_CTL1_REG{
	unsigned int reg;
	struct DAC0_CTL1_BITS{
		unsigned int _SEL:2;
		unsigned int _RFS:2;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :2;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL1 (*((volatile union DAC0_CTL1_REG *)0x4000070C))
// model

/** 0x4000 0714 DAC0_CAL **/
union DAC0_CAL_REG{
	unsigned int reg;
	struct DAC0_CAL_BITS{
		unsigned int _TPEN:1;
		unsigned int _TP:2;
		unsigned int :10;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CAL (*((volatile union DAC0_CAL_REG *)0x40000714))
// modelDAC1

/** 0x4000 0780 DAC1_CTL **/
union DAC1_CTL_REG{
	unsigned int reg;
	struct DAC1_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CTL (*((volatile union DAC1_CTL_REG *)0x40000780))
// model

/** 0x4000 0784 DAC1_DAHD **/
union DAC1_DAHD_REG{
	unsigned int reg;
	struct DAC1_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_DAHD (*((volatile union DAC1_DAHD_REG *)0x40000784))
// model

/** 0x4000 0788 DAC1_DATA **/
union DAC1_DATA_REG{
	unsigned int reg;
	struct DAC1_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_DATA (*((volatile union DAC1_DATA_REG *)0x40000788))
// model

/** 0x4000 078C DAC1_CTL1 **/
union DAC1_CTL1_REG{
	unsigned int reg;
	struct DAC1_CTL1_BITS{
		unsigned int _SEL:2;
		unsigned int _RFS:2;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :2;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CTL1 (*((volatile union DAC1_CTL1_REG *)0x4000078C))
// model

/** 0x4000 0794 DAC1_CAL **/
union DAC1_CAL_REG{
	unsigned int reg;
	struct DAC1_CAL_BITS{
		unsigned int _TPEN:1;
		unsigned int _TP:2;
		unsigned int :10;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CAL (*((volatile union DAC1_CAL_REG *)0x40000794))
// modelUSART0

/** 0x4000 0980 USART0_CTLR **/
union USART0_CTLR_REG{
	unsigned int reg;
	struct USART0_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_CTLR (*((volatile union USART0_CTLR_REG *)0x40000980))
// model

/** 0x4000 0984 USART0_BRGR **/
union USART0_BRGR_REG{
	unsigned int reg;
	struct USART0_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_BRGR (*((volatile union USART0_BRGR_REG *)0x40000984))
// model

/** 0x4000 0988 USART0_STR **/
union USART0_STR_REG{
	unsigned int reg;
	struct USART0_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_STR (*((volatile union USART0_STR_REG *)0x40000988))
// model

/** 0x4000 098C USART0_TBUFR **/
union USART0_TBUFR_REG{
	unsigned int reg;
	struct USART0_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_TBUFR (*((volatile union USART0_TBUFR_REG *)0x4000098C))
// model

/** 0x4000 098C USART0_RBUFR **/
union USART0_RBUFR_REG{
	unsigned int reg;
	struct USART0_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_RBUFR (*((volatile union USART0_RBUFR_REG *)0x4000098C))
// model

/** 0x4000 0994 USART0_IER **/
union USART0_IER_REG{
	unsigned int reg;
	struct USART0_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_IER (*((volatile union USART0_IER_REG *)0x40000994))
// model

/** 0x4000 0998 USART0_ADM **/
union USART0_ADM_REG{
	unsigned int reg;
	struct USART0_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_ADM (*((volatile union USART0_ADM_REG *)0x40000998))
// modelUSART1

/** 0x4000 0A00 USART1_CTLR **/
union USART1_CTLR_REG{
	unsigned int reg;
	struct USART1_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_CTLR (*((volatile union USART1_CTLR_REG *)0x40000A00))
// model

/** 0x4000 0A04 USART1_BRGR **/
union USART1_BRGR_REG{
	unsigned int reg;
	struct USART1_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_BRGR (*((volatile union USART1_BRGR_REG *)0x40000A04))
// model

/** 0x4000 0A08 USART1_STR **/
union USART1_STR_REG{
	unsigned int reg;
	struct USART1_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_STR (*((volatile union USART1_STR_REG *)0x40000A08))
// model

/** 0x4000 0A0C USART1_TBUFR **/
union USART1_TBUFR_REG{
	unsigned int reg;
	struct USART1_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_TBUFR (*((volatile union USART1_TBUFR_REG *)0x40000A0C))
// model

/** 0x4000 0A0C USART1_RBUFR **/
union USART1_RBUFR_REG{
	unsigned int reg;
	struct USART1_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_RBUFR (*((volatile union USART1_RBUFR_REG *)0x40000A0C))
// model

/** 0x4000 0A14 USART1_IER **/
union USART1_IER_REG{
	unsigned int reg;
	struct USART1_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_IER (*((volatile union USART1_IER_REG *)0x40000A14))
// model

/** 0x4000 0A18 USART1_ADM **/
union USART1_ADM_REG{
	unsigned int reg;
	struct USART1_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_ADM (*((volatile union USART1_ADM_REG *)0x40000A18))
// modelUSART2

/** 0x4000 0A80 USART2_CTLR **/
union USART2_CTLR_REG{
	unsigned int reg;
	struct USART2_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_CTLR (*((volatile union USART2_CTLR_REG *)0x40000A80))
// model

/** 0x4000 0A84 USART2_BRGR **/
union USART2_BRGR_REG{
	unsigned int reg;
	struct USART2_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_BRGR (*((volatile union USART2_BRGR_REG *)0x40000A84))
// model

/** 0x4000 0A88 USART2_STR **/
union USART2_STR_REG{
	unsigned int reg;
	struct USART2_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_STR (*((volatile union USART2_STR_REG *)0x40000A88))
// model

/** 0x4000 0A8C USART2_TBUFR **/
union USART2_TBUFR_REG{
	unsigned int reg;
	struct USART2_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_TBUFR (*((volatile union USART2_TBUFR_REG *)0x40000A8C))
// model

/** 0x4000 0A8C USART2_RBUFR **/
union USART2_RBUFR_REG{
	unsigned int reg;
	struct USART2_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_RBUFR (*((volatile union USART2_RBUFR_REG *)0x40000A8C))
// model

/** 0x4000 0A94 USART2_IER **/
union USART2_IER_REG{
	unsigned int reg;
	struct USART2_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_IER (*((volatile union USART2_IER_REG *)0x40000A94))
// model

/** 0x4000 0A98 USART2_ADM **/
union USART2_ADM_REG{
	unsigned int reg;
	struct USART2_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_ADM (*((volatile union USART2_ADM_REG *)0x40000A98))
// modelUSART3

/** 0x4000 0B00 USART3_CTLR **/
union USART3_CTLR_REG{
	unsigned int reg;
	struct USART3_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_CTLR (*((volatile union USART3_CTLR_REG *)0x40000B00))
// model

/** 0x4000 0B04 USART3_BRGR **/
union USART3_BRGR_REG{
	unsigned int reg;
	struct USART3_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_BRGR (*((volatile union USART3_BRGR_REG *)0x40000B04))
// model

/** 0x4000 0B08 USART3_STR **/
union USART3_STR_REG{
	unsigned int reg;
	struct USART3_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_STR (*((volatile union USART3_STR_REG *)0x40000B08))
// model

/** 0x4000 0B0C USART3_TBUFR **/
union USART3_TBUFR_REG{
	unsigned int reg;
	struct USART3_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_TBUFR (*((volatile union USART3_TBUFR_REG *)0x40000B0C))
// model

/** 0x4000 0B0C USART3_RBUFR **/
union USART3_RBUFR_REG{
	unsigned int reg;
	struct USART3_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_RBUFR (*((volatile union USART3_RBUFR_REG *)0x40000B0C))
// model

/** 0x4000 0B14 USART3_IER **/
union USART3_IER_REG{
	unsigned int reg;
	struct USART3_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_IER (*((volatile union USART3_IER_REG *)0x40000B14))
// model

/** 0x4000 0B18 USART3_ADM **/
union USART3_ADM_REG{
	unsigned int reg;
	struct USART3_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART3_ADM (*((volatile union USART3_ADM_REG *)0x40000B18))
// modelUSART4

/** 0x4000 0B80 USART4_CTLR **/
union USART4_CTLR_REG{
	unsigned int reg;
	struct USART4_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_CTLR (*((volatile union USART4_CTLR_REG *)0x40000B80))
// model

/** 0x4000 0B84 USART4_BRGR **/
union USART4_BRGR_REG{
	unsigned int reg;
	struct USART4_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_BRGR (*((volatile union USART4_BRGR_REG *)0x40000B84))
// model

/** 0x4000 0B88 USART4_STR **/
union USART4_STR_REG{
	unsigned int reg;
	struct USART4_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_STR (*((volatile union USART4_STR_REG *)0x40000B88))
// model

/** 0x4000 0B8C USART4_TBUFR **/
union USART4_TBUFR_REG{
	unsigned int reg;
	struct USART4_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_TBUFR (*((volatile union USART4_TBUFR_REG *)0x40000B8C))
// model

/** 0x4000 0B8C USART4_RBUFR **/
union USART4_RBUFR_REG{
	unsigned int reg;
	struct USART4_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_RBUFR (*((volatile union USART4_RBUFR_REG *)0x40000B8C))
// model

/** 0x4000 0B94 USART4_IER **/
union USART4_IER_REG{
	unsigned int reg;
	struct USART4_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_IER (*((volatile union USART4_IER_REG *)0x40000B94))
// modelUSART5

/** 0x4000 0B98 USART5_ADM **/
union USART5_ADM_REG{
	unsigned int reg;
	struct USART5_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_ADM (*((volatile union USART5_ADM_REG *)0x40000B98))
// model

/** 0x4000 1E80 USART5_CTLR **/
union USART5_CTLR_REG{
	unsigned int reg;
	struct USART5_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_CTLR (*((volatile union USART5_CTLR_REG *)0x40001E80))
// model

/** 0x4000 1E84 USART5_BRGR **/
union USART5_BRGR_REG{
	unsigned int reg;
	struct USART5_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_BRGR (*((volatile union USART5_BRGR_REG *)0x40001E84))
// model

/** 0x4000 1E88 USART5_STR **/
union USART5_STR_REG{
	unsigned int reg;
	struct USART5_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_STR (*((volatile union USART5_STR_REG *)0x40001E88))
// model

/** 0x4000 1E8C USART5_TBUFR **/
union USART5_TBUFR_REG{
	unsigned int reg;
	struct USART5_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_TBUFR (*((volatile union USART5_TBUFR_REG *)0x40001E8C))
// model

/** 0x4000 1E8C USART5_RBUFR **/
union USART5_RBUFR_REG{
	unsigned int reg;
	struct USART5_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_RBUFR (*((volatile union USART5_RBUFR_REG *)0x40001E8C))
// model

/** 0x4000 1E94 USART5_IER **/
union USART5_IER_REG{
	unsigned int reg;
	struct USART5_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_IER (*((volatile union USART5_IER_REG *)0x40001E94))
// model

/** 0x4000 1E98 USART5_ADM **/
union USART5_ADM_REG{
	unsigned int reg;
	struct USART5_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_ADM (*((volatile union USART5_ADM_REG *)0x40001E98))
// modelUSART6

/** 0x4000 1F00 USART6_CTLR **/
union USART6_CTLR_REG{
	unsigned int reg;
	struct USART6_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_CTLR (*((volatile union USART6_CTLR_REG *)0x40001F00))
// model

/** 0x4000 1F04 USART6_BRGR **/
union USART6_BRGR_REG{
	unsigned int reg;
	struct USART6_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_BRGR (*((volatile union USART6_BRGR_REG *)0x40001F04))
// model

/** 0x4000 1F08 USART6_STR **/
union USART6_STR_REG{
	unsigned int reg;
	struct USART6_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLEIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_STR (*((volatile union USART6_STR_REG *)0x40001F08))
// model

/** 0x4000 1F0C USART6_TBUFR **/
union USART6_TBUFR_REG{
	unsigned int reg;
	struct USART6_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_TBUFR (*((volatile union USART6_TBUFR_REG *)0x40001F0C))
// model

/** 0x4000 1F0C USART6_RBUFR **/
union USART6_RBUFR_REG{
	unsigned int reg;
	struct USART6_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_RBUFR (*((volatile union USART6_RBUFR_REG *)0x40001F0C))
// model

/** 0x4000 1F14 USART6_IER **/
union USART6_IER_REG{
	unsigned int reg;
	struct USART6_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_IER (*((volatile union USART6_IER_REG *)0x40001F14))
// model

/** 0x4000 1F18 USART6_ADM **/
union USART6_ADM_REG{
	unsigned int reg;
	struct USART6_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART6_ADM (*((volatile union USART6_ADM_REG *)0x40001F18))
// modelUSART7

/** 0x4000 1F80 USART7_CTLR **/
union USART7_CTLR_REG{
	unsigned int reg;
	struct USART7_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_CTLR (*((volatile union USART7_CTLR_REG *)0x40001F80))
// model

/** 0x4000 1F84 USART7_BRGR **/
union USART7_BRGR_REG{
	unsigned int reg;
	struct USART7_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_BRGR (*((volatile union USART7_BRGR_REG *)0x40001F84))
// model

/** 0x4000 1F88 USART7_STR **/
union USART7_STR_REG{
	unsigned int reg;
	struct USART7_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_STR (*((volatile union USART7_STR_REG *)0x40001F88))
// model

/** 0x4000 1F8C USART7_TBUFR **/
union USART7_TBUFR_REG{
	unsigned int reg;
	struct USART7_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_TBUFR (*((volatile union USART7_TBUFR_REG *)0x40001F8C))
// model

/** 0x4000 1F8C USART7_RBUFR **/
union USART7_RBUFR_REG{
	unsigned int reg;
	struct USART7_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_RBUFR (*((volatile union USART7_RBUFR_REG *)0x40001F8C))
// model

/** 0x4000 1F94 USART7_IER **/
union USART7_IER_REG{
	unsigned int reg;
	struct USART7_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_IER (*((volatile union USART7_IER_REG *)0x40001F94))
// model

/** 0x4000 1F98 USART7_ADM **/
union USART7_ADM_REG{
	unsigned int reg;
	struct USART7_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_ADM (*((volatile union USART7_ADM_REG *)0x40001F98))
// modelUSART8

/** 0x4000 4700 USART8_CTLR **/
union USART8_CTLR_REG{
	unsigned int reg;
	struct USART8_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_CTLR (*((volatile union USART8_CTLR_REG *)0x40004700))
// model

/** 0x4000 4704 USART8_BRGR **/
union USART8_BRGR_REG{
	unsigned int reg;
	struct USART8_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_BRGR (*((volatile union USART8_BRGR_REG *)0x40004704))
// model

/** 0x4000 4708 USART8_STR **/
union USART8_STR_REG{
	unsigned int reg;
	struct USART8_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_STR (*((volatile union USART8_STR_REG *)0x40004708))
// model

/** 0x4000 470C USART8_TBUFR **/
union USART8_TBUFR_REG{
	unsigned int reg;
	struct USART8_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_TBUFR (*((volatile union USART8_TBUFR_REG *)0x4000470C))
// model

/** 0x4000 470C USART8_RBUFR **/
union USART8_RBUFR_REG{
	unsigned int reg;
	struct USART8_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_RBUFR (*((volatile union USART8_RBUFR_REG *)0x4000470C))
// model

/** 0x4000 4714 USART8_IER **/
union USART8_IER_REG{
	unsigned int reg;
	struct USART8_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_IER (*((volatile union USART8_IER_REG *)0x40004714))
// model

/** 0x4000 4718 USART8_ADM **/
union USART8_ADM_REG{
	unsigned int reg;
	struct USART8_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART8_ADM (*((volatile union USART8_ADM_REG *)0x40004718))
// modelUSART9

/** 0x4000 4780 USART9_CTLR **/
union USART9_CTLR_REG{
	unsigned int reg;
	struct USART9_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_CTLR (*((volatile union USART9_CTLR_REG *)0x40004780))
// model

/** 0x4000 4784 USART9_BRGR **/
union USART9_BRGR_REG{
	unsigned int reg;
	struct USART9_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_BRGR (*((volatile union USART9_BRGR_REG *)0x40004784))
// model

/** 0x4000 4788 USART9_STR **/
union USART9_STR_REG{
	unsigned int reg;
	struct USART9_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_STR (*((volatile union USART9_STR_REG *)0x40004788))
// model

/** 0x4000 478C USART9_TBUFR **/
union USART9_TBUFR_REG{
	unsigned int reg;
	struct USART9_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_TBUFR (*((volatile union USART9_TBUFR_REG *)0x4000478C))
// model

/** 0x4000 478C USART9_RBUFR **/
union USART9_RBUFR_REG{
	unsigned int reg;
	struct USART9_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_RBUFR (*((volatile union USART9_RBUFR_REG *)0x4000478C))
// model

/** 0x4000 4794 USART9_IER **/
union USART9_IER_REG{
	unsigned int reg;
	struct USART9_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_IER (*((volatile union USART9_IER_REG *)0x40004794))
// model

/** 0x4000 4798 USART9_ADM **/
union USART9_ADM_REG{
	unsigned int reg;
	struct USART9_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART9_ADM (*((volatile union USART9_ADM_REG *)0x40004798))
// modelUSART10

/** 0x4000 4800 USART10_CTLR **/
union USART10_CTLR_REG{
	unsigned int reg;
	struct USART10_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_CTLR (*((volatile union USART10_CTLR_REG *)0x40004800))
// model

/** 0x4000 4804 USART10_BRGR **/
union USART10_BRGR_REG{
	unsigned int reg;
	struct USART10_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_BRGR (*((volatile union USART10_BRGR_REG *)0x40004804))
// model

/** 0x4000 4808 USART10_STR **/
union USART10_STR_REG{
	unsigned int reg;
	struct USART10_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_STR (*((volatile union USART10_STR_REG *)0x40004808))
// model

/** 0x4000 480C USART10_TBUFR **/
union USART10_TBUFR_REG{
	unsigned int reg;
	struct USART10_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_TBUFR (*((volatile union USART10_TBUFR_REG *)0x4000480C))
// model

/** 0x4000 480C USART10_RBUFR **/
union USART10_RBUFR_REG{
	unsigned int reg;
	struct USART10_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_RBUFR (*((volatile union USART10_RBUFR_REG *)0x4000480C))
// model

/** 0x4000 4814 USART10_IER **/
union USART10_IER_REG{
	unsigned int reg;
	struct USART10_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_IER (*((volatile union USART10_IER_REG *)0x40004814))
// model

/** 0x4000 4818 USART10_ADM **/
union USART10_ADM_REG{
	unsigned int reg;
	struct USART10_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART10_ADM (*((volatile union USART10_ADM_REG *)0x40004818))
// modelUSART11

/** 0x4000 4880 USART11_CTLR **/
union USART11_CTLR_REG{
	unsigned int reg;
	struct USART11_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_CTLR (*((volatile union USART11_CTLR_REG *)0x40004880))
// model

/** 0x4000 4884 USART11_BRGR **/
union USART11_BRGR_REG{
	unsigned int reg;
	struct USART11_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_BRGR (*((volatile union USART11_BRGR_REG *)0x40004884))
// model

/** 0x4000 4888 USART11_STR **/
union USART11_STR_REG{
	unsigned int reg;
	struct USART11_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_STR (*((volatile union USART11_STR_REG *)0x40004888))
// model

/** 0x4000 488C USART11_TBUFR **/
union USART11_TBUFR_REG{
	unsigned int reg;
	struct USART11_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_TBUFR (*((volatile union USART11_TBUFR_REG *)0x4000488C))
// model

/** 0x4000 488C USART11_RBUFR **/
union USART11_RBUFR_REG{
	unsigned int reg;
	struct USART11_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_RBUFR (*((volatile union USART11_RBUFR_REG *)0x4000488C))
// model

/** 0x4000 4894 USART11_IER **/
union USART11_IER_REG{
	unsigned int reg;
	struct USART11_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_IER (*((volatile union USART11_IER_REG *)0x40004894))
// model

/** 0x4000 4898 USART11_ADM **/
union USART11_ADM_REG{
	unsigned int reg;
	struct USART11_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART11_ADM (*((volatile union USART11_ADM_REG *)0x40004898))
// modelUSART12

/** 0x4000 4900 USART12_CTLR **/
union USART12_CTLR_REG{
	unsigned int reg;
	struct USART12_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_CTLR (*((volatile union USART12_CTLR_REG *)0x40004900))
// model

/** 0x4000 4904 USART12_BRGR **/
union USART12_BRGR_REG{
	unsigned int reg;
	struct USART12_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_BRGR (*((volatile union USART12_BRGR_REG *)0x40004904))
// model

/** 0x4000 4908 USART12_STR **/
union USART12_STR_REG{
	unsigned int reg;
	struct USART12_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_STR (*((volatile union USART12_STR_REG *)0x40004908))
// model

/** 0x4000 490C USART12_TBUFR **/
union USART12_TBUFR_REG{
	unsigned int reg;
	struct USART12_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_TBUFR (*((volatile union USART12_TBUFR_REG *)0x4000490C))
// model

/** 0x4000 490C USART12_RBUFR **/
union USART12_RBUFR_REG{
	unsigned int reg;
	struct USART12_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_RBUFR (*((volatile union USART12_RBUFR_REG *)0x4000490C))
// model

/** 0x4000 4914 USART12_IER **/
union USART12_IER_REG{
	unsigned int reg;
	struct USART12_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_IER (*((volatile union USART12_IER_REG *)0x40004914))
// model

/** 0x4000 4918 USART12_ADM **/
union USART12_ADM_REG{
	unsigned int reg;
	struct USART12_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART12_ADM (*((volatile union USART12_ADM_REG *)0x40004918))
// modelUSART13

/** 0x4000 4980 USART13_CTLR **/
union USART13_CTLR_REG{
	unsigned int reg;
	struct USART13_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_CTLR (*((volatile union USART13_CTLR_REG *)0x40004980))
// model

/** 0x4000 4984 USART13_BRGR **/
union USART13_BRGR_REG{
	unsigned int reg;
	struct USART13_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_BRGR (*((volatile union USART13_BRGR_REG *)0x40004984))
// model

/** 0x4000 4988 USART13_STR **/
union USART13_STR_REG{
	unsigned int reg;
	struct USART13_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_STR (*((volatile union USART13_STR_REG *)0x40004988))
// model

/** 0x4000 498C USART13_TBUFR **/
union USART13_TBUFR_REG{
	unsigned int reg;
	struct USART13_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_TBUFR (*((volatile union USART13_TBUFR_REG *)0x4000498C))
// model

/** 0x4000 498C USART13_RBUFR **/
union USART13_RBUFR_REG{
	unsigned int reg;
	struct USART13_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_RBUFR (*((volatile union USART13_RBUFR_REG *)0x4000498C))
// model

/** 0x4000 4994 USART13_IER **/
union USART13_IER_REG{
	unsigned int reg;
	struct USART13_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_IER (*((volatile union USART13_IER_REG *)0x40004994))
// model

/** 0x4000 4998 USART13_ADM **/
union USART13_ADM_REG{
	unsigned int reg;
	struct USART13_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART13_ADM (*((volatile union USART13_ADM_REG *)0x40004998))
// modelUSART14

/** 0x4000 5680 USART14_CTLR **/
union USART14_CTLR_REG{
	unsigned int reg;
	struct USART14_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_CTLR (*((volatile union USART14_CTLR_REG *)0x40005680))
// model

/** 0x4000 5684 USART14_BRGR **/
union USART14_BRGR_REG{
	unsigned int reg;
	struct USART14_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_BRGR (*((volatile union USART14_BRGR_REG *)0x40005684))
// model

/** 0x4000 5688 USART14_STR **/
union USART14_STR_REG{
	unsigned int reg;
	struct USART14_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_STR (*((volatile union USART14_STR_REG *)0x40005688))
// model

/** 0x4000 568C USART14_TBUFR **/
union USART14_TBUFR_REG{
	unsigned int reg;
	struct USART14_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_TBUFR (*((volatile union USART14_TBUFR_REG *)0x4000568C))
// model

/** 0x4000 568C USART14_RBUFR **/
union USART14_RBUFR_REG{
	unsigned int reg;
	struct USART14_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_RBUFR (*((volatile union USART14_RBUFR_REG *)0x4000568C))
// model

/** 0x4000 5694 USART14_IER **/
union USART14_IER_REG{
	unsigned int reg;
	struct USART14_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_IER (*((volatile union USART14_IER_REG *)0x40005694))
// model

/** 0x4000 5698 USART14_ADM **/
union USART14_ADM_REG{
	unsigned int reg;
	struct USART14_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART14_ADM (*((volatile union USART14_ADM_REG *)0x40005698))
// modelUSART15

/** 0x4000 5700 USART15_CTLR **/
union USART15_CTLR_REG{
	unsigned int reg;
	struct USART15_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLEIS:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :2;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_CTLR (*((volatile union USART15_CTLR_REG *)0x40005700))
// model

/** 0x4000 5704 USART15_BRGR **/
union USART15_BRGR_REG{
	unsigned int reg;
	struct USART15_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_BRGR (*((volatile union USART15_BRGR_REG *)0x40005704))
// model

/** 0x4000 5708 USART15_STR **/
union USART15_STR_REG{
	unsigned int reg;
	struct USART15_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TXSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_STR (*((volatile union USART15_STR_REG *)0x40005708))
// model

/** 0x4000 570C USART15_TBUFR **/
union USART15_TBUFR_REG{
	unsigned int reg;
	struct USART15_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_TBUFR (*((volatile union USART15_TBUFR_REG *)0x4000570C))
// model

/** 0x4000 570C USART15_RBUFR **/
union USART15_RBUFR_REG{
	unsigned int reg;
	struct USART15_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_RBUFR (*((volatile union USART15_RBUFR_REG *)0x4000570C))
// model

/** 0x4000 5714 USART15_IER **/
union USART15_IER_REG{
	unsigned int reg;
	struct USART15_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_IER (*((volatile union USART15_IER_REG *)0x40005714))
// model

/** 0x4000 5718 USART15_ADM **/
union USART15_ADM_REG{
	unsigned int reg;
	struct USART15_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART15_ADM (*((volatile union USART15_ADM_REG *)0x40005718))
// modelSPI0

/** 0x4000 0C00 SPI0_BRGR **/
union SPI0_BRGR_REG{
	unsigned int reg;
	struct SPI0_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BRGR (*((volatile union SPI0_BRGR_REG *)0x40000C00))
// model

/** 0x4000 0C04 SPI0_CTLR **/
union SPI0_CTLR_REG{
	unsigned int reg;
	struct SPI0_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMOD:1;
		unsigned int _SMINS:1;
		unsigned int _MCKOS:1;
		unsigned int _SPIPRCS:1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_CTLR (*((volatile union SPI0_CTLR_REG *)0x40000C04))
// model

/** 0x4000 0C08 SPI0_BUFR **/
union SPI0_BUFR_REG{
	unsigned int reg;
	struct SPI0_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BUFR (*((volatile union SPI0_BUFR_REG *)0x40000C08))
// model

/** 0x4000 0C0C SPI0_STR **/
union SPI0_STR_REG{
	unsigned int reg;
	struct SPI0_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int _TSTOP:1;
		unsigned int :2;
		unsigned int _TSTOPIE:1;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int _TSTOPIC:1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_STR (*((volatile union SPI0_STR_REG *)0x40000C0C))
// modelSPI1

/** 0x4000 0C80 SPI1_BRGR **/
union SPI1_BRGR_REG{
	unsigned int reg;
	struct SPI1_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BRGR (*((volatile union SPI1_BRGR_REG *)0x40000C80))
// model

/** 0x4000 0C84 SPI1_CTLR **/
union SPI1_CTLR_REG{
	unsigned int reg;
	struct SPI1_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMOD:1;
		unsigned int _SMINS:1;
		unsigned int _MCKOS:1;
		unsigned int _SPIPRCS:1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_CTLR (*((volatile union SPI1_CTLR_REG *)0x40000C84))
// model

/** 0x4000 0C88 SPI1_BUFR **/
union SPI1_BUFR_REG{
	unsigned int reg;
	struct SPI1_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BUFR (*((volatile union SPI1_BUFR_REG *)0x40000C88))
// model

/** 0x4000 0C8C SPI1_STR **/
union SPI1_STR_REG{
	unsigned int reg;
	struct SPI1_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int _TSTOP:1;
		unsigned int :2;
		unsigned int _TSTOPIE:1;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int _TSTOPIC:1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_STR (*((volatile union SPI1_STR_REG *)0x40000C8C))
// modelSPI2

/** 0x4000 2080 SPI2_BRGR **/
union SPI2_BRGR_REG{
	unsigned int reg;
	struct SPI2_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_BRGR (*((volatile union SPI2_BRGR_REG *)0x40002080))
// model

/** 0x4000 2084 SPI2_CTLR **/
union SPI2_CTLR_REG{
	unsigned int reg;
	struct SPI2_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMOD:1;
		unsigned int _SMINS:1;
		unsigned int _MCKOS:1;
		unsigned int _SPIPRCS:1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_CTLR (*((volatile union SPI2_CTLR_REG *)0x40002084))
// model

/** 0x4000 2088 SPI2_BUFR **/
union SPI2_BUFR_REG{
	unsigned int reg;
	struct SPI2_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_BUFR (*((volatile union SPI2_BUFR_REG *)0x40002088))
// model

/** 0x4000 208C SPI2_STR **/
union SPI2_STR_REG{
	unsigned int reg;
	struct SPI2_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int _TSTOP:1;
		unsigned int :2;
		unsigned int _TSTOPIE:1;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int _TSTOPIC:1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_STR (*((volatile union SPI2_STR_REG *)0x4000208C))
// modelSPI3

/** 0x4000 2100 SPI3_BRGR **/
union SPI3_BRGR_REG{
	unsigned int reg;
	struct SPI3_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_BRGR (*((volatile union SPI3_BRGR_REG *)0x40002100))
// model

/** 0x4000 2104 SPI3_CTLR **/
union SPI3_CTLR_REG{
	unsigned int reg;
	struct SPI3_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMOD:1;
		unsigned int _SMINS:1;
		unsigned int _MCKOS:1;
		unsigned int _SPIPRCS:1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_CTLR (*((volatile union SPI3_CTLR_REG *)0x40002104))
// model

/** 0x4000 2108 SPI3_BUFR **/
union SPI3_BUFR_REG{
	unsigned int reg;
	struct SPI3_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_BUFR (*((volatile union SPI3_BUFR_REG *)0x40002108))
// model

/** 0x4000 210C SPI3_STR **/
union SPI3_STR_REG{
	unsigned int reg;
	struct SPI3_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int _TSTOP:1;
		unsigned int :2;
		unsigned int _TSTOPIE:1;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int _TSTOPIC:1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_STR (*((volatile union SPI3_STR_REG *)0x4000210C))
// modelI2C0

/** 0x4000 0D00 I2C0_CTLR **/
union I2C0_CTLR_REG{
	unsigned int reg;
	struct I2C0_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _MENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_CTLR (*((volatile union I2C0_CTLR_REG *)0x40000D00))
// model

/** 0x4000 0D04 I2C0_SR **/
union I2C0_SR_REG{
	unsigned int reg;
	struct I2C0_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :1;
		unsigned int _BLTF:1;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_SR (*((volatile union I2C0_SR_REG *)0x40000D04))
// model

/** 0x4000 0D08 I2C0_BUFR **/
union I2C0_BUFR_REG{
	unsigned int reg;
	struct I2C0_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BUFR (*((volatile union I2C0_BUFR_REG *)0x40000D08))
// model

/** 0x4000 0D0C I2C0_ADDR0 **/
union I2C0_ADDR0_REG{
	unsigned int reg;
	struct I2C0_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR0 (*((volatile union I2C0_ADDR0_REG *)0x40000D0C))
// model

/** 0x4000 0D10 I2C0_BRGR **/
union I2C0_BRGR_REG{
	unsigned int reg;
	struct I2C0_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BRGR (*((volatile union I2C0_BRGR_REG *)0x40000D10))
// model

/** 0x4000 0D14 I2C0_ADDR1 **/
union I2C0_ADDR1_REG{
	unsigned int reg;
	struct I2C0_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR1 (*((volatile union I2C0_ADDR1_REG *)0x40000D14))
// model

/** 0x4000 0D18 I2C0_ADDR2 **/
union I2C0_ADDR2_REG{
	unsigned int reg;
	struct I2C0_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR2 (*((volatile union I2C0_ADDR2_REG *)0x40000D18))
// model

/** 0x4000 0D1C I2C0_ADDR3 **/
union I2C0_ADDR3_REG{
	unsigned int reg;
	struct I2C0_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR3 (*((volatile union I2C0_ADDR3_REG *)0x40000D1C))
// model

/** 0x4000 0D20 I2C0_IER **/
union I2C0_IER_REG{
	unsigned int reg;
	struct I2C0_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :2;
		unsigned int _BUSYIC:1;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :2;
		unsigned int _SDATEN:1;
		unsigned int _BLTIE:1;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int _BUSLOW:12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_IER (*((volatile union I2C0_IER_REG *)0x40000D20))
// model

/** 0x4000 0D28 I2C0_FILTER **/
union I2C0_FILTER_REG{
	unsigned int reg;
	struct I2C0_FILTER_BITS{
		unsigned int _SDAFEN:1;
		unsigned int _SDAFDIV:4;
		unsigned int _SDAFDELAY:3;
		unsigned int _SCLFEN:1;
		unsigned int _SCLFDIV:4;
		unsigned int _SCLFDELAY:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_FILTER (*((volatile union I2C0_FILTER_REG *)0x40000D28))
// modelI2C1

/** 0x4000 0D80 I2C1_CTLR **/
union I2C1_CTLR_REG{
	unsigned int reg;
	struct I2C1_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _MENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_CTLR (*((volatile union I2C1_CTLR_REG *)0x40000D80))
// model

/** 0x4000 0D84 I2C1_SR **/
union I2C1_SR_REG{
	unsigned int reg;
	struct I2C1_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :1;
		unsigned int _BLTF:1;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_SR (*((volatile union I2C1_SR_REG *)0x40000D84))
// model

/** 0x4000 0D88 I2C1_BUFR **/
union I2C1_BUFR_REG{
	unsigned int reg;
	struct I2C1_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BUFR (*((volatile union I2C1_BUFR_REG *)0x40000D88))
// model

/** 0x4000 0D8C I2C1_ADDR0 **/
union I2C1_ADDR0_REG{
	unsigned int reg;
	struct I2C1_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR0 (*((volatile union I2C1_ADDR0_REG *)0x40000D8C))
// model

/** 0x4000 0D90 I2C1_BRGR **/
union I2C1_BRGR_REG{
	unsigned int reg;
	struct I2C1_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BRGR (*((volatile union I2C1_BRGR_REG *)0x40000D90))
// model

/** 0x4000 0D94 I2C1_ADDR1 **/
union I2C1_ADDR1_REG{
	unsigned int reg;
	struct I2C1_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR1 (*((volatile union I2C1_ADDR1_REG *)0x40000D94))
// model

/** 0x4000 0D98 I2C1_ADDR2 **/
union I2C1_ADDR2_REG{
	unsigned int reg;
	struct I2C1_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR2 (*((volatile union I2C1_ADDR2_REG *)0x40000D98))
// model

/** 0x4000 0D9C I2C1_ADDR3 **/
union I2C1_ADDR3_REG{
	unsigned int reg;
	struct I2C1_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR3 (*((volatile union I2C1_ADDR3_REG *)0x40000D9C))
// model

/** 0x4000 0DA0 I2C1_IER **/
union I2C1_IER_REG{
	unsigned int reg;
	struct I2C1_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :2;
		unsigned int _BUSYIC:1;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :2;
		unsigned int _SDATEN:1;
		unsigned int _BLTIE:1;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int _BUSLOW:12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_IER (*((volatile union I2C1_IER_REG *)0x40000DA0))
// model

/** 0x4000 0DA8 I2C1_FILTER **/
union I2C1_FILTER_REG{
	unsigned int reg;
	struct I2C1_FILTER_BITS{
		unsigned int _SDAFEN:1;
		unsigned int _SDAFDIV:4;
		unsigned int _SDAFDELAY:3;
		unsigned int _SCLFEN:1;
		unsigned int _SCLFDIV:4;
		unsigned int _SCLFDELAY:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_FILTER (*((volatile union I2C1_FILTER_REG *)0x40000DA8))
// modelI2C2

/** 0x4000 0E00 I2C2_CTLR **/
union I2C2_CTLR_REG{
	unsigned int reg;
	struct I2C2_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _MENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_CTLR (*((volatile union I2C2_CTLR_REG *)0x40000E00))
// model

/** 0x4000 0E04 I2C2_SR **/
union I2C2_SR_REG{
	unsigned int reg;
	struct I2C2_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :1;
		unsigned int _BLTF:1;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_SR (*((volatile union I2C2_SR_REG *)0x40000E04))
// model

/** 0x4000 0E08 I2C2_BUFR **/
union I2C2_BUFR_REG{
	unsigned int reg;
	struct I2C2_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_BUFR (*((volatile union I2C2_BUFR_REG *)0x40000E08))
// model

/** 0x4000 0E0C I2C2_ADDR0 **/
union I2C2_ADDR0_REG{
	unsigned int reg;
	struct I2C2_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR0 (*((volatile union I2C2_ADDR0_REG *)0x40000E0C))
// model

/** 0x4000 0E10 I2C2_BRGR **/
union I2C2_BRGR_REG{
	unsigned int reg;
	struct I2C2_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_BRGR (*((volatile union I2C2_BRGR_REG *)0x40000E10))
// model

/** 0x4000 0E14 I2C2_ADDR1 **/
union I2C2_ADDR1_REG{
	unsigned int reg;
	struct I2C2_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR1 (*((volatile union I2C2_ADDR1_REG *)0x40000E14))
// model

/** 0x4000 0E18 I2C2_ADDR2 **/
union I2C2_ADDR2_REG{
	unsigned int reg;
	struct I2C2_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR2 (*((volatile union I2C2_ADDR2_REG *)0x40000E18))
// model

/** 0x4000 0E1C I2C2_ADDR3 **/
union I2C2_ADDR3_REG{
	unsigned int reg;
	struct I2C2_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR3 (*((volatile union I2C2_ADDR3_REG *)0x40000E1C))
// model

/** 0x4000 0E20 I2C2_IER **/
union I2C2_IER_REG{
	unsigned int reg;
	struct I2C2_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :2;
		unsigned int _BUSYIC:1;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :2;
		unsigned int _SDATEN:1;
		unsigned int _BLTIE:1;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int _BUSLOW:12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_IER (*((volatile union I2C2_IER_REG *)0x40000E20))
// model

/** 0x4000 0E28 I2C2_FILTER **/
union I2C2_FILTER_REG{
	unsigned int reg;
	struct I2C2_FILTER_BITS{
		unsigned int _SDAFEN:1;
		unsigned int _SDAFDIV:4;
		unsigned int _SDAFDELAY:3;
		unsigned int _SCLFEN:1;
		unsigned int _SCLFDIV:4;
		unsigned int _SCLFDELAY:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_FILTER (*((volatile union I2C2_FILTER_REG *)0x40000E28))
// modelI2C3

/** 0x4000 2380 I2C3_CTLR **/
union I2C3_CTLR_REG{
	unsigned int reg;
	struct I2C3_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int :1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _MENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_CTLR (*((volatile union I2C3_CTLR_REG *)0x40002380))
// model

/** 0x4000 2384 I2C3_SR **/
union I2C3_SR_REG{
	unsigned int reg;
	struct I2C3_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :1;
		unsigned int _BLTF:1;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_SR (*((volatile union I2C3_SR_REG *)0x40002384))
// model

/** 0x4000 2388 I2C3_BUFR **/
union I2C3_BUFR_REG{
	unsigned int reg;
	struct I2C3_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_BUFR (*((volatile union I2C3_BUFR_REG *)0x40002388))
// model

/** 0x4000 238C I2C3_ADDR0 **/
union I2C3_ADDR0_REG{
	unsigned int reg;
	struct I2C3_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR0 (*((volatile union I2C3_ADDR0_REG *)0x4000238C))
// model

/** 0x4000 2390 I2C3_BRGR **/
union I2C3_BRGR_REG{
	unsigned int reg;
	struct I2C3_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_BRGR (*((volatile union I2C3_BRGR_REG *)0x40002390))
// model

/** 0x4000 2394 I2C3_ADDR1 **/
union I2C3_ADDR1_REG{
	unsigned int reg;
	struct I2C3_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR1 (*((volatile union I2C3_ADDR1_REG *)0x40002394))
// model

/** 0x4000 2398 I2C3_ADDR2 **/
union I2C3_ADDR2_REG{
	unsigned int reg;
	struct I2C3_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR2 (*((volatile union I2C3_ADDR2_REG *)0x40002398))
// model

/** 0x4000 239C I2C3_ADDR3 **/
union I2C3_ADDR3_REG{
	unsigned int reg;
	struct I2C3_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR3 (*((volatile union I2C3_ADDR3_REG *)0x4000239C))
// model

/** 0x4000 23A0 I2C3_IER **/
union I2C3_IER_REG{
	unsigned int reg;
	struct I2C3_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :2;
		unsigned int _BUSYIC:1;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :2;
		unsigned int _SDATEN:1;
		unsigned int _BLTIE:1;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int _BUSLOW:12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_IER (*((volatile union I2C3_IER_REG *)0x400023A0))
// model

/** 0x4000 23A8 I2C3_FILTER **/
union I2C3_FILTER_REG{
	unsigned int reg;
	struct I2C3_FILTER_BITS{
		unsigned int _SDAFEN:1;
		unsigned int _SDAFDIV:4;
		unsigned int _SDAFDELAY:3;
		unsigned int _SCLFEN:1;
		unsigned int _SCLFDIV:4;
		unsigned int _SCLFDELAY:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_FILTER (*((volatile union I2C3_FILTER_REG *)0x400023A8))
// modelCANFD6

/** 0x4000 2E00 CANFD6_CTLR0 **/
union CANFD6_CTLR0_REG{
	unsigned int reg;
	struct CANFD6_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CTLR0 (*((volatile union CANFD6_CTLR0_REG *)0x40002E00))
// model

/** 0x4000 2E04 CANFD6_BRGR **/
union CANFD6_BRGR_REG{
	unsigned int reg;
	struct CANFD6_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_BRGR (*((volatile union CANFD6_BRGR_REG *)0x40002E04))
// model

/** 0x4000 2EF4 CANFD6_BRGR1 **/
union CANFD6_BRGR1_REG{
	unsigned int reg;
	struct CANFD6_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_BRGR1 (*((volatile union CANFD6_BRGR1_REG *)0x40002EF4))
// model

/** 0x4000 2E08 CANFD6_RCR **/
union CANFD6_RCR_REG{
	unsigned int reg;
	struct CANFD6_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RCR (*((volatile union CANFD6_RCR_REG *)0x40002E08))
// model

/** 0x4000 2E0C CANFD6_EROR **/
union CANFD6_EROR_REG{
	unsigned int reg;
	struct CANFD6_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_EROR (*((volatile union CANFD6_EROR_REG *)0x40002E0C))
// model

/** 0x4000 2E10 CANFD6_CTLR2 **/
union CANFD6_CTLR2_REG{
	unsigned int reg;
	struct CANFD6_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CTLR2 (*((volatile union CANFD6_CTLR2_REG *)0x40002E10))
// model

/** 0x4000 2E14 CANFD6_MSKR **/
union CANFD6_MSKR_REG{
	unsigned int reg;
	struct CANFD6_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_MSKR (*((volatile union CANFD6_MSKR_REG *)0x40002E14))
// model

/** 0x4000 2E18 CANFD6_IER **/
union CANFD6_IER_REG{
	unsigned int reg;
	struct CANFD6_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_IER (*((volatile union CANFD6_IER_REG *)0x40002E18))
// model

/** 0x4000 2E1C CANFD6_IFR **/
union CANFD6_IFR_REG{
	unsigned int reg;
	struct CANFD6_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_IFR (*((volatile union CANFD6_IFR_REG *)0x40002E1C))
// model

/** 0x4000 2E20 CANFD6_RXDATA0 **/
union CANFD6_RXDATA0_REG{
	unsigned int reg;
	struct CANFD6_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA0 (*((volatile union CANFD6_RXDATA0_REG *)0x40002E20))
// model

/** 0x4000 2E24 CANFD6_RXDATA1 **/
union CANFD6_RXDATA1_REG{
	unsigned int reg;
	struct CANFD6_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA1 (*((volatile union CANFD6_RXDATA1_REG *)0x40002E24))
// model

/** 0x4000 2E28 CANFD6_RXDATA2 **/
union CANFD6_RXDATA2_REG{
	unsigned int reg;
	struct CANFD6_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA2 (*((volatile union CANFD6_RXDATA2_REG *)0x40002E28))
// model

/** 0x4000 2E2C CANFD6_RXDATA3 **/
union CANFD6_RXDATA3_REG{
	unsigned int reg;
	struct CANFD6_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA3 (*((volatile union CANFD6_RXDATA3_REG *)0x40002E2C))
// model

/** 0x4000 2E30 CANFD6_RXDATA4 **/
union CANFD6_RXDATA4_REG{
	unsigned int reg;
	struct CANFD6_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA4 (*((volatile union CANFD6_RXDATA4_REG *)0x40002E30))
// model

/** 0x4000 2E34 CANFD6_RXDATA5 **/
union CANFD6_RXDATA5_REG{
	unsigned int reg;
	struct CANFD6_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA5 (*((volatile union CANFD6_RXDATA5_REG *)0x40002E34))
// model

/** 0x4000 2E38 CANFD6_RXDATA6 **/
union CANFD6_RXDATA6_REG{
	unsigned int reg;
	struct CANFD6_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA6 (*((volatile union CANFD6_RXDATA6_REG *)0x40002E38))
// model

/** 0x4000 2E3C CANFD6_RXDATA7 **/
union CANFD6_RXDATA7_REG{
	unsigned int reg;
	struct CANFD6_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA7 (*((volatile union CANFD6_RXDATA7_REG *)0x40002E3C))
// model

/** 0x4000 2E40 CANFD6_RXDATA8 **/
union CANFD6_RXDATA8_REG{
	unsigned int reg;
	struct CANFD6_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA8 (*((volatile union CANFD6_RXDATA8_REG *)0x40002E40))
// model

/** 0x4000 2E44 CANFD6_RXDATA9 **/
union CANFD6_RXDATA9_REG{
	unsigned int reg;
	struct CANFD6_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA9 (*((volatile union CANFD6_RXDATA9_REG *)0x40002E44))
// model

/** 0x4000 2E48 CANFD6_RXDATA10 **/
union CANFD6_RXDATA10_REG{
	unsigned int reg;
	struct CANFD6_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA10 (*((volatile union CANFD6_RXDATA10_REG *)0x40002E48))
// model

/** 0x4000 2E4C CANFD6_RXDATA11 **/
union CANFD6_RXDATA11_REG{
	unsigned int reg;
	struct CANFD6_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA11 (*((volatile union CANFD6_RXDATA11_REG *)0x40002E4C))
// model

/** 0x4000 2E50 CANFD6_RXDATA12 **/
union CANFD6_RXDATA12_REG{
	unsigned int reg;
	struct CANFD6_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA12 (*((volatile union CANFD6_RXDATA12_REG *)0x40002E50))
// model

/** 0x4000 2E54 CANFD6_RXDATA13 **/
union CANFD6_RXDATA13_REG{
	unsigned int reg;
	struct CANFD6_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA13 (*((volatile union CANFD6_RXDATA13_REG *)0x40002E54))
// model

/** 0x4000 2E58 CANFD6_RXDATA14 **/
union CANFD6_RXDATA14_REG{
	unsigned int reg;
	struct CANFD6_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA14 (*((volatile union CANFD6_RXDATA14_REG *)0x40002E58))
// model

/** 0x4000 2E5C CANFD6_RXDATA15 **/
union CANFD6_RXDATA15_REG{
	unsigned int reg;
	struct CANFD6_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA15 (*((volatile union CANFD6_RXDATA15_REG *)0x40002E5C))
// model

/** 0x4000 2E60 CANFD6_RXDATA16 **/
union CANFD6_RXDATA16_REG{
	unsigned int reg;
	struct CANFD6_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA16 (*((volatile union CANFD6_RXDATA16_REG *)0x40002E60))
// model

/** 0x4000 2E64 CANFD6_RXDATA17 **/
union CANFD6_RXDATA17_REG{
	unsigned int reg;
	struct CANFD6_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA17 (*((volatile union CANFD6_RXDATA17_REG *)0x40002E64))
// model

/** 0x4000 2E68 CANFD6_TIMER **/
union CANFD6_TIMER_REG{
	unsigned int reg;
	struct CANFD6_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TIMER (*((volatile union CANFD6_TIMER_REG *)0x40002E68))
// model

/** 0x4000 2E6C CANFD6_CRC **/
union CANFD6_CRC_REG{
	unsigned int reg;
	struct CANFD6_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CRC (*((volatile union CANFD6_CRC_REG *)0x40002E6C))
// model

/** 0x4000 2E74 CANFD6_CTLR1 **/
union CANFD6_CTLR1_REG{
	unsigned int reg;
	struct CANFD6_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CTLR1 (*((volatile union CANFD6_CTLR1_REG *)0x40002E74))
// model

/** 0x4000 2E78 CANFD6_AMSTA **/
union CANFD6_AMSTA_REG{
	unsigned int reg;
	struct CANFD6_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_AMSTA (*((volatile union CANFD6_AMSTA_REG *)0x40002E78))
// model

/** 0x4000 2E80 CANFD6_TXDATA0 **/
union CANFD6_TXDATA0_REG{
	unsigned int reg;
	struct CANFD6_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA0 (*((volatile union CANFD6_TXDATA0_REG *)0x40002E80))
// model

/** 0x4000 2E84 CANFD6_TXDATA1 **/
union CANFD6_TXDATA1_REG{
	unsigned int reg;
	struct CANFD6_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA1 (*((volatile union CANFD6_TXDATA1_REG *)0x40002E84))
// model

/** 0x4000 2E88 CANFD6_TXDATA2 **/
union CANFD6_TXDATA2_REG{
	unsigned int reg;
	struct CANFD6_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA2 (*((volatile union CANFD6_TXDATA2_REG *)0x40002E88))
// model

/** 0x4000 2E8C CANFD6_TXDATA3 **/
union CANFD6_TXDATA3_REG{
	unsigned int reg;
	struct CANFD6_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA3 (*((volatile union CANFD6_TXDATA3_REG *)0x40002E8C))
// model

/** 0x4000 2E90 CANFD6_TXDATA4 **/
union CANFD6_TXDATA4_REG{
	unsigned int reg;
	struct CANFD6_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA4 (*((volatile union CANFD6_TXDATA4_REG *)0x40002E90))
// model

/** 0x4000 2E94 CANFD6_TXDATA5 **/
union CANFD6_TXDATA5_REG{
	unsigned int reg;
	struct CANFD6_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA5 (*((volatile union CANFD6_TXDATA5_REG *)0x40002E94))
// model

/** 0x4000 2E98 CANFD6_TXDATA6 **/
union CANFD6_TXDATA6_REG{
	unsigned int reg;
	struct CANFD6_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA6 (*((volatile union CANFD6_TXDATA6_REG *)0x40002E98))
// model

/** 0x4000 2E9C CANFD6_TXDATA7 **/
union CANFD6_TXDATA7_REG{
	unsigned int reg;
	struct CANFD6_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA7 (*((volatile union CANFD6_TXDATA7_REG *)0x40002E9C))
// model

/** 0x4000 2EA0 CANFD6_TXDATA8 **/
union CANFD6_TXDATA8_REG{
	unsigned int reg;
	struct CANFD6_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA8 (*((volatile union CANFD6_TXDATA8_REG *)0x40002EA0))
// model

/** 0x4000 2EA4 CANFD6_TXDATA9 **/
union CANFD6_TXDATA9_REG{
	unsigned int reg;
	struct CANFD6_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA9 (*((volatile union CANFD6_TXDATA9_REG *)0x40002EA4))
// model

/** 0x4000 2EA8 CANFD6_TXDATA10 **/
union CANFD6_TXDATA10_REG{
	unsigned int reg;
	struct CANFD6_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA10 (*((volatile union CANFD6_TXDATA10_REG *)0x40002EA8))
// model

/** 0x4000 2EAC CANFD6_TXDATA11 **/
union CANFD6_TXDATA11_REG{
	unsigned int reg;
	struct CANFD6_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA11 (*((volatile union CANFD6_TXDATA11_REG *)0x40002EAC))
// model

/** 0x4000 2EB0 CANFD6_TXDATA12 **/
union CANFD6_TXDATA12_REG{
	unsigned int reg;
	struct CANFD6_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA12 (*((volatile union CANFD6_TXDATA12_REG *)0x40002EB0))
// model

/** 0x4000 2EB4 CANFD6_TXDATA13 **/
union CANFD6_TXDATA13_REG{
	unsigned int reg;
	struct CANFD6_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA13 (*((volatile union CANFD6_TXDATA13_REG *)0x40002EB4))
// model

/** 0x4000 2EB8 CANFD6_TXDATA14 **/
union CANFD6_TXDATA14_REG{
	unsigned int reg;
	struct CANFD6_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA14 (*((volatile union CANFD6_TXDATA14_REG *)0x40002EB8))
// model

/** 0x4000 2EBC CANFD6_TXDATA15 **/
union CANFD6_TXDATA15_REG{
	unsigned int reg;
	struct CANFD6_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA15 (*((volatile union CANFD6_TXDATA15_REG *)0x40002EBC))
// model

/** 0x4000 2EC0 CANFD6_TXDATA16 **/
union CANFD6_TXDATA16_REG{
	unsigned int reg;
	struct CANFD6_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA16 (*((volatile union CANFD6_TXDATA16_REG *)0x40002EC0))
// model

/** 0x4000 2EC4 CANFD6_TXDATA17 **/
union CANFD6_TXDATA17_REG{
	unsigned int reg;
	struct CANFD6_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA17 (*((volatile union CANFD6_TXDATA17_REG *)0x40002EC4))
// model

/** 0x4000 2EE0 CANFD6_CONFIGREG **/
union CANFD6_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD6_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CONFIGREG (*((volatile union CANFD6_CONFIGREG_REG *)0x40002EE0))
// model

/** 0x4000 2EE4 CANFD6_TRSTA0 **/
union CANFD6_TRSTA0_REG{
	unsigned int reg;
	struct CANFD6_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TRSTA0 (*((volatile union CANFD6_TRSTA0_REG *)0x40002EE4))
// model

/** 0x4000 2EE8 CANFD6_TRSTA1 **/
union CANFD6_TRSTA1_REG{
	unsigned int reg;
	struct CANFD6_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TRSTA1 (*((volatile union CANFD6_TRSTA1_REG *)0x40002EE8))
// model

/** 0x4000 2EEC CANFD6_RESTA0 **/
union CANFD6_RESTA0_REG{
	unsigned int reg;
	struct CANFD6_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RESTA0 (*((volatile union CANFD6_RESTA0_REG *)0x40002EEC))
// model

/** 0x4000 2EF0 CANFD6_RESTA1 **/
union CANFD6_RESTA1_REG{
	unsigned int reg;
	struct CANFD6_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RESTA1 (*((volatile union CANFD6_RESTA1_REG *)0x40002EF0))
// modelCANFD7

/** 0x4000 3000 CANFD7_CTLR0 **/
union CANFD7_CTLR0_REG{
	unsigned int reg;
	struct CANFD7_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CTLR0 (*((volatile union CANFD7_CTLR0_REG *)0x40003000))
// model

/** 0x4000 3004 CANFD7_BRGR **/
union CANFD7_BRGR_REG{
	unsigned int reg;
	struct CANFD7_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_BRGR (*((volatile union CANFD7_BRGR_REG *)0x40003004))
// model

/** 0x4000 30F4 CANFD7_BRGR1 **/
union CANFD7_BRGR1_REG{
	unsigned int reg;
	struct CANFD7_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_BRGR1 (*((volatile union CANFD7_BRGR1_REG *)0x400030F4))
// model

/** 0x4000 3008 CANFD7_RCR **/
union CANFD7_RCR_REG{
	unsigned int reg;
	struct CANFD7_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RCR (*((volatile union CANFD7_RCR_REG *)0x40003008))
// model

/** 0x4000 300C CANFD7_EROR **/
union CANFD7_EROR_REG{
	unsigned int reg;
	struct CANFD7_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_EROR (*((volatile union CANFD7_EROR_REG *)0x4000300C))
// model

/** 0x4000 3010 CANFD7_CTLR2 **/
union CANFD7_CTLR2_REG{
	unsigned int reg;
	struct CANFD7_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CTLR2 (*((volatile union CANFD7_CTLR2_REG *)0x40003010))
// model

/** 0x4000 3014 CANFD7_MSKR **/
union CANFD7_MSKR_REG{
	unsigned int reg;
	struct CANFD7_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_MSKR (*((volatile union CANFD7_MSKR_REG *)0x40003014))
// model

/** 0x4000 3018 CANFD7_IER **/
union CANFD7_IER_REG{
	unsigned int reg;
	struct CANFD7_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_IER (*((volatile union CANFD7_IER_REG *)0x40003018))
// model

/** 0x4000 301C CANFD7_IFR **/
union CANFD7_IFR_REG{
	unsigned int reg;
	struct CANFD7_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_IFR (*((volatile union CANFD7_IFR_REG *)0x4000301C))
// model

/** 0x4000 3020 CANFD7_RXDATA0 **/
union CANFD7_RXDATA0_REG{
	unsigned int reg;
	struct CANFD7_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA0 (*((volatile union CANFD7_RXDATA0_REG *)0x40003020))
// model

/** 0x4000 3024 CANFD7_RXDATA1 **/
union CANFD7_RXDATA1_REG{
	unsigned int reg;
	struct CANFD7_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA1 (*((volatile union CANFD7_RXDATA1_REG *)0x40003024))
// model

/** 0x4000 3028 CANFD7_RXDATA2 **/
union CANFD7_RXDATA2_REG{
	unsigned int reg;
	struct CANFD7_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA2 (*((volatile union CANFD7_RXDATA2_REG *)0x40003028))
// model

/** 0x4000 302C CANFD7_RXDATA3 **/
union CANFD7_RXDATA3_REG{
	unsigned int reg;
	struct CANFD7_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA3 (*((volatile union CANFD7_RXDATA3_REG *)0x4000302C))
// model

/** 0x4000 3030 CANFD7_RXDATA4 **/
union CANFD7_RXDATA4_REG{
	unsigned int reg;
	struct CANFD7_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA4 (*((volatile union CANFD7_RXDATA4_REG *)0x40003030))
// model

/** 0x4000 3034 CANFD7_RXDATA5 **/
union CANFD7_RXDATA5_REG{
	unsigned int reg;
	struct CANFD7_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA5 (*((volatile union CANFD7_RXDATA5_REG *)0x40003034))
// model

/** 0x4000 3038 CANFD7_RXDATA6 **/
union CANFD7_RXDATA6_REG{
	unsigned int reg;
	struct CANFD7_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA6 (*((volatile union CANFD7_RXDATA6_REG *)0x40003038))
// model

/** 0x4000 303C CANFD7_RXDATA7 **/
union CANFD7_RXDATA7_REG{
	unsigned int reg;
	struct CANFD7_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA7 (*((volatile union CANFD7_RXDATA7_REG *)0x4000303C))
// model

/** 0x4000 3040 CANFD7_RXDATA8 **/
union CANFD7_RXDATA8_REG{
	unsigned int reg;
	struct CANFD7_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA8 (*((volatile union CANFD7_RXDATA8_REG *)0x40003040))
// model

/** 0x4000 3044 CANFD7_RXDATA9 **/
union CANFD7_RXDATA9_REG{
	unsigned int reg;
	struct CANFD7_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA9 (*((volatile union CANFD7_RXDATA9_REG *)0x40003044))
// model

/** 0x4000 3048 CANFD7_RXDATA10 **/
union CANFD7_RXDATA10_REG{
	unsigned int reg;
	struct CANFD7_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA10 (*((volatile union CANFD7_RXDATA10_REG *)0x40003048))
// model

/** 0x4000 304C CANFD7_RXDATA11 **/
union CANFD7_RXDATA11_REG{
	unsigned int reg;
	struct CANFD7_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA11 (*((volatile union CANFD7_RXDATA11_REG *)0x4000304C))
// model

/** 0x4000 3050 CANFD7_RXDATA12 **/
union CANFD7_RXDATA12_REG{
	unsigned int reg;
	struct CANFD7_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA12 (*((volatile union CANFD7_RXDATA12_REG *)0x40003050))
// model

/** 0x4000 3054 CANFD7_RXDATA13 **/
union CANFD7_RXDATA13_REG{
	unsigned int reg;
	struct CANFD7_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA13 (*((volatile union CANFD7_RXDATA13_REG *)0x40003054))
// model

/** 0x4000 3058 CANFD7_RXDATA14 **/
union CANFD7_RXDATA14_REG{
	unsigned int reg;
	struct CANFD7_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA14 (*((volatile union CANFD7_RXDATA14_REG *)0x40003058))
// model

/** 0x4000 305C CANFD7_RXDATA15 **/
union CANFD7_RXDATA15_REG{
	unsigned int reg;
	struct CANFD7_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA15 (*((volatile union CANFD7_RXDATA15_REG *)0x4000305C))
// model

/** 0x4000 3060 CANFD7_RXDATA16 **/
union CANFD7_RXDATA16_REG{
	unsigned int reg;
	struct CANFD7_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA16 (*((volatile union CANFD7_RXDATA16_REG *)0x40003060))
// model

/** 0x4000 3064 CANFD7_RXDATA17 **/
union CANFD7_RXDATA17_REG{
	unsigned int reg;
	struct CANFD7_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA17 (*((volatile union CANFD7_RXDATA17_REG *)0x40003064))
// model

/** 0x4000 3068 CANFD7_TIMER **/
union CANFD7_TIMER_REG{
	unsigned int reg;
	struct CANFD7_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TIMER (*((volatile union CANFD7_TIMER_REG *)0x40003068))
// model

/** 0x4000 306C CANFD7_CRC **/
union CANFD7_CRC_REG{
	unsigned int reg;
	struct CANFD7_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CRC (*((volatile union CANFD7_CRC_REG *)0x4000306C))
// model

/** 0x4000 3074 CANFD7_CTLR1 **/
union CANFD7_CTLR1_REG{
	unsigned int reg;
	struct CANFD7_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CTLR1 (*((volatile union CANFD7_CTLR1_REG *)0x40003074))
// model

/** 0x4000 3078 CANFD7_AMSTA **/
union CANFD7_AMSTA_REG{
	unsigned int reg;
	struct CANFD7_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_AMSTA (*((volatile union CANFD7_AMSTA_REG *)0x40003078))
// model

/** 0x4000 3080 CANFD7_TXDATA0 **/
union CANFD7_TXDATA0_REG{
	unsigned int reg;
	struct CANFD7_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA0 (*((volatile union CANFD7_TXDATA0_REG *)0x40003080))
// model

/** 0x4000 3084 CANFD7_TXDATA1 **/
union CANFD7_TXDATA1_REG{
	unsigned int reg;
	struct CANFD7_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA1 (*((volatile union CANFD7_TXDATA1_REG *)0x40003084))
// model

/** 0x4000 3088 CANFD7_TXDATA2 **/
union CANFD7_TXDATA2_REG{
	unsigned int reg;
	struct CANFD7_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA2 (*((volatile union CANFD7_TXDATA2_REG *)0x40003088))
// model

/** 0x4000 308C CANFD7_TXDATA3 **/
union CANFD7_TXDATA3_REG{
	unsigned int reg;
	struct CANFD7_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA3 (*((volatile union CANFD7_TXDATA3_REG *)0x4000308C))
// model

/** 0x4000 3090 CANFD7_TXDATA4 **/
union CANFD7_TXDATA4_REG{
	unsigned int reg;
	struct CANFD7_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA4 (*((volatile union CANFD7_TXDATA4_REG *)0x40003090))
// model

/** 0x4000 3094 CANFD7_TXDATA5 **/
union CANFD7_TXDATA5_REG{
	unsigned int reg;
	struct CANFD7_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA5 (*((volatile union CANFD7_TXDATA5_REG *)0x40003094))
// model

/** 0x4000 3098 CANFD7_TXDATA6 **/
union CANFD7_TXDATA6_REG{
	unsigned int reg;
	struct CANFD7_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA6 (*((volatile union CANFD7_TXDATA6_REG *)0x40003098))
// model

/** 0x4000 309C CANFD7_TXDATA7 **/
union CANFD7_TXDATA7_REG{
	unsigned int reg;
	struct CANFD7_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA7 (*((volatile union CANFD7_TXDATA7_REG *)0x4000309C))
// model

/** 0x4000 30A0 CANFD7_TXDATA8 **/
union CANFD7_TXDATA8_REG{
	unsigned int reg;
	struct CANFD7_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA8 (*((volatile union CANFD7_TXDATA8_REG *)0x400030A0))
// model

/** 0x4000 30A4 CANFD7_TXDATA9 **/
union CANFD7_TXDATA9_REG{
	unsigned int reg;
	struct CANFD7_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA9 (*((volatile union CANFD7_TXDATA9_REG *)0x400030A4))
// model

/** 0x4000 30A8 CANFD7_TXDATA10 **/
union CANFD7_TXDATA10_REG{
	unsigned int reg;
	struct CANFD7_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA10 (*((volatile union CANFD7_TXDATA10_REG *)0x400030A8))
// model

/** 0x4000 30AC CANFD7_TXDATA11 **/
union CANFD7_TXDATA11_REG{
	unsigned int reg;
	struct CANFD7_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA11 (*((volatile union CANFD7_TXDATA11_REG *)0x400030AC))
// model

/** 0x4000 30B0 CANFD7_TXDATA12 **/
union CANFD7_TXDATA12_REG{
	unsigned int reg;
	struct CANFD7_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA12 (*((volatile union CANFD7_TXDATA12_REG *)0x400030B0))
// model

/** 0x4000 30B4 CANFD7_TXDATA13 **/
union CANFD7_TXDATA13_REG{
	unsigned int reg;
	struct CANFD7_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA13 (*((volatile union CANFD7_TXDATA13_REG *)0x400030B4))
// model

/** 0x4000 30B8 CANFD7_TXDATA14 **/
union CANFD7_TXDATA14_REG{
	unsigned int reg;
	struct CANFD7_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA14 (*((volatile union CANFD7_TXDATA14_REG *)0x400030B8))
// model

/** 0x4000 30BC CANFD7_TXDATA15 **/
union CANFD7_TXDATA15_REG{
	unsigned int reg;
	struct CANFD7_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA15 (*((volatile union CANFD7_TXDATA15_REG *)0x400030BC))
// model

/** 0x4000 30C0 CANFD7_TXDATA16 **/
union CANFD7_TXDATA16_REG{
	unsigned int reg;
	struct CANFD7_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA16 (*((volatile union CANFD7_TXDATA16_REG *)0x400030C0))
// model

/** 0x4000 30C4 CANFD7_TXDATA17 **/
union CANFD7_TXDATA17_REG{
	unsigned int reg;
	struct CANFD7_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA17 (*((volatile union CANFD7_TXDATA17_REG *)0x400030C4))
// model

/** 0x4000 30E0 CANFD7_CONFIGREG **/
union CANFD7_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD7_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CONFIGREG (*((volatile union CANFD7_CONFIGREG_REG *)0x400030E0))
// model

/** 0x4000 30E4 CANFD7_TRSTA0 **/
union CANFD7_TRSTA0_REG{
	unsigned int reg;
	struct CANFD7_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TRSTA0 (*((volatile union CANFD7_TRSTA0_REG *)0x400030E4))
// model

/** 0x4000 30E8 CANFD7_TRSTA1 **/
union CANFD7_TRSTA1_REG{
	unsigned int reg;
	struct CANFD7_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TRSTA1 (*((volatile union CANFD7_TRSTA1_REG *)0x400030E8))
// model

/** 0x4000 30EC CANFD7_RESTA0 **/
union CANFD7_RESTA0_REG{
	unsigned int reg;
	struct CANFD7_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RESTA0 (*((volatile union CANFD7_RESTA0_REG *)0x400030EC))
// model

/** 0x4000 30F0 CANFD7_RESTA1 **/
union CANFD7_RESTA1_REG{
	unsigned int reg;
	struct CANFD7_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RESTA1 (*((volatile union CANFD7_RESTA1_REG *)0x400030F0))
// modelCANFD8

/** 0x4000 3B00 CANFD8_CTLR0 **/
union CANFD8_CTLR0_REG{
	unsigned int reg;
	struct CANFD8_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_CTLR0 (*((volatile union CANFD8_CTLR0_REG *)0x40003B00))
// model

/** 0x4000 3B04 CANFD8_BRGR **/
union CANFD8_BRGR_REG{
	unsigned int reg;
	struct CANFD8_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_BRGR (*((volatile union CANFD8_BRGR_REG *)0x40003B04))
// model

/** 0x4000 3BF4 CANFD8_BRGR1 **/
union CANFD8_BRGR1_REG{
	unsigned int reg;
	struct CANFD8_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_BRGR1 (*((volatile union CANFD8_BRGR1_REG *)0x40003BF4))
// model

/** 0x4000 3B08 CANFD8_RCR **/
union CANFD8_RCR_REG{
	unsigned int reg;
	struct CANFD8_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RCR (*((volatile union CANFD8_RCR_REG *)0x40003B08))
// model

/** 0x4000 3B0C CANFD8_EROR **/
union CANFD8_EROR_REG{
	unsigned int reg;
	struct CANFD8_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_EROR (*((volatile union CANFD8_EROR_REG *)0x40003B0C))
// model

/** 0x4000 3B10 CANFD8_CTLR2 **/
union CANFD8_CTLR2_REG{
	unsigned int reg;
	struct CANFD8_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_CTLR2 (*((volatile union CANFD8_CTLR2_REG *)0x40003B10))
// model

/** 0x4000 3B14 CANFD8_MSKR **/
union CANFD8_MSKR_REG{
	unsigned int reg;
	struct CANFD8_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_MSKR (*((volatile union CANFD8_MSKR_REG *)0x40003B14))
// model

/** 0x4000 3B18 CANFD8_IER **/
union CANFD8_IER_REG{
	unsigned int reg;
	struct CANFD8_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_IER (*((volatile union CANFD8_IER_REG *)0x40003B18))
// model

/** 0x4000 3B1C CANFD8_IFR **/
union CANFD8_IFR_REG{
	unsigned int reg;
	struct CANFD8_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_IFR (*((volatile union CANFD8_IFR_REG *)0x40003B1C))
// model

/** 0x4000 3B20 CANFD8_RXDATA0 **/
union CANFD8_RXDATA0_REG{
	unsigned int reg;
	struct CANFD8_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA0 (*((volatile union CANFD8_RXDATA0_REG *)0x40003B20))
// model

/** 0x4000 3B24 CANFD8_RXDATA1 **/
union CANFD8_RXDATA1_REG{
	unsigned int reg;
	struct CANFD8_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA1 (*((volatile union CANFD8_RXDATA1_REG *)0x40003B24))
// model

/** 0x4000 3B28 CANFD8_RXDATA2 **/
union CANFD8_RXDATA2_REG{
	unsigned int reg;
	struct CANFD8_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA2 (*((volatile union CANFD8_RXDATA2_REG *)0x40003B28))
// model

/** 0x4000 3B2C CANFD8_RXDATA3 **/
union CANFD8_RXDATA3_REG{
	unsigned int reg;
	struct CANFD8_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA3 (*((volatile union CANFD8_RXDATA3_REG *)0x40003B2C))
// model

/** 0x4000 3B30 CANFD8_RXDATA4 **/
union CANFD8_RXDATA4_REG{
	unsigned int reg;
	struct CANFD8_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA4 (*((volatile union CANFD8_RXDATA4_REG *)0x40003B30))
// model

/** 0x4000 3B34 CANFD8_RXDATA5 **/
union CANFD8_RXDATA5_REG{
	unsigned int reg;
	struct CANFD8_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA5 (*((volatile union CANFD8_RXDATA5_REG *)0x40003B34))
// model

/** 0x4000 3B38 CANFD8_RXDATA6 **/
union CANFD8_RXDATA6_REG{
	unsigned int reg;
	struct CANFD8_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA6 (*((volatile union CANFD8_RXDATA6_REG *)0x40003B38))
// model

/** 0x4000 3B3C CANFD8_RXDATA7 **/
union CANFD8_RXDATA7_REG{
	unsigned int reg;
	struct CANFD8_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA7 (*((volatile union CANFD8_RXDATA7_REG *)0x40003B3C))
// model

/** 0x4000 3B40 CANFD8_RXDATA8 **/
union CANFD8_RXDATA8_REG{
	unsigned int reg;
	struct CANFD8_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA8 (*((volatile union CANFD8_RXDATA8_REG *)0x40003B40))
// model

/** 0x4000 3B44 CANFD8_RXDATA9 **/
union CANFD8_RXDATA9_REG{
	unsigned int reg;
	struct CANFD8_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA9 (*((volatile union CANFD8_RXDATA9_REG *)0x40003B44))
// model

/** 0x4000 3B48 CANFD8_RXDATA10 **/
union CANFD8_RXDATA10_REG{
	unsigned int reg;
	struct CANFD8_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA10 (*((volatile union CANFD8_RXDATA10_REG *)0x40003B48))
// model

/** 0x4000 3B4C CANFD8_RXDATA11 **/
union CANFD8_RXDATA11_REG{
	unsigned int reg;
	struct CANFD8_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA11 (*((volatile union CANFD8_RXDATA11_REG *)0x40003B4C))
// model

/** 0x4000 3B50 CANFD8_RXDATA12 **/
union CANFD8_RXDATA12_REG{
	unsigned int reg;
	struct CANFD8_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA12 (*((volatile union CANFD8_RXDATA12_REG *)0x40003B50))
// model

/** 0x4000 3B54 CANFD8_RXDATA13 **/
union CANFD8_RXDATA13_REG{
	unsigned int reg;
	struct CANFD8_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA13 (*((volatile union CANFD8_RXDATA13_REG *)0x40003B54))
// model

/** 0x4000 3B58 CANFD8_RXDATA14 **/
union CANFD8_RXDATA14_REG{
	unsigned int reg;
	struct CANFD8_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA14 (*((volatile union CANFD8_RXDATA14_REG *)0x40003B58))
// model

/** 0x4000 3B5C CANFD8_RXDATA15 **/
union CANFD8_RXDATA15_REG{
	unsigned int reg;
	struct CANFD8_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA15 (*((volatile union CANFD8_RXDATA15_REG *)0x40003B5C))
// model

/** 0x4000 3B60 CANFD8_RXDATA16 **/
union CANFD8_RXDATA16_REG{
	unsigned int reg;
	struct CANFD8_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA16 (*((volatile union CANFD8_RXDATA16_REG *)0x40003B60))
// model

/** 0x4000 3B64 CANFD8_RXDATA17 **/
union CANFD8_RXDATA17_REG{
	unsigned int reg;
	struct CANFD8_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RXDATA17 (*((volatile union CANFD8_RXDATA17_REG *)0x40003B64))
// model

/** 0x4000 3B68 CANFD8_TIMER **/
union CANFD8_TIMER_REG{
	unsigned int reg;
	struct CANFD8_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TIMER (*((volatile union CANFD8_TIMER_REG *)0x40003B68))
// model

/** 0x4000 3B6C CANFD8_CRC **/
union CANFD8_CRC_REG{
	unsigned int reg;
	struct CANFD8_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_CRC (*((volatile union CANFD8_CRC_REG *)0x40003B6C))
// model

/** 0x4000 3B74 CANFD8_CTLR1 **/
union CANFD8_CTLR1_REG{
	unsigned int reg;
	struct CANFD8_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_CTLR1 (*((volatile union CANFD8_CTLR1_REG *)0x40003B74))
// model

/** 0x4000 3B78 CANFD8_AMSTA **/
union CANFD8_AMSTA_REG{
	unsigned int reg;
	struct CANFD8_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_AMSTA (*((volatile union CANFD8_AMSTA_REG *)0x40003B78))
// model

/** 0x4000 3B80 CANFD8_TXDATA0 **/
union CANFD8_TXDATA0_REG{
	unsigned int reg;
	struct CANFD8_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA0 (*((volatile union CANFD8_TXDATA0_REG *)0x40003B80))
// model

/** 0x4000 3B84 CANFD8_TXDATA1 **/
union CANFD8_TXDATA1_REG{
	unsigned int reg;
	struct CANFD8_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA1 (*((volatile union CANFD8_TXDATA1_REG *)0x40003B84))
// model

/** 0x4000 3B88 CANFD8_TXDATA2 **/
union CANFD8_TXDATA2_REG{
	unsigned int reg;
	struct CANFD8_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA2 (*((volatile union CANFD8_TXDATA2_REG *)0x40003B88))
// model

/** 0x4000 3B8C CANFD8_TXDATA3 **/
union CANFD8_TXDATA3_REG{
	unsigned int reg;
	struct CANFD8_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA3 (*((volatile union CANFD8_TXDATA3_REG *)0x40003B8C))
// model

/** 0x4000 3B90 CANFD8_TXDATA4 **/
union CANFD8_TXDATA4_REG{
	unsigned int reg;
	struct CANFD8_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA4 (*((volatile union CANFD8_TXDATA4_REG *)0x40003B90))
// model

/** 0x4000 3B94 CANFD8_TXDATA5 **/
union CANFD8_TXDATA5_REG{
	unsigned int reg;
	struct CANFD8_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA5 (*((volatile union CANFD8_TXDATA5_REG *)0x40003B94))
// model

/** 0x4000 3B98 CANFD8_TXDATA6 **/
union CANFD8_TXDATA6_REG{
	unsigned int reg;
	struct CANFD8_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA6 (*((volatile union CANFD8_TXDATA6_REG *)0x40003B98))
// model

/** 0x4000 3B9C CANFD8_TXDATA7 **/
union CANFD8_TXDATA7_REG{
	unsigned int reg;
	struct CANFD8_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA7 (*((volatile union CANFD8_TXDATA7_REG *)0x40003B9C))
// model

/** 0x4000 3BA0 CANFD8_TXDATA8 **/
union CANFD8_TXDATA8_REG{
	unsigned int reg;
	struct CANFD8_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA8 (*((volatile union CANFD8_TXDATA8_REG *)0x40003BA0))
// model

/** 0x4000 3BA4 CANFD8_TXDATA9 **/
union CANFD8_TXDATA9_REG{
	unsigned int reg;
	struct CANFD8_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA9 (*((volatile union CANFD8_TXDATA9_REG *)0x40003BA4))
// model

/** 0x4000 3BA8 CANFD8_TXDATA10 **/
union CANFD8_TXDATA10_REG{
	unsigned int reg;
	struct CANFD8_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA10 (*((volatile union CANFD8_TXDATA10_REG *)0x40003BA8))
// model

/** 0x4000 3BAC CANFD8_TXDATA11 **/
union CANFD8_TXDATA11_REG{
	unsigned int reg;
	struct CANFD8_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA11 (*((volatile union CANFD8_TXDATA11_REG *)0x40003BAC))
// model

/** 0x4000 3BB0 CANFD8_TXDATA12 **/
union CANFD8_TXDATA12_REG{
	unsigned int reg;
	struct CANFD8_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA12 (*((volatile union CANFD8_TXDATA12_REG *)0x40003BB0))
// model

/** 0x4000 3BB4 CANFD8_TXDATA13 **/
union CANFD8_TXDATA13_REG{
	unsigned int reg;
	struct CANFD8_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA13 (*((volatile union CANFD8_TXDATA13_REG *)0x40003BB4))
// model

/** 0x4000 3BB8 CANFD8_TXDATA14 **/
union CANFD8_TXDATA14_REG{
	unsigned int reg;
	struct CANFD8_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA14 (*((volatile union CANFD8_TXDATA14_REG *)0x40003BB8))
// model

/** 0x4000 3BBC CANFD8_TXDATA15 **/
union CANFD8_TXDATA15_REG{
	unsigned int reg;
	struct CANFD8_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA15 (*((volatile union CANFD8_TXDATA15_REG *)0x40003BBC))
// model

/** 0x4000 3BC0 CANFD8_TXDATA16 **/
union CANFD8_TXDATA16_REG{
	unsigned int reg;
	struct CANFD8_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA16 (*((volatile union CANFD8_TXDATA16_REG *)0x40003BC0))
// model

/** 0x4000 3BC4 CANFD8_TXDATA17 **/
union CANFD8_TXDATA17_REG{
	unsigned int reg;
	struct CANFD8_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TXDATA17 (*((volatile union CANFD8_TXDATA17_REG *)0x40003BC4))
// model

/** 0x4000 3BE0 CANFD8_CONFIGREG **/
union CANFD8_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD8_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_CONFIGREG (*((volatile union CANFD8_CONFIGREG_REG *)0x40003BE0))
// model

/** 0x4000 3BE4 CANFD8_TRSTA0 **/
union CANFD8_TRSTA0_REG{
	unsigned int reg;
	struct CANFD8_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TRSTA0 (*((volatile union CANFD8_TRSTA0_REG *)0x40003BE4))
// model

/** 0x4000 3BE8 CANFD8_TRSTA1 **/
union CANFD8_TRSTA1_REG{
	unsigned int reg;
	struct CANFD8_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_TRSTA1 (*((volatile union CANFD8_TRSTA1_REG *)0x40003BE8))
// model

/** 0x4000 3BEC CANFD8_RESTA0 **/
union CANFD8_RESTA0_REG{
	unsigned int reg;
	struct CANFD8_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RESTA0 (*((volatile union CANFD8_RESTA0_REG *)0x40003BEC))
// model

/** 0x4000 3BF0 CANFD8_RESTA1 **/
union CANFD8_RESTA1_REG{
	unsigned int reg;
	struct CANFD8_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD8_RESTA1 (*((volatile union CANFD8_RESTA1_REG *)0x40003BF0))
// modelCANFD9

/** 0x4000 3D00 CANFD9_CTLR0 **/
union CANFD9_CTLR0_REG{
	unsigned int reg;
	struct CANFD9_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_CTLR0 (*((volatile union CANFD9_CTLR0_REG *)0x40003D00))
// model

/** 0x4000 3D04 CANFD9_BRGR **/
union CANFD9_BRGR_REG{
	unsigned int reg;
	struct CANFD9_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_BRGR (*((volatile union CANFD9_BRGR_REG *)0x40003D04))
// model

/** 0x4000 3DF4 CANFD9_BRGR1 **/
union CANFD9_BRGR1_REG{
	unsigned int reg;
	struct CANFD9_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_BRGR1 (*((volatile union CANFD9_BRGR1_REG *)0x40003DF4))
// model

/** 0x4000 3D08 CANFD9_RCR **/
union CANFD9_RCR_REG{
	unsigned int reg;
	struct CANFD9_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RCR (*((volatile union CANFD9_RCR_REG *)0x40003D08))
// model

/** 0x4000 3D0C CANFD9_EROR **/
union CANFD9_EROR_REG{
	unsigned int reg;
	struct CANFD9_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_EROR (*((volatile union CANFD9_EROR_REG *)0x40003D0C))
// model

/** 0x4000 3D10 CANFD9_CTLR2 **/
union CANFD9_CTLR2_REG{
	unsigned int reg;
	struct CANFD9_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_CTLR2 (*((volatile union CANFD9_CTLR2_REG *)0x40003D10))
// model

/** 0x4000 3D14 CANFD9_MSKR **/
union CANFD9_MSKR_REG{
	unsigned int reg;
	struct CANFD9_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_MSKR (*((volatile union CANFD9_MSKR_REG *)0x40003D14))
// model

/** 0x4000 3D18 CANFD9_IER **/
union CANFD9_IER_REG{
	unsigned int reg;
	struct CANFD9_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_IER (*((volatile union CANFD9_IER_REG *)0x40003D18))
// model

/** 0x4000 3D1C CANFD9_IFR **/
union CANFD9_IFR_REG{
	unsigned int reg;
	struct CANFD9_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_IFR (*((volatile union CANFD9_IFR_REG *)0x40003D1C))
// model

/** 0x4000 3D20 CANFD9_RXDATA0 **/
union CANFD9_RXDATA0_REG{
	unsigned int reg;
	struct CANFD9_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA0 (*((volatile union CANFD9_RXDATA0_REG *)0x40003D20))
// model

/** 0x4000 3D24 CANFD9_RXDATA1 **/
union CANFD9_RXDATA1_REG{
	unsigned int reg;
	struct CANFD9_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA1 (*((volatile union CANFD9_RXDATA1_REG *)0x40003D24))
// model

/** 0x4000 3D28 CANFD9_RXDATA2 **/
union CANFD9_RXDATA2_REG{
	unsigned int reg;
	struct CANFD9_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA2 (*((volatile union CANFD9_RXDATA2_REG *)0x40003D28))
// model

/** 0x4000 3D2C CANFD9_RXDATA3 **/
union CANFD9_RXDATA3_REG{
	unsigned int reg;
	struct CANFD9_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA3 (*((volatile union CANFD9_RXDATA3_REG *)0x40003D2C))
// model

/** 0x4000 3D30 CANFD9_RXDATA4 **/
union CANFD9_RXDATA4_REG{
	unsigned int reg;
	struct CANFD9_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA4 (*((volatile union CANFD9_RXDATA4_REG *)0x40003D30))
// model

/** 0x4000 3D34 CANFD9_RXDATA5 **/
union CANFD9_RXDATA5_REG{
	unsigned int reg;
	struct CANFD9_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA5 (*((volatile union CANFD9_RXDATA5_REG *)0x40003D34))
// model

/** 0x4000 3D38 CANFD9_RXDATA6 **/
union CANFD9_RXDATA6_REG{
	unsigned int reg;
	struct CANFD9_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA6 (*((volatile union CANFD9_RXDATA6_REG *)0x40003D38))
// model

/** 0x4000 3D3C CANFD9_RXDATA7 **/
union CANFD9_RXDATA7_REG{
	unsigned int reg;
	struct CANFD9_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA7 (*((volatile union CANFD9_RXDATA7_REG *)0x40003D3C))
// model

/** 0x4000 3D40 CANFD9_RXDATA8 **/
union CANFD9_RXDATA8_REG{
	unsigned int reg;
	struct CANFD9_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA8 (*((volatile union CANFD9_RXDATA8_REG *)0x40003D40))
// model

/** 0x4000 3D44 CANFD9_RXDATA9 **/
union CANFD9_RXDATA9_REG{
	unsigned int reg;
	struct CANFD9_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA9 (*((volatile union CANFD9_RXDATA9_REG *)0x40003D44))
// model

/** 0x4000 3D48 CANFD9_RXDATA10 **/
union CANFD9_RXDATA10_REG{
	unsigned int reg;
	struct CANFD9_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA10 (*((volatile union CANFD9_RXDATA10_REG *)0x40003D48))
// model

/** 0x4000 3D4C CANFD9_RXDATA11 **/
union CANFD9_RXDATA11_REG{
	unsigned int reg;
	struct CANFD9_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA11 (*((volatile union CANFD9_RXDATA11_REG *)0x40003D4C))
// model

/** 0x4000 3D50 CANFD9_RXDATA12 **/
union CANFD9_RXDATA12_REG{
	unsigned int reg;
	struct CANFD9_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA12 (*((volatile union CANFD9_RXDATA12_REG *)0x40003D50))
// model

/** 0x4000 3D54 CANFD9_RXDATA13 **/
union CANFD9_RXDATA13_REG{
	unsigned int reg;
	struct CANFD9_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA13 (*((volatile union CANFD9_RXDATA13_REG *)0x40003D54))
// model

/** 0x4000 3D58 CANFD9_RXDATA14 **/
union CANFD9_RXDATA14_REG{
	unsigned int reg;
	struct CANFD9_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA14 (*((volatile union CANFD9_RXDATA14_REG *)0x40003D58))
// model

/** 0x4000 3D5C CANFD9_RXDATA15 **/
union CANFD9_RXDATA15_REG{
	unsigned int reg;
	struct CANFD9_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA15 (*((volatile union CANFD9_RXDATA15_REG *)0x40003D5C))
// model

/** 0x4000 3D60 CANFD9_RXDATA16 **/
union CANFD9_RXDATA16_REG{
	unsigned int reg;
	struct CANFD9_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA16 (*((volatile union CANFD9_RXDATA16_REG *)0x40003D60))
// model

/** 0x4000 3D64 CANFD9_RXDATA17 **/
union CANFD9_RXDATA17_REG{
	unsigned int reg;
	struct CANFD9_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RXDATA17 (*((volatile union CANFD9_RXDATA17_REG *)0x40003D64))
// model

/** 0x4000 3D68 CANFD9_TIMER **/
union CANFD9_TIMER_REG{
	unsigned int reg;
	struct CANFD9_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TIMER (*((volatile union CANFD9_TIMER_REG *)0x40003D68))
// model

/** 0x4000 3D6C CANFD9_CRC **/
union CANFD9_CRC_REG{
	unsigned int reg;
	struct CANFD9_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_CRC (*((volatile union CANFD9_CRC_REG *)0x40003D6C))
// model

/** 0x4000 3D74 CANFD9_CTLR1 **/
union CANFD9_CTLR1_REG{
	unsigned int reg;
	struct CANFD9_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_CTLR1 (*((volatile union CANFD9_CTLR1_REG *)0x40003D74))
// model

/** 0x4000 3D78 CANFD9_AMSTA **/
union CANFD9_AMSTA_REG{
	unsigned int reg;
	struct CANFD9_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_AMSTA (*((volatile union CANFD9_AMSTA_REG *)0x40003D78))
// model

/** 0x4000 3D80 CANFD9_TXDATA0 **/
union CANFD9_TXDATA0_REG{
	unsigned int reg;
	struct CANFD9_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA0 (*((volatile union CANFD9_TXDATA0_REG *)0x40003D80))
// model

/** 0x4000 3D84 CANFD9_TXDATA1 **/
union CANFD9_TXDATA1_REG{
	unsigned int reg;
	struct CANFD9_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA1 (*((volatile union CANFD9_TXDATA1_REG *)0x40003D84))
// model

/** 0x4000 3D88 CANFD9_TXDATA2 **/
union CANFD9_TXDATA2_REG{
	unsigned int reg;
	struct CANFD9_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA2 (*((volatile union CANFD9_TXDATA2_REG *)0x40003D88))
// model

/** 0x4000 3D8C CANFD9_TXDATA3 **/
union CANFD9_TXDATA3_REG{
	unsigned int reg;
	struct CANFD9_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA3 (*((volatile union CANFD9_TXDATA3_REG *)0x40003D8C))
// model

/** 0x4000 3D90 CANFD9_TXDATA4 **/
union CANFD9_TXDATA4_REG{
	unsigned int reg;
	struct CANFD9_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA4 (*((volatile union CANFD9_TXDATA4_REG *)0x40003D90))
// model

/** 0x4000 3D94 CANFD9_TXDATA5 **/
union CANFD9_TXDATA5_REG{
	unsigned int reg;
	struct CANFD9_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA5 (*((volatile union CANFD9_TXDATA5_REG *)0x40003D94))
// model

/** 0x4000 3D98 CANFD9_TXDATA6 **/
union CANFD9_TXDATA6_REG{
	unsigned int reg;
	struct CANFD9_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA6 (*((volatile union CANFD9_TXDATA6_REG *)0x40003D98))
// model

/** 0x4000 3D9C CANFD9_TXDATA7 **/
union CANFD9_TXDATA7_REG{
	unsigned int reg;
	struct CANFD9_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA7 (*((volatile union CANFD9_TXDATA7_REG *)0x40003D9C))
// model

/** 0x4000 3DA0 CANFD9_TXDATA8 **/
union CANFD9_TXDATA8_REG{
	unsigned int reg;
	struct CANFD9_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA8 (*((volatile union CANFD9_TXDATA8_REG *)0x40003DA0))
// model

/** 0x4000 3DA4 CANFD9_TXDATA9 **/
union CANFD9_TXDATA9_REG{
	unsigned int reg;
	struct CANFD9_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA9 (*((volatile union CANFD9_TXDATA9_REG *)0x40003DA4))
// model

/** 0x4000 3DA8 CANFD9_TXDATA10 **/
union CANFD9_TXDATA10_REG{
	unsigned int reg;
	struct CANFD9_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA10 (*((volatile union CANFD9_TXDATA10_REG *)0x40003DA8))
// model

/** 0x4000 3DAC CANFD9_TXDATA11 **/
union CANFD9_TXDATA11_REG{
	unsigned int reg;
	struct CANFD9_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA11 (*((volatile union CANFD9_TXDATA11_REG *)0x40003DAC))
// model

/** 0x4000 3DB0 CANFD9_TXDATA12 **/
union CANFD9_TXDATA12_REG{
	unsigned int reg;
	struct CANFD9_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA12 (*((volatile union CANFD9_TXDATA12_REG *)0x40003DB0))
// model

/** 0x4000 3DB4 CANFD9_TXDATA13 **/
union CANFD9_TXDATA13_REG{
	unsigned int reg;
	struct CANFD9_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA13 (*((volatile union CANFD9_TXDATA13_REG *)0x40003DB4))
// model

/** 0x4000 3DB8 CANFD9_TXDATA14 **/
union CANFD9_TXDATA14_REG{
	unsigned int reg;
	struct CANFD9_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA14 (*((volatile union CANFD9_TXDATA14_REG *)0x40003DB8))
// model

/** 0x4000 3DBC CANFD9_TXDATA15 **/
union CANFD9_TXDATA15_REG{
	unsigned int reg;
	struct CANFD9_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA15 (*((volatile union CANFD9_TXDATA15_REG *)0x40003DBC))
// model

/** 0x4000 3DC0 CANFD9_TXDATA16 **/
union CANFD9_TXDATA16_REG{
	unsigned int reg;
	struct CANFD9_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA16 (*((volatile union CANFD9_TXDATA16_REG *)0x40003DC0))
// model

/** 0x4000 3DC4 CANFD9_TXDATA17 **/
union CANFD9_TXDATA17_REG{
	unsigned int reg;
	struct CANFD9_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TXDATA17 (*((volatile union CANFD9_TXDATA17_REG *)0x40003DC4))
// model

/** 0x4000 3DE0 CANFD9_CONFIGREG **/
union CANFD9_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD9_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_CONFIGREG (*((volatile union CANFD9_CONFIGREG_REG *)0x40003DE0))
// model

/** 0x4000 3DE4 CANFD9_TRSTA0 **/
union CANFD9_TRSTA0_REG{
	unsigned int reg;
	struct CANFD9_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TRSTA0 (*((volatile union CANFD9_TRSTA0_REG *)0x40003DE4))
// model

/** 0x4000 3DE8 CANFD9_TRSTA1 **/
union CANFD9_TRSTA1_REG{
	unsigned int reg;
	struct CANFD9_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_TRSTA1 (*((volatile union CANFD9_TRSTA1_REG *)0x40003DE8))
// model

/** 0x4000 3DEC CANFD9_RESTA0 **/
union CANFD9_RESTA0_REG{
	unsigned int reg;
	struct CANFD9_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RESTA0 (*((volatile union CANFD9_RESTA0_REG *)0x40003DEC))
// model

/** 0x4000 3DF0 CANFD9_RESTA1 **/
union CANFD9_RESTA1_REG{
	unsigned int reg;
	struct CANFD9_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD9_RESTA1 (*((volatile union CANFD9_RESTA1_REG *)0x40003DF0))
// modelCANFD10

/** 0x4000 3F00 CANFD10_CTLR0 **/
union CANFD10_CTLR0_REG{
	unsigned int reg;
	struct CANFD10_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_CTLR0 (*((volatile union CANFD10_CTLR0_REG *)0x40003F00))
// model

/** 0x4000 3F04 CANFD10_BRGR **/
union CANFD10_BRGR_REG{
	unsigned int reg;
	struct CANFD10_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_BRGR (*((volatile union CANFD10_BRGR_REG *)0x40003F04))
// model

/** 0x4000 3FF4 CANFD10_BRGR1 **/
union CANFD10_BRGR1_REG{
	unsigned int reg;
	struct CANFD10_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_BRGR1 (*((volatile union CANFD10_BRGR1_REG *)0x40003FF4))
// model

/** 0x4000 3F08 CANFD10_RCR **/
union CANFD10_RCR_REG{
	unsigned int reg;
	struct CANFD10_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RCR (*((volatile union CANFD10_RCR_REG *)0x40003F08))
// model

/** 0x4000 3F0C CANFD10_EROR **/
union CANFD10_EROR_REG{
	unsigned int reg;
	struct CANFD10_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_EROR (*((volatile union CANFD10_EROR_REG *)0x40003F0C))
// model

/** 0x4000 3F10 CANFD10_CTLR2 **/
union CANFD10_CTLR2_REG{
	unsigned int reg;
	struct CANFD10_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_CTLR2 (*((volatile union CANFD10_CTLR2_REG *)0x40003F10))
// model

/** 0x4000 3F14 CANFD10_MSKR **/
union CANFD10_MSKR_REG{
	unsigned int reg;
	struct CANFD10_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_MSKR (*((volatile union CANFD10_MSKR_REG *)0x40003F14))
// model

/** 0x4000 3F18 CANFD10_IER **/
union CANFD10_IER_REG{
	unsigned int reg;
	struct CANFD10_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_IER (*((volatile union CANFD10_IER_REG *)0x40003F18))
// model

/** 0x4000 3F1C CANFD10_IFR **/
union CANFD10_IFR_REG{
	unsigned int reg;
	struct CANFD10_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_IFR (*((volatile union CANFD10_IFR_REG *)0x40003F1C))
// model

/** 0x4000 3F20 CANFD10_RXDATA0 **/
union CANFD10_RXDATA0_REG{
	unsigned int reg;
	struct CANFD10_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA0 (*((volatile union CANFD10_RXDATA0_REG *)0x40003F20))
// model

/** 0x4000 3F24 CANFD10_RXDATA1 **/
union CANFD10_RXDATA1_REG{
	unsigned int reg;
	struct CANFD10_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA1 (*((volatile union CANFD10_RXDATA1_REG *)0x40003F24))
// model

/** 0x4000 3F28 CANFD10_RXDATA2 **/
union CANFD10_RXDATA2_REG{
	unsigned int reg;
	struct CANFD10_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA2 (*((volatile union CANFD10_RXDATA2_REG *)0x40003F28))
// model

/** 0x4000 3F2C CANFD10_RXDATA3 **/
union CANFD10_RXDATA3_REG{
	unsigned int reg;
	struct CANFD10_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA3 (*((volatile union CANFD10_RXDATA3_REG *)0x40003F2C))
// model

/** 0x4000 3F30 CANFD10_RXDATA4 **/
union CANFD10_RXDATA4_REG{
	unsigned int reg;
	struct CANFD10_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA4 (*((volatile union CANFD10_RXDATA4_REG *)0x40003F30))
// model

/** 0x4000 3F34 CANFD10_RXDATA5 **/
union CANFD10_RXDATA5_REG{
	unsigned int reg;
	struct CANFD10_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA5 (*((volatile union CANFD10_RXDATA5_REG *)0x40003F34))
// model

/** 0x4000 3F38 CANFD10_RXDATA6 **/
union CANFD10_RXDATA6_REG{
	unsigned int reg;
	struct CANFD10_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA6 (*((volatile union CANFD10_RXDATA6_REG *)0x40003F38))
// model

/** 0x4000 3F3C CANFD10_RXDATA7 **/
union CANFD10_RXDATA7_REG{
	unsigned int reg;
	struct CANFD10_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA7 (*((volatile union CANFD10_RXDATA7_REG *)0x40003F3C))
// model

/** 0x4000 3F40 CANFD10_RXDATA8 **/
union CANFD10_RXDATA8_REG{
	unsigned int reg;
	struct CANFD10_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA8 (*((volatile union CANFD10_RXDATA8_REG *)0x40003F40))
// model

/** 0x4000 3F44 CANFD10_RXDATA9 **/
union CANFD10_RXDATA9_REG{
	unsigned int reg;
	struct CANFD10_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA9 (*((volatile union CANFD10_RXDATA9_REG *)0x40003F44))
// model

/** 0x4000 3F48 CANFD10_RXDATA10 **/
union CANFD10_RXDATA10_REG{
	unsigned int reg;
	struct CANFD10_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA10 (*((volatile union CANFD10_RXDATA10_REG *)0x40003F48))
// model

/** 0x4000 3F4C CANFD10_RXDATA11 **/
union CANFD10_RXDATA11_REG{
	unsigned int reg;
	struct CANFD10_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA11 (*((volatile union CANFD10_RXDATA11_REG *)0x40003F4C))
// model

/** 0x4000 3F50 CANFD10_RXDATA12 **/
union CANFD10_RXDATA12_REG{
	unsigned int reg;
	struct CANFD10_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA12 (*((volatile union CANFD10_RXDATA12_REG *)0x40003F50))
// model

/** 0x4000 3F54 CANFD10_RXDATA13 **/
union CANFD10_RXDATA13_REG{
	unsigned int reg;
	struct CANFD10_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA13 (*((volatile union CANFD10_RXDATA13_REG *)0x40003F54))
// model

/** 0x4000 3F58 CANFD10_RXDATA14 **/
union CANFD10_RXDATA14_REG{
	unsigned int reg;
	struct CANFD10_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA14 (*((volatile union CANFD10_RXDATA14_REG *)0x40003F58))
// model

/** 0x4000 3F5C CANFD10_RXDATA15 **/
union CANFD10_RXDATA15_REG{
	unsigned int reg;
	struct CANFD10_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA15 (*((volatile union CANFD10_RXDATA15_REG *)0x40003F5C))
// model

/** 0x4000 3F60 CANFD10_RXDATA16 **/
union CANFD10_RXDATA16_REG{
	unsigned int reg;
	struct CANFD10_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA16 (*((volatile union CANFD10_RXDATA16_REG *)0x40003F60))
// model

/** 0x4000 3F64 CANFD10_RXDATA17 **/
union CANFD10_RXDATA17_REG{
	unsigned int reg;
	struct CANFD10_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RXDATA17 (*((volatile union CANFD10_RXDATA17_REG *)0x40003F64))
// model

/** 0x4000 3F68 CANFD10_TIMER **/
union CANFD10_TIMER_REG{
	unsigned int reg;
	struct CANFD10_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TIMER (*((volatile union CANFD10_TIMER_REG *)0x40003F68))
// model

/** 0x4000 3F6C CANFD10_CRC **/
union CANFD10_CRC_REG{
	unsigned int reg;
	struct CANFD10_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_CRC (*((volatile union CANFD10_CRC_REG *)0x40003F6C))
// model

/** 0x4000 3F74 CANFD10_CTLR1 **/
union CANFD10_CTLR1_REG{
	unsigned int reg;
	struct CANFD10_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_CTLR1 (*((volatile union CANFD10_CTLR1_REG *)0x40003F74))
// model

/** 0x4000 3F78 CANFD10_AMSTA **/
union CANFD10_AMSTA_REG{
	unsigned int reg;
	struct CANFD10_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_AMSTA (*((volatile union CANFD10_AMSTA_REG *)0x40003F78))
// model

/** 0x4000 3F80 CANFD10_TXDATA0 **/
union CANFD10_TXDATA0_REG{
	unsigned int reg;
	struct CANFD10_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA0 (*((volatile union CANFD10_TXDATA0_REG *)0x40003F80))
// model

/** 0x4000 3F84 CANFD10_TXDATA1 **/
union CANFD10_TXDATA1_REG{
	unsigned int reg;
	struct CANFD10_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA1 (*((volatile union CANFD10_TXDATA1_REG *)0x40003F84))
// model

/** 0x4000 3F88 CANFD10_TXDATA2 **/
union CANFD10_TXDATA2_REG{
	unsigned int reg;
	struct CANFD10_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA2 (*((volatile union CANFD10_TXDATA2_REG *)0x40003F88))
// model

/** 0x4000 3F8C CANFD10_TXDATA3 **/
union CANFD10_TXDATA3_REG{
	unsigned int reg;
	struct CANFD10_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA3 (*((volatile union CANFD10_TXDATA3_REG *)0x40003F8C))
// model

/** 0x4000 3F90 CANFD10_TXDATA4 **/
union CANFD10_TXDATA4_REG{
	unsigned int reg;
	struct CANFD10_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA4 (*((volatile union CANFD10_TXDATA4_REG *)0x40003F90))
// model

/** 0x4000 3F94 CANFD10_TXDATA5 **/
union CANFD10_TXDATA5_REG{
	unsigned int reg;
	struct CANFD10_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA5 (*((volatile union CANFD10_TXDATA5_REG *)0x40003F94))
// model

/** 0x4000 3F98 CANFD10_TXDATA6 **/
union CANFD10_TXDATA6_REG{
	unsigned int reg;
	struct CANFD10_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA6 (*((volatile union CANFD10_TXDATA6_REG *)0x40003F98))
// model

/** 0x4000 3F9C CANFD10_TXDATA7 **/
union CANFD10_TXDATA7_REG{
	unsigned int reg;
	struct CANFD10_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA7 (*((volatile union CANFD10_TXDATA7_REG *)0x40003F9C))
// model

/** 0x4000 3FA0 CANFD10_TXDATA8 **/
union CANFD10_TXDATA8_REG{
	unsigned int reg;
	struct CANFD10_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA8 (*((volatile union CANFD10_TXDATA8_REG *)0x40003FA0))
// model

/** 0x4000 3FA4 CANFD10_TXDATA9 **/
union CANFD10_TXDATA9_REG{
	unsigned int reg;
	struct CANFD10_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA9 (*((volatile union CANFD10_TXDATA9_REG *)0x40003FA4))
// model

/** 0x4000 3FA8 CANFD10_TXDATA10 **/
union CANFD10_TXDATA10_REG{
	unsigned int reg;
	struct CANFD10_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA10 (*((volatile union CANFD10_TXDATA10_REG *)0x40003FA8))
// model

/** 0x4000 3FAC CANFD10_TXDATA11 **/
union CANFD10_TXDATA11_REG{
	unsigned int reg;
	struct CANFD10_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA11 (*((volatile union CANFD10_TXDATA11_REG *)0x40003FAC))
// model

/** 0x4000 3FB0 CANFD10_TXDATA12 **/
union CANFD10_TXDATA12_REG{
	unsigned int reg;
	struct CANFD10_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA12 (*((volatile union CANFD10_TXDATA12_REG *)0x40003FB0))
// model

/** 0x4000 3FB4 CANFD10_TXDATA13 **/
union CANFD10_TXDATA13_REG{
	unsigned int reg;
	struct CANFD10_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA13 (*((volatile union CANFD10_TXDATA13_REG *)0x40003FB4))
// model

/** 0x4000 3FB8 CANFD10_TXDATA14 **/
union CANFD10_TXDATA14_REG{
	unsigned int reg;
	struct CANFD10_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA14 (*((volatile union CANFD10_TXDATA14_REG *)0x40003FB8))
// model

/** 0x4000 3FBC CANFD10_TXDATA15 **/
union CANFD10_TXDATA15_REG{
	unsigned int reg;
	struct CANFD10_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA15 (*((volatile union CANFD10_TXDATA15_REG *)0x40003FBC))
// model

/** 0x4000 3FC0 CANFD10_TXDATA16 **/
union CANFD10_TXDATA16_REG{
	unsigned int reg;
	struct CANFD10_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA16 (*((volatile union CANFD10_TXDATA16_REG *)0x40003FC0))
// model

/** 0x4000 3FC4 CANFD10_TXDATA17 **/
union CANFD10_TXDATA17_REG{
	unsigned int reg;
	struct CANFD10_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TXDATA17 (*((volatile union CANFD10_TXDATA17_REG *)0x40003FC4))
// model

/** 0x4000 3FE0 CANFD10_CONFIGREG **/
union CANFD10_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD10_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_CONFIGREG (*((volatile union CANFD10_CONFIGREG_REG *)0x40003FE0))
// model

/** 0x4000 3FE4 CANFD10_TRSTA0 **/
union CANFD10_TRSTA0_REG{
	unsigned int reg;
	struct CANFD10_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TRSTA0 (*((volatile union CANFD10_TRSTA0_REG *)0x40003FE4))
// model

/** 0x4000 3FE8 CANFD10_TRSTA1 **/
union CANFD10_TRSTA1_REG{
	unsigned int reg;
	struct CANFD10_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_TRSTA1 (*((volatile union CANFD10_TRSTA1_REG *)0x40003FE8))
// model

/** 0x4000 3FEC CANFD10_RESTA0 **/
union CANFD10_RESTA0_REG{
	unsigned int reg;
	struct CANFD10_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RESTA0 (*((volatile union CANFD10_RESTA0_REG *)0x40003FEC))
// model

/** 0x4000 3FF0 CANFD10_RESTA1 **/
union CANFD10_RESTA1_REG{
	unsigned int reg;
	struct CANFD10_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD10_RESTA1 (*((volatile union CANFD10_RESTA1_REG *)0x40003FF0))
// modelCANFD11

/** 0x4000 4100 CANFD11_CTLR0 **/
union CANFD11_CTLR0_REG{
	unsigned int reg;
	struct CANFD11_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_CTLR0 (*((volatile union CANFD11_CTLR0_REG *)0x40004100))
// model

/** 0x4000 4104 CANFD11_BRGR **/
union CANFD11_BRGR_REG{
	unsigned int reg;
	struct CANFD11_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_BRGR (*((volatile union CANFD11_BRGR_REG *)0x40004104))
// model

/** 0x4000 41F4 CANFD11_BRGR1 **/
union CANFD11_BRGR1_REG{
	unsigned int reg;
	struct CANFD11_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_BRGR1 (*((volatile union CANFD11_BRGR1_REG *)0x400041F4))
// model

/** 0x4000 4108 CANFD11_RCR **/
union CANFD11_RCR_REG{
	unsigned int reg;
	struct CANFD11_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RCR (*((volatile union CANFD11_RCR_REG *)0x40004108))
// model

/** 0x4000 410C CANFD11_EROR **/
union CANFD11_EROR_REG{
	unsigned int reg;
	struct CANFD11_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_EROR (*((volatile union CANFD11_EROR_REG *)0x4000410C))
// model

/** 0x4000 4110 CANFD11_CTLR2 **/
union CANFD11_CTLR2_REG{
	unsigned int reg;
	struct CANFD11_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_CTLR2 (*((volatile union CANFD11_CTLR2_REG *)0x40004110))
// model

/** 0x4000 4114 CANFD11_MSKR **/
union CANFD11_MSKR_REG{
	unsigned int reg;
	struct CANFD11_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_MSKR (*((volatile union CANFD11_MSKR_REG *)0x40004114))
// model

/** 0x4000 4118 CANFD11_IER **/
union CANFD11_IER_REG{
	unsigned int reg;
	struct CANFD11_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_IER (*((volatile union CANFD11_IER_REG *)0x40004118))
// model

/** 0x4000 411C CANFD11_IFR **/
union CANFD11_IFR_REG{
	unsigned int reg;
	struct CANFD11_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_IFR (*((volatile union CANFD11_IFR_REG *)0x4000411C))
// model

/** 0x4000 4120 CANFD11_RXDATA0 **/
union CANFD11_RXDATA0_REG{
	unsigned int reg;
	struct CANFD11_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA0 (*((volatile union CANFD11_RXDATA0_REG *)0x40004120))
// model

/** 0x4000 4124 CANFD11_RXDATA1 **/
union CANFD11_RXDATA1_REG{
	unsigned int reg;
	struct CANFD11_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA1 (*((volatile union CANFD11_RXDATA1_REG *)0x40004124))
// model

/** 0x4000 4128 CANFD11_RXDATA2 **/
union CANFD11_RXDATA2_REG{
	unsigned int reg;
	struct CANFD11_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA2 (*((volatile union CANFD11_RXDATA2_REG *)0x40004128))
// model

/** 0x4000 412C CANFD11_RXDATA3 **/
union CANFD11_RXDATA3_REG{
	unsigned int reg;
	struct CANFD11_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA3 (*((volatile union CANFD11_RXDATA3_REG *)0x4000412C))
// model

/** 0x4000 4130 CANFD11_RXDATA4 **/
union CANFD11_RXDATA4_REG{
	unsigned int reg;
	struct CANFD11_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA4 (*((volatile union CANFD11_RXDATA4_REG *)0x40004130))
// model

/** 0x4000 4134 CANFD11_RXDATA5 **/
union CANFD11_RXDATA5_REG{
	unsigned int reg;
	struct CANFD11_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA5 (*((volatile union CANFD11_RXDATA5_REG *)0x40004134))
// model

/** 0x4000 4138 CANFD11_RXDATA6 **/
union CANFD11_RXDATA6_REG{
	unsigned int reg;
	struct CANFD11_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA6 (*((volatile union CANFD11_RXDATA6_REG *)0x40004138))
// model

/** 0x4000 413C CANFD11_RXDATA7 **/
union CANFD11_RXDATA7_REG{
	unsigned int reg;
	struct CANFD11_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA7 (*((volatile union CANFD11_RXDATA7_REG *)0x4000413C))
// model

/** 0x4000 4140 CANFD11_RXDATA8 **/
union CANFD11_RXDATA8_REG{
	unsigned int reg;
	struct CANFD11_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA8 (*((volatile union CANFD11_RXDATA8_REG *)0x40004140))
// model

/** 0x4000 4144 CANFD11_RXDATA9 **/
union CANFD11_RXDATA9_REG{
	unsigned int reg;
	struct CANFD11_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA9 (*((volatile union CANFD11_RXDATA9_REG *)0x40004144))
// model

/** 0x4000 4148 CANFD11_RXDATA10 **/
union CANFD11_RXDATA10_REG{
	unsigned int reg;
	struct CANFD11_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA10 (*((volatile union CANFD11_RXDATA10_REG *)0x40004148))
// model

/** 0x4000 414C CANFD11_RXDATA11 **/
union CANFD11_RXDATA11_REG{
	unsigned int reg;
	struct CANFD11_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA11 (*((volatile union CANFD11_RXDATA11_REG *)0x4000414C))
// model

/** 0x4000 4150 CANFD11_RXDATA12 **/
union CANFD11_RXDATA12_REG{
	unsigned int reg;
	struct CANFD11_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA12 (*((volatile union CANFD11_RXDATA12_REG *)0x40004150))
// model

/** 0x4000 4154 CANFD11_RXDATA13 **/
union CANFD11_RXDATA13_REG{
	unsigned int reg;
	struct CANFD11_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA13 (*((volatile union CANFD11_RXDATA13_REG *)0x40004154))
// model

/** 0x4000 4158 CANFD11_RXDATA14 **/
union CANFD11_RXDATA14_REG{
	unsigned int reg;
	struct CANFD11_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA14 (*((volatile union CANFD11_RXDATA14_REG *)0x40004158))
// model

/** 0x4000 415C CANFD11_RXDATA15 **/
union CANFD11_RXDATA15_REG{
	unsigned int reg;
	struct CANFD11_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA15 (*((volatile union CANFD11_RXDATA15_REG *)0x4000415C))
// model

/** 0x4000 4160 CANFD11_RXDATA16 **/
union CANFD11_RXDATA16_REG{
	unsigned int reg;
	struct CANFD11_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA16 (*((volatile union CANFD11_RXDATA16_REG *)0x40004160))
// model

/** 0x4000 4164 CANFD11_RXDATA17 **/
union CANFD11_RXDATA17_REG{
	unsigned int reg;
	struct CANFD11_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RXDATA17 (*((volatile union CANFD11_RXDATA17_REG *)0x40004164))
// model

/** 0x4000 4168 CANFD11_TIMER **/
union CANFD11_TIMER_REG{
	unsigned int reg;
	struct CANFD11_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TIMER (*((volatile union CANFD11_TIMER_REG *)0x40004168))
// model

/** 0x4000 416C CANFD11_CRC **/
union CANFD11_CRC_REG{
	unsigned int reg;
	struct CANFD11_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_CRC (*((volatile union CANFD11_CRC_REG *)0x4000416C))
// model

/** 0x4000 4174 CANFD11_CTLR1 **/
union CANFD11_CTLR1_REG{
	unsigned int reg;
	struct CANFD11_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_CTLR1 (*((volatile union CANFD11_CTLR1_REG *)0x40004174))
// model

/** 0x4000 4178 CANFD11_AMSTA **/
union CANFD11_AMSTA_REG{
	unsigned int reg;
	struct CANFD11_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_AMSTA (*((volatile union CANFD11_AMSTA_REG *)0x40004178))
// model

/** 0x4000 4180 CANFD11_TXDATA0 **/
union CANFD11_TXDATA0_REG{
	unsigned int reg;
	struct CANFD11_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA0 (*((volatile union CANFD11_TXDATA0_REG *)0x40004180))
// model

/** 0x4000 4184 CANFD11_TXDATA1 **/
union CANFD11_TXDATA1_REG{
	unsigned int reg;
	struct CANFD11_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA1 (*((volatile union CANFD11_TXDATA1_REG *)0x40004184))
// model

/** 0x4000 4188 CANFD11_TXDATA2 **/
union CANFD11_TXDATA2_REG{
	unsigned int reg;
	struct CANFD11_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA2 (*((volatile union CANFD11_TXDATA2_REG *)0x40004188))
// model

/** 0x4000 418C CANFD11_TXDATA3 **/
union CANFD11_TXDATA3_REG{
	unsigned int reg;
	struct CANFD11_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA3 (*((volatile union CANFD11_TXDATA3_REG *)0x4000418C))
// model

/** 0x4000 4190 CANFD11_TXDATA4 **/
union CANFD11_TXDATA4_REG{
	unsigned int reg;
	struct CANFD11_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA4 (*((volatile union CANFD11_TXDATA4_REG *)0x40004190))
// model

/** 0x4000 4194 CANFD11_TXDATA5 **/
union CANFD11_TXDATA5_REG{
	unsigned int reg;
	struct CANFD11_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA5 (*((volatile union CANFD11_TXDATA5_REG *)0x40004194))
// model

/** 0x4000 4198 CANFD11_TXDATA6 **/
union CANFD11_TXDATA6_REG{
	unsigned int reg;
	struct CANFD11_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA6 (*((volatile union CANFD11_TXDATA6_REG *)0x40004198))
// model

/** 0x4000 419C CANFD11_TXDATA7 **/
union CANFD11_TXDATA7_REG{
	unsigned int reg;
	struct CANFD11_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA7 (*((volatile union CANFD11_TXDATA7_REG *)0x4000419C))
// model

/** 0x4000 41A0 CANFD11_TXDATA8 **/
union CANFD11_TXDATA8_REG{
	unsigned int reg;
	struct CANFD11_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA8 (*((volatile union CANFD11_TXDATA8_REG *)0x400041A0))
// model

/** 0x4000 41A4 CANFD11_TXDATA9 **/
union CANFD11_TXDATA9_REG{
	unsigned int reg;
	struct CANFD11_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA9 (*((volatile union CANFD11_TXDATA9_REG *)0x400041A4))
// model

/** 0x4000 41A8 CANFD11_TXDATA10 **/
union CANFD11_TXDATA10_REG{
	unsigned int reg;
	struct CANFD11_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA10 (*((volatile union CANFD11_TXDATA10_REG *)0x400041A8))
// model

/** 0x4000 41AC CANFD11_TXDATA11 **/
union CANFD11_TXDATA11_REG{
	unsigned int reg;
	struct CANFD11_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA11 (*((volatile union CANFD11_TXDATA11_REG *)0x400041AC))
// model

/** 0x4000 41B0 CANFD11_TXDATA12 **/
union CANFD11_TXDATA12_REG{
	unsigned int reg;
	struct CANFD11_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA12 (*((volatile union CANFD11_TXDATA12_REG *)0x400041B0))
// model

/** 0x4000 41B4 CANFD11_TXDATA13 **/
union CANFD11_TXDATA13_REG{
	unsigned int reg;
	struct CANFD11_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA13 (*((volatile union CANFD11_TXDATA13_REG *)0x400041B4))
// model

/** 0x4000 41B8 CANFD11_TXDATA14 **/
union CANFD11_TXDATA14_REG{
	unsigned int reg;
	struct CANFD11_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA14 (*((volatile union CANFD11_TXDATA14_REG *)0x400041B8))
// model

/** 0x4000 41BC CANFD11_TXDATA15 **/
union CANFD11_TXDATA15_REG{
	unsigned int reg;
	struct CANFD11_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA15 (*((volatile union CANFD11_TXDATA15_REG *)0x400041BC))
// model

/** 0x4000 41C0 CANFD11_TXDATA16 **/
union CANFD11_TXDATA16_REG{
	unsigned int reg;
	struct CANFD11_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA16 (*((volatile union CANFD11_TXDATA16_REG *)0x400041C0))
// model

/** 0x4000 41C4 CANFD11_TXDATA17 **/
union CANFD11_TXDATA17_REG{
	unsigned int reg;
	struct CANFD11_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TXDATA17 (*((volatile union CANFD11_TXDATA17_REG *)0x400041C4))
// model

/** 0x4000 41E0 CANFD11_CONFIGREG **/
union CANFD11_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD11_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_CONFIGREG (*((volatile union CANFD11_CONFIGREG_REG *)0x400041E0))
// model

/** 0x4000 41E4 CANFD11_TRSTA0 **/
union CANFD11_TRSTA0_REG{
	unsigned int reg;
	struct CANFD11_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TRSTA0 (*((volatile union CANFD11_TRSTA0_REG *)0x400041E4))
// model

/** 0x4000 41E8 CANFD11_TRSTA1 **/
union CANFD11_TRSTA1_REG{
	unsigned int reg;
	struct CANFD11_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_TRSTA1 (*((volatile union CANFD11_TRSTA1_REG *)0x400041E8))
// model

/** 0x4000 41EC CANFD11_RESTA0 **/
union CANFD11_RESTA0_REG{
	unsigned int reg;
	struct CANFD11_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RESTA0 (*((volatile union CANFD11_RESTA0_REG *)0x400041EC))
// model

/** 0x4000 41F0 CANFD11_RESTA1 **/
union CANFD11_RESTA1_REG{
	unsigned int reg;
	struct CANFD11_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD11_RESTA1 (*((volatile union CANFD11_RESTA1_REG *)0x400041F0))
// modelCANFD12

/** 0x4000 4300 CANFD12_CTLR0 **/
union CANFD12_CTLR0_REG{
	unsigned int reg;
	struct CANFD12_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_CTLR0 (*((volatile union CANFD12_CTLR0_REG *)0x40004300))
// model

/** 0x4000 4304 CANFD12_BRGR **/
union CANFD12_BRGR_REG{
	unsigned int reg;
	struct CANFD12_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_BRGR (*((volatile union CANFD12_BRGR_REG *)0x40004304))
// model

/** 0x4000 43F4 CANFD12_BRGR1 **/
union CANFD12_BRGR1_REG{
	unsigned int reg;
	struct CANFD12_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_BRGR1 (*((volatile union CANFD12_BRGR1_REG *)0x400043F4))
// model

/** 0x4000 4308 CANFD12_RCR **/
union CANFD12_RCR_REG{
	unsigned int reg;
	struct CANFD12_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RCR (*((volatile union CANFD12_RCR_REG *)0x40004308))
// model

/** 0x4000 430C CANFD12_EROR **/
union CANFD12_EROR_REG{
	unsigned int reg;
	struct CANFD12_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_EROR (*((volatile union CANFD12_EROR_REG *)0x4000430C))
// model

/** 0x4000 4310 CANFD12_CTLR2 **/
union CANFD12_CTLR2_REG{
	unsigned int reg;
	struct CANFD12_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_CTLR2 (*((volatile union CANFD12_CTLR2_REG *)0x40004310))
// model

/** 0x4000 4314 CANFD12_MSKR **/
union CANFD12_MSKR_REG{
	unsigned int reg;
	struct CANFD12_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_MSKR (*((volatile union CANFD12_MSKR_REG *)0x40004314))
// model

/** 0x4000 4318 CANFD12_IER **/
union CANFD12_IER_REG{
	unsigned int reg;
	struct CANFD12_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_IER (*((volatile union CANFD12_IER_REG *)0x40004318))
// model

/** 0x4000 431C CANFD12_IFR **/
union CANFD12_IFR_REG{
	unsigned int reg;
	struct CANFD12_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_IFR (*((volatile union CANFD12_IFR_REG *)0x4000431C))
// model

/** 0x4000 4320 CANFD12_RXDATA0 **/
union CANFD12_RXDATA0_REG{
	unsigned int reg;
	struct CANFD12_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA0 (*((volatile union CANFD12_RXDATA0_REG *)0x40004320))
// model

/** 0x4000 4324 CANFD12_RXDATA1 **/
union CANFD12_RXDATA1_REG{
	unsigned int reg;
	struct CANFD12_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA1 (*((volatile union CANFD12_RXDATA1_REG *)0x40004324))
// model

/** 0x4000 4328 CANFD12_RXDATA2 **/
union CANFD12_RXDATA2_REG{
	unsigned int reg;
	struct CANFD12_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA2 (*((volatile union CANFD12_RXDATA2_REG *)0x40004328))
// model

/** 0x4000 432C CANFD12_RXDATA3 **/
union CANFD12_RXDATA3_REG{
	unsigned int reg;
	struct CANFD12_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA3 (*((volatile union CANFD12_RXDATA3_REG *)0x4000432C))
// model

/** 0x4000 4330 CANFD12_RXDATA4 **/
union CANFD12_RXDATA4_REG{
	unsigned int reg;
	struct CANFD12_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA4 (*((volatile union CANFD12_RXDATA4_REG *)0x40004330))
// model

/** 0x4000 4334 CANFD12_RXDATA5 **/
union CANFD12_RXDATA5_REG{
	unsigned int reg;
	struct CANFD12_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA5 (*((volatile union CANFD12_RXDATA5_REG *)0x40004334))
// model

/** 0x4000 4338 CANFD12_RXDATA6 **/
union CANFD12_RXDATA6_REG{
	unsigned int reg;
	struct CANFD12_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA6 (*((volatile union CANFD12_RXDATA6_REG *)0x40004338))
// model

/** 0x4000 433C CANFD12_RXDATA7 **/
union CANFD12_RXDATA7_REG{
	unsigned int reg;
	struct CANFD12_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA7 (*((volatile union CANFD12_RXDATA7_REG *)0x4000433C))
// model

/** 0x4000 4340 CANFD12_RXDATA8 **/
union CANFD12_RXDATA8_REG{
	unsigned int reg;
	struct CANFD12_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA8 (*((volatile union CANFD12_RXDATA8_REG *)0x40004340))
// model

/** 0x4000 4344 CANFD12_RXDATA9 **/
union CANFD12_RXDATA9_REG{
	unsigned int reg;
	struct CANFD12_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA9 (*((volatile union CANFD12_RXDATA9_REG *)0x40004344))
// model

/** 0x4000 4348 CANFD12_RXDATA10 **/
union CANFD12_RXDATA10_REG{
	unsigned int reg;
	struct CANFD12_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA10 (*((volatile union CANFD12_RXDATA10_REG *)0x40004348))
// model

/** 0x4000 434C CANFD12_RXDATA11 **/
union CANFD12_RXDATA11_REG{
	unsigned int reg;
	struct CANFD12_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA11 (*((volatile union CANFD12_RXDATA11_REG *)0x4000434C))
// model

/** 0x4000 4350 CANFD12_RXDATA12 **/
union CANFD12_RXDATA12_REG{
	unsigned int reg;
	struct CANFD12_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA12 (*((volatile union CANFD12_RXDATA12_REG *)0x40004350))
// model

/** 0x4000 4354 CANFD12_RXDATA13 **/
union CANFD12_RXDATA13_REG{
	unsigned int reg;
	struct CANFD12_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA13 (*((volatile union CANFD12_RXDATA13_REG *)0x40004354))
// model

/** 0x4000 4358 CANFD12_RXDATA14 **/
union CANFD12_RXDATA14_REG{
	unsigned int reg;
	struct CANFD12_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA14 (*((volatile union CANFD12_RXDATA14_REG *)0x40004358))
// model

/** 0x4000 435C CANFD12_RXDATA15 **/
union CANFD12_RXDATA15_REG{
	unsigned int reg;
	struct CANFD12_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA15 (*((volatile union CANFD12_RXDATA15_REG *)0x4000435C))
// model

/** 0x4000 4360 CANFD12_RXDATA16 **/
union CANFD12_RXDATA16_REG{
	unsigned int reg;
	struct CANFD12_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA16 (*((volatile union CANFD12_RXDATA16_REG *)0x40004360))
// model

/** 0x4000 4364 CANFD12_RXDATA17 **/
union CANFD12_RXDATA17_REG{
	unsigned int reg;
	struct CANFD12_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RXDATA17 (*((volatile union CANFD12_RXDATA17_REG *)0x40004364))
// model

/** 0x4000 4368 CANFD12_TIMER **/
union CANFD12_TIMER_REG{
	unsigned int reg;
	struct CANFD12_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TIMER (*((volatile union CANFD12_TIMER_REG *)0x40004368))
// model

/** 0x4000 436C CANFD12_CRC **/
union CANFD12_CRC_REG{
	unsigned int reg;
	struct CANFD12_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_CRC (*((volatile union CANFD12_CRC_REG *)0x4000436C))
// model

/** 0x4000 4374 CANFD12_CTLR1 **/
union CANFD12_CTLR1_REG{
	unsigned int reg;
	struct CANFD12_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_CTLR1 (*((volatile union CANFD12_CTLR1_REG *)0x40004374))
// model

/** 0x4000 4378 CANFD12_AMSTA **/
union CANFD12_AMSTA_REG{
	unsigned int reg;
	struct CANFD12_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_AMSTA (*((volatile union CANFD12_AMSTA_REG *)0x40004378))
// model

/** 0x4000 4380 CANFD12_TXDATA0 **/
union CANFD12_TXDATA0_REG{
	unsigned int reg;
	struct CANFD12_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA0 (*((volatile union CANFD12_TXDATA0_REG *)0x40004380))
// model

/** 0x4000 4384 CANFD12_TXDATA1 **/
union CANFD12_TXDATA1_REG{
	unsigned int reg;
	struct CANFD12_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA1 (*((volatile union CANFD12_TXDATA1_REG *)0x40004384))
// model

/** 0x4000 4388 CANFD12_TXDATA2 **/
union CANFD12_TXDATA2_REG{
	unsigned int reg;
	struct CANFD12_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA2 (*((volatile union CANFD12_TXDATA2_REG *)0x40004388))
// model

/** 0x4000 438C CANFD12_TXDATA3 **/
union CANFD12_TXDATA3_REG{
	unsigned int reg;
	struct CANFD12_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA3 (*((volatile union CANFD12_TXDATA3_REG *)0x4000438C))
// model

/** 0x4000 4390 CANFD12_TXDATA4 **/
union CANFD12_TXDATA4_REG{
	unsigned int reg;
	struct CANFD12_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA4 (*((volatile union CANFD12_TXDATA4_REG *)0x40004390))
// model

/** 0x4000 4394 CANFD12_TXDATA5 **/
union CANFD12_TXDATA5_REG{
	unsigned int reg;
	struct CANFD12_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA5 (*((volatile union CANFD12_TXDATA5_REG *)0x40004394))
// model

/** 0x4000 4398 CANFD12_TXDATA6 **/
union CANFD12_TXDATA6_REG{
	unsigned int reg;
	struct CANFD12_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA6 (*((volatile union CANFD12_TXDATA6_REG *)0x40004398))
// model

/** 0x4000 439C CANFD12_TXDATA7 **/
union CANFD12_TXDATA7_REG{
	unsigned int reg;
	struct CANFD12_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA7 (*((volatile union CANFD12_TXDATA7_REG *)0x4000439C))
// model

/** 0x4000 43A0 CANFD12_TXDATA8 **/
union CANFD12_TXDATA8_REG{
	unsigned int reg;
	struct CANFD12_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA8 (*((volatile union CANFD12_TXDATA8_REG *)0x400043A0))
// model

/** 0x4000 43A4 CANFD12_TXDATA9 **/
union CANFD12_TXDATA9_REG{
	unsigned int reg;
	struct CANFD12_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA9 (*((volatile union CANFD12_TXDATA9_REG *)0x400043A4))
// model

/** 0x4000 43A8 CANFD12_TXDATA10 **/
union CANFD12_TXDATA10_REG{
	unsigned int reg;
	struct CANFD12_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA10 (*((volatile union CANFD12_TXDATA10_REG *)0x400043A8))
// model

/** 0x4000 43AC CANFD12_TXDATA11 **/
union CANFD12_TXDATA11_REG{
	unsigned int reg;
	struct CANFD12_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA11 (*((volatile union CANFD12_TXDATA11_REG *)0x400043AC))
// model

/** 0x4000 43B0 CANFD12_TXDATA12 **/
union CANFD12_TXDATA12_REG{
	unsigned int reg;
	struct CANFD12_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA12 (*((volatile union CANFD12_TXDATA12_REG *)0x400043B0))
// model

/** 0x4000 43B4 CANFD12_TXDATA13 **/
union CANFD12_TXDATA13_REG{
	unsigned int reg;
	struct CANFD12_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA13 (*((volatile union CANFD12_TXDATA13_REG *)0x400043B4))
// model

/** 0x4000 43B8 CANFD12_TXDATA14 **/
union CANFD12_TXDATA14_REG{
	unsigned int reg;
	struct CANFD12_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA14 (*((volatile union CANFD12_TXDATA14_REG *)0x400043B8))
// model

/** 0x4000 43BC CANFD12_TXDATA15 **/
union CANFD12_TXDATA15_REG{
	unsigned int reg;
	struct CANFD12_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA15 (*((volatile union CANFD12_TXDATA15_REG *)0x400043BC))
// model

/** 0x4000 43C0 CANFD12_TXDATA16 **/
union CANFD12_TXDATA16_REG{
	unsigned int reg;
	struct CANFD12_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA16 (*((volatile union CANFD12_TXDATA16_REG *)0x400043C0))
// model

/** 0x4000 43C4 CANFD12_TXDATA17 **/
union CANFD12_TXDATA17_REG{
	unsigned int reg;
	struct CANFD12_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TXDATA17 (*((volatile union CANFD12_TXDATA17_REG *)0x400043C4))
// model

/** 0x4000 43E0 CANFD12_CONFIGREG **/
union CANFD12_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD12_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_CONFIGREG (*((volatile union CANFD12_CONFIGREG_REG *)0x400043E0))
// model

/** 0x4000 43E4 CANFD12_TRSTA0 **/
union CANFD12_TRSTA0_REG{
	unsigned int reg;
	struct CANFD12_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TRSTA0 (*((volatile union CANFD12_TRSTA0_REG *)0x400043E4))
// model

/** 0x4000 43E8 CANFD12_TRSTA1 **/
union CANFD12_TRSTA1_REG{
	unsigned int reg;
	struct CANFD12_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_TRSTA1 (*((volatile union CANFD12_TRSTA1_REG *)0x400043E8))
// model

/** 0x4000 43EC CANFD12_RESTA0 **/
union CANFD12_RESTA0_REG{
	unsigned int reg;
	struct CANFD12_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RESTA0 (*((volatile union CANFD12_RESTA0_REG *)0x400043EC))
// model

/** 0x4000 43F0 CANFD12_RESTA1 **/
union CANFD12_RESTA1_REG{
	unsigned int reg;
	struct CANFD12_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD12_RESTA1 (*((volatile union CANFD12_RESTA1_REG *)0x400043F0))
// modelCANFD13

/** 0x4000 4500 CANFD13_CTLR0 **/
union CANFD13_CTLR0_REG{
	unsigned int reg;
	struct CANFD13_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_CTLR0 (*((volatile union CANFD13_CTLR0_REG *)0x40004500))
// model

/** 0x4000 4504 CANFD13_BRGR **/
union CANFD13_BRGR_REG{
	unsigned int reg;
	struct CANFD13_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _TSJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_BRGR (*((volatile union CANFD13_BRGR_REG *)0x40004504))
// model

/** 0x4000 45F4 CANFD13_BRGR1 **/
union CANFD13_BRGR1_REG{
	unsigned int reg;
	struct CANFD13_BRGR1_BITS{
		unsigned int _TSEG1:2;
		unsigned int _TSEG2_3:1;
		unsigned int _TSJW:2;
		unsigned int _HSJW:3;
		unsigned int _HTSEG1_4:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_BRGR1 (*((volatile union CANFD13_BRGR1_REG *)0x400045F4))
// model

/** 0x4000 4508 CANFD13_RCR **/
union CANFD13_RCR_REG{
	unsigned int reg;
	struct CANFD13_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int _SOFIE:1;
		unsigned int _NACKIE:1;
		unsigned int _ONLINEIE:1;
		unsigned int _SOFIC:1;
		unsigned int _NACKIC:1;
		unsigned int _ONLINEIC:1;
		unsigned int _SDETIC:1;
		unsigned int _SDETIE:1;
		unsigned int _SDETIF:1;
		unsigned int :4;
		unsigned int _ONLINE:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RCR (*((volatile union CANFD13_RCR_REG *)0x40004508))
// model

/** 0x4000 450C CANFD13_EROR **/
union CANFD13_EROR_REG{
	unsigned int reg;
	struct CANFD13_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_EROR (*((volatile union CANFD13_EROR_REG *)0x4000450C))
// model

/** 0x4000 4510 CANFD13_CTLR2 **/
union CANFD13_CTLR2_REG{
	unsigned int reg;
	struct CANFD13_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUTO:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDCO:2;
		unsigned int _TDCVM:7;
		unsigned int _CONFIG0:1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int _CONFIG1:1;
		unsigned int _CONFIG2:1;
		unsigned int _CONFIG3:1;
		unsigned int _CONFIG4:1;
		unsigned int _CONFIG5:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_CTLR2 (*((volatile union CANFD13_CTLR2_REG *)0x40004510))
// model

/** 0x4000 4514 CANFD13_MSKR **/
union CANFD13_MSKR_REG{
	unsigned int reg;
	struct CANFD13_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_MSKR (*((volatile union CANFD13_MSKR_REG *)0x40004514))
// model

/** 0x4000 4518 CANFD13_IER **/
union CANFD13_IER_REG{
	unsigned int reg;
	struct CANFD13_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int _TDCFAILIE:1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int _OPMOBSEL:1;
		unsigned int _CMOBEN:1;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int _TDCFAILIC:1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_IER (*((volatile union CANFD13_IER_REG *)0x40004518))
// model

/** 0x4000 451C CANFD13_IFR **/
union CANFD13_IFR_REG{
	unsigned int reg;
	struct CANFD13_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int _TDCFAILIF:1;
		unsigned int _MOENDIF:1;
		unsigned int _SOFIF:1;
		unsigned int _NACKIF:1;
		unsigned int _ONINEIF:1;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_IFR (*((volatile union CANFD13_IFR_REG *)0x4000451C))
// model

/** 0x4000 4520 CANFD13_RXDATA0 **/
union CANFD13_RXDATA0_REG{
	unsigned int reg;
	struct CANFD13_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA0 (*((volatile union CANFD13_RXDATA0_REG *)0x40004520))
// model

/** 0x4000 4524 CANFD13_RXDATA1 **/
union CANFD13_RXDATA1_REG{
	unsigned int reg;
	struct CANFD13_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA1 (*((volatile union CANFD13_RXDATA1_REG *)0x40004524))
// model

/** 0x4000 4528 CANFD13_RXDATA2 **/
union CANFD13_RXDATA2_REG{
	unsigned int reg;
	struct CANFD13_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA2 (*((volatile union CANFD13_RXDATA2_REG *)0x40004528))
// model

/** 0x4000 452C CANFD13_RXDATA3 **/
union CANFD13_RXDATA3_REG{
	unsigned int reg;
	struct CANFD13_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA3 (*((volatile union CANFD13_RXDATA3_REG *)0x4000452C))
// model

/** 0x4000 4530 CANFD13_RXDATA4 **/
union CANFD13_RXDATA4_REG{
	unsigned int reg;
	struct CANFD13_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA4 (*((volatile union CANFD13_RXDATA4_REG *)0x40004530))
// model

/** 0x4000 4534 CANFD13_RXDATA5 **/
union CANFD13_RXDATA5_REG{
	unsigned int reg;
	struct CANFD13_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA5 (*((volatile union CANFD13_RXDATA5_REG *)0x40004534))
// model

/** 0x4000 4538 CANFD13_RXDATA6 **/
union CANFD13_RXDATA6_REG{
	unsigned int reg;
	struct CANFD13_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA6 (*((volatile union CANFD13_RXDATA6_REG *)0x40004538))
// model

/** 0x4000 453C CANFD13_RXDATA7 **/
union CANFD13_RXDATA7_REG{
	unsigned int reg;
	struct CANFD13_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA7 (*((volatile union CANFD13_RXDATA7_REG *)0x4000453C))
// model

/** 0x4000 4540 CANFD13_RXDATA8 **/
union CANFD13_RXDATA8_REG{
	unsigned int reg;
	struct CANFD13_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA8 (*((volatile union CANFD13_RXDATA8_REG *)0x40004540))
// model

/** 0x4000 4544 CANFD13_RXDATA9 **/
union CANFD13_RXDATA9_REG{
	unsigned int reg;
	struct CANFD13_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA9 (*((volatile union CANFD13_RXDATA9_REG *)0x40004544))
// model

/** 0x4000 4548 CANFD13_RXDATA10 **/
union CANFD13_RXDATA10_REG{
	unsigned int reg;
	struct CANFD13_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA10 (*((volatile union CANFD13_RXDATA10_REG *)0x40004548))
// model

/** 0x4000 454C CANFD13_RXDATA11 **/
union CANFD13_RXDATA11_REG{
	unsigned int reg;
	struct CANFD13_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA11 (*((volatile union CANFD13_RXDATA11_REG *)0x4000454C))
// model

/** 0x4000 4550 CANFD13_RXDATA12 **/
union CANFD13_RXDATA12_REG{
	unsigned int reg;
	struct CANFD13_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA12 (*((volatile union CANFD13_RXDATA12_REG *)0x40004550))
// model

/** 0x4000 4554 CANFD13_RXDATA13 **/
union CANFD13_RXDATA13_REG{
	unsigned int reg;
	struct CANFD13_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA13 (*((volatile union CANFD13_RXDATA13_REG *)0x40004554))
// model

/** 0x4000 4558 CANFD13_RXDATA14 **/
union CANFD13_RXDATA14_REG{
	unsigned int reg;
	struct CANFD13_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA14 (*((volatile union CANFD13_RXDATA14_REG *)0x40004558))
// model

/** 0x4000 455C CANFD13_RXDATA15 **/
union CANFD13_RXDATA15_REG{
	unsigned int reg;
	struct CANFD13_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA15 (*((volatile union CANFD13_RXDATA15_REG *)0x4000455C))
// model

/** 0x4000 4560 CANFD13_RXDATA16 **/
union CANFD13_RXDATA16_REG{
	unsigned int reg;
	struct CANFD13_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA16 (*((volatile union CANFD13_RXDATA16_REG *)0x40004560))
// model

/** 0x4000 4564 CANFD13_RXDATA17 **/
union CANFD13_RXDATA17_REG{
	unsigned int reg;
	struct CANFD13_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RXDATA17 (*((volatile union CANFD13_RXDATA17_REG *)0x40004564))
// model

/** 0x4000 4568 CANFD13_TIMER **/
union CANFD13_TIMER_REG{
	unsigned int reg;
	struct CANFD13_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TIMER (*((volatile union CANFD13_TIMER_REG *)0x40004568))
// model

/** 0x4000 456C CANFD13_CRC **/
union CANFD13_CRC_REG{
	unsigned int reg;
	struct CANFD13_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_CRC (*((volatile union CANFD13_CRC_REG *)0x4000456C))
// model

/** 0x4000 4574 CANFD13_CTLR1 **/
union CANFD13_CTLR1_REG{
	unsigned int reg;
	struct CANFD13_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_CTLR1 (*((volatile union CANFD13_CTLR1_REG *)0x40004574))
// model

/** 0x4000 4578 CANFD13_AMSTA **/
union CANFD13_AMSTA_REG{
	unsigned int reg;
	struct CANFD13_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_AMSTA (*((volatile union CANFD13_AMSTA_REG *)0x40004578))
// model

/** 0x4000 4580 CANFD13_TXDATA0 **/
union CANFD13_TXDATA0_REG{
	unsigned int reg;
	struct CANFD13_TXDATA0_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA0 (*((volatile union CANFD13_TXDATA0_REG *)0x40004580))
// model

/** 0x4000 4584 CANFD13_TXDATA1 **/
union CANFD13_TXDATA1_REG{
	unsigned int reg;
	struct CANFD13_TXDATA1_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA1 (*((volatile union CANFD13_TXDATA1_REG *)0x40004584))
// model

/** 0x4000 4588 CANFD13_TXDATA2 **/
union CANFD13_TXDATA2_REG{
	unsigned int reg;
	struct CANFD13_TXDATA2_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA2 (*((volatile union CANFD13_TXDATA2_REG *)0x40004588))
// model

/** 0x4000 458C CANFD13_TXDATA3 **/
union CANFD13_TXDATA3_REG{
	unsigned int reg;
	struct CANFD13_TXDATA3_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA3 (*((volatile union CANFD13_TXDATA3_REG *)0x4000458C))
// model

/** 0x4000 4590 CANFD13_TXDATA4 **/
union CANFD13_TXDATA4_REG{
	unsigned int reg;
	struct CANFD13_TXDATA4_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA4 (*((volatile union CANFD13_TXDATA4_REG *)0x40004590))
// model

/** 0x4000 4594 CANFD13_TXDATA5 **/
union CANFD13_TXDATA5_REG{
	unsigned int reg;
	struct CANFD13_TXDATA5_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA5 (*((volatile union CANFD13_TXDATA5_REG *)0x40004594))
// model

/** 0x4000 4598 CANFD13_TXDATA6 **/
union CANFD13_TXDATA6_REG{
	unsigned int reg;
	struct CANFD13_TXDATA6_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA6 (*((volatile union CANFD13_TXDATA6_REG *)0x40004598))
// model

/** 0x4000 459C CANFD13_TXDATA7 **/
union CANFD13_TXDATA7_REG{
	unsigned int reg;
	struct CANFD13_TXDATA7_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA7 (*((volatile union CANFD13_TXDATA7_REG *)0x4000459C))
// model

/** 0x4000 45A0 CANFD13_TXDATA8 **/
union CANFD13_TXDATA8_REG{
	unsigned int reg;
	struct CANFD13_TXDATA8_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA8 (*((volatile union CANFD13_TXDATA8_REG *)0x400045A0))
// model

/** 0x4000 45A4 CANFD13_TXDATA9 **/
union CANFD13_TXDATA9_REG{
	unsigned int reg;
	struct CANFD13_TXDATA9_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA9 (*((volatile union CANFD13_TXDATA9_REG *)0x400045A4))
// model

/** 0x4000 45A8 CANFD13_TXDATA10 **/
union CANFD13_TXDATA10_REG{
	unsigned int reg;
	struct CANFD13_TXDATA10_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA10 (*((volatile union CANFD13_TXDATA10_REG *)0x400045A8))
// model

/** 0x4000 45AC CANFD13_TXDATA11 **/
union CANFD13_TXDATA11_REG{
	unsigned int reg;
	struct CANFD13_TXDATA11_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA11 (*((volatile union CANFD13_TXDATA11_REG *)0x400045AC))
// model

/** 0x4000 45B0 CANFD13_TXDATA12 **/
union CANFD13_TXDATA12_REG{
	unsigned int reg;
	struct CANFD13_TXDATA12_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA12 (*((volatile union CANFD13_TXDATA12_REG *)0x400045B0))
// model

/** 0x4000 45B4 CANFD13_TXDATA13 **/
union CANFD13_TXDATA13_REG{
	unsigned int reg;
	struct CANFD13_TXDATA13_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA13 (*((volatile union CANFD13_TXDATA13_REG *)0x400045B4))
// model

/** 0x4000 45B8 CANFD13_TXDATA14 **/
union CANFD13_TXDATA14_REG{
	unsigned int reg;
	struct CANFD13_TXDATA14_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA14 (*((volatile union CANFD13_TXDATA14_REG *)0x400045B8))
// model

/** 0x4000 45BC CANFD13_TXDATA15 **/
union CANFD13_TXDATA15_REG{
	unsigned int reg;
	struct CANFD13_TXDATA15_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA15 (*((volatile union CANFD13_TXDATA15_REG *)0x400045BC))
// model

/** 0x4000 45C0 CANFD13_TXDATA16 **/
union CANFD13_TXDATA16_REG{
	unsigned int reg;
	struct CANFD13_TXDATA16_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA16 (*((volatile union CANFD13_TXDATA16_REG *)0x400045C0))
// model

/** 0x4000 45C4 CANFD13_TXDATA17 **/
union CANFD13_TXDATA17_REG{
	unsigned int reg;
	struct CANFD13_TXDATA17_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TXDATA17 (*((volatile union CANFD13_TXDATA17_REG *)0x400045C4))
// model

/** 0x4000 45E0 CANFD13_CONFIGREG **/
union CANFD13_CONFIGREG_REG{
	unsigned int reg;
	struct CANFD13_CONFIGREG_BITS{
		unsigned int _CONFIGEN0:1;
		unsigned int _CONFIGEN1:1;
		unsigned int _CONFIGEN2:1;
		unsigned int _CONFIGEN3:1;
		unsigned int _CONFIGEN4:1;
		unsigned int _CONFIGEN5:1;
		unsigned int _CONFIGEN6:1;
		unsigned int _CONFIGEN7:1;
		unsigned int _CONFIGEN8:1;
		unsigned int _CONFIGEN9:1;
		unsigned int _CONFIGEN10:1;
		unsigned int _CONFIGEN11:1;
		unsigned int _CONFIGEN12:1;
		unsigned int _CONFIGEN13:1;
		unsigned int _CONFIGEN14:1;
		unsigned int _CONFIGEN15:1;
		unsigned int _CONFIGEN16:1;
		unsigned int _CONFIGEN17:1;
		unsigned int _CONFIGEN18:1;
		unsigned int _CONFIGEN19:1;
		unsigned int _CONFIGEN20:1;
		unsigned int _CONFIGEN21:1;
		unsigned int _CONFIGEN22:1;
		unsigned int _CONFIGEN23:1;
		unsigned int _CONFIGEN24:1;
		unsigned int _CONFIGEN25:1;
		unsigned int _CONFIGEN26:1;
		unsigned int _CONFIGEN27:1;
		unsigned int _CONFIGEN28:1;
		unsigned int _CONFIGEN29:1;
		unsigned int _CONFIGEN30:1;
		unsigned int _CONFIGEN31:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_CONFIGREG (*((volatile union CANFD13_CONFIGREG_REG *)0x400045E0))
// model

/** 0x4000 45E4 CANFD13_TRSTA0 **/
union CANFD13_TRSTA0_REG{
	unsigned int reg;
	struct CANFD13_TRSTA0_BITS{
		unsigned int _TRSTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TRSTA0 (*((volatile union CANFD13_TRSTA0_REG *)0x400045E4))
// model

/** 0x4000 45E8 CANFD13_TRSTA1 **/
union CANFD13_TRSTA1_REG{
	unsigned int reg;
	struct CANFD13_TRSTA1_BITS{
		unsigned int _TRSTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_TRSTA1 (*((volatile union CANFD13_TRSTA1_REG *)0x400045E8))
// model

/** 0x4000 45EC CANFD13_RESTA0 **/
union CANFD13_RESTA0_REG{
	unsigned int reg;
	struct CANFD13_RESTA0_BITS{
		unsigned int _RESTA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RESTA0 (*((volatile union CANFD13_RESTA0_REG *)0x400045EC))
// model

/** 0x4000 45F0 CANFD13_RESTA1 **/
union CANFD13_RESTA1_REG{
	unsigned int reg;
	struct CANFD13_RESTA1_BITS{
		unsigned int _RESTA1:19;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD13_RESTA1 (*((volatile union CANFD13_RESTA1_REG *)0x400045F0))
// modelRTC

/** 0x4000 0F00 RTC_CR **/
union RTC_CR_REG{
	unsigned int reg;
	struct RTC_CR_BITS{
		unsigned int _RTCEN:1;
		unsigned int _LD:1;
		unsigned int _RTOFF:1;
		unsigned int _CNT:1;
		unsigned int _HT:1;
		unsigned int _LIF:1;
		unsigned int _RESET:1;
		unsigned int :1;
		unsigned int _RTCTSCH:6;
		unsigned int :2;
		unsigned int _RTCTT:3;
		unsigned int _SUB1H:1;
		unsigned int _ADD1H:1;
		unsigned int _TSEN:1;
		unsigned int _TSEDGE:1;
		unsigned int :1;
		unsigned int _RTCCAL:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_CR (*((volatile union RTC_CR_REG *)0x40000F00))
// model

/** 0x4000 0F04 RTC_ALRA **/
union RTC_ALRA_REG{
	unsigned int reg;
	struct RTC_ALRA_BITS{
		unsigned int _ALRSA:7;
		unsigned int _ASENA:1;
		unsigned int _ALRMA:7;
		unsigned int _AMENA:1;
		unsigned int _ALRHA:6;
		unsigned int _AMPMA:1;
		unsigned int _AHENA:1;
		unsigned int _ALRWA:3;
		unsigned int _AWENA:1;
		unsigned int :3;
		unsigned int _ALRENA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_ALRA (*((volatile union RTC_ALRA_REG *)0x40000F04))
// model

/** 0x4000 0F08 RTC_TMR **/
union RTC_TMR_REG{
	unsigned int reg;
	struct RTC_TMR_BITS{
		unsigned int _SEC:7;
		unsigned int :1;
		unsigned int _MIN:7;
		unsigned int :1;
		unsigned int _HOUR:6;
		unsigned int _AMPM:1;
		unsigned int :1;
		unsigned int _WEK:3;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMR (*((volatile union RTC_TMR_REG *)0x40000F08))
// model

/** 0x4000 0F0C RTC_DTR **/
union RTC_DTR_REG{
	unsigned int reg;
	struct RTC_DTR_BITS{
		unsigned int _DAY:6;
		unsigned int :2;
		unsigned int _MTH:5;
		unsigned int :3;
		unsigned int _YEAR:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_DTR (*((volatile union RTC_DTR_REG *)0x40000F0C))
// model

/** 0x4000 0F10 RTC_ALRB **/
union RTC_ALRB_REG{
	unsigned int reg;
	struct RTC_ALRB_BITS{
		unsigned int _ALRSB:7;
		unsigned int _ASENB:1;
		unsigned int _ALRMB:7;
		unsigned int _AMENB:1;
		unsigned int _ALRHB:6;
		unsigned int _AMPMB:1;
		unsigned int _AHENB:1;
		unsigned int _ALRWB:3;
		unsigned int _AWENB:1;
		unsigned int :3;
		unsigned int _ALRENB:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_ALRB (*((volatile union RTC_ALRB_REG *)0x40000F10))
// model

/** 0x4000 0F14 RTC_TMER **/
union RTC_TMER_REG{
	unsigned int reg;
	struct RTC_TMER_BITS{
		unsigned int _TMR0:16;
		unsigned int _TMR1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMER (*((volatile union RTC_TMER_REG *)0x40000F14))
// model

/** 0x4000 0F18 RTC_TCR **/
union RTC_TCR_REG{
	unsigned int reg;
	struct RTC_TCR_BITS{
		unsigned int _TMR0C:4;
		unsigned int _TMR1C:4;
		unsigned int _TMR0EN:1;
		unsigned int _TMR1EN:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TCR (*((volatile union RTC_TCR_REG *)0x40000F18))
// model

/** 0x4000 0F1C RTC_IER **/
union RTC_IER_REG{
	unsigned int reg;
	struct RTC_IER_BITS{
		unsigned int _SECIE:1;
		unsigned int _MINIE:1;
		unsigned int _HOURIE:1;
		unsigned int _DAYIE:1;
		unsigned int _ALRAIE:1;
		unsigned int _ALRBIE:1;
		unsigned int _TTIE:1;
		unsigned int :1;
		unsigned int _RTCT0IE:1;
		unsigned int _RTCT1IE:1;
		unsigned int _TSOVFIE:1;
		unsigned int _TSIE:1;
		unsigned int :1;
		unsigned int _WEEKIE:1;
		unsigned int _MONTHIE:1;
		unsigned int _YEARIE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_IER (*((volatile union RTC_IER_REG *)0x40000F1C))
// model

/** 0x4000 0F20 RTC_IFR **/
union RTC_IFR_REG{
	unsigned int reg;
	struct RTC_IFR_BITS{
		unsigned int _SECIF:1;
		unsigned int _MINIF:1;
		unsigned int _HOURIF:1;
		unsigned int _DAYIF:1;
		unsigned int _ALRAIF:1;
		unsigned int _ALRBIF:1;
		unsigned int _TTIF:1;
		unsigned int :1;
		unsigned int _RTCT0IF:1;
		unsigned int _RTCT1IF:1;
		unsigned int _TSOVFIF:1;
		unsigned int _TSIF:1;
		unsigned int :1;
		unsigned int _WEEKIF:1;
		unsigned int _MONTHIF:1;
		unsigned int _YEARIF:1;
		unsigned int _SECIC:1;
		unsigned int _MINIC:1;
		unsigned int _HOURIC:1;
		unsigned int _DAYIC:1;
		unsigned int _ALRAIC:1;
		unsigned int _ALRBIC:1;
		unsigned int _TTIC:1;
		unsigned int :1;
		unsigned int _RTCT0IC:1;
		unsigned int _RTCT1IC:1;
		unsigned int _TSOVFIC:1;
		unsigned int _TSIC:1;
		unsigned int :1;
		unsigned int _WEEKIC:1;
		unsigned int _MONTHIC:1;
		unsigned int _YEARIC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_IFR (*((volatile union RTC_IFR_REG *)0x40000F20))
// model

/** 0x4000 0F24 RTC_TMBR **/
union RTC_TMBR_REG{
	unsigned int reg;
	struct RTC_TMBR_BITS{
		unsigned int _SECB:7;
		unsigned int :1;
		unsigned int _MINB:7;
		unsigned int :1;
		unsigned int _HOURB:6;
		unsigned int _AMPMB:1;
		unsigned int :1;
		unsigned int _WEKB:3;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMBR (*((volatile union RTC_TMBR_REG *)0x40000F24))
// model

/** 0x4000 0F28 RTC_DTBR **/
union RTC_DTBR_REG{
	unsigned int reg;
	struct RTC_DTBR_BITS{
		unsigned int _DAYB:6;
		unsigned int :2;
		unsigned int _MTHB:5;
		unsigned int :3;
		unsigned int _YEARB:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_DTBR (*((volatile union RTC_DTBR_REG *)0x40000F28))
// model

/** 0x4000 0F2C RTC_FASTEST **/
union RTC_FASTEST_REG{
	unsigned int reg;
	struct RTC_FASTEST_BITS{
		unsigned int :24;
		unsigned int _FASTTESTEN:1;
		unsigned int :1;
		unsigned int _MINTESTEN:1;
		unsigned int _HOURTESTEN:1;
		unsigned int _DAYTESTEN:1;
		unsigned int _WEEKTESTEN:1;
		unsigned int _MONTHTESTEN:1;
		unsigned int _YEARTESTEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_FASTEST (*((volatile union RTC_FASTEST_REG *)0x40000F2C))
// modelIWDT

/** 0x4000 1200 IWDT_CTL **/
union IWDT_CTL_REG{
	unsigned int reg;
	struct IWDT_CTL_BITS{
		unsigned int _IWDTPS:4;
		unsigned int _IWDTOVF:12;
		unsigned int :13;
		unsigned int _CLKS:1;
		unsigned int _IWDTTPEN:1;
		unsigned int _IWDTEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_CTL (*((volatile union IWDT_CTL_REG *)0x40001200))
// model

/** 0x4000 1204 IWDT_FD **/
union IWDT_FD_REG{
	unsigned int reg;
	struct IWDT_FD_BITS{
		unsigned int _IWDTFD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_FD (*((volatile union IWDT_FD_REG *)0x40001204))
// modelWWDT

/** 0x4000 1280 WWDT_CTL **/
union WWDT_CTL_REG{
	unsigned int reg;
	struct WWDT_CTL_BITS{
		unsigned int _WWDTEN:1;
		unsigned int _WWDTIE:1;
		unsigned int _WWDTIF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WWDTIC:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL (*((volatile union WWDT_CTL_REG *)0x40001280))
// model

/** 0x4000 1284 WWDT_CNT **/
union WWDT_CNT_REG{
	unsigned int reg;
	struct WWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CNT (*((volatile union WWDT_CNT_REG *)0x40001284))
// model

/** 0x4000 1288 WWDT_CTL1 **/
union WWDT_CTL1_REG{
	unsigned int reg;
	struct WWDT_CTL1_BITS{
		unsigned int _CLKS:2;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL1 (*((volatile union WWDT_CTL1_REG *)0x40001288))
// modelEWDT

/** 0x4000 2B00 EWDT_CTL **/
union EWDT_CTL_REG{
	unsigned int reg;
	struct EWDT_CTL_BITS{
		unsigned int _EWDTEN:1;
		unsigned int _WT40IE:1;
		unsigned int _WT40IF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WT40IC:1;
		unsigned int _EWDTINEN:1;
		unsigned int _EWDTINPOL:1;
		unsigned int _CLK:2;
		unsigned int _TPEN:1;
		unsigned int _EWDTRSTIE:1;
		unsigned int _EWDTRSTIC:1;
		unsigned int _EWDTRSTIF:1;
		unsigned int _OUTSEL:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EWDT_CTL (*((volatile union EWDT_CTL_REG *)0x40002B00))
// model

/** 0x4000 2B04 EWDT_CNT **/
union EWDT_CNT_REG{
	unsigned int reg;
	struct EWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EWDT_CNT (*((volatile union EWDT_CNT_REG *)0x40002B04))
// modelRST

/** 0x4000 1500 RST_CTL0 **/
union RST_CTL0_REG{
	unsigned int reg;
	struct RST_CTL0_BITS{
		unsigned int _GPIOARST:1;
		unsigned int _GPIOBRST:1;
		unsigned int _GPIOCRST:1;
		unsigned int _GPIODRST:1;
		unsigned int _GPIOERST:1;
		unsigned int _GPIOFRST:1;
		unsigned int _GPIOGRST:1;
		unsigned int _GPIOHRST:1;
		unsigned int _GPIOJRST:1;
		unsigned int _GPIOKRST:1;
		unsigned int :21;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL0 (*((volatile union RST_CTL0_REG *)0x40001500))
// model

/** 0x4000 1504 RST_CTL1 **/
union RST_CTL1_REG{
	unsigned int reg;
	struct RST_CTL1_BITS{
		unsigned int _QSPIRST:1;
		unsigned int _QEI1RST:1;
		unsigned int _T1RST:1;
		unsigned int _T2RST:1;
		unsigned int _T3RST:1;
		unsigned int _T4RST:1;
		unsigned int _T5T6RST:1;
		unsigned int _EXMCRST:1;
		unsigned int _T9T10RST:1;
		unsigned int _T25T26RST:1;
		unsigned int _QEI0RST:1;
		unsigned int _ADC0RST:1;
		unsigned int _ADC1RST:1;
		unsigned int _ADC2RST:1;
		unsigned int _DAC0RST:1;
		unsigned int _DAC1RST:1;
		unsigned int _CMPRST:1;
		unsigned int _T0RST:1;
		unsigned int _CTOUCHRST:1;
		unsigned int _USART0RST:1;
		unsigned int _USART1RST:1;
		unsigned int _USART2RST:1;
		unsigned int _USART3RST:1;
		unsigned int _USART4RST:1;
		unsigned int _SPI0RST:1;
		unsigned int _SPI1RST:1;
		unsigned int _I2C0RST:1;
		unsigned int _I2C1RST:1;
		unsigned int _I2C2RST:1;
		unsigned int :1;
		unsigned int _MPURST:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL1 (*((volatile union RST_CTL1_REG *)0x40001504))
// model

/** 0x4000 1508 RST_CTL2 **/
union RST_CTL2_REG{
	unsigned int reg;
	struct RST_CTL2_BITS{
		unsigned int _USART12RST:1;
		unsigned int _USART13RST:1;
		unsigned int _USART14RST:1;
		unsigned int _USART15RST:1;
		unsigned int _ISMUTESTRST:1;
		unsigned int _WWDTRST:1;
		unsigned int :2;
		unsigned int _EPWM11RST:1;
		unsigned int _EPWM12RST:1;
		unsigned int _EPWM13RST:1;
		unsigned int _EPWM16RST:1;
		unsigned int _DMA0RST:1;
		unsigned int _AES1RST:1;
		unsigned int _DMA1RST:1;
		unsigned int _ECC18RST:1;
		unsigned int _T14RST:1;
		unsigned int :1;
		unsigned int _ECC17RST:1;
		unsigned int _ECC16RST:1;
		unsigned int :1;
		unsigned int _T18RST:1;
		unsigned int _T19RST:1;
		unsigned int _T20RST:1;
		unsigned int _T21RST:1;
		unsigned int _T22RST:1;
		unsigned int _T23RST:1;
		unsigned int :2;
		unsigned int _USART5RST:1;
		unsigned int _USART6RST:1;
		unsigned int _USART7RST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL2 (*((volatile union RST_CTL2_REG *)0x40001508))
// model

/** 0x4000 150C RST_CTL3 **/
union RST_CTL3_REG{
	unsigned int reg;
	struct RST_CTL3_BITS{
		unsigned int :1;
		unsigned int _SPI2RST:1;
		unsigned int _SPI3RST:1;
		unsigned int :1;
		unsigned int _HRCAP3RST:1;
		unsigned int _HRCAP4RST:1;
		unsigned int _HRCAP5RST:1;
		unsigned int _I2C3RST:1;
		unsigned int _HRCAP0RST:1;
		unsigned int _HRCAP1RST:1;
		unsigned int _HRCAP2RST:1;
		unsigned int _REMAPTESTRST:1;
		unsigned int _CMURST:1;
		unsigned int _CRCRST:1;
		unsigned int _AESRST:1;
		unsigned int :2;
		unsigned int _CAN4RST:1;
		unsigned int :1;
		unsigned int _CFGLRST:1;
		unsigned int :1;
		unsigned int _FLEXMUXRST:1;
		unsigned int _FDC0RST:1;
		unsigned int _FDC1RST:1;
		unsigned int _FDC2RST:1;
		unsigned int _FLEXRMRST:1;
		unsigned int _ECFGLRST:1;
		unsigned int _EWDTRST:1;
		unsigned int _RNGRST:1;
		unsigned int _CANFD6RST:1;
		unsigned int _CANFD7RST:1;
		unsigned int _ECC15RST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL3 (*((volatile union RST_CTL3_REG *)0x4000150C))
// model

/** 0x4000 1510 RST_CTL4 **/
union RST_CTL4_REG{
	unsigned int reg;
	struct RST_CTL4_BITS{
		unsigned int _CANFD8RST:1;
		unsigned int _CANFD9RST:1;
		unsigned int _CANFD10RST:1;
		unsigned int _CANFD11RST:1;
		unsigned int _CANFD12RST:1;
		unsigned int _CANFD13RST:1;
		unsigned int _USART8RST:1;
		unsigned int _USART9RST:1;
		unsigned int _USART10RST:1;
		unsigned int _USART11RST:1;
		unsigned int _ECC4RST:1;
		unsigned int _ECC5RST:1;
		unsigned int _ECC6RST:1;
		unsigned int _ECC7RST:1;
		unsigned int _ECC8RST:1;
		unsigned int _ECC9RST:1;
		unsigned int _ECC10RST:1;
		unsigned int _ECC11RST:1;
		unsigned int _ECC12RST:1;
		unsigned int _ECC13RST:1;
		unsigned int _ECC0RST:1;
		unsigned int _ECC1RST:1;
		unsigned int _ECC2RST:1;
		unsigned int _ECC3RST:1;
		unsigned int _ECC19RST:1;
		unsigned int _ECC20RST:1;
		unsigned int _EPWM31RST:1;
		unsigned int _EPWM32RST:1;
		unsigned int _EPWM33RST:1;
		unsigned int _EPWM36RST:1;
		unsigned int _WRLOCKRST:1;
		unsigned int _ECC14RST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL4 (*((volatile union RST_CTL4_REG *)0x40001510))
// modelCLKEN

/** 0x4000 2640 PCLK_CTL0 **/
union PCLK_CTL0_REG{
	unsigned int reg;
	struct PCLK_CTL0_BITS{
		unsigned int _GPIOACLKEN:1;
		unsigned int _GPIOBCLKEN:1;
		unsigned int _GPIOCCLKEN:1;
		unsigned int _GPIODCLKEN:1;
		unsigned int _GPIOECLKEN:1;
		unsigned int _GPIOFCLKEN:1;
		unsigned int _GPIOGCLKEN:1;
		unsigned int _GPIOHCLKEN:1;
		unsigned int _GPIOJCLKEN:1;
		unsigned int _GPIOKCLKEN:1;
		unsigned int :21;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL0 (*((volatile union PCLK_CTL0_REG *)0x40002640))
// model

/** 0x4000 2644 PCLK_CTL1 **/
union PCLK_CTL1_REG{
	unsigned int reg;
	struct PCLK_CTL1_BITS{
		unsigned int _QSPICLKEN:1;
		unsigned int _QEI1CLKEN:1;
		unsigned int _T1CLKEN:1;
		unsigned int _T2CLKEN:1;
		unsigned int _T3CLKEN:1;
		unsigned int _T4CLKEN:1;
		unsigned int _T5T6CLKEN:1;
		unsigned int _EXMCCLKEN:1;
		unsigned int _T9T10CLKEN:1;
		unsigned int _T25T26CLKEN:1;
		unsigned int _QEI0CLKEN:1;
		unsigned int _ADC0CLKEN:1;
		unsigned int _ADC1CLKEN:1;
		unsigned int _ADC2CLKEN:1;
		unsigned int _DAC0CLKEN:1;
		unsigned int _DAC1CLKEN:1;
		unsigned int _CMPCLKEN:1;
		unsigned int _T0CLKEN:1;
		unsigned int _CTOUCHCLKEN:1;
		unsigned int _USART0CLKEN:1;
		unsigned int _USART1CLKEN:1;
		unsigned int _USART2CLKEN:1;
		unsigned int _USART3CLKEN:1;
		unsigned int _USART4CLKEN:1;
		unsigned int _SPI0CLKEN:1;
		unsigned int _SPI1CLKEN:1;
		unsigned int _I2C0CLKEN:1;
		unsigned int _I2C1CLKEN:1;
		unsigned int _I2C2CLKEN:1;
		unsigned int :1;
		unsigned int _MPUCLKEN:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL1 (*((volatile union PCLK_CTL1_REG *)0x40002644))
// model

/** 0x4000 2648 PCLK_CTL2 **/
union PCLK_CTL2_REG{
	unsigned int reg;
	struct PCLK_CTL2_BITS{
		unsigned int _USART12CLKEN:1;
		unsigned int _USART13CLKEN:1;
		unsigned int _USART14CLKEN:1;
		unsigned int _USART15CLKEN:1;
		unsigned int _ISMUTESTCLKEN:1;
		unsigned int _WWDTCLKEN:1;
		unsigned int :2;
		unsigned int _EPWM11CLKEN:1;
		unsigned int _EPWM12CLKEN:1;
		unsigned int _EPWM13CLKEN:1;
		unsigned int _EPWM16CLKEN:1;
		unsigned int _DMA0CLKEN:1;
		unsigned int _AES1CLKEN:1;
		unsigned int _DMA1CLKEN:1;
		unsigned int _ECC18CLKEN:1;
		unsigned int _T14CLKEN:1;
		unsigned int :1;
		unsigned int _ECC17CLKEN:1;
		unsigned int _ECC16CLKEN:1;
		unsigned int :1;
		unsigned int _T18CLKEN:1;
		unsigned int _T19CLKEN:1;
		unsigned int _T20CLKEN:1;
		unsigned int _T21CLKEN:1;
		unsigned int _T22CLKEN:1;
		unsigned int _T23CLKEN:1;
		unsigned int :2;
		unsigned int _USART5CLKEN:1;
		unsigned int _USART6CLKEN:1;
		unsigned int _USART7CLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL2 (*((volatile union PCLK_CTL2_REG *)0x40002648))
// model

/** 0x4000 264C PCLK_CTL3 **/
union PCLK_CTL3_REG{
	unsigned int reg;
	struct PCLK_CTL3_BITS{
		unsigned int :1;
		unsigned int _SPI2CLKEN:1;
		unsigned int _SPI3CLKEN:1;
		unsigned int :1;
		unsigned int _HRCAP3CLKEN:1;
		unsigned int _HRCAP4CLKEN:1;
		unsigned int _HRCAP5CLKEN:1;
		unsigned int _I2C3CLKEN:1;
		unsigned int _HRCAP0CLKEN:1;
		unsigned int _HRCAP1CLKEN:1;
		unsigned int _HRCAP2CLKEN:1;
		unsigned int _REMAPTESTCLKEN:1;
		unsigned int _CMUCLKEN:1;
		unsigned int _CRCCLKEN:1;
		unsigned int _AESCLKEN:1;
		unsigned int :2;
		unsigned int _CAN4CLKEN:1;
		unsigned int :1;
		unsigned int _CFGLCLKEN:1;
		unsigned int :1;
		unsigned int _FLEXMUXCLKEN:1;
		unsigned int _FDC0CLKEN:1;
		unsigned int _FDC1CLKEN:1;
		unsigned int _FDC2CLKEN:1;
		unsigned int _FLEXRMCLKEN:1;
		unsigned int _ECFGLCLKEN:1;
		unsigned int _EWDTCLKEN:1;
		unsigned int _RNGCLKEN:1;
		unsigned int _CANFD6CLKEN:1;
		unsigned int _CANFD7CLKEN:1;
		unsigned int _ECC15CLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL3 (*((volatile union PCLK_CTL3_REG *)0x4000264C))
// model

/** 0x4000 2650 PCLK_CTL4 **/
union PCLK_CTL4_REG{
	unsigned int reg;
	struct PCLK_CTL4_BITS{
		unsigned int _CANFD8CLKEN:1;
		unsigned int _CANFD9CLKEN:1;
		unsigned int _CANFD10CLKEN:1;
		unsigned int _CANFD11CLKEN:1;
		unsigned int _CANFD12CLKEN:1;
		unsigned int _CANFD13CLKEN:1;
		unsigned int _USART8CLKEN:1;
		unsigned int _USART9CLKEN:1;
		unsigned int _USART10CLKEN:1;
		unsigned int _USART11CLKEN:1;
		unsigned int _ECC4CLKEN:1;
		unsigned int _ECC5CLKEN:1;
		unsigned int _ECC6CLKEN:1;
		unsigned int _ECC7CLKEN:1;
		unsigned int _ECC8CLKEN:1;
		unsigned int _ECC9CLKEN:1;
		unsigned int _ECC10CLKEN:1;
		unsigned int _ECC11CLKEN:1;
		unsigned int _ECC12CLKEN:1;
		unsigned int _ECC13CLKEN:1;
		unsigned int _ECC0CLKEN:1;
		unsigned int _ECC1CLKEN:1;
		unsigned int _ECC2CLKEN:1;
		unsigned int _ECC3CLKEN:1;
		unsigned int _ECC19CLKEN:1;
		unsigned int _ECC20CLKEN:1;
		unsigned int _EPWM31CLKEN:1;
		unsigned int _EPWM32CLKEN:1;
		unsigned int _EPWM33CLKEN:1;
		unsigned int _EPWM36CLKEN:1;
		unsigned int _WRLOCKCLKEN:1;
		unsigned int _ECC14CLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL4 (*((volatile union PCLK_CTL4_REG *)0x40002650))
// modelBKP

/** 0x4000 1400 BKP_CTL **/
union BKP_CTL_REG{
	unsigned int reg;
	struct BKP_CTL_BITS{
		unsigned int :1;
		unsigned int _EXTHFBYP:1;
		unsigned int _EXTLFBYP:1;
		unsigned int _TAMPCLKS:1;
		unsigned int _SYNC:1;
		unsigned int :3;
		unsigned int _RTCCLK:2;
		unsigned int _RTCCLKTP:2;
		unsigned int :4;
		unsigned int _TAMP1EN:1;
		unsigned int _TAMP2EN:1;
		unsigned int _TAMP3EN:1;
		unsigned int :1;
		unsigned int _TAMP1LVL:1;
		unsigned int _TAMP2LVL:1;
		unsigned int _TAMP3LVL:1;
		unsigned int :8;
		unsigned int _BKPRST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_CTL (*((volatile union BKP_CTL_REG *)0x40001400))
// model

/** 0x4000 1404 BKP_INT **/
union BKP_INT_REG{
	unsigned int reg;
	struct BKP_INT_BITS{
		unsigned int _TAMP1IC:1;
		unsigned int _TAMP2IC:1;
		unsigned int _TAMP3IC:1;
		unsigned int :5;
		unsigned int _TAMP1IE:1;
		unsigned int _TAMP2IE:1;
		unsigned int _TAMP3IE:1;
		unsigned int :5;
		unsigned int _TAMP1IF:1;
		unsigned int _TAMP2IF:1;
		unsigned int _TAMP3IF:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_INT (*((volatile union BKP_INT_REG *)0x40001404))
// model

/** 0x4000 1440 BKP_DATA0 **/
union BKP_DATA0_REG{
	unsigned int reg;
	struct BKP_DATA0_BITS{
		unsigned int _BKPDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA0 (*((volatile union BKP_DATA0_REG *)0x40001440))
// model

/** 0x4000 1444 BKP_DATA1 **/
union BKP_DATA1_REG{
	unsigned int reg;
	struct BKP_DATA1_BITS{
		unsigned int _BKPDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA1 (*((volatile union BKP_DATA1_REG *)0x40001444))
// model

/** 0x4000 1448 BKP_DATA2 **/
union BKP_DATA2_REG{
	unsigned int reg;
	struct BKP_DATA2_BITS{
		unsigned int _BKPDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA2 (*((volatile union BKP_DATA2_REG *)0x40001448))
// model

/** 0x4000 144C BKP_DATA3 **/
union BKP_DATA3_REG{
	unsigned int reg;
	struct BKP_DATA3_BITS{
		unsigned int _BKPDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA3 (*((volatile union BKP_DATA3_REG *)0x4000144C))
// model

/** 0x4000 1450 BKP_DATA4 **/
union BKP_DATA4_REG{
	unsigned int reg;
	struct BKP_DATA4_BITS{
		unsigned int _BKPDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA4 (*((volatile union BKP_DATA4_REG *)0x40001450))
// model

/** 0x4000 1454 BKP_DATA5 **/
union BKP_DATA5_REG{
	unsigned int reg;
	struct BKP_DATA5_BITS{
		unsigned int _BKPDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA5 (*((volatile union BKP_DATA5_REG *)0x40001454))
// model

/** 0x4000 1458 BKP_DATA6 **/
union BKP_DATA6_REG{
	unsigned int reg;
	struct BKP_DATA6_BITS{
		unsigned int _BKPDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA6 (*((volatile union BKP_DATA6_REG *)0x40001458))
// model

/** 0x4000 145C BKP_DATA7 **/
union BKP_DATA7_REG{
	unsigned int reg;
	struct BKP_DATA7_BITS{
		unsigned int _BKPDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA7 (*((volatile union BKP_DATA7_REG *)0x4000145C))
// model

/** 0x4000 1460 BKP_DATA8 **/
union BKP_DATA8_REG{
	unsigned int reg;
	struct BKP_DATA8_BITS{
		unsigned int _BKPDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA8 (*((volatile union BKP_DATA8_REG *)0x40001460))
// model

/** 0x4000 1464 BKP_DATA9 **/
union BKP_DATA9_REG{
	unsigned int reg;
	struct BKP_DATA9_BITS{
		unsigned int _BKPDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA9 (*((volatile union BKP_DATA9_REG *)0x40001464))
// model

/** 0x4000 1468 BKP_DATA10 **/
union BKP_DATA10_REG{
	unsigned int reg;
	struct BKP_DATA10_BITS{
		unsigned int _BKPDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA10 (*((volatile union BKP_DATA10_REG *)0x40001468))
// model

/** 0x4000 146C BKP_DATA11 **/
union BKP_DATA11_REG{
	unsigned int reg;
	struct BKP_DATA11_BITS{
		unsigned int _BKPDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA11 (*((volatile union BKP_DATA11_REG *)0x4000146C))
// model

/** 0x4000 1470 BKP_DATA12 **/
union BKP_DATA12_REG{
	unsigned int reg;
	struct BKP_DATA12_BITS{
		unsigned int _BKPDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA12 (*((volatile union BKP_DATA12_REG *)0x40001470))
// model

/** 0x4000 1474 BKP_DATA13 **/
union BKP_DATA13_REG{
	unsigned int reg;
	struct BKP_DATA13_BITS{
		unsigned int _BKPDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA13 (*((volatile union BKP_DATA13_REG *)0x40001474))
// model

/** 0x4000 1478 BKP_DATA14 **/
union BKP_DATA14_REG{
	unsigned int reg;
	struct BKP_DATA14_BITS{
		unsigned int _BKPDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA14 (*((volatile union BKP_DATA14_REG *)0x40001478))
// model

/** 0x4000 147C BKP_DATA15 **/
union BKP_DATA15_REG{
	unsigned int reg;
	struct BKP_DATA15_BITS{
		unsigned int _BKPDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA15 (*((volatile union BKP_DATA15_REG *)0x4000147C))
// model

/** 0x4000 1480 BKP_DATA16 **/
union BKP_DATA16_REG{
	unsigned int reg;
	struct BKP_DATA16_BITS{
		unsigned int _BKPDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA16 (*((volatile union BKP_DATA16_REG *)0x40001480))
// model

/** 0x4000 1484 BKP_DATA17 **/
union BKP_DATA17_REG{
	unsigned int reg;
	struct BKP_DATA17_BITS{
		unsigned int _BKPDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA17 (*((volatile union BKP_DATA17_REG *)0x40001484))
// model

/** 0x4000 1488 BKP_DATA18 **/
union BKP_DATA18_REG{
	unsigned int reg;
	struct BKP_DATA18_BITS{
		unsigned int _BKPDATA18:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA18 (*((volatile union BKP_DATA18_REG *)0x40001488))
// model

/** 0x4000 148C BKP_DATA19 **/
union BKP_DATA19_REG{
	unsigned int reg;
	struct BKP_DATA19_BITS{
		unsigned int _BKPDATA19:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA19 (*((volatile union BKP_DATA19_REG *)0x4000148C))
// model

/** 0x4000 1490 BKP_DATA20 **/
union BKP_DATA20_REG{
	unsigned int reg;
	struct BKP_DATA20_BITS{
		unsigned int _BKPDATA20:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA20 (*((volatile union BKP_DATA20_REG *)0x40001490))
// model

/** 0x4000 1494 BKP_DATA21 **/
union BKP_DATA21_REG{
	unsigned int reg;
	struct BKP_DATA21_BITS{
		unsigned int _BKPDATA21:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA21 (*((volatile union BKP_DATA21_REG *)0x40001494))
// model

/** 0x4000 1498 BKP_DATA22 **/
union BKP_DATA22_REG{
	unsigned int reg;
	struct BKP_DATA22_BITS{
		unsigned int _BKPDATA22:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA22 (*((volatile union BKP_DATA22_REG *)0x40001498))
// model

/** 0x4000 149C BKP_DATA23 **/
union BKP_DATA23_REG{
	unsigned int reg;
	struct BKP_DATA23_BITS{
		unsigned int _BKPDATA23:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA23 (*((volatile union BKP_DATA23_REG *)0x4000149C))
// model

/** 0x4000 14A0 BKP_DATA24 **/
union BKP_DATA24_REG{
	unsigned int reg;
	struct BKP_DATA24_BITS{
		unsigned int _BKPDATA24:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA24 (*((volatile union BKP_DATA24_REG *)0x400014A0))
// model

/** 0x4000 14A4 BKP_DATA25 **/
union BKP_DATA25_REG{
	unsigned int reg;
	struct BKP_DATA25_BITS{
		unsigned int _BKPDATA25:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA25 (*((volatile union BKP_DATA25_REG *)0x400014A4))
// model

/** 0x4000 14A8 BKP_DATA26 **/
union BKP_DATA26_REG{
	unsigned int reg;
	struct BKP_DATA26_BITS{
		unsigned int _BKPDATA26:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA26 (*((volatile union BKP_DATA26_REG *)0x400014A8))
// model

/** 0x4000 14AC BKP_DATA27 **/
union BKP_DATA27_REG{
	unsigned int reg;
	struct BKP_DATA27_BITS{
		unsigned int _BKPDATA27:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA27 (*((volatile union BKP_DATA27_REG *)0x400014AC))
// model

/** 0x4000 14B0 BKP_DATA28 **/
union BKP_DATA28_REG{
	unsigned int reg;
	struct BKP_DATA28_BITS{
		unsigned int _BKPDATA28:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA28 (*((volatile union BKP_DATA28_REG *)0x400014B0))
// model

/** 0x4000 14B4 BKP_DATA29 **/
union BKP_DATA29_REG{
	unsigned int reg;
	struct BKP_DATA29_BITS{
		unsigned int _BKPDATA29:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA29 (*((volatile union BKP_DATA29_REG *)0x400014B4))
// model

/** 0x4000 14B8 BKP_DATA30 **/
union BKP_DATA30_REG{
	unsigned int reg;
	struct BKP_DATA30_BITS{
		unsigned int _BKPDATA30:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA30 (*((volatile union BKP_DATA30_REG *)0x400014B8))
// model

/** 0x4000 14BC BKP_DATA31 **/
union BKP_DATA31_REG{
	unsigned int reg;
	struct BKP_DATA31_BITS{
		unsigned int _BKPDATA31:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA31 (*((volatile union BKP_DATA31_REG *)0x400014BC))
// modelFLASH

/** 0x4020 0100 FLASH_ISPCON0 **/
union FLASH_ISPCON0_REG{
	unsigned int reg;
	struct FLASH_ISPCON0_BITS{
		unsigned int _NVMLOCK:1;
		unsigned int _FLASHLOCK:1;
		unsigned int _CFGLOCK:1;
		unsigned int :1;
		unsigned int _IFEN:1;
		unsigned int _STANDBY1:1;
		unsigned int :1;
		unsigned int _USERLOCK:1;
		unsigned int _DFLOCK:1;
		unsigned int _PFLOCK:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCON0 (*((volatile union FLASH_ISPCON0_REG *)0x40200100))
// model

/** 0x4020 0104 FLASH_ISPCON1 **/
union FLASH_ISPCON1_REG{
	unsigned int reg;
	struct FLASH_ISPCON1_BITS{
		unsigned int _IPSEL:1;
		unsigned int _RECALLEN:1;
		unsigned int _CONFEN:1;
		unsigned int :12;
		unsigned int _CHIPONEN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCON1 (*((volatile union FLASH_ISPCON1_REG *)0x40200104))
// model

/** 0x4020 0108 FLASH_ISPCMD **/
union FLASH_ISPCMD_REG{
	unsigned int reg;
	struct FLASH_ISPCMD_BITS{
		unsigned int _CMD:5;
		unsigned int _WSIZE:6;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPCMD (*((volatile union FLASH_ISPCMD_REG *)0x40200108))
// model

/** 0x4020 010C FLASH_ISPTRG **/
union FLASH_ISPTRG_REG{
	unsigned int reg;
	struct FLASH_ISPTRG_BITS{
		unsigned int _ISPGO:1;
		unsigned int :31;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPTRG (*((volatile union FLASH_ISPTRG_REG *)0x4020010C))
// model

/** 0x4020 0114 FLASH_CFG **/
union FLASH_CFG_REG{
	unsigned int reg;
	struct FLASH_CFG_BITS{
		unsigned int _TCFG:4;
		unsigned int :2;
		unsigned int _PREFETCHEN:1;
		unsigned int _ECCREADEN:1;
		unsigned int _FPREAEDEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFG (*((volatile union FLASH_CFG_REG *)0x40200114))
// model

/** 0x4020 0118 FLASH_USERUNLOCK **/
union FLASH_USERUNLOCK_REG{
	unsigned int reg;
	struct FLASH_USERUNLOCK_BITS{
		unsigned int _USERUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_USERUNLOCK (*((volatile union FLASH_USERUNLOCK_REG *)0x40200118))
// model

/** 0x4020 011C FLASH_ISPADDR **/
union FLASH_ISPADDR_REG{
	unsigned int reg;
	struct FLASH_ISPADDR_BITS{
		unsigned int :3;
		unsigned int _SADDR:18;
		unsigned int _FLCS:4;
		unsigned int _SADDR:7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_ISPADDR (*((volatile union FLASH_ISPADDR_REG *)0x4020011C))
// model

/** 0x4020 0120 FLASH_STATE **/
union FLASH_STATE_REG{
	unsigned int reg;
	struct FLASH_STATE_BITS{
		unsigned int _CFGERROR:1;
		unsigned int _SIGDONE:1;
		unsigned int _TBIT:1;
		unsigned int _TBUSY:1;
		unsigned int :8;
		unsigned int _DDBG:1;
		unsigned int _BDBGREM:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_STATE (*((volatile union FLASH_STATE_REG *)0x40200120))
// model

/** 0x4020 0128 FLASH_NVMUNLOCK **/
union FLASH_NVMUNLOCK_REG{
	unsigned int reg;
	struct FLASH_NVMUNLOCK_BITS{
		unsigned int _NUMUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_NVMUNLOCK (*((volatile union FLASH_NVMUNLOCK_REG *)0x40200128))
// model

/** 0x4020 012C FLASH_PROUNLOCK **/
union FLASH_PROUNLOCK_REG{
	unsigned int reg;
	struct FLASH_PROUNLOCK_BITS{
		unsigned int _PROUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_PROUNLOCK (*((volatile union FLASH_PROUNLOCK_REG *)0x4020012C))
// model

/** 0x4020 0130 FLASH_CFGUNLOCK **/
union FLASH_CFGUNLOCK_REG{
	unsigned int reg;
	struct FLASH_CFGUNLOCK_BITS{
		unsigned int _CFGUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFGUNLOCK (*((volatile union FLASH_CFGUNLOCK_REG *)0x40200130))
// model

/** 0x4020 0131  FLASH_CHIPONLOCK **/
union  FLASH_CHIPONLOCK_REG{
	unsigned int reg;
	struct  FLASH_CHIPONLOCK_BITS{
		unsigned int _CFGUNLOCK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  FLASH_CHIPONLOCK (*((volatile union  FLASH_CHIPONLOCK_REG *)0x40200131))
// model

/** 0x4020 0138 FLASH_CSSTART **/
union FLASH_CSSTART_REG{
	unsigned int reg;
	struct FLASH_CSSTART_BITS{
		unsigned int :4;
		unsigned int _CKSTADDR:17;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTART (*((volatile union FLASH_CSSTART_REG *)0x40200138))
// model

/** 0x4020 013C FLASH_CSSTOP **/
union FLASH_CSSTOP_REG{
	unsigned int reg;
	struct FLASH_CSSTOP_BITS{
		unsigned int :4;
		unsigned int _CKSPADDR:17;
		unsigned int :10;
		unsigned int _SIGGO:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTOP (*((volatile union FLASH_CSSTOP_REG *)0x4020013C))
// model

/** 0x4020 0140 FLASH_CSRES0 **/
union FLASH_CSRES0_REG{
	unsigned int reg;
	struct FLASH_CSRES0_BITS{
		unsigned int _CKSPRES0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES0 (*((volatile union FLASH_CSRES0_REG *)0x40200140))
// model

/** 0x4020 0144 FLASH_CSRES1 **/
union FLASH_CSRES1_REG{
	unsigned int reg;
	struct FLASH_CSRES1_BITS{
		unsigned int _CKSPRES1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES1 (*((volatile union FLASH_CSRES1_REG *)0x40200144))
// model

/** 0x4020 0148 FLASH_CSRES2 **/
union FLASH_CSRES2_REG{
	unsigned int reg;
	struct FLASH_CSRES2_BITS{
		unsigned int _CKSPRES2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES2 (*((volatile union FLASH_CSRES2_REG *)0x40200148))
// model

/** 0x4020 014C FLASH_CSRES3 **/
union FLASH_CSRES3_REG{
	unsigned int reg;
	struct FLASH_CSRES3_BITS{
		unsigned int _CKSPRES3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES3 (*((volatile union FLASH_CSRES3_REG *)0x4020014C))
// modelECC0

/** 0x4000 4F00 ECC0_CTL **/
union ECC0_CTL_REG{
	unsigned int reg;
	struct ECC0_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_CTL (*((volatile union ECC0_CTL_REG *)0x40004F00))
// model

/** 0x4000 4F04 ECC0_INT **/
union ECC0_INT_REG{
	unsigned int reg;
	struct ECC0_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_INT (*((volatile union ECC0_INT_REG *)0x40004F04))
// model

/** 0x4000 4F08 ECC0_ERRADDR **/
union ECC0_ERRADDR_REG{
	unsigned int reg;
	struct ECC0_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_ERRADDR (*((volatile union ECC0_ERRADDR_REG *)0x40004F08))
// model

/** 0x4000 4F10 ECC0_EBR0 **/
union ECC0_EBR0_REG{
	unsigned int reg;
	struct ECC0_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_EBR0 (*((volatile union ECC0_EBR0_REG *)0x40004F10))
// model

/** 0x4000 4F14 ECC0_EBR1 **/
union ECC0_EBR1_REG{
	unsigned int reg;
	struct ECC0_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_EBR1 (*((volatile union ECC0_EBR1_REG *)0x40004F14))
// model

/** 0x4000 4F18 ECC0_EBR2 **/
union ECC0_EBR2_REG{
	unsigned int reg;
	struct ECC0_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC0_EBR2 (*((volatile union ECC0_EBR2_REG *)0x40004F18))
// modelECC1

/** 0x4000 4F80 ECC1_CTL **/
union ECC1_CTL_REG{
	unsigned int reg;
	struct ECC1_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_CTL (*((volatile union ECC1_CTL_REG *)0x40004F80))
// model

/** 0x4000 4F84 ECC1_INT **/
union ECC1_INT_REG{
	unsigned int reg;
	struct ECC1_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_INT (*((volatile union ECC1_INT_REG *)0x40004F84))
// model

/** 0x4000 4F88 ECC1_ERRADDR **/
union ECC1_ERRADDR_REG{
	unsigned int reg;
	struct ECC1_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_ERRADDR (*((volatile union ECC1_ERRADDR_REG *)0x40004F88))
// model

/** 0x4000 4F90 ECC1_EBR0 **/
union ECC1_EBR0_REG{
	unsigned int reg;
	struct ECC1_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_EBR0 (*((volatile union ECC1_EBR0_REG *)0x40004F90))
// model

/** 0x4000 4F94 ECC1_EBR1 **/
union ECC1_EBR1_REG{
	unsigned int reg;
	struct ECC1_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_EBR1 (*((volatile union ECC1_EBR1_REG *)0x40004F94))
// model

/** 0x4000 4F98 ECC1_EBR2 **/
union ECC1_EBR2_REG{
	unsigned int reg;
	struct ECC1_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC1_EBR2 (*((volatile union ECC1_EBR2_REG *)0x40004F98))
// modelECC2

/** 0x4000 5000 ECC2_CTL **/
union ECC2_CTL_REG{
	unsigned int reg;
	struct ECC2_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC2_CTL (*((volatile union ECC2_CTL_REG *)0x40005000))
// model

/** 0x4000 5004 ECC2_INT **/
union ECC2_INT_REG{
	unsigned int reg;
	struct ECC2_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC2_INT (*((volatile union ECC2_INT_REG *)0x40005004))
// model

/** 0x4000 5008 ECC2_ERRADDR **/
union ECC2_ERRADDR_REG{
	unsigned int reg;
	struct ECC2_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC2_ERRADDR (*((volatile union ECC2_ERRADDR_REG *)0x40005008))
// model

/** 0x4000 5010 ECC2_EBR0 **/
union ECC2_EBR0_REG{
	unsigned int reg;
	struct ECC2_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC2_EBR0 (*((volatile union ECC2_EBR0_REG *)0x40005010))
// model

/** 0x4000 5014 ECC2_EBR1 **/
union ECC2_EBR1_REG{
	unsigned int reg;
	struct ECC2_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC2_EBR1 (*((volatile union ECC2_EBR1_REG *)0x40005014))
// model

/** 0x4000 5018 ECC2_EBR2 **/
union ECC2_EBR2_REG{
	unsigned int reg;
	struct ECC2_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC2_EBR2 (*((volatile union ECC2_EBR2_REG *)0x40005018))
// modelECC3

/** 0x4000 5080 ECC3_CTL **/
union ECC3_CTL_REG{
	unsigned int reg;
	struct ECC3_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC3_CTL (*((volatile union ECC3_CTL_REG *)0x40005080))
// model

/** 0x4000 5084 ECC3_INT **/
union ECC3_INT_REG{
	unsigned int reg;
	struct ECC3_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC3_INT (*((volatile union ECC3_INT_REG *)0x40005084))
// model

/** 0x4000 5088 ECC3_ERRADDR **/
union ECC3_ERRADDR_REG{
	unsigned int reg;
	struct ECC3_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC3_ERRADDR (*((volatile union ECC3_ERRADDR_REG *)0x40005088))
// model

/** 0x4000 5090 ECC3_EBR0 **/
union ECC3_EBR0_REG{
	unsigned int reg;
	struct ECC3_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC3_EBR0 (*((volatile union ECC3_EBR0_REG *)0x40005090))
// model

/** 0x4000 5094 ECC3_EBR1 **/
union ECC3_EBR1_REG{
	unsigned int reg;
	struct ECC3_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC3_EBR1 (*((volatile union ECC3_EBR1_REG *)0x40005094))
// model

/** 0x4000 5098 ECC3_EBR2 **/
union ECC3_EBR2_REG{
	unsigned int reg;
	struct ECC3_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC3_EBR2 (*((volatile union ECC3_EBR2_REG *)0x40005098))
// modelECC4

/** 0x4000 4A00 ECC4_CTL **/
union ECC4_CTL_REG{
	unsigned int reg;
	struct ECC4_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC4_CTL (*((volatile union ECC4_CTL_REG *)0x40004A00))
// model

/** 0x4000 4A04 ECC4_INT **/
union ECC4_INT_REG{
	unsigned int reg;
	struct ECC4_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC4_INT (*((volatile union ECC4_INT_REG *)0x40004A04))
// model

/** 0x4000 4A08 ECC4_ERRADDR **/
union ECC4_ERRADDR_REG{
	unsigned int reg;
	struct ECC4_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC4_ERRADDR (*((volatile union ECC4_ERRADDR_REG *)0x40004A08))
// model

/** 0x4000 4A10 ECC4_EBR0 **/
union ECC4_EBR0_REG{
	unsigned int reg;
	struct ECC4_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC4_EBR0 (*((volatile union ECC4_EBR0_REG *)0x40004A10))
// model

/** 0x4000 4A18 ECC4_EBR2 **/
union ECC4_EBR2_REG{
	unsigned int reg;
	struct ECC4_EBR2_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC4_EBR2 (*((volatile union ECC4_EBR2_REG *)0x40004A18))
// modelECC5

/** 0x4000 4A80 ECC5_CTL **/
union ECC5_CTL_REG{
	unsigned int reg;
	struct ECC5_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC5_CTL (*((volatile union ECC5_CTL_REG *)0x40004A80))
// model

/** 0x4000 4A84 ECC5_INT **/
union ECC5_INT_REG{
	unsigned int reg;
	struct ECC5_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC5_INT (*((volatile union ECC5_INT_REG *)0x40004A84))
// model

/** 0x4000 4A88 ECC5_ERRADDR **/
union ECC5_ERRADDR_REG{
	unsigned int reg;
	struct ECC5_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC5_ERRADDR (*((volatile union ECC5_ERRADDR_REG *)0x40004A88))
// model

/** 0x4000 4A90 ECC5_EBR0 **/
union ECC5_EBR0_REG{
	unsigned int reg;
	struct ECC5_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC5_EBR0 (*((volatile union ECC5_EBR0_REG *)0x40004A90))
// model

/** 0x4000 4A98 ECC5_EBR2 **/
union ECC5_EBR2_REG{
	unsigned int reg;
	struct ECC5_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC5_EBR2 (*((volatile union ECC5_EBR2_REG *)0x40004A98))
// modelECC6

/** 0x4000 4B00 ECC6_CTL **/
union ECC6_CTL_REG{
	unsigned int reg;
	struct ECC6_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC6_CTL (*((volatile union ECC6_CTL_REG *)0x40004B00))
// model

/** 0x4000 4B04 ECC6_INT **/
union ECC6_INT_REG{
	unsigned int reg;
	struct ECC6_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC6_INT (*((volatile union ECC6_INT_REG *)0x40004B04))
// model

/** 0x4000 4B08 ECC6_ERRADDR **/
union ECC6_ERRADDR_REG{
	unsigned int reg;
	struct ECC6_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC6_ERRADDR (*((volatile union ECC6_ERRADDR_REG *)0x40004B08))
// model

/** 0x4000 4B10 ECC6_EBR0 **/
union ECC6_EBR0_REG{
	unsigned int reg;
	struct ECC6_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC6_EBR0 (*((volatile union ECC6_EBR0_REG *)0x40004B10))
// model

/** 0x4000 4B18 ECC6_EBR2 **/
union ECC6_EBR2_REG{
	unsigned int reg;
	struct ECC6_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC6_EBR2 (*((volatile union ECC6_EBR2_REG *)0x40004B18))
// modelECC7

/** 0x4000 4B80 ECC7_CTL **/
union ECC7_CTL_REG{
	unsigned int reg;
	struct ECC7_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC7_CTL (*((volatile union ECC7_CTL_REG *)0x40004B80))
// model

/** 0x4000 4B84 ECC7_INT **/
union ECC7_INT_REG{
	unsigned int reg;
	struct ECC7_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC7_INT (*((volatile union ECC7_INT_REG *)0x40004B84))
// model

/** 0x4000 4B88 ECC7_ERRADDR **/
union ECC7_ERRADDR_REG{
	unsigned int reg;
	struct ECC7_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC7_ERRADDR (*((volatile union ECC7_ERRADDR_REG *)0x40004B88))
// model

/** 0x4000 4B90 ECC7_EBR0 **/
union ECC7_EBR0_REG{
	unsigned int reg;
	struct ECC7_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC7_EBR0 (*((volatile union ECC7_EBR0_REG *)0x40004B90))
// model

/** 0x4000 4B98 ECC7_EBR2 **/
union ECC7_EBR2_REG{
	unsigned int reg;
	struct ECC7_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC7_EBR2 (*((volatile union ECC7_EBR2_REG *)0x40004B98))
// modelECC8

/** 0x4000 4C00 ECC8_CTL **/
union ECC8_CTL_REG{
	unsigned int reg;
	struct ECC8_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC8_CTL (*((volatile union ECC8_CTL_REG *)0x40004C00))
// model

/** 0x4000 4C04 ECC8_INT **/
union ECC8_INT_REG{
	unsigned int reg;
	struct ECC8_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC8_INT (*((volatile union ECC8_INT_REG *)0x40004C04))
// model

/** 0x4000 4C08 ECC8_ERRADDR **/
union ECC8_ERRADDR_REG{
	unsigned int reg;
	struct ECC8_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC8_ERRADDR (*((volatile union ECC8_ERRADDR_REG *)0x40004C08))
// model

/** 0x4000 4C10 ECC8_EBR0 **/
union ECC8_EBR0_REG{
	unsigned int reg;
	struct ECC8_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC8_EBR0 (*((volatile union ECC8_EBR0_REG *)0x40004C10))
// model

/** 0x4000 4C18 ECC8_EBR2 **/
union ECC8_EBR2_REG{
	unsigned int reg;
	struct ECC8_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC8_EBR2 (*((volatile union ECC8_EBR2_REG *)0x40004C18))
// modelECC9

/** 0x4000 4C80 ECC9_CTL **/
union ECC9_CTL_REG{
	unsigned int reg;
	struct ECC9_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC9_CTL (*((volatile union ECC9_CTL_REG *)0x40004C80))
// model

/** 0x4000 4C84 ECC9_INT **/
union ECC9_INT_REG{
	unsigned int reg;
	struct ECC9_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC9_INT (*((volatile union ECC9_INT_REG *)0x40004C84))
// model

/** 0x4000 4C88 ECC9_ERRADDR **/
union ECC9_ERRADDR_REG{
	unsigned int reg;
	struct ECC9_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC9_ERRADDR (*((volatile union ECC9_ERRADDR_REG *)0x40004C88))
// model

/** 0x4000 4C90 ECC9_EBR0 **/
union ECC9_EBR0_REG{
	unsigned int reg;
	struct ECC9_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC9_EBR0 (*((volatile union ECC9_EBR0_REG *)0x40004C90))
// model

/** 0x4000 4C98 ECC9_EBR2 **/
union ECC9_EBR2_REG{
	unsigned int reg;
	struct ECC9_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC9_EBR2 (*((volatile union ECC9_EBR2_REG *)0x40004C98))
// modelECC10

/** 0x4000 4D00 ECC10_CTL **/
union ECC10_CTL_REG{
	unsigned int reg;
	struct ECC10_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC10_CTL (*((volatile union ECC10_CTL_REG *)0x40004D00))
// model

/** 0x4000 4D04 ECC10_INT **/
union ECC10_INT_REG{
	unsigned int reg;
	struct ECC10_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC10_INT (*((volatile union ECC10_INT_REG *)0x40004D04))
// model

/** 0x4000 4D08 ECC10_ERRADDR **/
union ECC10_ERRADDR_REG{
	unsigned int reg;
	struct ECC10_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC10_ERRADDR (*((volatile union ECC10_ERRADDR_REG *)0x40004D08))
// model

/** 0x4000 4D10 ECC10_EBR0 **/
union ECC10_EBR0_REG{
	unsigned int reg;
	struct ECC10_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC10_EBR0 (*((volatile union ECC10_EBR0_REG *)0x40004D10))
// model

/** 0x4000 4D18 ECC10_EBR2 **/
union ECC10_EBR2_REG{
	unsigned int reg;
	struct ECC10_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC10_EBR2 (*((volatile union ECC10_EBR2_REG *)0x40004D18))
// modelECC11

/** 0x4000 4D80 ECC11_CTL **/
union ECC11_CTL_REG{
	unsigned int reg;
	struct ECC11_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC11_CTL (*((volatile union ECC11_CTL_REG *)0x40004D80))
// model

/** 0x4000 4D84 ECC11_INT **/
union ECC11_INT_REG{
	unsigned int reg;
	struct ECC11_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC11_INT (*((volatile union ECC11_INT_REG *)0x40004D84))
// model

/** 0x4000 4D88 ECC11_ERRADDR **/
union ECC11_ERRADDR_REG{
	unsigned int reg;
	struct ECC11_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC11_ERRADDR (*((volatile union ECC11_ERRADDR_REG *)0x40004D88))
// model

/** 0x4000 4D90 ECC11_EBR0 **/
union ECC11_EBR0_REG{
	unsigned int reg;
	struct ECC11_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC11_EBR0 (*((volatile union ECC11_EBR0_REG *)0x40004D90))
// model

/** 0x4000 4D98 ECC11_EBR2 **/
union ECC11_EBR2_REG{
	unsigned int reg;
	struct ECC11_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC11_EBR2 (*((volatile union ECC11_EBR2_REG *)0x40004D98))
// modelECC12

/** 0x4000 4E00 ECC12_CTL **/
union ECC12_CTL_REG{
	unsigned int reg;
	struct ECC12_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC12_CTL (*((volatile union ECC12_CTL_REG *)0x40004E00))
// model

/** 0x4000 4E04 ECC12_INT **/
union ECC12_INT_REG{
	unsigned int reg;
	struct ECC12_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC12_INT (*((volatile union ECC12_INT_REG *)0x40004E04))
// model

/** 0x4000 4E08 ECC12_ERRADDR **/
union ECC12_ERRADDR_REG{
	unsigned int reg;
	struct ECC12_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC12_ERRADDR (*((volatile union ECC12_ERRADDR_REG *)0x40004E08))
// model

/** 0x4000 4E10 ECC12_EBR0 **/
union ECC12_EBR0_REG{
	unsigned int reg;
	struct ECC12_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC12_EBR0 (*((volatile union ECC12_EBR0_REG *)0x40004E10))
// model

/** 0x4000 4E18 ECC12_EBR2 **/
union ECC12_EBR2_REG{
	unsigned int reg;
	struct ECC12_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC12_EBR2 (*((volatile union ECC12_EBR2_REG *)0x40004E18))
// modelECC13

/** 0x4000 4E80 ECC13_CTL **/
union ECC13_CTL_REG{
	unsigned int reg;
	struct ECC13_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC13_CTL (*((volatile union ECC13_CTL_REG *)0x40004E80))
// model

/** 0x4000 4E84 ECC13_INT **/
union ECC13_INT_REG{
	unsigned int reg;
	struct ECC13_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC13_INT (*((volatile union ECC13_INT_REG *)0x40004E84))
// model

/** 0x4000 4E88 ECC13_ERRADDR **/
union ECC13_ERRADDR_REG{
	unsigned int reg;
	struct ECC13_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC13_ERRADDR (*((volatile union ECC13_ERRADDR_REG *)0x40004E88))
// model

/** 0x4000 4E90 ECC13_EBR0 **/
union ECC13_EBR0_REG{
	unsigned int reg;
	struct ECC13_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC13_EBR0 (*((volatile union ECC13_EBR0_REG *)0x40004E90))
// model

/** 0x4000 4E98 ECC13_EBR2 **/
union ECC13_EBR2_REG{
	unsigned int reg;
	struct ECC13_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC13_EBR2 (*((volatile union ECC13_EBR2_REG *)0x40004E98))
// modelECC14

/** 0x4000 5780 ECC14_CTL **/
union ECC14_CTL_REG{
	unsigned int reg;
	struct ECC14_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC14_CTL (*((volatile union ECC14_CTL_REG *)0x40005780))
// model

/** 0x4000 5784 ECC14_INT **/
union ECC14_INT_REG{
	unsigned int reg;
	struct ECC14_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC14_INT (*((volatile union ECC14_INT_REG *)0x40005784))
// model

/** 0x4000 5788 ECC14_ERRADDR **/
union ECC14_ERRADDR_REG{
	unsigned int reg;
	struct ECC14_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC14_ERRADDR (*((volatile union ECC14_ERRADDR_REG *)0x40005788))
// model

/** 0x4000 5790 ECC14_EBR0 **/
union ECC14_EBR0_REG{
	unsigned int reg;
	struct ECC14_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC14_EBR0 (*((volatile union ECC14_EBR0_REG *)0x40005790))
// model

/** 0x4000 5798 ECC14_EBR2 **/
union ECC14_EBR2_REG{
	unsigned int reg;
	struct ECC14_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC14_EBR2 (*((volatile union ECC14_EBR2_REG *)0x40005798))
// modelECC15

/** 0x4000 4680 ECC15_CTL **/
union ECC15_CTL_REG{
	unsigned int reg;
	struct ECC15_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC15_CTL (*((volatile union ECC15_CTL_REG *)0x40004680))
// model

/** 0x4000 4684 ECC15_INT **/
union ECC15_INT_REG{
	unsigned int reg;
	struct ECC15_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC15_INT (*((volatile union ECC15_INT_REG *)0x40004684))
// model

/** 0x4000 4688 ECC15_ERRADDR **/
union ECC15_ERRADDR_REG{
	unsigned int reg;
	struct ECC15_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC15_ERRADDR (*((volatile union ECC15_ERRADDR_REG *)0x40004688))
// model

/** 0x4000 4690 ECC15_EBR0 **/
union ECC15_EBR0_REG{
	unsigned int reg;
	struct ECC15_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC15_EBR0 (*((volatile union ECC15_EBR0_REG *)0x40004690))
// model

/** 0x4000 4698 ECC15_EBR2 **/
union ECC15_EBR2_REG{
	unsigned int reg;
	struct ECC15_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC15_EBR2 (*((volatile union ECC15_EBR2_REG *)0x40004698))
// modelECC16

/** 0x4000 5E80 ECC16_CTL **/
union ECC16_CTL_REG{
	unsigned int reg;
	struct ECC16_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC16_CTL (*((volatile union ECC16_CTL_REG *)0x40005E80))
// model

/** 0x4000 5E84 ECC16_INT **/
union ECC16_INT_REG{
	unsigned int reg;
	struct ECC16_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC16_INT (*((volatile union ECC16_INT_REG *)0x40005E84))
// model

/** 0x4000 5E88 ECC16_ERRADDR **/
union ECC16_ERRADDR_REG{
	unsigned int reg;
	struct ECC16_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC16_ERRADDR (*((volatile union ECC16_ERRADDR_REG *)0x40005E88))
// model

/** 0x4000 5E90 ECC16_EBR0 **/
union ECC16_EBR0_REG{
	unsigned int reg;
	struct ECC16_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC16_EBR0 (*((volatile union ECC16_EBR0_REG *)0x40005E90))
// model

/** 0x4000 5E98 ECC16_EBR2 **/
union ECC16_EBR2_REG{
	unsigned int reg;
	struct ECC16_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC16_EBR2 (*((volatile union ECC16_EBR2_REG *)0x40005E98))
// modelECC17

/** 0x4000 5E00 ECC17_CTL **/
union ECC17_CTL_REG{
	unsigned int reg;
	struct ECC17_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC17_CTL (*((volatile union ECC17_CTL_REG *)0x40005E00))
// model

/** 0x4000 5E04 ECC17_INT **/
union ECC17_INT_REG{
	unsigned int reg;
	struct ECC17_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC17_INT (*((volatile union ECC17_INT_REG *)0x40005E04))
// model

/** 0x4000 5E08 ECC17_ERRADDR **/
union ECC17_ERRADDR_REG{
	unsigned int reg;
	struct ECC17_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC17_ERRADDR (*((volatile union ECC17_ERRADDR_REG *)0x40005E08))
// model

/** 0x4000 5E10 ECC17_EBR0 **/
union ECC17_EBR0_REG{
	unsigned int reg;
	struct ECC17_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC17_EBR0 (*((volatile union ECC17_EBR0_REG *)0x40005E10))
// model

/** 0x4000 5E18 ECC17_EBR2 **/
union ECC17_EBR2_REG{
	unsigned int reg;
	struct ECC17_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC17_EBR2 (*((volatile union ECC17_EBR2_REG *)0x40005E18))
// modelECC18

/** 0x4000 5600 ECC18_CTL **/
union ECC18_CTL_REG{
	unsigned int reg;
	struct ECC18_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC18_CTL (*((volatile union ECC18_CTL_REG *)0x40005600))
// model

/** 0x4000 5604 ECC18_INT **/
union ECC18_INT_REG{
	unsigned int reg;
	struct ECC18_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC18_INT (*((volatile union ECC18_INT_REG *)0x40005604))
// model

/** 0x4000 5608 ECC18_ERRADDR **/
union ECC18_ERRADDR_REG{
	unsigned int reg;
	struct ECC18_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC18_ERRADDR (*((volatile union ECC18_ERRADDR_REG *)0x40005608))
// model

/** 0x4000 5610 ECC18_EBR0 **/
union ECC18_EBR0_REG{
	unsigned int reg;
	struct ECC18_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC18_EBR0 (*((volatile union ECC18_EBR0_REG *)0x40005610))
// model

/** 0x4000 5618 ECC18_EBR2 **/
union ECC18_EBR2_REG{
	unsigned int reg;
	struct ECC18_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC18_EBR2 (*((volatile union ECC18_EBR2_REG *)0x40005618))
// modelECC19

/** 0x4000 5100 ECC19_CTL **/
union ECC19_CTL_REG{
	unsigned int reg;
	struct ECC19_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC19_CTL (*((volatile union ECC19_CTL_REG *)0x40005100))
// model

/** 0x4000 5104 ECC19_INT **/
union ECC19_INT_REG{
	unsigned int reg;
	struct ECC19_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC19_INT (*((volatile union ECC19_INT_REG *)0x40005104))
// model

/** 0x4000 5108 ECC19_ERRADDR **/
union ECC19_ERRADDR_REG{
	unsigned int reg;
	struct ECC19_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC19_ERRADDR (*((volatile union ECC19_ERRADDR_REG *)0x40005108))
// model

/** 0x4000 5110 ECC19_EBR0 **/
union ECC19_EBR0_REG{
	unsigned int reg;
	struct ECC19_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC19_EBR0 (*((volatile union ECC19_EBR0_REG *)0x40005110))
// model

/** 0x4000 5114 ECC19_EBR1 **/
union ECC19_EBR1_REG{
	unsigned int reg;
	struct ECC19_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC19_EBR1 (*((volatile union ECC19_EBR1_REG *)0x40005114))
// model

/** 0x4000 5118 ECC19_EBR2 **/
union ECC19_EBR2_REG{
	unsigned int reg;
	struct ECC19_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC19_EBR2 (*((volatile union ECC19_EBR2_REG *)0x40005118))
// modelECC20

/** 0x4000 5180 ECC20_CTL **/
union ECC20_CTL_REG{
	unsigned int reg;
	struct ECC20_CTL_BITS{
		unsigned int _ECCTESTEN:1;
		unsigned int :7;
		unsigned int _MEMERRIE:1;
		unsigned int _MEM1BITERRIE:1;
		unsigned int _MEM2BITERRIE:1;
		unsigned int :1;
		unsigned int _MEMERRIC:1;
		unsigned int _MEM1BITERRIC:1;
		unsigned int _MEM2IBTERRIC:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC20_CTL (*((volatile union ECC20_CTL_REG *)0x40005180))
// model

/** 0x4000 5184 ECC20_INT **/
union ECC20_INT_REG{
	unsigned int reg;
	struct ECC20_INT_BITS{
		unsigned int _MEMERRIF:1;
		unsigned int _MEM1BITERRIF:1;
		unsigned int _MEM2BITERRIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC20_INT (*((volatile union ECC20_INT_REG *)0x40005184))
// model

/** 0x4000 5188 ECC20_ERRADDR **/
union ECC20_ERRADDR_REG{
	unsigned int reg;
	struct ECC20_ERRADDR_BITS{
		unsigned int _ERRADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC20_ERRADDR (*((volatile union ECC20_ERRADDR_REG *)0x40005188))
// model

/** 0x4000 5190 ECC20_EBR0 **/
union ECC20_EBR0_REG{
	unsigned int reg;
	struct ECC20_EBR0_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC20_EBR0 (*((volatile union ECC20_EBR0_REG *)0x40005190))
// model

/** 0x4000 5194 ECC20_EBR1 **/
union ECC20_EBR1_REG{
	unsigned int reg;
	struct ECC20_EBR1_BITS{
		unsigned int _ERRBITEN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC20_EBR1 (*((volatile union ECC20_EBR1_REG *)0x40005194))
// model

/** 0x4000 5198 ECC20_EBR2 **/
union ECC20_EBR2_REG{
	unsigned int reg;
	struct ECC20_EBR2_BITS{
		unsigned int _ERRBITEN:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECC20_EBR2 (*((volatile union ECC20_EBR2_REG *)0x40005198))
// modelCRC

/** 0x4000 2680 CRC_CTL **/
union CRC_CTL_REG{
	unsigned int reg;
	struct CRC_CTL_BITS{
		unsigned int _RSET:1;
		unsigned int :1;
		unsigned int _DATASIZE:2;
		unsigned int _DATAREV:2;
		unsigned int _DATAOUTSWAP:2;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_CTL (*((volatile union CRC_CTL_REG *)0x40002680))
// model

/** 0x4000 2684 CRC_DATA **/
union CRC_DATA_REG{
	unsigned int reg;
	struct CRC_DATA_BITS{
		unsigned int _CRCDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_DATA (*((volatile union CRC_DATA_REG *)0x40002684))
// model

/** 0x4000 2688 CRC_RSLT **/
union CRC_RSLT_REG{
	unsigned int reg;
	struct CRC_RSLT_BITS{
		unsigned int _CRCRSLT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RSLT (*((volatile union CRC_RSLT_REG *)0x40002688))
// model

/** 0x4000 268C CRC_INIT **/
union CRC_INIT_REG{
	unsigned int reg;
	struct CRC_INIT_BITS{
		unsigned int _CRCINIT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_INIT (*((volatile union CRC_INIT_REG *)0x4000268C))
// model

/** 0x4000 2690 CRC_PLN **/
union CRC_PLN_REG{
	unsigned int reg;
	struct CRC_PLN_BITS{
		unsigned int _CRCPLN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_PLN (*((volatile union CRC_PLN_REG *)0x40002690))
// model

/** 0x4000 2694 CRC_RXOR **/
union CRC_RXOR_REG{
	unsigned int reg;
	struct CRC_RXOR_BITS{
		unsigned int _CRCRXOR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RXOR (*((volatile union CRC_RXOR_REG *)0x40002694))
// model

/** 0x4000 2698 CRC_IDATA **/
union CRC_IDATA_REG{
	unsigned int reg;
	struct CRC_IDATA_BITS{
		unsigned int _CRCIDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_IDATA (*((volatile union CRC_IDATA_REG *)0x40002698))
// model

/** 0x4000 269C CRC_TEMP **/
union CRC_TEMP_REG{
	unsigned int reg;
	struct CRC_TEMP_BITS{
		unsigned int _CRCTEMP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_TEMP (*((volatile union CRC_TEMP_REG *)0x4000269C))
// modelAES

/** 0x4000 2700 AES_CTL **/
union AES_CTL_REG{
	unsigned int reg;
	struct AES_CTL_BITS{
		unsigned int _AESEN:1;
		unsigned int _UNSTDAES:1;
		unsigned int _ENCRYPT:1;
		unsigned int _SBOXINV:1;
		unsigned int _KEYLEN:3;
		unsigned int :1;
		unsigned int _RNDNUM:5;
		unsigned int _DIV:3;
		unsigned int _CKS:2;
		unsigned int _DATASWAP:2;
		unsigned int _AESMOD:3;
		unsigned int _GCMPH:2;
		unsigned int :5;
		unsigned int _KEYRUN:1;
		unsigned int _AESRUN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_CTL (*((volatile union AES_CTL_REG *)0x40002700))
// model

/** 0x4000 2704 AES_INT **/
union AES_INT_REG{
	unsigned int reg;
	struct AES_INT_BITS{
		unsigned int _AESIE:1;
		unsigned int _KEYIE:1;
		unsigned int :2;
		unsigned int _AESIC:1;
		unsigned int _KEYIC:1;
		unsigned int :2;
		unsigned int _AESIF:1;
		unsigned int _KEYIF:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INT (*((volatile union AES_INT_REG *)0x40002704))
// model

/** 0x4000 2710 AES_INPUT0 **/
union AES_INPUT0_REG{
	unsigned int reg;
	struct AES_INPUT0_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT0 (*((volatile union AES_INPUT0_REG *)0x40002710))
// model

/** 0x4000 2714 AES_INPUT1 **/
union AES_INPUT1_REG{
	unsigned int reg;
	struct AES_INPUT1_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT1 (*((volatile union AES_INPUT1_REG *)0x40002714))
// model

/** 0x4000 2718 AES_INPUT2 **/
union AES_INPUT2_REG{
	unsigned int reg;
	struct AES_INPUT2_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT2 (*((volatile union AES_INPUT2_REG *)0x40002718))
// model

/** 0x4000 271C AES_INPUT3 **/
union AES_INPUT3_REG{
	unsigned int reg;
	struct AES_INPUT3_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT3 (*((volatile union AES_INPUT3_REG *)0x4000271C))
// model

/** 0x4000 2720 AES_OUTPUT0 **/
union AES_OUTPUT0_REG{
	unsigned int reg;
	struct AES_OUTPUT0_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT0 (*((volatile union AES_OUTPUT0_REG *)0x40002720))
// model

/** 0x4000 2724 AES_OUTPUT1 **/
union AES_OUTPUT1_REG{
	unsigned int reg;
	struct AES_OUTPUT1_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT1 (*((volatile union AES_OUTPUT1_REG *)0x40002724))
// model

/** 0x4000 2728 AES_OUTPUT2 **/
union AES_OUTPUT2_REG{
	unsigned int reg;
	struct AES_OUTPUT2_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT2 (*((volatile union AES_OUTPUT2_REG *)0x40002728))
// model

/** 0x4000 272C AES_OUTPUT3 **/
union AES_OUTPUT3_REG{
	unsigned int reg;
	struct AES_OUTPUT3_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT3 (*((volatile union AES_OUTPUT3_REG *)0x4000272C))
// model

/** 0x4000 2730 AES_KEYR0 **/
union AES_KEYR0_REG{
	unsigned int reg;
	struct AES_KEYR0_BITS{
		unsigned int _AESKEY0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR0 (*((volatile union AES_KEYR0_REG *)0x40002730))
// model

/** 0x4000 2734 AES_KEYR1 **/
union AES_KEYR1_REG{
	unsigned int reg;
	struct AES_KEYR1_BITS{
		unsigned int _AESKEY1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR1 (*((volatile union AES_KEYR1_REG *)0x40002734))
// model

/** 0x4000 2738 AES_KEYR2 **/
union AES_KEYR2_REG{
	unsigned int reg;
	struct AES_KEYR2_BITS{
		unsigned int _AESKEY2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR2 (*((volatile union AES_KEYR2_REG *)0x40002738))
// model

/** 0x4000 273C AES_KEYR3 **/
union AES_KEYR3_REG{
	unsigned int reg;
	struct AES_KEYR3_BITS{
		unsigned int _AESKEY3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR3 (*((volatile union AES_KEYR3_REG *)0x4000273C))
// model

/** 0x4000 2740 AES_KEYR4 **/
union AES_KEYR4_REG{
	unsigned int reg;
	struct AES_KEYR4_BITS{
		unsigned int _AESKEY4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR4 (*((volatile union AES_KEYR4_REG *)0x40002740))
// model

/** 0x4000 2744 AES_KEYR5 **/
union AES_KEYR5_REG{
	unsigned int reg;
	struct AES_KEYR5_BITS{
		unsigned int _AESKEY5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR5 (*((volatile union AES_KEYR5_REG *)0x40002744))
// model

/** 0x4000 2748 AES_KEYR6 **/
union AES_KEYR6_REG{
	unsigned int reg;
	struct AES_KEYR6_BITS{
		unsigned int _AESKEY6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR6 (*((volatile union AES_KEYR6_REG *)0x40002748))
// model

/** 0x4000 274C AES_KEYR7 **/
union AES_KEYR7_REG{
	unsigned int reg;
	struct AES_KEYR7_BITS{
		unsigned int _AESKEY7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_KEYR7 (*((volatile union AES_KEYR7_REG *)0x4000274C))
// model

/** 0x4000 2750 AES_IVR0 **/
union AES_IVR0_REG{
	unsigned int reg;
	struct AES_IVR0_BITS{
		unsigned int _AESIVR0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_IVR0 (*((volatile union AES_IVR0_REG *)0x40002750))
// model

/** 0x4000 2754 AES_IVR1 **/
union AES_IVR1_REG{
	unsigned int reg;
	struct AES_IVR1_BITS{
		unsigned int _AESIVR1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_IVR1 (*((volatile union AES_IVR1_REG *)0x40002754))
// model

/** 0x4000 2758 AES_IVR2 **/
union AES_IVR2_REG{
	unsigned int reg;
	struct AES_IVR2_BITS{
		unsigned int _AESIVR2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_IVR2 (*((volatile union AES_IVR2_REG *)0x40002758))
// model

/** 0x4000 275C AES_IVR3 **/
union AES_IVR3_REG{
	unsigned int reg;
	struct AES_IVR3_BITS{
		unsigned int _AESIVR3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_IVR3 (*((volatile union AES_IVR3_REG *)0x4000275C))
// model

/** 0x4000 2760 AES_SUSR0 **/
union AES_SUSR0_REG{
	unsigned int reg;
	struct AES_SUSR0_BITS{
		unsigned int _AESSUSR0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR0 (*((volatile union AES_SUSR0_REG *)0x40002760))
// model

/** 0x4000 2764 AES_SUSR1 **/
union AES_SUSR1_REG{
	unsigned int reg;
	struct AES_SUSR1_BITS{
		unsigned int _AESSUSR1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR1 (*((volatile union AES_SUSR1_REG *)0x40002764))
// model

/** 0x4000 2768 AES_SUSR2 **/
union AES_SUSR2_REG{
	unsigned int reg;
	struct AES_SUSR2_BITS{
		unsigned int _AESSUSR2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR2 (*((volatile union AES_SUSR2_REG *)0x40002768))
// model

/** 0x4000 276C AES_SUSR3 **/
union AES_SUSR3_REG{
	unsigned int reg;
	struct AES_SUSR3_BITS{
		unsigned int _AESSUSR3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR3 (*((volatile union AES_SUSR3_REG *)0x4000276C))
// model

/** 0x4000 2770 AES_SUSR4 **/
union AES_SUSR4_REG{
	unsigned int reg;
	struct AES_SUSR4_BITS{
		unsigned int _AESSUSR3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR4 (*((volatile union AES_SUSR4_REG *)0x40002770))
// model

/** 0x4000 2774 AES_SUSR5 **/
union AES_SUSR5_REG{
	unsigned int reg;
	struct AES_SUSR5_BITS{
		unsigned int _AESSUSR3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR5 (*((volatile union AES_SUSR5_REG *)0x40002774))
// model

/** 0x4000 2778 AES_SUSR6 **/
union AES_SUSR6_REG{
	unsigned int reg;
	struct AES_SUSR6_BITS{
		unsigned int _AESSUSR3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR6 (*((volatile union AES_SUSR6_REG *)0x40002778))
// model

/** 0x4000 277C AES_SUSR7 **/
union AES_SUSR7_REG{
	unsigned int reg;
	struct AES_SUSR7_BITS{
		unsigned int _AESSUSR3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_SUSR7 (*((volatile union AES_SUSR7_REG *)0x4000277C))
// model

/** 0x4000 2780 AES_MASK0 **/
union AES_MASK0_REG{
	unsigned int reg;
	struct AES_MASK0_BITS{
		unsigned int _AESMASK0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_MASK0 (*((volatile union AES_MASK0_REG *)0x40002780))
// model

/** 0x4000 2784 AES_MASK1 **/
union AES_MASK1_REG{
	unsigned int reg;
	struct AES_MASK1_BITS{
		unsigned int _AESMASK1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_MASK1 (*((volatile union AES_MASK1_REG *)0x40002784))
// model

/** 0x4000 2788 AES_MASK2 **/
union AES_MASK2_REG{
	unsigned int reg;
	struct AES_MASK2_BITS{
		unsigned int _AESMASK2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_MASK2 (*((volatile union AES_MASK2_REG *)0x40002788))
// model

/** 0x4000 278C AES_MASK3 **/
union AES_MASK3_REG{
	unsigned int reg;
	struct AES_MASK3_BITS{
		unsigned int _AESMASK3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_MASK3 (*((volatile union AES_MASK3_REG *)0x4000278C))
// modelISMU

/** 0x4000 5F00 ISMU_STA **/
union ISMU_STA_REG{
	unsigned int reg;
	struct ISMU_STA_BITS{
		unsigned int _BUSY:1;
		unsigned int _BSTA:1;
		unsigned int _BINIT:1;
		unsigned int _BFN:1;
		unsigned int _BOK:1;
		unsigned int _RNGINIT:1;
		unsigned int _EDB:1;
		unsigned int _IDB:1;
		unsigned int _INITFIN:1;
		unsigned int _DEBCHAFIN:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ISMU_STA (*((volatile union ISMU_STA_REG *)0x40005F00))
// model

/** 0x4000 5F04 ISMU_INT **/
union ISMU_INT_REG{
	unsigned int reg;
	struct ISMU_INT_BITS{
		unsigned int _CMDIF:1;
		unsigned int :7;
		unsigned int _CMDIE:1;
		unsigned int :7;
		unsigned int _CMDIC:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ISMU_INT (*((volatile union ISMU_INT_REG *)0x40005F04))
// modelWRLOCK

/** 0x4000 3A80 WRLOCK_R0 **/
union WRLOCK_R0_REG{
	unsigned int reg;
	struct WRLOCK_R0_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY0:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R0 (*((volatile union WRLOCK_R0_REG *)0x40003A80))
// model

/** 0x4000 3A84 WRLOCK_R1 **/
union WRLOCK_R1_REG{
	unsigned int reg;
	struct WRLOCK_R1_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R1 (*((volatile union WRLOCK_R1_REG *)0x40003A84))
// model

/** 0x4000 3A88 WRLOCK_R2 **/
union WRLOCK_R2_REG{
	unsigned int reg;
	struct WRLOCK_R2_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY2:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R2 (*((volatile union WRLOCK_R2_REG *)0x40003A88))
// model

/** 0x4000 3A8C WRLOCK_R3 **/
union WRLOCK_R3_REG{
	unsigned int reg;
	struct WRLOCK_R3_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R3 (*((volatile union WRLOCK_R3_REG *)0x40003A8C))
// model

/** 0x4000 3A90 WRLOCK_R4 **/
union WRLOCK_R4_REG{
	unsigned int reg;
	struct WRLOCK_R4_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY4:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R4 (*((volatile union WRLOCK_R4_REG *)0x40003A90))
// model

/** 0x4000 3A94 WRLOCK_R5 **/
union WRLOCK_R5_REG{
	unsigned int reg;
	struct WRLOCK_R5_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY5:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R5 (*((volatile union WRLOCK_R5_REG *)0x40003A94))
// model

/** 0x4000 3A98 WRLOCK_R6 **/
union WRLOCK_R6_REG{
	unsigned int reg;
	struct WRLOCK_R6_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY6:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R6 (*((volatile union WRLOCK_R6_REG *)0x40003A98))
// model

/** 0x4000 3A9C WRLOCK_R7 **/
union WRLOCK_R7_REG{
	unsigned int reg;
	struct WRLOCK_R7_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY7:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R7 (*((volatile union WRLOCK_R7_REG *)0x40003A9C))
// model

/** 0x4000 3AA0 WRLOCK_R8 **/
union WRLOCK_R8_REG{
	unsigned int reg;
	struct WRLOCK_R8_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY8:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R8 (*((volatile union WRLOCK_R8_REG *)0x40003AA0))
// model

/** 0x4000 3AA4 WRLOCK_R9 **/
union WRLOCK_R9_REG{
	unsigned int reg;
	struct WRLOCK_R9_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY9:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R9 (*((volatile union WRLOCK_R9_REG *)0x40003AA4))
// model

/** 0x4000 3AA8 WRLOCK_R10 **/
union WRLOCK_R10_REG{
	unsigned int reg;
	struct WRLOCK_R10_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY10:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R10 (*((volatile union WRLOCK_R10_REG *)0x40003AA8))
// model

/** 0x4000 3AAC WRLOCK_R11 **/
union WRLOCK_R11_REG{
	unsigned int reg;
	struct WRLOCK_R11_BITS{
		unsigned int _WRLOCKEN:1;
		unsigned int :15;
		unsigned int _KEY11:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WRLOCK_R11 (*((volatile union WRLOCK_R11_REG *)0x40003AAC))
// modelCMU

/** 0x4000 3980 CMU_CTL **/
union CMU_CTL_REG{
	unsigned int reg;
	struct CMU_CTL_BITS{
		unsigned int _CMUEN1:1;
		unsigned int _CMUEN2:1;
		unsigned int _CMUEN3:1;
		unsigned int _CMUEN4:1;
		unsigned int _FHHIC1:1;
		unsigned int _FLLIC1:1;
		unsigned int _FHHIC2:1;
		unsigned int _FLLIC2:1;
		unsigned int _FHHIC3:1;
		unsigned int _FLLIC3:1;
		unsigned int _FHHIC4:1;
		unsigned int _FLLIC4:1;
		unsigned int _CH1REFIC:1;
		unsigned int _CH2REFIC:1;
		unsigned int _CH3REFIC:1;
		unsigned int _CH4REFIC:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_CTL (*((volatile union CMU_CTL_REG *)0x40003980))
// model

/** 0x4000 3984 CMU_INT **/
union CMU_INT_REG{
	unsigned int reg;
	struct CMU_INT_BITS{
		unsigned int _FHHIF1:1;
		unsigned int _FLLIF1:1;
		unsigned int _FHHIF2:1;
		unsigned int _FLLIF2:1;
		unsigned int _FHHIF3:1;
		unsigned int _FLLIF3:1;
		unsigned int _FHHIF4:1;
		unsigned int _FLLIF4:1;
		unsigned int _FHHIE1:1;
		unsigned int _FLLIE1:1;
		unsigned int _FHHIE2:1;
		unsigned int _FLLIE2:1;
		unsigned int _FHHIE3:1;
		unsigned int _FLLIE3:1;
		unsigned int _FHHIE4:1;
		unsigned int _FLLIE4:1;
		unsigned int _CH1REFIE:1;
		unsigned int _CH2REFIE:1;
		unsigned int _CH3REFIE:1;
		unsigned int _CH4REFIE:1;
		unsigned int _CH1REFIF:1;
		unsigned int _CH2REFIF:1;
		unsigned int _CH3REFIF:1;
		unsigned int _CH4REFIF:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_INT (*((volatile union CMU_INT_REG *)0x40003984))
// model

/** 0x4000 3988 CMU_REFCNT1 **/
union CMU_REFCNT1_REG{
	unsigned int reg;
	struct CMU_REFCNT1_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT1 (*((volatile union CMU_REFCNT1_REG *)0x40003988))
// model

/** 0x4000 398C CMU_HTC1 **/
union CMU_HTC1_REG{
	unsigned int reg;
	struct CMU_HTC1_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC1 (*((volatile union CMU_HTC1_REG *)0x4000398C))
// model

/** 0x4000 3990 CMU_LTC1 **/
union CMU_LTC1_REG{
	unsigned int reg;
	struct CMU_LTC1_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC1 (*((volatile union CMU_LTC1_REG *)0x40003990))
// model

/** 0x4000 3994 CMU_REFCNT2 **/
union CMU_REFCNT2_REG{
	unsigned int reg;
	struct CMU_REFCNT2_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT2 (*((volatile union CMU_REFCNT2_REG *)0x40003994))
// model

/** 0x4000 3998 CMU_HTC2 **/
union CMU_HTC2_REG{
	unsigned int reg;
	struct CMU_HTC2_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC2 (*((volatile union CMU_HTC2_REG *)0x40003998))
// model

/** 0x4000 399C CMU_LTC2 **/
union CMU_LTC2_REG{
	unsigned int reg;
	struct CMU_LTC2_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC2 (*((volatile union CMU_LTC2_REG *)0x4000399C))
// model

/** 0x4000 39A0 CMU_REFCNT3 **/
union CMU_REFCNT3_REG{
	unsigned int reg;
	struct CMU_REFCNT3_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT3 (*((volatile union CMU_REFCNT3_REG *)0x400039A0))
// model

/** 0x4000 39A4 CMU_HTC3 **/
union CMU_HTC3_REG{
	unsigned int reg;
	struct CMU_HTC3_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC3 (*((volatile union CMU_HTC3_REG *)0x400039A4))
// model

/** 0x4000 39A8 CMU_LTC3 **/
union CMU_LTC3_REG{
	unsigned int reg;
	struct CMU_LTC3_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC3 (*((volatile union CMU_LTC3_REG *)0x400039A8))
// model

/** 0x4000 39AC CMU_REFCNT4 **/
union CMU_REFCNT4_REG{
	unsigned int reg;
	struct CMU_REFCNT4_BITS{
		unsigned int _REFCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_REFCNT4 (*((volatile union CMU_REFCNT4_REG *)0x400039AC))
// model

/** 0x4000 39B0 CMU_HTC4 **/
union CMU_HTC4_REG{
	unsigned int reg;
	struct CMU_HTC4_BITS{
		unsigned int _HFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_HTC4 (*((volatile union CMU_HTC4_REG *)0x400039B0))
// model

/** 0x4000 39B4 CMU_LTC4 **/
union CMU_LTC4_REG{
	unsigned int reg;
	struct CMU_LTC4_BITS{
		unsigned int _LFREF:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMU_LTC4 (*((volatile union CMU_LTC4_REG *)0x400039B4))
// modelPM

/** 0x4000 1580 PM_CTL0 **/
union PM_CTL0_REG{
	unsigned int reg;
	struct PM_CTL0_BITS{
		unsigned int _LPMS:3;
		unsigned int _MEMSEL:1;
		unsigned int :1;
		unsigned int _LPREN:1;
		unsigned int _OCALLOCK:1;
		unsigned int _BKPWR:1;
		unsigned int _HSIEN:1;
		unsigned int _PDMDELAY:2;
		unsigned int _PDMSEL:1;
		unsigned int _VCOREPD12SELB:1;
		unsigned int _PHERIIOSEL:1;
		unsigned int :1;
		unsigned int _PORDELAYSEL:1;
		unsigned int _IWDTRMSEL:1;
		unsigned int _LSECONF:1;
		unsigned int _LP16MEN:1;
		unsigned int _LPRAMSEL:1;
		unsigned int _DPRAMASEL:1;
		unsigned int _IWDTCLR:1;
		unsigned int _BKPREGCLR:1;
		unsigned int _LPBGON:1;
		unsigned int _LDO18EN:1;
		unsigned int _MRBGEN:1;
		unsigned int :1;
		unsigned int _LSEEXEN:1;
		unsigned int _LSEEN:1;
		unsigned int _LSIEN:1;
		unsigned int :1;
		unsigned int _IOLATCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL0 (*((volatile union PM_CTL0_REG *)0x40001580))
// model

/** 0x4000 1584 PM_CTL1 **/
union PM_CTL1_REG{
	unsigned int reg;
	struct PM_CTL1_BITS{
		unsigned int _PVDEN:1;
		unsigned int _LPRTYPE:1;
		unsigned int _PVDS:3;
		unsigned int _VREFEN:1;
		unsigned int _VREFSEL:2;
		unsigned int _LPDEBUG:1;
		unsigned int _P18LVLSENB:1;
		unsigned int _RAMECCEN:1;
		unsigned int _LPCANCLKS:1;
		unsigned int _VDDOVDSEL:3;
		unsigned int _VDDOVDEN:1;
		unsigned int _MONV12EN:1;
		unsigned int _MONV18EN:1;
		unsigned int :1;
		unsigned int _MONV24EN:1;
		unsigned int _BUFLVL18EN:1;
		unsigned int :1;
		unsigned int _BUFCLKDIV:3;
		unsigned int _BUFCLKEN:1;
		unsigned int _INTBUFEN:1;
		unsigned int _P18OE:1;
		unsigned int _TSOE:1;
		unsigned int _TSEN:1;
		unsigned int _PVDWKEN:1;
		unsigned int _BOREN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL1 (*((volatile union PM_CTL1_REG *)0x40001584))
// model

/** 0x4000 1588 PM_STA0 **/
union PM_STA0_REG{
	unsigned int reg;
	struct PM_STA0_BITS{
		unsigned int _LPRSTA:1;
		unsigned int _LPRUNF:1;
		unsigned int :20;
		unsigned int _BKPPORIF:1;
		unsigned int _NRSTIF:1;
		unsigned int _PORIF:1;
		unsigned int _WSRSTF:1;
		unsigned int _BORF:1;
		unsigned int _PORF:1;
		unsigned int _WKPPINF:1;
		unsigned int _RTCALRF:1;
		unsigned int _IWDTF:1;
		unsigned int _RSTFC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA0 (*((volatile union PM_STA0_REG *)0x40001588))
// model

/** 0x4000 158C PM_STA1 **/
union PM_STA1_REG{
	unsigned int reg;
	struct PM_STA1_BITS{
		unsigned int _PVDSTA:1;
		unsigned int :10;
		unsigned int _WKP6STA:1;
		unsigned int _WKP7STA:1;
		unsigned int _WKP8STA:1;
		unsigned int _WKP9STA:1;
		unsigned int _WKP10STA:1;
		unsigned int _WKP11STA:1;
		unsigned int _WKP12STA:1;
		unsigned int _STOPERROR:1;
		unsigned int _PMCERROR:1;
		unsigned int _LPMDROPIF:1;
		unsigned int :1;
		unsigned int _POR18FINISH:1;
		unsigned int _OVDIF:1;
		unsigned int _OVDIC:1;
		unsigned int _OVDIE:1;
		unsigned int _PMCIF:1;
		unsigned int _WKP1STA:1;
		unsigned int _WKP2STA:1;
		unsigned int _WKP3STA:1;
		unsigned int _WKP4STA:1;
		unsigned int _WKP5STA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA1 (*((volatile union PM_STA1_REG *)0x4000158C))
// model

/** 0x4000 1590 PM_STAC **/
union PM_STAC_REG{
	unsigned int reg;
	struct PM_STAC_BITS{
		unsigned int _FVRMS:2;
		unsigned int _WKP6EN:1;
		unsigned int _WKP7EN:1;
		unsigned int _WKP8EN:1;
		unsigned int _WKP9EN:1;
		unsigned int _WKP10EN:1;
		unsigned int _WKP11EN:1;
		unsigned int _WKP12EN:1;
		unsigned int _WKP6P:1;
		unsigned int _WKP7P:1;
		unsigned int _WKP8P:1;
		unsigned int _WKP9P:1;
		unsigned int _WKP10P:1;
		unsigned int _WKP11P:1;
		unsigned int _WKP12P:1;
		unsigned int _WKP6SC:1;
		unsigned int _WKP7SC:1;
		unsigned int _WKP8SC:1;
		unsigned int _WKP9SC:1;
		unsigned int _WKP10SC:1;
		unsigned int _WKP11SC:1;
		unsigned int _WKP12SC:1;
		unsigned int :1;
		unsigned int _INTLF4MEN:1;
		unsigned int _IWDTDBGEN:1;
		unsigned int _PMCIC:1;
		unsigned int _WKP1SC:1;
		unsigned int _WKP2SC:1;
		unsigned int _WKP3SC:1;
		unsigned int _WKP4SC:1;
		unsigned int _WKP5SC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STAC (*((volatile union PM_STAC_REG *)0x40001590))
// model

/** 0x4000 1594 PM_CTL2 **/
union PM_CTL2_REG{
	unsigned int reg;
	struct PM_CTL2_BITS{
		unsigned int _CAN6LPEN:1;
		unsigned int _CCP0LPEN:1;
		unsigned int _EWDTLPEN:1;
		unsigned int _USART0LPEN:1;
		unsigned int _CAN6CLKLPEN:1;
		unsigned int _CCP0CLKLPEN:1;
		unsigned int _EWMCLKLPEN:1;
		unsigned int _USART0CLKLPEN:1;
		unsigned int _POR18SHD:1;
		unsigned int _VF12INF0:1;
		unsigned int _VF12INF1:1;
		unsigned int _VF12EN:1;
		unsigned int _TTSEL:2;
		unsigned int _TTPRESEN:1;
		unsigned int _TTWKPEN:1;
		unsigned int _QEI0CLKLPEN:1;
		unsigned int _GPIOALPEN:1;
		unsigned int _QEI0LPEN:1;
		unsigned int _PMCIE:1;
		unsigned int :2;
		unsigned int _WKP1P:1;
		unsigned int _WKP2P:1;
		unsigned int _WKP3P:1;
		unsigned int _WKP4P:1;
		unsigned int _WKP5P:1;
		unsigned int _WKP1EN:1;
		unsigned int _WKP2EN:1;
		unsigned int _WKP3EN:1;
		unsigned int _WKP4EN:1;
		unsigned int _WKP5EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL2 (*((volatile union PM_CTL2_REG *)0x40001594))
// model

/** 0x4000 1598 PM_CAL0 **/
union PM_CAL0_REG{
	unsigned int reg;
	struct PM_CAL0_BITS{
		unsigned int _BGTRIMFLLDO:5;
		unsigned int _BGTRIMMRLDO:5;
		unsigned int _NRST0EN:1;
		unsigned int _NRST1EN:1;
		unsigned int :1;
		unsigned int _STOP0PLL:1;
		unsigned int _STANDBY0STOP1WAKEEN:1;
		unsigned int _STANDBY0STOP1WAKESEL:1;
		unsigned int _MRTRIM:2;
		unsigned int _BORVREFSEL:1;
		unsigned int :3;
		unsigned int _FLBGEN:1;
		unsigned int :1;
		unsigned int _ZEROTISTRIM:2;
		unsigned int _VREF1VTRIM:6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL0 (*((volatile union PM_CAL0_REG *)0x40001598))
// model

/** 0x4000 159C PM_CAL1 **/
union PM_CAL1_REG{
	unsigned int reg;
	struct PM_CAL1_BITS{
		unsigned int _LSETRIMNBIAS:2;
		unsigned int _LSETRIMBIAS:3;
		unsigned int :1;
		unsigned int _LP4MTRIM:9;
		unsigned int _HSESEL:1;
		unsigned int :3;
		unsigned int _LSESEL:1;
		unsigned int _LPTRIMBIAS:3;
		unsigned int _SPCPUR:1;
		unsigned int _LSITRIMCAP:5;
		unsigned int _LSITRIMBIAS:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL1 (*((volatile union PM_CAL1_REG *)0x4000159C))
// model

/** 0x4000 15A0 PM_CAL2 **/
union PM_CAL2_REG{
	unsigned int reg;
	struct PM_CAL2_BITS{
		unsigned int _MRDELAS:2;
		unsigned int _VCOREDELAS:2;
		unsigned int _LPRDELAS:2;
		unsigned int _PMCOSCOFFTIMINGSEL:1;
		unsigned int _PMCWKPTESTSEL1:1;
		unsigned int _STOPTEST:1;
		unsigned int _POR12NODELAY:1;
		unsigned int _DELAYUSEHSI:1;
		unsigned int _STANDBYNORMALBKPON:1;
		unsigned int _ICSPCAL12EN:1;
		unsigned int _ICSPCAL13EN:1;
		unsigned int :8;
		unsigned int _CAPFREELDOIS:2;
		unsigned int _LPR12CAPLESSI:5;
		unsigned int :1;
		unsigned int _PMCWKPSEL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL2 (*((volatile union PM_CAL2_REG *)0x400015A0))
// model

/** 0x4000 15A4 PM_CAL3 **/
union PM_CAL3_REG{
	unsigned int reg;
	struct PM_CAL3_BITS{
		unsigned int _FVRCLTTRIM:8;
		unsigned int _FVRCAPTRIM:8;
		unsigned int _CANA01EN:7;
		unsigned int :1;
		unsigned int _FLASHBGTRIM:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL3 (*((volatile union PM_CAL3_REG *)0x400015A4))
// model

/** 0x4000 15A8 PM_CAL4 **/
union PM_CAL4_REG{
	unsigned int reg;
	struct PM_CAL4_BITS{
		unsigned int _LP16MTRIM:9;
		unsigned int :12;
		unsigned int _TESTEN_BKP:1;
		unsigned int _TESTEN_USER:1;
		unsigned int _TESTEN_ROMINT:1;
		unsigned int _TESTEN_DMA:1;
		unsigned int _TESTEN_RUNOUT:1;
		unsigned int _TESTEN_FETCHOUT:1;
		unsigned int _TESTEN_DFLASH:1;
		unsigned int _IAP64A01MAK:1;
		unsigned int _CACHEA01MAK:1;
		unsigned int _DEBUGA01MASK:1;
		unsigned int _STOP0SLEEPSEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL4 (*((volatile union PM_CAL4_REG *)0x400015A8))
// model

/** 0x4000 15AC PM_CTL3 **/
union PM_CTL3_REG{
	unsigned int reg;
	struct PM_CTL3_BITS{
		unsigned int _PMIWDTEN:1;
		unsigned int _BORSEL:2;
		unsigned int _BORHSEN:1;
		unsigned int _FVRCAPLESSEN:1;
		unsigned int _FVRCAPLESSMODE:1;
		unsigned int _BORWKPEN:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL3 (*((volatile union PM_CTL3_REG *)0x400015AC))
#endif
