#! /usr/bin/env bash
# Copyright (c) 2011-2015, ChipON Limited
# All rights reserved.
# 


set -e
set -x
set -u
set -o pipefail

umask 022

exec < /dev/null

script_path=`cd $(dirname $0) && pwd -P`
. $script_path/build-common.sh

usage ()
{
cat<<EOF

This script will build dependent libraries for gcc kungfu32 embedded toolchain.
EOF
}

if [ $# -gt 2 ] ; then
    usage
fi

skip_steps=


for ac_arg; do
    case $ac_arg in
        --skip_steps=*)
            skip_steps=`echo $ac_arg | sed -e "s/--skip_steps=//g" -e "s/,/ /g"`
            ;;   
        *)
            usage
	    exit 1
            ;;
    esac
done

if [ "x$skip_steps" != "x" ]; then
        for ss in $skip_steps; do
                case $ss in
                    *)
                      echo "Unknown build steps: $ss" 1>&2
                      usage
                      exit 1
                      ;;
                esac
        done
fi



echo Task [I-0] build
set TL_PATH=$SRCDIR
set TOOL_PATH=$HOME/ChipONCC32
set TOOL_CHAIN=ccr1_issue
set MAKE=gmake

set WORK_PATH=$HOME/workspace32
set PROJECT_NAME=1233
set PROJECT_MODE=Release

set PATH=%TOOL_PATH%/%TOOL_CHAIN%/bin;%TOOL_PATH%/%TOOL_CHAIN%/kf32/bin;%TOOL_PATH%/common;%TOOL_PATH%/%TOOL_CHAIN%/lib/gcc/kf32/4.7.0;%TL_PATH%;%PATH%


echo Init building ...

echo delete history hex file ...

rm -rf "$TL_PATH$PROJECT_NAME_UPDATE.hex"

rm -rf "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE/$PROJECT_NAME.hex"
rm -rf "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE/$PROJECT_NAME.elf"
rm -rf "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE/$PROJECT_NAME.map"
rm -rf "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE/$PROJECT_NAME.lst"

echo Init building ...
pushd "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE"

echo In Cut Upgrade file Please Wait a moment

#%MAKE% -k clean
%MAKE% -k -j$JOBS all 
type build_log.txt

Setlocal Enabledelayedexpansion
set /a row=0

cp "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE/build_log.txt" "$TL_PATHbuild_log.txt"


cp "$WORK_PATH/$PROJECT_NAME/$PROJECT_MODE/$PROJECT_NAME.hex" "$TL_PATH$PROJECT_NAME_UPDATE.hex"

echo Done.
popd






