/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: IWDG
 *  :  V2.3
 *  :  20191116
 *     ChipON_AE/FAE_Group
 *     ļṩʵֶŹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
#define    KEYUSER    GPIO_Read_Input_Data_Bit(GPIOD_SFR,GPIO_PIN_MASK_7)  //ȡPD7ƽ

//ʱ ֲvolatileܻᱻŻ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=7000;
		while(j--);
	}

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;                   //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ 
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                   //ʼ GPIOǷ 
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}


/**
  *   GPIOx ʼá
  *  : 
  *   ޡ
  */
void GPIO_Init(void)
{
	GPIOInit_Input_Config(GPIOD_SFR,GPIO_PIN_MASK_7);//PD7Ϊģʽ
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);//PB13ΪΪߵƽ
}



/**
  *  Ź趨ʱá
  *   OverflowȡֵΪ0~0xFFF Źֵ
  *     PrescalerINTLFԤƵֵ
  *   ޡ
  */
void IWDT_Config(uint32_t Overflow,uint32_t Prescaler)
{

#ifdef SYSCLK_FREQ_HSI
	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF);                       //ѡINTHFΪϵͳʱӽƵ
#else
	OSC_SCK_Source_Config(SCLK_SOURCE_EXTHF);                       //ѡEXTHFΪϵͳʱӽƵ
#endif
	BKP_Write_And_Read_Enable(TRUE);                                //дʹ
	PM_Independent_Watchdog_Reset_Config(PERIPHERAL_OUTRST_STATUS); //ʹܶŹ˳λ״̬
	PM_Internal_Low_Frequency_Enable(TRUE);                         //ڲƵʹ
	IWDT_Overflow_Config (Overflow);                                //ŹֵȡֵΪ500//1ӿŹ
	IWDT_Prescaler_Config(Prescaler);                               //ŹINTLF164ԤƵֵ
	IWDT_Enable(TRUE);                                              //ʹܶŹ

	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);                         //ѡpllΪϵͳʱ
}




//
void main()
{
	/*ûɲοKF32A151_demoʵʹöŹܡ
	 * жŹʱԴΪڲ32KHZ 164Ƶ500ΣλʱΪ1
	 * ûKEY2ʱϵͳ1븴λһD4˸KEYUSERϵͳD4Ƴ
	 *
	 *ע⣺öŹ֮ǰҪлƵ򿪱öŹ
     */
	//ϵͳʱ120M,Ƶʱ16M
	SystemInit(); //ϵͳʱӳʼ
	GPIO_Init();  //GPIOʼ
	//Ź
	IWDT_Config(500,IWDT_PRESCALER_64);//Ź 32KHZ 164Ƶ500Σ 1Ӻϵͳλ

	//PB13ߵƽ
	GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_13,Bit_SET);
	while(1)
    {
		if(KEYUSER)
		{
			IWDT_Feed_The_Dog();//KEYUSERºιϵͳûιʱ1ϵͳλ

		}
		delay_ms(20);
    }

}



void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

