/**
  ******************************************************************************
  * ļ  Usart.c
  *     ChipON_AE/FAE_Group
  *     2019-10-19
  *     ļṩ˴ú
  *          + ڷ
  *          + 첽
  *          + ͬ
  *          + ڽжʹ
  ******************************************************************************/
#include "system_init.h"
#include "Usart.h"

void USART_Async_config(USART_SFRmap *USARTx);//첽ȫ˫
void USART_Sync_config(USART_SFRmap* USARTx); //ڰ˫ͬ
void USART_ReceiveInt_config(USART_SFRmap *USARTx,InterruptIndex Peripheral);//ڽжʹ
void USART_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length);//ڷͺ
volatile uint8_t USART_Array_rec[256]={0};
/**
  *    ڷ
  *    USARTx:   ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Databuf   ָݵָ
  *      length      ͵ĳ
  *    
  */
void USART_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length)
{
	uint32_t i;
	for(i=0;i<length;i++)
	{
		//ڷ
		USART_SendData(USARTx,Databuf[i]);
		//ɱ־
		while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	}
}
void DMA_USART2Rx_Init(DMA_SFRmap *DMAx)
{
	DMA_InitTypeDef dmaNewStruct;
	/* DMAλ */
	DMA_Reset (DMAx);
	/* DMA */
	DMA_Struct_Init( &dmaNewStruct );
	/*  ݸ: 256 */
	dmaNewStruct.m_Number = 256;
	/*  DMA䷽ڴ */
	dmaNewStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;//DMA_MEMORY_TO_PERIPHERAL;//
	/*  DMAͨȼȼ */
	dmaNewStruct.m_Priority = DMA_CHANNEL_LOWER;
	/*  λ8λ */
	dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;
	/*  洢λ:8λ */
	dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;
	/*  ַģʽʹ: ֹ */
	dmaNewStruct.m_PeripheralInc = 0;
	/*  洢ַģʽʹ: ʹ */
	dmaNewStruct.m_MemoryInc = 1;
	/*  DMAͨѡ:DMA0-ͨ6*/
	dmaNewStruct.m_Channel = USART2_RXDMA_CHAN;
	/*  ݿ鴫ģʽ */
	dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;//DMA_TRANSFER_BYTE; //DMA_TRANSFER_BLOCK;//
	/*  ѭģʽʹ: ʹ */
	dmaNewStruct.m_LoopMode = 1;
	/*  ʼַȴյݵʼַ */
	dmaNewStruct.m_PeriphAddr = (uint32_t)&USART2_SFR->RBUFR ; //T1
	/*  ڴʼַݵڴռʼַ */
	dmaNewStruct.m_MemoryAddr = (uint32_t)USART_Array_rec;

	/* DMAܺ */
	DMA_Configuration (DMAx, &dmaNewStruct); //дDMAxĴ
	DMA_Memory_To_Memory_Enable (DMAx, USART2_RXDMA_CHAN, FALSE);
	DMA_Finish_Transfer_INT_Enable(DMAx,USART2_RXDMA_CHAN,TRUE);

}

/**
  *   첽ȫ˫(Ĭ8bitշʹ  ȫ˫ 115200)
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_Async_config(USART_SFRmap *USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
    USART_InitStructure.m_Mode=USART_MODE_FULLDUPLEXASY;                        //ȫ˫
    USART_InitStructure.m_TransferDir=USART_DIRECTION_FULL_DUPLEX;              //䷽
    USART_InitStructure.m_WordLength=USART_WORDLENGTH_8B;                       //8λ
    USART_InitStructure.m_StopBits=USART_STOPBITS_1;                            //1λֹͣλ
    USART_InitStructure.m_BaudRateBRCKS=USART_CLK_HFCLK;                        //ڲƵʱΪ USARTʷʱ

    /*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
    //4800    z:208    x:0    y:0
    //9600    z:104    x:0    y:0
    //19200   z:52     x:0    y:0
    //115200  z:8      x:1    y:13
    //115200
    USART_InitStructure.m_BaudRateInteger=8;         //USARTzȡֵΪ0~65535
    USART_InitStructure.m_BaudRateNumerator=1;         //USARTСӲxȡֵΪ0~0xF
    USART_InitStructure.m_BaudRateDenominator=13;       //USARTСĸyȡֵΪ0~0xF


	USART_Reset(USARTx);                                       //USARTxλ
	USART_Configuration(USARTx,&USART_InitStructure);          //USARTx
    USART_Passageway_Select_Config(USARTx,USART_U7816R_PASSAGEWAY_TX0);//UASRTxѡTX0ͨ
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);                //USARTxBUF
	USART_RESHD_Enable (USARTx, TRUE);						   //ʹRESHDλ
	USART_Cmd(USARTx,TRUE);                                    //USARTxʹ
}

/**
  *    ڰ˫ͬ(Ĭģʽ9bitͣ9600)
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_Sync_config(USART_SFRmap* USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
    USART_InitStructure.m_Mode=USART_MODE_HALFDUPLEXSYN;                        //˫
    USART_InitStructure.m_HalfDuplexClkSource=USART_MASTER_CLOCKSOURCE_INTER;   //ģʽ
    USART_InitStructure.m_TransferDir=USART_DIRECTION_TRANSMIT;                 //䷽""
    USART_InitStructure.m_WordLength=USART_WORDLENGTH_9B;                       //9λ
    USART_InitStructure.m_Parity=USART_PARITY_ODD;                              //У
    USART_InitStructure.m_BaudRateBRCKS=USART_CLK_HFCLK;                        //ڲƵʱΪ USARTʷʱ

    /*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
    //4800    z:208    x:0    y:0
    //9600    z:104    x:0    y:0
    //19200   z:52     x:0    y:0
    //115200  z:8      x:1    y:13
    //9600
    USART_InitStructure.m_BaudRateInteger=104;         //USARTzȡֵΪ0~65535
    USART_InitStructure.m_BaudRateNumerator=0;         //USARTСӲxȡֵΪ0~0xF
    USART_InitStructure.m_BaudRateDenominator=0;       //USARTСĸyȡֵΪ0~0xF

	USART_Reset(USARTx);                                       //USARTxλ
	USART_Configuration(USARTx,&USART_InitStructure);          //USARTx
	USART_Passageway_Select_Config(USARTx,USART_U7816R_PASSAGEWAY_TX0);//UASRTxѡTX0ͨ
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);                //USARTxBUF
	USART_RESHD_Enable (USARTx, TRUE);						   //ʹRESHDλ
	USART_Cmd(USARTx,TRUE);                                    //USARTxʹ
}


/**
  *    ڽж
  *    USARTx:ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Peripheral:ںжţȡֵΧΪ
  *                 öInterruptIndexеж
  *    
  */
void USART_ReceiveInt_config(USART_SFRmap *USARTx,InterruptIndex Peripheral)
{

	//USART_RDR_INT_Enable(USARTx,TRUE);
	//USART_Clear_Transmit_BUFR_INT_Flag(USARTx);
	USART_Receive_Idle_Frame_Config(USARTx, TRUE);
	USART_IDLE_INT_Enable(USARTx, TRUE);
	INT_Interrupt_Enable(Peripheral,TRUE);
	//sUSART_ReceiveData(USARTx);//ձ־λ
	//INT_All_Enable(TRUE);
}
