/****************************************************************************************
 * ļ: I2C_Slave.c
 * Ŀ: I2C_Slave_Mode
 *  :  V2.4
 *  :  2021729
 *     ChipON_AE/FAE_Group
 *     ļṩI2CͨŹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
#include "I2C_Slave.h"


/**
  *    I2C GPIOӳʼ
  *    
  *    
*/
void I2C_GPIO_init(void)
{
	/*I2Cx*/
	/**/
	GPIO_InitTypeDef I2C_GPIO_Init;

	I2C_GPIO_Init.m_Mode = GPIO_MODE_RMP;                           //GPIOӳ书
	I2C_GPIO_Init.m_OpenDrain = GPIO_POD_OD;                        //GPIO©
	I2C_GPIO_Init.m_Speed = GPIO_HIGH_SPEED;						//IOΪ
	I2C_GPIO_Init.m_Pin = GPIO_PIN_MASK_1|GPIO_PIN_MASK_2;          //Px1 Px2
	I2C_GPIO_Init.m_PullUp = GPIO_NOPULL;                           //GPIO
	I2C_GPIO_Init.m_PullDown = GPIO_NOPULL;                         //ʹGPIO
	GPIO_Pin_RMP_Config(GPIOB_SFR,GPIO_Pin_Num_1,GPIO_RMP_AF8_I2C1); //PB1ΪI2C1 SCL
	GPIO_Pin_RMP_Config(GPIOB_SFR,GPIO_Pin_Num_2,GPIO_RMP_AF8_I2C1); //PB2ΪI2C1 SDA
	GPIO_Configuration(GPIOB_SFR,&I2C_GPIO_Init);

}


/**
  *    I2Cx ʼ
  *    I2CxȡֵΧI2C0_SFR~I2C3_SFR   ѡõI2C
  *      I2C_ADDRESS:ȡֵΧ0x0~0x3FF     ӻӦ7λַ10λַ
  *    
*/
void I2C_init_Slave(I2C_SFRmap* I2Cx,uint16_t I2C_ADDRESS)
{
	/*I2CxӦò*/
	I2C_Reset(I2Cx);
	I2C_InitTypeDef newStruct_I2C;                        //
	newStruct_I2C.m_Mode = I2C_MODE_I2C;                  //ΪI2Cģʽ
	newStruct_I2C.m_ClockSource = I2C_CLK_SCLK;           //ʱԴѡSCLK
	newStruct_I2C.m_BADR10 = I2C_BUFRADDRESS_7BIT;        //7λӻַ
	newStruct_I2C.m_MasterSlave = I2C_MODE_SMBUSDEVICE;    //SMBusѡӻģʽ
	newStruct_I2C.m_BaudRateL = 12;                       //I2Cʵ͵ƽʱ   ֵ С3
	newStruct_I2C.m_BaudRateH = 12;                       //I2Cʸߵƽʱ   ֵ С3
	newStruct_I2C.m_AckEn = TRUE;                         //ʹӦ
	newStruct_I2C.m_AckData = I2C_ACKDATA_ACK;            //ѡӦźΪACK
	I2C_Configuration(I2Cx, &newStruct_I2C);

	I2C_ADDR_Config(I2Cx,0,I2C_ADDRESS);   //ôӻI2Cַ0
	I2C_ADDR_Config(I2Cx,1,I2C_ADDRESS);   //ôӻI2Cַ1
	I2C_ADDR_Config(I2Cx,2,I2C_ADDRESS);   //ôӻI2Cַ2
	I2C_ADDR_Config(I2Cx,3,I2C_ADDRESS);   //ôӻI2Cַ3
	I2C_MSK_Config (I2Cx,0,0x0000);        //I2Cַλ

	I2C_Clear_INTERRUPT_Flag(I2Cx);        //I2Cжϱ־λ

	I2C_MATCH_ADDRESS_Config(I2Cx,TRUE);   //ʹI2Cַƥ
	I2C_Cmd(I2Cx,TRUE);                    //ʹI2Cģ

	/********************I2Cж*****************/
	INT_Interrupt_Enable(INT_I2C1, TRUE);     //ʹI2C1 ж
	I2C_ISIE_INT_Enable(I2C1_SFR, TRUE);      //ʹI2Cж
	I2C_Start_INT_Enable(I2C1_SFR, TRUE);     //ʹSTARTж
	I2C_Stop_INT_Enable(I2C1_SFR, TRUE);	  //ʹSTOPж
	INT_All_Enable(TRUE);                     //ж

}

