/****************************************************************************************
 * ļ: main.c
 * Ŀ: I2C_DMA
 *  :  V2.3
 *  :  20191116
 *     ChipON_AE/FAE_Group
 *     ļṩI2CDMAʹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
#include "I2C_DMA.h"
#include "Usart.h"

#define	MODE_Master	   1					 //ģʽ
#define	MODE_Slave	   0                    //ӻģʽ
#define	IIC_MODE	   MODE_Master	        //0ӻģʽ1ģʽ






#if	IIC_MODE==MODE_Master  //ģʽ

#if IIC_10BIT_Address
#define BUFFER_SIZE               66   //дݸ
#define I2C_SLAVE_ADDRESS10B     0XF6A0   //÷ƥI2C 10λַ
uint8_t i2c_buffer_write10B[BUFFER_SIZE] = {
		                            0XF6,0XA0,0X5A,0X22,0X33,0X44,0X66,0X77,0X88,0X99,0XAA,0XBB,
											  0X01,0X02,0X03,0X04,0X05,0X06,0X07,0X08,0X09,0X10,
											  0X11,0X12,0X13,0X14,0X15,0X16,0X17,0X18,0X19,0X20,
											  0X21,0X22,0X23,0X24,0X25,0X26,0X27,0X28,0X29,0X30,
											  0X31,0X32,0X33,0X34,0X35,0X36,0X37,0X38,0X39,0X40,
											  0X41,0X42,0X43,0X44,0X45,0X46,0X47,0X48,0X49,0X50,
											  0X51,0X52,0X53,0XA5};
#else
#define I2C_SLAVE_ADDRESS         0XA0   //÷͵I2C 7λַ
#define BUFFER_SIZE               65   //дݸ



//ģʽDMAҪдI2Cַ
uint8_t i2c_buffer_write[BUFFER_SIZE] = {
									     0XA0,0X5A,0X22,0X33,0X44,0X66,0X77,0X88,0X99,0XAA,0XBB,
											  0X01,0X02,0X03,0X04,0X05,0X06,0X07,0X08,0X09,0X10,
											  0X11,0X12,0X13,0X14,0X15,0X16,0X17,0X18,0X19,0X20,
											  0X21,0X22,0X23,0X24,0X25,0X26,0X27,0X28,0X29,0X30,
											  0X31,0X32,0X33,0X34,0X35,0X36,0X37,0X38,0X39,0X40,
											  0X41,0X42,0X43,0X44,0X45,0X46,0X47,0X48,0X49,0X50,
											  0X51,0X52,0X53,0XA5};

#endif

#else  //ӻģʽ

#define BUFFER_SIZE               65   //дݸ

#if IIC_10BIT_Address
#define I2C_SLAVE_ADDRESS10B     0X3A0   //ýƥI2C 10λַ
#else
#define I2C_SLAVE_ADDRESS         0XA0   //ýƥI2C 7λַ

#endif

volatile uint8_t i2c_buffer_read[BUFFER_SIZE];//ȡI2Cݺ洢
//ںͶI2C 7λַݵԱ
uint8_t i2c_buffer_read_test[BUFFER_SIZE] = {
		                                 0XA0,0X5A,0X22,0X33,0X44,0X66,0X77,0X88,0X99,0XAA,0XBB,
		                                      0X01,0X02,0X03,0X04,0X05,0X06,0X07,0X08,0X09,0X10,
		                                      0X11,0X12,0X13,0X14,0X15,0X16,0X17,0X18,0X19,0X20,
		                                      0X21,0X22,0X23,0X24,0X25,0X26,0X27,0X28,0X29,0X30,
		                                      0X31,0X32,0X33,0X34,0X35,0X36,0X37,0X38,0X39,0X40,
		                                      0X41,0X42,0X43,0X44,0X45,0X46,0X47,0X48,0X49,0X50,
		                                      0X51,0X52,0X53,0XA5};


/**
  *   ԱI2CǷƥ
  * 
  *    1ƥ
  *      0ݲƥ
  */
uint8_t I2C_Data_test(void)
{
	uint16_t i;

    for(i = 0;i < BUFFER_SIZE;i++)
    {
        if(i2c_buffer_read[i] != i2c_buffer_read_test[i])
        {
           return I2C_FAIL;
        }
    }
    return I2C_OK;


}

#endif

//ʱ ֲvolatileܻᱻŻ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	 //Ϊߵƽ

}




/**
  *   I2C DMA ʼá
  *  : 
  *
  *   ޡ
  */
void I2C_DMA_Init(void)
{
	DMA_Reset(DMA0_SFR);
	DMA_InitTypeDef I2C_DMAStruct;
	I2C_DMAStruct.m_Number = BUFFER_SIZE;/*  ݸ: BUFFER_SIZE */
#if	IIC_MODE==MODE_Slave  //ӻģʽ
	I2C_DMAStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;/*  DMA䷽ 赽ڴ*/
	I2C_DMAStruct.m_Channel = DMA_CHANNEL_7;/*  DMAͨѡ:ͨ7 */
#else
	I2C_DMAStruct.m_Direction = DMA_MEMORY_TO_PERIPHERAL;/*  DMA䷽ ڴ浽*/
	I2C_DMAStruct.m_Channel = DMA_CHANNEL_6;/*  DMAͨѡ:ͨ6 */
#endif
	I2C_DMAStruct.m_Priority = DMA_CHANNEL_LOWER;/*  DMAͨȼȼ */
	I2C_DMAStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;/*  λ8λ */
	I2C_DMAStruct.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;/*  洢λ:8λ */
	I2C_DMAStruct.m_PeripheralInc = FALSE;/*  ַģʽʹ: ʹ */
	I2C_DMAStruct.m_MemoryInc = TRUE;/*  洢ַģʽʹ: ʹ */

	I2C_DMAStruct.m_BlockMode = DMA_TRANSFER_BYTE; /*  ֽڴģʽ */
	I2C_DMAStruct.m_LoopMode = TRUE;/*  ѭģʽʹ: ʹ */
	I2C_DMAStruct.m_PeriphAddr = 0x40000D88;/*  I2C1 buffַȴջ͵ݵʼַ */

#if	IIC_MODE==MODE_Slave  //ӻģʽ
	I2C_DMAStruct.m_MemoryAddr = (uint32_t)&i2c_buffer_read;/*  ڴʼַݵڴռʼַ */
#else

#if IIC_10BIT_Address
	I2C_DMAStruct.m_MemoryAddr = (uint32_t)&i2c_buffer_write10B;/*  ڴʼַݵڴռʼַ */
#else
	I2C_DMAStruct.m_MemoryAddr = (uint32_t)&i2c_buffer_write;/*  ڴʼַݵڴռʼַ */
#endif

#endif

	DMA_Configuration(DMA0_SFR, &I2C_DMAStruct);

}



//
void main()
{

	/*ûɲοKF32A151_demoʵʹI2CʵDMAշܡ
	* ʹI2C1 PB1 PB2 ͨš 궨 IIC_MODE 10ѡģʽӻģʽ
	* I2C_DMA.hѡ궨IIC_10BIT_AddressǷʹ10ַģʽ7λַģʽ
	* ܼ:	1.I2C Master DMAܣÿ60msӻ64ֽݣDMA ɺD4˸D4Ƴ
	* 			2.I2C Slave DMA ܣ͹64ͨDMAݶԱƥPB13תD4˸D4Ƴ
	* Ӳ˵ ʹKF32A151demoԽӣPB1PB1ԽӣPB2PB2Խӣ
	*           PB13ӦD4
	*           ҪôڽUSART0_RX PA0 	USART0_TX0	PA1  Usart.h ں궨Usart_Print  1
	*ע 1DMA͵һһ͵ڶΪI2CΪӻַ
	*    210λַҪעӻַĸλǵڶλ͵λЧ
	*
    */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//ʼPB13Ϊߵƽ
	GPIO_Reset(GPIOB_SFR);
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);
	I2C_GPIO_init(); //I2C GPIOӳSCL:PB1   SDA:PB2



#if	IIC_MODE==MODE_Master  //ģʽ
	I2C_init_Master(I2C1_SFR);  //I2C1ʼ

#else
	I2C_DMA_Init();  //I2C1 DMA1ʼ
#if Usart_Print

	GPIO_USART();//USART0ӳ䣬	//USART0_RX		PA0  //USART0_TX0	PA1
	USART_Async_config(USART0_SFR);//ȫ˫첽8bit 9600
#endif


#if IIC_10BIT_Address
	I2C_init_Slave(I2C1_SFR,I2C_SLAVE_ADDRESS10B);//I2C1 ӻ10λַ0XF3A0
#else
	I2C_init_Slave(I2C1_SFR,I2C_SLAVE_ADDRESS);//I2C1ӻ7λַ0XA0
#endif

	I2C_Receive_DMA_INT_Enable(I2C1_SFR,TRUE);	//ʹI2C1ж
	DMA_Channel_Enable(DMA0_SFR,DMA_CHANNEL_7,TRUE); //ʹDMA0 I2C1ͨ
	///********************I2Cж*****************/
		INT_Interrupt_Enable(INT_I2C1, TRUE);
		I2C_ISIE_INT_Enable(I2C1_SFR, TRUE);       //ʹI2Cж
		INT_All_Enable(TRUE);

#endif


	while(1)
    {

#if	IIC_MODE==MODE_Master  //ģʽ
		delay_ms(1000);
		I2C_DMA_Init();  //I2C1 DMA1ʼ
		DMA_I2C_Enable(TRUE);
		GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_13);  // DMA ݺPB13ת
	    I2C_Transmit_DMA_INT_Enable(I2C1_SFR,FALSE);	//I2C0ж
		DMA_Channel_Enable(DMA0_SFR,DMA_CHANNEL_6,FALSE); //DMA0 ͨ6
		delay_ms(200);

#else  //ӻģʽ

		while (0 == DMA_Get_Finish_Transfer_INT_Flag(DMA0_SFR, DMA_CHANNEL_7))//ȴDMAд
		{
            ;
		}

		I2C_Receive_DMA_INT_Enable(I2C1_SFR,FALSE);	//ʹI2C1ж
		DMA_Channel_Enable(DMA1_SFR,DMA_CHANNEL_7,FALSE); //ʹDMA1 I2C1ͨ
		delay_ms(200);

#if Usart_Print

			delay_ms(200);
			delay_ms(200);
			delay_ms(200);
			//ڴӡյ
			USART_Send(USART0_SFR,i2c_buffer_read,sizeof(i2c_buffer_read));
#endif
		I2C_DMA_Init();
		I2C_Receive_DMA_INT_Enable(I2C1_SFR,TRUE);	//ʹI2C1ж
		DMA_Channel_Enable(DMA0_SFR,DMA_CHANNEL_7,TRUE); //ʹDMA0 I2C1ͨ

		if(I2C_OK == I2C_Data_test())//ж϶I2CƥPB13ת
		{
			GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_13);  //PB13ת
			delay_ms(200);
		}
#endif
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

