/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: GPIO_Output
 *  :  V2.3
 *  :  20191116
 *     ChipON_AE/FAE_Group
 *     ļṩGPIOӦ̲ο
 *
 ****************************************************************************************/
#include "system_init.h"


#define Demo_LEDON()         GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_13,Bit_SET)  //Ϊߵƽ
#define Demo_LEDOff()        GPIO_Set_Output_Data_Bits(GPIOB_SFR,GPIO_PIN_MASK_13,Bit_RESET)//Ϊ͵ƽ
#define Demo_LED_ON_OFF()    GPIO_Toggle_Output_Data_Config (GPIOB_SFR, GPIO_PIN_MASK_0)   //LEDƽȡ


void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=10000;
		while(j--);
	}

}



/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	 //Ϊߵƽ

}




//
void main()
{
	/*ûɲοKF32A151demoʵGPIOùܡ
	 * ʹGPIO  PB13ΪD4,PB13Ϊ
	 * D4Ƽ500ms ˸
	 */

    	//ϵͳʱ120M,Ƶʱ16M
		SystemInit();//ϵͳʱӳʼ
		GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);  //PB13ʼߵƽ

		while(1)
		{
			Demo_LEDON(); //D4Ƶ
			delay_ms(500);
			Demo_LEDOff();//D4Ϩ
			delay_ms(500);
		}
}






void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

