/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: EXIT
 *  :  V2.3
 *  :  20191116
 *   :  ChipON_AE/FAE_Group
 *     ļṩⲿжӦ̲ο
 *
 ****************************************************************************************/
#include "system_init.h"
/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);


	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	 //Ϊߵƽ

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Input_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{

	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;                      //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;                     //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;                   //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
}



/**
  *   ⲿж(EINT)жԴ(GPIPA~GPIOH)
  *  :  EintNum: ⲿжϱţ
  *              ȡֵΪINT_EXTERNAL_INTERRUPT_0INT_EXTERNAL_INTERRUPT_31еһ 0~15
  *
  * PeripheralSource: жߵжԴ INT_EXTERNAL_SOURCE_PA~INT_EXTERNAL_SOURCE_PF
  *   ޡ
  */
void EXIT_INTx_Config(uint32_t EintNum,uint32_t PeripheralSource)
{
	EINT_InitTypeDef EXIT_InitStructure;
	INT_External_Struct_Init(&EXIT_InitStructure);
	EXIT_InitStructure.m_Line = EintNum;                   //ⲿжϱ
	EXIT_InitStructure.m_Mask = TRUE;                      //ⲿжʹܿ
	EXIT_InitStructure.m_Rise = TRUE;                     //ⲿжжʹ
	EXIT_InitStructure.m_Fall = FALSE;                     //ⲿж½жʹ
	EXIT_InitStructure.m_Source = PeripheralSource;        //ⲿжϵжԴѡ
	INT_External_Configuration(&EXIT_InitStructure);       //жù
	INT_External_Source_Enable(EintNum,PeripheralSource);  //ʹⲿжԴ


    if(EintNum==INT_EXTERNAL_INTERRUPT_0)
    {
    	INT_Interrupt_Enable(INT_EINT0,TRUE);								//ʹжEINT0
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_1)
    {
    	INT_Interrupt_Enable(INT_EINT1,TRUE);								//ʹжEINT1
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_2)
    {
    	INT_Interrupt_Enable(INT_EINT2,TRUE);								//ʹжEINT2
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_3)
    {
    	INT_Interrupt_Enable(INT_EINT3,TRUE);								//ʹжEINT3
    }else if(EintNum==INT_EXTERNAL_INTERRUPT_4)
    {
    	INT_Interrupt_Enable(INT_EINT4,TRUE);								//ʹжEINT4
    }else if((EintNum>=INT_EXTERNAL_INTERRUPT_5)&&(EintNum<=INT_EXTERNAL_INTERRUPT_9))
    {
    	INT_Interrupt_Enable(INT_EINT9TO5,TRUE);							//ʹжEINT5~EINT9
    }else if((EintNum>=INT_EXTERNAL_INTERRUPT_10)&&(EintNum<=INT_EXTERNAL_INTERRUPT_15))
    {
    	INT_Interrupt_Enable(INT_EINT15TO10,TRUE);							//ʹжEINT10~EINT15
    }

	INT_All_Enable (TRUE);      //ʹж
}


//
void main()
{

	/*ûɲοKF32A151_demoʵⲿжEINTùܡ
	 * ʹⲿEINT7ʵ飬ͨжԴΪPD7 EINT7ʹPB13ת
	 * USER£D4ϨٴΰD4Ƶ
     *
     * *ע⣺úжźжԴѡҪжԴIOʼΪģʽԼжϺ
     * ETIN5~ETIN9   жڵַ жϱ־λ
     * ETIN10~ETIN15 жڵַ жϱ־λ
     * ETIN17~ETIN19 жڵַ жϱ־λ
     * ETIN20~ETIN21 жڵַ жϱ־λ
     * ETIN22~ETIN31 жڵַ жϱ־λ
     * жϺҪжĸжжϱ־
	 */
	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ʱӳʼ

	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);  //PB13ʼߵƽ
	GPIOInit_Input_Config(GPIOD_SFR,GPIO_PIN_MASK_7);    //PD7ʼΪ

	//ⲿжEINT7شж
	EXIT_INTx_Config(INT_EXTERNAL_INTERRUPT_7,INT_EXTERNAL_SOURCE_PD);  //ⲿжEINT7жԴPD7
    while(1)
    {
    }

}


void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

