/*************************************************************************************
* Ŀ:   KF8A100ENG TOUCH KEY
* ChipON IDE
* 汾2021-03-07
* Ӳ 
* ʹоƬKF8A100ENG
* ߣ TIM WANG
* ܼ:
*************************************************************************************/

#include "init_mcu.h"
#include "CTouch.h"
#include "PowerMan.h"
#include "Timer.h"

volatile unsigned int Key_Code = 0;
unsigned int  iic_checksum_buf;

volatile unsigned char iic_buf;
volatile unsigned char Rcv_Cnt;
volatile unsigned char I2C_Head;
volatile unsigned char Key_Error_Code = 0;
volatile unsigned char Low_Power_Flg = 0;
volatile unsigned int Raw_Data = 0;
volatile unsigned int  T1_count = 0;
unsigned int  		   iic_checksum_buf;
volatile unsigned int tmp;

/**************************************************************************/
#define 			   LP_USART_DEBUG 							 0
#define 			   SYSTEM_RUN						         0
#define 			   SYSTEM_STOP								 1
#define 			   SYS_SLEEP_DELAY_15S 						 300

/**************************************************************************/
void Sys_State_Get(void);
void Sys_Sleep_Mode(void);
void Sys_Run_Mode(void);

/**************************************************************************/
//;***********************************************************************************
//;*   :  INT_FUN() __interrupt
//;* : жϺ
//;* ڲ: 
//;*     :   
//;************************************************************************************
void int_fun0() __interrupt (0)
{
	/* Ĵ˴ T3 */
	if(T3IF)
	{
		T3IF = 0;
		Touch_Int_Flg = 1;
	}

	if(T1IE & T1IF)
	{
		T1IF = 0;
		if(T1_count <= SYS_SLEEP_DELAY_15S)
		{
			T1_count++;
		}
	}
}
void int_fun1() __interrupt (1)
{
	static unsigned char tmp1 = 0;
	static unsigned char tmp2 = 0;
	static unsigned char tmp3 = 0;
	static unsigned char key_value = 0;
#if 1

 	if(SSCIIF)
 	{
 		SSCIIF=0;
 		if(SSCIDA==0)//SSCIDA=0ʾյǵַ
 		{
 			//Key_Code = 1;
#if 1

 			if(Key_Code)
 			{
 				key_value = (Key_Code<<7)+(Key_Code>>1);
 				tmp1 = 0x80;
 				tmp2 = (unsigned char)(key_value);//Raw_Data >> 8;//;
 				tmp3 = 0;//Raw_Data;//Key_Code;
 				I2C_Head = tmp1;
 			}
#endif
 			else
 			{
 				tmp1 = 0x00;
 				tmp2 = 0x00;
 				tmp3 = 0x00;
 				I2C_Head = tmp1;
 			}

 			SSCIBUFR = I2C_Head;
 			iic_checksum_buf = I2C_Head;
 			Rcv_Cnt = 0;
 		}
 		else //յ
 		{
 			Rcv_Cnt ++;
 			iic_buf = SSCIBUFR;

 			if(Rcv_Cnt == 1)
 			{
 				iic_buf = tmp2;
 				iic_checksum_buf = iic_checksum_buf^tmp2;
 			}
 			else if(Rcv_Cnt == 2)
 			{
 				iic_buf = tmp3;
				iic_checksum_buf = iic_checksum_buf^tmp3;
 			}
 			else
 			{
 				iic_buf = (unsigned char)~iic_checksum_buf;
 			}
 			SSCICKP = 0;
 			SSCIBUFR = 0;
 			SSCIWCFL = 0;
 			SSCIBUF = 0;
 			SSCIOV = 0;
 			SSCIBUFR = iic_buf;
 		 }
 		SSCIWCFL = 0;
 		SSCIOV =0 ;
 		SSCICKP = 1;
 	}
#endif
}

void startup()
{
__asm
	MOVP	#0x1F
	MOVB	#0x00
	CALL	#0xfff
	MOV	0x30, R0
	NOPZ
	NOPZ
	CALL	#0xffe
	MOV	0x37, R0
	NOPZ
	NOPZ
	CALL	#0xffd
	MOV	0x4c, R0
	NOPZ
	NOPZ
	CALL	#0xffc
	MOV	0x4d, R0
	NOPZ
	NOPZ
	CALL	#0xffb
	MOV	0x2a, R0
	NOPZ
	MOVB	#0x01
	CALL	#0xffa
	MOV	0x59, R0
	NOPZ
	CALL	#0xff9
	MOV	0x5a, R0
	NOPZ
	CALL	#0xff8
	MOV	0x65, R0
	NOPZ
	NOPZ
	;CRET
__endasm;
	OSCCTL = 0x70;
}


/*****************************************
//͹
****************************************/
void Sys_State_Get(void)
{
	if((P20==0)&&(T1_count >= SYS_SLEEP_DELAY_15S)) // IICͨѶ15s͹ģʽ
	{
		Low_Power_Flg = SYSTEM_STOP;
	}
	else
	{
		Low_Power_Flg = SYSTEM_RUN;
	}
//	Low_Power_Flg = SYSTEM_RUN;
}
void Sys_Sleep_Mode(void)
{
	unsigned char tmp = 0;
	T1ON = 0;

	System_Goto_Sleep();
	if(!_CTouch_LowPower_Scan_Process_())
	{
		T1_count = 0;
		Low_Power_Flg = SYSTEM_RUN;
		Timer1_Init();
		P0LR2 = 1;
	}
}


void Sys_Run_Mode(void)
{
	Key_Error_Code = _CTouch_Scan_Process_();

	Key_Code = Channel_Press_str;

	Danger_Key_Set(Key_Code);

}
//;************************************************************************************
//;*   :  void main()
//;* : ں
//;* ڲ: 
//;*     :   
//;************************************************************************************
unsigned int test_data;
void main()
{
	Init_MCU();
	_CTouch_Key_Init_();
	Timer1_Init();
	WatchDog_Init();
	Low_Power_Flg = SYSTEM_RUN;
	while(1)
	{
		_CWDT();
	    Sys_State_Get();

		if(Low_Power_Flg == SYSTEM_RUN)
		{
			Sys_Run_Mode();
		}
		else
		{
			Sys_Sleep_Mode();
		}
	}
}
