/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a KF32A156 device StdPeriph Template		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
*                        		Include Files                                 *
******************************************************************************/
#include "system_init.h"
#include "Usart.h"
#include "Usart_Config.h"
static void Led_Gpio_Init(void);
static void Led_Flip(void);

/******************************************************************************
*                           Array Definition                                  *
******************************************************************************/
uint8_t  Usart_Send_Sdu[] = {"ChipON\r\n"};

/******************************************************************************
*                        	Initialization function                           *
******************************************************************************/
/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
static void Led_Gpio_Init(void)
{
	GPIO_Write_Mode_Bits(GPIOA_SFR, GPIO_PIN_MASK_4 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_12 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOF_SFR, GPIO_PIN_MASK_7 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOH_SFR, GPIO_PIN_MASK_3 , GPIO_MODE_OUT);
}

/**
 *  @brief :
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
static void Led_Flip(void)
{
	GPIO_Toggle_Output_Data_Config(GPIOA_SFR, GPIO_PIN_MASK_4);
	GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	GPIO_Toggle_Output_Data_Config(GPIOF_SFR, GPIO_PIN_MASK_7);
	GPIO_Toggle_Output_Data_Config(GPIOH_SFR, GPIO_PIN_MASK_3);
}

int main()
{
	/* Initialize the system clock */
	SystemInit(120);
	/* Setup SysTick Timer as delay function */
	systick_delay_init(120);
	/* Initialize led IOs */
	Led_Gpio_Init();
	/* Set Usart Tx And Rx PINS */
	Usart_Gpio_Init();
	/* Set Usart Working Mode  */
	USART_Mode_Config(USART1_SFR);
	/* Set Usart Tx And Rx PINS */
	Usart0_Gpio_Init();
	/* Set Usart Working Mode  */
	USART0_Mode_Config(USART0_SFR);
	USART_Int_Config(USART1_SFR,INT_USART1);
	INT_All_Enable(TRUE);
	while(1)
	{
		systick_delay_ms(250);
		systick_delay_ms(250);
		Led_Flip();
	}		
}
