/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_T18.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for T18.                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_T18.h"

/*******************************************************************************
**                      	public Variables Definitions                  	  **
*******************************************************************************/
volatile uint16_t time_10ms=0;
/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief : Initialize Timer 18 and configuration Timer 18.
 *  @param in :	CNT_T:Counting period
 				Prescaler
 *  @param out :None
 *  @retval :None
 */
void GENERAL_TIMER18_Config(uint16_t CNT_T,uint16_t Prescaler)
{
	/*reset peripherals of Timer 18 and enable peripherals clock source.*******/
	TIM_Reset(T18_SFR);
	/*Configure the T18 immediate update control bit to update immediately*****/
	GPTIM_Updata_Immediately_Config(T18_SFR,TRUE);
	/*Enable T18 update controller*********************************************/
	GPTIM_Updata_Enable(T18_SFR,TRUE);
	/*Set to timing mode as working mode of timer 18***************************/
	GPTIM_Work_Mode_Config(T18_SFR,GPTIM_TIMER_MODE);
	/*Updata counter***********************************************************/
	GPTIM_Set_Counter(T18_SFR,0);
	/*Set the counting period**************************************************/
	GPTIM_Set_Period(T18_SFR,CNT_T);
	/*Set prescaler************************************************************/
	GPTIM_Set_Prescaler(T18_SFR,Prescaler);
	/*Set up and down count****************************************************/
	GPTIM_Counter_Mode_Config(T18_SFR,GPTIM_COUNT_UP_DOWN_OUF);
	/*Select SCLK  as clock source of timer 18*********************************/
	GPTIM_Clock_Config(T18_SFR,GPTIM_SCLK);
	/*Set interrupt priority***************************************************/
	INT_Interrupt_Priority_Config(INT_T18,4,0);
	/*Enable timer 18 overflow interrupt***************************************/
	GPTIM_Overflow_INT_Enable(T18_SFR,TRUE);
	/*Enable INT_T18 interrupt*************************************************/
	INT_Interrupt_Enable(INT_T18,TRUE);
	/*Clear INT_T18 interrupt flag*********************************************/
	INT_Clear_Interrupt_Flag(INT_T18);
	/*Enable timer 18**********************************************************/
	GPTIM_Cmd(T18_SFR,TRUE);
	/*Enable all interrupt*****************************************************/
	INT_All_Enable (TRUE);

}
