/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_T6.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for T6.                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_T6.h"


/*******************************************************************************
**                      	public Variables Definitions                  	  **
*******************************************************************************/
volatile uint16_t time_10ms=0;
/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/

/**
 *  @brief : Initialize general Timer 6 and configuration Timer 6.
 *  @param in :	CNT_T:Counting period
 				Prescaler
 *  @param out :None
 *  @retval :None
 */
void ADVANCE_TIMER6_Config(uint16_t CNT_T,uint16_t Prescaler)
{
	/*reset peripherals of Timer 6 and enable peripherals clock source.********/
	TIM_Reset(T6_SFR);
	/*Configure the T6 immediate update control bit to update immediately******/
	ATIM_Z_Updata_Immediately_Config(T6_SFR,TRUE);
	/*Enable T6 update controller**********************************************/
	ATIM_Z_Updata_Enable(T6_SFR,TRUE);
	/*Set to timing mode as working mode of timer 6****************************/
	ATIM_Z_Work_Mode_Config(T6_SFR,ATIM_TIMER_MODE);
	/*Updata counter***********************************************************/
	ATIM_Z_Set_Counter(T6_SFR,0);
	/*Set the counting period**************************************************/
	ATIM_Z_Set_Period(T6_SFR,CNT_T);
	/*Set prescaler************************************************************/
	ATIM_Z_Set_Prescaler(T6_SFR,Prescaler);
	ATIM_Z_Postscaler_Config(T6_SFR,ATIM_POSTSCALER_DIV_1);
	/*Set to count up mode*****************************************************/
	ATIM_Z_Counter_Mode_Config(T6_SFR,ATIM_COUNT_UP_OF);
	/*Select HFCLK as clock source of timer 6**********************************/
	ATIM_Z_Clock_Config(T6_SFR,ATIM_HFCLK);
	/*Enable timer 6 overflow interrupt****************************************/
	ATIM_Z_Overflow_INT_Enable(T6_SFR,TRUE);
	/*Enable timer 6 **********************************************************/
	ATIM_Z_Cmd(T6_SFR,TRUE);
	/*Set interrupt priority***************************************************/
	INT_Interrupt_Priority_Config(INT_T6,4,0);
	/*Enable INT_T6 interrupt**************************************************/
	INT_Interrupt_Enable(INT_T6,TRUE);
	/*Clear INT_T6 interrupt flag**********************************************/
	INT_Clear_Interrupt_Flag(INT_T6);
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);
	/*Enable all interrupt*****************************************************/
	INT_All_Enable (TRUE);

}


