/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf_ic.c                                               *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : Main Interrupt Service Routines.                      *      
 *                      This file provides template for all exceptions        *
 *                      handler and peripherals interrupt service routine.    *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                          Include Files                                    **
******************************************************************************/
#include "system_init.h"
#include "SPI.h"
#include <stdio.h>
/*******************************************************************************
**                   KF32A156 Processor Exceptions Handlers  		         **
*******************************************************************************/
extern uint8_t Spi_DataLength;
uint8_t SpiEndIndex = 0;
//*****************************************************************************************
//                                 NMI Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _NMI_exception(void)
{
}

//*****************************************************************************************
//                               HardFault Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _HardFault_exception(void)
{
}

//*****************************************************************************************
//                               StackFault Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _StackFault_exception(void)
{
}

//*****************************************************************************************
//                               SVC Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SVC_exception(void)
{
}

//*****************************************************************************************
//                              SoftSV Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SoftSV_exception(void)
{
}

//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SysTick_exception(void)
{
}

//*****************************************************************************************
//                              SPI2 Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SPI2_exception(void)
{
	if(SpiEndIndex < SPI_TRANSMISSION_DATA_SIZE)
	{
		/* Wait send buffer to empty */
		if(SPI_Get_Transmit_Buf_Flag(SPI2_SFR)==RESET)
		{
			if(Spi_DataLength < SPI_TRANSMISSION_DATA_SIZE)
			{
				/* Send data */
				SPI_I2S_SendData8(SPI2_SFR,Rx_Slave[Spi_DataLength]);
				Spi_DataLength++;
				if(Spi_DataLength==SPI_TRANSMISSION_DATA_SIZE)
				{
					Spi_DataLength = 0;
				}
			}
		}
		/* Wait receive buffer not empty */
		if(SPI_Get_Receive_Buf_Flag(SPI2_SFR)==SET)
		{
			/* Receive data */
			Spi_ReceiveData[SpiEndIndex] = SPI_I2S_ReceiveData(SPI2_SFR);
			SpiEndIndex++;
			if(SpiEndIndex==SPI_TRANSMISSION_DATA_SIZE)
			{
				SpiEndIndex = 0;
				printf("%s\r\n",Spi_ReceiveData);
				/* LED1 flashing */
			    GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
			}
		}
	}
}
