/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf_ic.c                                               *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : Main Interrupt Service Routines.                      *      
 *                      This file provides template for all exceptions        *
 *                      handler and peripherals interrupt service routine.    *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                          Include Files                                    **
******************************************************************************/
#include "system_init.h"
#include <stdio.h>
#include "SPI.h"
/*******************************************************************************
**                   KF32A156 Processor Exceptions Handlers  		         **
*******************************************************************************/
extern void delay_ms(volatile uint32_t nms);
extern uint8_t Spi_Finish_Flag;
extern uint8_t Spi_Length;
uint8_t Spi_Change_Flag = 0;
//*****************************************************************************************
//                                 NMI Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _NMI_exception(void)
{
}

//*****************************************************************************************
//                               HardFault Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _HardFault_exception(void)
{
}

//*****************************************************************************************
//                               StackFault Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _StackFault_exception(void)
{
}

//*****************************************************************************************
//                               SVC Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SVC_exception(void)
{
}

//*****************************************************************************************
//                              SoftSV Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SoftSV_exception(void)
{
}

//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SysTick_exception(void)
{
}

//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _SPI2_exception(void)
{
}

//*****************************************************************************************
//                              DMA0 Interrupt Course
//*****************************************************************************************
void __attribute__((interrupt)) _DMA0_exception(void)
{
	/* Waiting for DMA to receive full  */
	if (DMA_Get_Finish_Transfer_INT_Flag(DMA0_SFR, DMA_CHANNEL_6))
	{
		/* Use the serial port to print out the received data */
		printf("%s\r\n", Spi_ReceiveData);
		/* Clear interrupt flag */
		DMA_Clear_INT_Flag(DMA0_SFR, DMA_CHANNEL_6, DMA_INT_FINISH_TRANSFER);
		/* LED1 flashing */
		GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	}
	/* Waiting for DMA to send complete */
	if (DMA_Get_Finish_Transfer_INT_Flag(DMA0_SFR, DMA_CHANNEL_5))
	{
		/* After the DMA finishes sending for the first time, set the number of data to be
		 * transferred and the starting memory address of the DMA channel to the actual size 
		 * and starting position of the string sent  */
		if (Spi_Change_Flag == 0)
		{
			/* Transmit data size */
			DMA_Transfer_Number_Config(DMA0_SFR, DMA_CHANNEL_5, SPI_TRANSMISSION_DATA_SIZE);
			/* Memory start address */
			DMA_Memory_Start_Address_Config(DMA0_SFR, DMA_CHANNEL_5, (uint32_t)&Tx_Slave);
			Spi_Change_Flag = 1;
		}
		/* Waiting for spi to send no data */
		while (SPI_Get_BUSY_Flag(SPI2_SFR) == SET)
			;
		/* Clear interrupt flag */
		DMA_Clear_INT_Flag(DMA0_SFR, DMA_CHANNEL_5, DMA_INT_FINISH_TRANSFER);
		/* Enable next transmit */
		DMA_Channel_Enable(DMA0_SFR, DMA_CHANNEL_5, TRUE);
	}
}
