/*****************************************************************************
*                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
******************************************************************************
*  @File Name        : SPI.c                                                 *
*  @Author           : ChipON AE/FAE Group                                   *
*  @Data$            : 2021-07-14                                            *
*  @Version          : V1.0                                                  *
*  @Description      : This file contains the spi configuration for KF32A156 *
*  devices                                                                   *
******************************************************************************
*  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
*  All rights reserved.                                                      *
*                                                                            *
*  This software is copyrght protected and proprietary to                    *
*  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
******************************************************************************
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*                          REVISON HISTORY                                   *
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  Data       Version  Author        Description                             *
*  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  2021-07-14 00.01.00  AE Group     new creat                               *
*                                                                            *
*                                                                            *
*****************************************************************************/

/******************************************************************************
**                             Include Files                                **
******************************************************************************/
#include "SPI.h"

/*****************************************************************************
**                         Private Macro Definitions                        **
*****************************************************************************/
/*****************************************************************************
**                         Private Variables Definitions                    **
*****************************************************************************/
uint8_t Tx_Master[SPI_TRANSMISSION_DATA_SIZE] = "KF32A156-KungFu32 SPI Example Master";
uint8_t Spi_ReceiveData[SPI_TRANSMISSION_DATA_SIZE];
/*****************************************************************************
**                             Private Functions                            **
*****************************************************************************/

/*****************************************************************************
**                             Global Functions                            **
*****************************************************************************/
/**
 *  @brief: Initialize the spi module
 *  @param in: SPIx
 *  @param out : None
 *  @retval : None
 */
void Spi_Init(SPI_SFRmap *SPIx)
{
    SPI_InitTypeDef Spi_ConfigPtr;

    /* SPI mode */
    Spi_ConfigPtr.m_Mode = SPI_MODE_MASTER_CLKDIV4;
    /* SPI clock */
    Spi_ConfigPtr.m_Clock = SPI_CLK_SCLK;
    /* Data transfer start control */
    Spi_ConfigPtr.m_FirstBit = SPI_FIRSTBIT_MSB;
    /* Spi idle state */
    Spi_ConfigPtr.m_CKP = SPI_CKP_LOW;
    /* Spi clock phase(Data shift edge) */
    Spi_ConfigPtr.m_CKE = SPI_CKE_1EDGE;
    /* Data width */
    Spi_ConfigPtr.m_DataSize = SPI_DATASIZE_8BITS;
    /* Baud rate :Fck_spi=Fck/2(m_BaudRate+1)*/
    Spi_ConfigPtr.m_BaudRate = 0x59;

    /* Spi reset */
    SPI_Reset(SPIx);
    /* Configure SPI module */
    SPI_Configuration(SPIx, &Spi_ConfigPtr);
}

/**
 *  @brief: Initialize the SPI IO
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void Spi_IO_Init()
{
    /* Configure SPI2 IO */
    /* 
     * SPI2_SCK = PD3
     * SPI2_SDI = PD2
     * SPI2_SDO = PG15
     * SPI2_SS0 = PG14
     */
    GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_2 | GPIO_PIN_MASK_3, GPIO_MODE_RMP);
    GPIO_Write_Mode_Bits(GPIOG_SFR, GPIO_PIN_MASK_14 | GPIO_PIN_MASK_15, GPIO_MODE_RMP);

    GPIO_Pin_RMP_Config(GPIOD_SFR, GPIO_Pin_Num_2, GPIO_RMP_AF4);
    GPIO_Pin_RMP_Config(GPIOD_SFR, GPIO_Pin_Num_3, GPIO_RMP_AF4);
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_15, GPIO_RMP_AF4);
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_14, GPIO_RMP_AF4);
}

/**
 *  @brief: Initialize DMA channel
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void Spi_DMA_Init(SPI_SFRmap *SPIx)
{
    DMA_InitTypeDef Dma_ConfigPtr;
    DMA_Reset(DMA0_SFR);
    /* Receive channel */
    /* Transmit data size */
    Dma_ConfigPtr.m_Number = SPI_TRANSMISSION_DATA_SIZE;
    /* DMA transmit direction */
    Dma_ConfigPtr.m_Direction = DMA_PERIPHERAL_TO_MEMORY;
    /* DMA channel priority */
    Dma_ConfigPtr.m_Priority = DMA_CHANNEL_TOP;
    /* Peripheral data width */
    Dma_ConfigPtr.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;
    /* Memory data width */
    Dma_ConfigPtr.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;
    /* Peripheral address incremental mode enable */
    Dma_ConfigPtr.m_PeripheralInc = FALSE;
    /* Memory address incremental mode enable */
    Dma_ConfigPtr.m_MemoryInc = TRUE;
    /* DMA channel select */
    Dma_ConfigPtr.m_Channel = DMA_CHANNEL_6;
    /* DMA data block transfer mode */
    Dma_ConfigPtr.m_BlockMode = DMA_TRANSFER_BYTE;
    /* Cycle mode enable */
    Dma_ConfigPtr.m_LoopMode = TRUE;
    /* Peripheral start address */
    Dma_ConfigPtr.m_PeriphAddr = (uint32_t) & (SPIx->BUFR);
    /* Memory start address */
    Dma_ConfigPtr.m_MemoryAddr = (uint32_t)&Spi_ReceiveData;

    /* Configure DMA0 */
    DMA_Configuration(DMA0_SFR, &Dma_ConfigPtr);

    /* Receive DMA */
    SPI_Receive_DMA_INT_Enable(SPIx, TRUE);
    /* DMA channel enable */
    DMA_Channel_Enable(DMA0_SFR, DMA_CHANNEL_6, TRUE);
    /* DMA receive finish interrupt */
    DMA_Finish_Transfer_INT_Enable(DMA0_SFR, DMA_CHANNEL_6, TRUE);

    /* Send channal */
    /* Transmit data size */
    Dma_ConfigPtr.m_Number = SPI_TRANSMISSION_DATA_SIZE - 1;
    /* DMA transmit direction */
    Dma_ConfigPtr.m_Direction = DMA_MEMORY_TO_PERIPHERAL;
    /* DMA channel select */
    Dma_ConfigPtr.m_Channel = DMA_CHANNEL_5;
    /* Cycle mode enable */
    Dma_ConfigPtr.m_LoopMode = FALSE;
    /* Peripheral start address */
    Dma_ConfigPtr.m_PeriphAddr = (uint32_t) & (SPIx->BUFR);
    /* Memory start address */
    Dma_ConfigPtr.m_MemoryAddr = (uint32_t)&Tx_Master + 1;

    /* Configure DMA1 */
    DMA_Configuration(DMA0_SFR, &Dma_ConfigPtr);

    /* Send DMA */
    SPI_Transmit_DMA_INT_Enable(SPIx, TRUE);
    /* DMA channel enable */
    DMA_Channel_Enable(DMA0_SFR, DMA_CHANNEL_5, TRUE);
    /* DMA finsh interrupt enable */
    DMA_Finish_Transfer_INT_Enable(DMA0_SFR, DMA_CHANNEL_5, TRUE);

    /* Enable SPI module */
    SPI_Cmd(SPIx, TRUE);
}
