/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : user_RTC.c        	                                  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides provides template for 			  *
 *                      user RTC 			                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "system_init.h"
#include "User_RTC.h"
#include "Usart.h"

/**
 *  @brief :Configure RTC data,and configure RTC moduel.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */

void Init_RTC_Data(void)
{
	RTC_InitTypeDef RTC_INIT;
	/*reset RTC**************************************************************/
	RTC_Reset();

	/* Set the INTLF to the RTC clock source ********************************/
	RTC_INIT.m_ClockSource = RTC_WORK_CLK_INTLF;
	/* Set RTC time format:24-hour clock ************************************/
	RTC_INIT.m_HourFormat = RTC_HOUR_FORMAT_24;
	/* Set RTC hours Initial value:20 ***************************************/
	RTC_INIT.m_TimeStruct.m_Hours = 20;
	/* Set RTC minutes Initial value:0 **************************************/
	RTC_INIT.m_TimeStruct.m_Minutes = 0;
	/* Set RTC seconds Initial value:0 **************************************/
	RTC_INIT.m_TimeStruct.m_Seconds = 0;
	/* set AM/PM.but 24-hour format don't need set AM/PM.********************/
	//	RTC_INIT.m_TimeStruct.m_AMPM = RTC_TIME_AM; 
	/* Set RTC week Initial value:WEDNESDAY *********************************/
	RTC_INIT.m_DateStruct.m_WeekDay = RTC_WEEKDAY_WEDNESDAY_DEC;
	/* Set RTC year Initial value :19****************************************/
	RTC_INIT.m_DateStruct.m_Year = 19;
	/* Set RTC month Initial value: OCTOBER**********************************/
	RTC_INIT.m_DateStruct.m_Month = RTC_MONTH_OCTOBER_DEC;
	/* Set RTC date Initial value :30****************************************/
	RTC_INIT.m_DateStruct.m_Day = 30;
	/*Declare that the input parameters are not in BCD encoding format, and 
	write the time and date into the register********************************/
	RTC_Configuration(RTC_TIME_FORMAT_BIN,&RTC_INIT);
}

/**
 *  @brief :Output rtc data through serial port.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */

void Print_time_to_uart()
{
	char USART_Array_Tansmit[20]={'2','0'};
	char * p;
	RTC_InitTypeDef buf;
	/*	get rtc data and time	*/
	RTC_Get_Time_Configuration(RTC_TIME_FORMAT_BCD, &buf.m_TimeStruct);
	RTC_Get_Date_Configuration(RTC_TIME_FORMAT_BCD, &buf.m_DateStruct);
	/*	Convert the time and date into a string and write it into the sending
	buffer	******************************************************************/
	USART_Array_Tansmit[2] = (buf.m_DateStruct.m_Year>>4) + '0'; 
	USART_Array_Tansmit[3] = (buf.m_DateStruct.m_Year&0x0F) + '0';
	USART_Array_Tansmit[4] = '-';
	USART_Array_Tansmit[5] = (buf.m_DateStruct.m_Month>>4) + '0';
	USART_Array_Tansmit[6] = (buf.m_DateStruct.m_Month&0x0F) + '0';
	USART_Array_Tansmit[7] = '-';
	USART_Array_Tansmit[8] = (buf.m_DateStruct.m_Day>>4) + '0'; 
	USART_Array_Tansmit[9] = (buf.m_DateStruct.m_Day&0x0F) + '0';
	USART_Array_Tansmit[10] = ' ';
	USART_Array_Tansmit[11] = (buf.m_TimeStruct.m_Hours>>4) + '0'; 
	USART_Array_Tansmit[12] = (buf.m_TimeStruct.m_Hours&0x0F) + '0';
	USART_Array_Tansmit[13] = ':';
	USART_Array_Tansmit[14] = (buf.m_TimeStruct.m_Minutes>>4) + '0'; 
	USART_Array_Tansmit[15] = (buf.m_TimeStruct.m_Minutes&0x0F) + '0';
	USART_Array_Tansmit[16] = ':';
	USART_Array_Tansmit[17] = (buf.m_TimeStruct.m_Seconds>>4) + '0';
	USART_Array_Tansmit[18] = (buf.m_TimeStruct.m_Seconds&0x0F) + '0';
	USART_Array_Tansmit[19] = ' ';
	USART_Send(USART0_SFR, USART_Array_Tansmit, sizeof(USART_Array_Tansmit));

	switch(buf.m_DateStruct.m_WeekDay)
	{
		case 1:
			p = "Mon";
		break;
		case 2:
			p = "Tue";
		break;
		case 3:
			p = "Wed";
		break;
		case 4:
			p = "Thu";
		break;
		case 5:
			p = "Fri";
		break;
		case 6:
			p = "Sat";
		break;
		case 7:
			p = "Sun";
		break;
		default:
			p = "error";
		break;
	}
	USART_Send(USART0_SFR, p, 3);
	p ="\n";
	USART_Send(USART0_SFR, p, 1);
}


/**
 *  @brief :Set RTC alarm.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Set_rtc_Alarm()
{
	RTC_AlarmTypeDef RTC_AlarmA;
	/*enter RTC configuration mode *****************************************/
	RTC_Config_Mode_Enable (TRUE);
	/*Set RTC alarm clock ring time*****************************************/
	RTC_AlarmA.m_WeekDay=RTC_WEEKDAY_MONDAY_DEC;
	RTC_AlarmA.m_Hours=17;
	RTC_AlarmA.m_Minutes=48;
	RTC_AlarmA.m_Seconds=10;
	RTC_AlarmA.m_AMPM=RTC_TIME_AM;
	RTC_AlarmA.m_WeekDayEnable=FALSE;
	RTC_AlarmA.m_HoursEnable=TRUE;
	RTC_AlarmA.m_MinutesEnable=TRUE;
	RTC_AlarmA.m_SecondsEnable=TRUE;
	RTC_Alarm_Configuration (RTC_ALARM_A_ADDR_OFFSET,RTC_TIME_FORMAT_BIN,&RTC_AlarmA);

	/*enable alarm A*/
	RTC_Alarm_A_Enable(TRUE);
	/*enable alarm A IRQ*/
	RTC_Alarm_A_INT_Enable (TRUE);
	/*quit RTC configuration mode *******************************************/
	RTC_Config_Mode_Enable (FALSE);
}

/**
 *  @brief :The interrupt source of RTC cannot directly trigger the core 
 			interrupt. The RTC interrupt must use the external interrupt 
 			Eint17-19 as the signal transmission channel to trigger the 
 			core interrupt. Therefore, the use of RTC interrupts must also 
 			be configured with Eint17-19 interrupts..
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Config_RTC_interrupt(void)
{
	EINT_InitTypeDef EINT_17to19;
	/*enter RTC configuration mode *****************************************/
	RTC_Config_Mode_Enable (TRUE);

	/*enable EINT_17to19 interrupt******************************************/
	EINT_17to19.m_Mask=TRUE;
	/*enable Rising edge trigger********************************************/
	EINT_17to19.m_Rise=TRUE;
	/*External interrupt line selection, only one interrupt source can be
	written in a configuration**********************************************/
	EINT_17to19.m_Line=INT_EXTERNAL_INTERRUPT_17;
	/*disable fall edge trigger*********************************************/
	EINT_17to19.m_Fall=FALSE; 
	INT_External_Configuration (&EINT_17to19);

	/*Configure the RTC clock correction value. If the calibration function
	is not used, a value of 0 must be written.*******************************/
	RTC_Clock_Calibration_Config((int8_t)0x0);
	/*set rtc tick :1s*******************************************************/
	RTC_Time_Tick_Config(RTC_TIME_TICK_DIV_1);
	/*enable rtc tick IRQ****************************************************/
	RTC_Time_Tick_INT_Enable (TRUE);
	/*enable rtc seconds interrupt*******************************************/
	RTC_Seconds_INT_Enable(TRUE);
	/*enable rtc*************************************************************/
	RTC_Enable(TRUE);
	/*quit RTC configuration mode *******************************************/
	RTC_Config_Mode_Enable (FALSE);
	/*enable INT_EINT19TO17 *************************************************/
	INT_Interrupt_Enable(INT_EINT19TO17,TRUE);
	/*enable all interrupt **************************************************/
	INT_All_Enable (TRUE);
}
