/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a sample demonstration of LIN master mode	  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "lin_master.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/
/* Led control toggle output */
#define BoardLed1Toggle()		(GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12))
/* LIN slave ID address */
#define LINSlaveID1				(0x34)
#define LINSlaveID2				(0x36)

/*******************************************************************************
**                      	Private Variables Definitions                  	  **
*******************************************************************************/
/* Transmit date buffer */
uint8_t LINTxBuffer1[] = {1, 2, 3, 4, 5, 6, 7, 8};
uint8_t LINTxBuffer2[] = {8, 7, 6, 5, 4, 3, 2, 1};

/*******************************************************************************
**                     		   Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief :Initialize the LED GPIO ports
 * 			PD7	------------- UserKey
 * 			PD12 ------------ LED1
 * 			PH3 ------------- LED2
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void BoardGpioInit(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	
	/* Configure PD12 LED1 output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_12;
	GPIO_Configuration(GPIOD_SFR , &GPIO_InitStructure);
	/* Configure PH3 LED2 output */
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_3;
	GPIO_Configuration(GPIOH_SFR , &GPIO_InitStructure);
	/* Configure PA4 LED3 output */
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_4;
	GPIO_Configuration(GPIOA_SFR , &GPIO_InitStructure);
	/* Configure PD7 user key input */
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_7;
	GPIO_Configuration(GPIOD_SFR , &GPIO_InitStructure);
}

/**
 *  @brief :Initialize the LIN GPIO ports
 * 			PA7	------------- LIN_TX_PIN
 * 			PA8 ------------- LIN_RX_PIN
 *  @param in :None
 *  @param out :None
 *  @retval :None
 */
void LINGpioIinit(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;

	/* Configure PA7/PA8 remap mode */
	GPIO_InitStructure.m_Mode = GPIO_MODE_RMP;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_7|GPIO_PIN_MASK_8;
	GPIO_Configuration(GPIOA_SFR , &GPIO_InitStructure);
	/* If there is no external pull-up resistor, pull-up is required */
	/* GPIO_Pull_Up_Enable(GPIOA_SFR, GPIO_PIN_MASK_8, TRUE); */
	/* Configure PA3 remap function to AF13 */
	GPIO_Pin_RMP_Config(GPIOA_SFR, GPIO_Pin_Num_7, GPIO_RMP_AF13);
	/* Configure PA8 remap function to AF13 */
	GPIO_Pin_RMP_Config(GPIOA_SFR, GPIO_Pin_Num_8, GPIO_RMP_AF13);
}

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* Initialize the system clock is 120M */
	SystemInit(120);
	/* Setup SysTick Timer as delay function, and input frequency is 120M */
	systick_delay_init(120);
	/* Initialize the LED IOs */
	BoardGpioInit();
	/* Initialize the LIN IOs */
	LINGpioIinit();
	/* LIN2.0 configured as follow:
		- BaudRate = 9600 baud
		- Word Length = 8 Bits
		- parity bits included
		- Receive and transmit enabled
	 */
	USART_LIN_config(USART5_SFR);
	/* Enable and set INT_USART5 Interrupt to the lowest priority */
	INT_Interrupt_Enable(INT_USART5, TRUE);
	INT_Interrupt_Priority_Config(INT_USART5, 7, 1);	
	/* Configure interrupt priority group, default is 3VS1 */
	INT_Priority_Group_Config(INT_PRIORITY_GROUP_3VS1);
	/* Enable the global interrupt */
	INT_All_Enable(TRUE);
	while(1)
	{
		/* Send the data to LIN node1 from the buffer1 */
		LIN_Send(USART5_SFR, LINSlaveID1, LINTxBuffer1, 8);
		systick_delay_ms(50);
		/* Send the data to LIN node2 from the buffer2 */
		LIN_Send(USART5_SFR, LINSlaveID2, LINTxBuffer2, 8);
		systick_delay_ms(50);
		/* ON/OFF the LED1 to indicates that the system is running */
		BoardLed1Toggle();
	}		
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t LINe)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
