/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : system_init.h                                         *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file contains the Header file configuration 	  *
 * 						for KF32A156 device                                   *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyright protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/
#ifndef _SYSTEM_INIT_H_
#define _SYSTEM_INIT_H_

/******************************************************************************
**                       	Include Files                                    **
******************************************************************************/
#include <string.h>
#include <stdint.h>
#include "KF32A156.h"
#include "KF32A156Config.h"
#include "kf32a156_adc.h"
#include "kf32a156_aes.h"
#include "kf32a156_atim.h"
#include "kf32a156_bkp.h"
#include "kf32a156_btim.h"
#include "kf32a156_can.h"
#include "kf32a156_canfd.h"
#include "kf32a156_cfgl.h"
#include "kf32a156_cmp.h"
#include "kf32a156_crc.h"
#include "kf32a156_dac.h"
#include "kf32a156_dma.h"
#include "kf32a156_ecfgl.h"
#include "kf32a156_epwm.h"
#include "kf32a156_ewdt.h"
#include "kf32a156_exic.h"
#include "kf32a156_fdc.h"
#include "kf32a156_flash.h"
#include "kf32a156_flexmux.h"
#include "kf32a156_gpio.h"
#include "kf32a156_gtim.h"
#include "kf32a156_hrcap.h"
#include "kf32a156_i2c.h"
#include "kf32a156_int.h"
#include "kf32a156_iwdt.h"
#include "kf32a156_op.h"
#include "kf32a156_osc.h"
#include "kf32a156_pclk.h"
#include "kf32a156_pm.h"
#include "kf32a156_qei.h"
#include "kf32a156_rng.h"
#include "kf32a156_rst.h"
#include "kf32a156_rtc.h"
#include "kf32a156_spi.h"
#include "kf32a156_sysctl.h"
#include "kf32a156_systick.h"
#include "kf32a156_usart.h"
#include "kf32a156_wwdt.h"

/*******************************************************************************
**                      Global Macro Definitions                              **
*******************************************************************************/
/* PLL clock source used by the INTHF in 16000000Hz defult
 * If an external clock source is used, then the value of the following define,
 * should be set to the value of the external clock source, else, if no external 
 * clock is used, keep this define commented.Value of the external clock in Hz.
 */
/* #define SYSCLK_FREQ_HSE  16000000 */
#if !defined (SYSCLK_FREQ_HSE)
	#define	SYSCLK_FREQ_HSI  		16000000
#endif

/* Configure the System clock source */
#if defined (KF32A156MQV) 
#define SYSCLK_FREQ_120MHz  120000000
#endif

#if (SYSCLK_FREQ_HSE == 16000000) || (defined SYSCLK_FREQ_HSI)
static const uint8_t PLL_Value_Select[][3] = {
		{25,2,8},{13,1,8},{27,2,8},{14,1,8},{29,2,8},{15,1,8},{31,2,8},{16,1,8},{33,2,8},
		{17,1,8},{35,2,8},{18,1,8},{37,2,8},{19,1,8},{39,2,8},{20,1,8},{41,2,8},{21,1,8},
		{43,2,8},{22,1,8},{45,2,8},{23,1,8},{47,2,8},{24,1,8},{49,2,8},{25,1,8},{51,4,4},
		{13,1,4},{53,4,4},{27,2,4},{55,4,4},{14,1,4},{57,4,4},{29,2,4},{59,4,4},{15,1,4},
		{61,4,4},{31,2,4},{63,4,4},{16,1,4},{65,4,4},{33,2,4},{67,4,4},{17,1,4},{69,4,4},
		{35,2,4},{71,4,4},{18,1,4},{73,4,4},{37,2,4},{75,4,4},{19,1,4},{77,4,4},{39,2,4},
		{79,4,4},{20,1,4},{81,4,4},{41,2,4},{83,4,4},{21,1,4},{85,4,4},{43,2,4},{87,4,4},
		{22,1,4},{89,4,4},{45,2,4},{91,4,4},{23,1,4},{93,4,4},{47,2,4},{95,4,4},{24,1,4},
		{97,4,4},{49,2,4},{99,4,4},{25,1,4},{101,8,2},{51,4,2},{103,8,2},{13,1,2},{105,8,2},
		{53,4,2},{107,8,2},{27,2,2},{109,8,2},{55,4,2},{111,8,2},{14,1,2},{113,8,2},{57,4,2},
		{115,8,2},{29,2,2},{117,8,2},{59,4,2},{119,8,2},{15,1,2}
};
#elif (SYSCLK_FREQ_HSE == 8000000)
static const uint8_t PLL_Value_Select[][3] = {
		{25,1,8},{26,1,8},{27,1,8},{28,1,8},{29,1,8},{30,1,8},{31,1,8},{32,1,8},{33,1,8},
		{34,1,8},{35,1,8},{36,1,8},{37,1,8},{38,1,8},{39,1,8},{40,1,8},{41,1,8},{42,1,8},
		{43,1,8},{44,1,8},{45,1,8},{46,1,8},{47,1,8},{48,1,8},{49,1,8},{25,1,4},{51,2,4},
		{26,1,4},{53,2,4},{27,1,4},{55,2,4},{28,1,4},{57,2,4},{29,1,4},{59,2,4},{30,1,4},
		{61,2,4},{31,1,4},{63,2,4},{32,1,4},{65,2,4},{33,1,4},{67,2,4},{34,1,4},{69,2,4},
		{35,1,4},{71,2,4},{36,1,4},{73,2,4},{37,1,4},{75,2,4},{38,1,4},{77,2,4},{39,1,4},
		{79,2,4},{40,1,4},{81,2,4},{41,1,4},{83,2,4},{42,1,4},{85,2,4},{43,1,4},{87,2,4},
		{44,1,4},{89,2,4},{45,1,4},{91,2,4},{46,1,4},{93,2,4},{47,1,4},{95,2,4},{48,1,4},
		{97,2,4},{49,1,4},{99,2,4},{25,1,2},{101,4,2},{51,2,2},{103,4,2},{26,1,2},{105,4,2},
		{53,2,2},{107,4,2},{27,1,2},{109,4,2},{55,2,2},{111,4,2},{28,1,2},{113,4,2},{57,2,2},
		{115,4,2},{29,1,2},{117,4,2},{59,2,2},{119,4,2},{30,1,2}
};
#elif (SYSCLK_FREQ_HSE == 12000000)
static const uint8_t PLL_Value_Select[][3] = {
		{50,3,8},{52,3,8},{18,1,8},{56,3,8},{58,3,8},{20,1,8},{62,3,8},{64,3,8},{22,1,8},
		{68,3,8},{70,3,8},{24,1,8},{74,3,8},{76,3,8},{26,1,8},{80,3,8},{82,3,8},{28,1,8},
		{86,3,8},{88,3,8},{30,1,8},{92,3,8},{94,3,8},{32,1,8},{98,3,8},{50,3,4},{17,1,4},
		{52,3,4},{53,3,4},{18,1,4},{55,3,4},{56,3,4},{19,1,4},{58,3,4},{59,3,4},{20,1,4},
		{61,3,4},{62,3,4},{21,1,4},{64,3,4},{65,3,4},{22,1,4},{67,3,4},{68,3,4},{23,1,4},
		{70,3,4},{71,3,4},{24,1,4},{73,3,4},{74,3,4},{25,1,4},{76,3,4},{77,3,4},{26,1,4},
		{79,3,4},{80,3,4},{27,1,4},{82,3,4},{83,3,4},{28,1,4},{85,3,4},{86,3,4},{29,1,4},
		{88,3,4},{89,3,4},{30,1,4},{91,3,4},{92,3,4},{31,1,4},{94,3,4},{95,3,4},{32,1,4},
		{97,3,4},{98,3,4},{33,1,4},{50,3,2},{101,6,2},{17,1,2},{103,6,2},{52,3,2},{35,2,2},
		{53,3,2},{107,6,2},{18,1,2},{109,6,2},{55,3,2},{37,2,2},{56,3,2},{113,6,2},{19,1,2},
		{115,6,2},{58,3,2},{39,2,2},{59,3,2},{119,6,2},{20,1,2},
};
#elif (SYSCLK_FREQ_HSE == 24000000)
static const uint8_t PLL_Value_Select[][3] = {
		{25,3,8},{26,3,8},{9,1,8},{28,3,8},{29,3,8},{10,1,8},{31,3,8},{32,3,8},{11,1,8},
		{34,3,8},{35,3,8},{12,1,8},{37,3,8},{38,3,8},{13,1,8},{40,3,8},{41,3,8},{14,1,8},
		{43,3,8},{44,3,8},{15,1,8},{46,3,8},{47,3,8},{16,1,8},{49,3,8},{25,3,4},{17,2,4},
		{26,3,4},{53,6,4},{9,1,4},{55,6,4},{28,3,4},{19,2,4},{29,3,4},{59,6,4},{10,1,4},
		{61,6,4},{31,3,4},{21,2,4},{32,3,4},{65,6,4},{11,1,4},{67,6,4},{34,3,4},{23,2,4},
		{35,3,4},{71,6,4},{12,1,4},{73,6,4},{37,3,4},{25,2,4},{38,3,4},{77,6,4},{13,1,4},
		{79,6,4},{40,3,4},{27,2,4},{41,3,4},{83,6,4},{14,1,4},{85,6,4},{43,3,4},{29,2,4},
		{44,3,4},{89,6,4},{15,1,4},{91,6,4},{46,3,4},{31,2,4},{47,3,4},{95,6,4},{16,1,4},
		{97,6,4},{49,3,4},{33,2,4},{25,3,2},{101,12,2},{17,2,2},{103,12,2},{26,3,2},{35,4,2},
		{53,6,2},{107,12,2},{9,1,2},{109,12,2},{55,6,2},{37,4,2},{28,3,2},{113,12,2},{19,2,2},
		{115,12,2},{29,3,2},{39,4,2},{59,6,2},{119,12,2},{10,1,2},
};
#else
	#error("User must calculate the PLL according to the external crystal oscillator in system_init.c");
#endif

/******************************************************************************
*                      Functional defineition                                 *
******************************************************************************/
void SystemInit(uint8_t SCLK_Value);
void systick_delay_init(uint32_t SystemCoreClock);
void systick_delay_us(unsigned int nus);
void systick_delay_ms(unsigned int nms);
uint32_t SystemCoreClockUpdate(void);
#endif /* _SYSTEM_INIT_H_ */
