/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_wwdt.c                              	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides functions related to the window    *
 *                   	watchdog (WWDT) , including:                          *
 *          			+ Window watchdog (WWDT) control function             *
 *          			+ Window Watchdog (WWDT) interrupt management function*
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_wwdt.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/**
  *   ##### ڿŹ(WWDT)ƹܺ #####
  */
/**
  *   λWWDTģ飬ʹʱӡ
  *   ޡ
  *   ޡ
  */
void
WWDT_Reset (void)
{
    /* λWWDTģ */
    RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_WWDTRST, TRUE);
    RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_WWDTRST, FALSE);

    /* ʹWWDTʱ */
    PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_WWDTCLKEN, TRUE);
}

/**
  *   ôڿŹɲֵ
  *   Threshold: ڿŹɲֵȡֵΪ0~0x3F
  *   ޡ
  */
void
WWDT_Threshold_Config (uint32_t Threshold)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_WWDT_THRESHOLD(Threshold));

    /*---------------- WWDT_CTLĴWWλ ----------------*/
    tmpreg = Threshold << WWDT_CTL_WW0_POS;
    WWDT_CTL = SFR_Config (WWDT_CTL, ~WWDT_CTL_WW, tmpreg);
}

/**
  *   ôڿŹԤƵԿŹʱӽзƵ
  *   Prescaler: ڿŹԿŹʱӵԤƵֵȡֵΪ
  *                    WWDT_PRESCALER_1: Ƶ
  *                    WWDT_PRESCALER_2: 2Ƶ
  *                    WWDT_PRESCALER_4: 4Ƶ
  *                    WWDT_PRESCALER_8: 8Ƶ
  *                    WWDT_PRESCALER_16: 16Ƶ
  *                    WWDT_PRESCALER_32: 32Ƶ
  *                    WWDT_PRESCALER_64: 64Ƶ
  *                    WWDT_PRESCALER_128: 128Ƶ
  *                    WWDT_PRESCALER_256: 256Ƶ
  *                    WWDT_PRESCALER_512: 512Ƶ
  *                    WWDT_PRESCALER_1024: 1024Ƶ
  *                    WWDT_PRESCALER_2048: 2048Ƶ
  *                    WWDT_PRESCALER_4096: 4096Ƶ
  *                    WWDT_PRESCALER_8192: 8192Ƶ
  *                    WWDT_PRESCALER_16384: 16384Ƶ
  *                    WWDT_PRESCALER_32768: 32768Ƶ
  *                    WWDT_PRESCALER_65536: 65536Ƶ
  *                    WWDT_PRESCALER_131072: 131072Ƶ
  *                    WWDT_PRESCALER_262144: 262144Ƶ
  *   ޡ
  */
void
WWDT_Prescaler_Config (uint32_t Prescaler)
{
    /* У */
    CHECK_RESTRICTION(CHECK_WWDT_PRESCALER(Prescaler));

    /*---------------- WWDT_CTLĴWPSλ ----------------*/
    WWDT_CTL = SFR_Config (WWDT_CTL, ~WWDT_CTL_WPS, Prescaler);
}

/**
  *   ôڿŹʱԴ
  *   ClkSource: ڿŹʱԴȡֵΪ
					WWDT_SCK_INTLF
					WWDT_SCK_SCLK
					WWDT_SCK_LFCLK
					WWDT_SCK_LP4M
  *   ޡ
  */
void
WWDT_Work_CLK_Selest(uint32_t Source)
{
	/* У */
	CHECK_RESTRICTION(CHECK_WWDT_SCK_SOURCE(Source));

	WWDT_CTL1 = SFR_Config(WWDT_CTL1, ~WWDT_CTL1_CLKS, Source);
}

/**
  *   ôڿŹʹܡ
  *   NewState: ڿŹʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
WWDT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- WWDT_CTLĴWWDTENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܴڿŹʱ */
        SFR_SET_BIT_ASM(WWDT_CTL, WWDT_CTL_WWDTEN_POS);
    }
    else
    {
        /* δʹܴڿŹ */
        SFR_CLR_BIT_ASM(WWDT_CTL, WWDT_CTL_WWDTEN_POS);
    }
}

/**
  *   ôڿŹֵ
  *   Counter: ڿŹֵȡֵΪ7λЧֵ
  *   ޡ
  */
void
WWDT_Counter_Config (uint32_t Counter)
{
    /* У */
    CHECK_RESTRICTION(CHECK_WWDT_THRESHOLD(Counter));

    /*---------------- WWDT_CNTĴWTλ ----------------*/
    WWDT_CNT = Counter;
}

/**
  *   ȡڿŹֵ
  *   ޡ
  *   ڿŹֵ7λЧֵ
  */
uint32_t
WWDT_Get_Counter (void)
{
    uint32_t tmpreg = 0;

    /*---------------- ȡWWDT_CNTĴWTλ ----------------*/
    tmpreg = WWDT_CNT & WWDT_CNT_WT;
    tmpreg >>= WWDT_CNT_WT_POS;

    return tmpreg;
}
/**
  *   ##### ڿŹ(WWDT)ƹܺ #####
  */


/**
  *   ##### ڿŹ(WWDT)жϹ #####
  */
/**
  *   ôڿŹжʹܡ
  *   NewState: ڿŹжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
WWDT_INT_Enable (FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- WWDT_CTLĴWWDTIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹܴڿŹж */
        SFR_SET_BIT_ASM(WWDT_CTL, WWDT_CTL_WWDTIE_POS);
    }
    else
    {
        /* ֹڿŹж */
        SFR_CLR_BIT_ASM(WWDT_CTL, WWDT_CTL_WWDTIE_POS);
    }
}

/**
  *   ȡڿŹжϱ־
  *   ޡ
  *   1:˴ڿŹжϣ0:δڿŹжϡ
  */
FlagStatus
WWDT_Get_INT_Flag (void)
{
    /*---------------- ȡWWDT_CTLĴWWDTIFλ ----------------*/
    if (WWDT_CTL & WWDT_CTL_WWDTIF)
    {
        /* ˴ڿŹж */
        return SET;
    }
    else
    {
        /* δڿŹж */
        return RESET;
    }
}

/**
  *   㴰ڿŹжϱ־
  *   ޡ
  *   ޡ
  */
void
WWDT_Clear_INT_Flag (void)
{
    /*---------------- WWDT_CTLĴWWDTICλ ----------------*/
    SFR_SET_BIT_ASM(WWDT_CTL, WWDT_CTL_WWDTIC_POS);
    while(WWDT_CTL & WWDT_CTL_WWDTIF);
    SFR_CLR_BIT_ASM(WWDT_CTL, WWDT_CTL_WWDTIC_POS);
}
/**
  *   ##### ڿŹ(WWDT)жϹ #####
  */

