/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_rst.c                                 	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the Reset module (RST) peripheral  *
 *                    	function, including:                                  *
 *          			+ Reset module(RST) function configuration function	  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/


#include "kf32a156_rst.h"


/**
  *	##### λģ(RST)ú #####
  **/

/**
  *   RST_CTL0Ƶ踴λ״̬
  *   RST_CTL0_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL0_GPIOARST: GPIOAλ
  *                       RST_CTL0_GPIOBRST: GPIOBλ
  *                       RST_CTL0_GPIOCRST: GPIOCλ
  *                       RST_CTL0_GPIODRST: GPIODλ
  *                       RST_CTL0_GPIOERST: GPIOEλ
  *                       RST_CTL0_GPIOFRST: GPIOFλ
  *                       RST_CTL0_GPIOGRST: GPIOGλ
  *                       RST_CTL0_GPIOHRST: GPIOHλ
  *                       RST_CTL0_GPIOIRST: GPIOIλ
  * NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  **/
void
RST_CTL0_Peripheral_Reset_Enable (uint32_t RST_CTL0_bit,
					FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_RST_CTL0_RESET_PERIPH(RST_CTL0_bit));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	if(NewState != FALSE)
	{
		RST_CTL0 |= RST_CTL0_bit;
	}
	else
	{
		RST_CTL0 &= ~RST_CTL0_bit;
	}
}

/**
  *   RST_CTL1Ƶ踴λ״̬
  *   RST_CTL1_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL1_QEI1RSTQEI1λ
  *                       RST_CTL1_T1RSTT1λ
  *                       RST_CTL1_T2RSTT2λ
  *                       RST_CTL1_T3RSTT3λ
  *                       RST_CTL1_T4RSTT4λ
  *                       RST_CTL1_T5T6RSTT5T6λ
  *                       RST_CTL1_QEI0RSTQEI0λ
  *                       RST_CTL1_ADC0RSTADC0λ
  *                       RST_CTL1_ADC1RSTADC1λ
  *                       RST_CTL1_ADC2RSTADC2λ
  *                       RST_CTL1_DAC0RSTDAC0λ
  *                       RST_CTL1_DAC1RSTDAC1λ
  *                       RST_CTL1_CMPRSTCMPλ
  *                       RST_CTL1_T0RSTT0λ
  *                       RST_CTL1_USART0RSTUSART0λ
  *                       RST_CTL1_USART1RSTUSART1λ
  *                       RST_CTL1_USART2RSTUSART2λ
  *                       RST_CTL1_USART4RSTUSART4λ
  *                       RST_CTL1_SPI0RSTSPI0λ
  *                       RST_CTL1_SPI1RSTSPI1λ
  *                       RST_CTL1_I2C0RSTI2C0λ
  *                       RST_CTL1_I2C1RSTI2C1λ
  *                       RST_CTL1_I2C2RSTI2C2λ
  * NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  **/
void
RST_CTL1_Peripheral_Reset_Enable (uint32_t RST_CTL1_bit,
					FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_RST_CTL1_RESET_PERIPH(RST_CTL1_bit));
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	if(NewState != FALSE)
	{
		RST_CTL1 |= RST_CTL1_bit;
	}
	else
	{
		RST_CTL1 &= ~RST_CTL1_bit;
	}
}

/**
  *   RST_CTL2Ƶ踴λ״̬
  *   RST_CTL2_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL2_I2C4RSTI2C4λ
  *                       RST_CTL2_I2C5RSTI2C5λ
  *                       RST_CTL2_WWDTRSTWWDTλ
  *                       RST_CTL2_EPWM11TRSTEPWM11λ
  *                       RST_CTL2_EPWM12TRSTEPWM12λ
  *                       RST_CTL2_EPWM13TRSTEPWM13λ
  *                       RST_CTL2_EPWM16TRSTEPWM16λ
  *                       RST_CTL2_DMA0RSTDMA0λ
  *                       RST_CTL2_DMA1RSTDMA1λ
  *                       RST_CTL2_T14RSTT14λ
  *                       RST_CTL2_T18RSTT18λ
  *                       RST_CTL2_T19RSTT19λ
  *                       RST_CTL2_T21RSTT21λ
  *                       RST_CTL2_DAC2RSTDAC2λ
  *                       RST_CTL2_DAC3RSTDAC3λ
  *                       RST_CTL2_USART5RSTUSART5λ
  *                       RST_CTL2_USART7RSTUSART7λ
  * NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
RST_CTL2_Peripheral_Reset_Enable (uint32_t RST_CTL2_bit,
					FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RST_CTL2_RESET_PERIPH(RST_CTL2_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        RST_CTL2 |= RST_CTL2_bit;
    }
    else
    {
        RST_CTL2 &= ~RST_CTL2_bit;
    }
}

/**
  *   RST_CTL3Ƶ踴λ״̬
  *   RST_CTL3_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL3_SPI2RSTSPI2λ
  *                       RST_CTL3_SPI3RSTSPI3λ
  *                       RST_CTL3_I2C3RSTI2C3λ
  *                       RST_CTL3_HRCAP0RSTHRCAP0λ
  *                       RST_CTL3_HRCAP1RSTHRCAP1λ
  *                       RST_CTL3_HRCAP2RSTHRCAP2λ
  *                       RST_CTL3_CRCRSTCRCλ
  *                       RST_CTL3_AESRSTAESλ
  *                       RST_CTL3_EXICRSTEXICλ
  *                       RST_CTL3_CAN4RSTCAN4λ
  *                       RST_CTL3_CFGLRSTCFGLλ
  *                       RST_CTL3_OPRSTOPλ
  *                       RST_CTL3_TRGMUXRSTTRGMUXλ
  *                       RST_CTL3_PDB0RSTPDB0λ
  *                       RST_CTL3_PDB1RSTPDB1λ
  *                       RST_CTL3_PDB2RSTPDB2λ
  *                       RST_CTL3_FLEXRPRSTFLEXRPλ
  *                       RST_CTL3_PLARSTPLAλ
  *                       RST_CTL3_EWDTRSTEWDTλ
  *                       RST_CTL3_RNGRSTRNGλ
  *                       RST_CTL3_CAN6RST CAN6λ
  *                       RST_CTL3_CAN7RSTCAN7λ
  *                       RST_CTL3_RTCRSTRTCλ
  * NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
RST_CTL3_Peripheral_Reset_Enable (uint32_t RST_CTL3_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RST_CTL3_RESET_PERIPH(RST_CTL3_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        RST_CTL3 |= RST_CTL3_bit;
    }
    else
    {
        RST_CTL3 &= ~RST_CTL3_bit;
    }
}

/**
  *	##### λģ(RST)ú #####
  */
