/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_btim.c                                	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides timer peripherals function,		  *
 *  					including:											  *
 *          			+ Definition of timer peripheral reset function       *
 *          			+ Basic Timer (BTIM) initialization and configuration *
 *          			  function definition								  *
 *          			+ Basic Timer (BTIM) interrupt and flag management 	  *
 *          			  function definition								  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "kf32a156_btim.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"


/*******************************************************************************
**                         Timer private definition                           **
*******************************************************************************/

/* BTIMx_CTL1Ĵ */
#define BTIM_CTL1_INIT_MASK  (BTIM_CTL1_TXCLK | \
                              BTIM_CTL1_TXCMS | \
                              BTIM_CTL1_TXSY | \
                              BTIM_CTL1_TXCS)

/* BTIMx_CTL2Ĵ */
#define BTIM_CTL2_INIT_MASK  (BTIM_CTL2_TXMMS | \
                              BTIM_CTL2_TXSMS | \
                              BTIM_CTL2_TXMSSYNC)


/**
  *   ##### ʱ踴λ #####
  */
/**
  *   ʱ踴λʹʱӡ
  *   TIMx: ʱڴṹָ룬ȡֵΪ T0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/
  *           T5_SFR/T6_SFR/T14_SFR/T18_SFR/T19_SFR/T21_SFR
  *   
  */
void TIM_Reset (void* TIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_TIM_ALL_PERIPH((uint32_t)TIMx));

    if ((uint32_t)TIMx == T0_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T0RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T0RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T0CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T1_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T1RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T1RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T1CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T2_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T2RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T2RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T2CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T3_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T3RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T3RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T3CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T4_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T4RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T4RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T4CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T5_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T5T6RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T5T6RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T5T6CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T6_ADDR)
    {
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T5T6RST, TRUE);
        RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_T5T6RST, FALSE);
        PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_T5T6CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T14_ADDR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T14RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T14RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_T14CLKEN, TRUE);
    }

    else if ((uint32_t)TIMx == T18_ADDR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T18RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T18RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_T18CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T19_ADDR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T19RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T19RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_T19CLKEN, TRUE);
    }
    else if ((uint32_t)TIMx == T21_ADDR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T21RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T21RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_T21CLKEN, TRUE);
    }
    else
    {
        ;
    }
}
/**
  *   ʱ踴λʹʱӡ
  *   TIMx: ʱڴṹָ룬ȡֵΪ T14_SFR
  *   
  */
void BTIM_Reset (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    if (BTIMx == T14_SFR)
    {
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T14RST, TRUE);
        RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_T14RST, FALSE);
        PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_T14CLKEN, TRUE);
    }
    else
    {
        ;
    }
}

/**
  *   ##### ʱ踴λ #####
  */

/**
  *   ##### ʱ(BTIM)ʼú #####
  */

/**
  *   ʱ(BTIM)á
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       btimInitStruct: ʱϢṹָ롣
  *   
  */

/**
  *   ʱ(BTIM)á
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       btimInitStruct: ʱϢṹָ롣
  *   
  */
void
BTIM_Configuration (BTIM_SFRmap* BTIMx,
                    BTIM_InitTypeDef* btimInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_COUNTER_MODE(btimInitStruct->m_CounterMode));
    CHECK_RESTRICTION(CHECK_BTIM_CLOCK_CONFIG(btimInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_BTIM_WORK_MODE(btimInitStruct->m_WorkMode));
    CHECK_RESTRICTION(CHECK_BTIM_MASTER_MODE(btimInitStruct->m_MasterMode));
    CHECK_RESTRICTION(CHECK_BTIM_SLAVE_MODE(btimInitStruct->m_SlaveMode));
    CHECK_RESTRICTION(CHECK_BTIM_SYNC_MODE(btimInitStruct->m_EXPulseSync));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(btimInitStruct->m_MasterSlaveSync));

    /*-------------------- TxCNTĴ --------------------*/
    BTIMx->CNT = (uint32_t)btimInitStruct->m_Counter;

    /*-------------------- PPxڼĴ --------------------*/
    BTIMx->PPX = (uint32_t)btimInitStruct->m_Period;

    /*-------------------- TxԤƵĴ --------------------*/
    BTIMx->PRSC = (uint32_t)btimInitStruct->m_Prescaler;

    /*-------------------- TXCTL1Ĵ --------------------*/
    /* ݽṹԱm_CounterModeTXCMSλ */
    /* ݽṹԱm_ClockTXCLKλ */
    /* ݽṹԱm_WorkModeTXCSλ */
    /* ݽṹԱm_EXPulseSyncTXSYλ */
    tmpreg = ((uint32_t)btimInitStruct->m_CounterMode) | \
             ((uint32_t)btimInitStruct->m_Clock) | \
             ((uint32_t)btimInitStruct->m_WorkMode) | \
             ((uint32_t)btimInitStruct->m_EXPulseSync);
    BTIMx->CTL1 = SFR_Config (BTIMx->CTL1,
                          ~BTIM_CTL1_INIT_MASK,
                          tmpreg);

    /*-------------------- TXCTL2Ĵ --------------------*/
    /* ݽṹԱm_MasterModeTXMMSλ */
    /* ݽṹԱm_SlaveModeTXSMSλ */
    /* ݽṹԱm_MasterSlaveSyncTXMSSYNCλ */
    tmpreg = ((uint32_t)btimInitStruct->m_MasterMode) | \
             ((uint32_t)btimInitStruct->m_SlaveMode) | \
             ((uint32_t)btimInitStruct->m_MasterSlaveSync << BTIM_CTL2_TXMSSYNC_POS);
    BTIMx->CTL2 = SFR_Config (BTIMx->CTL2,
                          ~BTIM_CTL2_INIT_MASK,
                          tmpreg);
}

/**
  *   ʼʱϢṹ塣
  *   btimInitStruct: ָʼĽṹָ롣
  *   
  */
void
BTIM_Struct_Init (BTIM_InitTypeDef* btimInitStruct)
{
    /* Txֵ */
    btimInitStruct->m_Counter = 0x0000;
    /* Txֵ */
    btimInitStruct->m_Period = 0xFFFF;
    /* TxԤƵֵ */
    btimInitStruct->m_Prescaler = 0x0000;
    /* Txģʽ */
    btimInitStruct->m_CounterMode = BTIM_COUNT_UP_OF;
    /* Txʱ */
    btimInitStruct->m_Clock = BTIM_SCLK;
    /* öʱ/ģʽѡ */
    btimInitStruct->m_WorkMode = BTIM_TIMER_MODE;
    /* ģʽѡ */
    btimInitStruct->m_MasterMode = BTIM_MASTER_TXUR_SIGNAL;
    /* ôģʽѡ */
    btimInitStruct->m_SlaveMode = BTIM_SLAVE_FORBIDDEN_MODE;
    /* Txģʽⲿͬ */
    btimInitStruct->m_EXPulseSync = BTIM_EX_SYNC_MODE;
    /* ģʽͬ */
    btimInitStruct->m_MasterSlaveSync = FALSE;
}


/**
  *   ʱʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ʱʹܿƣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Cmd (BTIM_SFRmap* BTIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL1ĴTXENλ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(BTIMx->CTL1, BTIM_CTL1_TXEN_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(BTIMx->CTL1, BTIM_CTL1_TXEN_POS);
    }
}

/**
  *   ¶ʱֵ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       Counter: µļֵȡֵ16λݡ
  *   
  */
void
BTIM_Set_Counter (BTIM_SFRmap* BTIMx, uint16_t Counter)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /* ¶ʱֵ */
    BTIMx->CNT = Counter;
}

/**
  *   ¶ʱֵ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       Period: µֵȡֵ16λݡ
  *   
  */
void
BTIM_Set_Period (BTIM_SFRmap* BTIMx, uint16_t Period)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /* ¶ʱֵ */
    BTIMx->PPX = Period;
}

/**
  *   ¶ʱԤƵֵ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       Prescaler: µԤƵȡֵ16λݡ
  *   
  */
void
BTIM_Set_Prescaler (BTIM_SFRmap* BTIMx, uint16_t Prescaler)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /* ¶ʱֵ */
    BTIMx->PRSC = Prescaler;
}

/**
  *   ¶ʱģʽ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       CounterMode: µļģʽ
  *                    ȡֵΧΪ
  *                      BTIM_COUNT_DOWN_UF: ¼,жϱ־
  *                      BTIM_COUNT_UP_OF: ϼ,жϱ־
  *                      BTIM_COUNT_UP_DOWN_OF: -¼,жϱ־
  *                      BTIM_COUNT_UP_DOWN_UF: -¼,жϱ־
  *                      BTIM_COUNT_UP_DOWN_OUF: -¼,жϱ־
  *   
  */
void
BTIM_Counter_Mode_Config (BTIM_SFRmap* BTIMx, uint32_t CounterMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_COUNTER_MODE(CounterMode));

    /*-------------------- TXCTL1ĴTXCMSλ --------------------*/
    BTIMx->CTL1 = SFR_Config (BTIMx->CTL1,
                          ~BTIM_CTL1_TXCMS,
                          CounterMode);
}

/**
  *   ¶ʱʱӡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewClock: µĹʱӣ
  *                 ȡֵΧΪ
  *                   BTIM_SCLK: ѡSCLKʱ
  *                   BTIM_HFCLK: ѡHFCLKʱ
  *                   BTIM_LFCLK: ѡLFCLKʱ
  *   
  */
void
BTIM_Clock_Config (BTIM_SFRmap* BTIMx, uint32_t NewClock)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_CLOCK_CONFIG(NewClock));

    /*-------------------- TXCTL1ĴTXCLKλ --------------------*/
    BTIMx->CTL1 = SFR_Config (BTIMx->CTL1,
                          ~BTIM_CTL1_TXCLK,
                          NewClock);
}

/**
  *   ¶ʱģʽⲿͬλ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewClock: µĶʱģʽⲿͬλʹ״̬
  *                 ȡֵΧΪ
  *                   BTIM_EX_SYNC_MODE: ⲿͬ
  *                   BTIM_NO_SYNC_MODE: ⲿͬ
  *   
  */
void
BTIM_External_Pulse_Sync_Config (BTIM_SFRmap* BTIMx, uint32_t PulseSync)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_SYNC_MODE(PulseSync));

    /*-------------------- TXCTL1ĴTXSYλ --------------------*/
    if (PulseSync != BTIM_EX_SYNC_MODE)
    {
        /* ⲿͬ */
        SFR_SET_BIT_ASM(BTIMx->CTL1, BTIM_CTL1_TXSY_POS);
    }
    else
    {
        /* ⲿͬ */
        SFR_CLR_BIT_ASM(BTIMx->CTL1, BTIM_CTL1_TXSY_POS);
    }
}

/**
  *   ¶ʱ/ģʽѡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: µĶʱ/ģʽ
  *                 ȡֵΧΪ
  *                   BTIM_TIMER_MODE: ʱģʽ
  *                   BTIM_COUNTER_MODE: ģʽ
  *   
  */
void
BTIM_Work_Mode_Config (BTIM_SFRmap* BTIMx, uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_WORK_MODE(NewState));

    /*-------------------- TXCTL1ĴTXCSλ --------------------*/
    if (NewState != BTIM_TIMER_MODE)
    {
        /* ģʽ */
        SFR_SET_BIT_ASM(BTIMx->CTL1, BTIM_CTL1_TXCS_POS);
    }
    else
    {
        /* ʱģʽ */
        SFR_CLR_BIT_ASM(BTIMx->CTL1, BTIM_CTL1_TXCS_POS);
    }
}

/**
  *   ²¼λ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ʱʹܿ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Generate_Trigger_Config (BTIM_SFRmap* BTIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴTXTRGλ --------------------*/
    if (NewState != FALSE)
    {
        /* Ӧ */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXTRG_POS);
    }
    else
    {
        /* ޶ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXTRG_POS);
    }
}

/**
  *   õģʽ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ģʽʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Single_Pulse_Enable (BTIM_SFRmap* BTIMx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴPXSPMλ --------------------*/
    if (NewState != FALSE)
    {
        /* ģʽʹ */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_PXSPM_POS);
    }
    else
    {
        /* ģʽδʹ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_PXSPM_POS);
    }
}

/**
  *   õģʽ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ģʽѡ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Single_Pulse_Shut_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴPXSPMSTλ --------------------*/
    if (NewState != FALSE)
    {
        /* رնʱʹλ */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_PXSPMST_POS);
    }
    else
    {
        /* 󲻹رնʱʹλ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_PXSPMST_POS);
    }
}

/**
  *   ¿λ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Updata_Immediately_Config (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴTXURλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹ */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXUR_POS);
    }
    else
    {
        /* δʹ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXUR_POS);
    }
}

/**
  *   ģʽͬλ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ģʽͬλ״̬
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Master_Slave_Snyc_Config (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴTXMSSYNCλ --------------------*/
    if (NewState != FALSE)
    {
        /* ʹ */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXMSSYNC_POS);
    }
    else
    {
        /* δʹ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXMSSYNC_POS);
    }
}

/**
  *   ôѡλ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       TriggerSelect: ѡ
  *                      ȡֵΧΪ
  *                         BTIM_TRIGGER_T1
  *                         BTIM_TRIGGER_T2
  *                         BTIM_TRIGGER_T3
  *                         BTIM_TRIGGER_T4
  *                         BTIM_TRIGGER_T5
  *                         BTIM_TRIGGER_T9
  *                         BTIM_TRIGGER_T14
  *                         BTIM_TRIGGER_T15
  *                         BTIM_TRIGGER_T18
  *                         BTIM_TRIGGER_T19
  *                         BTIM_TRIGGER_T20
  *                         BTIM_TRIGGER_T21
  *                         BTIM_TRIGGER_TXCK
  *   
  */
void
BTIM_Trigger_Select_Config (BTIM_SFRmap* BTIMx,
                    uint32_t TriggerSelect)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_TRIGGER_MODE(TriggerSelect));

    /*-------------------- TXCTL2ĴTXTSλ --------------------*/
    BTIMx->CTL2 = SFR_Config (BTIMx->CTL2,
                          ~BTIM_CTL2_TXTS,
                          TriggerSelect);
}

/**
  *   ôģʽѡλ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       SlaveSelect: ģʽѡ
  *                    ȡֵΧΪ
  *                      BTIM_SLAVE_FORBIDDEN_MODE: ģʽֹ
  *                      BTIM_SLAVE_TRIGGER_MODE: ģʽ
  *                      BTIM_SLAVE_GATED_MODE: ſģʽ
  *                      BTIM_SLAVE_RESET_MODE: λģʽ
  *                      BTIM_SLAVE_COUNTER_MODE: ģʽ2
  *   
  */
void
BTIM_Slave_Mode_Config (BTIM_SFRmap* BTIMx,
                    uint32_t SlaveMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_SLAVE_MODE(SlaveMode));

    /*-------------------- TXCTL2ĴTXSMSλ --------------------*/
    BTIMx->CTL2 = SFR_Config (BTIMx->CTL2,
                          ~BTIM_CTL2_TXSMS,
                          SlaveMode);
}

/**
  *   ģʽѡλ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       MasterMode: ģʽѡ
  *                   ȡֵΧΪ
  *                     BTIM_MASTER_TXUR_SIGNAL: URλΪ
  *                     BTIM_MASTER_TXEN_SIGNAL: TXENΪ
  *                     BTIM_MASTER_TXIF_SIGNAL: TXIFΪ
  *   
  */
void
BTIM_Master_Mode_Config (BTIM_SFRmap* BTIMx,
                    uint32_t MasterMode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_BTIM_MASTER_MODE(MasterMode));

    /*-------------------- TXCTL2ĴTXMMSλ --------------------*/
    BTIMx->CTL2 = SFR_Config (BTIMx->CTL2,
                          ~BTIM_CTL2_TXMMS,
                          MasterMode);
}

/**
  *   ظ¼λ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ¼״̬
  *                 ȡֵΧΪ
  *                   TRUE: 
  *                   FALSE: ÿڸ
  *   
  */
void
BTIM_Updata_Rising_Edge_Config (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴTXMSSYNCλ --------------------*/
    if (NewState != FALSE)
    {
        /*  */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXUDEVT_POS);
    }
    else
    {
        /* ÿڸ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXUDEVT_POS);
    }
}

/**
  *   øʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ʹ״̬
  *                 ȡֵΧΪ
  *                   TRUE: 
  *                   FALSE: ֹ
  *   
  */
void
BTIM_Updata_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXCTL2ĴTXUDENλ --------------------*/
    if (NewState != FALSE)
    {
        /*  */
        SFR_SET_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXUDEN_POS);
    }
    else
    {
        /* ÿڸ */
        SFR_CLR_BIT_ASM(BTIMx->CTL2, BTIM_CTL2_TXUDEN_POS);
    }
}

/**
  *   TX
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   TX0£1ϡ
  */
DIRStatus
BTIM_Get_Direction (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- ȡTXCTL1ĴTXDIRλ --------------------*/
    if (BTIMx->CTL1 & BTIM_CTL1_TXDIR)
    {
        /* ǰΪϼ */
        return DIR_UP;
    }
    else
    {
        /* ǰΪ¼ */
        return DIR_DOWN;
    }
}

/**
  *   ʱֵ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   Txֵ16λ
  */
uint16_t
BTIM_Get_Counter (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /* ʱֵ */
    return BTIMx->CNT;
}

/**
  *   ʱֵ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   Txֵ16λ
  */
uint16_t
BTIM_Get_Period (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /* ʱֵ */
    return BTIMx->PPX;
}

/**
  *   ʱԤƵֵ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   TxԤƵֵ16λ
  */
uint16_t
BTIM_Get_Prescaler (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /* ʱֵ */
    return BTIMx->PRSC;
}

/**
  *   ##### ʱ(BTIM)ʼú #####
  */


/**
  *   ##### ʱ(BTIM)жϼ־ #####
  */
/**
  *   ô¼DMAʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ¼DMA
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Trigger_DMA_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXDIERĴTXTDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼DMA */
        SFR_SET_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXTDE_POS);
    }
    else
    {
        /* ֹ¼DMA */
        SFR_CLR_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXTDE_POS);
    }
}

/**
  *   ø¼DMAʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: ¼DMA
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Updata_DMA_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXDIERĴTXUDEλ --------------------*/
    if (NewState != FALSE)
    {
        /* ¼DMA */
        SFR_SET_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXUDE_POS);
    }
    else
    {
        /* ֹ¼DMA */
        SFR_CLR_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXUDE_POS);
    }
}

/**
  *   Txжʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: Txжϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Overflow_INT_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXDIERĴTXIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Txж */
        SFR_SET_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXIE_POS);
    }
    else
    {
        /* ֹTxж */
        SFR_CLR_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXIE_POS);
    }
}

/**
  *   Tx¼жʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: Tx¼жϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Trigger_INT_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXDIERĴTXTIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Tx¼ж */
        SFR_SET_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXTIE_POS);
    }
    else
    {
        /* ֹTx¼ж */
        SFR_CLR_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXTIE_POS);
    }
}

/**
  *   Tx¼жʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *       NewState: Tx¼жϣ
  *                 ȡֵΧΪTRUE  FALSE
  *   
  */
void
BTIM_Updata_INT_Enable (BTIM_SFRmap* BTIMx,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*-------------------- TXDIERĴTXUIEλ --------------------*/
    if (NewState != FALSE)
    {
        /* Tx¼ж */
        SFR_SET_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXUIE_POS);
    }
    else
    {
        /* ֹTx¼ж */
        SFR_CLR_BIT_ASM(BTIMx->DIER, BTIM_DIER_TXUIE_POS);
    }
}

/**
  *   ô¼DMAʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   жʹ״̬0δʹܣ1ʹ
  */
INTStatus
BTIM_Get_Trigger_DMA_INT_Status (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXDIERĴTXTDEλ --------------------*/
    if (BTIMx->DIER & BTIM_DIER_TXTDE)
    {
        /* ǰΪϼ */
        return SET;
    }
    else
    {
        /* ǰΪ¼ */
        return RESET;
    }
}

/**
  *   ø¼DMAʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   жʹ״̬0δʹܣ1ʹ
  */
INTStatus
BTIM_Get_Updata_DMA_INT_Status (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXDIERĴTXUDEλ --------------------*/
    if (BTIMx->DIER & BTIM_DIER_TXUDE)
    {
        /* ǰΪϼ */
        return SET;
    }
    else
    {
        /* ǰΪ¼ */
        return RESET;
    }
}

/**
  *   Txжʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   жʹ״̬0δʹܣ1ʹ
  */
INTStatus
BTIM_Get_Overflow_INT_Status (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXDIERĴTXIEλ --------------------*/
    if (BTIMx->DIER & BTIM_DIER_TXIE)
    {
        /* ǰΪϼ */
        return SET;
    }
    else
    {
        /* ǰΪ¼ */
        return RESET;
    }
}

/**
  *   Tx¼жʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   жʹ״̬0δʹܣ1ʹ
  */
INTStatus
BTIM_Get_Trigger_INT_Status (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXDIERĴTXTIEλ --------------------*/
    if (BTIMx->DIER & BTIM_DIER_TXTIE)
    {
        /* ǰΪϼ */
        return SET;
    }
    else
    {
        /* ǰΪ¼ */
        return RESET;
    }
}

/**
  *   Tx¼жʹܡ
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   жʹ״̬0δʹܣ1ʹ
  */
INTStatus
BTIM_Get_Updata_INT_Status (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXDIERĴTXUIEλ --------------------*/
    if (BTIMx->DIER & BTIM_DIER_TXUIE)
    {
        /* ǰΪϼ */
        return SET;
    }
    else
    {
        /* ǰΪ¼ */
        return RESET;
    }
}

/**
  *   ȡ¼DMAжϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
BTIM_Get_Trigger_DMA_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRĴTXTDFλ --------------------*/
    if (BTIMx->SR & BTIM_SR_TXTDF)
    {
        /* ¼DMAж */
        return SET;
    }
    else
    {
        /* δ¼DMAж */
        return RESET;
    }
}

/**
  *   ȡ¼DMAжϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
BTIM_Get_Updata_DMA_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRĴTXUDFλ --------------------*/
    if (BTIMx->SR & BTIM_SR_TXUDF)
    {
        /* ¼DMAж */
        return SET;
    }
    else
    {
        /* δ¼DMAж */
        return RESET;
    }
}

/**
  *   ȡTxжϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
BTIM_Get_Overflow_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRĴTXIFλ --------------------*/
    if (BTIMx->SR & BTIM_SR_TXIF)
    {
        /* Txж */
        return SET;
    }
    else
    {
        /* δTxж */
        return RESET;
    }
}

/**
  *   ȡTx¼жϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
BTIM_Get_Trigger_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRĴTXTIFλ --------------------*/
    if (BTIMx->SR & BTIM_SR_TXTIF)
    {
        /* Tx¼ж */
        return SET;
    }
    else
    {
        /* δTx¼ж */
        return RESET;
    }
}

/**
  *   ȡTx¼жϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   ж״̬0δжϣ1ж
  */
FlagStatus
BTIM_Get_Updata_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRĴTXUIFλ --------------------*/
    if (BTIMx->SR & BTIM_SR_TXUIF)
    {
        /* Tx¼ж */
        return SET;
    }
    else
    {
        /* δTx¼ж */
        return RESET;
    }
}

/**
  *   Txжϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   
  */
void
BTIM_Clear_Overflow_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRICĴTXICλ --------------------*/
    SFR_SET_BIT_ASM(BTIMx->SRIC, BTIM_SRIC_TXIC_POS);
    while((BTIMx->SR & BTIM_SR_TXIF)>>BTIM_SR_TXIF_POS);
    SFR_CLR_BIT_ASM(BTIMx->SRIC, BTIM_SRIC_TXIC_POS);
}

/**
  *   Tx¼жϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   
  */
void
BTIM_Clear_Trigger_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRICĴTXTICλ --------------------*/
    SFR_SET_BIT_ASM(BTIMx->SRIC, BTIM_SRIC_TXTIC_POS);
    while((BTIMx->SR & BTIM_SR_TXTIF)>>BTIM_SR_TXTIF_POS);
    SFR_CLR_BIT_ASM(BTIMx->SRIC, BTIM_SRIC_TXTIC_POS);
}

/**
  *   Tx¼жϱ־
  *   BTIMx: ָʱڴṹָ룬ȡֵT14_SFR
  *   
  * ˵ñ־λʹܶӦʱ½Уᵼʧܡ
  */
void
BTIM_Clear_Updata_INT_Flag (BTIM_SFRmap* BTIMx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_BTIM_PERIPH(BTIMx));

    /*-------------------- TXSRICĴTXUICλ --------------------*/
    SFR_SET_BIT_ASM(BTIMx->SRIC, BTIM_SRIC_TXUIC_POS);
    while((BTIMx->SR & BTIM_SR_TXUIF)>>BTIM_SR_TXUIF_POS);
    SFR_CLR_BIT_ASM(BTIMx->SRIC, BTIM_SRIC_TXUIC_POS);
}
/**
  *   ##### ʱ(BTIM)жϼ־ #####
  */
