/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : kf32a156_aes.h                              	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-08                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the system control related function*
 *                    	declaration and related macro definition.	          *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/

#include "kf32a156_aes.h"
#include "kf32a156_rst.h"
#include "kf32a156_pclk.h"

/**
  *   ##### ʼú #####
  */
/**
  * AES踴λʹʱӡ
  *   : 
  *   ޡ
  */
void
AES_Reset ()
{
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_AESRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_AESRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_AESCLKEN, TRUE);
}

/**
  *  AES ʹܡ
  * 룺 NewState:
  * 	  		TRUE: AES 
  * 	 		FALSE: Ӱ
  * أ ޡ
  * עͣЧ Ҫֶ㣻
  */
void
AES_Run_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_AESRUN, NewState << AES_CTL_AESRUN_POS);
}

/**
  *  AES ģʽʹܡ
  * 룺 NewState:
  * 	  		TRUE:ģʽʹλ
  * 	 		FALSE: Ӱ
  * أ ޡ
  */
void
AES_High_Speed_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_HSMODE, NewState << AES_CTL_HSMODE_POS);
}

/**
  *  CBCģʽʹλ
  * 룺 Mode:
  * 	  		AES_WORK_ECB_MODE: ECBģʽ
  * 	 		AES_WORK_CBC_MODE: CBCģʽ
  * أ ޡ
  */
void
AES_CBC_Mode_Select(uint32_t Mode)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_WORK_MODE(Mode));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_CBCEN, Mode << AES_CTL_CBCEN_POS);
}

/**
  *  AESʱԴѡ
  * 룺 Source:
  * 	  		AES_TRNG_SCK_SCLK: ѡSCLKΪTRNGʱ
  * 	 		AES_TRNG_SCK_HFCLK: ѡSCLKΪTRNGʱ
  * 	 		AES_TRNG_SCK_LFCLK: ѡSCLKΪTRNGʱ
  * أ ޡ
  */
void
AES_TRNG_SCK_Select(uint32_t Source)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_TRNG_SCK(Source));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_CKS, Source << AES_CTL_CKS0_POS);
}

/**
  *  AESʱӷƵѡ
  * 룺 CLKDIV:
  * 	  		AES_SCK_DIV0:    Ƶ
  * 	 		AES_SCK_DIV2:    2Ƶ
  * 	 		AES_SCK_DIV4:    4Ƶ
  * 	 		AES_SCK_DIV8:  	 8Ƶ
  * 	 		AES_SCK_DIV16:   16Ƶ
  * 	 		AES_SCK_DIV32:   32Ƶ
  * 	 		AES_SCK_DIV64:   64Ƶ
  * 	 		AES_SCK_DIV128:  128Ƶ
  * أ ޡ
  */
void
AES_SCK_DIV_Select(uint32_t CLKDIV)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_SCK_DIV(CLKDIV));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_DIV, CLKDIV << AES_CTL_DIV0_POS);
}

/**
  *  AESԿչѡ
  * 룺 RNG_NUM:  RNG_NUM <= 0x1F
  * أ ޡ
  */
void
AES_RND_NUM_Config(uint32_t RNG_NUM)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_RNG_NUM(RNG_NUM));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_RND_NUM, RNG_NUM << AES_CTL_RND_NUM0_POS);
}

/**
  *  AESԿѡ
  * 룺 KEY_LEN:  KEY_LEN <= 0x07
  * أ ޡ
  * עͣ Կֳ =KEY_LEN+1/4
  */
void
AES_KEY_LEN_Config(uint32_t KEY_LEN)
{
	/* У */
	CHECK_RESTRICTION(CHECK_KEY_LEN(KEY_LEN));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_KEY_LEN, KEY_LEN << AES_CTL_KEY_LEN0_POS);
}

/**
  *  S 滻ʹλ
  * 룺 SBOXMODE:
					AES_SBOX_NOR_REPLACE: S滻
					AES_SBOX_INV_REPLACE: S滻
  * أ ޡ
  */
void
AES_SBOX_INV_Enable(uint32_t SBOXMODE)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_SBOX_INV(SBOXMODE));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_SB0X_INV, SBOXMODE << AES_CTL_SB0X_INV_POS);
}

/**
  *  ܹʹλ
  * 룺 EN_DECRYPT:
					AES_DECRYPT: ѡ AES ܹ
					AES_ENCRYPT: ѡ AES ܹ
  * أ ޡ
  */
void
AES_ENCRYPT_Function_Enable(uint32_t EN_DECRYPT)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_DE_ENCRYPT(EN_DECRYPT));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_ENCRYPT, EN_DECRYPT << AES_CTL_ENCRYPT_POS);
}

/**
  *  㷨Զʹ
  * 룺 ALGORITHM:
					AES_STANDARD_ALGORITHM: AES ñ׼㷨
					AES_CUSTOMIZE_ALGORITHM: AES Զ㷨
  * أ ޡ
  */
void
AES_CUSTOMIZE_ALGORITHM_Enable(uint32_t ALGORITHM)
{
	/* У */
	CHECK_RESTRICTION(CHECK_AES_ALGORITHM(ALGORITHM));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_AESLIKE, ALGORITHM << AES_CTL_AESLIKE_POS);
}

/**
  *  AES ʹ
  * 룺 NewState:
					TRUE: AES ʹ
					FALSE: AES ֹ
  * أ ޡ
  */
void
AES_Enable(FunctionalState NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	AES_CTL = SFR_Config(AES_CTL, ~AES_CTL_AESEN, NewState);
}


/**
  *  AES /жϱ־
  * 룺 
  * أ 0ڼӽܹ̻δʼӽ
  *		  11 μ/
  */
FlagStatus
AES_Get_INT_Flag(void)
{
	if(AES_INT & AES_INT_AESIF)
	{
		return SET;
	}
	else
	{
		return RESET;
	}
}

/**
  *  AES жϱ־
  * 룺 
  * أ ޡ
  */
void
AES_Clear_INT_Flag(void)
{
	SFR_SET_BIT_ASM(AES_INT, AES_INT_AESIC_POS);
	while(AES_INT & AES_INT_AESIF);
	SFR_CLR_BIT_ASM(AES_INT, AES_INT_AESIC_POS);
}

/**
  *  AES жʹλ
  * 룺 NewState:
  * 				ENABLE: AES жʹ
  * 				DISABLE: AES жϽֹ
  * أ ޡ
  */
void
AES_INT_Enable(AbleStatus NewState)
{
	/* У */
	CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

	AES_INT = SFR_Config(AES_INT, ~AES_INT_AESIE, NewState);
}


/**
  *  AESĴ
  *   INPUTDATA:λbit32
  *   ޡ
  */
void
AES_INPUT0_DATA (uint32_t DATA)
{

	AES_SFR->INPUT0=DATA;
}
void
AES_INPUT1_DATA (uint32_t DATA)
{

	AES_SFR->INPUT1=DATA;
}
void
AES_INPUT2_DATA (uint32_t DATA)
{

	AES_SFR->INPUT2=DATA;
}
void
AES_INPUT3_DATA (uint32_t DATA)
{

	AES_SFR->INPUT3=DATA;
}
/**
  *  AESĴ
  *  :
  * أ OUTPUTDATA:λbit32
  */
uint32_t
GET_AES_OUTPUT0_DATA (void)
{
	uint32_t DATA;
	DATA=AES_SFR->OUTPUT0;

	return	DATA;
}
uint32_t
GET_AES_OUTPUT1_DATA (void)
{
	uint32_t DATA;
	DATA=AES_SFR->OUTPUT1;

	return	DATA;
}
uint32_t
GET_AES_OUTPUT2_DATA (void)
{
	uint32_t DATA;
	DATA=AES_SFR->OUTPUT2;

	return	DATA;
}
uint32_t
GET_AES_OUTPUT3_DATA (void)
{
	uint32_t DATA;
	DATA=AES_SFR->OUTPUT3;

	return	DATA;
}
