/*****************************************************************************
*                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
******************************************************************************
*  @File Name        : I2C.c                                                 *
*  @Author           : ChipON AE/FAE Group                                   *
*  @Data$            : 2021-07-14                                            *
*  @Version          : V1.0                                                  *
*  @Description      : This file contains the I2C configuration for KF32A156 *
******************************************************************************
*  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
*  All rights reserved.                                                      *
*                                                                            *
*  This software is copyrght protected and proprietary to                    *
*  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
******************************************************************************
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*                          REVISON HISTORY                                   *
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  Data       Version  Author        Description                             *
*  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  2021-07-14 00.01.00  AE Group     new creat                               *
*                                                                            *
*                                                                            *
*****************************************************************************/

/******************************************************************************
**                             Include Files                                **
******************************************************************************/
#include "I2C.h"

/*****************************************************************************
**                         Private Macro Definitions                        **
*****************************************************************************/

/*****************************************************************************
**                         Private Variables Definitions                    **
*****************************************************************************/
I2C_SFRmap *I2C_Choose;
/*****************************************************************************
**                             Private Functions                            **
*****************************************************************************/

/*****************************************************************************
**                             Global Functions                            **
*****************************************************************************/
/**
 *  @brief: Initialization I2C IO
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void I2c_IO_Init()
{
    GPIO_InitTypeDef GpioConfigPtr;

    /* Configure GPIO remapping function */
    GpioConfigPtr.m_Mode = GPIO_MODE_RMP;
    /* Configyre GPIO open drain output */
    GpioConfigPtr.m_OpenDrain = GPIO_POD_OD;
    /* PG0,SCL */
    GpioConfigPtr.m_Pin = GPIO_PIN_MASK_0;
    /* Configure pull up */
    GpioConfigPtr.m_PullUp = GPIO_PULLUP;
    /* Configure drop down */
    GpioConfigPtr.m_PullDown = GPIO_NOPULL;
    /* Configure PG0 as I2C0 SCL */
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_0, GPIO_RMP_AF5);
    GPIO_Configuration(GPIOG_SFR, &GpioConfigPtr);

    /* PF15,SDA */
    GpioConfigPtr.m_Pin = GPIO_PIN_MASK_15;

    /* Configure PF0 as I2C0 SCL */
    GPIO_Pin_RMP_Config(GPIOF_SFR, GPIO_Pin_Num_15, GPIO_RMP_AF5);
    GPIO_Configuration(GPIOF_SFR, &GpioConfigPtr);
}

/**
 *  @brief: Initialization I2C HW module
 *  @param in: I2Cx
 *             I2c_Address
 *  @param out : None
 *  @retval : None
 */
void I2c_Init(I2C_SFRmap *I2cx, uint16_t I2c_Address)
{
    I2C_InitTypeDef I2cConfigPtr;

    /* I2c mode */
    I2cConfigPtr.m_Mode = I2C_MODE_I2C;
    /* I2c clock */
    I2cConfigPtr.m_ClockSource = I2C_CLK_SCLK;
/* Configure slave address width */
#if (I2C_ADDRESS_WIDTH == I2C_7BIT)
    I2cConfigPtr.m_BADR10 = I2C_BUFRADDRESS_7BIT;
#else
    I2cConfigPtr.m_BADR10 = I2C_BUFRADDRESS_10BIT;
#endif
    /* SMBus type */
    I2cConfigPtr.m_MasterSlave = I2C_MODE_SMBUSDEVICE;
    /* I2c baud rate low level time */
    I2cConfigPtr.m_BaudRateL = 12;
    /* I2c baud rate high level time */
    I2cConfigPtr.m_BaudRateH = 12;
    /* Enable ACK */
    I2cConfigPtr.m_AckEn = TRUE;
    /* Select the response signal as ACK */
    I2cConfigPtr.m_AckData = I2C_ACKDATA_ACK;

    /* I2C reset */
    I2C_Reset(I2cx);
    /* Configue I2C */
    I2C_Configuration(I2cx, &I2cConfigPtr);

    /* Set slave address */
    I2C_ADDR_Config(I2cx, 0, I2c_Address);
    I2C_ADDR_Config(I2cx, 1, I2c_Address);
    I2C_ADDR_Config(I2cx, 2, I2c_Address);
    I2C_ADDR_Config(I2cx, 3, I2c_Address);
    /* Configure I2C address mask bit */
    I2C_MSK_Config(I2cx, 0, 0x0000);

    /* Clear Interrupt flag */
    I2C_Clear_INTERRUPT_Flag(I2cx);

    /* Enable I2C address match */
    I2C_MATCH_ADDRESS_Config(I2cx, TRUE);

    /* Enable I2C HW module */
    I2C_Cmd(I2cx, TRUE);
}

/**
 *  @brief: nitialization I2C Interrupt 
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void I2c_Interrupt_Init()
{
    /* Enable I2c receive interrupt */
    INT_Interrupt_Enable(INT_I2C0, TRUE);
    /* Enable I2c interrupt */
    I2C_ISIE_INT_Enable(I2C0_SFR, TRUE);
    INT_All_Enable(TRUE);
}


