/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for ECCPx PWM interrupt  *
 *                      mode                                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "main.h"

/*******************************************************************************
**                      	Private Macro Definitions                         **
*******************************************************************************/
/* Edge aligned PWM signal */
#define PWM_Edge_Out (0U)
/* Center aligned PWM signal */
#define PWM_Center_Out (1U)

/* PWM signal mode control */
#define CCP_PWM_WORK (PWM_Edge_Out)
/*******************************************************************************
**                     			Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}
/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* Initialize led lights */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);

	/* Configure PWM output IO port */
	ECCP_IO_Init();

	/* Reset T5 */
	TIM_Reset(T5_SFR);

	/* Configure ECCP5 */
	ECCP5_Init();

	/* Configure T5 */
	Tx_Init(T5_SFR);

	/* Configure Interrupt */
	ECCP_Interrupt_Init();
	while (1)
		;
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
