/*****************************************************************************
*                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
******************************************************************************
*  @File Name        : ECCP.c                                                *
*  @Author           : ChipON AE/FAE Group                                   *
*  @Data$            : 2021-07-21                                            *
*  @Version          : V1.0                                                  *
*  @Description      : This file contains the ECCP configuration for KF32A156*
*  devices                                                                   *
******************************************************************************
*  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
*  All rights reserved.                                                      *
*                                                                            *
*  This software is copyrght protected and proprietary to                    *
*  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
******************************************************************************
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*                          REVISON HISTORY                                   *
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  Data       Version  Author        Description                             *
*  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  2021-07-21 00.01.00  AE Group     new creat                               *
*                                                                            *
*                                                                            *
*****************************************************************************/

/******************************************************************************
**                             Include Files                                **
******************************************************************************/
#include "ECCP.h"

/*****************************************************************************
**                         Private Macro Definitions                        **
*****************************************************************************/

/*****************************************************************************
**                         Private Variables Definitions                    **
*****************************************************************************/

/*****************************************************************************
**                             Private Functions                            **
*****************************************************************************/

/*****************************************************************************
**                             Global Functions                            **
*****************************************************************************/
/**
 *  @brief: ECCP5 initialziation
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void ECCP5_Init()
{
    /* PWM free mode */
    ECCP_PWM_Mode_Config(ECCP5_SFR, ECCP_PWM_FREE);
    /* Independent output mode  */
    ECCP_Channel_Output_Mode(ECCP5_SFR, ECCP_CHANNEL_1, ECCP_OUTPUT_INDEPENDENT);
    /* Complementary output mode  */
    ECCP_Channel_Output_Mode(ECCP5_SFR, ECCP_CHANNEL_2, ECCP_OUTPUT_COMPLEMENTARY);

    /* Prohibit automatic shutdown  */
    ECCP_Channel_Shutdown_Signal(ECCP5_SFR, ECCP_CHANNEL_1, ECCP_CHANNEL_SHUTDOWN_FORBID);
    /* Enable automatic shutdown, low level on ECCPx_BKIN pin  */
    ECCP_Channel_Shutdown_Signal(ECCP5_SFR, ECCP_CHANNEL_2, ECCP_CHANNEL_BKIN_INACTIVE);

    /* Enable automatic restart  */
    ECCP_PWM_Restart_Enable(ECCP5_SFR, TRUE);

    /* Enable phase shift  */
    ECCP_PWM_Move_Phase_Enable(ECCP5_SFR, TRUE);

    /* Closed state is low  */
    ECCP_Channel_Pin_Ctl(ECCP5_SFR, ECCP_CHANNEL_2, ECCP_PORT_LOW, PIN_INACTIVE);
    /* Closed state is high */
    ECCP_Channel_Pin_Ctl(ECCP5_SFR, ECCP_CHANNEL_2, ECCP_PORT_HIGH, PIN_ACTIVE);

    /* Force output high level  */
    ECCP_Channel_Output_Control(ECCP5_SFR, ECCP_CHANNEL_1, ECCP_PORT_LOW, ECCP_CHANNEL_OUTPUT_ACTIVE);
    /* PWM output, high effective  */
    ECCP_Channel_Output_Control(ECCP5_SFR, ECCP_CHANNEL_1, ECCP_PORT_HIGH, ECCP_CHANNEL_OUTPUT_PWM_ACTIVE);
    /* PWM output, high effective  */
    ECCP_Channel_Output_Control(ECCP5_SFR, ECCP_CHANNEL_2, ECCP_PORT_LOW, ECCP_CHANNEL_OUTPUT_PWM_ACTIVE);
    /* PWM output, high effective  */
    ECCP_Channel_Output_Control(ECCP5_SFR, ECCP_CHANNEL_2, ECCP_PORT_HIGH, ECCP_CHANNEL_OUTPUT_PWM_ACTIVE);

    /* Channel dead zone delay time */
    ECCP_Dead_Time_Config(ECCP5_SFR, ECCP_CHANNEL_2, 0x10);

    /* PWM duty cycle  */
    ECCP_Set_Compare_Result(ECCP5_SFR, ECCP_CHANNEL_1, 0x2000);
    ECCP_Set_Compare_Result(ECCP5_SFR, ECCP_CHANNEL_2, 0x4000);
}

/**
  *  @brief: Tx inialization
  *  @param in: ATIM_SFRmap *ATIMx
  *  @param out : None
  *  @retval : None
  */
void Tx_Init(ATIM_SFRmap *ATIMx)
{
    /* Timing mode */
    ATIM_X_Work_Mode_Config(ATIMx, ATIM_TIMER_MODE);
    /* Count value is cleared to 0  */
    ATIM_X_Set_Counter(ATIMx, 0);
    /* Period value */
    ATIM_X_Set_Period(ATIMx, 0xffff);
    /* Prescaler 1:1  */
    ATIM_X_Set_Prescaler(ATIMx, 0);
    /* The post-divider ratio is 1:1  */
    ATIM_X_Postscaler_Config(ATIMx, ATIM_POSTSCALER_DIV_1);
    /* Center-aligned PWM signal, counts up, and generates an interrupt flag when it overflows */
    ATIM_X_Counter_Mode_Config(ATIMx, ATIM_COUNT_UP_OF);
    /* Choose HFCLK clock as Tx working clock  */
    ATIM_X_Clock_Config(ATIMx, ATIM_HFCLK);
    /* Enable immediate update  */
    ATIM_X_Updata_Immediately_Config(ATIMx, TRUE);

    /* Immediately update the output control register with Tx as the time base  */
    ATIM_X_Updata_Output_Ctl(ATIMx, TRUE);
    /* Allow to change related configuration information with Tx as the time base  */
    ATIM_X_Updata_Enable(ATIMx, TRUE);
    /* Tx start control enable  */
    ATIM_X_Cmd(ATIMx, TRUE);
}
/**
 *  @brief: IO inialization
 *  @param in: None
 *  @param out : None
 *  @retval : None
 */
void ECCP_IO_Init()
{
    GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_0, GPIO_MODE_RMP);
    GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_1, GPIO_MODE_RMP);
    GPIO_Write_Mode_Bits(GPIOG_SFR, GPIO_PIN_MASK_13, GPIO_MODE_RMP);
    GPIO_Write_Mode_Bits(GPIOG_SFR, GPIO_PIN_MASK_12, GPIO_MODE_RMP);
    GPIO_Write_Mode_Bits(GPIOF_SFR, GPIO_PIN_MASK_5, GPIO_MODE_RMP);

    /* ECCP5CH1L */
    GPIO_Pin_RMP_Config(GPIOB_SFR, GPIO_Pin_Num_0, GPIO_RMP_AF8);
    /* ECCP5CH1H */
    GPIO_Pin_RMP_Config(GPIOB_SFR, GPIO_Pin_Num_1, GPIO_RMP_AF10);
    /* ECCP5CH2L */
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_13, GPIO_RMP_AF10);
    /* ECCP5CH2H */
    GPIO_Pin_RMP_Config(GPIOG_SFR, GPIO_Pin_Num_12, GPIO_RMP_AF10);
    /* ECCP5BKIN */
    GPIO_Pin_RMP_Config(GPIOF_SFR, GPIO_Pin_Num_5, GPIO_RMP_AF8);

    /* Use the internal pull-up on the ECCP5BKIN pin, the default is not to turn off the PWM output  */
    GPIO_Pull_Up_Enable(GPIOF_SFR, GPIO_PIN_MASK_5, TRUE);
}
