/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for ECCPx compare mode   *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/* Capture the PWM duty cycle variable */
volatile uint16_t DW_PLUSE_WIDTH = 0;
/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief: Delay time
 *  @param in: nms
 *  @param out : None
 *  @retval : None
 */
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i, j;
	for (i = 0; i < nms; i++)
	{
		j = 5000;
		while (j--)
			;
	}
}

/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}

/**
 *  @brief: The ECCPx comapre function configures the initialization parameters.
 *  @param in: ECCPx Pointer to ECCP or general timer memory structure
 *  @param out : None
 *  @retval : None
 */
void ECCPx_Compare_Mode_init(ECCP_SFRmap *ECCPx)
{
	/* Set the prescaler value of the timer and the mode of the capture channel */
	/* Timer peripheral reset, enable peripheral clock */
	TIM_Reset(ECCPx);

	/* Configure CCPx to compare mode, the output level is inverted during comparison match*/
	ECCP_Compare_Mode_Config(ECCPx, ECCP_CHANNEL_1, ECCP_CMP_TOGGLE_LEVEL);
	/* Configure CCPx compare register */
	ECCP_Set_Compare_Result(ECCPx, CCP_CHANNEL_1, 0x8000);

	/* Immediately update the output control register with Tx as the time base */
	ATIM_X_Updata_Output_Ctl(ECCPx, TRUE);
	/* Update control immediately */
	ATIM_X_Updata_Immediately_Config(ECCPx, TRUE);
	/* Configuration update enable */
	ATIM_X_Updata_Enable(ECCPx, TRUE);
	/* Timing mode selection */
	ATIM_X_Work_Mode_Config(ECCPx, ATIM_TIMER_MODE);
	/* Timer count value */
	ATIM_X_Set_Counter(ECCPx, 0);
	/* Timer period value */
	ATIM_X_Set_Period(ECCPx, 0XFFFF);
	/* Timer prescaler value The prescaler is 119+1=120, the main clock is 120M, 
	   1us counts once */
	ATIM_X_Set_Prescaler(ECCPx, 15);
	/* Up, overflow generates an interrupt flag */
	ATIM_X_Counter_Mode_Config(ECCPx, ATIM_COUNT_UP_OF);
	/* Select SCLK as the timer clock source */
	ATIM_X_Clock_Config(ECCPx, ATIM_SCLK);
	/* Enable general timer */
	ATIM_X_Cmd(ECCPx, TRUE);
}
/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* System clock configuration */
	SystemInit(120);

	/* Initialize led lights */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);

	/* PB0 remap tp capture mode */
	GPIO_Write_Mode_Bits(GPIOB_SFR, GPIO_PIN_MASK_0, GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOB_SFR, GPIO_Pin_Num_0, GPIO_RMP_AF8);

	/* CCP18 channel 1 Compare mode initialization, Configure 
	   channel 1 trigger source*/
	ECCPx_Compare_Mode_init(ECCP5_SFR);

	while (ECCP_Get_Channel_Trigger_INT_Flag(ECCP5_SFR, ECCP_CHANNEL_1))
	{
		/* Clear interrupt flag */
		ECCP_Clear_Channel_INT_Flag(ECCP5_SFR, ECCP_CHANNEL_1);
		/* Update timer period value */
		ATIM_X_Set_Period(T5_SFR, 0xF000);
	}
	while (1)
	{
	}
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
