/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for DMA Ram to Ram mode  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "main.h"

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	char j = 0;
	/* The power-on default clock is 16M divided by 128. If the RAM initialization time 
	is too long, the system clock initialization can be placed before the initialization 
	of the RAM by the startup() function of startup.c */
	
	/* System clock configuration */
	SystemInit(120);

	/* PD12 control Led1 */
	GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_12,GPIO_MODE_OUT);
	/* Set Led1 low level */
	GPIO_Set_Output_Data_Bits(GPIOD_SFR, GPIO_PIN_MASK_12,Bit_RESET);

	/* Initialization DMA */
	DMA_init(DMA0_SFR);

	/* Enable the M2M register can be used as a signal triggered by software to start 
	DMA transfer, and DMA transfer will continue after the software trigger*/
	DMA_Memory_To_Memory_Enable(DMA0_SFR,DMA_CHANNEL_1,TRUE);

	/* Wait transmit complete */
	while(0 == DMA_Get_Finish_Transfer_INT_Flag(DMA0_SFR,DMA_CHANNEL_1));

	/* Check whether the characters transmitted by DMA are correct one by one */
	for (char i = 0; i < 20; i++)
	{
		if (buf_2[i] == buf_1[i])
		{
			j++;
		}
	}
	if (j==20)
	{
		GPIO_Set_Output_Data_Bits(GPIOD_SFR, GPIO_PIN_MASK_12, Bit_SET);
	}
	else
	{
		GPIO_Set_Output_Data_Bits(GPIOD_SFR, GPIO_PIN_MASK_12, Bit_RESET);
	}
	while(1);	
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
