/*****************************************************************************
*                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
******************************************************************************
*  @File Name        : DMA.h                                                 *
*  @Author           : ChipON AE/FAE Group                                   *
*  @Data$            : 2021-07-12                                            *
*  @Version          : V1.0                                                  *
*  @Description      : This file contains the DMA Ram to Ram configuration   *
*                      for KF32A156 device                                   *
******************************************************************************
*  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
*  All rights reserved.                                                      *
*                                                                            *
*  This software is copyrght protected and proprietary to                    *
*  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
******************************************************************************
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*                          REVISON HISTORY                                   *
*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  Data       Version  Author        Description                             *
*  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
*  2021-07-12 00.01.00  AE Group     new creat                               *
*                                                                            *
*                                                                            *
*****************************************************************************/

/******************************************************************************
**                             Include Files                                **
******************************************************************************/
#include "DMA.h"

#ifndef DMA_C
#define DMA_C
/*****************************************************************************
**                         Private Macro Definitions                        **
*****************************************************************************/

/*****************************************************************************
**                         Private Variables Definitions                    **
*****************************************************************************/
uint32_t buf_1[20] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x20};
uint32_t buf_2[20] = {0};
/*****************************************************************************
**                             Private Functions                            **
*****************************************************************************/

/*****************************************************************************
**                             Global Functions                            **
*****************************************************************************/
/**
 *  @brief: Initialize DMAx and configure DMAx
 *  @param in: DMA_SFRmap *DMAx
 *  @param out : None
 *  @retval : None
 */
void DMA_init(DMA_SFRmap *DMAx)
{
    DMA_InitTypeDef dmaNewStruct;
    /* DMA reset */
    DMA_Reset(DMAx);
    /* DMA function configuration */

    /* Configuration Number of data to be transmitted */
    dmaNewStruct.m_Number = 20;
    /* Configure DMA transfer direction */
    dmaNewStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;
    /* Configure DMA channel priority */
    dmaNewStruct.m_Priority = DMA_CHANNEL_LOWER;
    /* Configuration Peripheral data bit width: 32 bits wide */
    dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_32_BITS;
    /* Configuration memory data width: 32 bits wide */
    dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_32_BITS;
    /* Configuration Peripheral address incremental mode enable */
    dmaNewStruct.m_PeripheralInc = TRUE;
    /* Configuration Memory address increment mode enable */
    dmaNewStruct.m_MemoryInc = TRUE;
    /* Configure DMA channel selection */
    dmaNewStruct.m_Channel = DMA_CHANNEL_1;
    /* Configuration data block transmission mode */
    dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;
    /* Configuration Cyclic mode enable */
    dmaNewStruct.m_LoopMode = TRUE;
    /* Configuration Peripheral start address: the start address of the data waiting to be sent */
    dmaNewStruct.m_PeriphAddr = (uint32_t)buf_1;
    /* Configuration Memory start address: the start address of the memory space for receiving data */
    dmaNewStruct.m_MemoryAddr = (uint32_t)buf_2;

    /* Configure DMA function */
    DMA_Configuration(DMAx, &dmaNewStruct);
    /* Enable channel 1 DMA */
    DMA_Channel_Enable(DMAx, DMA_CHANNEL_1, TRUE);
}

#endif /* DMA_C */