/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides a routine for CCP capture interrupt*
 *                      mode                                                  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief: Delay time
 *  @param in: nms
 *  @param out : None
 *  @retval : None
 */
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i, j;
	for (i = 0; i < nms; i++)
	{
		j = 5000;
		while (j--)
			;
	}
}

/**
 *  @brief: GPIOx output initialization configuration
 *  @param in: GPIOx
 * 			   GpioPin
 *  @param out : None
 *  @retval : None
 */
void GPIOInit_Output_Config(GPIO_SFRmap *GPIOx, uint16_t GpioPin)
{
	/* Configure Pxy as output mode parameter */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	/* Initialize GPIO output speed */
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	/* Initialize GPIO direction as output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	/* Initialize whether the GPIO is pulled up */
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	/* Initialize whether the GPIO is pulled down */
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;

	GPIO_Configuration(GPIOx, &GPIO_InitStructure);

	/* Initialized to high level */
	GPIO_Set_Output_Data_Bits(GPIOx, GpioPin, Bit_SET);
}

/**
 *  @brief: The CCPx capture function configures the initialization parameters.
 *  @param in: CCPx Pointer to CCP or general timer memory structure
 *  @param out : None
 *  @retval : None
 */
void CCPx_CaptureINT_Mode_init(CCP_SFRmap *CCPx)
{
	/* Set the prescaler value of the timer and the mode of the capture channel */
	/* Timer peripheral reset, enable peripheral clock */
	TIM_Reset(CCPx);
	/* Set slave mode: reset mode */
	GPTIM_Slave_Mode_Config(CCPx, GPTIM_SLAVE_RESET_MODE);
	/* Select the trigger source : CH1 */
	GPTIM_Trigger_Select_Config(CCPx, GPTIM_TRIGGER_CCPXCH1);
	/* Set the capture channel mode: capture every rising edge */
	CCP_Capture_Mode_Config(CCPx, CCP_CHANNEL_1, CCP_CAP_RISING_EDGE);

	/* Update control immediately */
	GPTIM_Updata_Immediately_Config(CCPx, TRUE);
	/* Configuration update enable */
	GPTIM_Updata_Enable(CCPx, TRUE);
	/* Timing mode selection */
	GPTIM_Work_Mode_Config(CCPx, GPTIM_TIMER_MODE);
	/* Timer count value */
	GPTIM_Set_Counter(CCPx, 0);

	/* Timer prescaler value The prescaler is 119+1=120, the main clock is 120M, 
	   1us counts once */
	GPTIM_Set_Prescaler(CCPx, 119);
	/* Up, overflow generates an interrupt flag */
	GPTIM_Counter_Mode_Config(CCPx, GPTIM_COUNT_UP_OF);
	/* Select SCLK as the timer clock source */
	GPTIM_Clock_Config(CCPx, GPTIM_SCLK);

	/* Enable general timer */
	GPTIM_Cmd(CCPx, TRUE);
}
/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* Initialize the system clock is 120M*/
	SystemInit(120);

	/* Initialize led lights */
	GPIOInit_Output_Config(GPIOD_SFR, GPIO_PIN_MASK_12);

	/* PG8 remap tp capture mode */
	GPIO_Write_Mode_Bits(GPIOE_SFR, GPIO_PIN_MASK_10, GPIO_MODE_RMP);
	GPIO_Pin_RMP_Config(GPIOE_SFR, GPIO_Pin_Num_10, GPIO_RMP_AF2);

	/* CCP18 channel 1 and channel 2 Capture mode initialization, Configure 
	   channel 1 trigger source*/
	CCPx_CaptureINT_Mode_init(CCP18_SFR);

	/* Enable all interrupt */
	INT_All_Enable(TRUE);
	/* Interrupt enable configuration */
	CCP_Channel_INT_Config(CCP18_SFR, CCP_CHANNEL_1, TRUE);
	/* Preemption priority 4, sub-priority 0 */
	INT_Interrupt_Priority_Config(INT_T18, 4, 0);
	/* Peripheral interrupt enable */
	INT_Interrupt_Enable(INT_T18, TRUE);
	/* Clear interrupt flag */
	INT_Clear_Interrupt_Flag(INT_T18);

	while (1)
		;
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t *File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while (1)
	{
		;
	}
};
