/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This file provides the reference code of CAN		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
*                        		Include Files                                 *
******************************************************************************/
#include "system_init.h"
#include "Can.h"

/******************************************************************************
*                     	Static function declaration                           *
******************************************************************************/
static void Led_Gpio_Init(void);
static void Led_Flip(void);

/******************************************************************************
*                        	Initialization function                           *
******************************************************************************/
/**
 *  @brief :Initializes the GPIO of the LED
 *  @param in :None
 *  @param out :None
 *  @retval :PD12--LED1
 *  		 PH3 --LED2
 *  		 PA4 --LED3
 *  		 PF7 --LED4
 */
static void Led_Gpio_Init(void)
{
	/*Configure the GPIO PA4/PD12/PF7/PH3 as IO port output mode */
	GPIO_Write_Mode_Bits(GPIOA_SFR, GPIO_PIN_MASK_4 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_12 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOF_SFR, GPIO_PIN_MASK_7 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOH_SFR, GPIO_PIN_MASK_3 , GPIO_MODE_OUT);

	GPIO_Write_Mode_Bits(GPIOE_SFR, GPIO_PIN_MASK_8 , GPIO_MODE_OUT);
	GPIO_Write_Mode_Bits(GPIOA_SFR, GPIO_PIN_MASK_2 , GPIO_MODE_OUT);
	GPIO_Set_Output_Data_Bits(GPIOA_SFR, GPIO_PIN_MASK_2 ,Bit_RESET );
	GPIO_Set_Output_Data_Bits(GPIOE_SFR, GPIO_PIN_MASK_8 ,Bit_RESET );
}

/**
 *  @brief :Led flip
 *  @param in :None
 *  @param out :None
 *  @retval :PD12--LED1
 *  		 PH3 --LED2
 *  		 PA4 --LED3
 *  		 PF7 --LED4
 */
static void Led_Flip(void)
{
	GPIO_Toggle_Output_Data_Config(GPIOA_SFR, GPIO_PIN_MASK_4);
	GPIO_Toggle_Output_Data_Config(GPIOD_SFR, GPIO_PIN_MASK_12);
	GPIO_Toggle_Output_Data_Config(GPIOF_SFR, GPIO_PIN_MASK_7);
	GPIO_Toggle_Output_Data_Config(GPIOH_SFR, GPIO_PIN_MASK_3);
}

/*
 * Filter group type:
 *			- Acceptance code
 *			- Mask code
 *			- Frame type Standard Frame
 *			               Extended Frame
 */
Filter_Group_Typedef Filter_Group[9] = {
										{0x111,0x00000000,Standard_Frame},
										{0x222,0x00000000,Standard_Frame},
										{0x333,0x00000000,Standard_Frame},
										{0x444,0x00000000,Standard_Frame},
										{0x7FE,0x00000000,Standard_Frame},
										{0x3860111,0x00000000,Extended_Frame},
										{0x3860222,0x00000000,Extended_Frame},
										{0x3860333,0x00000000,Extended_Frame},
										{0x3860444,0x00000000,Extended_Frame},
									   };

/*
 * CAN configuration information:
 *			- Enable CAN
 *			- CAN mode configuration
 *          - CAN worksource configuration
 *			- Can baud rate default value is 0
 *			- CAN synchronous jump width is 1
 *			- CAN time interval 1 is 10
 *			- CAN time interval 2 is 3
 *			- CAN bus acquisition times is 3 times
 */
CAN_InitTypeDef CAN_Condition = {
									TRUE,
									CAN_MODE_NORMAL,
									CAN_SOURCE_HFCLK_DIV_2,
#if(BAUDRATE == BAUDRATE100K)
									4,
#elif(BAUDRATE == BAUDRATE250K)
									1,
#elif(BAUDRATE == BAUDRATE500K)
									0,
#endif
									1,
									11,
									2,
									CAN_BUS_SAMPLE_3_TIMES,
									&Filter_Group[0]
								};

/*
 *   Can interrupt type:
 *			- Enable CAN transmit interrupt type
 *			- Enable CAN receive interrupt type
 *          - Enable CAN overflow interrupt type
 *          - Enable CAN buserror interrupt type
 *          - Enable CAN busoff interrupt type
 *          - Enable CAN error negative interrupt type
 */
Can_Interrupt_Type Can_Interrupt = {
									INTERRUPT_DISABLE,
									INTERRUPT_ENABLE,
									INTERRUPT_DISABLE,
									INTERRUPT_ENABLE,
									INTERRUPT_ENABLE,
									INTERRUPT_DISABLE,
									};

/*
 *   Can interrupt type:
 *			- CAN message information structure:
 *					- Frame format selection
 *					- Send the request remotely
 *					- Data Length
 *					- ID
 *					- Data area
 *			- Frame length is 1
 */
Can_Pdu_TypeDef    Can_Pdu_Send = {
									{
										{
										CAN_FRAME_FORMAT_SFF,
										CAN_DATA_FRAME,
										8,
										0x111,
										{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
										},
									},
									1,
								   };

int main()
{
	/* Initialize the system clock */
	SystemInit(120);
	/* Setup SysTick Timer as delay function */
	systick_delay_init(120);
	/* Initialize led IOs */
	Led_Gpio_Init();
	/* Initialize Can IOs
	 *     - PC10 = CAN4TX
	 *     - PC11 = CNA4RX
	 */
	CAN_Gpio_Init();
	/* Initialize Can Mode And Set Can Module To 500k baudrate*/
	CAN_Init(CAN4_SFR,&CAN_Condition);
	/* Initialize   Interrupt */
	CAN_Int_Config(&Can_Interrupt);
	while(1)
	{
		/* Led flip */
		Led_Flip();
		systick_delay_ms(1000);
	}		
}
