/****************************************************************************************
 *
 * File Name: kf_it.c
 * Project Name: KF32A156
 * Version: v1.0
 * Date: 2021-05-17- 09:13:03
 * Author: dell
 * 
 ****************************************************************************************/
#include "system_init.h"
#include "Canfd.h"
//*****************************************************************************************
//                                 NMI Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _NMI_exception (void)
{	

}

//*****************************************************************************************
//                               HardFault Interrupt Course
//*****************************************************************************************	

void __attribute__((interrupt)) _HardFault_exception (void)
{

}

//*****************************************************************************************
//                               StackFault Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _StackFault_exception (void)
{

}

//*****************************************************************************************
//                               SVC Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SVC_exception (void)
{

}

//*****************************************************************************************
//                              SoftSV Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SoftSV_exception (void)
{

}

//*****************************************************************************************
//                              SysTick Interrupt Course
//*****************************************************************************************	
void __attribute__((interrupt)) _SysTick_exception (void)
{
	
}




/*****************************************************************************************
                              FlexCAN6_exception Course
*****************************************************************************************/

void __attribute__((interrupt)) _CANFD6_exception (void)
{
	uint8_t Rmc_count = 0;
	Can_Controller_InterruptFlagType Can_Controller_InterruptFlag;
	volatile Kf32a_Canfd_Reg *ControllerRegPtr = (Kf32a_Canfd_Reg *)Can_m_ControllersInfo[1].BaseAddress;
	Can_m_FdGetIntFlag(1, &Can_Controller_InterruptFlag, &Rmc_count);
	Can_m_FdClearIntFlag(1, &Can_Controller_InterruptFlag, Rmc_count);
	if (Can_Controller_InterruptFlag.TxIntFlag == 0x01)
	{
		/* Receive Message From Mailbox_0 */
		Can_m_FdMailBoxCode_Set(CANfd6, Mailbox_0, &Canfd_Sdu.Can_MailboxHeader[0]);
		if(Can_m_FdTransmitonce(CANfd6) != CAN_OK)
		{
			while(1);
		}
	}

	if(Can_Controller_InterruptFlag.BusErrorFlag == 0x01)
	{
		/* Disable Transmitting Message */
		ControllerRegPtr->CANFD_CTLR0.B.ATX = 0x01;
		ControllerRegPtr->CANFD_CTLR0.B.ATX = 0x00;
	}

	if(Can_Controller_InterruptFlag.BusOffFlag == 0x01)
	{
		/* Bus Off Soft Recovery */
		ControllerRegPtr->CANFD_CTLR0.B.RSMOD = 0x00;
	}
}





