/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a This example demonstrates how to 			  *
 * 						write and read BKP DATA.BKP DATA is not reset in 	  *
 * 						Software Reset Mode									  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"

/*******************************************************************************
**                     		   Global Functions 		             	      **
*******************************************************************************/
/**
 *  @brief :Initialize the LED GPIO ports
 * 			PD7	------------- UserKey
 * 			PD12 ------------ LED1
 * 			PH3 ------------- LED2
 *  @param in :None
 *  @param out :None 
 *  @retval :None
 */
void BoardGpioInit(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	
	/* Configure PD12 LED1 output */
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_12;
	GPIO_Configuration(GPIOD_SFR , &GPIO_InitStructure);
	/* Configure PH3 LED2 output */
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_3;
	GPIO_Configuration(GPIOH_SFR , &GPIO_InitStructure);
	/* Configure PA4 LED3 output */
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_4;
	GPIO_Configuration(GPIOA_SFR , &GPIO_InitStructure);
	/* Configure PD7 user key input */
	GPIO_InitStructure.m_Mode = GPIO_MODE_IN;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_7;
	GPIO_Configuration(GPIOD_SFR , &GPIO_InitStructure);
}

/*******************************************************************************
**                     			main Functions 		             	     	  **
*******************************************************************************/
int main()
{
	/* Initialize the system clock is 120M */
	SystemInit(120);
	/* Setup SysTick Timer as delay function, and input frequency is 120M */
	systick_delay_init(120);
	/* Initialize the LED IOs */
	BoardGpioInit();
	/* Set the BKP area is enable */
	BKP_Write_And_Read_Enable(TRUE);
	/* Read and write data in the backup domain 0, increment by 1 each time, 
	and reset to 0 when it reaches 40 */
	if (++BKP_DATA0 >= 40)
		BKP_DATA0 = 0;
	/* Turn on LED1 */
	GPIO_Set_Output_Data_Bits(GPIOD_SFR, GPIO_PIN_MASK_12, Bit_SET);
	/* Delay a little time. time = (BKP_DATA0 * 5ms) */
	for (int i = 0; i < BKP_DATA0; i++)
	{
		systick_delay_ms(5);
	}
	/* Turn off LED1 */
	GPIO_Set_Output_Data_Bits(GPIOD_SFR, GPIO_PIN_MASK_12, Bit_RESET);
	/* Delay a little time. time = (BKP_DATA0 * 5ms) */
	for (int i = 0; i < BKP_DATA0; i++)
	{
		systick_delay_ms(5);
	}
	/* MCU reset, but bkp area will not reset */
	asm("RESET");
	
	while(1)
	{
	
	}		
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
