/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a template project used by ADC single mode.   *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_SysTick.h"
#include "User_ADC.h"
/* Private variables *********************************************************/
ADC_InitTypeDef ADC_InitStructure;
volatile uint16_t adc_Pd5_value;


/******************************************************************************
**                     			main Functions 		             	     	 **
******************************************************************************/
int main()
{

	/*initialize system clock ,defaut SCLK is  120M,select INTHF as Clock
	 **source*****************************************************************/
	SystemInit(120);
	GPIOInit_Output_Config(GPIOD_SFR,GPIO_PIN_MASK_7);
	/*T=1/120M*120000=1ms,120M:SCLK*******************************************/
	SysTick_Configuration(120000);


	/*ADC0 module configuration***********************************************/
	adc_GPIO_init();
	/*reset ADC0 module,enable ADC0 clock source******************************/
	ADC_Reset (ADC0_SFR);
	ADC_Struct_Init(&ADC_InitStructure);
	/*select HFCLK as the ADC0 sampling clock source***************************
	**You can also select SCLK or LFCLK as the ADC0 sampling clock************/
	ADC_InitStructure.m_Clock=ADC_HFCLK;
	/*ADC sampling clock Divider configuration********************************/
	ADC_InitStructure.m_ClockDiv = ADC_CLK_DIV_32;
	/*disable adc scan mode***************************************************/
	ADC_InitStructure.m_ScanMode = FALSE;
	/*select single adc sampling mode ****************************************/
	ADC_InitStructure.m_ContinuousMode = ADC_SINGLE_MODE;
	/*Right-aligned sampling result data *************************************/
	ADC_InitStructure.m_DataAlign = ADC_DATAALIGN_RIGHT;
	/*disable External trigger************************************************/
	ADC_InitStructure.m_ExternalTrig_EN = FALSE;
	/*select Vdd as ADC refrence voltage**************************************/
	ADC_InitStructure.m_VoltageRef=ADC_REF_AVDD;
	ADC_Configuration (ADC0_SFR, &ADC_InitStructure);
	ADC_Cmd (ADC0_SFR, TRUE);
	/*Need to delay after the adc configuration is completed******************/
	Systick_Delay(SYSTEM_DELAY_1MS);
	while(1)
	{
		/*sampling GPIO PD5 adc value*****************************************/
		adc_Pd5_value = Get_ADC0_value(ADC_CHANNEL_3);

	}		
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
