/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : main.c                                         	      *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-8                                             *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This is a template project used by ADC continuous trig*
 *   					DMA.			  									  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-08 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/

/******************************************************************************
**                      		Include Files                                **
******************************************************************************/
#include "system_init.h"
#include "User_ADC.h"
#include "Usart.h"
#include "Usart_Config.h"
/* Private variables *********************************************************/
ADC_InitTypeDef ADC_InitStructure;
volatile uint16_t adc_Pd5_value;
volatile uint8_t adc_flag=0;
uint8_t adc_data_HL[2]={1,2};
/**
 *  @brief : software Delay.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Delay(volatile uint32_t cnt)
{
	while(cnt--);
}

/******************************************************************************
**                     			main Functions 		             	     	 **
******************************************************************************/
int main()
{

	/*initialize system clock ,defaut SCLK is  120M,select INTHF as Clock
	 **source*****************************************************************/
	SystemInit(120);
	/* Setup SysTick Timer as delay function *********************************/
	systick_delay_init(120);
	GPIOInit_Output_Config(GPIOD_SFR,GPIO_PIN_MASK_7);

	Usart_Gpio_Init();
	/* Set Usart Working Mode  ***********************************************/
	USART_Mode_Config(USART0_SFR);
	/*ADC0 DMA0 Chanel configuration******************************************/
	ADC0_Chanel_DMA_Init();
	
	/*ADC0 module configuration***********************************************/
	adc_GPIO_init();
	/*reset ADC0 module,enable ADC0 clock source******************************/
	ADC_Reset (ADC0_SFR);
	ADC_Struct_Init(&ADC_InitStructure);
	/*select HFCLK as the ADC0 sampling clock source***************************
	**You can also select SCLK or LFCLK as the ADC0 sampling clock************/
	ADC_InitStructure.m_Clock=ADC_HFCLK;
	/*ADC sampling clock Divider configuration********************************/
	ADC_InitStructure.m_ClockDiv = ADC_CLK_DIV_32;
	/*disable adc scan mode***************************************************/
	ADC_InitStructure.m_ScanMode = FALSE;
	/*select continuous mode as adc vonversion mode **************************/
	ADC_InitStructure.m_ContinuousMode = ADC_SINGLE_MODE;
	/*Right-aligned sampling result data *************************************/
	ADC_InitStructure.m_DataAlign = ADC_DATAALIGN_RIGHT;
	/*disable External trigger************************************************/
	ADC_InitStructure.m_ExternalTrig_EN = FALSE;
	/*select Vdd as ADC refrence voltage**************************************/
	ADC_InitStructure.m_VoltageRef = ADC_REF_AVDD;
	ADC_Configuration (ADC0_SFR, &ADC_InitStructure);
	ADC_Cmd (ADC0_SFR, TRUE);
	Delay(0xff);
	/*sampling adc data of GPIO PD5 ******************************************/
	ADC_Regular_Channel_Config(ADC0_SFR,ADC_CHANNEL_3,01);
	/*Enable normal channel DMA memory access mode.***************************/
	ADC_Regular_Channel_DMA_Cmd(ADC0_SFR,TRUE);
	/*Configure DMA0 chanel 5 trig interrupt mode*****************************/
	Config_DMA_interrupt();
	/*enable all interrupt****************************************************/
	INT_All_Enable (TRUE);
	/*software trig adc Conversion,In continuous conversion mode,only need to
	trig for the first time***************************************************/
	ADC_Software_Start_Conv(ADC0_SFR);
	while(1)
	{
			if(adc_flag)
			{
				adc_flag=0;
				ADC_Software_Start_Conv(ADC0_SFR);
				adc_data_HL[1]=adc_buf[0]&0xff;
				USART_SendData(USART0_SFR, adc_data_HL[1]);
				adc_data_HL[0]=(adc_buf[0]>>8)&0xff;
				USART_SendData(USART0_SFR, adc_data_HL[0]);
				systick_delay_ms(1000);
			}

	}		
}

/**
 *  @brief : Reports the name of the source file and the source line number
 *           where the assert_param error has occurred.
 *  @param in :	file pointer to the source file name
 * 	@param in :	line assert_param error line source number
 *  @param out :None
 *  @retval :None
 */
void check_failed(uint8_t* File, uint32_t Line)
{
	/* User can add his own implementation to report the file name and line number,
		ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	/* Infinite loop */
	while(1)
	{
		;
	}
};
