/******************************************************************************
 *                  Shanghai ChipON Micro-Electronic Co.,Ltd                  *
 ******************************************************************************
 *  $File Name$       : User_ADC.c                                        	  *
 *  $Author$          : ChipON AE/FAE Group                                   *
 *  $Data$            : 2021-07-12                                            *
 *  $AutoSAR Version  : V1.0	                                              *
 *  $Description$     : This fiel provides template for continuous conversion *
 						mode of ADC0 depend on DMA0 chanel 5.         		  *
 ******************************************************************************
 *  Copyright (C) by Shanghai ChipON Micro-Electronic Co.,Ltd                 *
 *  All rights reserved.                                                      *
 *                                                                            *
 *  This software is copyrght protected and proprietary to                    *
 *  Shanghai ChipON Micro-Electronic Co.,Ltd.                                 *
 ******************************************************************************
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *                     		REVISON HISTORY                               	  *
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  Data       Version  Author        Description                             *
 *  ~~~~~~~~~~ ~~~~~~~~ ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  *
 *  2021-07-12 00.01.00 FAE Group     new creat                               *
 *                                                                            *
 *                                                                            *
 *****************************************************************************/


#include "system_init.h"
#include "User_ADC.h"

/*******************************************************************************
**                      	Public Variables Definitions                  	  **
*******************************************************************************/
unsigned int adc_buf[32] ={0};
uint16_t adc_value0[16] ={0};
uint16_t adc_value1[16] ={0};

/*******************************************************************************
**                      	Global Functions 		             	      	  **
*******************************************************************************/
/**
 *  @brief : configuration adc GPIO.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void adc_GPIO_init(void)
{
	GPIO_Write_Mode_Bits(GPIOD_SFR,GPIO_PIN_MASK_5,GPIO_MODE_AN);
}

/**
 *  @brief : initialize DMA chanel for adc0.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void ADC0_Chanel_DMA_Init(void)
{
	DMA_InitTypeDef dmaNewStruct;
	/*************************************************************************/
	/*reset DMA0 moduel*******************************************************/
	DMA_Reset (DMA0_SFR);
	/* Transfer 32 bytes at a time through the DMA0 channel 5*****************/
	dmaNewStruct.m_Number = 32;
	/*DMATransmission directionperipheral to memory*************************/
	dmaNewStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;
	/*select low Priority for DMA0 chanel*************************************/
	dmaNewStruct.m_Priority = DMA_CHANNEL_LOWER;
	/* Set Peripheral data size32bits***************************************/
	dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_32_BITS;
	/* Set Memory data size32bits ******************************************/
	dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_32_BITS;
	/* Disable Peripheral address increment mode in oder to read only ADC0_DATA
	register  ****************************************************************/
	dmaNewStruct.m_PeripheralInc = FALSE;
	/* Enable memory address increment mode in oder to write adc_buf**********/
	dmaNewStruct.m_MemoryInc = TRUE;
	/* Enable DMA0 chanel 5 because of ADC0 corresponds to DMA0 chanel 5 *****/
	dmaNewStruct.m_Channel = DMA_CHANNEL_5;
	/*Adc trigger once to DMA transmit once***********************************/
	dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;
	/* Enable loop mode*******************************************************/
	dmaNewStruct.m_LoopMode = TRUE;
	/* used ADC0_DATA register as the DMA0 peripheral address*****************/
	dmaNewStruct.m_PeriphAddr = (uint32_t) &ADC0_DATA; 
	/* used adc_buf as the DMA0 memory start address**************************/
	dmaNewStruct.m_MemoryAddr = (uint32_t) adc_buf;
	/* configure DMA0 through dmaNewStruct************************************/
	DMA_Configuration (DMA0_SFR, &dmaNewStruct);
	/* enable DMA0 chanel 5************************************************* */
	DMA_Channel_Enable (DMA0_SFR, DMA_CHANNEL_5, TRUE);
}
/**
 *  @brief :Configure DMA0 chanel 5 trig interrupt mode.
 *  @param in :	None
 *  @param out :None
 *  @retval :None
 */
void Config_DMA_interrupt(void)
{
	/*enable DMA0 chanel 5 transferred half of data to interrupt************/
	DMA_Set_INT_Enable(DMA0_SFR, DMA_CHANNEL_5, DMA_INT_HALF_TRANSFER,TRUE);
	/*clear DMA0 chanel 5 transferred half of data IRQ *********************/
	DMA_Clear_INT_Flag(DMA0_SFR, DMA_CHANNEL_5, DMA_INT_HALF_TRANSFER);

	/*enable DMA0 chanel 5 transferred all of data to interrupt*************/
	DMA_Set_INT_Enable(DMA0_SFR, DMA_CHANNEL_5, DMA_INT_FINISH_TRANSFER,TRUE); 
	/*clear DMA0 chanel 5 transferred all of data IRQ **********************/
	DMA_Clear_INT_Flag(DMA0_SFR, DMA_CHANNEL_5, DMA_INT_FINISH_TRANSFER);

	/*Preempt priority:4;Subpriority:0**************************************/
	INT_Interrupt_Priority_Config(INT_DMA0,4,0);
	/*enable DMA0 interrupt*************************************************/
	INT_Interrupt_Enable(INT_DMA0,TRUE);
	/*clear DMA0 IRQ flag***************************************************/
	INT_Clear_Interrupt_Flag(INT_DMA0);
}

/**
 *  @brief :GPIO initialize.
 *  @param in :	GPIOx : IO grop
 			    GpioPin:IO Pin
 *  @param out :None
 *  @retval :None
 */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);
	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_RESET);

}
