/**
  ******************************************************************************
  * ļ  kf32l_basic_rst.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ˸λģ(RST)蹦ܺ
  *          + λģ(RST)ú
  *
  *********************************************************************
  */

#include "kf32l_basic_rst.h"


/**
  *   ##### λģ(RST)ú #####
  */
/**
  *   RST_CTL0Ƶ踴λ״̬
  *   RST_CTL0_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL0_GPIOARST: GPIOAλ
  *                       RST_CTL0_GPIOBRST: GPIOBλ
  *                       RST_CTL0_GPIOCRST: GPIOCλ
  *                       RST_CTL0_GPIODRST: GPIODλ
  *                       RST_CTL0_GPIOERST: GPIOEλ
  *                       RST_CTL0_GPIOFRST: GPIOFλ
  *                       RST_CTL0_GPIOGRST: GPIOGλ
  *                       RST_CTL0_GPIOHRST: GPIOHλ
  *                       RST_CTL0_GPIOIRST: GPIOIλ
  *       NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
RST_CTL0_Peripheral_Reset_Enable (uint32_t RST_CTL0_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RST_CTL0_RESET_PERIPH(RST_CTL0_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        RST_CTL0 |= RST_CTL0_bit;
    }
    else
    {
        RST_CTL0 &= ~RST_CTL0_bit;
    }
}

/**
  *   RST_CTL1Ƶ踴λ״̬
  *   RST_CTL1_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL1_QEI1RST: QEI1λ
  *                       RST_CTL1_T1RST: T1λ
  *                       RST_CTL1_T2RST: T2λ
  *                       RST_CTL1_T3RST: T3λ
  *                       RST_CTL1_T4RST: T4λ
  *                       RST_CTL1_T5T6RST: T5T6λ
  *                       RST_CTL1_T9T10RST: T9T10λ
  *                       RST_CTL1_QEI0RST: QEI0λ
  *                       RST_CTL1_ADC0RST: ADC0λ
  *                       RST_CTL1_ADC1RST: ADC1λ
  *                       RST_CTL1_ADC2RST: ADC2λ
  *                       RST_CTL1_DAC0RST: DAC0λ
  *                       RST_CTL1_DAC1RST: DAC1λ
  *                       RST_CTL1_CMPRST: CMPλ
  *                       RST_CTL1_T0RST: T0λ
  *                       RST_CTL1_CTOUCHRST: CTOUCHλ
  *                       RST_CTL1_USART0RST: USART0λ
  *                       RST_CTL1_USART1RST: USART1λ
  *                       RST_CTL1_USART2RST: USART2λ
  *                       RST_CTL1_USART3RST: USART3λ
  *                       RST_CTL1_USART4RST: USART4λ
  *                       RST_CTL1_SPI0RST: SPI0λ
  *                       RST_CTL1_SPI1RST: SPI1λ
  *                       RST_CTL1_I2C0RST: I2C0λ
  *                       RST_CTL1_I2C1RST: I2C1λ
  *                       RST_CTL1_I2C2RST: I2C2λ
  *                       RST_CTL1_LCDRST: LCDλ
  *                       RST_CTL1_USBRST: USBλ
  *       NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
RST_CTL1_Peripheral_Reset_Enable (uint32_t RST_CTL1_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RST_CTL1_RESET_PERIPH(RST_CTL1_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        RST_CTL1 |= RST_CTL1_bit;
    }
    else
    {
        RST_CTL1 &= ~RST_CTL1_bit;
    }
}

/**
  *   RST_CTL2Ƶ踴λ״̬
  *   RST_CTL2_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL2_CAN0RST: CAN0λ
  *                       RST_CTL2_CAN1RST: CAN1λ
  *                       RST_CTL2_WWDTRST: WWDTλ
  *                       RST_CTL2_DMA0RST: DMA0λ
  *                       RST_CTL2_DMA1RST: DMA1λ
  *                       RST_CTL2_T14RST: T14λ
  *                       RST_CTL2_T15RST: T15λ
  *                       RST_CTL2_CAN2RST: CAN2λ
  *                       RST_CTL2_CAN3RST: CAN3λ
  *                       RST_CTL2_T18RST: T18λ
  *                       RST_CTL2_T19RST: T19λ
  *                       RST_CTL2_T20RST: T20λ
  *                       RST_CTL2_T21RST: T21λ
  *                       RST_CTL2_T22RST: T22λ
  *                       RST_CTL2_T23RST: T23λ
  *                       RST_CTL2_USART5RST: USART5λ
  *                       RST_CTL2_USART6RST: USART6λ
  *                       RST_CTL2_USART7RST: USART7λ
  *       NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
RST_CTL2_Peripheral_Reset_Enable (uint32_t RST_CTL2_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RST_CTL2_RESET_PERIPH(RST_CTL2_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        RST_CTL2 |= RST_CTL2_bit;
    }
    else
    {
        RST_CTL2 &= ~RST_CTL2_bit;
    }
}

/**
  *   RST_CTL3Ƶ踴λ״̬
  *   RST_CTL3_bit: ָ踴λλ룬ȡֵΪ
  *                       RST_CTL3_SPI2RST: SPI2λ
  *                       RST_CTL3_SPI3RST: SPI3λ
  *                       RST_CTL3_I2C3RST: I2C3λ
  *                       RST_CTL3_CRCRST: CRCλ
  *                       RST_CTL3_AESRST: AESλ
  *                       RST_CTL3_LEDRST: LEDλ
  *                       RST_CTL3_EXICRST: EXICλ
  *                       RST_CTL3_CAN4RST: CAN4λ
  *                       RST_CTL3_CAN5RST: CAN5λ
  *                       RST_CTL3_CFGLRST: CFGLλ
  *                       RST_CTL3_OPRST: OPλ
  *       NewState: 踴λ״̬ȡֵΧΪTRUE  FALSE
  *   ޡ
  */
void
RST_CTL3_Peripheral_Reset_Enable (uint32_t RST_CTL3_bit,
                    FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_RST_CTL3_RESET_PERIPH(RST_CTL3_bit));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    if (NewState != FALSE)
    {
        RST_CTL3 |= RST_CTL3_bit;
    }
    else
    {
        RST_CTL3 &= ~RST_CTL3_bit;
    }
}
/**
  *   ##### λģ(RST)ú #####
  */
