/**
  ******************************************************************************
  * ļ  kf32l_basic_led.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩLEDģ蹦ܺ
  *          + LEDģ蹦ʼ
  *          + LEDģʾ
  *          + LEDģ״̬ȡ
  *
  *********************************************************************
  */
#include "kf32l_basic_led.h"
#include "kf32l_basic_rst.h"
#include "kf32l_basic_pclk.h"

#ifdef KF32L_Periph_led
/**
  *   ##### LEDģ蹦ʼ #####
  */

/* LED_CTL0Ĵʼ */
#define LED_CTL0_INIT_MASK              (LED_CTL0_LEDEN \
                                       | LED_CTL0_LEDBR \
                                       | LED_CTL0_PNS \
                                       | LED_CTL0_CS \
                                       | LED_CTL0_CKS1 \
                                       | LED_CTL0_CKS0 )
/* LED_CTL1Ĵʼ */
#define LED_CTL1_INIT_MASK              (LED_CTL1_SEG16EN \
                                       | LED_CTL1_SEG12EN \
                                       | LED_CTL1_SEG8EN \
                                       | LED_CTL1_CCOMEN \
                                       | LED_CTL1_LUM )

/**
  *   λLED裬ʹʱӡ
  *  :ޡ
  *   ޡ
  */
void
LED_Reset (void)
{
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_LEDRST, TRUE);
	RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_LEDRST, FALSE);
	PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_LEDCLKEN, TRUE);

}

/**
  *   ģתģ(LED)ʼá
  *   LEDx: ָLEDڴṹָ룬ȡֵΪLED0_SFR~LED2_SFR
  *       ledInitStruct: LEDģϢṹָ롣
  *   ޡ
  */
void
LED_Configuration (LED_InitTypeDef* ledInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(ledInitStruct->m_Module_Enable));
    CHECK_RESTRICTION(CHECK_OUTPUT_CONTROL_SEL(ledInitStruct->m_Output_Control_Select));
    CHECK_RESTRICTION(CHECK_WORK_MODE_SEL(ledInitStruct->m_Anodic_Cathodal_Sel));
    CHECK_RESTRICTION(CHECK_LED_CLKSOURCE_SEL(ledInitStruct->m_Source_Clock_Sel));
    CHECK_RESTRICTION(CHECK_CLK_DIVISION_SEL(ledInitStruct->m_Clock_Division));
    CHECK_RESTRICTION(CHECK_CLK_PREDIVISION_SEL(ledInitStruct->m_Clock_PreDivision));

    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(ledInitStruct->m_Output_SEG12_15_Enable));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(ledInitStruct->m_Output_SEG8_11_Enable));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(ledInitStruct->m_Output_SEG0_7_Enable));
    CHECK_RESTRICTION(CHECK_COM_NUMBER_SEL(ledInitStruct->m_COM_Number_Select));
    CHECK_RESTRICTION(CHECK_LUM_SEL(ledInitStruct->m_Lum_Select));

    /*---------------- LED_CTL0Ĵ ----------------*/
    /* ݽṹԱm_Module_EnableLEDENλ */
    /* ݽṹԱm_Output_Control_SelectLEDBRλ */
    /* ݽṹԱm_Anodic_Cathodal_SelPNSλ */
    /* ݽṹԱm_Source_Clock_SelCSλ */
    /* ݽṹԱm_Clock_DivisionCKS1λ */
    /* ݽṹԱm_Clock_PreDivisionCKS0λ */
    tmpreg = (uint32_t) ((uint32_t)(ledInitStruct->m_Module_Enable << LED_CTL0_LEDEN_POS) | \
                        (ledInitStruct->m_Output_Control_Select) | \
                        (ledInitStruct->m_Anodic_Cathodal_Sel) | \
                        (ledInitStruct->m_Source_Clock_Sel ) | \
                        (ledInitStruct->m_Clock_Division) | \
                        (ledInitStruct->m_Clock_PreDivision)
                        );
    LED_SFR->CTL0 = SFR_Config (LED_SFR->CTL0, ~LED_CTL0_INIT_MASK, tmpreg);

    /*---------------- LED_CTL1Ĵ ----------------*/
    /* ݽṹԱm_Output_SEG12_15_EnableSEG16ENλ */
    /* ݽṹԱm_Output_SEG8_11_EnableSEG12ENλ */
    /* ݽṹԱm_Output_SEG0_7_EnableSEG8ENλ */
    /* ݽṹԱm_COM_Number_SelectCOMENλ */
    /* ݽṹԱm_Lum_SelectLUMλ */
    tmpreg = (uint32_t)(((uint32_t)ledInitStruct->m_Output_SEG12_15_Enable << LED_CTL1_SEG16EN_POS) | \
                         ((uint32_t)ledInitStruct->m_Output_SEG8_11_Enable << LED_CTL1_SEG12EN_POS) | \
                         ((uint32_t)ledInitStruct->m_Output_SEG0_7_Enable << LED_CTL1_SEG8EN_POS) | \
                         ledInitStruct->m_COM_Number_Select | \
                         ledInitStruct->m_Lum_Select);
    LED_SFR->CTL1 = SFR_Config (LED_SFR->CTL1, ~LED_CTL1_INIT_MASK, tmpreg);

}

/**
  *   ʼLEDϢṹ塣
  *   LEDInitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
LED_Struct_Init (LED_InitTypeDef* LEDInitStruct)
{
    /* ʼLEDʾʹѡ */
    LEDInitStruct->m_Module_Enable = FALSE;
    /* ʼLEDѡ */
    LEDInitStruct->m_Output_Control_Select = LEDSEG_OUTPUT_DISABLE;
    /* ʼLEDѡ */
    LEDInitStruct->m_Anodic_Cathodal_Sel = LED_CATHODAL_DIRECT_MODE;
    /* ʼLEDʱԴѡ */
    LEDInitStruct->m_Source_Clock_Sel = LED_CLKSOURCE_HFCLK;
    /* ʼLEDʱԴƵѡ */
    LEDInitStruct->m_Clock_Division = LED_CLK_DIVISION_2;
    /* ʼLEDԤƵѡ */
    LEDInitStruct->m_Clock_PreDivision = LED_CLK_PREDIVISION_16;
    /* ʼLEDͨSEG<15:12>ʹ */
    LEDInitStruct->m_Output_SEG12_15_Enable = FALSE;
    /* ʼ LEDͨSEG<11:8>ʹ */
    LEDInitStruct->m_Output_SEG8_11_Enable = FALSE;
    /* ʼLEDͨSEG<7:0>ʹ */
    LEDInitStruct->m_Output_SEG0_7_Enable = FALSE;
    /* ʼLED COM ʹѡ */
    LEDInitStruct->m_COM_Number_Select = LED_COM_NUM_1;
    /* ʼLED COM Զȵѡ */
    LEDInitStruct->m_Lum_Select = LED_COM_LUM_1;

}

/**
  *   ȡLEDʾ֡־
  *  :
  *   жӦ״̬11ɨ裬0δɨ衣
  */
INTStatus
LED_Get_Frame_Flag (void)
{

    uint32_t tmpreg = 0;

    /*------------- ȡLED_CTL1Ĵ  FRAMEFλ-------------*/
    tmpreg = LED_SFR->CTL1;
    tmpreg = (tmpreg & 0x01 );

    /* жʹܺͱ־ */
    if (tmpreg)
    {
        /*  LED1ɨ裨1֡ */
        return SET;
    }
    else
    {
        /* LEDδɨ */
        return RESET;
    }
}
/**
  *   ȡʾݡ
  *  :DATAx, (LED_DATA0-LED_DATA7)
  *  ʾݣ16λЧݡ
  */
uint16_t
LED_Display_Data_Value (uint32_t LED_DATAx)
{
    uint32_t tmpreg = 0;

    /*---------------- LED_DATAĴDATAλ ----------------*/
    if(LED_DATAx==LED_DATA0)
    {
    	tmpreg = LED_SFR->DATA0;
    }
    else if(LED_DATAx==LED_DATA1)
    {
    	tmpreg = LED_SFR->DATA1;
    }
    else if(LED_DATAx==LED_DATA2)
    {
    	tmpreg = LED_SFR->DATA2;
    }
    else if(LED_DATAx==LED_DATA3)
    {
    	tmpreg = LED_SFR->DATA3;
    }
    else if(LED_DATAx==LED_DATA4)
    {
    	tmpreg = LED_SFR->DATA4;
    }
    else if(LED_DATAx==LED_DATA5)
    {
    	tmpreg = LED_SFR->DATA5;
    }
    else if(LED_DATAx==LED_DATA6)
    {
    	tmpreg = LED_SFR->DATA6;
    }
    else if(LED_DATAx==LED_DATA7)
    {
    	tmpreg = LED_SFR->DATA7;
    }
    return (uint16_t) tmpreg;
}

/**
  *  : ʾ
  *  : LED_Datax_SelData0-7Ĵ
  * 	   LED_Datax_DataҪдݣȡֵΪ16λ
  * 	   LED_Datax_Maskд룬ȡֵΪ16λ
  * 	   				λӦλȡ1ݣȡ0
  *  
  */
void
LED_SET_Datareg (uint8_t LED_Datax_Sel,uint16_t LED_Datax_Data,uint16_t LED_Datax_Mask)
{
	uint16_t tmpreg;
	/*----------------ǷΪData0-7 ----------------*/
	CHECK_RESTRICTION(CHECK_LED_COM_SEL(LED_Datax_Sel));

	/*----------------дLED_DATAĴDATAλ ----------------*/
	tmpreg = LED_Datax_Data & LED_Datax_Mask;
	switch (LED_Datax_Sel)
	{
	case 0:
		tmpreg |= LED_DATA0 & (~LED_Datax_Mask);
		LED_DATA0 = tmpreg ;
		break;
	case 1:
		tmpreg |= LED_DATA1 & (~LED_Datax_Mask);
		LED_DATA1 = tmpreg ;
		break;
	case 2:
		tmpreg |= LED_DATA2 & (~LED_Datax_Mask);
		LED_DATA2 = tmpreg ;
		break;
	case 3:
		tmpreg |= LED_DATA3 & (~LED_Datax_Mask);
		LED_DATA3 = tmpreg ;
		break;
	case 4:
		tmpreg |= LED_DATA4 & (~LED_Datax_Mask);
		LED_DATA4 = tmpreg ;
		break;
	case 5:
		tmpreg |= LED_DATA5 & (~LED_Datax_Mask);
		LED_DATA5 = tmpreg ;
		break;
	case 6:
		tmpreg |= LED_DATA6 & (~LED_Datax_Mask);
		LED_DATA6 = tmpreg ;
		break;
	case 7:
		tmpreg |= LED_DATA7 & (~LED_Datax_Mask);
		LED_DATA7 = tmpreg ;
		break;
	default:
		break;
	}
}
#endif //KF32L_Periph_led
