/**
  ******************************************************************************
  * ļ  usb.h
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *     ļṩUSBЭеض
  *
  *********************************************************************
  */
#ifndef _USB_H_
#define _USB_H_
#include "system_init.h"
#include "usb_conf.h"
/*˵㻺״̬Ĵַ  22˿ڣ˿˫忪Զ˿24Ĵ*/
#define EP0_OUT_table                      	 ((BDT_ENTRY *) 0x1FFEFC00)
#define EP0_IN_table                       	 ((BDT_ENTRY *) 0x1FFEFC04)
#define EP20_OUT_table                       ((BDT_ENTRY *) 0x1FFEFC18)
#define EP21_OUT_table                       ((BDT_ENTRY *) 0x1FFEFC1C)
#define EP20_IN_table                  	     ((BDT_ENTRY *) 0x1FFEFC20)
#define EP21_IN_table                        ((BDT_ENTRY *) 0x1FFEFC24)

/* ˵㻺ַ*/
#define setup_ADD                      ((uint32_t)0x1FFEFC28)
#define setup                       ((SETUP_PKT *) setup_ADD)
#define ep0_out_buff    ((num *) 0x1FFEFC28)
#define ep0_in_buff    ((num *) 0x1FFEFC30)
#define ep20_out_buff    ((num64 *) 0x1FFEFC38)
#define ep21_out_buff    ((num64 *) 0x1FFEFCB0)
#define ep20_in_buff     ((num64 *) 0x1FFEFD30)
#define ep21_in_buff     ((num64 *) 0x1FFEFDB0)



// ׼
#define GET_STATUS                0x00      // ȡ״̬
#define CLR_FEATURE               0x01      // 
#define SET_FEATURE               0x03      // 
#define SET_ADDRESS               0x05      // õַ
#define GET_DESCRIPTOR            0x06      // ȡ
#define SET_DESCRIPTOR            0x07      // 
#define GET_CONFIG                0x08      // ȡ
#define SET_CONFIG                0x09      // 
#define GET_INTERFACE             0x0a      // ȡýӿ
#define SET_INTERFACE             0x0b      // ýӿ
#define SYNCH_FRAME               0x0c      // ͬ֡

// 
#define DEVICE_DESCRIPTOR         0x01      // 豸
#define CONFIG_DESCRIPTOR         0x02      // 
#define STRING_DESCRIPTOR         0x03      // ַ
#define INTERFACE_DESCRIPTOR      0x04      // ӿ
#define ENDPOINT_DESCRIPTOR       0x05      // ˵
#define REPORT_DESCRIPTOR         0x22      // 

#define SET_IDLE 				  0x0A
#define GET_MAX_LUN  			  0xFE
#define MASS_STORAGE_RESET 		  0xFF
#define COMMAND_STAGE 			  0x00
#define DATA_STAGE   			  0x01
#define STATUS_STAGE  			  0x02

// 
#define EP0_BUFF_SIZE             8
#define EP2_BUFF_SIZE             64
////////////////////////////////////////////////////
#define INQUIRY                   0x12
#define READ_FORMAT_CAPACITIES    0x23
#define READ_CAPACITY             0x25
#define READ_10                   0x28
#define WRITE_10                  0x2A
#define REQUEST_SENSE             0x03
#define TEST_UNIT_READY           0x00

extern void ProcScsiCommand(void);
extern void ProcScsiOutData(void);
///////////////////////////////////////////////////
extern volatile uint8_t in_last;
extern USB_StateTypeDef usbStateStruct;
extern uint8_t CBW[31];
extern volatile uint32_t ByteAddr;
//////scsi.c
/////////////////////////////////////////////////////
extern const uint8_t Dbr[];
extern const uint8_t Fat[];
extern const uint8_t Zeros[];
extern const uint8_t TestFileData[];
extern const uint8_t RootDir[];
//fat.c
extern uint32_t Ep2DataLength;
extern uint8_t * pEp2SendData;
extern uint8_t TransportStage;
extern uint8_t Ep2Buffer[EP2_BUFF_SIZE];
//////////////////////////////////////////////////////
// SETUP ưṹ
typedef union
{
    struct
    {
        unsigned :8;
        unsigned :8;
        uint16_t w_value;
        uint16_t w_index;
        uint16_t w_length;
    };

    struct
    {
        uint8_t bm_request_type;
        uint8_t b_request;
        uint8_t w_value_l;
        uint8_t w_value_h;
        uint8_t w_index_l;
        uint8_t w_index_h;
        uint8_t w_length_l;
        uint8_t w_length_h;
    };

    uint8_t buff[8];

}SETUP_PKT;

// BDT ״̬ṹ
typedef union
{
    struct
    {
        unsigned        :2;
        unsigned BSTALL :1;
        unsigned DTSEN  :1;
        unsigned        :1;
        unsigned        :1;
        unsigned DTS    :1;  //   ͬ
        unsigned        :1;
    };

    struct
    {
        unsigned BC8    :1;
        unsigned BC9    :1;
        unsigned PID    :4;
        unsigned        :1;
        unsigned UOWN   :1;  // BDT Ȩ
    };

    uint8_t val;

}BD_STAT;

// BDT Ŀṹ
typedef union
{
    struct
    {
        BD_STAT STAT;        // BDT ״̬
        uint8_t       CNT;        // ֽڼ
        uint8_t      ADRL;
        uint8_t      ADRH;
    };

    struct
    {
        unsigned :8;
        unsigned :8;
        uint16_t     ADR;         // ַָ
    };

    uint8_t _data[4];

}BDT_ENTRY;

typedef struct
{
	unsigned char shuzu[8];
}num;
typedef struct
{
	unsigned char shuzu[64];
}num64;
/* ƣusb_endp0_send()
 * 
 * ݳ
 * ݵ˵0 
 */
extern uint8_t usb_endp0_send(void);

/* ƣusb_endp0_input()
 * 
 * 
 * ˵0 ݸ
 */
extern void usb_endp0_input(void);

/* ƣusb_endp0_output()
 * 
 * 
 * ˵0 
 */
extern void usb_endp0_output(void);

/* ƣusb_endp0_setup()
 * 
 * 
 * SETUP ư
 */
extern void usb_endp0_setup(void);

/* ƣusb_endp_table_int()
 * 
 * 
 * USB ˵ʼ
 */
extern void usb_endp_table_int(void);

/* ƣusb_module_init()
 * 
 * 
 * USB ģϵʹ
 */
extern void usb_module_init(void);

/* ƣusb_event_poll()
 * 
 * 
 * USB ¼ѯ
 */
extern void usb_event_poll(void);

/* ƣusb_endp2_input()
 * 
 * 
 * ˵2 ݸ
 *  */
extern void usb_endp2_input(void);

/* ƣusb_endp2_read()
 * 
 * 
 * ˵2 ȡ͵
 *  */
extern uint8_t usb_endp2_read(uint8_t len,uint8_t *Buf);

#endif  // _USB_H_
