/**
  ******************************************************************************
  * ļ  usb.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-23
  *   
  *
  *********************************************************************
  */
#include "usb.h"
#include "usb_conf.h"
#include "flash.h"

const  uint8_t *send_dat    = 0;            // ָ
static uint16_t send_len    = 0;            // ݷͳ
static uint8_t usb_addr     = 0;            // USB 豸ַ

const uint8_t MaxLun[]={0};
volatile uint8_t in_last=1;
uint8_t rebuff[FLASH_SECTOR_SIZE];
USB_StateTypeDef usbStateStruct;
uint8_t usb_endp2_read(uint8_t len,uint8_t *Buf)
{
	 uint8_t i=0, j=0;

	 if(usbStateStruct.m_BDPointer==0)
	 {
		 j = EP20_OUT_table->_data[1] ; //ȡݳ

		 if(j>len) //Ҫֽʵʽյ
		 {
			 j = len;  //ָֻĳ
		 }
		 for(i=0;i<j;i++)
		 {
			 *(Buf+i)=ep20_out_buff->shuzu[i];  //FIFOжһֽݣż
		 }

	 }
	 else if(usbStateStruct.m_BDPointer==1)
	 {
		 j = EP21_OUT_table->_data[1] ; //ȡݳ

		 if(j>len) //Ҫֽʵʽյ
		 {
			 j = len;  //ָֻĳ
		 }
		 for(i=0;i<j;i++)
		 {
			 *(Buf+i)=ep21_out_buff->shuzu[i];  //FIFOжһֽݣ
		 }
	 }
	  return j; //ʵʶȡֽ

}



void usb_endp2_output(void)
{
	uint8_t len;
	static uint32_t recunt=0;
	switch(TransportStage)
	{
		case COMMAND_STAGE:

			len=usb_endp2_read(sizeof(CBW),CBW);

				 if(len==31) //յݳ31ֽڣ˵CBW
				 {
				  //CBWǩǷȷǩΪUSBC
				  if((CBW[0]=='U')&&(CBW[1]=='S')&&(CBW[2]=='B')&&(CBW[3]=='C'))
				  {
				   //CBWǩȷSCSI
				   ProcScsiCommand();
				  }
				 }
			break;

		case DATA_STAGE:
			if(CBW[15]==WRITE_10)
			{
				len = usb_endp2_read(EP2_BUFF_SIZE,(rebuff+EP2_BUFF_SIZE*recunt));
				Ep2DataLength -= len;
				recunt++;
				if(recunt ==16)// 1kд
				{
					GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_9);
					recunt=0;
					FLASH_PageWrite(ByteAddr,rebuff);
					ByteAddr+=FLASH_SECTOR_SIZE;
					GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_10);

				}
				if(Ep2DataLength==0)
				{
					recunt=0;

					usb_endp2_directly();
					TransportStage=COMMAND_STAGE;
				}
			}else
			{
				TransportStage=COMMAND_STAGE;
			}

			//SCSI
			break;

		case STATUS_STAGE:

			//ȡ˵2,ֵΪʵʶֽ
			break;
	}
	 if(usbStateStruct.m_BDPointer==0)
		 {
			EP21_OUT_table->ADR        = (uint16_t)(ep21_out_buff);
			EP21_OUT_table->STAT.val = 0;
			EP21_OUT_table->STAT.DTS = 1;
			EP21_OUT_table->_data[1]          = EP2_BUFF_SIZE;
			EP21_OUT_table->STAT.DTSEN   = 1;
			EP21_OUT_table->STAT.UOWN    = 1;

		 }
		 else if(usbStateStruct.m_BDPointer==1)
		 {
			EP20_OUT_table->ADR        = (uint16_t)(ep20_out_buff);
			EP20_OUT_table->STAT.val = 0;
			EP20_OUT_table->STAT.DTS = 0;
			EP20_OUT_table->_data[1]          = EP2_BUFF_SIZE;
			EP20_OUT_table->STAT.DTSEN   = 1;
			EP20_OUT_table->STAT.UOWN    = 1;
		 }

}

void usb_endp2_enable(void)
{
    EP20_OUT_table->ADR        = (uint16_t)(ep20_out_buff);
    EP20_OUT_table->_data[1]        = EP2_BUFF_SIZE;
    EP20_OUT_table->STAT.DTS = 0;
    EP20_OUT_table->STAT.val   = 0;
    EP20_OUT_table->STAT.DTSEN = 1;
    EP20_OUT_table->STAT.UOWN  = 1;           // SIE ӵпȨ

    EP21_OUT_table->ADR        = (uint16_t)(ep21_out_buff);
    EP21_OUT_table->_data[1]        = EP2_BUFF_SIZE;
    EP21_OUT_table->STAT.DTS = 1;
    EP21_OUT_table->STAT.val   = 0;
    EP21_OUT_table->STAT.DTSEN = 1;
    EP21_OUT_table->STAT.UOWN  = 0;           // CPU ӵпȨ

    EP20_IN_table->ADR         = (uint16_t)(ep20_in_buff);
    EP20_IN_table->STAT.val    = 0;           // CPU ӵпȨ

    EP21_IN_table->ADR         = (uint16_t)(ep21_in_buff);
    EP21_IN_table->STAT.val    = 0;           // CPU ӵпȨ

    USB_UEP2 = 0x00000000;
    USB_Endpoint_Handshake_Enable(USB_ENDPOINT_2,TRUE);
    // IN/OUT
	USB_Bidirectional_Endpoint_Enable(USB_ENDPOINT_2,FALSE);
	// ʹܶ˵0 
	USB_Endpoint_Output_Enable(USB_ENDPOINT_2,TRUE);
	// ʹܶ˵0 
	USB_Endpoint_Input_Enable(USB_ENDPOINT_2,TRUE);
}

uint8_t usb_endp0_send(void)
{
    uint8_t i, len;

    // ݳȲܴڶ˵0 
    // ֻܷһλ
    if (send_len > EP0_BUFF_SIZE)
    {
        // ݷ
        len = EP0_BUFF_SIZE;

        // ʣݳ
        send_len = send_len - EP0_BUFF_SIZE;
    }

    // ݳСڻ
    // ͵ݳȵʣ೤
    else
    {
        len = (uint8_t)(send_len & 0xff);

        // ɳ
        send_len = 0;
    }

    // ݸƵ˵0 뻺
    EP0_OUT_table->ADR        = (uint16_t)(ep0_out_buff->shuzu);//?
    EP0_IN_table->ADR         = (uint16_t)(ep0_in_buff->shuzu);//?
    EP0_IN_table->_data[1]      = len;
    EP0_IN_table->STAT.DTSEN    = 1;
    if (EP0_IN_table->STAT.DTS)
     {
         EP0_IN_table->STAT.val  = 0;
         EP0_IN_table->STAT.DTS  = 0;
     }

     else
     {
         EP0_IN_table->STAT.val  = 0;
         EP0_IN_table->STAT.DTS  = 1;
     }
    for (i = 0; i < len; i++)
    {
    	ep0_in_buff->shuzu[i] =*send_dat++;
    }

    return len;
}

void usb_endp0_input(void)
{
    uint8_t len;


    // д˵0 
    len   = usb_endp0_send();

    // USB 豸Эַ
    USB_UADDR = usb_addr;

    // ö˵0 
    EP0_IN_table->_data[1]      = len;
    EP0_IN_table->STAT.DTSEN    = 1;
    EP0_IN_table->STAT.UOWN     = 1;

}

void usb_endp0_output(void)
{
	EP0_OUT_table->ADR        = (uint16_t)(ep0_out_buff->shuzu);//?
    // ö˵0 
    if (EP0_OUT_table->STAT.DTS)
    {
        EP0_OUT_table->STAT.val = 0;
        EP0_OUT_table->STAT.DTS = 0;
    }

    else
    {
        EP0_OUT_table->STAT.val = 0;
        EP0_OUT_table->STAT.DTS = 1;
    }

    EP0_OUT_table->_data[1]          = EP0_BUFF_SIZE;
    EP0_OUT_table->STAT.DTSEN   = 1;
    EP0_OUT_table->STAT.UOWN    = 1;
}

void usb_endp0_setup(void)
{
    uint8_t len;

    switch (setup->b_request)
    {
        // ȡ
        case GET_DESCRIPTOR:

            // w_value ָֽ
            switch (setup->w_value_h)
            {
                // ȡ豸
                case DEVICE_DESCRIPTOR:

                    // ݳȴ豸
                    // ֻ豸ȵЧ
                    if (setup->w_length > sizeof(device_descriptor))
                    {
                        send_len = sizeof(device_descriptor);
                    }

                    // ֻݳȵЧ
                    else
                    {
                        send_len = setup->w_length;
                    }

                    // ָ豸ڻַ
                    send_dat = device_descriptor;

                    break;

                // ȡ
                case CONFIG_DESCRIPTOR:

                    // ݳȴ
                    // ֻȵЧ
                    if (setup->w_length > sizeof(configuration_descriptor))
                    {
                        send_len = sizeof(configuration_descriptor);
                    }

                    // ֻݳȵЧ
                    else
                    {
                        send_len = setup->w_length;
                    }

                    // ָڻַ
                    send_dat = configuration_descriptor;

                    break;

                // ȡַ
                case STRING_DESCRIPTOR:

                    // w_value ֵַָֽ
                    switch (setup->w_value_l)
                    {
                        // ȡID
                        case 0:

                            // ID ݳ ָ
                            send_len = sizeof(language_id);
                            send_dat = language_id;

                            break;

                        // ȡƷַ
                        case 2:

                            // زƷַ ݳ ָ
                            send_len = sizeof(product_string_descriptor);
                            send_dat = product_string_descriptor;

                            break;

                        // δֵ֪
                        default:

                            // һ㳤ȵݰ
                            send_len = 0;

                            break;
                    }

                    // ݳС
                    // ֻݳȵЧ
                    if (setup->w_length < send_len)
                    {
                        send_len = setup->w_length;
                    }

                    break;

                // ûж
                default:

                    // ˵0 һ㳤ȵݰ
                    send_len = 0;

                    break;
            }

            break;

        case GET_MAX_LUN:

        	send_dat = MaxLun;
        	send_len = 1;

        	break;

        case MASS_STORAGE_RESET:

        	TransportStage = COMMAND_STAGE;
               //һ0ȵݰ
        	send_len = 0;
            break;

        // ַ豸
        case SET_ADDRESS:

            // w_value ĵֵַָֽ
            if (setup->w_value_l)
            {
                usb_addr = setup->w_value_l;
            }

            // ˵0 һ㳤ȵݰ
            send_len = 0;

            break;

        // ø豸
        case SET_CONFIG:

            // ˵0 һ㳤ȵݰ
            send_len = 0;

            break;

        // δ
        default:

            // ˵0 һ㳤ȵݰ
            send_len = 0;

            break;
    }

    // д˵0 
    len = usb_endp0_send();

    // ö˵0 
    EP0_IN_table->ADR         = (uint16_t)(ep0_in_buff->shuzu);
    EP0_IN_table->_data[1]         = len;
    EP0_IN_table->STAT.val   = 0;
    EP0_IN_table->STAT.DTS    = 1;
    EP0_IN_table->STAT.DTSEN  = 1;
    EP0_IN_table->STAT.UOWN   = 1;

    // ö˵0 
    EP0_OUT_table->ADR         = (uint16_t)(ep0_out_buff->shuzu);
    EP0_OUT_table->_data[1]        = EP0_BUFF_SIZE;
    EP0_OUT_table->STAT.val   = 0;
    EP0_OUT_table->STAT.DTS   = 1;
    EP0_OUT_table->STAT.DTSEN = 1;
    EP0_OUT_table->STAT.UOWN  = 1;

   if(setup->b_request==SET_CONFIG)
   {
       // w_value ĵָֽõֵ
       // ֵʹܷ˵
	   if (setup->w_value_l)
	   usb_endp2_enable();

   }
}

void usb_endp_table_int(void)
{

	EP0_OUT_table->ADR        = (uint16_t)(ep0_out_buff->shuzu);
    EP0_OUT_table->STAT.val   = 0;
    EP0_OUT_table->STAT.DTSEN = 1;
    EP0_OUT_table->STAT.UOWN  = 1;           // SIE ӵпȨ
    EP0_OUT_table->_data[1]        = EP0_BUFF_SIZE;

    EP0_IN_table->ADR         = (uint16_t)(ep0_in_buff->shuzu);
    EP0_IN_table->STAT.val    = 0;           // CPU ӵпȨ
    EP0_IN_table->STAT.DTSEN = 1;
	EP0_IN_table->STAT.UOWN  = 0;           // SIE ӵпȨ
	EP0_IN_table->_data[1]        = 8;


    EP20_OUT_table->STAT.val   = 0;
    EP21_OUT_table->STAT.val   = 0;
    EP20_IN_table->STAT.val    = 0;
    EP21_IN_table->STAT.val    = 0;			 // CPU ӵпȨ
//    EP1_OUT_table->STAT.val   = 0;
//    EP1_IN_table->STAT.val    = 0;
}

void usb_module_init(void)
{
    // ˵ʼ
    usb_endp_table_int();
    USB_UCON = 0x00000000;
    // ģʽ
    USB_Speed_Config(USB_FULL_SPEED);
    // ʹ
    USB_On_Chip_Pull_Up_Enable(TRUE);
    USB_UCON |=0x00000003;
    USB_Double_Buffer_Pointer_Enable(TRUE);

    USB_Double_Buffer_Pointer_Enable(FALSE);
    // USB ģʹ
    USB_Cmd(TRUE);
    USB_UDB = 0X00000010;

    USB_UEP0 = 0x00000000;
   	// ʹܶ˵
   	USB_Endpoint_Handshake_Enable(USB_ENDPOINT_0,TRUE);
   	// ʹSETUP ư
   	USB_Bidirectional_Endpoint_Enable(USB_ENDPOINT_0,TRUE);
   	// ʹܶ˵0 
   	USB_Endpoint_Output_Enable(USB_ENDPOINT_0,TRUE);
   	// ʹܶ˵0 
   	USB_Endpoint_Input_Enable(USB_ENDPOINT_0,TRUE);
    // USBжϱ־
    USB_UIR = 0X00000000;
    // λUSBж
    USB_UIE = 0X00000000;
    // λж
    USB_Set_INT_Enable(USB_INT_RESET,TRUE);
}


void usb_event_poll(void)
{


    if (USB_Get_INT_Flag(USB_INT_RESET))                            //USB ߸λ
	{
		while (USB_Get_INT_Flag(USB_INT_TRANSACTION_COMPLETED))  // δ
		{
			USB_Clear_INT_Flag(USB_INT_TRANSACTION_COMPLETED);
		}
		USB_Clear_INT_Flag(USB_INT_RESET);
		USB_UIR  = 0X00000000;           // еĴжϱ־ , USBжϱ־
		USB_UIE = 0X00003F77;            // USBж,жUSBж
		USB_Clear_Package_Transmit_Flag();// SETUP 
		USB_Address_Config(0);            // USB Ĭϵַ
		usb_endp_table_int();              // ˵
		USB_Double_Buffer_Pointer_Enable(TRUE);
		USB_Double_Buffer_Pointer_Enable(FALSE);
		TransportStage=COMMAND_STAGE;
		in_last=1;
	}

    if (USB_Get_INT_Flag(USB_INT_TRANSACTION_COMPLETED))
    {
    	USB_Get_Arrangement_State(&usbStateStruct);
        switch ( usbStateStruct.m_EndPoint)
        {
            case 0:
                if (usbStateStruct.m_BDDirection)
                {
                    usb_endp0_input();      // ˵0 

                }

                else if (USB_Get_Package_Transmit_Flag())
                {
                	USB_Clear_Package_Transmit_Flag();    // SETUP 
                    usb_endp0_setup();      //   SETUP ư

                }

                else
                {
                    usb_endp0_output();     // ˵0 
                }

                break;

            case 2:
                if (usbStateStruct.m_BDDirection)
                {
                	usb_endp2_input();      // ˵2 
                }

                else
                {
                    usb_endp2_output();     // ˵2 
                }

                break;
            default:
            	break;
        }

        USB_Clear_INT_Flag(USB_INT_TRANSACTION_COMPLETED);

    }
    if(USB_Get_INT_Flag(USB_INT_IDLE) && USB_Get_INT_Enable(USB_INT_IDLE))  // ߿жϣUSBҪ
     {

    	USB_Get_INT_Enable(USB_INT_BUS_ACTIVE);// ʹ߻ж

    	USB_Clear_INT_Flag(USB_INT_IDLE);      // ߿жϱ־

//        USB_Suspend_Enable(TRUE);              // USB

     }

	if(USB_Get_INT_Flag(USB_INT_BUS_ACTIVE) && USB_Get_INT_Enable(USB_INT_BUS_ACTIVE)) //USBӹл,߻ж
	 {

	    USB_Suspend_Enable(FALSE);					//USBģ˳״̬״̬

	    USB_Set_INT_Enable(USB_INT_BUS_ACTIVE,FALSE);//־ֹ߻ж
	    USB_Clear_INT_Flag(USB_INT_BUS_ACTIVE);
	 }
}
